/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseClassEvent;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.RelatedCourseInfoDAO;

@Entity
@DiscriminatorValue(value="0")
public class ClassEvent
extends BaseClassEvent {
    private static final long serialVersionUID = 1L;

    public ClassEvent() {
    }

    public ClassEvent(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    @Transient
    public Set<Student> getStudents() {
        HashSet<Student> students = new HashSet<Student>();
        Iterator<StudentClassEnrollment> i = this.getClazz().getStudentEnrollments().iterator();
        while (i.hasNext()) {
            students.add(i.next().getStudent());
        }
        return students;
    }

    @Override
    @Transient
    public Collection<Long> getStudentIds() {
        return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e where e.clazz.uniqueId = :classId", Long.class).setParameter("classId", (Object)this.getClazz().getUniqueId()).setCacheable(true).list();
    }

    @Override
    @Transient
    public Set<DepartmentalInstructor> getInstructors() {
        HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
        for (ClassInstructor ci : this.getClazz().getClassInstructors()) {
            if (!ci.isLead().booleanValue()) continue;
            instructors.add(ci.getInstructor());
        }
        return instructors;
    }

    @Override
    @Transient
    public int getEventType() {
        return 0;
    }

    @Override
    @Transient
    public Session getSession() {
        return this.getClazz().getSession();
    }

    @Override
    @Transient
    public Collection<StudentClassEnrollment> getStudentClassEnrollments() {
        return ClassEventDAO.getInstance().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.uniqueId = :classId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student", StudentClassEnrollment.class).setParameter("classId", (Object)this.getClazz().getUniqueId()).list();
    }
}

