/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.base.BaseApplicationConfig;
import org.unitime.timetable.model.dao.ApplicationConfigDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="application_config")
public class ApplicationConfig
extends BaseApplicationConfig {
    private static final long serialVersionUID = 1L;
    public static final String APP_CFG_ATTR_NAME = "appConfig";

    public ApplicationConfig() {
    }

    public ApplicationConfig(String key) {
        super(key);
    }

    public static ApplicationConfig getConfig(String key) {
        return (ApplicationConfig)ApplicationConfigDAO.getInstance().getSession().createQuery("from ApplicationConfig where key = :key", ApplicationConfig.class).setParameter("key", (Object)key).setCacheable(true).uniqueResult();
    }

    public static String getConfigValue(String key, String defaultValue) {
        if (!HibernateUtil.isConfigured()) {
            return defaultValue;
        }
        String value = (String)ApplicationConfigDAO.getInstance().getSession().createQuery("select c.value from ApplicationConfig c where c.key=:key", String.class).setParameter("key", (Object)key).setCacheable(true).uniqueResult();
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties toProperties() {
        Properties properties = new Properties();
        if (!HibernateUtil.isConfigured()) {
            return properties;
        }
        try (Session hibSession = ApplicationConfigDAO.getInstance().createNewSession();){
            for (ApplicationConfig appcfg : ApplicationConfigDAO.getInstance().findAll(hibSession)) {
                properties.setProperty(appcfg.getKey(), appcfg.getValue() == null ? "" : appcfg.getValue());
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean configureLogging() {
        if (!HibernateUtil.isConfigured()) {
            return false;
        }
        try (Session hibSession = ApplicationConfigDAO.getInstance().createNewSession();){
            for (ApplicationConfig config : hibSession.createQuery("from ApplicationConfig where key like 'log4j.logger.%'", ApplicationConfig.class).list()) {
                Level level = Level.getLevel((String)config.getValue());
                boolean root = "log4j.logger.root".equals(config.getKey());
                if (root) {
                    Configurator.setRootLevel((Level)level);
                } else {
                    Configurator.setLevel((String)config.getKey().substring("log4j.logger.".length()), (Level)level);
                }
                Debug.info("Logging level for " + (root ? "root" : config.getKey().substring("log4j.logger.".length())) + " set to " + level);
            }
        }
        return true;
    }
}

