/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="academic_classification")
public class AcademicClassification
extends BaseAcademicClassification {
    private static final long serialVersionUID = 1L;
    private static HashMap academicClassifications = new HashMap(40);
    public static final String ACAD_CLASS_REQUEST_ATTR = "academicClassifications";

    public AcademicClassification() {
    }

    public AcademicClassification(Long uniqueId) {
        super(uniqueId);
    }

    public static List<AcademicClassification> getAcademicClassificationList(Long sessionId) {
        return AcademicClassificationDAO.getInstance().getSession().createQuery("select c from AcademicClassification as c where c.session.uniqueId=:sessionId order by c.name", AcademicClassification.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    @Transient
    public String getLabelNameCode() {
        return this.getName() + " - " + this.getCode();
    }

    @Transient
    public String getLabelCodeName() {
        return this.getCode() + " - " + this.getName();
    }

    public static void loadAcademicClassifications(Long sessionId) {
        List<AcademicClassification> acadClasses = AcademicClassification.getAcademicClassificationList(sessionId);
        for (int i = 0; i < acadClasses.size(); ++i) {
            AcademicClassification acadClass = acadClasses.get(i);
            String code = acadClass.getCode();
            academicClassifications.put(code, acadClass);
        }
    }

    public static AcademicClassification getAcademicClassification(String academicClass) {
        return (AcademicClassification)academicClassifications.get(academicClass);
    }

    @Transient
    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public static AcademicClassification findByCode(Long sessionId, String code) {
        return AcademicClassification.findByCode(AcademicClassificationDAO.getInstance().getSession(), sessionId, code);
    }

    public static AcademicClassification findByCode(Session hibSession, Long sessionId, String code) {
        return (AcademicClassification)hibSession.createQuery("select a from AcademicClassification a where a.session.uniqueId=:sessionId and a.code=:code", AcademicClassification.class).setParameter("sessionId", (Object)sessionId).setParameter("code", (Object)code).setCacheable(true).uniqueResult();
    }

    public static AcademicClassification findByExternalId(Long sessionId, String externalId) {
        return AcademicClassification.findByExternalId(AcademicClassificationDAO.getInstance().getSession(), sessionId, externalId);
    }

    public static AcademicClassification findByExternalId(Session hibSession, Long sessionId, String externalId) {
        return (AcademicClassification)hibSession.createQuery("select a from AcademicClassification a where a.session.uniqueId=:sessionId and a.externalUniqueId=:externalUniqueId", AcademicClassification.class).setParameter("sessionId", (Object)sessionId).setParameter("externalUniqueId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        AcademicClassification c = new AcademicClassification();
        c.setExternalUniqueId(this.getExternalUniqueId());
        c.setCode(this.getCode());
        c.setName(this.getName());
        return c;
    }

    public boolean isUsed(Session hibSession) {
        return ((Number)(hibSession == null ? AcademicClassificationDAO.getInstance().getSession() : hibSession).createQuery("select count(c) from CurriculumClassification c inner join c.academicClassification f where f.uniqueId = :clasfId", Number.class).setParameter("clasfId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue() > 0;
    }
}

