/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.shared.EventInterface;

public abstract class ReservationInterface
implements IsSerializable,
Comparable<ReservationInterface>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iId;
    private Offering iOffering;
    private List<Config> iConfigs = new ArrayList<Config>();
    private List<Clazz> iClasses = new ArrayList<Clazz>();
    private Integer iLimit = null;
    private Integer iEnrollment = null;
    private Integer iLastLike = null;
    private Integer iProjection = null;
    private Date iStartDate;
    private Date iExpirationDate;
    private boolean iEditable = false;
    private boolean iExpired = false;
    private boolean iOverride = false;
    private boolean iAlwaysExpired = false;
    private boolean iAllowOverlaps = false;
    private boolean iOverLimit = false;
    private boolean iMustBeUsed = false;
    private Boolean iInclusive = null;

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public void setOffering(Offering offering) {
        this.iOffering = offering;
    }

    public Integer getLimit() {
        return this.iLimit;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    public Integer getReservationLimit() {
        return this.iLimit;
    }

    public Integer getLastLike() {
        return this.iLastLike;
    }

    public void setLastLike(Integer lastLike) {
        this.iLastLike = lastLike;
    }

    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    public Integer getProjection() {
        return this.iProjection;
    }

    public void setProjection(Integer projection) {
        this.iProjection = projection;
    }

    public Date getStartDate() {
        return this.iStartDate;
    }

    public void setStartDate(Date d) {
        this.iStartDate = d;
    }

    public Date getExpirationDate() {
        return this.iExpirationDate;
    }

    public void setExpirationDate(Date d) {
        this.iExpirationDate = d;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public void setExpired(boolean expired) {
        this.iExpired = expired;
    }

    public boolean isExpired() {
        return this.iExpired;
    }

    public boolean isOverride() {
        return this.iOverride;
    }

    public void setOverride(boolean override) {
        this.iOverride = override;
    }

    public boolean isAlwaysExpired() {
        return this.iAlwaysExpired;
    }

    public void setAlwaysExpired(boolean alwaysExpired) {
        this.iAlwaysExpired = alwaysExpired;
    }

    public boolean isAllowOverlaps() {
        return this.iAllowOverlaps;
    }

    public void setAllowOverlaps(boolean allowOverlaps) {
        this.iAllowOverlaps = allowOverlaps;
    }

    public boolean isOverLimit() {
        return this.iOverLimit;
    }

    public void setOverLimit(boolean overLimit) {
        this.iOverLimit = overLimit;
    }

    public boolean isMustBeUsed() {
        return this.iMustBeUsed;
    }

    public void setMustBeUsed(boolean mustBeUsed) {
        this.iMustBeUsed = mustBeUsed;
    }

    public void setInclusive(Boolean inclusive) {
        this.iInclusive = inclusive;
    }

    public boolean hasInclusive() {
        return this.iInclusive != null;
    }

    public Boolean isInclusive() {
        return this.iInclusive;
    }

    public List<Config> getConfigs() {
        return this.iConfigs;
    }

    public List<Clazz> getClasses() {
        return this.iClasses;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ReservationInterface)) {
            return false;
        }
        return this.getId().equals(((ReservationInterface)o).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public abstract int getPriority();

    @Override
    public int compareTo(ReservationInterface r2) {
        int cmp = this.getOffering().getAbbv().compareTo(r2.getOffering().getAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.valueOf(this.getPriority()).compareTo(r2.getPriority());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.toString().compareTo(r2.toString());
        if (cmp != 0) {
            return cmp;
        }
        return this.getId().compareTo(r2.getId());
    }

    public static class Offering
    extends IdName {
        private static final long serialVersionUID = 1L;
        private boolean iOffered = true;
        private boolean iNeedUnlock = false;
        private List<Course> iCourses = new ArrayList<Course>();
        private List<Config> iConfigs = new ArrayList<Config>();

        public List<Course> getCourses() {
            return this.iCourses;
        }

        public List<Config> getConfigs() {
            return this.iConfigs;
        }

        public boolean isOffered() {
            return this.iOffered;
        }

        public void setOffered(boolean offered) {
            this.iOffered = offered;
        }

        public boolean isUnlockNeeded() {
            return this.iNeedUnlock;
        }

        public void setUnlockNeeded(boolean unlockNeeded) {
            this.iNeedUnlock = unlockNeeded;
        }

        public Course getControllingCourse() {
            for (Course course : this.iCourses) {
                if (!course.isControl()) continue;
                return course;
            }
            return null;
        }
    }

    public static class ReservationDefaultExpirationDatesRpcRequest
    implements GwtRpcRequest<DefaultExpirationDates> {
        private Long iSessionId = null;

        public ReservationDefaultExpirationDatesRpcRequest() {
        }

        public ReservationDefaultExpirationDatesRpcRequest(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        @Override
        public String toString() {
            return this.iSessionId == null ? "null" : this.iSessionId.toString();
        }
    }

    public static class DefaultExpirationDates
    implements GwtRpcResponse {
        private Map<String, Date> iExpirations = new HashMap<String, Date>();
        private Map<String, Date> iStartDates = new HashMap<String, Date>();
        private Boolean iInclusive = null;

        public Date getExpirationDate(String type) {
            return this.iExpirations.get(type);
        }

        public boolean hasExpirationDate(String type) {
            return this.getExpirationDate(type) != null;
        }

        public void setExpirationDate(String type, Date date) {
            if (date == null) {
                this.iExpirations.remove(type);
            } else {
                this.iExpirations.put(type, date);
            }
        }

        public Date getStartDate(String type) {
            return this.iStartDates.get(type);
        }

        public boolean hasStartDate(String type) {
            return this.getStartDate(type) != null;
        }

        public void setStartDate(String type, Date date) {
            if (date == null) {
                this.iStartDates.remove(type);
            } else {
                this.iStartDates.put(type, date);
            }
        }

        public void setInclusive(Boolean inclusive) {
            this.iInclusive = inclusive;
        }

        public boolean hasInclusive() {
            return this.iInclusive != null;
        }

        public Boolean isInclusive() {
            return this.iInclusive;
        }

        public String toString() {
            return this.iExpirations.toString();
        }
    }

    public static class ReservationFilterRpcRequest
    extends EventInterface.FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    public static enum OverrideType implements IsSerializable,
    Serializable
    {
        AllowTimeConflict("time-cnflt", false, true, false, true, true),
        AllowOverLimit("closed", false, false, true, true, true),
        AllowOverLimitTimeConflict("time-limit-cnflt", false, true, true, true, true),
        ClassificationOverride("class", false, false, false, true, false),
        CoReqOverride("co-req", false, false, false, true, true, true),
        CohortOverride("cohort", false, false, false, true, false),
        CollegeRestrictionOverride("college", false, false, false, true, false),
        DegreeOverride("degree", false, false, false, true, false),
        DepartmentPermission("dpt-permit", true, false, false, true, false),
        HonorsPermission("honors", false, false, false, true, false),
        InstructorPermission("inst-permt", true, false, false, true, false),
        LevelOverride("level", false, false, false, true, false),
        MajorOverride("major", false, false, false, true, false),
        PreReqOverride("pre-req", false, false, false, true, false),
        Program("program", false, false, false, true, false),
        Other("other", false, false, false, true, true),
        AllowOverLimitLink("limit-link", false, false, true, true, true, true),
        AllowTimeConflictLink("time-link", false, true, false, true, true, true),
        AllowOverLimitTimeConflictLink("time-limit-link", false, true, true, true, true, true);

        String iReference;
        boolean iMustBeUsed = false;
        boolean iAllowTimeConflict = false;
        boolean iAllowOverLimit = false;
        boolean iEditable = false;
        Boolean iExpired = false;
        boolean iBreakLinkedSections = false;

        private OverrideType(String reference, boolean mustBeUsed, boolean timeConflict, boolean overLimit, Boolean expired, boolean editable) {
            this.iReference = reference;
            this.iMustBeUsed = mustBeUsed;
            this.iAllowTimeConflict = timeConflict;
            this.iAllowOverLimit = overLimit;
            this.iExpired = expired;
            this.iEditable = editable;
        }

        private OverrideType(String reference, boolean mustBeUsed, boolean timeConflict, boolean overLimit, Boolean expired, boolean editable, boolean breakLinkedSections) {
            this(reference, mustBeUsed, timeConflict, overLimit, expired, editable);
            this.iBreakLinkedSections = breakLinkedSections;
        }

        public String getReference() {
            return this.iReference;
        }

        public boolean isMustBeUsed() {
            return this.iMustBeUsed;
        }

        public boolean isAllowTimeConflict() {
            return this.iAllowTimeConflict;
        }

        public boolean isAllowOverLimit() {
            return this.iAllowOverLimit;
        }

        public Boolean isExpired() {
            return this.iExpired;
        }

        public boolean isCanHaveExpirationDate() {
            return this.iExpired == null;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public boolean isBreakLinkedSections() {
            return this.iBreakLinkedSections;
        }
    }

    public static class Curriculum
    extends IdName {
        private static final long serialVersionUID = 1L;
        private List<IdName> iClassifications = new ArrayList<IdName>();
        private List<IdName> iMajors = new ArrayList<IdName>();
        private IdName iArea = null;
        private Integer iLimit = null;

        public List<IdName> getClassifications() {
            return this.iClassifications;
        }

        public List<IdName> getMajors() {
            return this.iMajors;
        }

        public IdName getArea() {
            return this.iArea;
        }

        public void setArea(IdName area) {
            this.iArea = area;
        }

        @Override
        public Integer getLimit() {
            return this.iLimit;
        }

        @Override
        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getArea().toString() + " " + this.getClassifications().toString() + " " + this.getMajors().toString();
        }
    }

    public static class Areas
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<IdName> iAreas = new ArrayList<IdName>();
        private List<IdName> iClassifications = new ArrayList<IdName>();
        private List<IdName> iMajors = new ArrayList<IdName>();
        private List<IdName> iMinors = new ArrayList<IdName>();
        private List<IdName> iConcentrations = new ArrayList<IdName>();

        public List<IdName> getAreas() {
            return this.iAreas;
        }

        public List<IdName> getClassifications() {
            return this.iClassifications;
        }

        public List<IdName> getMajors() {
            return this.iMajors;
        }

        public List<IdName> getMinors() {
            return this.iMinors;
        }

        public List<IdName> getConcentrations() {
            return this.iConcentrations;
        }

        public String toString() {
            return this.getAreas().toString() + " " + this.getClassifications().toString() + " " + this.getMajors().toString();
        }
    }

    public static class Area
    extends IdName {
        private static final long serialVersionUID = 1L;
        private List<IdName> iClassifications = new ArrayList<IdName>();
        private List<IdName> iMajors = new ArrayList<IdName>();
        private List<IdName> iMinors = new ArrayList<IdName>();
        private List<IdName> iConcentrations = new ArrayList<IdName>();

        public List<IdName> getClassifications() {
            return this.iClassifications;
        }

        public List<IdName> getMajors() {
            return this.iMajors;
        }

        public List<IdName> getMinors() {
            return this.iMinors;
        }

        public List<IdName> getConcentrations() {
            return this.iConcentrations;
        }

        public List<IdName> getConcentrations(Long majorId) {
            ArrayList<IdName> ret = new ArrayList<IdName>();
            for (IdName conc : this.getConcentrations()) {
                if (!majorId.equals(conc.getParentId())) continue;
                ret.add(conc);
            }
            return ret;
        }

        public boolean hasConcentrations(Long majorId) {
            if (majorId == null) {
                return false;
            }
            for (IdName conc : this.getConcentrations()) {
                if (!majorId.equals(conc.getParentId())) continue;
                return true;
            }
            return false;
        }

        public IdName getMajor(Long majorId) {
            if (majorId == null) {
                return null;
            }
            for (IdName major : this.getMajors()) {
                if (!major.getId().equals(majorId)) continue;
                return major;
            }
            return null;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.getClassifications().toString() + " " + this.getMajors().toString();
        }
    }

    public static class Clazz
    extends IdName {
        private static final long serialVersionUID = 1L;
        private Subpart iSubpart = null;
        private Long iParentId = null;
        private String iExternalId = null;
        private boolean iCancelled = false;
        private String iTime = null;
        private String iDate = null;
        private String iRoom = null;
        private String iInstructor = null;
        private Integer iEnrollment = null;

        @Override
        public Long getParentId() {
            return this.iParentId;
        }

        @Override
        public void setParentId(Long parentId) {
            this.iParentId = parentId;
        }

        public Subpart getSubpart() {
            return this.iSubpart;
        }

        public void setSubpart(Subpart subpart) {
            this.iSubpart = subpart;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null && !this.iExternalId.isEmpty();
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public boolean isCancelled() {
            return this.iCancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.iCancelled = cancelled;
        }

        public boolean hasTime() {
            return this.iTime != null && !this.iTime.isEmpty();
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public boolean hasDate() {
            return this.iDate != null && !this.iDate.isEmpty();
        }

        public String getDate() {
            return this.iDate;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public boolean hasRoom() {
            return this.iRoom != null && !this.iRoom.isEmpty();
        }

        public String getRoom() {
            return this.iRoom;
        }

        public void setRoom(String room) {
            this.iRoom = room;
        }

        public boolean hasInstructor() {
            return this.iInstructor != null && !this.iInstructor.isEmpty();
        }

        public String getInstructor() {
            return this.iInstructor;
        }

        public void setInstructor(String instructor) {
            this.iInstructor = instructor;
        }

        public Integer getEnrollment() {
            return this.iEnrollment;
        }

        public void setEnrollment(Integer enrollment) {
            this.iEnrollment = enrollment;
        }
    }

    public static class Subpart
    extends IdName {
        private static final long serialVersionUID = 1L;
        private Long iParentId = null;
        private List<Clazz> iClasses = new ArrayList<Clazz>();
        private Config iConfig;

        public Config getConfig() {
            return this.iConfig;
        }

        public void setConfig(Config config) {
            this.iConfig = config;
        }

        public List<Clazz> getClasses() {
            return this.iClasses;
        }

        @Override
        public Long getParentId() {
            return this.iParentId;
        }

        @Override
        public void setParentId(Long parentId) {
            this.iParentId = parentId;
        }

        public Clazz getClazz(Long id) {
            if (id == null) {
                return null;
            }
            for (Clazz clazz : this.iClasses) {
                if (!id.equals(clazz.getId())) continue;
                return clazz;
            }
            return null;
        }
    }

    public static class Config
    extends IdName {
        private static final long serialVersionUID = 1L;
        private List<Subpart> iSubparts = new ArrayList<Subpart>();
        private String iInstructionalMethod = null;

        public List<Subpart> getSubparts() {
            return this.iSubparts;
        }

        public boolean hasInstructionalMethod() {
            return this.iInstructionalMethod != null && !this.iInstructionalMethod.isEmpty();
        }

        public String getInstructionalMethod() {
            return this.iInstructionalMethod;
        }

        public void setInstructionalMethod(String instructionalMethod) {
            this.iInstructionalMethod = instructionalMethod;
        }

        public int getIndent(Subpart subpart) {
            Subpart parent = this.getSubpart(subpart.getParentId());
            return parent == null ? 0 : 1 + this.getIndent(parent);
        }

        public String getIndent(Subpart subpart, String indent) {
            Subpart parent = this.getSubpart(subpart.getParentId());
            return parent == null ? "" : indent + this.getIndent(parent, indent);
        }

        public Subpart getSubpart(Long id) {
            if (id == null) {
                return null;
            }
            for (Subpart subpart : this.iSubparts) {
                if (!id.equals(subpart.getId())) continue;
                return subpart;
            }
            return null;
        }

        public boolean isParent(Subpart a, Subpart b) {
            Subpart parent = this.getSubpart(b.getParentId());
            return parent != null && (a.equals(parent) || this.isParent(a, parent));
        }

        public boolean isParent(Clazz a, Clazz b) {
            Subpart parentSubpart = this.getSubpart(b.getSubpart().getParentId());
            Clazz parent = parentSubpart == null ? null : parentSubpart.getClazz(b.getParentId());
            return parent != null && (a.equals(parent) || this.isParent(a, parent));
        }

        public Clazz getParentClazz(Clazz clazz, Subpart parentSubpart) {
            Subpart subpart = this.getSubpart(clazz.getSubpart().getParentId());
            if (subpart == null) {
                return null;
            }
            Clazz parent = subpart.getClazz(clazz.getParentId());
            if (parent == null) {
                return null;
            }
            if (subpart.equals(parentSubpart)) {
                return parent;
            }
            return this.getParentClazz(parent, parentSubpart);
        }

        public int[] countChildClasses(Subpart parent, Subpart child) {
            HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
            for (Clazz clazz : child.getClasses()) {
                Clazz pc = this.getParentClazz(clazz, parent);
                if (pc == null) continue;
                Integer count = (Integer)counts.get(pc.getId());
                counts.put(pc.getId(), count == null ? 1 : 1 + count);
            }
            int max = 0;
            int min = Integer.MAX_VALUE;
            for (Integer count : counts.values()) {
                if (max < count) {
                    max = count;
                }
                if (min <= count) continue;
                min = count;
            }
            if (min <= max) {
                return new int[]{min, max};
            }
            return null;
        }
    }

    public static class Course
    extends IdName {
        private static final long serialVersionUID = 1L;
        private boolean iControl = true;

        public boolean isControl() {
            return this.iControl;
        }

        public void setControl(boolean control) {
            this.iControl = control;
        }
    }

    public static class IdName
    implements IsSerializable,
    Comparable<IdName>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iAbbv;
        private String iName;
        private Integer iLimit = null;
        private Long iParentId = null;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getAbbv() {
            return this.iAbbv;
        }

        public void setAbbv(String abbv) {
            this.iAbbv = abbv;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }

        public Long getParentId() {
            return this.iParentId;
        }

        public void setParentId(Long id) {
            this.iParentId = id;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof IdName)) {
                return false;
            }
            return this.getId().equals(((IdName)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return ((this.iAbbv == null || this.iAbbv.isEmpty() ? "" : this.iAbbv) + (String)(this.iName == null || this.iName.isEmpty() ? "" : " " + this.iName)).trim();
        }

        @Override
        public int compareTo(IdName other) {
            int cmp = (this.getAbbv() == null ? "" : this.getAbbv()).compareTo(other.getAbbv() == null ? "" : other.getAbbv());
            if (cmp != 0) {
                return cmp;
            }
            cmp = (this.getName() == null ? "" : this.getName()).compareTo(other.getName() == null ? "" : other.getName());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId().compareTo(other.getId());
        }
    }

    public static class UniversalReservation
    extends ReservationInterface {
        private static final long serialVersionUID = 1L;
        private String iFilter;

        public String getFilter() {
            return this.iFilter;
        }

        public void setFilter(String filter) {
            this.iFilter = filter;
        }

        public String toString() {
            return this.getFilter();
        }

        @Override
        public int getPriority() {
            return 350;
        }
    }

    public static class LCReservation
    extends ReservationInterface {
        private static final long serialVersionUID = 1L;
        private IdName iGroup;
        private Course iCourse;

        public IdName getGroup() {
            return this.iGroup;
        }

        public void setGroup(IdName group) {
            this.iGroup = group;
        }

        public Course getCourse() {
            return this.iCourse;
        }

        public void setCourse(Course course) {
            this.iCourse = course;
        }

        public String toString() {
            return this.getCourse() + " " + this.getGroup();
        }

        @Override
        public int getPriority() {
            return 500;
        }
    }

    public static class CurriculumReservation
    extends ReservationInterface {
        private static final long serialVersionUID = 1L;
        private Areas iCurriculum;

        public Areas getCurriculum() {
            return this.iCurriculum;
        }

        public void setCurriculum(Areas curriculum) {
            this.iCurriculum = curriculum;
        }

        public String toString() {
            return this.getCurriculum().toString();
        }

        @Override
        public int getPriority() {
            return 300;
        }
    }

    public static class OverrideReservation
    extends IndividualReservation {
        private static final long serialVersionUID = 1L;
        private List<IdName> iStudents = new ArrayList<IdName>();
        private OverrideType iType = null;

        public OverrideReservation() {
        }

        public OverrideReservation(OverrideType type) {
            this.setType(type);
        }

        @Override
        public List<IdName> getStudents() {
            return this.iStudents;
        }

        @Override
        public Integer getLimit() {
            return this.iStudents.size();
        }

        public OverrideType getType() {
            return this.iType;
        }

        public void setType(OverrideType type) {
            this.iType = type;
        }

        @Override
        public boolean isExpired() {
            return this.getType().isCanHaveExpirationDate() ? super.isExpired() : this.getType().isExpired().booleanValue();
        }

        @Override
        public Date getExpirationDate() {
            return this.getType().isCanHaveExpirationDate() ? super.getExpirationDate() : null;
        }

        @Override
        public Date getStartDate() {
            return this.getType().isCanHaveExpirationDate() ? super.getStartDate() : null;
        }

        @Override
        public int getPriority() {
            return 600 + (this.getType() == null ? 0 : 1 + this.getType().ordinal());
        }
    }

    public static class IndividualReservation
    extends ReservationInterface {
        private static final long serialVersionUID = 1L;
        private List<IdName> iStudents = new ArrayList<IdName>();

        public List<IdName> getStudents() {
            return this.iStudents;
        }

        @Override
        public Integer getLimit() {
            return this.iStudents.size();
        }

        public String toString() {
            Object ret = "";
            for (IdName s : this.iStudents) {
                if (!((String)ret).isEmpty()) {
                    ret = (String)ret + "\n";
                }
                ret = (String)ret + s.getName();
            }
            return ret;
        }

        @Override
        public int getPriority() {
            return this.isOverride() ? 150 : 100;
        }
    }

    public static class GroupReservation
    extends ReservationInterface {
        private static final long serialVersionUID = 1L;
        private IdName iGroup;

        public IdName getGroup() {
            return this.iGroup;
        }

        public void setGroup(IdName group) {
            this.iGroup = group;
        }

        public String toString() {
            return this.getGroup().toString();
        }

        @Override
        public int getPriority() {
            return this.isOverride() ? 250 : 200;
        }
    }

    public static class CourseReservation
    extends ReservationInterface {
        private static final long serialVersionUID = 1L;
        private Course iCourse;

        public Course getCourse() {
            return this.iCourse;
        }

        public void setCourse(Course course) {
            this.iCourse = course;
        }

        @Override
        public Integer getLimit() {
            return this.iCourse == null ? null : this.iCourse.getLimit();
        }

        public String toString() {
            return this.getCourse().toString();
        }

        @Override
        public int getPriority() {
            return 400;
        }
    }
}

