/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.Placement;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.SecurityMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.ReservationServlet;
import org.unitime.timetable.gwt.server.UniTimePrincipal;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.ReservationException;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.gwt.shared.StudentSchedulingPreferencesInterface;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.AdvisorCourseRequestDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseDemandDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.OnlineSectioningLogDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLogger;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorCourseRequestsSubmit;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorCourseRequestsValidate;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.onlinesectioning.basic.CheckCourses;
import org.unitime.timetable.onlinesectioning.basic.CheckEligibility;
import org.unitime.timetable.onlinesectioning.basic.CourseRequestEligibility;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.basic.GetDegreePlans;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.basic.GetStudentPreferences;
import org.unitime.timetable.onlinesectioning.basic.ListClasses;
import org.unitime.timetable.onlinesectioning.basic.ListCourseOfferings;
import org.unitime.timetable.onlinesectioning.basic.ListEnrollments;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseMatcherProvider;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomClassAttendanceProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomCriticalCoursesHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomDegreePlansHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomWaitListValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.RequestStudentUpdates;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationDashboardUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEmailProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentHoldsCheckProvider;
import org.unitime.timetable.onlinesectioning.custom.VariableTitleCourseProvider;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.ComputeSuggestionsAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationCancel;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationChangeGradeModes;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationEligibility;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationRequestVariableTitleCourse;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationRetrieveAll;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationRetrieveGradeModes;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationSubmit;
import org.unitime.timetable.onlinesectioning.specreg.SpecialRegistrationUpdate;
import org.unitime.timetable.onlinesectioning.specreg.WaitListCheckValidation;
import org.unitime.timetable.onlinesectioning.specreg.WaitListSubmitOverrides;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.FindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.FindOnlineSectioningLogAction;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.GetReservationsAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindOnlineSectioningLogAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.updates.ApproveEnrollmentsAction;
import org.unitime.timetable.onlinesectioning.updates.ChangeStudentGroup;
import org.unitime.timetable.onlinesectioning.updates.ChangeStudentPreferences;
import org.unitime.timetable.onlinesectioning.updates.ChangeStudentStatus;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.MassCancelAction;
import org.unitime.timetable.onlinesectioning.updates.RejectEnrollmentsAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.onlinesectioning.updates.SaveStudentRequests;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.authority.OtherAuthority;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.ProxyHolder;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.BatchEnrollStudent;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

@Service(value="sectioning.gwt")
public class SectioningServlet
implements SectioningService,
DisposableBean {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private static SecurityMessages SEC_MSG = Localization.create(SecurityMessages.class);
    private static Log sLog = LogFactory.getLog(SectioningServlet.class);
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private SessionContext sessionContext;
    @Autowired
    private SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    private SolverServerService solverServerService;

    private CourseDetailsProvider getCourseDetailsProvider() {
        return (CourseDetailsProvider)Customization.CourseDetailsProvider.getProvider();
    }

    private CourseMatcherProvider getCourseMatcherProvider() {
        return (CourseMatcherProvider)Customization.CourseMatcherProvider.getProvider();
    }

    private ExternalTermProvider getExternalTermProvider() {
        return (ExternalTermProvider)Customization.ExternalTermProvider.getProvider();
    }

    private AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private StudentSolverProxy getStudentSolver() {
        return this.studentSectioningSolverService.getSolver();
    }

    private OnlineSectioningServer getServerInstance(Long academicSessionId, boolean canReturnDummy) {
        if (academicSessionId == null) {
            return null;
        }
        ApplicationProperties.setSessionId(academicSessionId);
        OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(academicSessionId.toString());
        if (server != null || !canReturnDummy) {
            return server;
        }
        SessionAttribute attribute = SessionAttribute.OnlineSchedulingDummyServer;
        ProxyHolder h = (ProxyHolder)this.sessionContext.getAttribute(attribute);
        if (h != null && h.isValid(academicSessionId)) {
            return (OnlineSectioningServer)h.getProxy();
        }
        org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(academicSessionId);
        if (session == null) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        server = new DatabaseServer(new AcademicSessionInfo(session), false);
        this.sessionContext.setAttribute(attribute, new ProxyHolder<Long, OnlineSectioningServer>(academicSessionId, server));
        return server;
    }

    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> listCourseOfferings(OnlineSectioningInterface.StudentSectioningContext cx, CourseRequestInterface.Filter filter, String query, Integer limit) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        int dayOfWeekOffset = 0;
        if (filter != null && filter.hasDates()) {
            Date dpFirstDate = null;
            if (server != null) {
                dpFirstDate = server.getAcademicSession().getDatePatternFirstDate();
                dayOfWeekOffset = server.getAcademicSession().getDayOfWeekOffset();
            } else {
                dpFirstDate = AcademicSessionInfo.getDatePatternFirstDay((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(cx.getSessionId()));
                dayOfWeekOffset = Constants.getDayOfWeek(dpFirstDate);
            }
            if (filter.getClassFrom() != null) {
                filter.setDaysFrom(Days.daysBetween((ReadablePartial)new LocalDate((Object)dpFirstDate), (ReadablePartial)new LocalDate((Object)filter.getClassFrom())).getDays());
            } else {
                filter.setDaysFrom(null);
            }
            if (filter.getClassTo() != null) {
                filter.setDaysTo(Days.daysBetween((ReadablePartial)new LocalDate((Object)dpFirstDate), (ReadablePartial)new LocalDate((Object)filter.getClassTo())).getDays());
            } else {
                filter.setDaysTo(null);
            }
        }
        CourseMatcher matcher = this.getCourseMatcher(cx, server);
        if (server == null || server instanceof DatabaseServer) {
            Student student;
            Session hibSession = CurriculumDAO.getInstance().getSession();
            if (query != null && !query.isEmpty() && CustomCourseLookupHolder.hasProvider()) {
                try {
                    List<CourseOffering> courses = CustomCourseLookupHolder.getProvider().getCourses(new AcademicSessionInfo((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(cx.getSessionId(), hibSession)), hibSession, query, true);
                    if (courses != null && !courses.isEmpty()) {
                        ArrayList results = new ArrayList();
                        for (CourseOffering c : courses) {
                            if (!matcher.match(new XCourseId(c)) || !this.matchFilter(filter, c, dayOfWeekOffset)) continue;
                            ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                            course.setCourseId(c.getUniqueId());
                            course.setSubject(c.getSubjectAreaAbbv());
                            course.setCourseNbr(c.getCourseNbr());
                            course.setTitle(c.getTitle());
                            course.setNote(c.getScheduleBookNote());
                            if (c.getCredit() != null) {
                                course.setCreditText(c.getCredit().creditText());
                                course.setCreditAbbv(c.getCredit().creditAbbv());
                            }
                            course.setTitle(c.getTitle());
                            course.setHasUniqueName(true);
                            course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                            course.setCanWaitList(c.getInstructionalOffering().effectiveWaitList());
                            boolean unlimited = false;
                            int courseLimit = 0;
                            int snapshotLimit = 0;
                            for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                                Integer snapshot;
                                if (cfg.isUnlimitedEnrollment().booleanValue()) {
                                    unlimited = true;
                                }
                                if (cfg.getLimit() != null) {
                                    courseLimit += cfg.getLimit().intValue();
                                }
                                if ((snapshot = cfg.getSnapShotLimit()) == null) continue;
                                snapshotLimit += snapshot.intValue();
                            }
                            if (c.getReservation() != null) {
                                courseLimit = c.getReservation();
                            }
                            if (courseLimit >= 9999) {
                                unlimited = true;
                            }
                            course.setLimit(unlimited ? -1 : courseLimit);
                            course.setSnapShotLimit(snapshotLimit);
                            course.setProjected(c.getProjectedDemand());
                            course.setEnrollment(c.getEnrollment());
                            course.setLastLike(c.getDemand());
                            results.add(course);
                            for (InstrOfferingConfig config : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                                if (config.getEffectiveInstructionalMethod() != null) {
                                    course.addInstructionalMethod(config.getEffectiveInstructionalMethod().getUniqueId(), config.getEffectiveInstructionalMethod().getLabel());
                                    continue;
                                }
                                course.setHasNoInstructionalMethod(true);
                            }
                        }
                        if (!results.isEmpty()) {
                            ListCourseOfferings.setSelection(results);
                            return results;
                        }
                    }
                }
                catch (Exception e) {
                    sLog.error((Object)("Failed to use the custom course lookup: " + e.getMessage()), (Throwable)e);
                }
            }
            Object types = "";
            for (String ref : matcher.getAllowedCourseTypes()) {
                types = (String)types + (((String)types).isEmpty() ? "" : ", ") + "'" + ref + "'";
            }
            if (!matcher.isAllCourseTypes() && !matcher.isNoCourseType() && ((String)types).isEmpty()) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
            }
            List overrides = hibSession.createQuery("from OverrideType order by label", OverrideType.class).setCacheable(true).list();
            StudentSchedulingRule rule = cx.getStudentId() == null ? null : StudentSchedulingRule.getRuleFilter(cx.getStudentId(), server, this.sessionContext);
            boolean excludeNotOffered = ApplicationProperty.CourseRequestsShowNotOffered.isFalse();
            ArrayList<ClassAssignmentInterface.CourseAssignment> results = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
            org.unitime.timetable.onlinesectioning.match.CourseMatcher parent = matcher.getParentCourseMatcher();
            for (CourseOffering c : hibSession.createQuery("select c from CourseOffering c left outer join c.courseType ct where " + (excludeNotOffered ? "c.instructionalOffering.notOffered = false and " : "") + "c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and ((lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) like :q || '%') " + (query.length() > 2 ? "or lower(c.title) like '%' || :q || '%'" : "") + " or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like '% - ' || :q || '%' or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) like '% - ' || :q || '%' or lower(c.courseNbr) like :q || '%') " + (String)(matcher.isAllCourseTypes() ? "" : (matcher.isNoCourseType() ? (((String)types).isEmpty() ? " and ct is null " : " and (ct is null or ct.reference in (" + (String)types + ")) ") : " and ct.reference in (" + (String)types + ") ")) + "order by case when lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' then 0 else 1 end,c.subjectArea.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("q", (Object)query.toLowerCase()).setParameter("sessionId", (Object)cx.getSessionId()).setCacheable(true).setMaxResults(limit == null || limit <= 0 || parent != null ? Integer.MAX_VALUE : limit).list()) {
                if (parent != null && !parent.match(new XCourseId(c)) || !this.matchFilter(filter, c, dayOfWeekOffset)) continue;
                ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                course.setCourseId(c.getUniqueId());
                course.setSubject(c.getSubjectAreaAbbv());
                course.setCourseNbr(c.getCourseNbr());
                course.setTitle(c.getTitle());
                course.setNote(c.getScheduleBookNote());
                if (c.getCredit() != null) {
                    course.setCreditText(c.getCredit().creditText());
                    course.setCreditAbbv(c.getCredit().creditAbbv());
                }
                course.setTitle(c.getTitle());
                course.setHasUniqueName(true);
                course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                course.setCanWaitList(c.getInstructionalOffering().effectiveWaitList());
                if (overrides != null && !overrides.isEmpty()) {
                    for (OverrideType override : overrides) {
                        if (c.getDisabledOverrides().contains(override)) continue;
                        course.addOverride(override.getReference(), override.getLabel());
                    }
                }
                boolean unlimited = false;
                int courseLimit = 0;
                for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (cfg.isUnlimitedEnrollment().booleanValue()) {
                        unlimited = true;
                    }
                    if (cfg.getLimit() == null) continue;
                    courseLimit += cfg.getLimit().intValue();
                }
                if (c.getReservation() != null) {
                    courseLimit = c.getReservation();
                }
                if (courseLimit >= 9999) {
                    unlimited = true;
                }
                course.setLimit(unlimited ? -1 : courseLimit);
                course.setProjected(c.getProjectedDemand());
                course.setEnrollment(c.getEnrollment());
                course.setLastLike(c.getDemand());
                results.add(course);
                for (InstrOfferingConfig config : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    boolean imAvailable = true;
                    if (rule != null) {
                        if (rule.isDisjunctive().booleanValue()) {
                            if (!(rule.hasCourseName() && rule.matchesCourseName(c.getCourseName()) || rule.hasCourseType() && rule.matchesCourseType(c.getCourseType()) || rule.hasInstructionalMethod() && rule.matchesInstructionalMethod(config.getInstructionalMethod()))) {
                                imAvailable = false;
                            }
                        } else if (!rule.matchesInstructionalMethod(config.getInstructionalMethod())) {
                            imAvailable = false;
                        }
                    }
                    if (!imAvailable) continue;
                    if (config.getEffectiveInstructionalMethod() != null) {
                        course.addInstructionalMethod(config.getEffectiveInstructionalMethod().getUniqueId(), config.getEffectiveInstructionalMethod().getLabel());
                        continue;
                    }
                    course.setHasNoInstructionalMethod(true);
                }
                if (parent == null || limit == null || limit <= 0 || results.size() < limit) continue;
                break;
            }
            if (results.isEmpty()) {
                if (filter == null || filter.isEmpty()) {
                    throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
                }
                throw new SectioningException(MSG.exceptionNoCourseMatchingFilter(query));
            }
            if (ApplicationProperty.ListCourseOfferingsMatchingCampusFirst.isTrue() && cx.getStudentId() != null && (student = (Student)StudentDAO.getInstance().get(cx.getStudentId())) != null) {
                String campus;
                StudentAreaClassificationMajor primary = student.getPrimaryAreaClasfMajor();
                String string = campus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
                if (campus != null && !campus.equals(student.getSession().getAcademicInitiative())) {
                    ExternalTermProvider ext = this.getExternalTermProvider();
                    AcademicSessionInfo info = new AcademicSessionInfo((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(cx.getSessionId(), hibSession));
                    ArrayList<ClassAssignmentInterface.CourseAssignment> ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>(results.size());
                    for (ClassAssignmentInterface.CourseAssignment ca : results) {
                        if (ext == null) {
                            if (!ca.getSubject().startsWith(campus + " - ")) continue;
                            ret.add(ca);
                            continue;
                        }
                        if (!campus.equals(ext.getExternalCourseCampus(info, ca.getSubject(), ca.getCourseNbr()))) continue;
                        ret.add(ca);
                    }
                    if (ret.isEmpty()) {
                        return results;
                    }
                    for (ClassAssignmentInterface.CourseAssignment ca : results) {
                        if (ext == null) {
                            if (ca.getSubject().startsWith(campus + " - ")) continue;
                            ret.add(ca);
                            continue;
                        }
                        if (campus.equals(ext.getExternalCourseCampus(info, ca.getSubject(), ca.getCourseNbr()))) continue;
                        ret.add(ca);
                    }
                    return ret;
                }
            }
            return results;
        }
        Collection<ClassAssignmentInterface.CourseAssignment> results = null;
        try {
            results = server.execute(server.createAction(ListCourseOfferings.class).withFilter(filter).forQuery(query).withLimit(limit).withMatcher(matcher).forStudent(cx.getStudentId()), this.currentUser(cx));
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        if (results == null || results.isEmpty()) {
            if (filter == null || filter.isEmpty()) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(query));
            }
            throw new SectioningException(MSG.exceptionNoCourseMatchingFilter(query));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public CourseMatcher getCourseMatcher(OnlineSectioningInterface.StudentSectioningContext cx, OnlineSectioningServer server) {
        noCourseType = true;
        allCourseTypes = false;
        allowedCourseTypes = new HashSet<String>();
        courseIds = null;
        if (this.getSessionContext().hasPermissionOtherAuthority(cx.getSessionId(), Right.StudentSchedulingCanLookupAllCourses, this.getStudentAuthority(cx.getSessionId()))) {
            allCourseTypes = true;
            if (cx.getStudentId() != null) {
                if (server != null && !(server instanceof DatabaseServer)) {
                    courseIds = server.getRequestedCourseIds(cx.getStudentId());
                } else {
                    student = (Student)StudentDAO.getInstance().get(cx.getStudentId());
                    if (student != null) {
                        courseIds = new HashSet<Long>();
                        for (CourseDemand cd : student.getCourseDemands()) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                courseIds.add(cr.getCourseOffering().getUniqueId());
                            }
                        }
                        for (AdvisorCourseRequest acr : student.getAdvisorCourseRequests()) {
                            if (acr.getCourseOffering() == null) continue;
                            courseIds.add(acr.getCourseOffering().getUniqueId());
                        }
                    }
                }
            }
        } else {
            hibSession = SessionDAO.getInstance().createNewSession();
            try {
                student = cx.getStudentId() == null ? null : (Student)StudentDAO.getInstance().get(cx.getStudentId(), hibSession);
                v0 = status = student == null ? null : student.getEffectiveStatus();
                if (status != null) {
                    for (CourseType type : status.getTypes()) {
                        allowedCourseTypes.add(type.getReference());
                    }
                    v1 = noCourseType = status.hasOption(new StudentSectioningStatus.Option[]{StudentSectioningStatus.Option.notype}) == false;
                }
                if (student == null) ** GOTO lbl57
                if (server != null && !(server instanceof DatabaseServer)) {
                    courseIds = server.getRequestedCourseIds(cx.getStudentId());
                }
                courseIds = new HashSet<Long>();
                for (CourseDemand cd : student.getCourseDemands()) {
                    for (CourseRequest cr : cd.getCourseRequests()) {
                        courseIds.add(cr.getCourseOffering().getUniqueId());
                    }
                }
                for (AdvisorCourseRequest acr : student.getAdvisorCourseRequests()) {
                    if (acr.getCourseOffering() == null) continue;
                    courseIds.add(acr.getCourseOffering().getUniqueId());
                }
            }
            finally {
                hibSession.close();
            }
        }
lbl57:
        // 5 sources

        matcher = new CourseMatcher(allCourseTypes, noCourseType, allowedCourseTypes, courseIds);
        if (cx.getStudentId() != null && (provider = this.getCourseMatcherProvider()) != null) {
            matcher.setParentCourseMatcher(provider.getCourseMatcher(server, this.getSessionContext(), cx.getStudentId()));
        }
        return matcher;
    }

    @Override
    public Collection<ClassAssignmentInterface.ClassAssignment> listClasses(OnlineSectioningInterface.StudentSectioningContext cx, String course) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        if (!cx.isOnline()) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(ListClasses.class).forCourseAndStudent(course, cx.getStudentId()), this.currentUser(cx));
        }
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        HashSet<Long> allowedClasses = null;
        if (server == null || server instanceof DatabaseServer) {
            StudentSchedulingRule rule;
            org.unitime.timetable.model.Session session;
            if (!this.sessionContext.hasPermission(Right.HasRole) && (session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(cx.getSessionId())) != null && !session.canNoRoleReportClass()) {
                throw new SectioningException(MSG.exceptionClassScheduleNotAvaiable());
            }
            ArrayList<ClassAssignmentInterface.ClassAssignment> results = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            CourseOffering courseOffering = null;
            Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) = :course)", CourseOffering.class).setParameter("course", (Object)course.toLowerCase()).setParameter("sessionId", (Object)cx.getSessionId()).setCacheable(true).setMaxResults(1).list().iterator();
            if (iterator.hasNext()) {
                CourseOffering c;
                courseOffering = c = (CourseOffering)iterator.next();
            }
            StudentSchedulingRule studentSchedulingRule = rule = cx.getStudentId() == null ? null : StudentSchedulingRule.getRuleFilter(cx.getStudentId(), server, this.sessionContext);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            ArrayList<Class_> classes = new ArrayList<Class_>();
            for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                boolean imAvailable = true;
                if (rule != null) {
                    if (rule.isDisjunctive().booleanValue()) {
                        if (!(rule.hasCourseName() && rule.matchesCourseName(courseOffering.getCourseName()) || rule.hasCourseType() && rule.matchesCourseType(courseOffering.getCourseType()) || rule.hasInstructionalMethod() && rule.matchesInstructionalMethod(config.getInstructionalMethod()))) {
                            imAvailable = false;
                        }
                    } else if (!rule.matchesInstructionalMethod(config.getInstructionalMethod())) {
                        imAvailable = false;
                    }
                }
                if (!imAvailable) continue;
                for (SchedulingSubpart schedulingSubpart : config.getSchedulingSubparts()) {
                    classes.addAll(schedulingSubpart.getClasses());
                }
            }
            Collections.sort(classes, new ClassComparator(5));
            NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
            String datePatternFormat = ApplicationProperty.DatePatternFormatUseDates.valueOfSession(cx.getSessionId());
            for (Class_ clazz : classes) {
                int maxLimit;
                if (!clazz.isEnabledForStudentScheduling().booleanValue()) {
                    if (cx.getStudentId() != null && allowedClasses == null) {
                        allowedClasses = new HashSet<Long>();
                        for (Reservation reservation : courseOffering.getInstructionalOffering().getReservations()) {
                            StudentGroupType type;
                            if (!(reservation instanceof StudentGroupReservation) || (type = ((StudentGroupReservation)reservation).getGroup().getType()) == null || type.getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.WithGroupReservation) continue;
                            boolean hasStudent = false;
                            for (Student student : ((StudentGroupReservation)reservation).getGroup().getStudents()) {
                                if (!student.getUniqueId().equals(cx.getStudentId())) continue;
                                hasStudent = true;
                                break;
                            }
                            if (!hasStudent) continue;
                            for (Class_ c : classes) {
                                if (c.isEnabledForStudentScheduling().booleanValue() || !reservation.isMatching(c)) continue;
                                allowedClasses.add(c.getUniqueId());
                            }
                        }
                        Student student = (Student)StudentDAO.getInstance().get(cx.getStudentId(), hibSession);
                        if (student != null) {
                            for (StudentGroup group : student.getGroups()) {
                                StudentGroupType type = group.getType();
                                if (type == null || type.getAllowDisabledSection() != StudentGroupType.AllowDisabledSection.AlwaysAllowed) continue;
                                for (Class_ c : classes) {
                                    if (c.isEnabledForStudentScheduling().booleanValue()) continue;
                                    allowedClasses.add(c.getUniqueId());
                                }
                            }
                        }
                    }
                    if (allowedClasses == null || !allowedClasses.contains(clazz.getUniqueId())) continue;
                }
                ClassAssignmentInterface.ClassAssignment classAssignment = new ClassAssignmentInterface.ClassAssignment();
                classAssignment.setClassId(clazz.getUniqueId());
                classAssignment.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim());
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                    classAssignment.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                }
                classAssignment.setSection(clazz.getClassSuffix(courseOffering));
                if (classAssignment.getSection() == null) {
                    classAssignment.setSection(clazz.getSectionNumberString(hibSession));
                }
                classAssignment.setExternalId(clazz.getExternalId(courseOffering));
                if (classAssignment.getExternalId() == null) {
                    classAssignment.setExternalId(clazz.getSchedulingSubpart().getItypeDesc().trim() + " " + clazz.getSectionNumberString());
                }
                classAssignment.setClassNumber(clazz.getSectionNumberString(hibSession));
                classAssignment.addNote(clazz.getSchedulePrintNote());
                Assignment assignment = clazz.getCommittedAssignment();
                Placement p = assignment == null ? null : assignment.getPlacement();
                int minLimit = clazz.getExpectedCapacity();
                int limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                if (minLimit < maxLimit && p != null) {
                    int roomLimit = (int)Math.floor((float)p.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                    limit = -1;
                }
                classAssignment.setCancelled(clazz.isCancelled());
                classAssignment.setLimit(new int[]{clazz.getEnrollment() == 0 ? -1 : clazz.getEnrollment(), limit});
                if (p != null && p.getTimeLocation() != null) {
                    for (DayCode d : DayCode.toDayCodes(p.getTimeLocation().getDayCode())) {
                        classAssignment.addDay(d.getIndex());
                    }
                    classAssignment.setStart(p.getTimeLocation().getStartSlot());
                    classAssignment.setLength(p.getTimeLocation().getLength());
                    classAssignment.setBreakTime(p.getTimeLocation().getBreakTime());
                    classAssignment.setDatePattern(XTime.datePatternName(assignment, datePatternFormat));
                }
                if (assignment != null) {
                    for (Location loc : assignment.getRooms()) {
                        classAssignment.addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                    }
                } else {
                    for (RoomPref rp : clazz.effectivePreferences(RoomPref.class)) {
                        if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) continue;
                        classAssignment.addRoom(rp.getRoom().getUniqueId(), rp.getRoom().getLabel());
                    }
                    DatePattern pattern = clazz.effectiveDatePattern();
                    if (pattern != null) {
                        classAssignment.setDatePattern(this.datePatternName(pattern, datePatternFormat));
                    }
                }
                if (!clazz.getClassInstructors().isEmpty()) {
                    for (ClassInstructor instr : clazz.getClassInstructors()) {
                        classAssignment.addInstructor(nameFormat.format(instr.getInstructor()));
                        classAssignment.addInstructoEmail(instr.getInstructor().getEmail());
                    }
                }
                if (clazz.getParentClass() != null) {
                    classAssignment.setParentSection(clazz.getParentClass().getClassSuffix(courseOffering));
                }
                classAssignment.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                if (classAssignment.getParentSection() == null) {
                    classAssignment.setParentSection(courseOffering.getConsentType() == null ? null : courseOffering.getConsentType().getLabel());
                }
                results.add(classAssignment);
            }
            return results;
        }
        try {
            return server.execute(server.createAction(ListClasses.class).forCourseAndStudent(course, cx.getStudentId()), this.currentUser(cx));
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private boolean matchPrimaryCampus(org.unitime.timetable.model.Session session, String primaryCampus) {
        if (primaryCampus == null) {
            return false;
        }
        String preferredCampus = ApplicationProperty.StudentSchedulingPreferredCampus.value(session);
        if (preferredCampus != null && !preferredCampus.isEmpty()) {
            return primaryCampus.matches(preferredCampus);
        }
        return primaryCampus.equals(session.getAcademicInitiative());
    }

    @Override
    public Collection<AcademicSessionProvider.AcademicSessionInfo> listAcademicSessions(boolean sectioning) throws SectioningException, PageAccessException {
        ArrayList<AcademicSessionProvider.AcademicSessionInfo> ret = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
        ExternalTermProvider extTerm = this.getExternalTermProvider();
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        boolean preferStudentCampus = ApplicationProperty.StudentSchedulingPreferStudentCampus.isTrue();
        if (sectioning) {
            for (String s : this.solverServerService.getOnlineStudentSchedulingContainer().getSolvers()) {
                OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(s);
                if (server == null || !server.isReady()) continue;
                org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(Long.valueOf(s));
                AcademicSessionInfo info = server.getAcademicSession();
                String primaryCampus = null;
                if (principal != null) {
                    StudentSectioningStatus status;
                    studentId = principal.getStudentId(session.getUniqueId());
                    if (studentId == null || (student = (Student)StudentDAO.getInstance().get(studentId)) == null) continue;
                    if (preferStudentCampus) {
                        primary = student.getPrimaryAreaClasfMajor();
                        String string = primaryCampus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
                    }
                    if (!((status = student.getEffectiveStatus()) == null || status.hasOption(StudentSectioningStatus.Option.enabled) || this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdmin, new Qualifiable[0]) && status.hasOption(StudentSectioningStatus.Option.admin) || this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdvisor, new Qualifiable[0]) && status.hasOption(StudentSectioningStatus.Option.advisor))) {
                        continue;
                    }
                } else {
                    if (!this.getSessionContext().hasPermissionOtherAuthority(session, Right.SchedulingAssistant, this.getStudentAuthority(session))) continue;
                    if (preferStudentCampus && (studentId = this.getStudentId(session.getUniqueId())) != null) {
                        student = (Student)StudentDAO.getInstance().get(studentId);
                        primary = student == null ? null : student.getPrimaryAreaClasfMajor();
                        primaryCampus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
                    }
                }
                ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info)).setPrimary(preferStudentCampus && this.matchPrimaryCampus(session, primaryCampus)));
            }
        } else {
            for (org.unitime.timetable.model.Session session : SessionDAO.getInstance().findAll()) {
                if (session.getStatusType().isTestSession() || !session.getStatusType().canPreRegisterStudents()) continue;
                AcademicSessionInfo info = new AcademicSessionInfo(session);
                String primaryCampus = null;
                if (principal != null) {
                    StudentSectioningStatus status;
                    studentId = principal.getStudentId(session.getUniqueId());
                    if (studentId == null || (student = (Student)StudentDAO.getInstance().get(studentId)) == null) continue;
                    if (preferStudentCampus) {
                        primary = student.getPrimaryAreaClasfMajor();
                        String string = primaryCampus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
                    }
                    if (!((status = student.getEffectiveStatus()) == null || status.hasOption(StudentSectioningStatus.Option.regenabled) || this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdmin, new Qualifiable[0]) && status.hasOption(StudentSectioningStatus.Option.regadmin) || this.getSessionContext().hasPermissionAnySession((Object)session, Right.StudentSchedulingAdvisor, new Qualifiable[0]) && status.hasOption(StudentSectioningStatus.Option.regadvisor))) {
                        continue;
                    }
                } else {
                    if (!this.getSessionContext().hasPermissionOtherAuthority(session, Right.CourseRequests, this.getStudentAuthority(session))) continue;
                    if (preferStudentCampus && (studentId = this.getStudentId(session.getUniqueId())) != null) {
                        student = (Student)StudentDAO.getInstance().get(studentId);
                        primary = student == null ? null : student.getPrimaryAreaClasfMajor();
                        primaryCampus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
                    }
                }
                ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info)).setOnline(false).setPrimary(preferStudentCampus && this.matchPrimaryCampus(session, primaryCampus)));
            }
        }
        if (ret.isEmpty()) {
            throw new SectioningException(MSG.exceptionNoSuitableAcademicSessions());
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public String retrieveCourseDetails(OnlineSectioningInterface.StudentSectioningContext cx, String course) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        if (server == null) {
            CourseOffering courseOffering = SectioningServlet.lookupCourse(CourseOfferingDAO.getInstance().getSession(), cx.getSessionId(), null, course, null);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            return this.getCourseDetailsProvider().getDetails(new AcademicSessionInfo(courseOffering.getSubjectArea().getSession()), courseOffering.getSubjectAreaAbbv(), courseOffering.getCourseNbr());
        }
        XCourseId c = server.getCourse(course);
        if (c == null) {
            if (course.indexOf(32) >= 0) {
                return this.getCourseDetailsProvider().getDetails(new AcademicSessionInfo((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(cx.getSessionId())), course.substring(0, course.indexOf(32)), course.substring(course.indexOf(32) + 1));
            }
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
        }
        return server.getCourseDetails(c.getCourseId(), this.getCourseDetailsProvider());
    }

    @Override
    public Long retrieveCourseOfferingId(Long sessionId, String course) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(sessionId, false);
        if (server == null) {
            CourseOffering courseOffering = SectioningServlet.lookupCourse(CourseOfferingDAO.getInstance().getSession(), sessionId, null, course, null);
            if (courseOffering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
            }
            return courseOffering.getUniqueId();
        }
        XCourseId c = server.getCourse(course);
        if (c == null) {
            throw new SectioningException(MSG.exceptionCourseDoesNotExist(course));
        }
        return c.getCourseId();
    }

    @Override
    public ClassAssignmentInterface section(CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment) throws SectioningException, PageAccessException {
        try {
            this.checkContext(request);
            if (!request.isOnline()) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment), this.currentUser(request)).get(0);
                if (ret != null) {
                    ret.setCanEnroll(request.getStudentId() != null);
                }
                return ret;
            }
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment), this.currentUser(request)).get(0);
            if (ret != null) {
                ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
                if (ret.isCanEnroll() && request.getStudentId() == null) {
                    ret.setCanEnroll(false);
                }
            }
            OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(request);
            if (ret != null && last != null && last.hasCreditHours()) {
                for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                        Float credit = last.getCreditHour(a);
                        a.setCreditHour(credit);
                        if (credit == null) continue;
                        a.setCredit(FixedCreditUnitConfig.formatCredit(credit.floatValue()));
                    }
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    @Override
    public CourseRequestInterface.CheckCoursesResponse checkCourses(CourseRequestInterface request) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server;
            this.checkContext(request);
            if (request.getAcademicSessionId() == null) {
                throw new SectioningException(MSG.exceptionNoAcademicSession());
            }
            if (!request.isOnline()) {
                StudentSolverProxy server2 = this.getStudentSolver();
                if (server2 == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                return server2.execute(server2.createAction(CheckCourses.class).forRequest(request), this.currentUser(request));
            }
            if (!request.isSectioning()) {
                if (request.getStudentId() == null) {
                    throw new PageAccessException(MSG.exceptionNoStudent());
                }
                this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanRegister, new Qualifiable[0]);
                OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(request);
                if (last != null && !last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
                    throw new SectioningException(last.hasMessage() ? last.getMessage() : MSG.exceptionInsufficientPrivileges());
                }
            }
            if ((server = this.getServerInstance(request.getAcademicSessionId(), false)) == null) {
                if (!request.isSectioning() && CustomCourseRequestsValidationHolder.hasProvider()) {
                    OnlineSectioningServer dummy = this.getServerInstance(request.getAcademicSessionId(), true);
                    return dummy.execute(dummy.createAction(CheckCourses.class).forRequest(request).withMatcher(this.getCourseMatcher(request, server)).withCustomValidation(true), this.currentUser(request));
                }
                Session hibSession = CurriculumDAO.getInstance().getSession();
                CourseRequestInterface.CheckCoursesResponse response = new CourseRequestInterface.CheckCoursesResponse();
                CourseMatcher matcher = this.getCourseMatcher(request, server);
                for (CourseRequestInterface.Request cr : request.getCourses()) {
                    if (!cr.hasRequestedCourse()) continue;
                    for (CourseRequestInterface.RequestedCourse rc : cr.getRequestedCourse()) {
                        if (!rc.isCourse() || SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), request.getStudentId(), rc, matcher) != null) continue;
                        response.addError(rc.getCourseId(), rc.getCourseName(), "NOT_FOUND", MSG.validationCourseNotExists(rc.getCourseName()));
                        response.setErrorMessage(MSG.validationCourseNotExists(rc.getCourseName()));
                    }
                }
                for (CourseRequestInterface.Request cr : request.getAlternatives()) {
                    if (!cr.hasRequestedCourse()) continue;
                    for (CourseRequestInterface.RequestedCourse rc : cr.getRequestedCourse()) {
                        if (!rc.isCourse() || SectioningServlet.lookupCourse(hibSession, request.getAcademicSessionId(), request.getStudentId(), rc, matcher) != null) continue;
                        response.addError(rc.getCourseId(), rc.getCourseName(), "NOT_FOUND", MSG.validationCourseNotExists(rc.getCourseName()));
                        response.setErrorMessage(MSG.validationCourseNotExists(rc.getCourseName()));
                    }
                }
                return response;
            }
            return server.execute(server.createAction(CheckCourses.class).forRequest(request).withMatcher(this.getCourseMatcher(request, server)).withCustomValidation(!request.isSectioning()), this.currentUser(request));
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    public static CourseOffering lookupCourse(Session hibSession, Long sessionId, Long studentId, String courseName, CourseMatcher courseMatcher) {
        Iterator iterator;
        boolean excludeNotOffered = ApplicationProperty.CourseRequestsShowNotOffered.isFalse();
        if (studentId != null && (iterator = hibSession.createQuery("select cr.courseOffering from CourseRequest cr where cr.courseDemand.student.uniqueId = :studentId and " + (excludeNotOffered ? "cr.courseOffering.instructionalOffering.notOffered = false and " : "") + "(lower(cr.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || cr.courseOffering.courseNbr) = :course or lower(cr.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || cr.courseOffering.courseNbr || ' - ' || cr.courseOffering.title) = :course)", CourseOffering.class).setParameter("course", (Object)courseName.toLowerCase()).setParameter("studentId", (Object)studentId).setCacheable(true).setMaxResults(1).list().iterator()).hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        for (CourseOffering co : hibSession.createQuery("select c from CourseOffering c where " + (excludeNotOffered ? "c.instructionalOffering.notOffered = false and " : "") + "c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course or lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr || ' - ' || c.title) = :course)", CourseOffering.class).setParameter("course", (Object)courseName.toLowerCase()).setParameter("sessionId", (Object)sessionId).setCacheable(true).setMaxResults(1).list()) {
            if (courseMatcher != null && !courseMatcher.match(new XCourse(co))) continue;
            return co;
        }
        return null;
    }

    public static CourseOffering lookupCourse(Session hibSession, Long sessionId, Long studentId, CourseRequestInterface.RequestedCourse rc, CourseMatcher courseMatcher) {
        if (rc.hasCourseId()) {
            CourseOffering co = (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), hibSession);
            if (courseMatcher != null && !courseMatcher.match(new XCourse(co))) {
                return null;
            }
            return co;
        }
        if (rc.hasCourseName()) {
            return SectioningServlet.lookupCourse(hibSession, sessionId, studentId, rc.getCourseName(), courseMatcher);
        }
        return null;
    }

    @Override
    public Collection<ClassAssignmentInterface> computeSuggestions(CourseRequestInterface request, Collection<ClassAssignmentInterface.ClassAssignment> currentAssignment, int selectedAssignmentIndex, String filter) throws SectioningException, PageAccessException {
        try {
            this.checkContext(request);
            if (!request.isOnline()) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                ClassAssignmentInterface.ClassAssignment selectedAssignment = null;
                if (selectedAssignmentIndex >= 0) {
                    selectedAssignment = (ClassAssignmentInterface.ClassAssignment)((List)currentAssignment).get(selectedAssignmentIndex);
                } else if (request.getLastCourse() != null) {
                    XCourseId course = server.getCourse(request.getLastCourse().getCourseId(), request.getLastCourse().getCourseName());
                    if (course == null) {
                        throw new SectioningException(MSG.exceptionCourseDoesNotExist(request.getLastCourse().getCourseName()));
                    }
                    selectedAssignment = new ClassAssignmentInterface.ClassAssignment();
                    selectedAssignment.setCourseId(course.getCourseId());
                }
                Collection ret = server.execute(((ComputeSuggestionsAction)server.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)currentAssignment)).withSelection(selectedAssignment).withFilter(filter), this.currentUser(request));
                if (ret != null) {
                    for (ClassAssignmentInterface ca : ret) {
                        ca.setCanEnroll(request.getStudentId() != null);
                    }
                }
                return ret;
            }
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface.ClassAssignment selectedAssignment = null;
            if (selectedAssignmentIndex >= 0) {
                selectedAssignment = (ClassAssignmentInterface.ClassAssignment)((List)currentAssignment).get(selectedAssignmentIndex);
            } else if (request.getLastCourse() != null) {
                XCourseId course = server.getCourse(request.getLastCourse().getCourseId(), request.getLastCourse().getCourseName());
                if (course == null) {
                    throw new SectioningException(MSG.exceptionCourseDoesNotExist(request.getLastCourse().getCourseName()));
                }
                selectedAssignment = new ClassAssignmentInterface.ClassAssignment();
                selectedAssignment.setCourseId(course.getCourseId());
            }
            Collection ret = server.execute(((ComputeSuggestionsAction)server.createAction(ComputeSuggestionsAction.class).forRequest(request).withAssignment((Collection)currentAssignment)).withSelection(selectedAssignment).withFilter(filter).withCanRequire(request.getStudentId() == null || this.getSessionContext().hasPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0])), this.currentUser(request));
            if (ret != null) {
                boolean canEnroll = server.getAcademicSession().isSectioningEnabled() && request.getStudentId() != null;
                for (ClassAssignmentInterface ca : ret) {
                    ca.setCanEnroll(canEnroll);
                }
            }
            OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(request);
            if (ret != null && last != null && last.hasCreditHours()) {
                for (ClassAssignmentInterface suggestion : ret) {
                    for (ClassAssignmentInterface.CourseAssignment ca : suggestion.getCourseAssignments()) {
                        for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                            Float credit = last.getCreditHour(a);
                            a.setCreditHour(credit);
                            if (credit == null) continue;
                            a.setCredit(FixedCreditUnitConfig.formatCredit(credit.floatValue()));
                        }
                    }
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String logIn(String userName, String password, String pin) throws SectioningException, PageAccessException {
        if ("LOOKUP".equals(userName)) {
            this.getSessionContext().checkPermissionAnySession(Right.StudentSchedulingAdvisor, new Qualifiable[0]);
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                List student = hibSession.createQuery("select m from Student m where m.externalUniqueId = :uid order by m.session.sessionBeginDateTime desc", Student.class).setParameter("uid", (Object)password).list();
                if (!student.isEmpty()) {
                    UserContext user = this.getSessionContext().getUser();
                    UniTimePrincipal principal = new UniTimePrincipal(user.getTrueExternalUserId(), password, user.getTrueName());
                    for (Student s : student) {
                        if (!this.getSessionContext().hasPermissionAnySession((Object)s.getSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) continue;
                        principal.addStudentId(s.getSession().getUniqueId(), s.getUniqueId());
                        principal.setName(NameFormat.defaultFormat().format(s));
                    }
                    this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingUser, (Object)principal);
                    String string = principal.getName();
                    return string;
                }
            }
        }
        if ("BATCH".equals(userName)) {
            this.getSessionContext().checkPermission(Right.StudentSectioningSolverDashboard);
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                XStudent student = server.getStudent(Long.valueOf(password));
                if (student == null) {
                    throw new SectioningException(MSG.exceptionLoginFailed());
                }
                UserContext user = this.getSessionContext().getUser();
                UniTimePrincipal uniTimePrincipal = new UniTimePrincipal(user.getTrueExternalUserId(), student.getExternalId(), user.getTrueName());
                uniTimePrincipal.addStudentId(server.getAcademicSession().getUniqueId(), student.getStudentId());
                uniTimePrincipal.setName(student.getName());
                this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingUser, (Object)uniTimePrincipal);
                String string = uniTimePrincipal.getName();
                return string;
            }
        }
        try {
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)userName, (Object)password);
            Authentication authResult = this.getAuthenticationManager().authenticate((Authentication)authRequest);
            SecurityContextHolder.getContext().setAuthentication(authResult);
            UserContext user = (UserContext)authResult.getPrincipal();
            if (user.getCurrentAuthority() == null) {
                for (UserAuthority userAuthority : user.getAuthorities("Student", new Qualifiable[0])) {
                    if (this.getLastSessionId() != null && !userAuthority.getAcademicSession().getQualifierId().equals(this.getLastSessionId())) continue;
                    user.setCurrentAuthority(userAuthority);
                    break;
                }
            }
            LoginManager.loginSuceeded(authResult.getName());
            return user.getName() == null ? user.getUsername() : user.getName();
        }
        catch (Exception e) {
            LoginManager.addFailedLoginAttempt(userName, new Date());
            throw new PageAccessException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean logOut() throws SectioningException, PageAccessException {
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingUser);
        this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingEligibility);
        if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            return false;
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        return true;
    }

    @Override
    public String whoAmI() throws SectioningException, PageAccessException {
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (principal != null) {
            return principal.getName();
        }
        UserContext user = this.getSessionContext().getUser();
        if (user == null || user instanceof AnonymousUserContext) {
            return null;
        }
        return user.getName() == null ? user.getUsername() : user.getName();
    }

    public Long getStudentId(Long sessionId) {
        if (sessionId == null) {
            return null;
        }
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (principal != null) {
            return principal.getStudentId(sessionId);
        }
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            return null;
        }
        Iterator<? extends UserAuthority> iterator = user.getAuthorities("Student", new SimpleQualifier("Session", sessionId)).iterator();
        if (iterator.hasNext()) {
            UserAuthority a = iterator.next();
            return a.getUniqueId();
        }
        return null;
    }

    public Long getLastSessionId() {
        Long sessionId;
        UserContext user;
        Long lastSessionId = (Long)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingLastSession);
        if (lastSessionId == null && (user = this.getSessionContext().getUser()) != null && (sessionId = user.getCurrentAcademicSessionId()) != null) {
            lastSessionId = sessionId;
        }
        return lastSessionId;
    }

    public void setLastSessionId(Long sessionId) {
        this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingLastSession, (Object)sessionId);
    }

    @Override
    public AcademicSessionProvider.AcademicSessionInfo lastAcademicSession(boolean sectioning) throws SectioningException, PageAccessException {
        if (this.getSessionContext().isHttpSessionNew()) {
            throw new PageAccessException(MSG.exceptionUserNotLoggedIn());
        }
        Long sessionId = (Long)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingLastSession);
        if (sessionId == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        ExternalTermProvider extTerm = this.getExternalTermProvider();
        if (sectioning) {
            OnlineSectioningServer server = this.getServerInstance(sessionId, false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            AcademicSessionInfo s = server.getAcademicSession();
            if (s == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            if (this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser) == null) {
                this.getSessionContext().checkPermissionOtherAuthority(s, Right.SchedulingAssistant, this.getStudentAuthority(s));
            }
            return new AcademicSessionProvider.AcademicSessionInfo(s.getUniqueId(), s.getYear(), s.getTerm(), s.getCampus(), MSG.sessionName(s.getYear(), s.getTerm(), s.getCampus()), s.getSessionBeginDate()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(s)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(s));
        }
        org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(sessionId);
        if (session == null || session.getStatusType().isTestSession()) {
            throw new SectioningException(MSG.exceptionNoSuitableAcademicSessions());
        }
        if (!session.getStatusType().canPreRegisterStudents() || session.getStatusType().canSectionAssistStudents() || session.getStatusType().canOnlineSectionStudents()) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        AcademicSessionInfo info = new AcademicSessionInfo(session);
        if (this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser) == null) {
            this.getSessionContext().checkPermissionOtherAuthority(session, Right.CourseRequests, this.getStudentAuthority(session));
        }
        return new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info));
    }

    @Override
    public CourseRequestInterface saveRequest(CourseRequestInterface request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanRegister, new Qualifiable[0]);
        OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(request);
        if (last != null && !last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            throw new SectioningException(last.hasMessage() ? last.getMessage() : MSG.exceptionInsufficientPrivileges());
        }
        OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
        Long studentId = request.getStudentId();
        if (studentId == null) {
            throw new PageAccessException(MSG.exceptionEnrollNotStudent(((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(request.getAcademicSessionId())).getLabel()));
        }
        if (!studentId.equals(this.getStudentId(request.getAcademicSessionId()))) {
            this.getSessionContext().hasPermissionAnySession((Object)request.getAcademicSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]);
        }
        if (server != null) {
            return server.execute(server.createAction(SaveStudentRequests.class).forStudent(studentId).withRequest(request).withCustomValidation(true), this.currentUser(request));
        }
        try (Session hibSession = StudentDAO.getInstance().getSession();){
            Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, this.currentUser(request));
            CriticalCoursesProvider.CriticalCourses critical = null;
            try {
                if (CustomCriticalCoursesHolder.hasProvider()) {
                    critical = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(this.getServerInstance(request.getAcademicSessionId(), true), helper, new XStudentId(student, helper));
                }
            }
            catch (Exception e) {
                helper.warn("Failed to lookup critical courses: " + e.getMessage(), e);
            }
            SaveStudentRequests.saveRequest(null, helper, student, request, true, critical);
            hibSession.persist((Object)student);
            hibSession.flush();
            CourseRequestInterface courseRequestInterface = request;
            return courseRequestInterface;
        }
    }

    @Override
    public ClassAssignmentInterface enroll(CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> currentAssignment) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        Long sessionId = this.canEnroll(request);
        if (!request.getAcademicSessionId().equals(sessionId)) {
            throw new SectioningException(MSG.exceptionBadSession());
        }
        OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(request);
        if (!request.isOnline()) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(BatchEnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(currentAssignment).withWaitListCheck(last != null && last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.WAIT_LIST_VALIDATION)), this.currentUser(request));
        }
        OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionBadStudentId());
        }
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        ClassAssignmentInterface ret = server.execute(server.createAction(EnrollStudent.class).forStudent(request.getStudentId()).withRequest(request).withAssignment(currentAssignment).withWaitListCheck(last != null && last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.WAIT_LIST_VALIDATION)), this.currentUser(request));
        if (ret != null && last != null) {
            for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                    if (a.getGradeMode() != null) {
                        last.addGradeMode(a.getExternalId(), a.getGradeMode().getCode(), a.getGradeMode().getLabel(), a.getGradeMode().isHonor());
                    }
                    if (a.getCreditHour() == null) continue;
                    last.addCreditHour(a.getExternalId(), a.getCreditHour());
                }
            }
            last.setCurrentCredit(ret.getCurrentCredit());
        }
        return ret;
    }

    @Override
    public List<Long> canApprove(Long classOrOfferingId) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server;
            InstructionalOffering offering;
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
            }
            Session hibSession = SessionDAO.getInstance().getSession();
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            if ((server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false)) == null) {
                return null;
            }
            ArrayList<Long> coursesToApprove = new ArrayList<Long>();
            for (CourseOffering course : offering.getCourseOfferings()) {
                if (!this.getSessionContext().hasPermissionAnyAuthority((Object)course, Right.ConsentApproval, new Qualifiable[0])) continue;
                coursesToApprove.add(course.getUniqueId());
            }
            return coursesToApprove;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ClassAssignmentInterface.Enrollment> listEnrollments(Long classOrOfferingId) throws SectioningException, PageAccessException {
        try {
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
            }
            try (Session hibSession = SessionDAO.getInstance().getSession();){
                Class_ clazz;
                InstructionalOffering offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
                Class_ class_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (offering == null && clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                if (offering == null) {
                    offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
                }
                Long offeringId = offering.getUniqueId();
                this.getSessionContext().checkPermission(offering, Right.OfferingEnrollments);
                OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
                if (server == null || !offering.isAllowStudentScheduling() || offering.isNotOffered().booleanValue() || offering.getInstrOfferingConfigs().isEmpty()) {
                    BaseCourseRequest alt;
                    Object c;
                    ClassAssignmentInterface.Student st;
                    ClassAssignmentInterface.Enrollment e;
                    NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingStudentNameFormat.value());
                    NameFormat instructorNameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
                    Hashtable<String, void> approvedBy2name = new Hashtable<String, void>();
                    Hashtable<Long, ClassAssignmentInterface.Enrollment> student2enrollment = new Hashtable<Long, ClassAssignmentInterface.Enrollment>();
                    boolean canShowExtIds = this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId);
                    boolean canRegister = this.sessionContext.hasPermission(Right.CourseRequests);
                    boolean canUseAssistant = this.sessionContext.hasPermission(Right.SchedulingAssistant);
                    for (StudentClassEnrollment enrollment : hibSession.createQuery((String)(clazz == null ? "from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId" : "select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.student.uniqueId in (select f.student.uniqueId from StudentClassEnrollment f where f.clazz.uniqueId = " + clazz.getUniqueId() + ")"), StudentClassEnrollment.class).setParameter("offeringId", (Object)offeringId).list()) {
                        e = (ClassAssignmentInterface.Enrollment)student2enrollment.get(enrollment.getStudent().getUniqueId());
                        if (e == null) {
                            st = new ClassAssignmentInterface.Student();
                            st.setId(enrollment.getStudent().getUniqueId());
                            st.setSessionId(enrollment.getStudent().getSession().getUniqueId());
                            st.setExternalId(enrollment.getStudent().getExternalUniqueId());
                            st.setCanShowExternalId(canShowExtIds);
                            st.setCanRegister(canRegister);
                            st.setCanUseAssistant(canUseAssistant);
                            st.setName(nameFormat.format(enrollment.getStudent()));
                            for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(enrollment.getStudent().getAreaClasfMajors())) {
                                st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicArea().getTitle());
                                st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getAcademicClassification().getName());
                                st.addMajor(studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getMajor().getName());
                                st.addConcentration(studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getName());
                                st.addDegree(studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getLabel());
                                st.addProgram(studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getLabel());
                                st.addCampus(studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getReference(), studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getLabel());
                            }
                            st.setDefaultCampus(enrollment.getStudent().getSession().getAcademicInitiative());
                            for (StudentAreaClassificationMinor studentAreaClassificationMinor : new TreeSet<StudentAreaClassificationMinor>(enrollment.getStudent().getAreaClasfMinors())) {
                                st.addMinor(studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor.getMinor().getName());
                            }
                            for (StudentGroup studentGroup : enrollment.getStudent().getGroups()) {
                                if (studentGroup.getType() == null) {
                                    st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                                    continue;
                                }
                                st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                            }
                            for (StudentAccomodation studentAccomodation : enrollment.getStudent().getAccomodations()) {
                                st.addAccommodation(studentAccomodation.getAbbreviation(), studentAccomodation.getName());
                            }
                            for (Advisor advisor : enrollment.getStudent().getAdvisors()) {
                                if (advisor.getLastName() == null) continue;
                                st.addAdvisor(instructorNameFormat.format(advisor));
                            }
                            e = new ClassAssignmentInterface.Enrollment();
                            e.setStudent(st);
                            e.setEnrolledDate(enrollment.getTimestamp());
                            c = new ClassAssignmentInterface.CourseAssignment();
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseId(enrollment.getCourseOffering().getUniqueId());
                            ((ClassAssignmentInterface.CourseAssignment)c).setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                            ((ClassAssignmentInterface.CourseAssignment)c).setTitle(enrollment.getCourseOffering().getTitle());
                            ((ClassAssignmentInterface.CourseAssignment)c).setHasCrossList(enrollment.getCourseOffering().getInstructionalOffering().hasCrossList());
                            ((ClassAssignmentInterface.CourseAssignment)c).setCanWaitList(enrollment.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                            e.setCourse((ClassAssignmentInterface.CourseAssignment)c);
                            student2enrollment.put(enrollment.getStudent().getUniqueId(), e);
                            if (enrollment.getCourseRequest() != null) {
                                e.setPriority(1 + enrollment.getCourseRequest().getCourseDemand().getPriority());
                                if (enrollment.getCourseRequest().getCourseDemand().getCourseRequests().size() > 1) {
                                    void var20_31;
                                    Object var20_30 = null;
                                    for (CourseRequest courseRequest : enrollment.getCourseRequest().getCourseDemand().getCourseRequests()) {
                                        if (var20_31 != null && courseRequest.getOrder().compareTo(var20_31.getOrder()) >= 0) continue;
                                        CourseRequest courseRequest2 = courseRequest;
                                    }
                                    if (!var20_31.equals(enrollment.getCourseRequest())) {
                                        e.setAlternative(var20_31.getCourseOffering().getCourseName());
                                    }
                                }
                                if (enrollment.getCourseRequest().getCourseDemand().isAlternative().booleanValue()) {
                                    void var20_34;
                                    CourseDemand courseDemand = enrollment.getCourseRequest().getCourseDemand();
                                    block15: for (CourseDemand courseDemand2 : enrollment.getStudent().getCourseDemands()) {
                                        if (courseDemand2.isAlternative().booleanValue() || courseDemand2.getPriority().compareTo(var20_34.getPriority()) >= 0 || courseDemand2.getCourseRequests().isEmpty()) continue;
                                        for (CourseRequest cr : courseDemand2.getCourseRequests()) {
                                            if (!cr.getClassEnrollments().isEmpty()) continue;
                                            continue block15;
                                        }
                                        CourseDemand courseDemand3 = courseDemand2;
                                    }
                                    alt = null;
                                    for (CourseRequest courseRequest : var20_34.getCourseRequests()) {
                                        if (alt != null && courseRequest.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                                        alt = courseRequest;
                                    }
                                    e.setAlternative(alt.getCourseOffering().getCourseName());
                                }
                                e.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                                e.setCritical(enrollment.getCourseRequest().getCourseDemand().getEffectiveCritical().ordinal());
                                e.setApprovedDate(enrollment.getApprovedDate());
                                if (enrollment.getApprovedBy() != null) {
                                    void var20_39;
                                    String string = (String)approvedBy2name.get(enrollment.getApprovedBy());
                                    if (string == null) {
                                        TimetableManager mgr = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :externalId", TimetableManager.class).setParameter("externalId", (Object)enrollment.getApprovedBy()).setMaxResults(1).uniqueResult();
                                        if (mgr != null) {
                                            String string2 = mgr.getName();
                                        } else {
                                            DepartmentalInstructor departmentalInstructor = (DepartmentalInstructor)hibSession.createQuery("from DepartmentalInstructor where externalUniqueId = :externalId and department.session.uniqueId = :sessionId", DepartmentalInstructor.class).setParameter("externalId", (Object)enrollment.getApprovedBy()).setParameter("sessionId", (Object)enrollment.getStudent().getSession().getUniqueId()).setMaxResults(1).uniqueResult();
                                            if (departmentalInstructor != null) {
                                                String string3 = departmentalInstructor.nameLastNameFirst();
                                            }
                                        }
                                        if (var20_39 != null) {
                                            approvedBy2name.put(enrollment.getApprovedBy(), var20_39);
                                        }
                                    }
                                    e.setApprovedBy((String)(var20_39 == null ? enrollment.getApprovedBy() : var20_39));
                                }
                                e.setWaitList(enrollment.getCourseRequest().getCourseDemand().effectiveWaitList());
                                e.setNoSub(enrollment.getCourseRequest().getCourseDemand().effectiveNoSub());
                            } else {
                                e.setPriority(-1);
                            }
                        }
                        ClassAssignmentInterface.ClassAssignment c2 = e.getCourse().addClassAssignment();
                        c2.setClassId(enrollment.getClazz().getUniqueId());
                        c2.setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                        if (c2.getSection() == null) {
                            c2.setSection(enrollment.getClazz().getSectionNumberString(hibSession));
                        }
                        c2.setExternalId(enrollment.getClazz().getExternalId(enrollment.getCourseOffering()));
                        c2.setClassNumber(enrollment.getClazz().getSectionNumberString(hibSession));
                        c2.setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                    }
                    if (classOrOfferingId >= 0L) {
                        for (CourseRequest request : hibSession.createQuery("from CourseRequest r where r.courseOffering.instructionalOffering.uniqueId = :offeringId", CourseRequest.class).setParameter("offeringId", (Object)classOrOfferingId).list()) {
                            e = (ClassAssignmentInterface.Enrollment)student2enrollment.get(request.getCourseDemand().getStudent().getUniqueId());
                            if (e != null) continue;
                            st = new ClassAssignmentInterface.Student();
                            st.setId(request.getCourseDemand().getStudent().getUniqueId());
                            st.setSessionId(request.getCourseDemand().getStudent().getSession().getUniqueId());
                            st.setExternalId(request.getCourseDemand().getStudent().getExternalUniqueId());
                            st.setCanShowExternalId(canShowExtIds);
                            st.setCanRegister(canRegister);
                            st.setCanUseAssistant(canUseAssistant);
                            st.setName(nameFormat.format(request.getCourseDemand().getStudent()));
                            for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(request.getCourseDemand().getStudent().getAreaClasfMajors())) {
                                st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicArea().getTitle());
                                st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getAcademicClassification().getName());
                                st.addMajor(studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getMajor().getName());
                                st.addConcentration(studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getName());
                                st.addDegree(studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getLabel());
                                st.addProgram(studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getLabel());
                                st.addCampus(studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getReference(), studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getLabel());
                            }
                            st.setDefaultCampus(request.getCourseDemand().getStudent().getSession().getAcademicInitiative());
                            for (StudentAreaClassificationMinor studentAreaClassificationMinor : new TreeSet<StudentAreaClassificationMinor>(request.getCourseDemand().getStudent().getAreaClasfMinors())) {
                                st.addMinor(studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor.getMinor().getName());
                            }
                            for (StudentGroup studentGroup : request.getCourseDemand().getStudent().getGroups()) {
                                if (studentGroup.getType() == null) {
                                    st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                                    continue;
                                }
                                st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                            }
                            for (StudentAccomodation studentAccomodation : request.getCourseDemand().getStudent().getAccomodations()) {
                                st.addAccommodation(studentAccomodation.getAbbreviation(), studentAccomodation.getName());
                            }
                            for (Advisor advisor : request.getCourseDemand().getStudent().getAdvisors()) {
                                if (advisor.getLastName() == null) continue;
                                st.addAdvisor(instructorNameFormat.format(advisor));
                            }
                            e = new ClassAssignmentInterface.Enrollment();
                            e.setStudent(st);
                            c = new ClassAssignmentInterface.CourseAssignment();
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseId(request.getCourseOffering().getUniqueId());
                            ((ClassAssignmentInterface.CourseAssignment)c).setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                            ((ClassAssignmentInterface.CourseAssignment)c).setCourseNbr(request.getCourseOffering().getCourseNbr());
                            ((ClassAssignmentInterface.CourseAssignment)c).setTitle(request.getCourseOffering().getTitle());
                            ((ClassAssignmentInterface.CourseAssignment)c).setHasCrossList(request.getCourseOffering().getInstructionalOffering().hasCrossList());
                            ((ClassAssignmentInterface.CourseAssignment)c).setCanWaitList(request.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                            e.setCourse((ClassAssignmentInterface.CourseAssignment)c);
                            e.setWaitList(request.getCourseDemand().effectiveWaitList());
                            e.setNoSub(request.getCourseDemand().effectiveNoSub());
                            student2enrollment.put(request.getCourseDemand().getStudent().getUniqueId(), e);
                            e.setPriority(1 + request.getCourseDemand().getPriority());
                            if (request.getCourseDemand().getCourseRequests().size() > 1) {
                                void var20_47;
                                Object var20_46 = null;
                                for (CourseRequest courseRequest : request.getCourseDemand().getCourseRequests()) {
                                    if (var20_47 != null && courseRequest.getOrder().compareTo(var20_47.getOrder()) >= 0) continue;
                                    CourseRequest courseRequest3 = courseRequest;
                                }
                                if (!var20_47.equals(request)) {
                                    e.setAlternative(var20_47.getCourseOffering().getCourseName());
                                }
                            }
                            if (request.getCourseDemand().isAlternative().booleanValue()) {
                                void var20_50;
                                CourseDemand courseDemand = request.getCourseDemand();
                                block25: for (CourseDemand courseDemand4 : request.getCourseDemand().getStudent().getCourseDemands()) {
                                    if (courseDemand4.isAlternative().booleanValue() || courseDemand4.getPriority().compareTo(var20_50.getPriority()) >= 0 || courseDemand4.getCourseRequests().isEmpty()) continue;
                                    for (CourseRequest cr : courseDemand4.getCourseRequests()) {
                                        if (!cr.getClassEnrollments().isEmpty()) continue;
                                        continue block25;
                                    }
                                    CourseDemand courseDemand5 = courseDemand4;
                                }
                                alt = null;
                                for (CourseRequest courseRequest : var20_50.getCourseRequests()) {
                                    if (alt != null && courseRequest.getOrder().compareTo(alt.getOrder()) >= 0) continue;
                                    alt = courseRequest;
                                }
                                e.setAlternative(alt.getCourseOffering().getCourseName());
                            }
                            e.setRequestedDate(request.getCourseDemand().getTimestamp());
                            e.setCritical(request.getCourseDemand().getEffectiveCritical().ordinal());
                            e.setWaitListedDate(request.getCourseDemand().getWaitlistedTimeStamp());
                            if (!request.getCourseDemand().getStudent().isEnrolled(request.getCourseDemand().getWaitListSwapWithCourseOffering())) continue;
                            e.setWaitListedReplacement(request.getCourseDemand().getWaitListSwapWithCourseOffering().getCourseName());
                        }
                    }
                    Iterator iterator = new ArrayList(student2enrollment.values());
                    return iterator;
                }
                List<ClassAssignmentInterface.Enrollment> list = server.execute(server.createAction(ListEnrollments.class).forOffering(offeringId).withSection(clazz == null ? null : clazz.getUniqueId()).canShowExternalIds(this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)).canRegister(this.sessionContext.hasPermission(Right.CourseRequests)).canUseAssistant(this.sessionContext.hasPermission(Right.SchedulingAssistant)).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)offering.getSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)offering.getSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)), this.currentUser());
                return list;
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassAssignmentInterface getEnrollment(boolean online, Long studentId) throws SectioningException, PageAccessException {
        try {
            if (online) {
                this.getSessionContext().checkPermission(studentId, "Student", Right.StudentEnrollments);
                try (Session hibSession = SessionDAO.getInstance().getSession();){
                    Student student = (Student)StudentDAO.getInstance().get(studentId, hibSession);
                    if (student == null) {
                        throw new SectioningException(MSG.exceptionBadStudentId());
                    }
                    StudentSectioningStatus status = student.getEffectiveStatus();
                    OnlineSectioningInterface.WaitListMode wlMode = student.getWaitListMode();
                    OnlineSectioningServer server = this.getServerInstance(student.getSession().getUniqueId(), false);
                    if (server == null) {
                        Object clazz;
                        ClassAssignmentInterface.CourseAssignment course;
                        Comparator<StudentClassEnrollment> cmp = new Comparator<StudentClassEnrollment>(){

                            public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
                                SchedulingSubpart p1 = s1.getParentSubpart();
                                if (p1 == null) {
                                    return false;
                                }
                                if (p1.equals(s2)) {
                                    return true;
                                }
                                return this.isParent(p1, s2);
                            }

                            @Override
                            public int compare(StudentClassEnrollment a, StudentClassEnrollment b) {
                                SchedulingSubpart s2;
                                SchedulingSubpart s1 = a.getClazz().getSchedulingSubpart();
                                if (this.isParent(s1, s2 = b.getClazz().getSchedulingSubpart())) {
                                    return 1;
                                }
                                if (this.isParent(s2, s1)) {
                                    return -1;
                                }
                                int cmp = s1.getItype().compareTo(s2.getItype());
                                if (cmp != 0) {
                                    return cmp;
                                }
                                return Double.compare(s1.getUniqueId().longValue(), s2.getUniqueId().longValue());
                            }
                        };
                        NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
                        String datePatternFormat = ApplicationProperty.DatePatternFormatUseDates.value(student.getSession());
                        ClassAssignmentInterface ret = new ClassAssignmentInterface();
                        Hashtable<Long, ClassAssignmentInterface.CourseAssignment> courses = new Hashtable<Long, ClassAssignmentInterface.CourseAssignment>();
                        CourseCreditUnitConfig credit = null;
                        ExternalClassNameHelperInterface.HasGradableSubpart gs = null;
                        if (ApplicationProperty.OnlineSchedulingGradableIType.isTrue() && Class_.getExternalClassNameHelper() != null && Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasGradableSubpart) {
                            gs = (ExternalClassNameHelperInterface.HasGradableSubpart)((Object)Class_.getExternalClassNameHelper());
                        }
                        TreeSet<StudentClassEnrollment> enrollments = new TreeSet<StudentClassEnrollment>(cmp);
                        enrollments.addAll(hibSession.createQuery("from StudentClassEnrollment e where e.student.uniqueId = :studentId order by e.courseOffering.subjectAreaAbbv, e.courseOffering.courseNbr", StudentClassEnrollment.class).setParameter("studentId", (Object)studentId).list());
                        CustomClassAttendanceProvider provider = (CustomClassAttendanceProvider)Customization.CustomClassAttendanceProvider.getProvider();
                        CustomClassAttendanceProvider.StudentClassAttendance attendance = provider == null ? null : provider.getCustomClassAttendanceForStudent(student, null, this.getSessionContext());
                        for (StudentClassEnrollment enrollment : enrollments) {
                            Float creditOverride;
                            int maxLimit;
                            course = (ClassAssignmentInterface.CourseAssignment)courses.get(enrollment.getCourseOffering().getUniqueId());
                            if (course == null) {
                                course = new ClassAssignmentInterface.CourseAssignment();
                                courses.put(enrollment.getCourseOffering().getUniqueId(), course);
                                ret.add(course);
                                course.setAssigned(true);
                                course.setCourseId(enrollment.getCourseOffering().getUniqueId());
                                course.setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                                course.setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                                course.setTitle(enrollment.getCourseOffering().getTitle());
                                course.setHasCrossList(enrollment.getCourseOffering().getInstructionalOffering().hasCrossList());
                                course.setCanWaitList(enrollment.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                                credit = enrollment.getCourseOffering().getCredit();
                                if (enrollment.getCourseRequest() != null) {
                                    course.setRequestedDate(enrollment.getCourseRequest().getCourseDemand().getTimestamp());
                                }
                            }
                            clazz = course.addClassAssignment();
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setClassId(enrollment.getClazz().getUniqueId());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseId(enrollment.getCourseOffering().getUniqueId());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseAssigned(true);
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCourseNbr(enrollment.getCourseOffering().getCourseNbr());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setTitle(enrollment.getCourseOffering().getTitle());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setSubject(enrollment.getCourseOffering().getSubjectAreaAbbv());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setSection(enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering()));
                            if (((ClassAssignmentInterface.ClassAssignment)clazz).getSection() == null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setSection(enrollment.getClazz().getSectionNumberString(hibSession));
                            }
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setExternalId(enrollment.getClazz().getExternalId(enrollment.getCourseOffering()));
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setClassNumber(enrollment.getClazz().getSectionNumberString(hibSession));
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setSubpart(enrollment.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                            if (enrollment.getClazz().getParentClass() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getClazz().getParentClass().getClassSuffix(enrollment.getCourseOffering()));
                                if (((ClassAssignmentInterface.ClassAssignment)clazz).getParentSection() == null) {
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getClazz().getParentClass().getSectionNumberString(hibSession));
                                }
                            }
                            if (enrollment.getCourseOffering().getScheduleBookNote() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).addNote(enrollment.getCourseOffering().getScheduleBookNote());
                            }
                            if (enrollment.getClazz().getSchedulePrintNote() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).addNote(enrollment.getClazz().getSchedulePrintNote());
                            }
                            if (attendance != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).addNote(attendance.getClassNote(((ClassAssignmentInterface.ClassAssignment)clazz).getExternalId()));
                            }
                            Iterator<Object> placement = enrollment.getClazz().getCommittedAssignment() == null ? null : enrollment.getClazz().getCommittedAssignment().getPlacement();
                            int minLimit = enrollment.getClazz().getExpectedCapacity();
                            int limit = maxLimit = enrollment.getClazz().getMaxExpectedCapacity().intValue();
                            if (minLimit < maxLimit && placement != null) {
                                int roomLimit = (int)Math.floor((float)placement.getRoomSize() / (enrollment.getClazz().getRoomRatio() == null ? 1.0f : enrollment.getClazz().getRoomRatio().floatValue()));
                                limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                            }
                            if (enrollment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                                limit = -1;
                            }
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setCancelled(enrollment.getClazz().isCancelled());
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setLimit(new int[]{enrollment.getClazz().getEnrollment(), limit});
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setEnrolledDate(enrollment.getTimestamp());
                            if (placement != null) {
                                if (placement.getTimeLocation() != null) {
                                    for (DayCode d : DayCode.toDayCodes(placement.getTimeLocation().getDayCode())) {
                                        ((ClassAssignmentInterface.ClassAssignment)clazz).addDay(d.getIndex());
                                    }
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setStart(placement.getTimeLocation().getStartSlot());
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setLength(placement.getTimeLocation().getLength());
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setBreakTime(placement.getTimeLocation().getBreakTime());
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setDatePattern(XTime.datePatternName(enrollment.getClazz().getCommittedAssignment(), datePatternFormat));
                                }
                                if (enrollment.getClazz().getCommittedAssignment() != null) {
                                    for (Location loc : enrollment.getClazz().getCommittedAssignment().getRooms()) {
                                        ((ClassAssignmentInterface.ClassAssignment)clazz).addRoom(loc.getUniqueId(), loc.getLabelWithDisplayName());
                                    }
                                }
                            } else {
                                for (RoomPref rp : enrollment.getClazz().effectivePreferences(RoomPref.class)) {
                                    if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) continue;
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addRoom(rp.getRoom().getUniqueId(), rp.getRoom().getLabel());
                                }
                                DatePattern pattern = enrollment.getClazz().effectiveDatePattern();
                                if (pattern != null) {
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).setDatePattern(this.datePatternName(pattern, datePatternFormat));
                                }
                            }
                            if (enrollment.getClazz().getDisplayInstructor().booleanValue()) {
                                for (ClassInstructor ci : enrollment.getClazz().getClassInstructors()) {
                                    if (!ci.isLead().booleanValue()) continue;
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addInstructor(nameFormat.format(ci.getInstructor()));
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addInstructoEmail(ci.getInstructor().getEmail() == null ? "" : ci.getInstructor().getEmail());
                                }
                            }
                            if (credit != null && gs != null && gs.isGradableSubpart(enrollment.getClazz().getSchedulingSubpart(), enrollment.getCourseOffering(), hibSession)) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(credit.creditAbbv() + "|" + credit.creditText());
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                                credit = null;
                            } else if (credit != null && gs == null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(credit.creditAbbv() + "|" + credit.creditText());
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCreditRange(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                                credit = null;
                            }
                            if (enrollment.getClazz().getSchedulingSubpart().getCredit() != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(enrollment.getClazz().getSchedulingSubpart().getCredit().creditAbbv() + "|" + enrollment.getClazz().getSchedulingSubpart().getCredit().creditText());
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCreditRange(Float.valueOf(enrollment.getClazz().getSchedulingSubpart().getCredit().getMinCredit()), Float.valueOf(enrollment.getClazz().getSchedulingSubpart().getCredit().getMaxCredit()));
                                credit = null;
                            }
                            if ((creditOverride = enrollment.getClazz().getCredit(enrollment.getCourseOffering())) != null) {
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                            }
                            if (((ClassAssignmentInterface.ClassAssignment)clazz).getParentSection() != null) continue;
                            ((ClassAssignmentInterface.ClassAssignment)clazz).setParentSection(enrollment.getCourseOffering().getConsentType() == null ? null : enrollment.getCourseOffering().getConsentType().getLabel());
                        }
                        block22: for (CourseDemand demand : hibSession.createQuery("from CourseDemand d where d.student.uniqueId = :studentId order by d.priority", CourseDemand.class).setParameter("studentId", (Object)studentId).list()) {
                            if (demand.getFreeTime() != null) {
                                course = new ClassAssignmentInterface.CourseAssignment();
                                course.setAssigned(true);
                                clazz = course.addClassAssignment();
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setLength(demand.getFreeTime().getLength());
                                for (DayCode d : DayCode.toDayCodes(demand.getFreeTime().getDayCode())) {
                                    ((ClassAssignmentInterface.ClassAssignment)clazz).addDay(d.getIndex());
                                }
                                ((ClassAssignmentInterface.ClassAssignment)clazz).setStart(demand.getFreeTime().getStartSlot());
                                block24: for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                                    for (ClassAssignmentInterface.ClassAssignment c : ca.getClassAssignments()) {
                                        if (!c.isAssigned()) continue;
                                        for (int d : c.getDays()) {
                                            if (!((ClassAssignmentInterface.ClassAssignment)clazz).getDays().contains(d) || c.getStart() + c.getLength() <= ((ClassAssignmentInterface.ClassAssignment)clazz).getStart() || ((ClassAssignmentInterface.ClassAssignment)clazz).getStart() + ((ClassAssignmentInterface.ClassAssignment)clazz).getLength() <= c.getStart()) continue;
                                            course.setAssigned(false);
                                            break block24;
                                        }
                                    }
                                }
                                course.setRequestedDate(demand.getTimestamp());
                                ret.add(course);
                                continue;
                            }
                            BaseCourseRequest request = null;
                            for (CourseRequest r : demand.getCourseRequests()) {
                                if (courses.containsKey(r.getCourseOffering().getUniqueId())) continue block22;
                                if (request != null && r.getOrder().compareTo(request.getOrder()) >= 0) continue;
                                request = r;
                            }
                            if (request == null) continue;
                            ClassAssignmentInterface.CourseAssignment course2 = new ClassAssignmentInterface.CourseAssignment();
                            courses.put(request.getCourseOffering().getUniqueId(), course2);
                            course2.setRequestedDate(demand.getTimestamp());
                            if (demand.effectiveWaitList()) {
                                course2.setWaitListedDate(demand.getWaitlistedTimeStamp());
                            }
                            ret.add(course2);
                            course2.setAssigned(false);
                            course2.setCourseId(request.getCourseOffering().getUniqueId());
                            course2.setCourseNbr(request.getCourseOffering().getCourseNbr());
                            course2.setSubject(request.getCourseOffering().getSubjectAreaAbbv());
                            course2.setTitle(request.getCourseOffering().getTitle());
                            course2.setHasCrossList(request.getCourseOffering().getInstructionalOffering().hasCrossList());
                            course2.setCanWaitList(request.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                        }
                        ret.setRequest(this.getRequest(student));
                        ret.setCanSetCriticalOverrides(this.getSessionContext().hasPermission(student, Right.StudentSchedulingChangeCriticalOverride));
                        ret.setAdvisorRequest(AdvisorGetCourseRequests.getRequest(student, hibSession));
                        ret.setAdvisorWaitListedCourseIds(student.getAdvisorWaitListedCourseIds(null));
                        if (Customization.StudentHoldsCheckProvider.hasProvider()) {
                            try {
                                OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, this.currentUser());
                                try {
                                    StudentHoldsCheckProvider holds = (StudentHoldsCheckProvider)Customization.StudentHoldsCheckProvider.getProvider();
                                    ret.getRequest().setErrorMessage(holds.getStudentHoldError(this.getServerInstance(student.getSession().getUniqueId(), true), helper, new XStudentId(student, helper)));
                                }
                                catch (Exception e) {
                                    helper.warn("Failed to lookup critical courses: " + e.getMessage(), e);
                                }
                            }
                            catch (Exception helper) {
                                // empty catch block
                            }
                        }
                        if (Customization.SpecialRegistrationDashboardUrlProvider.hasProvider()) {
                            try {
                                SpecialRegistrationDashboardUrlProvider dash = (SpecialRegistrationDashboardUrlProvider)Customization.SpecialRegistrationDashboardUrlProvider.getProvider();
                                ret.getRequest().setSpecRegDashboardUrl(dash.getDashboardUrl(student));
                            }
                            catch (Exception dash) {
                                // empty catch block
                            }
                        }
                        if (ret.getRequest() != null) {
                            ret.getRequest().setWaitListMode(wlMode);
                        }
                        if (ret.getAdvisorRequest() != null) {
                            String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(student.getSession());
                            if ("Student".equalsIgnoreCase(advWlMode)) {
                                ret.getAdvisorRequest().setWaitListMode(wlMode);
                            } else {
                                ret.getAdvisorRequest().setWaitListMode(OnlineSectioningInterface.WaitListMode.valueOf(advWlMode));
                            }
                        }
                        for (StudentNote n : student.getNotes()) {
                            ClassAssignmentInterface.Note note = new ClassAssignmentInterface.Note();
                            note.setTimeStamp(n.getTimeStamp());
                            note.setId(n.getUniqueId());
                            note.setMessage(n.getTextNote());
                            note.setOwner(n.getUserId());
                            TimetableManager manager = TimetableManager.findByExternalId(n.getUserId());
                            if (manager != null) {
                                note.setOwner(nameFormat.format(manager));
                            } else {
                                Advisor advisor = Advisor.findByExternalId(n.getUserId(), student.getSession().getUniqueId());
                                if (advisor != null) {
                                    note.setOwner(nameFormat.format(advisor));
                                }
                            }
                            ret.addNote(note);
                        }
                        if (status != null && status.hasOption(StudentSectioningStatus.Option.specreg) && Customization.SpecialRegistrationProvider.hasProvider()) {
                            try {
                                SpecialRegistrationProvider sp = (SpecialRegistrationProvider)Customization.SpecialRegistrationProvider.getProvider();
                                OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, this.currentUser());
                                server = this.getServerInstance(student.getSession().getUniqueId(), true);
                                ret.setSpecialRegistrations(sp.retrieveAllRegistrations(server, helper, new XStudent(student, helper, server.getAcademicSession().getFreeTimePattern(), server.getAcademicSession().getDatePatternFirstDate())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ClassAssignmentInterface classAssignmentInterface = ret;
                        return classAssignmentInterface;
                    }
                    ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId).withRequest(true).withCustomCheck(true).withWaitListCheck(true).withAdvisorRequest(true).checkHolds(true).withWaitListMode(wlMode).withSpecialRegistrations(status != null && status.hasOption(StudentSectioningStatus.Option.specreg)).withWaitListPosition(true), this.currentUser());
                    ret.setCanSetCriticalOverrides(this.getSessionContext().hasPermission(student, Right.StudentSchedulingChangeCriticalOverride));
                    if (ret.getRequest() != null) {
                        ret.getRequest().setWaitListMode(wlMode);
                    }
                    if (ret.getAdvisorRequest() != null) {
                        String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(student.getSession());
                        if ("Student".equalsIgnoreCase(advWlMode)) {
                            ret.getAdvisorRequest().setWaitListMode(wlMode);
                        } else {
                            ret.getAdvisorRequest().setWaitListMode(OnlineSectioningInterface.WaitListMode.valueOf(advWlMode));
                        }
                    }
                    NameFormat nameFormat = NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value());
                    for (StudentNote n : student.getNotes()) {
                        ClassAssignmentInterface.Note note = new ClassAssignmentInterface.Note();
                        note.setTimeStamp(n.getTimeStamp());
                        note.setId(n.getUniqueId());
                        note.setMessage(n.getTextNote());
                        note.setOwner(n.getUserId());
                        TimetableManager manager = TimetableManager.findByExternalId(n.getUserId());
                        if (manager != null) {
                            note.setOwner(nameFormat.format(manager));
                        } else {
                            Advisor advisor = Advisor.findByExternalId(n.getUserId(), server.getAcademicSession().getUniqueId());
                            if (advisor != null) {
                                note.setOwner(nameFormat.format(advisor));
                            }
                        }
                        ret.addNote(note);
                    }
                    ClassAssignmentInterface classAssignmentInterface = ret;
                    return classAssignmentInterface;
                }
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            OnlineSectioningInterface.WaitListMode wlMode = OnlineSectioningInterface.WaitListMode.NoSubs;
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(studentId).withRequest(true).withAdvisorRequest(true).withWaitListMode(wlMode), this.currentUser());
            if (ret.getRequest() != null) {
                ret.getRequest().setWaitListMode(wlMode);
            }
            if (ret.getAdvisorRequest() != null) {
                String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(server.getAcademicSession());
                if ("Student".equalsIgnoreCase(advWlMode)) {
                    ret.getAdvisorRequest().setWaitListMode(wlMode);
                } else {
                    ret.getAdvisorRequest().setWaitListMode(OnlineSectioningInterface.WaitListMode.valueOf(advWlMode));
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            throw new PageAccessException(e.getMessage());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public String approveEnrollments(Long classOrOfferingId, List<Long> studentIds) throws SectioningException, PageAccessException {
        try {
            InstructionalOffering offering;
            Session hibSession = SessionDAO.getInstance().getSession();
            List<Long> courseIdsCanApprove = this.canApprove(classOrOfferingId);
            if (courseIdsCanApprove == null || courseIdsCanApprove.isEmpty()) {
                throw new SectioningException(MSG.exceptionInsufficientPrivileges());
            }
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
            UserContext user = this.getSessionContext().getUser();
            String approval = new Date().getTime() + ":" + user.getTrueExternalUserId() + ":" + user.getTrueName();
            server.execute(server.createAction(ApproveEnrollmentsAction.class).withParams(offering.getUniqueId(), studentIds, courseIdsCanApprove, approval), this.currentUser());
            return approval;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean rejectEnrollments(Long classOrOfferingId, List<Long> studentIds) throws SectioningException, PageAccessException {
        try {
            InstructionalOffering offering;
            Session hibSession = SessionDAO.getInstance().getSession();
            List<Long> courseIdsCanApprove = this.canApprove(classOrOfferingId);
            if (courseIdsCanApprove == null || courseIdsCanApprove.isEmpty()) {
                throw new SectioningException(MSG.exceptionInsufficientPrivileges());
            }
            InstructionalOffering instructionalOffering = offering = classOrOfferingId >= 0L ? (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(classOrOfferingId, hibSession) : null;
            if (offering == null) {
                BaseClass_ clazz;
                BaseClass_ baseClass_ = clazz = classOrOfferingId < 0L ? (Class_)Class_DAO.getInstance().get(-classOrOfferingId.longValue(), hibSession) : null;
                if (clazz == null) {
                    throw new SectioningException(MSG.exceptionBadClassOrOffering());
                }
                offering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering();
            }
            OnlineSectioningServer server = this.getServerInstance(offering.getControllingCourseOffering().getSubjectArea().getSessionId(), false);
            UserContext user = this.getSessionContext().getUser();
            String approval = new Date().getTime() + ":" + user.getTrueExternalUserId() + ":" + user.getTrueName();
            return server.execute(server.createAction(RejectEnrollmentsAction.class).withParams(offering.getUniqueId(), studentIds, courseIdsCanApprove, approval), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private Long getStatusPageSessionId() throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (user.getCurrentAcademicSessionId() == null) {
            Long sessionId = this.getLastSessionId();
            if (sessionId != null) {
                return sessionId;
            }
        } else {
            return user.getCurrentAcademicSessionId();
        }
        throw new SectioningException(MSG.exceptionNoAcademicSession());
    }

    private HashSet<Long> getCoordinatingCourses(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (this.getSessionContext().hasPermission(Right.HasRole)) {
            return null;
        }
        HashSet<Long> courseIds = new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c inner join c.instructionalOffering.offeringCoordinators oc where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and oc.instructor.externalUniqueId = :extId", Long.class).setParameter("sessionId", (Object)sessionId).setParameter("extId", (Object)user.getExternalUserId()).setCacheable(true).list());
        return courseIds;
    }

    private Set<String> getSubjectAreas() throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        if (!this.getSessionContext().hasPermission(Right.HasRole) || this.getSessionContext().hasPermission(Right.DepartmentIndependent)) {
            return null;
        }
        if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdmin) || this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor)) {
            return null;
        }
        HashSet<String> subjects = new HashSet<String>();
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(user)) {
            subjects.add(subject.getSubjectAreaAbbreviation());
        }
        return subjects;
    }

    private HashSet<Long> getApprovableCourses(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        HashSet<Long> courseIds = new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c inner join c.instructionalOffering.offeringCoordinators oc where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and c.consentType.reference = :reference and oc.instructor.externalUniqueId = :extId", Long.class).setParameter("sessionId", (Object)sessionId).setParameter("reference", (Object)"IN").setParameter("extId", (Object)user.getExternalUserId()).setCacheable(true).list());
        if (!user.getCurrentAuthority().hasRight(Right.HasRole)) {
            return courseIds;
        }
        if (user.getCurrentAuthority().hasRight(Right.SessionIndependent)) {
            return new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select c.uniqueId from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and c.subjectArea.department.allowStudentScheduling = true and c.consentType is not null", Long.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
        }
        for (Department d : Department.getUserDepartments(user)) {
            courseIds.addAll(CourseOfferingDAO.getInstance().getSession().createQuery("select distinct c.uniqueId from CourseOffering c where c.subjectArea.department.uniqueId = :departmentId and c.subjectArea.department.allowStudentScheduling = true and c.consentType is not null", Long.class).setParameter("departmentId", (Object)d.getUniqueId()).setCacheable(true).list());
        }
        return courseIds;
    }

    private HashSet<Long> getMyStudents(Long sessionId) throws SectioningException, PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null || user.getCurrentAuthority() == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired());
        }
        return new HashSet<Long>(CourseOfferingDAO.getInstance().getSession().createQuery("select s.uniqueId from Advisor a inner join a.students s where a.externalUniqueId = :user and a.role.reference = :role and a.session.uniqueId = :sessionId", Long.class).setParameter("sessionId", (Object)sessionId).setParameter("user", (Object)user.getExternalUserId()).setParameter("role", (Object)user.getCurrentAuthority().getRole()).setCacheable(true).list());
    }

    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> findEnrollmentInfos(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter, Long courseId) throws SectioningException, PageAccessException {
        try {
            if (filter != null && this.sessionContext.isAuthenticated()) {
                filter.setOption("user", this.sessionContext.getUser().getExternalUserId());
                if (this.sessionContext.getUser().getCurrentAuthority() != null) {
                    filter.setOption("role", this.sessionContext.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindEnrollmentInfoAction.class).withParams(query, courseId, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas()).showUnmatchedClasses(CommonValues.Yes.eq(UserProperty.StudentDashboardShowUnmatchedClasses.get(this.sessionContext.getUser()))).showUnmatchedCourses(CommonValues.Yes.eq(UserProperty.StudentDashboardShowUnmatchedCourses.get(this.sessionContext.getUser()))).withFilter(filter), this.currentUser());
                }
                return server.execute(server.createAction(FindEnrollmentInfoAction.class).withParams(query, courseId, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas()).showUnmatchedClasses(CommonValues.Yes.eq(UserProperty.StudentDashboardShowUnmatchedClasses.get(this.sessionContext.getUser()))).withFilter(filter), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(FindEnrollmentInfoAction.class).withParams(query, courseId, null, null, this.getMyStudents(server.getAcademicSession().getUniqueId()), this.getSubjectAreas()).showUnmatchedClasses(CommonValues.Yes.eq(UserProperty.StudentDashboardShowUnmatchedClasses.get(this.sessionContext.getUser()))).withFilter(filter), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<ClassAssignmentInterface.StudentInfo> findStudentInfos(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) throws SectioningException, PageAccessException {
        try {
            if (filter != null && this.sessionContext.isAuthenticated()) {
                filter.setOption("user", this.sessionContext.getUser().getExternalUserId());
                if (this.sessionContext.getUser().getCurrentAuthority() != null) {
                    filter.setOption("role", this.sessionContext.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindStudentInfoAction.class).withParams(query, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas(), this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingChangeStudentStatus) || this.getSessionContext().hasPermission(Right.StudentSchedulingEmailStudent)), this.currentUser());
                }
                return server.execute(server.createAction(FindStudentInfoAction.class).withParams(query, this.getCoordinatingCourses(sessionId), query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId) : null, this.getMyStudents(sessionId), this.getSubjectAreas(), this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingChangeStudentStatus) || this.getSessionContext().hasPermission(Right.StudentSchedulingEmailStudent)), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(FindStudentInfoAction.class).withParams(query, null, null, this.getMyStudents(server.getAcademicSession().getUniqueId()), this.getSubjectAreas(), this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), false, true).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingChangeStudentStatus) || this.getSessionContext().hasPermission(Right.StudentSchedulingEmailStudent)), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<String[]> querySuggestions(boolean online, String query, int limit) throws SectioningException, PageAccessException {
        try {
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                UserContext user = this.getSessionContext().getUser();
                return server.execute(server.createAction(StatusPageSuggestionsAction.class).withParams(user.getExternalUserId(), user.getName(), query, limit), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            UserContext user = this.getSessionContext().getUser();
            return server.execute(server.createAction(StatusPageSuggestionsAction.class).withParams(user.getExternalUserId(), user.getName(), query, limit), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public List<ClassAssignmentInterface.Enrollment> findEnrollments(boolean online, String query, SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter, Long courseId, Long classId) throws SectioningException, PageAccessException {
        try {
            if (filter != null && this.sessionContext.isAuthenticated()) {
                filter.setOption("user", this.sessionContext.getUser().getExternalUserId());
                if (this.sessionContext.getUser().getCurrentAuthority() != null) {
                    filter.setOption("role", this.sessionContext.getUser().getCurrentAuthority().getRole());
                }
            }
            if (online) {
                Long sessionId = this.getStatusPageSessionId();
                OnlineSectioningServer server = this.getServerInstance(sessionId, true);
                if (server == null) {
                    throw new SectioningException(MSG.exceptionBadSession());
                }
                if (this.getSessionContext().isAuthenticated()) {
                    this.getSessionContext().getUser().setProperty("SectioningStatus.LastStatusQuery", query);
                }
                if (server instanceof DatabaseServer) {
                    return server.execute(server.createAction(DbFindEnrollmentAction.class).withParams(query, courseId, classId, query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId).contains(courseId) : false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant), this.getMyStudents(sessionId)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingChangeStudentStatus) || this.getSessionContext().hasPermission(Right.StudentSchedulingEmailStudent)), this.currentUser());
                }
                return server.execute(server.createAction(FindEnrollmentAction.class).withParams(query, courseId, classId, query.matches("(?i:.*consent:[ ]?(todo|\\\"to do\\\").*)") ? this.getApprovableCourses(sessionId).contains(courseId) : false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), this.sessionContext.hasPermission(Right.CourseRequests), this.sessionContext.hasPermission(Right.SchedulingAssistant), this.getMyStudents(sessionId)).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingChangeStudentStatus) || this.getSessionContext().hasPermission(Right.StudentSchedulingEmailStudent)), this.currentUser());
            }
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            if (this.getSessionContext().isAuthenticated()) {
                this.getSessionContext().getUser().setProperty("SectioningStatus.LastStatusQuery", query);
            }
            return server.execute(server.createAction(FindEnrollmentAction.class).withParams(query, courseId, classId, false, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId), false, true, this.getMyStudents(server.getAcademicSession().getUniqueId())).withFilter(filter).withPermissions(this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdmin, new Qualifiable[0]), this.getSessionContext().hasPermissionAnySession((Object)server.getAcademicSession().getUniqueId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents), this.getSessionContext().hasPermission(Right.StudentSchedulingChangeStudentStatus) || this.getSessionContext().hasPermission(Right.StudentSchedulingEmailStudent)), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    protected OnlineSectioningInterface.EligibilityCheck getLastEligibilityCheck(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        OnlineSectioningInterface.EligibilityCheck last = (OnlineSectioningInterface.EligibilityCheck)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingEligibility);
        if (last == null) {
            return this.checkEligibility(cx);
        }
        if (cx.getSessionId() != null && !cx.getSessionId().equals(last.getSessionId())) {
            return this.checkEligibility(cx);
        }
        if (cx.getStudentId() != null && !cx.getStudentId().equals(last.getStudentId())) {
            return this.checkEligibility(cx);
        }
        return last;
    }

    @Override
    public Long canEnroll(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningInterface.EligibilityCheck check;
            OnlineSectioningInterface.EligibilityCheck last;
            this.checkContext(cx);
            if (!cx.isOnline()) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    throw new SectioningException(MSG.exceptionNoSolver());
                }
                CourseRequestInterface request = server.execute(server.createAction(GetRequest.class).forStudent(cx.getStudentId()).withWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs), this.currentUser(cx));
                if (request == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                return server.getAcademicSession().getUniqueId();
            }
            boolean recheckCustomEligibility = ApplicationProperty.OnlineSchedulingCustomEligibilityRecheck.isTrue();
            if (!(recheckCustomEligibility || (last = this.getLastEligibilityCheck(cx)) == null || !last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT) && last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL))) {
                recheckCustomEligibility = true;
            }
            if ((check = this.checkEligibility(cx, recheckCustomEligibility)) == null || !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT)) {
                if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                    throw new SectioningException(check.getMessage() == null ? MSG.exceptionAuthenticationPinNotProvided() : check.getMessage()).withEligibilityCheck(check);
                }
                throw new PageAccessException(check.getMessage() == null ? MSG.exceptionInsufficientPrivileges() : check.getMessage());
            }
            if (cx.getStudentId() == null || cx.getStudentId().equals(this.getStudentId(check.getSessionId()))) {
                return check.getSessionId();
            }
            if (this.getSessionContext().hasPermissionAnySession((Object)check.getSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
                return check.getSessionId();
            }
            OnlineSectioningServer server = this.getServerInstance(check.getSessionId(), false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            if (this.getStudentId(check.getSessionId()) == null) {
                throw new PageAccessException(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
            }
            throw new PageAccessException(MSG.exceptionInsufficientPrivileges());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    protected CourseRequestInterface getRequest(Student student) {
        OnlineSectioningServer server;
        CourseRequestInterface request = new CourseRequestInterface();
        request.setAcademicSessionId(student.getSession().getUniqueId());
        request.setStudentId(student.getUniqueId());
        request.setSaved(true);
        request.setMaxCredit(student.getMaxCredit());
        request.setWaitListMode(student.getWaitListMode());
        if (student.getOverrideMaxCredit() != null) {
            request.setMaxCreditOverride(student.getOverrideMaxCredit());
            request.setMaxCreditOverrideExternalId(student.getOverrideExternalId());
            request.setMaxCreditOverrideTimeStamp(student.getOverrideTimeStamp());
            Integer status = student.getOverrideStatus();
            if (status == null) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
            } else if (status.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
            } else {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
            }
        }
        boolean setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnly.isTrue();
        if (this.getSessionContext().hasPermissionAnySession((Object)student.getSession().getUniqueId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) || this.getSessionContext().hasPermissionAnySession((Object)student.getSession().getUniqueId(), Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
            setReadOnlyWhenReserved = ApplicationProperty.OnlineSchedulingMakeReservedRequestReadOnlyIfAdmin.isTrue();
        }
        boolean reservedNoPriority = ApplicationProperty.OnlineSchedulingReservedRequestNoPriorityChanges.isTrue();
        boolean reservedNoAlternatives = ApplicationProperty.OnlineSchedulingReservedRequestNoAlternativeChanges.isTrue();
        boolean enrolledNoPriority = ApplicationProperty.OnlineSchedulingAssignedRequestNoPriorityChanges.isTrue();
        boolean enrolledNoAlternatives = ApplicationProperty.OnlineSchedulingAssignedRequestNoAlternativeChanges.isTrue();
        HashSet<Long> courseIds = new HashSet<Long>();
        if (!student.getCourseDemands().isEmpty()) {
            TreeSet<CourseDemand> demands = new TreeSet<CourseDemand>(new Comparator<CourseDemand>(){

                @Override
                public int compare(CourseDemand d1, CourseDemand d2) {
                    if (d1.isAlternative().booleanValue() && !d2.isAlternative().booleanValue()) {
                        return 1;
                    }
                    if (!d1.isAlternative().booleanValue() && d2.isAlternative().booleanValue()) {
                        return -1;
                    }
                    int cmp = d1.getPriority().compareTo(d2.getPriority());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return d1.getUniqueId().compareTo(d2.getUniqueId());
                }
            });
            demands.addAll(student.getCourseDemands());
            CourseRequestInterface.Request lastRequest = null;
            int lastRequestPriority = -1;
            for (CourseDemand cd : demands) {
                CourseRequestInterface.Request r = null;
                if (cd.getFreeTime() != null) {
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(cd.getFreeTime().getStartSlot());
                    ft.setLength(cd.getFreeTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(cd.getFreeTime().getDayCode())) {
                        ft.addDay(day.getIndex());
                    }
                    if (lastRequest != null && lastRequestPriority == cd.getPriority() && lastRequest.hasRequestedCourse() && lastRequest.getRequestedCourse(0).isFreeTime()) {
                        lastRequest.getRequestedCourse(0).addFreeTime(ft);
                        continue;
                    }
                    r = new CourseRequestInterface.Request();
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.addFreeTime(ft);
                    r.addRequestedCourse(rc);
                    if (cd.isAlternative().booleanValue()) {
                        request.getAlternatives().add(r);
                    } else {
                        request.getCourses().add(r);
                    }
                    lastRequest = r;
                    lastRequestPriority = cd.getPriority();
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    continue;
                }
                if (cd.getCourseRequests().isEmpty()) continue;
                r = new CourseRequestInterface.Request();
                for (CourseRequest course : new TreeSet<CourseRequest>(cd.getCourseRequests())) {
                    courseIds.add(course.getCourseOffering().getUniqueId());
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseId(course.getCourseOffering().getUniqueId());
                    rc.setCourseName(course.getCourseOffering().getSubjectAreaAbbv() + " " + course.getCourseOffering().getCourseNbr() + (String)(!CONSTANTS.showCourseTitle() ? "" : " - " + course.getCourseOffering().getTitle()));
                    rc.setCourseTitle(course.getCourseOffering().getTitle());
                    CourseCreditUnitConfig credit = course.getCourseOffering().getCredit();
                    if (credit != null) {
                        rc.setCredit(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                    }
                    boolean hasEnrollments = !course.getClassEnrollments().isEmpty();
                    rc.setReadOnly(hasEnrollments);
                    rc.setCanDelete(!hasEnrollments);
                    rc.setCanWaitList(course.getCourseOffering().getInstructionalOffering().effectiveWaitList());
                    if (hasEnrollments) {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                    } else if (course.getOverrideStatus() != null) {
                        rc.setStatus(course.isRequestApproved() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED : (course.isRequestRejected() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED : (course.isRequestCancelled() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED : (course.isRequestNeeded() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : (course.isRequestNotNeeded() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED : CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING)))));
                    } else {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                    if (hasEnrollments) {
                        if (enrolledNoAlternatives) {
                            rc.setCanChangeAlternatives(false);
                        }
                        if (enrolledNoPriority) {
                            rc.setCanChangePriority(false);
                        }
                    }
                    if (setReadOnlyWhenReserved) {
                        for (Reservation reservation : course.getCourseOffering().getInstructionalOffering().getReservations()) {
                            if (!(reservation instanceof IndividualReservation) && !(reservation instanceof StudentGroupReservation) && !(reservation instanceof LearningCommunityReservation) || !reservation.isMustBeUsed() || reservation.isExpired() || !reservation.isApplicable(student, course)) continue;
                            rc.setReadOnly(true);
                            rc.setCanDelete(false);
                            if (reservedNoAlternatives) {
                                rc.setCanChangeAlternatives(false);
                            }
                            if (!reservedNoPriority) break;
                            rc.setCanChangePriority(false);
                            break;
                        }
                    }
                    rc.setOverrideExternalId(course.getOverrideExternalId());
                    rc.setOverrideTimeStamp(course.getOverrideTimeStamp());
                    if (course.getPreferences() != null) {
                        for (StudentSectioningPref ssp : course.getPreferences()) {
                            if (ssp instanceof StudentClassPref) {
                                StudentClassPref scp = (StudentClassPref)ssp;
                                rc.setSelectedClass(scp.getClazz().getUniqueId(), scp.getClazz().getClassPrefLabel(course.getCourseOffering()), scp.isRequired(), true);
                                continue;
                            }
                            if (!(ssp instanceof StudentInstrMthPref)) continue;
                            StudentInstrMthPref imp = (StudentInstrMthPref)ssp;
                            rc.setSelectedIntructionalMethod(imp.getInstructionalMethod().getUniqueId(), imp.getInstructionalMethod().getLabel(), imp.isRequired(), true);
                        }
                    }
                    r.addRequestedCourse(rc);
                }
                if (r.hasRequestedCourse()) {
                    if (cd.isAlternative().booleanValue()) {
                        request.getAlternatives().add(r);
                    } else {
                        request.getCourses().add(r);
                    }
                }
                r.setWaitList(cd.effectiveWaitList());
                r.setNoSub(cd.effectiveNoSub());
                if (cd.getCriticalOverride() != null) {
                    r.setCritical(cd.getCriticalOverride());
                } else {
                    r.setCritical(cd.getCritical());
                }
                r.setTimeStamp(cd.getTimestamp());
                if (r.isWaitList()) {
                    r.setWaitListedTimeStamp(cd.getWaitlistedTimeStamp());
                }
                r.setWaitListSwapWithCourseOfferingId(cd.getWaitListSwapWithCourseOffering() == null ? null : cd.getWaitListSwapWithCourseOffering().getUniqueId());
                lastRequest = r;
                lastRequestPriority = cd.getPriority();
            }
        }
        if (!student.getClassEnrollments().isEmpty()) {
            TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
            for (StudentClassEnrollment enrl : student.getClassEnrollments()) {
                if (courseIds.contains(enrl.getCourseOffering().getUniqueId())) continue;
                courses.add(enrl.getCourseOffering());
            }
            for (CourseOffering c : courses) {
                CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                rc.setCourseId(c.getUniqueId());
                rc.setCourseName(c.getSubjectAreaAbbv() + " " + c.getCourseNbr() + (String)(!CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                rc.setCourseTitle(c.getTitle());
                rc.setCanWaitList(c.getInstructionalOffering().effectiveWaitList());
                CourseCreditUnitConfig credit = c.getCredit();
                if (credit != null) {
                    rc.setCredit(Float.valueOf(credit.getMinCredit()), Float.valueOf(credit.getMaxCredit()));
                }
                r.addRequestedCourse(rc);
                request.getCourses().add(r);
                rc.setReadOnly(true);
                rc.setCanDelete(false);
                rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
            }
        }
        if (CustomCourseRequestsValidationHolder.hasProvider() && (server = this.getServerInstance(student.getSession().getUniqueId(), true)) != null) {
            try {
                return server.execute(server.createAction(CustomCourseRequestsValidationHolder.Check.class).withRequest(request), this.currentUser());
            }
            catch (SectioningException e) {
                sLog.warn((Object)("Failed to validate course requests: " + e.getMessage()), (Throwable)e);
            }
        }
        return request;
    }

    @Override
    public CourseRequestInterface savedRequest(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        boolean includeAdvisorRequests;
        this.checkContext(cx);
        if (cx.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        if (!cx.isOnline()) {
            StudentSolverProxy server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
            return server.execute(server.createAction(GetRequest.class).forStudent(cx.getStudentId(), cx.isSectioning()).withWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs), this.currentUser(cx));
        }
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId() == null ? this.canEnroll(cx) : cx.getSessionId(), false);
        OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(cx);
        boolean bl = includeAdvisorRequests = cx.isSectioning() && ApplicationProperty.AdvisorCourseRequestsPrepopulateSchedulingAssistant.isTrue() || !cx.isSectioning() && last != null && last.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER) && ApplicationProperty.AdvisorCourseRequestsPrepopulateCourseRequests.isTrue();
        if (server != null) {
            return server.execute(server.createAction(GetRequest.class).forStudent(cx.getStudentId(), cx.isSectioning()).withCustomValidation(!cx.isSectioning()).withWaitListValidation(cx.isSectioning()).withCourseMatcher(this.getCourseMatcher(cx, server)).withAdvisorRequests(includeAdvisorRequests), this.currentUser(cx));
        }
        try (Session hibSession = StudentDAO.getInstance().getSession();){
            Student student = (Student)StudentDAO.getInstance().get(cx.getStudentId(), hibSession);
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            CourseRequestInterface request = this.getRequest(student);
            if (request.isEmpty() && CustomCourseRequestsHolder.hasProvider()) {
                OnlineSectioningHelper helper = new OnlineSectioningHelper(hibSession, this.currentUser(cx));
                CourseRequestInterface r = CustomCourseRequestsHolder.getProvider().getCourseRequests(this.getServerInstance(cx.getSessionId(), true), helper, new XStudentId(student, helper), this.getCourseMatcher(cx, server));
                if (r != null && !r.isEmpty()) {
                    CourseRequestInterface courseRequestInterface = r;
                    return courseRequestInterface;
                }
            }
            if (includeAdvisorRequests && student.getLastChangedByStudent() == null && request.applyAdvisorRequests(AdvisorGetCourseRequests.getRequest(student, hibSession))) {
                request.setPopupMessage(ApplicationProperty.PopupMessageCourseRequestsPrepopulatedWithAdvisorRecommendations.value());
            }
            CourseRequestInterface courseRequestInterface = request;
            return courseRequestInterface;
        }
    }

    @Override
    public ClassAssignmentInterface savedResult(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.isOnline()) {
            OnlineSectioningServer server = this.getServerInstance(cx.getSessionId() == null ? this.canEnroll(cx) : cx.getSessionId(), false);
            ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(cx.getStudentId()), this.currentUser(cx));
            OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(cx);
            if (ret != null && last != null && last.hasGradeModes()) {
                for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                        OnlineSectioningInterface.GradeMode m = last.getGradeMode(a);
                        if (m == null) continue;
                        a.setGradeMode(m);
                    }
                }
            }
            if (ret != null && last != null && last.hasCreditHours()) {
                for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                        Float credit = last.getCreditHour(a);
                        a.setCreditHour(credit);
                        if (credit == null) continue;
                        a.setCredit(FixedCreditUnitConfig.formatCredit(credit.floatValue()));
                    }
                }
            }
            return ret;
        }
        StudentSolverProxy server = this.getStudentSolver();
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoSolver());
        }
        ClassAssignmentInterface ret = server.execute(server.createAction(GetAssignment.class).forStudent(cx.getStudentId()).withWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs), this.currentUser(cx));
        if (ret != null) {
            ret.setCanEnroll(cx.getStudentId() != null);
        }
        return ret;
    }

    @Override
    public Boolean selectSession(Long sessionId) {
        this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingLastSession, (Object)sessionId);
        UserContext user = this.getSessionContext().getUser();
        if (user != null && user.getCurrentAuthority() != null) {
            List<? extends UserAuthority> authorities = user.getAuthorities(user.getCurrentAuthority().getRole(), new SimpleQualifier("Session", sessionId));
            if (!authorities.isEmpty()) {
                user.setCurrentAuthority(authorities.get(0));
            } else {
                user.setCurrentAuthority(null);
            }
        }
        return true;
    }

    private OnlineSectioningInterface.StudentStatusInfo toStudentStatusInfo(StudentSectioningStatus status, List<CourseType> types, boolean admin, boolean advisor) {
        OnlineSectioningInterface.StudentStatusInfo info = new OnlineSectioningInterface.StudentStatusInfo();
        info.setUniqueId(status.getUniqueId());
        info.setReference(status.getReference());
        info.setLabel(status.getLabel());
        info.setCanAccessAssistantPage(status.hasOption(StudentSectioningStatus.Option.enabled));
        info.setCanAccessRequestsPage(status.hasOption(StudentSectioningStatus.Option.regenabled));
        info.setCanStudentEnroll(status.hasOption(StudentSectioningStatus.Option.enrollment));
        info.setCanStudentRegister(status.hasOption(StudentSectioningStatus.Option.registration));
        info.setCanAdvisorEnroll(status.hasOption(StudentSectioningStatus.Option.advisor));
        info.setCanAdvisorRegister(status.hasOption(StudentSectioningStatus.Option.regadvisor));
        info.setCanAdminEnroll(status.hasOption(StudentSectioningStatus.Option.admin));
        info.setCanAdminRegister(status.hasOption(StudentSectioningStatus.Option.regadmin));
        info.setWaitList(status.hasOption(StudentSectioningStatus.Option.waitlist));
        info.setNoSubs(status.hasOption(StudentSectioningStatus.Option.nosubs));
        info.setCanRequire(status.hasOption(StudentSectioningStatus.Option.canreq));
        info.setEmail(status.hasOption(StudentSectioningStatus.Option.email));
        info.setNoSchedule(status.hasOption(StudentSectioningStatus.Option.noschedule));
        info.setReSchedule(status.hasOption(StudentSectioningStatus.Option.reschedule));
        info.setMessage(status.getMessage());
        if (status.getFallBackStatus() != null) {
            info.setFallback(status.getFallBackStatus().getLabel());
        }
        if (!status.hasOption(StudentSectioningStatus.Option.notype)) {
            TreeSet<String> prohibited = new TreeSet<String>();
            for (CourseType courseType : types) {
                if (status.getTypes() != null && status.getTypes().contains(courseType)) continue;
                prohibited.add(courseType.getReference());
            }
            if (!prohibited.isEmpty()) {
                refs = "";
                for (String ref : prohibited) {
                    refs = (String)refs + (((String)refs).isEmpty() ? "" : ", ") + ref;
                }
                info.setCourseTypes(MSG.courseTypesAllBut((String)refs));
            }
        } else {
            TreeSet<String> allowed = new TreeSet<String>();
            for (CourseType courseType : status.getTypes()) {
                allowed.add(courseType.getReference());
            }
            if (allowed.isEmpty()) {
                info.setCourseTypes(MSG.courseTypesNoneAllowed());
            } else {
                refs = "";
                for (String ref : allowed) {
                    refs = (String)refs + (((String)refs).isEmpty() ? "" : ", ") + ref;
                }
                info.setCourseTypes(MSG.courseTypesAllowed((String)refs));
            }
        }
        if (status.getEffectiveStartDate() != null || status.getEffectiveStartPeriod() != null) {
            if (status.getEffectiveStartDate() == null) {
                info.setEffectiveStart(Constants.slot2str(status.getEffectiveStartPeriod()));
            } else if (status.getEffectiveStartPeriod() == null) {
                info.setEffectiveStart(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStartDate()));
            } else {
                info.setEffectiveStart(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStartDate()) + " " + Constants.slot2str(status.getEffectiveStartPeriod()));
            }
        }
        if (status.getEffectiveStopDate() != null || status.getEffectiveStopPeriod() != null) {
            if (status.getEffectiveStopDate() == null) {
                info.setEffectiveStop(Constants.slot2str(status.getEffectiveStopPeriod()));
            } else if (status.getEffectiveStopPeriod() == null) {
                info.setEffectiveStop(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStopDate()));
            } else {
                info.setEffectiveStop(Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(status.getEffectiveStopDate()) + " " + Constants.slot2str(status.getEffectiveStopPeriod()));
            }
        }
        Object notifications = "";
        for (StudentSectioningStatus.NotificationType notification : StudentSectioningStatus.NotificationType.values()) {
            if (!status.hasNotification(notification)) continue;
            notifications = (String)notifications + (((String)notifications).isEmpty() ? "" : ", ") + notification.label();
        }
        info.setNotifications((String)notifications);
        if (this.getSessionContext().hasPermission(Right.SchedulingAssistant)) {
            info.setCanUseAssistant(StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.enabled) || admin && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.admin) || advisor && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.advisor));
        }
        if (this.getSessionContext().hasPermission(Right.CourseRequests)) {
            info.setCanRegister(StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.regenabled) || admin && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.regadmin) || advisor && StudentSectioningStatus.hasEffectiveOption(status, null, StudentSectioningStatus.Option.regadvisor));
        }
        return info;
    }

    @Override
    public List<OnlineSectioningInterface.StudentStatusInfo> lookupStudentSectioningStates() throws SectioningException, PageAccessException {
        List courseTypes = CourseTypeDAO.getInstance().getSession().createQuery("select distinct t from CourseOffering c inner join c.courseType t where c.instructionalOffering.session.uniqueId = :sessionId order by t.reference", CourseType.class).setParameter("sessionId", (Object)this.getStatusPageSessionId()).setCacheable(true).list();
        ArrayList<OnlineSectioningInterface.StudentStatusInfo> ret = new ArrayList<OnlineSectioningInterface.StudentStatusInfo>();
        boolean advisor = this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]);
        boolean admin = this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]);
        boolean email = true;
        boolean waitlist = CustomStudentEnrollmentHolder.isAllowWaitListing();
        boolean specreg = CustomSpecialRegistrationHolder.hasProvider();
        boolean reqval = CustomCourseRequestsValidationHolder.hasProvider();
        if (admin) {
            org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(this.getStatusPageSessionId());
            OnlineSectioningInterface.StudentStatusInfo info = null;
            if (session.getDefaultSectioningStatus() != null) {
                StudentSectioningStatus s = session.getDefaultSectioningStatus();
                info = this.toStudentStatusInfo(s, courseTypes, admin, advisor);
                info.setUniqueId(null);
                info.setReference("");
                info.setLabel(MSG.studentStatusSessionDefault(session.getDefaultSectioningStatus().getLabel()));
                info.setEmail(email && s.hasOption(StudentSectioningStatus.Option.email));
                info.setWaitList(waitlist && s.hasOption(StudentSectioningStatus.Option.waitlist));
                info.setSpecialRegistration(specreg && s.hasOption(StudentSectioningStatus.Option.specreg));
                info.setRequestValiadtion(reqval && s.hasOption(StudentSectioningStatus.Option.reqval));
                info.setReSchedule(waitlist && s.hasOption(StudentSectioningStatus.Option.reschedule));
            } else {
                info = new OnlineSectioningInterface.StudentStatusInfo();
                info.setReference("");
                info.setLabel(MSG.studentStatusSystemDefault());
                info.setAllEnabled();
                info.setEmail(email);
                info.setWaitList(waitlist);
                info.setSpecialRegistration(specreg);
                info.setRequestValiadtion(reqval);
                info.setReSchedule(waitlist);
            }
            ret.add(info);
        }
        for (StudentSectioningStatus s : StudentSectioningStatus.findAll(this.getStatusPageSessionId())) {
            if (s.isPast() || advisor && !admin && !s.hasOption(StudentSectioningStatus.Option.advcanset)) continue;
            OnlineSectioningInterface.StudentStatusInfo info = this.toStudentStatusInfo(s, courseTypes, admin, advisor);
            info.setEmail(email && s.hasOption(StudentSectioningStatus.Option.email));
            info.setWaitList(waitlist && s.hasOption(StudentSectioningStatus.Option.waitlist));
            info.setSpecialRegistration(specreg && s.hasOption(StudentSectioningStatus.Option.specreg));
            info.setRequestValiadtion(reqval && s.hasOption(StudentSectioningStatus.Option.reqval));
            ret.add(info);
        }
        return ret;
    }

    @Override
    public Boolean sendEmail(Long sessionId, Long studentId, String subject, String message, String cc, Boolean courseRequests, Boolean classSchedule, Boolean advisorRequests, Boolean optional, String sourceOperation) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server;
            if (sessionId == null) {
                sessionId = this.getStatusPageSessionId();
            }
            if ((server = this.getServerInstance(sessionId, true)) == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingEmailStudent, new Qualifiable[0]);
            if (!this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(sessionId);
                if (!myStudentIds.contains(studentId)) {
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingEmailStudent.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            StudentEmail email = server.createAction(StudentEmail.class).forStudent(studentId);
            if (courseRequests != null && classSchedule != null && advisorRequests != null) {
                email.overridePermissions(courseRequests, classSchedule, advisorRequests);
                if (advisorRequests.booleanValue() && !courseRequests.booleanValue() && !classSchedule.booleanValue()) {
                    email.includeAdvisorRequestsPDF();
                }
            }
            if (sourceOperation != null) {
                email.fromAction(sourceOperation);
            }
            email.setCC(cc);
            email.setEmailSubject(subject == null || subject.isEmpty() ? (classSchedule.booleanValue() ? MSG.defaulSubject() : (courseRequests.booleanValue() ? MSG.defaulSubjectCourseRequests() : (advisorRequests.booleanValue() ? MSG.defaulSubjectAdvisorRequests() : MSG.defaulSubjectOther()))) : subject);
            email.setOptional(optional);
            email.setMessage(message);
            return server.execute(email, this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean changeStatus(List<Long> studentIds, String note, String ref) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingChangeStudentStatus);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                for (Long studentId : studentIds) {
                    if (myStudentIds.contains(studentId)) continue;
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingChangeStudentStatus.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            Boolean ret = server.execute(server.createAction(ChangeStudentStatus.class).forStudents(studentIds).withStatus(ref).withNote(note), this.currentUser());
            try {
                SessionFactory hibSessionFactory = SessionDAO.getInstance().getSession().getSessionFactory();
                for (Long studentId : studentIds) {
                    hibSessionFactory.getCache().evictEntityData(Student.class, (Object)studentId);
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to evict cache: " + e.getMessage()));
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public Boolean changeStudentGroup(List<Long> studentIds, Long groupId, boolean remove) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingChangeStudentGroup);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                for (Long studentId : studentIds) {
                    if (myStudentIds.contains(studentId)) continue;
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingChangeStudentGroup.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            return server.execute(server.createAction(ChangeStudentGroup.class).forStudents(studentIds).withGroup(groupId, remove), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private OnlineSectioningLog.Entity currentUser() {
        return this.currentUser(null);
    }

    private OnlineSectioningLog.Entity currentUser(OnlineSectioningInterface.StudentSectioningContext cx) {
        UserContext user = this.getSessionContext().getUser();
        UniTimePrincipal principal = (UniTimePrincipal)this.getSessionContext().getAttribute(SessionAttribute.OnlineSchedulingUser);
        if (user != null) {
            OnlineSectioningLog.Entity.Builder entity = OnlineSectioningLog.Entity.newBuilder().setExternalId(user.getTrueExternalUserId()).setName(user.getTrueName() == null ? user.getUsername() : user.getTrueName()).setType(user instanceof UserContext.Chameleon || principal != null ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT);
            if (cx != null && cx.hasPin()) {
                entity.addParameterBuilder().setKey("pin").setValue(cx.getPin());
            }
            if (principal != null && principal.getStudentExternalId() != null) {
                entity.addParameterBuilder().setKey("student").setValue(principal.getStudentExternalId());
            }
            if (cx != null && cx.getAcademicSessionId() != null) {
                entity.addParameterBuilder().setKey("admin").setValue(this.getSessionContext().hasPermissionAnySession((Object)cx.getAcademicSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) ? "true" : "false");
                entity.addParameterBuilder().setKey("advisor").setValue(this.getSessionContext().hasPermissionAnySession((Object)cx.getAcademicSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) ? "true" : "false");
            } else {
                entity.addParameterBuilder().setKey("admin").setValue(this.getSessionContext().hasPermission(Right.StudentSchedulingAdmin) ? "true" : "false");
                entity.addParameterBuilder().setKey("advisor").setValue(this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor) ? "true" : "false");
            }
            return entity.build();
        }
        if (principal != null) {
            OnlineSectioningLog.Entity.Builder entity = OnlineSectioningLog.Entity.newBuilder().setExternalId(principal.getExternalId()).setName(principal.getName()).setType(OnlineSectioningLog.Entity.EntityType.MANAGER);
            if (cx != null && cx.hasPin()) {
                entity.addParameterBuilder().setKey("pin").setValue(cx.getPin());
            }
            if (cx != null && cx.getAcademicSessionId() != null) {
                entity.addParameterBuilder().setKey("admin").setValue(this.getSessionContext().hasPermissionAnySession((Object)cx.getAcademicSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) ? "true" : "false");
                entity.addParameterBuilder().setKey("advisor").setValue(this.getSessionContext().hasPermissionAnySession((Object)cx.getAcademicSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) ? "true" : "false");
            } else {
                entity.addParameterBuilder().setKey("admin").setValue(this.getSessionContext().hasPermission(Right.StudentSchedulingAdmin) ? "true" : "false");
                entity.addParameterBuilder().setKey("advisor").setValue(this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisor) ? "true" : "false");
            }
            return entity.build();
        }
        return null;
    }

    @Override
    public List<ClassAssignmentInterface.SectioningAction> changeLog(String query) throws SectioningException, PageAccessException {
        Long sessionId = this.getStatusPageSessionId();
        OnlineSectioningServer server = this.getServerInstance(sessionId, true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (server instanceof DatabaseServer) {
            return server.execute(server.createAction(DbFindOnlineSectioningLogAction.class).forQuery(query, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)), this.currentUser());
        }
        return server.execute(server.createAction(FindOnlineSectioningLogAction.class).forQuery(query, this.sessionContext.hasPermission(Right.EnrollmentsShowExternalId)), this.currentUser());
    }

    @Override
    public Boolean massCancel(List<Long> studentIds, String statusRef, String subject, String message, String cc) throws SectioningException, PageAccessException {
        try {
            OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), false);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingMassCancel);
            if (!this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]) && this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]) && !this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                this.getSessionContext().checkPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents);
                HashSet<Long> myStudentIds = this.getMyStudents(this.getStatusPageSessionId());
                for (Long studentId : studentIds) {
                    if (myStudentIds.contains(studentId)) continue;
                    Student student = (Student)StudentDAO.getInstance().get(studentId);
                    throw new PageAccessException(SEC_MSG.permissionCheckFailed(Right.StudentSchedulingMassCancel.toString(), student == null ? studentId.toString() : student.getName(NameFormat.LAST_FIRST_MIDDLE.reference())));
                }
            }
            return server.execute(server.createAction(MassCancelAction.class).forStudents(studentIds).withStatus(statusRef).withEmail(subject, message, cc), this.currentUser());
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    @Override
    public OnlineSectioningInterface.EligibilityCheck checkEligibility(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        return this.checkEligibility(cx, true);
    }

    protected void checkContext(OnlineSectioningInterface.StudentSectioningContext cx) {
        Student student;
        if (cx.getSessionId() == null && cx.getStudentId() != null && (student = (Student)StudentDAO.getInstance().get(cx.getStudentId())) != null) {
            cx.setSessionId(student.getSession().getUniqueId());
            sLog.info((Object)("ContextCheck: session " + student.getSession().getLabel() + " guessed from student id " + student.getExternalUniqueId()));
        }
        if (cx.getSessionId() == null) {
            cx.setSessionId(this.getLastSessionId());
            sLog.info((Object)("ContextCheck: no session id, using last/current session instead (" + cx.getSessionId() + ")"));
        } else {
            this.setLastSessionId(cx.getSessionId());
        }
        if (cx.getStudentId() == null && cx.getSessionId() != null) {
            cx.setStudentId(this.getStudentId(cx.getSessionId()));
            sLog.debug((Object)("ContextCheck: student id " + cx.getStudentId() + " guessed from session id " + cx.getSessionId()));
        }
        if (cx.getStudentId() == null) {
            sLog.debug((Object)"ContextCheck: no student id (assuming guess access)");
        }
        if (cx.getStudentId() != null && !cx.getStudentId().equals(this.getStudentId(cx.getSessionId()))) {
            boolean check = this.getSessionContext().hasPermissionAnySession((Object)cx.getSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]);
            if (check) {
                sLog.debug((Object)("ContextCheck: different student id, permission check: " + check));
            } else {
                sLog.info((Object)("ContextCheck: different student id, permission check: " + check));
            }
        }
    }

    public OnlineSectioningInterface.EligibilityCheck checkEligibility(OnlineSectioningInterface.StudentSectioningContext cx, boolean includeCustomCheck) throws SectioningException, PageAccessException {
        try {
            this.checkContext(cx);
            if (includeCustomCheck) {
                this.getSessionContext().removeAttribute(SessionAttribute.OnlineSchedulingEligibility);
            }
            if (!cx.isOnline()) {
                StudentSolverProxy server = this.getStudentSolver();
                if (server == null) {
                    return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoSolver(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
                }
                OnlineSectioningInterface.EligibilityCheck check = new OnlineSectioningInterface.EligibilityCheck();
                check.setSessionId(server.getAcademicSession().getUniqueId());
                check.setStudentId(cx.getStudentId());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, !server.isPublished());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, false);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_NO_SUBS, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.SolverDashboardAllowScheduleReset.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_DROP, ApplicationProperty.OnlineSchedulingConfirmCourseDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.QUICK_ADD_DROP, ApplicationProperty.OnlineSchedulingQuickAddDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.ALTERNATIVES_DROP, ApplicationProperty.OnlineSchedulingAlternativesDrop.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.GWT_CONFIRMATIONS, ApplicationProperty.OnlineSchedulingGWTConfirmations.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.DEGREE_PLANS, ApplicationProperty.DegreePlanForStudents.isTrue() && CustomDegreePlansHolder.hasProvider());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.NO_REQUEST_ARROWS, ApplicationProperty.OnlineSchedulingNoRequestArrows.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_LONG_TRAVEL, ApplicationProperty.OnlineSchedulingConfirmLongTravel.isTrue());
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, true);
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SHOW_SCHEDULING_PREFS, false);
                return check;
            }
            if (cx.getSessionId() == null) {
                return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoAcademicSession(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                return new OnlineSectioningInterface.EligibilityCheck(this.getSessionContext().isHttpSessionNew() ? MSG.exceptionHttpSessionExpired() : MSG.exceptionLoginRequired(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            OnlineSectioningInterface.EligibilityCheck check = new OnlineSectioningInterface.EligibilityCheck();
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN, this.getSessionContext().hasPermissionAnySession((Object)cx.getSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]));
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR, this.getSessionContext().hasPermissionAnySession((Object)cx.getSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]));
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST, user instanceof AnonymousUserContext);
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.OnlineSchedulingAllowScheduleReset.isTrue());
            if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET) && (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR))) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_RESET, ApplicationProperty.OnlineSchedulingAllowScheduleResetIfAdmin.isTrue());
            }
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_DROP, ApplicationProperty.OnlineSchedulingConfirmCourseDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.QUICK_ADD_DROP, ApplicationProperty.OnlineSchedulingQuickAddDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.ALTERNATIVES_DROP, ApplicationProperty.OnlineSchedulingAlternativesDrop.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.GWT_CONFIRMATIONS, ApplicationProperty.OnlineSchedulingGWTConfirmations.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.DEGREE_PLANS, ApplicationProperty.DegreePlanForStudents.isTrue() && CustomDegreePlansHolder.hasProvider());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.NO_REQUEST_ARROWS, ApplicationProperty.OnlineSchedulingNoRequestArrows.isTrue());
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SHOW_SCHEDULING_PREFS, ApplicationProperty.OnlineSchedulingStudentPreferencesEnabled.isTrue() && cx.getStudentId() != null);
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CONFIRM_LONG_TRAVEL, ApplicationProperty.OnlineSchedulingConfirmLongTravel.isTrue());
            check.setSessionId(cx.getSessionId());
            check.setStudentId(cx.getStudentId());
            if (!cx.isSectioning()) {
                OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), true);
                if (server == null) {
                    Student student;
                    Student student2 = student = cx.getStudentId() == null ? null : (Student)StudentDAO.getInstance().get(cx.getStudentId());
                    if (student == null) {
                        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                            check.setMessage(MSG.exceptionEnrollNotStudent(((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(cx.getSessionId())).getLabel()));
                        }
                        return check;
                    }
                    StudentSectioningStatus status = student.getEffectiveStatus();
                    if (status == null) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, true);
                    } else {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, status.hasOption(StudentSectioningStatus.Option.regenabled) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && status.hasOption(StudentSectioningStatus.Option.regadmin) || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) && status.hasOption(StudentSectioningStatus.Option.regadvisor));
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, status.hasOption(StudentSectioningStatus.Option.waitlist));
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_NO_SUBS, status.hasOption(StudentSectioningStatus.Option.nosubs));
                        check.setMessage(status.getMessage());
                    }
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, this.getSessionContext().hasPermissionAnyAuthority((Object)student, Right.StudentSchedulingCanRegister, new Qualifiable[0]));
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, this.getSessionContext().hasPermissionAnyAuthority((Object)student, Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0]));
                    check.setAdvisorWaitListedCourseIds(student.getAdvisorWaitListedCourseIds(null));
                } else {
                    check = server.execute(server.createAction(CourseRequestEligibility.class).forStudent(cx.getStudentId()).withCheck(check).includeCustomCheck(includeCustomCheck).withPermission(this.getSessionContext().hasPermissionAnyAuthority(cx.getStudentId(), "Student", Right.StudentSchedulingCanRegister, new Qualifiable[0]), this.getSessionContext().hasPermissionAnyAuthority(cx.getStudentId(), "Student", Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0])), this.currentUser(cx));
                }
                if (includeCustomCheck) {
                    this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingEligibility, (Object)check);
                }
                return check;
            }
            OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
            if (server == null) {
                return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionNoServerForSession(), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
            }
            OnlineSectioningInterface.EligibilityCheck ret = server.execute(server.createAction(CheckEligibility.class).forStudent(cx.getStudentId()).withCheck(check).includeCustomCheck(includeCustomCheck).withPermission(this.getSessionContext().hasPermissionAnyAuthority(cx.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]), this.getSessionContext().hasPermissionAnyAuthority(cx.getStudentId(), "Student", Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0])), this.currentUser(cx));
            if (includeCustomCheck) {
                this.getSessionContext().setAttribute(SessionAttribute.OnlineSchedulingEligibility, (Object)ret);
            }
            return ret;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return new OnlineSectioningInterface.EligibilityCheck(MSG.exceptionUnknown(e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : (e.getCause() != null ? e.getCause().getClass().getSimpleName() : e.getClass().getSimpleName())), new OnlineSectioningInterface.EligibilityCheck.EligibilityFlag[0]);
        }
    }

    public void destroy() throws Exception {
        for (Customization customization : Customization.values()) {
            customization.release();
        }
    }

    @Override
    public OnlineSectioningInterface.SectioningProperties getProperties(Long sessionId) throws SectioningException, PageAccessException {
        OnlineSectioningInterface.SectioningProperties properties = new OnlineSectioningInterface.SectioningProperties();
        properties.setAdmin(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0]));
        properties.setAdvisor(this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]));
        if (sessionId == null && this.getSessionContext().getUser() != null) {
            sessionId = this.getSessionContext().getUser().getCurrentAcademicSessionId();
        }
        properties.setSessionId(sessionId);
        if (sessionId != null) {
            org.unitime.timetable.model.Session session = (org.unitime.timetable.model.Session)SessionDAO.getInstance().get(sessionId);
            properties.setChangeLog(properties.isAdmin() && this.getServerInstance(sessionId, true) != null);
            properties.setMassCancel(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingMassCancel));
            properties.setEmail(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingEmailStudent));
            properties.setChangeStatus(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingChangeStudentStatus));
            properties.setRequestUpdate(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingRequestStudentUpdate));
            properties.setReloadStudent(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingReloadStudent));
            properties.setCheckStudentOverrides(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingCheckStudentOverrides));
            properties.setValidateStudentOverrides(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingValidateStudentOverrides));
            properties.setRecheckCriticalCourses(this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingRecheckCriticalCourses));
            properties.setAdvisorCourseRequests(this.getSessionContext().hasPermission(sessionId, Right.AdvisorCourseRequests) && session != null && (session.getStatusType().canPreRegisterStudents() || session.getStatusType().canOnlineSectionStudents()));
            if (properties.isEmail() && Customization.StudentEmailProvider.hasProvider()) {
                StudentEmailProvider email = (StudentEmailProvider)Customization.StudentEmailProvider.getProvider();
                properties.setEmailOptionalToggleCaption(email.getToggleCaptionIfOptional());
                properties.setEmailOptionalToggleDefault(email.isOptionCheckedByDefault());
            }
            if (this.getSessionContext().hasPermission(sessionId, Right.StudentSchedulingChangeStudentGroup)) {
                for (StudentGroup g : StudentGroupDAO.getInstance().getSession().createQuery("from StudentGroup g where g.type.advisorsCanSet = true and g.session.uniqueId = :sessionId order by g.groupAbbreviation", StudentGroup.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
                    properties.addEditableGroup(new OnlineSectioningInterface.StudentGroupInfo(g.getUniqueId(), g.getGroupAbbreviation(), g.getGroupName(), g.getType() == null ? null : g.getType().getReference()));
                }
            }
        }
        return properties;
    }

    @Override
    public Boolean requestStudentUpdate(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingRequestStudentUpdate);
        return server.execute(server.createAction(RequestStudentUpdates.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public Boolean reloadStudent(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingReloadStudent);
        return server.execute(server.createAction(ReloadStudent.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public Boolean checkStudentOverrides(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingCheckStudentOverrides);
        Boolean r1 = server.execute(server.createAction(CustomCourseRequestsValidationHolder.Update.class).forStudents(studentIds), this.currentUser());
        Boolean r2 = server.execute(server.createAction(CustomWaitListValidationHolder.Update.class).forStudents(studentIds), this.currentUser());
        return r1 != false || r2 != false;
    }

    @Override
    public Boolean validateStudentOverrides(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingValidateStudentOverrides);
        Boolean r1 = server.execute(server.createAction(CustomCourseRequestsValidationHolder.Validate.class).forStudents(studentIds), this.currentUser());
        Boolean r2 = server.execute(server.createAction(CustomWaitListValidationHolder.Validate.class).forStudents(studentIds), this.currentUser());
        return r1 != false || r2 != false;
    }

    @Override
    public Boolean recheckCriticalCourses(List<Long> studentIds) throws SectioningException, PageAccessException {
        OnlineSectioningServer server = this.getServerInstance(this.getStatusPageSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        this.getSessionContext().checkPermission(server.getAcademicSession(), Right.StudentSchedulingRecheckCriticalCourses);
        return server.execute(server.createAction(CustomCriticalCoursesHolder.CheckCriticalCourses.class).forStudents(studentIds), this.currentUser());
    }

    @Override
    public List<DegreePlanInterface> listDegreePlans(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        if (!cx.getStudentId().equals(this.getStudentId(cx.getSessionId())) && !this.getSessionContext().hasPermissionAnySession((Object)cx.getSessionId(), Right.AdvisorCourseRequests, new Qualifiable[0])) {
            this.getSessionContext().checkPermissionAnySession((Object)cx.getSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]);
        }
        OnlineSectioningServer server = null;
        if (!cx.isOnline()) {
            server = this.getStudentSolver();
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoSolver());
            }
        } else {
            server = this.getServerInstance(cx.getSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
        }
        CourseMatcher matcher = this.getCourseMatcher(cx, server);
        return server.execute(server.createAction(GetDegreePlans.class).forStudent(cx.getStudentId()).withMatcher(matcher), this.currentUser(cx));
    }

    @Override
    public ClassAssignmentInterface.Student lookupStudent(boolean online, String studentId) throws SectioningException, PageAccessException {
        if (this.getSessionContext().getUser() == null || this.getSessionContext().getUser().getCurrentAcademicSessionId() == null) {
            return null;
        }
        Student student = Student.findByExternalId(this.getSessionContext().getUser().getCurrentAcademicSessionId(), studentId);
        if (student == null) {
            return null;
        }
        this.getSessionContext().checkPermission(student, Right.StudentEnrollments);
        ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
        st.setId(student.getUniqueId());
        st.setSessionId(this.getSessionContext().getUser().getCurrentAcademicSessionId());
        st.setExternalId(student.getExternalUniqueId());
        st.setCanShowExternalId(this.getSessionContext().hasPermission(Right.EnrollmentsShowExternalId));
        st.setCanRegister(this.getSessionContext().hasPermission(Right.CourseRequests) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanRegister));
        st.setCanUseAssistant(online ? this.getSessionContext().hasPermission(Right.SchedulingAssistant) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanEnroll) : this.getStudentSolver() != null);
        st.setName(student.getName(ApplicationProperty.OnlineSchedulingStudentNameFormat.value()));
        StudentSectioningStatus status = student.getEffectiveStatus();
        if (CustomStudentEnrollmentHolder.isAllowWaitListing() && (status == null || status.hasOption(StudentSectioningStatus.Option.waitlist))) {
            st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
        } else if (status != null && status.hasOption(StudentSectioningStatus.Option.nosubs)) {
            st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
        } else {
            st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
        }
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
            st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicArea().getTitle());
            st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getAcademicClassification().getName());
            st.addMajor(studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getMajor().getName());
            st.addConcentration(studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getName());
            st.addDegree(studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getLabel());
            st.addProgram(studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getLabel());
            st.addCampus(studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getReference(), studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getLabel());
        }
        st.setDefaultCampus(student.getSession().getAcademicInitiative());
        for (StudentAreaClassificationMinor studentAreaClassificationMinor : new TreeSet<StudentAreaClassificationMinor>(student.getAreaClasfMinors())) {
            st.addMinor(studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor.getMinor().getName());
        }
        for (StudentGroup studentGroup : student.getGroups()) {
            if (studentGroup.getType() == null) {
                st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                continue;
            }
            st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
        }
        for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
            st.addAccommodation(studentAccomodation.getAbbreviation(), studentAccomodation.getName());
        }
        for (Advisor advisor : student.getAdvisors()) {
            if (advisor.getLastName() == null) continue;
            st.addAdvisor(NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value()).format(advisor));
        }
        return st;
    }

    @Override
    public SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitSpecialRequest(SpecialRegistrationInterface.SubmitSpecialRegistrationRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(SpecialRegistrationSubmit.class).withRequest(request), this.currentUser());
    }

    @Override
    public SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse checkSpecialRequestEligibility(SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(SpecialRegistrationEligibility.class).withRequest(request), this.currentUser());
    }

    @Override
    public List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> retrieveAllSpecialRequests(SpecialRegistrationInterface.RetrieveAllSpecialRegistrationsRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(SpecialRegistrationRetrieveAll.class).withRequest(request), this.currentUser());
    }

    @Override
    public ClassAssignmentInterface.Student lookupStudent(boolean online, Long studentId) throws SectioningException, PageAccessException {
        if (this.getSessionContext().getUser() == null || this.getSessionContext().getUser().getCurrentAcademicSessionId() == null) {
            return null;
        }
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        if (student == null) {
            return null;
        }
        this.getSessionContext().checkPermission(student, Right.StudentEnrollments);
        ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
        st.setId(student.getUniqueId());
        st.setSessionId(this.getSessionContext().getUser().getCurrentAcademicSessionId());
        st.setExternalId(student.getExternalUniqueId());
        st.setCanShowExternalId(this.getSessionContext().hasPermission(Right.EnrollmentsShowExternalId));
        st.setCanRegister(this.getSessionContext().hasPermission(Right.CourseRequests) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanRegister));
        st.setCanUseAssistant(online ? this.getSessionContext().hasPermission(Right.SchedulingAssistant) && this.getSessionContext().hasPermission(student, Right.StudentSchedulingCanEnroll) : this.getStudentSolver() != null);
        st.setName(student.getName(ApplicationProperty.OnlineSchedulingStudentNameFormat.value()));
        StudentSectioningStatus status = student.getEffectiveStatus();
        if (CustomStudentEnrollmentHolder.isAllowWaitListing() && (status == null || status.hasOption(StudentSectioningStatus.Option.waitlist))) {
            st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
        } else if (status != null && status.hasOption(StudentSectioningStatus.Option.nosubs)) {
            st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
        } else {
            st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
        }
        for (StudentAreaClassificationMajor studentAreaClassificationMajor : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
            st.addArea(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation(), studentAreaClassificationMajor.getAcademicArea().getTitle());
            st.addClassification(studentAreaClassificationMajor.getAcademicClassification().getCode(), studentAreaClassificationMajor.getAcademicClassification().getName());
            st.addMajor(studentAreaClassificationMajor.getMajor().getCode(), studentAreaClassificationMajor.getMajor().getName());
            st.addConcentration(studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getCode(), studentAreaClassificationMajor.getConcentration() == null ? null : studentAreaClassificationMajor.getConcentration().getName());
            st.addDegree(studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getReference(), studentAreaClassificationMajor.getDegree() == null ? null : studentAreaClassificationMajor.getDegree().getLabel());
            st.addProgram(studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getReference(), studentAreaClassificationMajor.getProgram() == null ? null : studentAreaClassificationMajor.getProgram().getLabel());
            st.addCampus(studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getReference(), studentAreaClassificationMajor.getCampus() == null ? null : studentAreaClassificationMajor.getCampus().getLabel());
        }
        st.setDefaultCampus(student.getSession().getAcademicInitiative());
        for (StudentAreaClassificationMinor studentAreaClassificationMinor : new TreeSet<StudentAreaClassificationMinor>(student.getAreaClasfMinors())) {
            st.addMinor(studentAreaClassificationMinor.getMinor().getCode(), studentAreaClassificationMinor.getMinor().getName());
        }
        for (StudentGroup studentGroup : student.getGroups()) {
            if (studentGroup.getType() == null) {
                st.addGroup(studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
                continue;
            }
            st.addGroup(studentGroup.getType().getReference(), studentGroup.getGroupAbbreviation(), studentGroup.getGroupName());
        }
        for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
            st.addAccommodation(studentAccomodation.getAbbreviation(), studentAccomodation.getName());
        }
        for (Advisor advisor : student.getAdvisors()) {
            if (advisor.getLastName() == null) continue;
            st.addAdvisor(NameFormat.fromReference(ApplicationProperty.OnlineSchedulingInstructorNameFormat.value()).format(advisor));
        }
        st.setCanSelect(this.getSessionContext().hasPermission(student.getSession(), Right.AdvisorCourseRequests) || this.getSessionContext().hasPermission(student.getSession(), Right.StudentSchedulingEmailStudent));
        return st;
    }

    @Override
    public ClassAssignmentInterface section(CourseRequestInterface request, List<ClassAssignmentInterface.ClassAssignment> currentAssignment, List<ClassAssignmentInterface.ClassAssignment> specialRegistration) throws SectioningException, PageAccessException {
        try {
            this.checkContext(request);
            OnlineSectioningServer server = this.getServerInstance(request.getAcademicSessionId(), true);
            if (server == null) {
                throw new SectioningException(MSG.exceptionNoServerForSession());
            }
            ClassAssignmentInterface ret = server.execute(server.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(currentAssignment).withSpecialRegistration(specialRegistration), this.currentUser(request)).get(0);
            if (ret != null) {
                ret.setCanEnroll(server.getAcademicSession().isSectioningEnabled());
                if (ret.isCanEnroll() && request.getStudentId() == null) {
                    ret.setCanEnroll(false);
                }
            }
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionSectioningFailed(e.getMessage()), e);
        }
    }

    @Override
    public SpecialRegistrationInterface.CancelSpecialRegistrationResponse cancelSpecialRequest(SpecialRegistrationInterface.CancelSpecialRegistrationRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(SpecialRegistrationCancel.class).withRequest(request), this.currentUser());
    }

    @Override
    public SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse retrieveGradeModes(SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(SpecialRegistrationRetrieveGradeModes.class).withRequest(request), this.currentUser());
    }

    @Override
    public SpecialRegistrationInterface.ChangeGradeModesResponse changeGradeModes(SpecialRegistrationInterface.ChangeGradeModesRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        SpecialRegistrationInterface.ChangeGradeModesResponse ret = server.execute(server.createAction(SpecialRegistrationChangeGradeModes.class).withRequest(request), this.currentUser());
        OnlineSectioningInterface.EligibilityCheck last = this.getLastEligibilityCheck(request);
        if (ret != null && ret.hasGradeModes() && last != null) {
            for (Map.Entry<String, Comparable<OnlineSectioningInterface.GradeMode>> entry : ret.getGradeModes().toMap().entrySet()) {
                last.addGradeMode(entry.getKey(), ((OnlineSectioningInterface.GradeMode)entry.getValue()).getCode(), ((OnlineSectioningInterface.GradeMode)entry.getValue()).getLabel(), ((OnlineSectioningInterface.GradeMode)entry.getValue()).isHonor());
            }
        }
        if (ret != null && ret.hasCreditHours() && last != null) {
            for (Map.Entry<String, Comparable<OnlineSectioningInterface.GradeMode>> entry : ret.getGradeModes().getCreditHours().entrySet()) {
                last.addCreditHour(entry.getKey(), (Float)entry.getValue());
            }
        }
        if (ret != null && ret.hasGradeModes() && last != null) {
            last.setCurrentCredit(ret.getGradeModes().getCurrentCredit());
        }
        return ret;
    }

    @Override
    public Integer changeCriticalOverride(Long studentId, Long courseId, Integer critical) throws SectioningException, PageAccessException {
        this.getSessionContext().checkPermission(studentId, Right.StudentSchedulingChangeCriticalOverride);
        try {
            Session hibSession = CourseDemandDAO.getInstance().getSession();
            CourseDemand cd = (CourseDemand)hibSession.createQuery("select cr.courseDemand from CourseRequest cr where cr.courseOffering.uniqueId = :courseId and cr.courseDemand.student.uniqueId = :studentId", CourseDemand.class).setParameter("studentId", (Object)studentId).setParameter("courseId", (Object)courseId).setMaxResults(1).uniqueResult();
            if (cd == null) {
                return null;
            }
            cd.setCriticalOverride(critical);
            hibSession.persist((Object)cd);
            hibSession.flush();
            OnlineSectioningServer server = this.getServerInstance(cd.getStudent().getSession().getUniqueId(), false);
            if (server != null) {
                server.execute(server.createAction(ReloadStudent.class).forStudents(studentId), this.currentUser());
            }
            return cd.getEffectiveCritical().ordinal();
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException("Failed to update critical status: " + e.getMessage(), e);
        }
    }

    @Override
    public SpecialRegistrationInterface.UpdateSpecialRegistrationResponse updateSpecialRequest(SpecialRegistrationInterface.UpdateSpecialRegistrationRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        if (request.isPreReg()) {
            this.getSessionContext().checkPermissionOtherAuthority(request.getSessionId(), "Session", Right.CourseRequests, this.getStudentAuthority(request.getSessionId()));
        } else {
            this.getSessionContext().checkPermissionOtherAuthority(request.getSessionId(), "Session", Right.SchedulingAssistant, this.getStudentAuthority(request.getSessionId()));
        }
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        return server.execute(server.createAction(SpecialRegistrationUpdate.class).withRequest(request), this.currentUser());
    }

    @Override
    public OnlineSectioningInterface.StudentInfo getStudentInfo(Long studentId) throws SectioningException, PageAccessException {
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        if (student == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnySession((Object)student.getSession(), Right.AdvisorCourseRequests, new Qualifiable[0]);
        Long sessionId = student.getSession().getUniqueId();
        OnlineSectioningInterface.StudentInfo ret = new OnlineSectioningInterface.StudentInfo();
        ret.setSessionId(sessionId);
        ret.setStudentId(student.getUniqueId());
        ret.setStudentName(student.getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
        ret.setStudentExternalId(student.getExternalUniqueId());
        ret.setStudentEmail(student.getEmail());
        ret.setSessionName(student.getSession().getLabel());
        return ret;
    }

    @Override
    public OnlineSectioningInterface.AdvisingStudentDetails getStudentAdvisingDetails(Long sessionId, String studentExternalId) throws SectioningException, PageAccessException {
        String defaultNote;
        OnlineSectioningServer server;
        Object status;
        Object email;
        SessionDAO.getInstance().getSession().setCacheMode(CacheMode.REFRESH);
        if (sessionId == null) {
            sessionId = this.getLastSessionId();
        }
        this.getSessionContext().checkPermissionAnySession((Object)sessionId, Right.AdvisorCourseRequests, new Qualifiable[0]);
        Student student = Student.findByExternalId(sessionId, studentExternalId);
        if (student == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningInterface.AdvisingStudentDetails ret = new OnlineSectioningInterface.AdvisingStudentDetails();
        ret.setSessionId(sessionId);
        ret.setStudentId(student.getUniqueId());
        ret.setStudentName(student.getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
        ret.setStudentExternalId(student.getExternalUniqueId());
        ret.setStudentEmail(student.getEmail());
        ret.setSessionName(student.getSession().getLabel());
        TimetableManager manager = TimetableManager.findByExternalId(this.getSessionContext().getUser().getExternalUserId());
        Advisor advisor = Advisor.findByExternalId(this.getSessionContext().getUser().getExternalUserId(), sessionId);
        if (manager != null && manager.getEmailAddress() != null && !manager.getEmailAddress().isEmpty()) {
            ret.setAdvisorEmail(manager.getEmailAddress());
        } else if (advisor != null && advisor.getEmail() != null && !advisor.getEmail().isEmpty()) {
            ret.setAdvisorEmail(advisor.getEmail());
        } else {
            email = null;
            for (Advisor a : student.getAdvisors()) {
                if (a.getEmail() == null) continue;
                email = (String)(email == null ? "" : email + "\n") + a.getEmail();
                if (!this.getSessionContext().getUser().getExternalUserId().equals(a.getExternalUniqueId())) continue;
                email = a.getEmail();
                break;
            }
            ret.setAdvisorEmail((String)email);
        }
        ret.setCanUpdate(false);
        ret.setDegreePlan(ApplicationProperty.DegreePlanForAdvisors.isTrue() && CustomDegreePlansHolder.hasProvider() && this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0]));
        if (Customization.StudentEmailProvider.hasProvider()) {
            email = (StudentEmailProvider)Customization.StudentEmailProvider.getProvider();
            ret.setEmailOptionalToggleCaption(email.getToggleCaptionIfOptional());
            ret.setEmailOptionalToggleDefault(email.isOptionCheckedByDefault());
        }
        try {
            String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(student.getSession());
            if ("Student".equalsIgnoreCase(advWlMode)) {
                ret.setWaitListMode(student.getWaitListMode());
            } else {
                ret.setWaitListMode(OnlineSectioningInterface.WaitListMode.valueOf(advWlMode));
            }
        }
        catch (Exception advWlMode) {
            // empty catch block
        }
        if (this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdmin, new Qualifiable[0])) {
            ret.setCanUpdate(true);
        } else if (this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingAdvisor, new Qualifiable[0])) {
            if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyAllStudents)) {
                ret.setCanUpdate(true);
            } else if (this.getSessionContext().hasPermission(Right.StudentSchedulingAdvisorCanModifyMyStudents) && advisor != null && advisor.getStudents().contains(student)) {
                ret.setCanUpdate(true);
            }
        }
        if (!student.getSession().getStatusType().canPreRegisterStudents() && !student.getSession().getStatusType().canOnlineSectionStudents()) {
            ret.setCanUpdate(false);
            ret.setDegreePlan(false);
        }
        ret.setCanEmail(this.getSessionContext().hasPermissionAnySession((Object)student.getSession(), Right.StudentSchedulingEmailStudent, new Qualifiable[0]));
        ret.setCanRequire(this.getSessionContext().hasPermissionAnySession((Object)student, Right.StudentSchedulingCanRequirePreferences, new Qualifiable[0]));
        ret.setClassScheduleNotAvailable(!student.getSession().canNoRoleReportClass());
        List courseTypes = CourseTypeDAO.getInstance().getSession().createQuery("select distinct t from CourseOffering c inner join c.courseType t where c.instructionalOffering.session.uniqueId = :sessionId order by t.reference", CourseType.class).setParameter("sessionId", (Object)this.getStatusPageSessionId()).setCacheable(true).list();
        boolean adv = this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdvisor, new Qualifiable[0]);
        boolean admin = this.getSessionContext().hasPermissionAnySession((Object)this.getStatusPageSessionId(), Right.StudentSchedulingAdmin, new Qualifiable[0]);
        if (student.getSectioningStatus() != null) {
            ret.setStatus(this.toStudentStatusInfo(student.getSectioningStatus(), courseTypes, admin, adv));
        } else if (student.getSession().getDefaultSectioningStatus() != null) {
            info = this.toStudentStatusInfo(student.getSession().getDefaultSectioningStatus(), courseTypes, admin, adv);
            info.setUniqueId(null);
            info.setReference("");
            info.setLabel(MSG.studentStatusSessionDefault(student.getSession().getDefaultSectioningStatus().getLabel()));
            info.setEffectiveStart(null);
            info.setEffectiveStop(null);
            ret.setStatus(info);
        } else {
            info = new OnlineSectioningInterface.StudentStatusInfo();
            info.setReference("");
            info.setLabel(MSG.studentStatusSystemDefault());
            info.setAllEnabled();
            ret.setStatus(info);
        }
        if (ret.isCanUpdate() && this.getSessionContext().hasPermissionAnySession((Object)sessionId, Right.StudentSchedulingChangeStudentStatus, new Qualifiable[0])) {
            boolean canChange = true;
            if (admin) {
                org.unitime.timetable.model.Session session = student.getSession();
                OnlineSectioningInterface.StudentStatusInfo info = null;
                if (session.getDefaultSectioningStatus() != null) {
                    info = this.toStudentStatusInfo(session.getDefaultSectioningStatus(), courseTypes, admin, adv);
                    info.setUniqueId(null);
                    info.setReference("");
                    info.setLabel(MSG.studentStatusSessionDefault(session.getDefaultSectioningStatus().getLabel()));
                    info.setEffectiveStart(null);
                    info.setEffectiveStop(null);
                } else {
                    info = new OnlineSectioningInterface.StudentStatusInfo();
                    info.setReference("");
                    info.setLabel(MSG.studentStatusSystemDefault());
                    info.setAllEnabled();
                }
                ret.addStatus(info);
            } else if (ApplicationProperty.AdvisorCourseRequestsRestrictedStatusChange.isTrue()) {
                status = student.getSectioningStatus() == null ? student.getSession().getDefaultSectioningStatus() : student.getSectioningStatus();
                boolean bl = canChange = status != null && ((StudentSectioningStatus)status).hasOption(StudentSectioningStatus.Option.advcanset);
            }
            if (canChange) {
                for (StudentSectioningStatus s : StudentSectioningStatus.findAll(sessionId)) {
                    if (s.isPast() || !admin && !s.hasOption(StudentSectioningStatus.Option.advcanset)) continue;
                    ret.addStatus(this.toStudentStatusInfo(s, courseTypes, admin, adv));
                }
            }
        }
        if ((server = this.getServerInstance(sessionId, true)) != null) {
            ret.setRequest(server.execute(server.createAction(AdvisorGetCourseRequests.class).forStudent(student.getUniqueId()).checkDemands(true).checkHolds(ret.isCanUpdate()), this.currentUser()));
        }
        if (server != null && !(server instanceof DatabaseServer)) {
            ret.setStudentRequest(server.execute(server.createAction(GetRequest.class).forStudent(student.getUniqueId(), false).withCustomValidation(true).withWaitListValidation(true).withCustomRequest(false).withAdvisorRequests(false).withWaitListMode(student.getWaitListMode()), this.currentUser()));
        } else if (ret.isCanUpdate()) {
            ret.setStudentRequest(this.getRequest(student));
        }
        for (Student otherStudent : CourseTypeDAO.getInstance().getSession().createQuery("select s from Student s where s.externalUniqueId = :studentId and s.session.academicYear = :year and s.session.academicTerm = :term and s.session.academicInitiative != :campus and s.advisorCourseRequests is not empty", Student.class).setParameter("studentId", (Object)student.getExternalUniqueId()).setParameter("year", (Object)student.getSession().getAcademicYear()).setParameter("term", (Object)student.getSession().getAcademicTerm()).setParameter("campus", (Object)student.getSession().getAcademicInitiative()).list()) {
            CourseRequestInterface recommendations;
            OnlineSectioningServer otherServer = this.getServerInstance(otherStudent.getSession().getUniqueId(), true);
            if (otherServer == null || (recommendations = otherServer.execute(otherServer.createAction(AdvisorGetCourseRequests.class).forStudent(otherStudent.getUniqueId()).checkDemands(false).checkHolds(false), this.currentUser())) == null || recommendations.isEmpty()) continue;
            ret.addOtherSessionRecommendations(otherStudent.getSession().getAcademicInitiative(), recommendations);
        }
        if (ret.hasStudentRequest()) {
            status = student.getEffectiveStatus();
            if (CustomStudentEnrollmentHolder.isAllowWaitListing() && (status == null || ((StudentSectioningStatus)status).hasOption(StudentSectioningStatus.Option.waitlist))) {
                ret.getStudentRequest().setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
            } else if (status != null && ((StudentSectioningStatus)status).hasOption(StudentSectioningStatus.Option.nosubs)) {
                ret.getStudentRequest().setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
            } else {
                ret.getStudentRequest().setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
            }
            if (ret.getRequest() != null) {
                if (ret.getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList && server != null && server.getConfig().getPropertyBoolean("Load.UseAdvisorWaitLists", false)) {
                    ret.setAdvisorWaitListedCourseIds(ret.getRequest().getWaitListedCourseIds());
                }
                if (ret.getWaitListMode() == OnlineSectioningInterface.WaitListMode.NoSubs && server != null && server.getConfig().getPropertyBoolean("Load.UseAdvisorNoSubs", false)) {
                    ret.setAdvisorWaitListedCourseIds(ret.getRequest().getNoSubCourseIds());
                }
            }
        }
        if (ret.getRequest() != null && ret.getRequest().hasPin() && student.getAdvisorCourseRequests().isEmpty()) {
            ret.getRequest().setPinReleased(true);
        }
        if (student.getAdvisorCourseRequests().isEmpty() && (defaultNote = ApplicationProperty.AdvisorCourseRequestsDefaultNote.valueOfSession(sessionId)) != null && !defaultNote.isEmpty()) {
            ret.getRequest().setCreditNote(defaultNote);
        }
        ret.setCriticalCheck(CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(sessionId)).ordinal());
        return ret;
    }

    @Override
    public CourseRequestInterface.CheckCoursesResponse checkAdvisingDetails(OnlineSectioningInterface.AdvisingStudentDetails details) throws SectioningException, PageAccessException {
        this.getSessionContext().checkPermissionAnySession((Object)details.getSessionId(), Right.AdvisorCourseRequests, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(details.getSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        return server.execute(server.createAction(AdvisorCourseRequestsValidate.class).withDetails(details), this.currentUser());
    }

    @Override
    public OnlineSectioningInterface.AdvisorCourseRequestSubmission submitAdvisingDetails(OnlineSectioningInterface.AdvisingStudentDetails details, boolean emailStudent) throws SectioningException, PageAccessException {
        this.getSessionContext().checkPermissionAnySession((Object)details.getSessionId(), Right.AdvisorCourseRequests, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(details.getSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        OnlineSectioningInterface.AdvisorCourseRequestSubmission ret = server.execute(server.createAction(AdvisorCourseRequestsSubmit.class).withDetails(details), this.currentUser());
        if (emailStudent && details.isCanEmail()) {
            StudentEmail email = server.createAction(StudentEmail.class).forStudent(details.getStudentId()).fromAction("advisor-submit").overridePermissions(false, false, true).includeAdvisorRequestsPDF();
            email.setEmailSubject(MSG.defaulSubjectAdvisorRequests());
            UserContext user = this.getSessionContext().getUser();
            if (user != null && user instanceof UserContext.Chameleon) {
                email.setCC(((UserContext.Chameleon)((Object)user)).getOriginalUserContext().getEmail());
            } else if (user != null) {
                email.setCC(user.getEmail());
            }
            server.execute(email, this.currentUser());
        }
        try {
            SessionFactory hibSessionFactory = SessionDAO.getInstance().getSession().getSessionFactory();
            hibSessionFactory.getCache().evictEntityData(Student.class, (Object)details.getStudentId());
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to evict cache: " + e.getMessage()));
        }
        return ret;
    }

    @Override
    public Collection<AcademicSessionProvider.AcademicSessionInfo> getStudentSessions(String studentExternalId) throws SectioningException, PageAccessException {
        StudentAreaClassificationMajor primary;
        String primaryCampus;
        AcademicSessionInfo info;
        org.unitime.timetable.model.Session session;
        ArrayList<AcademicSessionProvider.AcademicSessionInfo> ret = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
        ExternalTermProvider extTerm = this.getExternalTermProvider();
        HashSet<Long> sessionIds = new HashSet<Long>();
        boolean preferStudentCampus = ApplicationProperty.StudentSchedulingPreferStudentCampus.isTrue();
        for (Student student : StudentDAO.getInstance().getSession().createQuery("from Student where externalUniqueId = :id", Student.class).setParameter("id", (Object)studentExternalId).setCacheable(true).list()) {
            session = student.getSession();
            if (session.getStatusType().isTestSession() || !session.getStatusType().canPreRegisterStudents() && !session.getStatusType().canOnlineSectionStudents() || !this.getSessionContext().hasPermissionAnySession((Object)session, Right.AdvisorCourseRequests, new Qualifiable[0])) continue;
            info = new AcademicSessionInfo(session);
            primaryCampus = null;
            if (preferStudentCampus) {
                primary = student.getPrimaryAreaClasfMajor();
                primaryCampus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
            }
            ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info)).setPrimary(preferStudentCampus && this.matchPrimaryCampus(session, primaryCampus)));
            sessionIds.add(session.getUniqueId());
        }
        for (Student student : StudentDAO.getInstance().getSession().createQuery("from Student s where s.externalUniqueId = :id and s.advisorCourseRequests is not empty", Student.class).setParameter("id", (Object)studentExternalId).setCacheable(true).list()) {
            session = student.getSession();
            if (session.getStatusType().isTestSession() || sessionIds.contains(session.getUniqueId()) || !this.getSessionContext().hasPermissionAnySession((Object)session, Right.AdvisorCourseRequests, new Qualifiable[0])) continue;
            info = new AcademicSessionInfo(session);
            primaryCampus = null;
            if (preferStudentCampus) {
                primary = student.getPrimaryAreaClasfMajor();
                primaryCampus = primary == null || primary.getCampus() == null ? null : primary.getCampus().getReference();
            }
            ret.add(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), MSG.sessionName(session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative()), session.getSessionBeginDateTime()).setExternalCampus(extTerm == null ? null : extTerm.getExternalCampus(info)).setExternalTerm(extTerm == null ? null : extTerm.getExternalTerm(info)).setPrimary(preferStudentCampus && this.matchPrimaryCampus(session, primaryCampus)));
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    public CourseRequestInterface getAdvisorRequests(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId() == null ? this.canEnroll(cx) : cx.getSessionId(), true);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        CourseRequestInterface ret = server.execute(server.createAction(AdvisorGetCourseRequests.class).forStudent(cx.getStudentId()).checkDemands(false), this.currentUser(cx));
        try {
            String advWlMode = ApplicationProperty.AdvisorRecommendationsWaitListMode.value(server.getAcademicSession());
            if ("Student".equalsIgnoreCase(advWlMode)) {
                ret.setWaitListMode(((Student)StudentDAO.getInstance().get(cx.getStudentId())).getWaitListMode());
            } else {
                ret.setWaitListMode(OnlineSectioningInterface.WaitListMode.valueOf(advWlMode));
            }
        }
        catch (Exception e) {
            ret.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
        }
        return ret;
    }

    @Override
    public List<ReservationInterface> getReservations(boolean online, Long offeringId) throws ReservationException, PageAccessException {
        if (online) {
            this.sessionContext.checkPermission(Right.Reservations);
            OnlineSectioningServer server = this.getServerInstance(this.sessionContext.getUser().getCurrentAcademicSessionId(), true);
            if (server != null) {
                return server.execute(server.createAction(GetReservationsAction.class).forOfferingId(offeringId), this.currentUser());
            }
            return new ReservationServlet().withSessionContext(this.sessionContext).getReservations(offeringId);
        }
        StudentSolverProxy server = this.getStudentSolver();
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoSolver());
        }
        return server.getReservations(offeringId);
    }

    @Override
    public List<OnlineSectioningInterface.AdvisorNote> lastAdvisorNotes(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        this.getSessionContext().checkPermissionAnySession((Object)cx.getAcademicSessionId(), Right.AdvisorCourseRequests, new Qualifiable[0]);
        if (!ApplicationProperty.AdvisorCourseRequestsLastNotes.isTrue()) {
            return null;
        }
        ArrayList<OnlineSectioningInterface.AdvisorNote> ret = new ArrayList<OnlineSectioningInterface.AdvisorNote>();
        String defaultNote = ApplicationProperty.AdvisorCourseRequestsDefaultNote.valueOfSession(cx.getAcademicSessionId());
        Student student = cx.getStudentId() == null ? null : (Student)StudentDAO.getInstance().get(cx.getStudentId());
        List notes = AdvisorCourseRequestDAO.getInstance().getSession().createQuery("select replace(acr.notes, acr.student.pin, '$PIN$'), count(acr), max(acr.timestamp) from AdvisorCourseRequest acr where acr.priority = -1 and acr.changedBy = :externalId and acr.student.session.uniqueId = :sessionId group by replace(acr.notes, acr.student.pin, '$PIN$') order by max(acr.timestamp) desc", Object[].class).setParameter("externalId", (Object)this.sessionContext.getUser().getExternalUserId()).setParameter("sessionId", (Object)cx.getAcademicSessionId()).setCacheable(false).setMaxResults(50).list();
        for (Object[] o : notes) {
            String note = (String)o[0];
            Integer count = ((Number)o[1]).intValue();
            Date ts = (Date)o[2];
            if (note == null || note.isEmpty()) continue;
            String dispNote = note;
            if (defaultNote != null && note.contains(defaultNote)) {
                dispNote = note.replace(defaultNote, "\u2026");
            }
            if (defaultNote != null && note.contains(defaultNote.replace("\r", ""))) {
                dispNote = note.replace(defaultNote.replace("\r", ""), "\u2026");
            }
            OnlineSectioningInterface.AdvisorNote an = new OnlineSectioningInterface.AdvisorNote();
            an.setCount(count);
            an.setDisplayString(dispNote.replace("$PIN$", "XXXXXX"));
            an.setReplaceString(note.replace("$PIN$", student == null || student.getPin() == null ? "XXXXXX" : student.getPin()));
            an.setTimeStamp(ts);
            ret.add(an);
        }
        return ret;
    }

    @Override
    public String getChangeLogMessage(Long logId) throws SectioningException, PageAccessException {
        this.getSessionContext().checkPermission(Right.SchedulingDashboard);
        OnlineSectioningLog log = (OnlineSectioningLog)OnlineSectioningLogDAO.getInstance().get(logId);
        if (log != null) {
            try {
                OnlineSectioningLog.Action action = OnlineSectioningLog.Action.parseFrom(log.getAction());
                if (action != null) {
                    return FindOnlineSectioningLogAction.getHTML(action);
                }
                throw new SectioningException("Failed to load log message: Log message has no details.");
            }
            catch (InvalidProtocolBufferException e) {
                throw new SectioningException("Failed to parse log message: " + e.getMessage(), e);
            }
        }
        throw new SectioningException("Failed to load log message: Log message does not exist.");
    }

    @Override
    public Map<Long, String> getChangeLogTexts(Collection<Long> logIds) throws SectioningException, PageAccessException {
        this.getSessionContext().checkPermission(Right.SchedulingDashboard);
        HashMap<Long, String> ret = new HashMap<Long, String>();
        for (Object[] o : OnlineSectioningLogDAO.getInstance().getSession().createQuery("select uniqueId, action from OnlineSectioningLog where uniqueId in :logIds", Object[].class).setParameterList("logIds", logIds, Long.class).list()) {
            Long id = (Long)o[0];
            try {
                OnlineSectioningLog.Action action = OnlineSectioningLog.Action.parseFrom((byte[])o[1]);
                String message = OnlineSectioningLogger.getMessage(action);
                if (message == null || message.isEmpty()) continue;
                ret.put(id, message);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
        }
        return ret;
    }

    @Override
    public Collection<SpecialRegistrationInterface.VariableTitleCourseInfo> listVariableTitleCourses(OnlineSectioningInterface.StudentSectioningContext cx, String query, int limit) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (cx.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(cx.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.VariableTitleCourseProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        VariableTitleCourseProvider provider = (VariableTitleCourseProvider)Customization.VariableTitleCourseProvider.getProvider();
        OnlineSectioningHelper helper = new OnlineSectioningHelper(SessionDAO.getInstance().getSession(), this.currentUser(cx));
        return provider.getVariableTitleCourses(query, limit, cx.getStudentId(), server, helper);
    }

    @Override
    public SpecialRegistrationInterface.VariableTitleCourseInfo getVariableTitleCourse(OnlineSectioningInterface.StudentSectioningContext cx, String course) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (cx.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(cx.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.VariableTitleCourseProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        VariableTitleCourseProvider provider = (VariableTitleCourseProvider)Customization.VariableTitleCourseProvider.getProvider();
        OnlineSectioningHelper helper = new OnlineSectioningHelper(SessionDAO.getInstance().getSession(), this.currentUser(cx));
        return provider.getVariableTitleCourse(course, cx.getStudentId(), server, helper);
    }

    @Override
    public SpecialRegistrationInterface.VariableTitleCourseResponse requestVariableTitleCourse(SpecialRegistrationInterface.VariableTitleCourseRequest request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.VariableTitleCourseProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(SpecialRegistrationRequestVariableTitleCourse.class).withRequest(request), this.currentUser());
    }

    @Override
    public CourseRequestInterface.CheckCoursesResponse waitListCheckValidation(CourseRequestInterface request) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.WaitListValidationProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(WaitListCheckValidation.class).withRequest(request), this.currentUser());
    }

    @Override
    public CourseRequestInterface waitListSubmitOverrides(CourseRequestInterface request, Float neededCredit) throws SectioningException, PageAccessException {
        this.checkContext(request);
        if (request.getSessionId() == null) {
            throw new PageAccessException(MSG.exceptionNoAcademicSession());
        }
        if (request.getStudentId() == null) {
            throw new PageAccessException(MSG.exceptionNoStudent());
        }
        this.getSessionContext().checkPermissionAnyAuthority(request.getStudentId(), "Student", Right.StudentSchedulingCanEnroll, new Qualifiable[0]);
        OnlineSectioningServer server = this.getServerInstance(request.getSessionId(), false);
        if (server == null) {
            throw new SectioningException(MSG.exceptionNoServerForSession());
        }
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.WaitListValidationProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        return server.execute(server.createAction(WaitListSubmitOverrides.class).withRequest(request).withCredit(neededCredit), this.currentUser());
    }

    protected OtherAuthority getStudentAuthority(Long sessionId) {
        return new StudentAuthority(this.getSessionContext(), new SimpleQualifier("Session", sessionId));
    }

    protected OtherAuthority getStudentAuthority(Qualifiable session) {
        return new StudentAuthority(this.getSessionContext(), session);
    }

    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> getCoursesFromRequest(OnlineSectioningInterface.StudentSectioningContext cx, CourseRequestInterface.Request query) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getSessionId() == null) {
            throw new SectioningException(MSG.exceptionNoAcademicSession());
        }
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        if (server == null || server instanceof DatabaseServer) {
            Session hibSession = CurriculumDAO.getInstance().getSession();
            List overrides = hibSession.createQuery("from OverrideType order by label", OverrideType.class).setCacheable(true).list();
            ArrayList<ClassAssignmentInterface.CourseAssignment> results = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
            for (Long courseId : query.getCourseIds()) {
                CourseOffering c = (CourseOffering)CourseOfferingDAO.getInstance().get(courseId);
                if (c == null) continue;
                ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                course.setCourseId(c.getUniqueId());
                course.setSubject(c.getSubjectAreaAbbv());
                course.setCourseNbr(c.getCourseNbr());
                course.setTitle(c.getTitle());
                course.setNote(c.getScheduleBookNote());
                if (c.getCredit() != null) {
                    course.setCreditText(c.getCredit().creditText());
                    course.setCreditAbbv(c.getCredit().creditAbbv());
                }
                course.setTitle(c.getTitle());
                course.setHasUniqueName(true);
                course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                course.setCanWaitList(c.getInstructionalOffering().effectiveWaitList());
                if (overrides != null && !overrides.isEmpty()) {
                    for (OverrideType override : overrides) {
                        if (c.getDisabledOverrides().contains(override)) continue;
                        course.addOverride(override.getReference(), override.getLabel());
                    }
                }
                boolean unlimited = false;
                int courseLimit = 0;
                for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (cfg.isUnlimitedEnrollment().booleanValue()) {
                        unlimited = true;
                    }
                    if (cfg.getLimit() == null) continue;
                    courseLimit += cfg.getLimit().intValue();
                }
                if (c.getReservation() != null) {
                    courseLimit = c.getReservation();
                }
                if (courseLimit >= 9999) {
                    unlimited = true;
                }
                course.setLimit(unlimited ? -1 : courseLimit);
                course.setProjected(c.getProjectedDemand());
                course.setEnrollment(c.getEnrollment());
                course.setLastLike(c.getDemand());
                results.add(course);
                for (InstrOfferingConfig config : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (config.getEffectiveInstructionalMethod() != null) {
                        course.addInstructionalMethod(config.getEffectiveInstructionalMethod().getUniqueId(), config.getEffectiveInstructionalMethod().getLabel());
                        continue;
                    }
                    course.setHasNoInstructionalMethod(true);
                }
            }
            return results;
        }
        Collection<ClassAssignmentInterface.CourseAssignment> results = null;
        try {
            results = server.execute(server.createAction(ListCourseOfferings.class).forRequest(query).forStudent(cx.getStudentId()), this.currentUser(cx));
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        return results;
    }

    @Override
    public StudentSchedulingPreferencesInterface getStudentSchedulingPreferences(OnlineSectioningInterface.StudentSectioningContext cx) throws SectioningException, PageAccessException {
        Student student;
        this.checkContext(cx);
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), false);
        if (server != null) {
            return server.execute(server.createAction(GetStudentPreferences.class).forStudent(cx.getStudentId()), this.currentUser(cx));
        }
        StudentSchedulingPreferencesInterface ret = new StudentSchedulingPreferencesInterface();
        ApplicationProperties.setSessionId(cx.getSessionId());
        ret.setAllowClassDates(ApplicationProperty.OnlineSchedulingStudentPreferencesDatesAllowed.isTrue());
        ret.setAllowRequireOnline(ApplicationProperty.OnlineSchedulingStudentPreferencesReqOnlineAllowed.isTrue());
        ret.setCustomNote(ApplicationProperty.OnlineSchedulingStudentPreferencesNote.value());
        Student student2 = student = cx.getStudentId() == null ? null : (Student)StudentDAO.getInstance().get(cx.getStudentId());
        if (student != null) {
            ret.setClassModality(student.getPreferredClassModality());
            ret.setScheduleGaps(student.getPreferredScheduleGaps());
            ret.setClassDateFrom(student.getClassStartDate());
            ret.setClassDateTo(student.getClassEndDate());
        }
        return ret;
    }

    @Override
    public Boolean setStudentSchedulingPreferences(OnlineSectioningInterface.StudentSectioningContext cx, StudentSchedulingPreferencesInterface preferences) throws SectioningException, PageAccessException {
        this.checkContext(cx);
        if (cx.getStudentId() == null) {
            throw new SectioningException(MSG.exceptionNoStudent());
        }
        OnlineSectioningServer server = this.getServerInstance(cx.getSessionId(), true);
        if (server != null) {
            server.execute(server.createAction(ChangeStudentPreferences.class).forStudent(cx.getStudentId()).withPreferences(preferences), this.currentUser(cx));
        } else {
            Student student = (Student)StudentDAO.getInstance().get(cx.getStudentId());
            if (student != null) {
                student.setPreferredClassModality(preferences.getClassModality());
                student.setPreferredScheduleGaps(preferences.getScheduleGaps());
                student.setClassStartDate(preferences.getClassDateFrom());
                student.setClassEndDate(preferences.getClassDateTo());
                StudentDAO.getInstance().getSession().merge((Object)student);
                StudentDAO.getInstance().getSession().flush();
            }
        }
        try {
            SessionFactory hibSessionFactory = SessionDAO.getInstance().getSession().getSessionFactory();
            hibSessionFactory.getCache().evictEntityData(Student.class, (Object)cx.getStudentId());
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to evict cache: " + e.getMessage()));
        }
        return false;
    }

    private boolean matchFilter(CourseRequestInterface.Filter filter, CourseOffering co, int dayOfWeekOffset) {
        Float credit;
        if (filter == null) {
            return true;
        }
        if (filter.getCreditMin() != null && co.getCredit() != null && (credit = Float.valueOf(co.getCredit().getMaxCredit())) != null && credit.floatValue() < filter.getCreditMin().floatValue()) {
            return false;
        }
        if (filter.getCreditMax() != null && co.getCredit() != null && (credit = Float.valueOf(co.getCredit().getMinCredit())) != null && credit.floatValue() > filter.getCreditMax().floatValue()) {
            return false;
        }
        if (filter.hasInstructor()) {
            boolean match = false;
            block0: for (InstrOfferingConfig cfg : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                for (SchedulingSubpart ss : cfg.getSchedulingSubparts()) {
                    for (Class_ c : ss.getClasses()) {
                        if (!c.isEnabledForStudentScheduling().booleanValue() || !this.matchInstructorName(filter, c) || !this.matchDates(dayOfWeekOffset, filter, c)) continue;
                        match = true;
                        break block0;
                    }
                }
            }
            if (!match) {
                return false;
            }
        }
        if (filter.hasDates()) {
            boolean match = false;
            block3: for (InstrOfferingConfig cfg : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                for (SchedulingSubpart ss : cfg.getSchedulingSubparts()) {
                    boolean matchClass = false;
                    block5: for (Class_ c : ss.getClasses()) {
                        if (!c.isEnabledForStudentScheduling().booleanValue() || !this.matchDates(dayOfWeekOffset, filter, c)) continue;
                        for (Class_ p = c.getParentClass(); p != null; p = p.getParentClass()) {
                            if (!this.matchDates(dayOfWeekOffset, filter, p)) continue block5;
                        }
                        matchClass = true;
                        break;
                    }
                    if (matchClass) continue;
                    continue block3;
                }
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    private boolean matchInstructorName(CourseRequestInterface.Filter filter, Class_ clazz) {
        if (!filter.hasInstructor()) {
            return true;
        }
        if (clazz.isDisplayInstructor().booleanValue()) {
            for (ClassInstructor ci : clazz.getClassInstructors()) {
                if (!this.matchName(filter.getInstructor(), ci.getInstructor())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchDates(int dayOfWeekOffset, CourseRequestInterface.Filter filter, Class_ clazz) {
        if (!filter.hasDates()) {
            return true;
        }
        Assignment ass = clazz.getCommittedAssignment();
        if (ass == null) {
            DatePattern dp = clazz.effectiveDatePattern();
            if (filter.getDaysFrom() != null && dp != null && dp.getFirstMeeting(0, dayOfWeekOffset) < filter.getDaysFrom()) {
                return false;
            }
            if (filter.getDaysTo() != null && dp != null && dp.getLastMeeting(0, dayOfWeekOffset) > filter.getDaysTo()) {
                return false;
            }
        } else {
            DatePattern dp = ass.getDatePattern();
            if (filter.getDaysFrom() != null && dp.getFirstMeeting(ass.getDays(), dayOfWeekOffset) < filter.getDaysFrom()) {
                return false;
            }
            if (filter.getDaysTo() != null && dp.getLastMeeting(ass.getDays(), dayOfWeekOffset) > filter.getDaysTo()) {
                return false;
            }
        }
        return true;
    }

    private boolean matchName(String instructor, NameInterface name) {
        StringTokenizer s = new StringTokenizer(instructor);
        while (s.hasMoreTokens()) {
            String token = s.nextToken().toLowerCase();
            if (name.getFirstName() != null && name.getFirstName().toLowerCase().startsWith(token) || name.getMiddleName() != null && name.getMiddleName().toLowerCase().startsWith(token) || name.getLastName() != null && name.getLastName().toLowerCase().startsWith(token) || name.getAcademicTitle() != null && name.getAcademicTitle().toLowerCase().startsWith(token)) continue;
            return false;
        }
        return true;
    }

    protected String datePatternName(DatePattern pattern, String datePatternFormat) {
        if ("never".equals(datePatternFormat)) {
            return pattern.getName();
        }
        if ("extended".equals(datePatternFormat) && !pattern.isExtended()) {
            return pattern.getName();
        }
        if ("alternate".equals(datePatternFormat) && pattern.isAlternate()) {
            return pattern.getName();
        }
        Formats.Format<Date> dpf = Formats.getDateFormat(Formats.Pattern.DATE_PATTERN);
        Date first = pattern.getStartDate();
        Date last = pattern.getEndDate();
        return dpf.format(first) + (String)(first.equals(last) ? "" : " - " + dpf.format(last));
    }

    static class CourseMatcher
    extends AbstractCourseMatcher {
        private org.unitime.timetable.onlinesectioning.match.CourseMatcher iParent;
        private static final long serialVersionUID = 1L;
        private boolean iAllCourseTypes;
        private boolean iNoCourseType;
        private Set<String> iAllowedCourseTypes;
        private Set<Long> iAllowedCourseIds;

        public CourseMatcher(boolean allCourseTypes, boolean noCourseType, Set<String> allowedCourseTypes, Set<Long> allowedCourseIds) {
            this.iAllCourseTypes = allCourseTypes;
            this.iNoCourseType = noCourseType;
            this.iAllowedCourseTypes = allowedCourseTypes;
            this.iAllowedCourseIds = allowedCourseIds;
        }

        public boolean isAllCourseTypes() {
            return this.iAllCourseTypes;
        }

        public boolean isNoCourseType() {
            return this.iNoCourseType;
        }

        public boolean hasAllowedCourseTypes() {
            return this.iAllowedCourseTypes != null && !this.iAllowedCourseTypes.isEmpty();
        }

        public Set<String> getAllowedCourseTypes() {
            return this.iAllowedCourseTypes;
        }

        public Set<Long> getAllowedCourseIds() {
            return this.iAllowedCourseIds;
        }

        public boolean isAllowedCourseId(XCourseId course) {
            return this.iAllowedCourseIds != null && course != null && this.iAllowedCourseIds.contains(course.getCourseId());
        }

        public org.unitime.timetable.onlinesectioning.match.CourseMatcher getParentCourseMatcher() {
            return this.iParent;
        }

        public void setParentCourseMatcher(org.unitime.timetable.onlinesectioning.match.CourseMatcher parent) {
            this.iParent = parent;
        }

        @Override
        public void setServer(OnlineSectioningServer server) {
            super.setServer(server);
            if (this.iParent != null) {
                this.iParent.setServer(server);
            }
        }

        @Override
        public boolean match(XCourseId course) {
            if (this.isAllowedCourseId(course)) {
                return true;
            }
            return course != null && course.matchType(this.iAllCourseTypes, this.iNoCourseType, this.iAllowedCourseTypes) && (this.iParent == null || this.iParent.match(course));
        }
    }

    protected static class StudentAuthority
    implements OtherAuthority {
        private String iRole = null;
        private boolean iAllowNoRole = false;
        private Qualifiable[] iFilter = null;

        protected StudentAuthority(SessionContext context, Qualifiable ... filter) {
            UserContext user = context.getUser();
            this.iFilter = filter;
            if (user != null && user.getCurrentAuthority() != null) {
                this.iRole = user.getCurrentAuthority().getRole();
                this.iAllowNoRole = true;
                block0: for (UserAuthority userAuthority : user.getAuthorities()) {
                    for (Qualifiable q : filter) {
                        if (!userAuthority.hasQualifier(q)) continue block0;
                    }
                    if (!"Student".equals(userAuthority.getRole())) continue;
                    this.iAllowNoRole = false;
                    break;
                }
            } else if (user != null && user instanceof AnonymousUserContext) {
                this.iRole = "Anonymous";
                this.iAllowNoRole = true;
            }
        }

        @Override
        public boolean isMatch(UserAuthority authority) {
            if (this.iRole == null) {
                return false;
            }
            for (Qualifiable q : this.iFilter) {
                if (authority.hasQualifier(q)) continue;
                return false;
            }
            if (this.iRole.equals(authority.getRole())) {
                return true;
            }
            if ("Student".equals(authority.getRole())) {
                return true;
            }
            return this.iAllowNoRole && ("No Role".equals(authority.getRole()) || "Anonymous".equals(authority.getRole()));
        }
    }
}

