/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;

public class ServerDateTimeFormat
extends DateTimeFormat {
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static com.google.gwt.i18n.client.TimeZone sServerTimeZone = null;
    private static final Map<String, ServerDateTimeFormat> sFormatCache;

    public ServerDateTimeFormat(String pattern) {
        super(pattern);
    }

    public static com.google.gwt.i18n.client.TimeZone getServerTimeZone() {
        return sServerTimeZone;
    }

    public static Integer getOffset(Date date) {
        return sServerTimeZone.getStandardOffset() - sServerTimeZone.getDaylightAdjustment(date);
    }

    public static Date toLocalDate(Date serverDate) {
        if (serverDate == null || sServerTimeZone == null) {
            return serverDate;
        }
        return new Date(serverDate.getTime() + (long)(60000 * (serverDate.getTimezoneOffset() - ServerDateTimeFormat.getOffset(serverDate))));
    }

    public static Date toServerDate(Date localDate) {
        if (localDate == null || sServerTimeZone == null) {
            return localDate;
        }
        return new Date(localDate.getTime() + (long)(60000 * (ServerDateTimeFormat.getOffset(localDate) - localDate.getTimezoneOffset())));
    }

    public String format(Date date) {
        return super.format(date, (TimeZone)sServerTimeZone);
    }

    public static DateTimeFormat getFormat(String pattern) {
        ServerDateTimeFormat format = sFormatCache.get(pattern);
        if (format == null) {
            format = new ServerDateTimeFormat(pattern);
            sFormatCache.put(pattern, format);
        }
        return format;
    }

    static {
        String cookie = ToolBox.getSessionCookie("UniTime:ServerTimeZone");
        if (cookie != null) {
            try {
                sServerTimeZone = com.google.gwt.i18n.client.TimeZone.createTimeZone((String)cookie);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sServerTimeZone == null) {
            RPC.execute(new ServerTimeZoneRequest(), new AsyncCallback<ServerTimeZoneResponse>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(ServerTimeZoneResponse result) {
                    sServerTimeZone = com.google.gwt.i18n.client.TimeZone.createTimeZone((String)result.toJsonString());
                    ToolBox.setSessionCookie("UniTime:ServerTimeZone", result.toJsonString());
                }
            });
        }
        sFormatCache = new HashMap<String, ServerDateTimeFormat>();
    }

    public static class ServerTimeZoneRequest
    implements GwtRpcRequest<ServerTimeZoneResponse> {
    }

    public static class ServerTimeZoneResponse
    implements GwtRpcResponse {
        private String iId;
        private List<String> iNames;
        private int iTimeZoneOffsetInMinutes;
        private List<Integer> iTransitions = null;

        public ServerTimeZoneResponse() {
        }

        public ServerTimeZoneResponse(int timeZoneOffsetInMinutes) {
            this.iTimeZoneOffsetInMinutes = timeZoneOffsetInMinutes;
        }

        public void setId(String id) {
            this.iId = id;
        }

        public String getId() {
            return this.iId;
        }

        public void addName(String name) {
            if (this.iNames == null) {
                this.iNames = new ArrayList<String>();
            }
            this.iNames.add(name);
        }

        public void setTimeZoneOffsetInMinutes(int timeZoneOffestInMinutes) {
            this.iTimeZoneOffsetInMinutes = timeZoneOffestInMinutes;
        }

        public int getTimeZoneOffsetInMinutes() {
            return this.iTimeZoneOffsetInMinutes;
        }

        public void addTransition(int transition, int adjustment) {
            if (this.iTransitions == null) {
                this.iTransitions = new ArrayList<Integer>();
            }
            this.iTransitions.add(transition);
            this.iTransitions.add(adjustment);
        }

        public String toJsonString() {
            int i;
            String ret = "{\"id\":\"" + this.getId() + "\",\"std_offset\":" + this.getTimeZoneOffsetInMinutes();
            if (this.iTransitions != null) {
                ret = ret + ",\"transitions\":[";
                for (i = 0; i < this.iTransitions.size(); ++i) {
                    ret = ret + (i == 0 ? "" : ",") + this.iTransitions.get(i);
                }
                ret = ret + "]";
            }
            if (this.iNames == null) {
                ret = ret + ",\"names\":[]";
            } else {
                ret = ret + ",\"names\":[";
                for (i = 0; i < this.iNames.size(); ++i) {
                    ret = ret + (i == 0 ? "" : ",") + "\"" + this.iNames.get(i) + "\"";
                }
                ret = ret + "]";
            }
            ret = ret + "}";
            return ret;
        }

        public String toString() {
            return this.toJsonString();
        }
    }
}

