/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.AutocompleteValue;
import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class IntervalSelector<T>
extends Composite
implements HasValue<Interval>,
HasAriaLabel,
HasAllFocusHandlers {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private boolean iAllowMultiSelection;
    private Interval iValue;
    private Interval iDefaultValue;
    private List<T> iValues = null;
    private boolean iFilterEnabled = false;
    private Filter<T> iItemFilter = null;
    private AriaTextBox iFilter;
    private PopupPanel iPopup;
    private Menu iPopupMenu;
    private ScrollPanel iPopupScroll;
    private P iPanel;
    private Button iPrev;
    private Button iNext;
    private UniTimeWidget<AbsolutePanel> iWidget;
    private String iLastSelected = null;

    public IntervalSelector(boolean allowMultiSelection) {
        this.iAllowMultiSelection = allowMultiSelection;
        this.iPanel = new P("unitime-IntervalSelector");
        P row = new P("row");
        this.iPanel.add((Widget)row);
        this.iPrev = new Button("&laquo;");
        this.iPrev.setEnabled(false);
        this.iPrev.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                Interval prev;
                Interval interval = prev = IntervalSelector.this.getValue() == null ? null : IntervalSelector.this.previous(IntervalSelector.this.getValue());
                if (prev != null) {
                    IntervalSelector.this.setValue(prev, true);
                }
            }
        });
        this.iNext = new Button("&raquo;");
        this.iNext.setEnabled(false);
        this.iNext.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                Interval next;
                Interval interval = next = IntervalSelector.this.getValue() == null ? null : IntervalSelector.this.next(IntervalSelector.this.getValue());
                if (next != null) {
                    IntervalSelector.this.setValue(next, true);
                }
            }
        });
        this.iFilter = new AriaTextBox();
        this.iFilter.addStyleName("selection");
        this.iFilter.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (IntervalSelector.this.isSuggestionsShowing()) {
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 40: {
                            IntervalSelector.this.iPopupMenu.selectItem(IntervalSelector.this.iPopupMenu.getSelectedItemIndex() + 1);
                            IntervalSelector.this.setStatus(ARIA.onSuggestion(IntervalSelector.this.iPopupMenu.getSelectedItemIndex() + 1, IntervalSelector.this.iPopupMenu.getNumItems(), IntervalSelector.this.iPopupMenu.getSelectedInterval().toAriaString()));
                            break;
                        }
                        case 38: {
                            if (IntervalSelector.this.iPopupMenu.getSelectedItemIndex() == -1) {
                                IntervalSelector.this.iPopupMenu.selectItem(IntervalSelector.this.iPopupMenu.getNumItems() - 1);
                            } else {
                                IntervalSelector.this.iPopupMenu.selectItem(IntervalSelector.this.iPopupMenu.getSelectedItemIndex() - 1);
                            }
                            IntervalSelector.this.setStatus(ARIA.onSuggestion(IntervalSelector.this.iPopupMenu.getSelectedItemIndex() + 1, IntervalSelector.this.iPopupMenu.getNumItems(), IntervalSelector.this.iPopupMenu.getSelectedInterval().toAriaString()));
                            break;
                        }
                        case 9: 
                        case 13: {
                            IntervalSelector.this.iPopupMenu.executeSelected();
                            IntervalSelector.this.hideSuggestions();
                            break;
                        }
                        case 27: {
                            IntervalSelector.this.hideSuggestions();
                        }
                    }
                    switch (event.getNativeEvent().getKeyCode()) {
                        case 13: 
                        case 27: 
                        case 38: 
                        case 40: {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                    }
                } else if (event.getNativeEvent().getKeyCode() == 40 && (event.getNativeEvent().getAltKey() || IntervalSelector.this.iFilter.getCursorPos() == IntervalSelector.this.iFilter.getText().length())) {
                    IntervalSelector.this.showSuggestions();
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        });
        this.iFilter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (IntervalSelector.this.selectASuggestion()) {
                    if (!IntervalSelector.this.isSuggestionsShowing()) {
                        IntervalSelector.this.showSuggestions();
                    } else {
                        IntervalSelector.this.setStatus(ARIA.onSuggestion(IntervalSelector.this.iPopupMenu.getSelectedItemIndex() + 1, IntervalSelector.this.iPopupMenu.getNumItems(), IntervalSelector.this.iPopupMenu.getSelectedInterval().toAriaString()));
                    }
                }
            }
        });
        this.iFilter.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (IntervalSelector.this.iValues != null) {
                    if (IntervalSelector.this.isAllowMultiSelection() && ((String)event.getValue()).equals(IntervalSelector.this.getReplaceString(new Interval()))) {
                        IntervalSelector.this.setValue(new Interval());
                    } else {
                        Interval value = null;
                        block0: for (int i = 0; i < IntervalSelector.this.iValues.size(); ++i) {
                            if (((String)event.getValue()).equals(IntervalSelector.this.getReplaceString(new Interval(IntervalSelector.this.iValues.get(i))))) {
                                value = new Interval(IntervalSelector.this.iValues.get(i));
                                break;
                            }
                            if (!IntervalSelector.this.isAllowMultiSelection()) continue;
                            for (int j = i + 1; j < IntervalSelector.this.iValues.size(); ++j) {
                                if (!((String)event.getValue()).equals(IntervalSelector.this.getReplaceString(new Interval(IntervalSelector.this.iValues.get(i), IntervalSelector.this.iValues.get(j))))) continue;
                                value = new Interval(IntervalSelector.this.iValues.get(i), IntervalSelector.this.iValues.get(j));
                                break block0;
                            }
                        }
                        IntervalSelector.this.setValue(value);
                    }
                }
            }
        });
        this.iFilter.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                IntervalSelector.this.showSuggestions();
            }
        });
        this.iPopupMenu = new Menu();
        this.iPopupScroll = new ScrollPanel((Widget)this.iPopupMenu);
        this.iPopupScroll.addStyleName("scroll");
        this.iPopup = new PopupPanel(true, false);
        this.iPopup.setPreviewingAllNativeEvents(true);
        this.iPopup.setStyleName("unitime-IntervalSelectorPopup");
        this.iPopup.setWidget((Widget)this.iPopupScroll);
        row.add((Widget)this.iPrev);
        row.add((Widget)this.iFilter);
        row.add((Widget)this.iNext);
        this.iWidget = new UniTimeWidget<P>(this.iPanel);
        this.initWidget((Widget)this.iWidget);
        Roles.getTextboxRole().setAriaAutocompleteProperty((Element)this.iFilter.getElement(), AutocompleteValue.NONE);
        this.iPopup.getElement().setAttribute("id", DOM.createUniqueId());
        Roles.getTextboxRole().setAriaOwnsProperty((Element)this.iFilter.getElement(), new Id[]{Id.of((Element)this.iPopup.getElement())});
    }

    protected void hideSuggestions() {
        if (this.iPopup.isShowing()) {
            this.iPopup.hide();
        }
    }

    protected void showSuggestions() {
        if (this.iValues == null || this.iValues.isEmpty()) {
            return;
        }
        if (this.iPopupMenu.getNumItems() == 1) {
            this.setStatus(ARIA.showingOneSuggestion(this.iPopupMenu.getSelectedInterval().toAriaString()));
        } else if (this.iPopupMenu.getSelectedItemIndex() == 0) {
            this.setStatus(ARIA.showingMultipleSuggestionsNoQuery(this.iPopupMenu.getNumItems(), this.iFilter.getValue() == null ? ARIA.emptyFilter() : this.iFilter.getValue()));
        }
        if (this.iPopupMenu.getSelectedItemIndex() > 0) {
            this.setStatus(ARIA.onSuggestion(this.iPopupMenu.getSelectedItemIndex() + 1, this.iPopupMenu.getNumItems(), this.iPopupMenu.getSelectedInterval().toAriaString()));
        } else {
            this.setStatus(ARIA.showingMultipleSuggestionsNoQueryNoneSelected(this.iPopupMenu.getNumItems()));
        }
        this.iPopup.showRelativeTo((UIObject)this.iFilter);
        this.iPopupMenu.scrollToView();
    }

    protected boolean isSuggestionsShowing() {
        return this.iPopup.isShowing();
    }

    protected void createSuggestions() {
        this.iPopupMenu.clearItems();
        if (this.isAllowMultiSelection()) {
            if (this.hasFilter()) {
                all = new Interval();
                all.setEnableFilter(!this.isFilterEnabled());
                this.iPopupMenu.addItem(new IntervalMenuItem(all));
                Interval allCurrent = new Interval();
                allCurrent.setEnableFilter(this.isFilterEnabled());
                this.iPopupMenu.addItem(new IntervalMenuItem(allCurrent));
                if (allCurrent.equals(this.iDefaultValue) || this.getReplaceString(allCurrent).equals(this.iFilter.getText())) {
                    this.iPopupMenu.selectItem(1);
                }
            } else {
                all = new Interval();
                this.iPopupMenu.addItem(new IntervalMenuItem(all));
                if (all.equals(this.iDefaultValue) || this.getReplaceString(all).equals(this.iFilter.getText())) {
                    this.iPopupMenu.selectItem(0);
                }
            }
        }
        int select = -1;
        for (int i = 0; i < this.iValues.size(); ++i) {
            if (this.filter(this.iValues.get(i))) continue;
            Interval one = new Interval(this.iValues.get(i));
            this.iPopupMenu.addItem(new IntervalMenuItem(one));
            if (one.equals(this.iDefaultValue) && select < 0 || this.getReplaceString(one).equals(this.iFilter.getText()) || one.equals(this.iValue)) {
                select = this.iPopupMenu.getNumItems() - 1;
            }
            if (!this.isAllowMultiSelection() || this.getValue() == null || this.getValue().getFirst() == null || !this.getValue().getFirst().equals(one.getFirst())) continue;
            for (int j = i + 1; j < this.iValues.size(); ++j) {
                if (this.filter(this.iValues.get(j))) continue;
                Interval multi = new Interval(this.iValues.get(i), this.iValues.get(j));
                this.iPopupMenu.addItem(new IntervalMenuItem(multi));
                if ((!multi.equals(this.iDefaultValue) || select >= 0) && !this.getReplaceString(multi).equals(this.iFilter.getText()) && !multi.equals(this.iValue)) continue;
                select = this.iPopupMenu.getNumItems() - 1;
            }
        }
        if (select >= 0) {
            this.iPopupMenu.selectItem(select);
        }
        this.iLastSelected = this.iFilter.getText();
        if (this.iPopup.isShowing() && this.iPopupMenu.getSelectedItemIndex() >= 0) {
            this.setStatus(ARIA.onSuggestion(this.iPopupMenu.getSelectedItemIndex() + 1, this.iPopupMenu.getNumItems(), this.iPopupMenu.getSelectedInterval().toAriaString()));
        }
    }

    protected boolean selectASuggestion() {
        if (this.iFilter.getText().equals(this.iLastSelected)) {
            return false;
        }
        this.iLastSelected = this.iFilter.getText();
        Interval parsed = this.parse(this.iLastSelected);
        if (parsed != null) {
            if (!this.isAllowMultiSelection()) {
                return this.iPopupMenu.selectItem(parsed) >= 0;
            }
            if (parsed.isAll()) {
                return this.iPopupMenu.selectItem(0);
            }
            int idx = this.iPopupMenu.selectItem(parsed);
            if (idx >= 0 && !parsed.isOne()) {
                return true;
            }
            for (int i = this.iPopupMenu.getNumItems() - 1; i >= 0; --i) {
                IntervalMenuItem item = (IntervalMenuItem)this.iPopupMenu.itemAt(i);
                if (item.getInterval().getLast() == null) continue;
                this.iPopupMenu.removeItem(item);
            }
            idx = this.iPopupMenu.indexOf(new Interval(parsed.getFirst()));
            if (idx >= 0) {
                for (int j = this.iValues.size() - 1; j > this.iValues.indexOf(parsed.getFirst()); --j) {
                    if (this.isFilterEnabled() && this.filter(this.iValues.get(j))) continue;
                    Interval multi = new Interval(parsed.getFirst(), this.iValues.get(j));
                    this.iPopupMenu.insertItem(new IntervalMenuItem(multi), idx + 1);
                }
            }
            return this.iPopupMenu.selectItem(parsed) >= 0;
        }
        block2: for (int i = 0; i < this.iPopupMenu.getNumItems(); ++i) {
            IntervalMenuItem item = (IntervalMenuItem)this.iPopupMenu.itemAt(i);
            String text = this.getReplaceString(item.getInterval()).toLowerCase();
            for (String c : this.iLastSelected.split("[ \\(\\),]")) {
                if (!text.contains(c.trim().toLowerCase())) continue block2;
            }
            this.iPopupMenu.selectItem(i);
            return true;
        }
        if (this.iDefaultValue != null) {
            return this.iPopupMenu.selectItem(this.iDefaultValue) >= 0;
        }
        return false;
    }

    public Interval parse(String name) {
        if (this.iValues == null) {
            return null;
        }
        if (name == null || name.isEmpty()) {
            return this.iAllowMultiSelection ? new Interval() : null;
        }
        for (int i = 0; i < this.iValues.size(); ++i) {
            if (this.isFilterEnabled() && this.filter(this.iValues.get(i))) continue;
            if (this.iValues.get(i).toString().toLowerCase().startsWith(name.toLowerCase())) {
                return new Interval(this.iValues.get(i));
            }
            if (!this.iAllowMultiSelection) continue;
            for (int j = i + 1; j < this.iValues.size(); ++j) {
                if (this.isFilterEnabled() && this.filter(this.iValues.get(j))) continue;
                if ((this.iValues.get(i) + " - " + this.iValues.get(j)).toLowerCase().startsWith(name.toLowerCase())) {
                    return new Interval(this.iValues.get(i), this.iValues.get(j));
                }
                if (!(this.iValues.get(i) + "-" + this.iValues.get(j)).toLowerCase().startsWith(name.toLowerCase())) continue;
                return new Interval(this.iValues.get(i), this.iValues.get(j));
            }
        }
        return null;
    }

    public boolean isAllowMultiSelection() {
        return this.iAllowMultiSelection;
    }

    public void setAllowMultiSelection(boolean allowMultiSelection) {
        this.iAllowMultiSelection = false;
    }

    public void setValues(List<T> values) {
        this.iValues = values;
        if (this.iValue != null && !this.iValue.isAll()) {
            if (this.iValue.isOne()) {
                if (!this.iValues.contains(this.iValue.getFirst())) {
                    this.setValue(this.iDefaultValue, true);
                }
            } else if (!this.iValues.contains(this.iValue.getFirst()) || !this.iValues.contains(this.iValue.getLast())) {
                this.setValue(this.iDefaultValue, true);
            }
        }
        this.createSuggestions();
    }

    public boolean hasValues() {
        return this.iValues != null && !this.iValues.isEmpty();
    }

    public List<T> getValues() {
        return this.iValues;
    }

    public void setValues(T ... values) {
        ArrayList<T> valuesAsList = new ArrayList<T>(values == null ? 0 : values.length);
        if (values != null) {
            for (T t : values) {
                valuesAsList.add(t);
            }
        }
        this.setValues((List<T>)valuesAsList);
    }

    public Interval createInterval(T first, T last) {
        return new Interval(first, last);
    }

    public Interval createInterval(T first) {
        return new Interval(first);
    }

    public Interval createInterval() {
        return new Interval();
    }

    protected Interval previous(Interval interval) {
        if (this.iValues != null && interval.isOne()) {
            if (this.filter(interval.getFirst())) {
                return null;
            }
            for (int idx = this.iValues.indexOf(interval.getFirst()) - 1; idx >= 0; --idx) {
                if (this.filter(this.iValues.get(idx))) continue;
                return new Interval(this.iValues.get(idx));
            }
            if (this.isAllowMultiSelection()) {
                Interval all = new Interval();
                all.setEnableFilter(this.isFilterEnabled());
                return all;
            }
        }
        return null;
    }

    protected Interval next(Interval interval) {
        block5: {
            block4: {
                if (this.iValues == null) {
                    return null;
                }
                if (!interval.isOne()) break block4;
                if (this.filter(interval.getFirst())) {
                    return null;
                }
                for (int idx = this.iValues.indexOf(interval.getFirst()) + 1; idx < this.iValues.size(); ++idx) {
                    if (this.filter(this.iValues.get(idx))) continue;
                    return new Interval(this.iValues.get(idx));
                }
                break block5;
            }
            if (!interval.isAll()) break block5;
            for (T t : this.iValues) {
                if (this.filter(t)) continue;
                return new Interval(t);
            }
        }
        return null;
    }

    protected String getDisplayString(Interval interval) {
        if (interval.isAll()) {
            return interval.isEnableFilter() ? MESSAGES.itemAll() : MESSAGES.itemAllWithFilter();
        }
        if (interval.isOne()) {
            return interval.getFirst().toString();
        }
        return "&nbsp;&nbsp;&nbsp;" + interval.getFirst().toString() + " - " + interval.getLast().toString();
    }

    protected String getReplaceString(Interval interval) {
        if (interval.isAll()) {
            return "";
        }
        if (interval.isOne()) {
            return interval.getFirst().toString();
        }
        return interval.getFirst().toString() + " - " + interval.getLast().toString();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Interval> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Interval getValue() {
        return this.iValue;
    }

    public boolean isOne() {
        return this.getSelected().size() == 1;
    }

    public List<T> getSelected() {
        if (this.iValue == null) {
            if (this.hasFilter() && this.isFilterEnabled() && this.iValues != null) {
                ArrayList<T> values = new ArrayList<T>();
                for (T t : this.iValues) {
                    if (this.filter(t)) continue;
                    values.add(t);
                }
                return values;
            }
            return this.iValues;
        }
        return this.iValue.getSelected();
    }

    public Interval getDefaultValue() {
        return this.iDefaultValue;
    }

    public void setDefaultValue(Interval defaultValue) {
        this.iDefaultValue = defaultValue;
    }

    public void setValue(Interval value) {
        this.setValue(value, false);
    }

    public void setValue(Interval value, boolean fireEvents) {
        this.iValue = value;
        if (this.iValue == null) {
            this.iFilter.setText("");
            this.iPrev.setEnabled(false);
            this.iNext.setEnabled(false);
        } else {
            if (this.iValue.isAll()) {
                this.iFilterEnabled = this.iValue.isEnableFilter();
            }
            this.iFilter.setText(this.getReplaceString(this.iValue));
            this.iPrev.setEnabled(this.previous(this.iValue) != null);
            this.iNext.setEnabled(this.next(this.iValue) != null);
        }
        this.createSuggestions();
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public void setErrorHint(String hint) {
        this.iWidget.setErrorHint(hint);
    }

    public void setHint(String hint) {
        this.iWidget.setHint(hint);
    }

    public void clearHint() {
        this.iWidget.clearHint();
    }

    public void setFilter(Filter<T> filter) {
        this.iItemFilter = filter;
    }

    public boolean hasFilter() {
        return this.iItemFilter != null && !this.iItemFilter.isEmpty();
    }

    public boolean isFilterEnabled() {
        return this.iFilterEnabled;
    }

    public void setFilterEnabled(boolean enabled) {
        this.iFilterEnabled = enabled;
        if (this.iValue != null && this.iValue.isAll()) {
            this.iValue.setEnableFilter(this.hasFilter() && this.isFilterEnabled());
            this.iFilter.setText(this.getReplaceString(this.iValue));
        }
        this.createSuggestions();
    }

    public boolean filter(T t) {
        return this.isFilterEnabled() && this.hasFilter() ? this.iItemFilter.filter(t) : false;
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.iFilter.addFocusHandler(handler);
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.iFilter.addBlurHandler(handler);
    }

    @Override
    public String getAriaLabel() {
        return this.iFilter.getAriaLabel();
    }

    @Override
    public void setAriaLabel(String text) {
        this.iFilter.setAriaLabel(text);
    }

    public void setStatus(String text) {
        AriaStatus.getInstance().setHTML(text);
    }

    public String toAriaString() {
        return this.getValue() == null ? ARIA.emptyFilter() : this.getValue().toAriaString();
    }

    public static interface Filter<T> {
        public boolean filter(T var1);

        public boolean isEmpty();
    }

    public static class Button
    extends AbsolutePanel
    implements HasMouseDownHandlers {
        private boolean iEnabled = true;

        private Button(String caption) {
            this.getElement().setInnerHTML(caption);
            this.addStyleName("enabled");
            this.sinkEvents(4);
        }

        public boolean isEnabled() {
            return this.iEnabled;
        }

        public void setEnabled(boolean enabled) {
            if (this.iEnabled == enabled) {
                return;
            }
            this.iEnabled = enabled;
            if (this.iEnabled) {
                this.addStyleName("enabled");
                this.removeStyleName("disabled");
            } else {
                this.addStyleName("disabled");
                this.removeStyleName("enabled");
            }
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    MouseDownEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
        }

        public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)MouseDownEvent.getType());
        }
    }

    private class Menu
    extends MenuBar {
        Menu() {
            super(true);
            this.setStyleName("");
            this.setFocusOnHoverEnabled(false);
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public boolean selectItem(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.selectItem((MenuItem)items.get(index));
                IntervalSelector.this.iPopupScroll.ensureVisible((UIObject)items.get(index));
                return true;
            }
            return false;
        }

        public int selectItem(Interval interval) {
            List items = this.getItems();
            for (int i = 0; i < items.size(); ++i) {
                if (!((IntervalMenuItem)((Object)items.get(i))).getInterval().equals(interval)) continue;
                this.selectItem((MenuItem)items.get(i));
                IntervalSelector.this.iPopupScroll.ensureVisible((UIObject)items.get(i));
                return i;
            }
            return -1;
        }

        public int indexOf(Interval interval) {
            List items = this.getItems();
            for (int i = 0; i < items.size(); ++i) {
                if (!((IntervalMenuItem)((Object)items.get(i))).getInterval().equals(interval)) continue;
                return i;
            }
            return -1;
        }

        public void scrollToView() {
            List items = this.getItems();
            int index = this.getSelectedItemIndex();
            if (index > -1 && index < items.size()) {
                IntervalSelector.this.iPopupScroll.ensureVisible((UIObject)items.get(index));
            }
        }

        public void executeSelected() {
            MenuItem selected = this.getSelectedItem();
            if (selected != null) {
                selected.getScheduledCommand().execute();
            }
        }

        public MenuItem itemAt(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                return (MenuItem)items.get(index);
            }
            return null;
        }

        public IntervalMenuItem getSelectedInterval() {
            return (IntervalMenuItem)this.getSelectedItem();
        }
    }

    private class IntervalMenuItem
    extends MenuItem {
        private Interval iInterval;

        private IntervalMenuItem(Interval interval) {
            super(IntervalSelector.this.getDisplayString(interval), true, (Scheduler.ScheduledCommand)new IntervalCommand(interval));
            this.setStyleName("item");
            this.getElement().setAttribute("whiteSpace", "nowrap");
            this.iInterval = interval;
        }

        public Interval getInterval() {
            return this.iInterval;
        }

        public String toAriaString() {
            return this.getInterval() == null ? ARIA.emptyFilter() : this.getInterval().toAriaString();
        }
    }

    public class Interval {
        private T iFirst = null;
        private T iLast = null;
        private boolean iEnableFilter = false;

        public Interval() {
            this(null, null);
        }

        public Interval(T first) {
            this(first, null);
        }

        public Interval(T first, T last) {
            this.iFirst = first;
            if (last != null && !last.equals(first) && IntervalSelector.this.iValues.indexOf(first) < IntervalSelector.this.iValues.indexOf(last)) {
                this.iLast = last;
            }
        }

        public T getFirst() {
            return this.iFirst;
        }

        public T getLast() {
            return this.iLast;
        }

        public boolean isAll() {
            return this.iFirst == null;
        }

        public boolean isOne() {
            return this.iFirst != null && this.iLast == null;
        }

        public int getNrSelected() {
            return this.isAll() ? IntervalSelector.this.iValues.size() : (this.isOne() ? 1 : IntervalSelector.this.iValues.indexOf(this.iLast) - IntervalSelector.this.iValues.indexOf(this.iFirst) + 1);
        }

        public List<T> getSelected() {
            ArrayList ret = new ArrayList();
            if (this.isAll()) {
                for (Object t : IntervalSelector.this.iValues) {
                    if (IntervalSelector.this.filter(t)) continue;
                    ret.add(t);
                }
            } else if (this.isOne()) {
                ret.add(this.iFirst);
            } else {
                for (int i = IntervalSelector.this.iValues.indexOf(this.iFirst); i <= IntervalSelector.this.iValues.indexOf(this.iLast); ++i) {
                    if (IntervalSelector.this.filter(IntervalSelector.this.iValues.get(i))) continue;
                    ret.add(IntervalSelector.this.iValues.get(i));
                }
            }
            return ret;
        }

        public String toString() {
            return IntervalSelector.this.getReplaceString(this);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Interval)) {
                return false;
            }
            Interval i = (Interval)o;
            if (this.isEnableFilter() != i.isEnableFilter()) {
                return false;
            }
            return (this.getFirst() == null ? i.getFirst() == null : this.getFirst().equals(i.getFirst())) && (this.getLast() == null ? i.getLast() == null : this.getLast().equals(i.getLast()));
        }

        public boolean isEnableFilter() {
            return this.iEnableFilter;
        }

        public void setEnableFilter(boolean enable) {
            this.iEnableFilter = enable;
        }

        public String toAriaString() {
            return IntervalSelector.this.getDisplayString(this);
        }
    }

    private class IntervalCommand
    implements Command {
        private Interval iInterval;

        private IntervalCommand(Interval interval) {
            this.iInterval = interval;
        }

        public Interval getInterval() {
            return this.iInterval;
        }

        public String toString() {
            return IntervalSelector.this.getDisplayString(this.getInterval());
        }

        public void execute() {
            IntervalSelector.this.hideSuggestions();
            IntervalSelector.this.setValue(this.getInterval(), !this.getInterval().equals(IntervalSelector.this.getValue()));
            IntervalSelector.this.iLastSelected = IntervalSelector.this.getReplaceString(this.getInterval());
            if (IntervalSelector.this.getValue() != null) {
                IntervalSelector.this.setStatus(ARIA.suggestionSelected(IntervalSelector.this.toAriaString()));
            }
        }
    }
}

