/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class TableWidget
extends UniTimeTable<TableInterface.LineInterface> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);

    public TableWidget() {
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<TableInterface.LineInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TableInterface.LineInterface> event) {
                if (event.getData().hasURL()) {
                    LoadingWidget.showLoading(MESSAGES.waitLoadingPage());
                    ToolBox.open(event.getData().getURL());
                }
            }
        });
    }

    public TableWidget(TableInterface table) {
        this();
        this.setData(table);
    }

    protected static void applyStyle(Style style, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        for (String param : text.split(";")) {
            if (param.indexOf(58) < 0) continue;
            String key = param.substring(0, param.indexOf(58)).trim();
            String value = param.substring(param.indexOf(58) + 1).trim();
            if (value.isEmpty()) {
                style.clearProperty(key);
                continue;
            }
            style.setProperty(key, value);
        }
    }

    public void setData(TableInterface table) {
        int row;
        ArrayList<CellWidget> cells;
        this.clearTable();
        if (table.getHeader() != null) {
            for (final TableInterface.LineInterface line : table.getHeader()) {
                if (!line.hasCells()) continue;
                cells = new ArrayList<CellWidget>();
                for (TableInterface.CellInterface cell : line.getCells()) {
                    cells.add(new CellWidget(cell));
                }
                row = this.addRow(line, cells);
                if (line.hasBgColor()) {
                    this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(line.getBgColor());
                }
                if (line.hasTitle()) {
                    this.getRowFormatter().getElement(row).setTitle(line.getTitle());
                }
                if (!line.hasStyle()) continue;
                TableWidget.applyStyle(this.getRowFormatter().getElement(row).getStyle(), line.getStyle());
            }
        }
        if (table.hasErrorMessage()) {
            ArrayList<ErrorWidget> cells2 = new ArrayList<ErrorWidget>();
            cells2.add(new ErrorWidget(table));
            this.addRow(null, cells2);
        }
        if (table.getLines() != null) {
            for (final TableInterface.LineInterface line : table.getLines()) {
                if (!line.hasCells()) continue;
                cells = new ArrayList();
                for (TableInterface.CellInterface cell : line.getCells()) {
                    cells.add(new CellWidget(cell));
                }
                if (line.hasWarning() && !cells.isEmpty()) {
                    Image warning = new Image(RESOURCES.warning());
                    warning.setTitle(line.getWarning());
                    warning.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            UniTimeConfirmationDialog.alert(line.getWarning());
                        }
                    });
                    ((CellWidget)cells.get(0)).insert((Widget)warning, 0);
                }
                row = this.addRow(line, cells);
                if (line.hasBgColor()) {
                    this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(line.getBgColor());
                }
                if (line.hasTitle()) {
                    this.getRowFormatter().getElement(row).setTitle(line.getTitle());
                }
                if (!line.hasStyle()) continue;
                TableWidget.applyStyle(this.getRowFormatter().getElement(row).getStyle(), line.getStyle());
            }
        }
    }

    public static native void setLastMouseOverElement(Element var0);

    public static class CellWidget
    extends P
    implements UniTimeTable.HasColSpan,
    UniTimeTable.HasRowSpan,
    UniTimeTable.HasCellAlignment,
    UniTimeTable.HasVerticalCellAlignment,
    UniTimeTable.HasStyleName {
        private TableInterface.CellInterface iCell;

        CellWidget(TableInterface.CellInterface cell) {
            super((Element)(cell.isInline() ? DOM.createSpan() : DOM.createDiv()), new String[0]);
            this.iCell = cell;
            if (cell.hasText()) {
                if (cell.isHtml()) {
                    this.setHTML(cell.getText());
                } else {
                    this.setText(cell.getText());
                }
            } else if (!cell.hasItems()) {
                this.setText("\u202f");
            }
            if (cell.hasTitle()) {
                this.setTitle(cell.getTitle());
            }
            if (cell.hasAnchors()) {
                for (String anchor : cell.getAnchors()) {
                    Anchor a = new Anchor();
                    a.setName(anchor);
                    a.getElement().setId(anchor);
                    this.add((Widget)a);
                }
            }
            if (cell.hasStyle()) {
                TableWidget.applyStyle(this.getElement().getStyle(), cell.getStyle());
            }
            if (cell.hasImage()) {
                Image img = new Image(cell.getImage().getSource());
                if (cell.getImage().hasAlt()) {
                    img.setAltText(cell.getImage().getAlt());
                }
                if (cell.getImage().hasTitle()) {
                    img.setTitle(cell.getImage().getTitle());
                }
                this.add((Widget)img);
            }
            if (cell.hasColor()) {
                this.getElement().getStyle().setColor(cell.getColor());
            }
            if (cell.isNoWrap()) {
                this.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
            } else if (cell.isWrap()) {
                this.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
            }
            if (cell.hasMouseOver()) {
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent e) {
                        TableWidget.setLastMouseOverElement((Element)this.getElement());
                        ToolBox.eval(iCell.getMouseOver());
                    }
                });
            }
            if (cell.hasMouseOut()) {
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent e) {
                        ToolBox.eval(iCell.getMouseOut());
                    }
                });
            }
            if (cell.hasIndent()) {
                this.getElement().getStyle().setPaddingLeft((double)cell.getIndent().intValue() * 10.0, Style.Unit.PX);
            }
            if (cell.hasItems()) {
                for (TableInterface.CellInterface item : cell.getItems()) {
                    this.add((Widget)new CellWidget(item));
                }
            }
        }

        @Override
        public int getColSpan() {
            return this.iCell.getColSpan();
        }

        @Override
        public int getRowSpan() {
            return this.iCell.getRowSpan();
        }

        @Override
        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalCellAlignment() {
            switch (this.iCell.getHorizontalAlignment()) {
                case TOP: {
                    return HasVerticalAlignment.ALIGN_TOP;
                }
                case MIDLE: {
                    return HasVerticalAlignment.ALIGN_MIDDLE;
                }
                case BOTTOM: {
                    return HasVerticalAlignment.ALIGN_BOTTOM;
                }
            }
            return null;
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            switch (this.iCell.getTextAlignment()) {
                case LEFT: {
                    return HasHorizontalAlignment.ALIGN_LEFT;
                }
                case CENTER: {
                    return HasHorizontalAlignment.ALIGN_CENTER;
                }
                case RIGHT: {
                    return HasHorizontalAlignment.ALIGN_RIGHT;
                }
            }
            return null;
        }

        @Override
        public String getStyleName() {
            return this.iCell.getClassName();
        }
    }

    public static class ErrorWidget
    extends P
    implements UniTimeTable.HasColSpan {
        private TableInterface iTable;

        ErrorWidget(TableInterface table) {
            super("unitime-ErrorMessage");
            this.setText(table.getErrorMessage());
            this.iTable = table;
        }

        @Override
        public int getColSpan() {
            int cols = this.iTable.getMaxColumns();
            return cols <= 0 ? 1 : cols;
        }
    }
}

