/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.tables;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;

public class TableInterface
implements IsSerializable {
    private String iName;
    private String iStyle;
    private String iErrorMessage;
    private String iClassName;
    private List<LineInterface> iHeader;
    private List<LineInterface> iLines;
    private String iAnchor;
    private List<LinkInteface> iLinks;

    public List<LineInterface> getHeader() {
        return this.iHeader;
    }

    public void addHeader(LineInterface header) {
        if (this.iHeader == null) {
            this.iHeader = new ArrayList<LineInterface>();
        }
        this.iHeader.add(header);
    }

    public List<LineInterface> getLines() {
        return this.iLines;
    }

    public void addLine(LineInterface line) {
        if (this.iLines == null) {
            this.iLines = new ArrayList<LineInterface>();
        }
        this.iLines.add(line);
    }

    public List<LinkInteface> getLinks() {
        return this.iLinks;
    }

    public void addLink(LinkInteface link) {
        if (this.iLinks == null) {
            this.iLinks = new ArrayList<LinkInteface>();
        }
        this.iLinks.add(link);
    }

    public int getMaxColumns() {
        int cols;
        int ret = 0;
        if (this.iHeader != null) {
            for (LineInterface line : this.iHeader) {
                cols = line.getMaxColumns();
                if (ret >= cols) continue;
                ret = cols;
            }
        }
        if (this.iLines != null) {
            for (LineInterface line : this.iLines) {
                cols = line.getMaxColumns();
                if (ret >= cols) continue;
                ret = cols;
            }
        }
        return ret;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getName() {
        return this.iName;
    }

    public boolean hasName() {
        return this.iName != null && !this.iName.isEmpty();
    }

    public String getStyle() {
        return this.iStyle;
    }

    public void setStyle(String style) {
        this.iStyle = style;
    }

    public boolean hasStyle() {
        return this.iStyle != null && !this.iStyle.isEmpty();
    }

    public String getClassName() {
        return this.iClassName;
    }

    public void setClassName(String className) {
        this.iClassName = className;
    }

    public boolean hasClassName() {
        return this.iClassName != null && !this.iClassName.isEmpty();
    }

    public String getAnchor() {
        return this.iAnchor;
    }

    public void setAnchor(String anchor) {
        this.iAnchor = anchor;
    }

    public boolean hasAnchor() {
        return this.iAnchor != null && !this.iAnchor.isEmpty();
    }

    public String getErrorMessage() {
        return this.iErrorMessage;
    }

    public void setErrorMessage(String error) {
        this.iErrorMessage = error;
    }

    public boolean hasErrorMessage() {
        return this.iErrorMessage != null && !this.iErrorMessage.isEmpty();
    }

    public static class LineInterface
    implements IsSerializable {
        private ArrayList<CellInterface> iCells;
        private String iStyle;
        private String iClassName;
        private String iBgColor;
        private String iURL;
        private String iTitle;
        private String iWarning;
        private String iAnchor;

        public List<CellInterface> getCells() {
            return this.iCells;
        }

        public void addCell(CellInterface cell) {
            if (this.iCells == null) {
                this.iCells = new ArrayList();
            }
            this.iCells.add(cell);
        }

        public boolean hasCells() {
            return this.iCells != null && !this.iCells.isEmpty();
        }

        public String getStyle() {
            return this.iStyle;
        }

        public void setStyle(String style) {
            this.iStyle = style;
        }

        public boolean hasStyle() {
            return this.iStyle != null && !this.iStyle.isEmpty();
        }

        public String getClassName() {
            return this.iClassName;
        }

        public void setClassName(String className) {
            this.iClassName = className;
        }

        public boolean hasClassName() {
            return this.iClassName != null && !this.iClassName.isEmpty();
        }

        public String getBgColor() {
            return this.iBgColor;
        }

        public void setBgColor(String bgColor) {
            this.iBgColor = bgColor;
        }

        public boolean hasBgColor() {
            return this.iBgColor != null && !this.iBgColor.isEmpty();
        }

        public String getURL() {
            return this.iURL;
        }

        public void setURL(String url) {
            this.iURL = url;
        }

        public boolean hasURL() {
            return this.iURL != null && !this.iURL.isEmpty();
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getWarning() {
            return this.iWarning;
        }

        public void setWarning(String warning) {
            this.iWarning = warning;
        }

        public boolean hasWarning() {
            return this.iWarning != null && !this.iWarning.isEmpty();
        }

        public String getAnchor() {
            return this.iAnchor;
        }

        public void setAnchor(String anchor) {
            this.iAnchor = anchor;
        }

        public boolean hasAnchor() {
            return this.iAnchor != null && !this.iAnchor.isEmpty();
        }

        public int getMaxColumns() {
            if (this.iCells == null) {
                return 0;
            }
            int ret = 0;
            for (CellInterface cell : this.iCells) {
                ret += cell.getColSpan();
            }
            return ret;
        }
    }

    public static interface ImageGenerator {
        public Object generate();
    }

    public static interface FilterInterface {
        public boolean hasParameter(String var1);

        public String getParameterValue(String var1);

        public String getParameterValue(String var1, String var2);
    }

    public static class ImageInterface
    implements IsSerializable {
        private String iSource;
        private String iTitle;
        private String iAlt;
        private transient ImageGenerator iGenerator;

        public ImageInterface setSource(String source) {
            this.iSource = source;
            return this;
        }

        public String getSource() {
            return this.iSource;
        }

        public boolean hasSource() {
            return this.iSource != null && !this.iSource.isEmpty();
        }

        public String getTitle() {
            return this.iTitle;
        }

        public ImageInterface setTitle(String title) {
            this.iTitle = title;
            return this;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getAlt() {
            return this.iAlt;
        }

        public ImageInterface setAlt(String alt) {
            this.iAlt = alt;
            return this;
        }

        public boolean hasAlt() {
            return this.iAlt != null && !this.iAlt.isEmpty();
        }

        public ImageGenerator getGenerator() {
            return this.iGenerator;
        }

        public ImageInterface setGenerator(ImageGenerator generator) {
            this.iGenerator = generator;
            return this;
        }
    }

    public static class CellInterface
    implements IsSerializable {
        private String iText;
        private String iAria;
        private String iTitle;
        private String iStyle;
        private String iClassName;
        private List<CellInterface> iItems;
        private Integer iRowSpan;
        private Integer iColSpan;
        private Alignment iTextAlignment;
        private Alignment iHorizontalAlignment;
        private Boolean iNoWrap;
        private Boolean iInline;
        private Boolean iHtml;
        private List<String> iAnchors;
        private String iColor;
        private Integer iIndent;
        private String iMouseOver;
        private String iMouseOut;
        private ImageInterface iImage;
        private Integer iWidth;

        public String getText() {
            return this.iText;
        }

        public CellInterface setText(String text) {
            this.iText = text;
            return this;
        }

        public CellInterface setHtml(String text) {
            this.iText = text;
            this.iHtml = true;
            return this;
        }

        public boolean hasText() {
            return this.iText != null && !this.iText.isEmpty();
        }

        @Deprecated
        public void addContent(String text) {
            this.iText = this.iText == null ? text : this.iText + text;
        }

        public String getAria() {
            return this.iAria;
        }

        public CellInterface setAria(String aria) {
            this.iAria = aria;
            return this;
        }

        public boolean hasAria() {
            return this.iAria != null && !this.iAria.isEmpty();
        }

        public String getStyle() {
            return this.iStyle;
        }

        public void setStyle(String style) {
            this.iStyle = style;
        }

        public CellInterface addStyle(String style) {
            this.iStyle = this.iStyle == null ? style : this.iStyle + style;
            return this;
        }

        public boolean hasStyle() {
            return this.iStyle != null && !this.iStyle.isEmpty();
        }

        public String getClassName() {
            return this.iClassName;
        }

        public CellInterface setClassName(String className) {
            this.iClassName = className;
            return this;
        }

        public boolean hasClassName() {
            return this.iClassName != null && !this.iClassName.isEmpty();
        }

        public String getTitle() {
            return this.iTitle;
        }

        public CellInterface setTitle(String title) {
            this.iTitle = title;
            return this;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getColor() {
            return this.iColor;
        }

        public CellInterface setColor(String color) {
            this.iColor = color;
            return this;
        }

        public boolean hasColor() {
            return this.iColor != null && !this.iColor.isEmpty();
        }

        public Integer getWidth() {
            return this.iWidth;
        }

        public CellInterface setWidth(Integer width) {
            this.iWidth = width;
            return this;
        }

        public boolean hasWidth() {
            return this.iWidth != null;
        }

        public List<CellInterface> getItems() {
            return this.iItems;
        }

        public CellInterface addItem(CellInterface item) {
            if (this.iItems == null) {
                this.iItems = new ArrayList<CellInterface>();
            }
            this.iItems.add(item);
            return this;
        }

        public boolean hasItems() {
            return this.iItems != null && !this.iItems.isEmpty();
        }

        public CellInterface add(String text) {
            CellInterface cell = new CellInterface();
            cell.setText(text);
            this.addItem(cell);
            return cell;
        }

        public CellInterface add(String text, boolean html) {
            return this.add(text).setHtml(html);
        }

        public CellInterface addBlankLine() {
            return this.add("").setInline(false);
        }

        public List<String> getAnchors() {
            return this.iAnchors;
        }

        public CellInterface addAnchor(String anchor) {
            if (this.iAnchors == null) {
                this.iAnchors = new ArrayList<String>();
            }
            this.iAnchors.add(anchor);
            return this;
        }

        public boolean hasAnchors() {
            return this.iAnchors != null && !this.iAnchors.isEmpty();
        }

        public Integer getIndent() {
            return this.iIndent;
        }

        public CellInterface setIndent(int indent) {
            this.iIndent = indent;
            return this;
        }

        public boolean hasIndent() {
            return this.iIndent != null && this.iIndent > 0;
        }

        public String getMouseOver() {
            return this.iMouseOver;
        }

        public CellInterface setMouseOver(String mouseOver) {
            this.iMouseOver = mouseOver;
            return this;
        }

        public boolean hasMouseOver() {
            return this.iMouseOver != null && !this.iMouseOver.isEmpty();
        }

        public String getMouseOut() {
            return this.iMouseOut;
        }

        public CellInterface setMouseOut(String mouseOut) {
            this.iMouseOut = mouseOut;
            return this;
        }

        public boolean hasMouseOut() {
            return this.iMouseOut != null && !this.iMouseOut.isEmpty();
        }

        public int getRowSpan() {
            return this.iRowSpan == null ? 1 : this.iRowSpan;
        }

        public CellInterface setRowSpan(int rowSpan) {
            this.iRowSpan = rowSpan;
            return this;
        }

        public int getColSpan() {
            return this.iColSpan == null ? 1 : this.iColSpan;
        }

        public CellInterface setColSpan(int colSpan) {
            this.iColSpan = colSpan;
            return this;
        }

        public Alignment getTextAlignment() {
            return this.iTextAlignment == null ? Alignment.LEFT : this.iTextAlignment;
        }

        public CellInterface setTextAlignment(Alignment alignment) {
            this.iTextAlignment = alignment;
            return this;
        }

        public Alignment getHorizontalAlignment() {
            return this.iHorizontalAlignment == null ? Alignment.TOP : this.iHorizontalAlignment;
        }

        public CellInterface setHorizontalAlignment(Alignment alignment) {
            this.iHorizontalAlignment = alignment;
            return this;
        }

        public boolean isNoWrap() {
            return this.iNoWrap != null && this.iNoWrap != false;
        }

        public boolean isWrap() {
            return this.iNoWrap != null && this.iNoWrap == false;
        }

        public CellInterface setNoWrap(boolean noWrap) {
            this.iNoWrap = noWrap;
            return this;
        }

        public boolean isInline() {
            return this.iInline == null || this.iInline != false;
        }

        public CellInterface setInline(boolean inline) {
            this.iInline = inline;
            return this;
        }

        public boolean isHtml() {
            return this.iHtml != null && this.iHtml != false;
        }

        public CellInterface setHtml(boolean html) {
            this.iHtml = html;
            return this;
        }

        public boolean hasNoWrap() {
            if (this.isNoWrap()) {
                return true;
            }
            if (this.hasItems()) {
                for (CellInterface item : this.getItems()) {
                    if (!item.hasNoWrap()) continue;
                    return true;
                }
            }
            return false;
        }

        public CellInterface setImage(ImageInterface image) {
            this.iImage = image;
            return this;
        }

        public ImageInterface getImage() {
            return this.iImage;
        }

        public boolean hasImage() {
            return this.iImage != null && this.iImage.hasSource();
        }

        public String toString() {
            return this.toString(null, 0);
        }

        protected String toString(CellInterface parent, int idx) {
            int i;
            Object ret = "";
            if (parent != null && !this.isInline() && idx > 0) {
                ret = "\n";
            }
            if (this.hasIndent()) {
                for (i = 0; i < this.getIndent(); ++i) {
                    ret = (String)ret + "  ";
                }
            }
            if (this.hasAria()) {
                ret = (String)ret + this.getAria();
                return ret;
            }
            if (this.hasText() && !this.isHtml()) {
                ret = (String)ret + this.getText();
            } else if (this.hasTitle()) {
                ret = (String)ret + this.getTitle();
            } else if (this.hasImage() && this.getImage().hasTitle()) {
                ret = (String)ret + this.getImage().getTitle();
            }
            if (this.hasItems()) {
                i = 0;
                for (CellInterface cell : this.getItems()) {
                    ret = (String)ret + cell.toString(this, i++);
                }
            }
            return ret;
        }

        public static enum Alignment {
            LEFT,
            CENTER,
            RIGHT,
            TOP,
            MIDLE,
            BOTTOM;

        }
    }

    public static class LinkInteface
    implements IsSerializable {
        private String iHref;
        private String iText;

        public String getText() {
            return this.iText;
        }

        public LinkInteface setText(String text) {
            this.iText = text;
            return this;
        }

        public String getHref() {
            return this.iHref;
        }

        public LinkInteface setHref(String href) {
            this.iHref = href;
            return this;
        }
    }
}

