/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.rooms.RoomFilterBox;
import org.unitime.timetable.gwt.client.widgets.CourseNumbersSuggestBox;
import org.unitime.timetable.gwt.client.widgets.DayCodeSelector;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.FilterInterface;

public class PageFilter
extends SimpleForm
implements HasValue<FilterInterface> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final CourseMessages MSG = (CourseMessages)GWT.create(CourseMessages.class);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private FilterInterface iFilter;
    private int iFilterHeaderRow = -1;
    private int iFilterLastRow = -1;
    private List<Integer> iCollapsibleRows = new ArrayList<Integer>();
    private Map<String, Widget> iWidgets = new HashMap<String, Widget>();
    private Command iSubmitCommand;

    public PageFilter() {
        this.addStyleName("unitime-PageFilter");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iHeader.setCollapsible(true);
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                for (int row : PageFilter.this.iCollapsibleRows) {
                    PageFilter.this.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                }
            }
        });
        this.iFilterLastRow = this.iFilterHeaderRow = this.addHeaderRow((Widget)this.iHeader);
        this.iFooter = this.iHeader.clonePanel(null);
    }

    public UniTimeHeaderPanel getHeader() {
        return this.iHeader;
    }

    public UniTimeHeaderPanel getFooter() {
        return this.iFooter;
    }

    public Command getSubmitCommand() {
        return this.iSubmitCommand;
    }

    public void setSubmitCommand(Command command) {
        this.iSubmitCommand = command;
    }

    protected Widget getWidget(final FilterInterface.FilterParameterInterface param) {
        if (param.hasOptions()) {
            final ListBox list = new ListBox();
            list.setMultipleSelect(param.isMultiSelect());
            if (!param.isMultiSelect()) {
                list.addItem(MESSAGES.itemSelect());
            }
            for (FilterInterface.ListItem item : param.getOptions()) {
                list.addItem(item.getText(), item.getValue());
                if (param.isMultiSelect()) {
                    list.setItemSelected(list.getItemCount() - 1, param.isDefaultItem(item));
                    continue;
                }
                if (!param.isDefaultItem(item)) continue;
                list.setSelectedIndex(list.getItemCount() - 1);
            }
            if (list.isMultipleSelect()) {
                list.getElement().setAttribute("size", String.valueOf(Math.min(param.getMaxLinesToShow(), param.getOptions().size())));
            }
            list.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    if (param.isMultiSelect()) {
                        Object value = "";
                        for (int i = 0; i < list.getItemCount(); ++i) {
                            if (!list.isItemSelected(i)) continue;
                            value = (String)value + (((String)value).isEmpty() ? "" : ",") + list.getValue(i);
                        }
                        param.setValue((String)value);
                    } else if (list.getSelectedIndex() <= 0) {
                        param.setValue(null);
                    } else {
                        param.setValue(list.getValue(list.getSelectedIndex()));
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return list;
        }
        if ("roomFilter".equals(param.getName())) {
            AcademicSessionProvider session = new AcademicSessionProvider(){

                @Override
                public Long getAcademicSessionId() {
                    return param.getSessionId();
                }

                @Override
                public String getAcademicSessionName() {
                    return "Current Session";
                }

                @Override
                public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
                }

                @Override
                public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
                }

                @Override
                public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
                    return null;
                }
            };
            RoomFilterBox rf = new RoomFilterBox(session);
            if (param.hasDefaultValue()) {
                rf.setValue(param.getDefaultValue());
            }
            rf.addValueChangeHandler(new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    param.setValue((String)event.getValue());
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return rf;
        }
        if ("boolean".equalsIgnoreCase(param.getType())) {
            CheckBox ch = new CheckBox();
            ch.setValue(Boolean.valueOf("1".equalsIgnoreCase(param.getDefaultValue())));
            ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((Boolean)event.getValue() != false ? "1" : "0");
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return ch;
        }
        if ("file".equalsIgnoreCase(param.getType())) {
            UniTimeFileUpload upload = new UniTimeFileUpload();
            upload.reset();
            upload.addValueChangeHandler(new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return upload;
        }
        if ("textarea".equalsIgnoreCase(param.getType())) {
            TextArea textarea = new TextArea();
            textarea.setStyleName("unitime-TextArea");
            textarea.setVisibleLines(5);
            textarea.setCharacterWidth(80);
            if (param.hasDefaultValue()) {
                textarea.setText(param.getDefaultValue());
            }
            textarea.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return textarea;
        }
        if ("integer".equalsIgnoreCase(param.getType()) || "int".equalsIgnoreCase(param.getType()) || "long".equalsIgnoreCase(param.getType()) || "short".equalsIgnoreCase(param.getType()) || "byte".equalsIgnoreCase(param.getType())) {
            NumberBox text = new NumberBox();
            text.setDecimal(false);
            text.setNegative(true);
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("number".equalsIgnoreCase(param.getType()) || "float".equalsIgnoreCase(param.getType()) || "double".equalsIgnoreCase(param.getType())) {
            NumberBox text = new NumberBox();
            text.setDecimal(true);
            text.setNegative(true);
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("date".equalsIgnoreCase(param.getType())) {
            SingleDateSelector text = new SingleDateSelector();
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            final DateTimeFormat format = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
            text.addValueChangeHandler(new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue(format.format((Date)event.getValue()));
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("time".equalsIgnoreCase(param.getType())) {
            TimeSelector text = new TimeSelector((TimeSelector)this.iWidgets.get("startTime"));
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            text.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                public void onValueChange(ValueChangeEvent<Integer> event) {
                    if (event.getValue() == null) {
                        param.setValue("");
                    } else {
                        param.setValue(((Integer)event.getValue()).toString());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("dayCode".equalsIgnoreCase(param.getType())) {
            DayCodeSelector text = new DayCodeSelector();
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            text.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                public void onValueChange(ValueChangeEvent<Integer> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue(((Integer)event.getValue()).toString());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return text;
        }
        if ("courseNumber".equalsIgnoreCase(param.getType())) {
            AriaTextBox text = new AriaTextBox();
            text.setWidth("200px");
            text.getElement().setAttribute("autocomplete", "off");
            text.setTitle(MSG.tooltipCourseNumber());
            if (param.hasDefaultValue()) {
                text.setText(param.getDefaultValue());
            }
            AriaSuggestBox box = new AriaSuggestBox(text, new CourseNumbersSuggestBox(param.getConfig()).withFilter(this.iFilter));
            text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (event.getValue() == null) {
                        param.setValue(null);
                    } else {
                        param.setValue((String)event.getValue());
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
                }
            });
            return box;
        }
        TextBox text = new TextBox();
        text.setStyleName("unitime-TextBox");
        text.setWidth("400px");
        if (param.hasDefaultValue()) {
            text.setText(param.getDefaultValue());
        }
        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (event.getValue() == null) {
                    param.setValue(null);
                } else {
                    param.setValue((String)event.getValue());
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)PageFilter.this, (Object)PageFilter.this.iFilter);
            }
        });
        return text;
    }

    public FilterInterface getValue() {
        return this.iFilter;
    }

    public void setValue(FilterInterface filter) {
        this.setValue(filter, true);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<FilterInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Widget getFilterWidget(String name) {
        return this.iWidgets.get(name);
    }

    public void setValue(FilterInterface filter, boolean fireEvents) {
        this.iFilter = filter;
        this.iWidgets.clear();
        for (int row = this.getRowCount() - 1; row > this.iFilterHeaderRow; --row) {
            this.removeRow(row);
        }
        this.iCollapsibleRows.clear();
        HashSet<String> parents = new HashSet<String>();
        String lastLabel = null;
        FilterInterface.FilterParameterInterface previous = null;
        for (FilterInterface.FilterParameterInterface param : filter.getParameters()) {
            int row;
            String value = Window.Location.getParameter((String)param.getName());
            if (value != null) {
                param.setDefaultValue(value);
            }
            Widget w = this.getWidget(param);
            if (param.isEnterToSubmit() && w instanceof HasKeyUpHandlers) {
                ((HasKeyUpHandlers)w).addKeyUpHandler(new KeyUpHandler(){

                    public void onKeyUp(KeyUpEvent event) {
                        if (event.getNativeEvent().getKeyCode() == 13 && PageFilter.this.iSubmitCommand != null) {
                            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                public void execute() {
                                    PageFilter.this.iSubmitCommand.execute();
                                }
                            });
                        }
                    }
                });
            }
            w.getElement().setId(param.getName());
            this.iWidgets.put(param.getName(), w);
            String label = param.getLabel();
            if (label.equals(lastLabel)) {
                label = "";
            } else {
                lastLabel = label;
            }
            P panel = new P("panel");
            if ((param.hasSuffix() || param.hasPrefix()) && param.hasPrefix()) {
                Label prefix = new Label(param.getPrefix());
                prefix.addStyleName("prefix");
                panel.add((Widget)prefix);
            }
            panel.add(w);
            if (param.hasSuffix()) {
                if (w instanceof CheckBox) {
                    ((CheckBox)w).setText(param.getSuffix());
                } else {
                    Label suffix = new Label(param.getSuffix());
                    suffix.addStyleName("suffix");
                    panel.add((Widget)suffix);
                }
            }
            if (label.isEmpty() && param.isComposite() && previous != null && previous.isComposite()) {
                row = this.iFilterLastRow;
                Widget widget = this.getWidget(row, 1);
                P prev = null;
                if (widget instanceof P && ((P)widget).getStyleName().contains("panel")) {
                    prev = (P)widget;
                } else {
                    prev = new P("panel");
                    prev.add(widget);
                }
                P composite = new P("composite");
                composite.add((Widget)prev);
                composite.add((Widget)panel);
                this.setWidget(row, 1, (Widget)composite);
            } else {
                row = panel.getWidgetCount() == 1 ? this.addRow(label, w) : this.addRow(label, (Widget)panel);
            }
            if (param.getParent() != null) {
                this.getWidget(row, 1).getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
                parents.add(param.getParent());
            }
            if (param.isCollapsible()) {
                this.iCollapsibleRows.add(row);
            }
            this.iFilterLastRow = row;
            previous = param;
            if (this.iHeader.isCollapsible() == null || this.iHeader.isCollapsible().booleanValue() || !param.isCollapsible()) continue;
            this.getRowFormatter().setVisible(this.iFilterLastRow, false);
        }
        if (this.iCollapsibleRows.isEmpty()) {
            this.iHeader.setCollapsible(null);
        } else if (this.iHeader.isCollapsible() == null) {
            this.iHeader.setCollapsible(false);
        }
        this.addBottomRow((Widget)this.iFooter);
        for (final String parent : parents) {
            Widget w = this.iWidgets.get(parent);
            if (w == null || !(w instanceof CheckBox)) continue;
            ((CheckBox)w).addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> e) {
                    for (FilterInterface.FilterParameterInterface p : PageFilter.this.iFilter.getParameters()) {
                        if (!parent.equals(p.getParent())) continue;
                        PageFilter.this.setValue(p.getName(), (Boolean)e.getValue() != false ? "1" : "0");
                    }
                }
            });
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.iFilter);
        }
    }

    public String getQuery() {
        Object query = "";
        for (FilterInterface.FilterParameterInterface param : this.iFilter.getParameters()) {
            String value = param.getValue();
            if (value == null) continue;
            query = (String)query + "&" + param.getName() + "=" + URL.encodeQueryString((String)value);
        }
        return query;
    }

    public String getFullQuery() {
        Object query = "";
        for (FilterInterface.FilterParameterInterface param : this.iFilter.getParameters()) {
            String value = param.getValue();
            if (value == null) {
                value = param.getDefaultValue();
            }
            if (value == null) continue;
            query = (String)query + "&" + param.getName() + "=" + URL.encodeQueryString((String)value);
        }
        return query;
    }

    public void setValue(String name, String value) {
        Widget w = this.iWidgets.get(name);
        FilterInterface.FilterParameterInterface param = this.iFilter.getParameter(name);
        if (param != null) {
            param.setValue(value);
        }
        if (w == null) {
            return;
        }
        if (w instanceof CheckBox) {
            ((CheckBox)w).setValue(Boolean.valueOf("1".equals(value)));
        } else if (w instanceof ListBox) {
            ListBox list = (ListBox)w;
            if (param != null && param.isMultiSelect()) {
                for (int i = 0; i < list.getItemCount(); ++i) {
                    boolean selected = false;
                    for (String val : value.split(",")) {
                        if (!val.equalsIgnoreCase(list.getValue(i))) continue;
                        selected = true;
                    }
                    list.setItemSelected(i, selected);
                }
            } else {
                for (int i = 0; i < list.getItemCount(); ++i) {
                    if (!value.equalsIgnoreCase(list.getValue(i))) continue;
                    list.setSelectedIndex(i);
                    break;
                }
            }
        } else if (w instanceof HasText) {
            ((HasText)w).setText(value);
        }
    }

    public void setQuery(String query, boolean fireEvents) {
        if (query != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (String pair : query.split("\\&")) {
                int idx = pair.indexOf(61);
                if (idx < 0) continue;
                params.put(pair.substring(0, idx), URL.decodeQueryString((String)pair.substring(idx + 1)));
            }
            for (FilterInterface.FilterParameterInterface param : this.iFilter.getParameters()) {
                String value = (String)params.get(param.getName());
                if (value != null) {
                    this.setValue(param.getName(), value);
                    continue;
                }
                if (param.getValue() == null || param.getDefaultValue() == null) continue;
                this.setValue(param.getName(), param.getDefaultValue());
            }
        }
    }
}

