/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.client.sectioning.StudentStatusDialog;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;

public class SectioningReports
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static NumberFormat PF = NumberFormat.getFormat((String)"0.0%");
    private static NumberFormat DF = NumberFormat.getFormat((String)"0.00");
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    protected static final StudentSectioningMessages SCT_MSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private SimpleForm iForm = null;
    private UniTimeHeaderPanel iHeader = null;
    private UniTimeHeaderPanel iTableHeader = null;
    private UniTimeWidget<ListBox> iReportSelector = null;
    private RowData iHead = null;
    private List<RowData> iData = new ArrayList<RowData>();
    private UniTimeTable<RowData> iTable = new UniTimeTable();
    private int iFirstLine = 0;
    private int iLastSort = 0;
    private String iLastHistory = null;
    private String iLastFilter = null;
    private boolean iOnline = false;
    private List<ReportTypeInterface> iReportTypes = null;
    private OnlineSectioningInterface.SectioningProperties iSectioningProperties = null;
    private Set<Long> iSelectedStudentIds = new HashSet<Long>();
    private Set<OnlineSectioningInterface.StudentStatusInfo> iStates = null;
    private StudentStatusDialog iStudentStatusDialog = null;
    private Map<Long, List<CheckBox>> iStudentId2Checks = new HashMap<Long, List<CheckBox>>();
    private SectioningStatusFilterBox iFilter = null;
    private int iFilterLine = -1;

    public SectioningReports(boolean online) {
        this.iOnline = online;
        this.iForm = new SimpleForm(2);
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iHeader.addButton("execute", MESSAGES.buttonExecute(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningReports.this.iFirstLine = 0;
                SectioningReports.this.iLastSort = 0;
                SectioningReports.this.execute();
            }
        });
        this.iHeader.addButton("print", MESSAGES.buttonPrint(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                final UniTimeTable table = new UniTimeTable();
                ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
                for (int i = 0; i < SectioningReports.this.iHead.getLength(); ++i) {
                    String x = SectioningReports.this.iHead.getCell(i);
                    String name = x.replace('_', ' ').trim();
                    UniTimeTableHeader h = new UniTimeTableHeader(name.replaceAll("\\n", "<br>"), 1);
                    if (i + 1 == SectioningReports.this.iLastSort) {
                        h.setOrder(true);
                    } else if (-1 - i == SectioningReports.this.iLastSort) {
                        h.setOrder(false);
                    }
                    header.add(h);
                }
                table.addRow(null, header);
                RowData prev = null;
                for (int i = 0; i < SectioningReports.this.iData.size(); ++i) {
                    RowData row = SectioningReports.this.iData.get(i);
                    ArrayList<NumberCell> line = new ArrayList<NumberCell>();
                    boolean prevHide = true;
                    for (int x = 0; x < table.getCellCount(0); ++x) {
                        boolean hide = true;
                        if (prev == null || !prevHide || !prev.getCell(x).equals(row.getCell(x))) {
                            hide = false;
                        }
                        Object text = "";
                        boolean number = true;
                        int idx = 0;
                        for (String t : row.getCell(x).split("\\n")) {
                            boolean n;
                            block20: {
                                n = false;
                                try {
                                    Double.parseDouble(t);
                                    n = true;
                                }
                                catch (Exception e) {
                                    if (!"\u221e".equals(t)) break block20;
                                    n = true;
                                }
                            }
                            if (SectioningReports.this.iHead.getCell(x).contains("%") && n) {
                                t = PF.format(Double.parseDouble(t));
                            } else if (t.matches("[\\-]?[0-9]+\\.[0-9]+(<br>[\\-]?[0-9]+\\.[0-9]+)*") && n) {
                                t = DF.format(Double.parseDouble(t));
                            } else if (t.matches("[\\-]?[0-9]+(,[0-9][0-9][0-9])*(\\.[0-9]+)? ?%?")) {
                                n = true;
                            }
                            if (!n) {
                                number = false;
                            }
                            if (idx > 0) {
                                text = (String)text + "<br>";
                            }
                            text = (String)text + t;
                            ++idx;
                        }
                        line.add(number ? new NumberCell((String)(hide ? "" : text)) : new HTML((String)(hide ? "" : text)));
                        prevHide = hide;
                    }
                    int last = table.addRow(row, line);
                    if (prev != null && !prev.getCell(0).equals(row.getCell(0))) {
                        for (int c = 0; c < table.getCellCount(last); ++c) {
                            table.getCellFormatter().addStyleName(last, c, "unitime-TopLineDash");
                        }
                    }
                    prev = row;
                }
                if (SectioningReports.this.iHead.getCell(0).startsWith("__")) {
                    table.setColumnVisible(0, false);
                }
                table.getElement().getStyle().setWidth(1040.0, Style.Unit.PX);
                com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
                com.google.gwt.user.client.Element tableElement = table.getElement();
                com.google.gwt.user.client.Element thead = DOM.createTHead();
                tableElement.insertFirst((Node)thead);
                headerRow.getParentElement().removeChild((Node)headerRow);
                thead.appendChild((Node)headerRow);
                final String name = SectioningReports.this.iReportSelector.getWidget().getItemText(SectioningReports.this.iReportSelector.getWidget().getSelectedIndex());
                ToolBox.print(new ToolBox.Page(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getUser() {
                        return "";
                    }

                    @Override
                    public String getSession() {
                        return "";
                    }

                    @Override
                    public Element getBody() {
                        return table.getElement();
                    }
                });
            }
        });
        this.iHeader.addButton("export", MESSAGES.buttonExportCSV(), 85, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SectioningReports.this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
                    SectioningReports.this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
                    return;
                }
                ReportTypeInterface type = SectioningReports.this.getReportType(SectioningReports.this.iReportSelector.getWidget().getValue(SectioningReports.this.iReportSelector.getWidget().getSelectedIndex()));
                String query = "output=sct-report.csv&name=" + type.getReference() + "&report=" + type.getImplementation() + "&online=" + (SectioningReports.this.iOnline ? "true" : "false") + "&sort=" + SectioningReports.this.iLastSort;
                if (type.isFilter()) {
                    query = query + "&filter=" + URL.encodeQueryString((String)SectioningReports.this.iFilter.getValue());
                }
                int i = 0;
                while (i + 1 < type.getParameters().length) {
                    query = query + "&" + type.getParameters()[i] + "=" + type.getParameters()[i + 1];
                    i += 2;
                }
                RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
                    }
                });
            }
        });
        this.iHeader.addButton("exportXls", MESSAGES.buttonExportXLS(), 85, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SectioningReports.this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
                    SectioningReports.this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
                    return;
                }
                ReportTypeInterface type = SectioningReports.this.getReportType(SectioningReports.this.iReportSelector.getWidget().getValue(SectioningReports.this.iReportSelector.getWidget().getSelectedIndex()));
                String query = "output=sct-report.xls&name=" + type.getReference() + "&report=" + type.getImplementation() + "&online=" + (SectioningReports.this.iOnline ? "true" : "false") + "&sort=" + SectioningReports.this.iLastSort;
                if (type.isFilter()) {
                    query = query + "&filter=" + URL.encodeQueryString((String)SectioningReports.this.iFilter.getValue());
                }
                int i = 0;
                while (i + 1 < type.getParameters().length) {
                    query = query + "&" + type.getParameters()[i] + "=" + type.getParameters()[i + 1];
                    i += 2;
                }
                RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
                    }
                });
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iHeader.setEnabled("execute", false);
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        this.iHeader.setEnabled("exportXls", false);
        this.iForm.getColumnFormatter().setWidth(0, "120px");
        this.iForm.getColumnFormatter().setWidth(1, "100%");
        this.iReportSelector = new UniTimeWidget<ListBox>(new ListBox());
        RPC.execute(new SectioningReportTypesRpcRequest(this.iOnline), new AsyncCallback<GwtRpcResponseList<ReportTypeInterface>>(){

            public void onFailure(Throwable caught) {
                SectioningReports.this.iTableHeader.setErrorMessage(caught.getMessage());
            }

            public void onSuccess(GwtRpcResponseList<ReportTypeInterface> result) {
                SectioningReports.this.iReportTypes = result;
                SectioningReports.this.iReportSelector.getWidget().addItem(MESSAGES.itemSelect(), "");
                for (ReportTypeInterface type : result) {
                    SectioningReports.this.iReportSelector.getWidget().addItem(type.getName(), type.getReference());
                }
                SectioningReports.this.reload(History.getToken());
            }
        });
        this.iForm.addRow(MESSAGES.propReport(), (Widget)this.iReportSelector);
        this.iReportSelector.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SectioningReports.this.iReportSelector.clearHint();
                SectioningReports.this.iReportSelector.setPrintText(SectioningReports.this.iReportSelector.getWidget().getItemText(SectioningReports.this.iReportSelector.getWidget().getSelectedIndex()));
                if (SectioningReports.this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
                    SectioningReports.this.iForm.getRowFormatter().setVisible(SectioningReports.this.iFilterLine, false);
                } else {
                    ReportTypeInterface type = SectioningReports.this.getReportType(SectioningReports.this.iReportSelector.getWidget().getValue(SectioningReports.this.iReportSelector.getWidget().getSelectedIndex()));
                    SectioningReports.this.iForm.getRowFormatter().setVisible(SectioningReports.this.iFilterLine, type.isFilter());
                }
                SectioningReports.this.queryChanged();
            }
        });
        this.iFilter = new SectioningStatusFilterBox(this.iOnline, true);
        this.iFilter.removeFilter("mode");
        this.iFilter.removeFilter("consent");
        this.iFilter.removeFilter("approver");
        this.iFilter.removeFilter("override");
        this.iFilter.removeFilter("operation");
        this.iFilterLine = this.iForm.addRow(MESSAGES.propFilter(), (Widget)this.iFilter);
        this.iForm.getRowFormatter().setVisible(this.iFilterLine, false);
        this.iTableHeader = new UniTimeHeaderPanel(MESSAGES.sectResults());
        this.iTableHeader.addButton("previous", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningReports.this.iFirstLine -= 100;
                SectioningReports.this.populate(false);
                History.newItem((String)(SectioningReports.this.iLastHistory + ":" + SectioningReports.this.iFirstLine + ":" + SectioningReports.this.iLastSort + ":" + SectioningReports.this.iLastFilter), (boolean)false);
            }
        });
        this.iTableHeader.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningReports.this.iFirstLine += 100;
                SectioningReports.this.populate(false);
                History.newItem((String)(SectioningReports.this.iLastHistory + ":" + SectioningReports.this.iFirstLine + ":" + SectioningReports.this.iLastSort + ":" + SectioningReports.this.iLastFilter), (boolean)false);
            }
        });
        this.iTableHeader.setEnabled("previous", false);
        this.iTableHeader.setEnabled("next", false);
        this.iForm.addHeaderRow((Widget)this.iTableHeader);
        this.iForm.addRow((Widget)this.iTable);
        this.iForm.addBottomRow((Widget)this.iHeader.clonePanel(""));
        this.initWidget((Widget)this.iForm);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SectioningReports.this.reload((String)event.getValue());
            }
        });
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RowData>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RowData> event) {
                if (event.getRow() > 0 && event.getData() != null) {
                    if ("__Class".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "classDetail.action?cid=" + event.getData().getCell(0));
                    } else if ("__Offering".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.action?op=view&io=" + event.getData().getCell(0));
                    } else if ("__Subpart".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "schedulingSubpartDetail.action?ssuid=" + event.getData().getCell(0));
                    } else if ("__Room".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=rooms&back=1&id=" + event.getData().getCell(0));
                    } else if ("__Instructor".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructorDetail.action?instructorId=" + event.getData().getCell(0));
                    } else if ("__Exam".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "examDetail.action?examId=" + event.getData().getCell(0));
                    } else if ("__Event".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=events#event=" + event.getData().getCell(0));
                    } else if ("__Student".equals(SectioningReports.this.iHead.getCell(0))) {
                        EnrollmentTable et = new EnrollmentTable(false, SectioningReports.this.iOnline);
                        et.setAdvisorRecommendations(SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isAdvisorCourseRequests());
                        et.setEmail(SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isEmail());
                        et.showStudentSchedule(Long.valueOf(event.getData().getCell(0)));
                    }
                }
            }
        });
        if (!online) {
            RPC.execute(new SolverInterface.SolverPageMessagesRequest(SolverInterface.SolverType.STUDENT), new AsyncCallback<SolverInterface.SolverPageMessages>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(SolverInterface.SolverPageMessages response) {
                    RootPanel cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages");
                    if (cpm != null) {
                        cpm.clear();
                        if (response.hasPageMessages()) {
                            for (final SolverInterface.PageMessage pm : response.getPageMessages()) {
                                P p = new P(pm.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pm.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                                p.setHTML(pm.getMessage());
                                if (pm.hasUrl()) {
                                    p.addStyleName("unitime-ClickablePageMessage");
                                    p.addClickHandler(new ClickHandler(){

                                        public void onClick(ClickEvent event) {
                                            if (pm.hasUrl()) {
                                                ToolBox.open(GWT.getHostPageBaseURL() + pm.getUrl());
                                            }
                                        }
                                    });
                                }
                                cpm.add((Widget)p);
                            }
                        }
                    }
                }
            });
        }
        this.iSectioningService.getProperties(null, new AsyncCallback<OnlineSectioningInterface.SectioningProperties>(){

            public void onSuccess(OnlineSectioningInterface.SectioningProperties result) {
                SectioningReports.this.iSectioningProperties = result;
                SectioningReports.this.iSectioningService.lookupStudentSectioningStates(new AsyncCallback<List<OnlineSectioningInterface.StudentStatusInfo>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(List<OnlineSectioningInterface.StudentStatusInfo> result) {
                        SectioningReports.this.iStates = new TreeSet<OnlineSectioningInterface.StudentStatusInfo>(result);
                        SectioningReports.this.iStudentStatusDialog = new StudentStatusDialog(SectioningReports.this.iStates, new StudentStatusDialog.StudentStatusConfirmation(){

                            @Override
                            public boolean isAllMyStudents() {
                                return false;
                            }

                            @Override
                            public int getStudentCount() {
                                return SectioningReports.this.iSelectedStudentIds.size();
                            }
                        });
                    }
                });
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    protected ReportTypeInterface getReportType(String reference) {
        if (this.iReportTypes == null || reference == null) {
            return null;
        }
        for (ReportTypeInterface type : this.iReportTypes) {
            if (!reference.equals(type.getReference())) continue;
            return type;
        }
        return null;
    }

    private void queryChanged() {
        this.iHeader.clearMessage();
        if (this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
            this.iHeader.setEnabled("execute", false);
            this.iHeader.setEnabled("export", false);
            this.iHeader.setEnabled("exportXls", false);
        } else {
            this.iHeader.setEnabled("execute", true);
            this.iHeader.setEnabled("export", true);
            this.iHeader.setEnabled("exportXls", true);
        }
    }

    public void populate(boolean sort) {
        if (this.iData == null || this.iData.isEmpty() || this.iHead == null) {
            this.iTableHeader.setMessage(MESSAGES.errorNoResults());
        } else {
            if (this.iLastSort != 0 && sort) {
                final boolean asc = this.iLastSort > 0;
                final int col = Math.abs(this.iLastSort) - 1;
                Collections.sort(this.iData, new Comparator<RowData>(){

                    @Override
                    public int compare(RowData o1, RowData o2) {
                        return asc ? o1.compareTo(o2, col) : o2.compareTo(o1, col);
                    }
                });
            }
            ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
            this.iTable.clearTable();
            this.iStudentId2Checks.clear();
            for (int i = 0; i < this.iHead.getLength(); ++i) {
                String x = this.iHead.getCell(i);
                final String name = x.replace('_', ' ').trim();
                final UniTimeTableHeader h = new UniTimeTableHeader(name.replaceAll("\\n", "<br>"), 1);
                final int col = header.size();
                h.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        boolean asc = h.getOrder() == null ? true : h.getOrder() == false;
                        SectioningReports.this.iLastSort = asc ? 1 + col : -1 - col;
                        SectioningReports.this.populate(true);
                        History.newItem((String)(SectioningReports.this.iLastHistory + ":" + SectioningReports.this.iFirstLine + ":" + SectioningReports.this.iLastSort + ":" + SectioningReports.this.iLastFilter), (boolean)false);
                    }

                    @Override
                    public boolean isApplicable() {
                        return true;
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opSortBy(name);
                    }
                });
                if (i + 1 == this.iLastSort) {
                    h.setOrder(true);
                } else if (-1 - i == this.iLastSort) {
                    h.setOrder(false);
                }
                header.add(h);
            }
            if (this.iSectioningProperties != null && "__Student".equals(this.iHead.getCell(0)) && this.iSectioningProperties.isCanSelectStudent()) {
                UniTimeTableHeader hSelect = new UniTimeTableHeader("&otimes;", HasHorizontalAlignment.ALIGN_CENTER);
                header.set(0, hSelect);
                hSelect.setWidth("10px");
                hSelect.addAdditionalStyleName("unitime-CheckBoxColumn");
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.selectAll();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iSelectedStudentIds.size() != SectioningReports.this.iTable.getRowCount() - 1;
                    }

                    public void execute() {
                        SectioningReports.this.iSelectedStudentIds.clear();
                        for (int row = 0; row < SectioningReports.this.iTable.getRowCount(); ++row) {
                            Widget w = SectioningReports.this.iTable.getWidget(row, 0);
                            if (!(w instanceof CheckBox)) continue;
                            ((CheckBox)w).setValue(Boolean.valueOf(true));
                            SectioningReports.this.iSelectedStudentIds.add(Long.valueOf(SectioningReports.this.iTable.getData(row).getCell(0)));
                        }
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.clearAll();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iSelectedStudentIds.size() > 0;
                    }

                    public void execute() {
                        SectioningReports.this.iSelectedStudentIds.clear();
                        for (int row = 0; row < SectioningReports.this.iTable.getRowCount(); ++row) {
                            Widget w = SectioningReports.this.iTable.getWidget(row, 0);
                            if (!(w instanceof CheckBox)) continue;
                            ((CheckBox)w).setValue(Boolean.valueOf(false));
                        }
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.sendStudentEmail();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iStudentStatusDialog != null && SectioningReports.this.iSectioningProperties.isEmail();
                    }

                    public void execute() {
                        if (!SectioningReports.this.iOnline) {
                            SectioningReports.this.iStudentStatusDialog.getClassScheduleCheckBox().setVisible(false);
                        }
                        SectioningReports.this.iStudentStatusDialog.sendStudentEmail(new Command(){

                            public void execute() {
                                ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                                LoadingWidget.getInstance().show(MESSAGES.waitSendingEmail());
                                SectioningReports.this.sendEmail(studentIds.iterator(), SectioningReports.this.iStudentStatusDialog.getSubject(), SectioningReports.this.iStudentStatusDialog.getMessage(), SectioningReports.this.iStudentStatusDialog.getCC(), 0, SectioningReports.this.iStudentStatusDialog.getIncludeCourseRequests(), SectioningReports.this.iOnline && SectioningReports.this.iStudentStatusDialog.getIncludeClassSchedule() != false, SectioningReports.this.iStudentStatusDialog.getIncludeAdvisorRequests(), SectioningReports.this.iStudentStatusDialog.isOptionalEmailToggle());
                            }
                        }, SectioningReports.this.iSectioningProperties.getEmailOptionalToggleCaption(), SectioningReports.this.iSectioningProperties.getEmailOptionalToggleDefault());
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.massCancel();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iOnline && SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isMassCancel() && SectioningReports.this.iStudentStatusDialog != null;
                    }

                    public void execute() {
                        SectioningReports.this.iStudentStatusDialog.massCancel(new Command(){

                            public void execute() {
                                UniTimeConfirmationDialog.confirmFocusNo(SCT_MSG.massCancelConfirmation(), new Command(){

                                    public void execute() {
                                        ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                                        LoadingWidget.getInstance().show(SCT_MSG.massCanceling());
                                        SectioningReports.this.iSectioningService.massCancel(studentIds, SectioningReports.this.iStudentStatusDialog.getStatus(), SectioningReports.this.iStudentStatusDialog.getSubject(), SectioningReports.this.iStudentStatusDialog.getMessage(), SectioningReports.this.iStudentStatusDialog.getCC(), new AsyncCallback<Boolean>(){

                                            public void onFailure(Throwable caught) {
                                                LoadingWidget.getInstance().hide();
                                                UniTimeNotifications.error(caught);
                                            }

                                            public void onSuccess(Boolean result) {
                                                LoadingWidget.getInstance().hide();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.reloadStudent();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iOnline && SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isReloadStudent();
                    }

                    public void execute() {
                        ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                        LoadingWidget.getInstance().show(SCT_MSG.reloadingStudent());
                        SectioningReports.this.iSectioningService.reloadStudent(studentIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.info(SCT_MSG.reloadStudentSuccess());
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.requestStudentUpdate();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return !SectioningReports.this.iSectioningProperties.isReloadStudent();
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iOnline && SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isRequestUpdate();
                    }

                    public void execute() {
                        ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                        LoadingWidget.getInstance().show(SCT_MSG.requestingStudentUpdate());
                        SectioningReports.this.iSectioningService.requestStudentUpdate(studentIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.info(SCT_MSG.requestStudentUpdateSuccess());
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.checkOverrideStatus();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return !SectioningReports.this.iSectioningProperties.isRequestUpdate() && !SectioningReports.this.iSectioningProperties.isReloadStudent();
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iOnline && SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isCheckStudentOverrides();
                    }

                    public void execute() {
                        ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                        LoadingWidget.getInstance().show(SCT_MSG.checkingOverrideStatus());
                        SectioningReports.this.iSectioningService.checkStudentOverrides(studentIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.info(SCT_MSG.checkStudentOverridesSuccess());
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.validateStudentOverrides();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return !SectioningReports.this.iSectioningProperties.isRequestUpdate() && !SectioningReports.this.iSectioningProperties.isCheckStudentOverrides() && !SectioningReports.this.iSectioningProperties.isReloadStudent();
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iOnline && SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isValidateStudentOverrides();
                    }

                    public void execute() {
                        ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                        LoadingWidget.getInstance().show(SCT_MSG.validatingStudentOverrides());
                        SectioningReports.this.iSectioningService.validateStudentOverrides(studentIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.info(SCT_MSG.validateStudentOverridesSuccess());
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.validateReCheckCriticalCourses();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return !SectioningReports.this.iSectioningProperties.isRequestUpdate() && !SectioningReports.this.iSectioningProperties.isCheckStudentOverrides() && !SectioningReports.this.iSectioningProperties.isValidateStudentOverrides() && !SectioningReports.this.iSectioningProperties.isReloadStudent();
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iOnline && SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isRecheckCriticalCourses();
                    }

                    public void execute() {
                        ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                        LoadingWidget.getInstance().show(SCT_MSG.recheckingCriticalCourses());
                        SectioningReports.this.iSectioningService.recheckCriticalCourses(studentIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught);
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.info(SCT_MSG.recheckCriticalCoursesSuccess());
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.setStudentStatus();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return true;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isChangeStatus() && SectioningReports.this.iStudentStatusDialog != null;
                    }

                    public void execute() {
                        SectioningReports.this.iStudentStatusDialog.setStatus(new Command(){

                            public void execute() {
                                String statusRef = SectioningReports.this.iStudentStatusDialog.getStatus();
                                if ("-".equals(statusRef)) {
                                    return;
                                }
                                ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                                LoadingWidget.getInstance().show(SCT_MSG.changingStatusTo(statusRef));
                                SectioningReports.this.iSectioningService.changeStatus(studentIds, null, statusRef, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(caught);
                                    }

                                    public void onSuccess(Boolean result) {
                                        LoadingWidget.getInstance().hide();
                                    }
                                });
                            }
                        });
                    }
                });
                hSelect.addOperation(new UniTimeTableHeader.Operation(){

                    @Override
                    public String getName() {
                        return SCT_MSG.setStudentNote();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public boolean isApplicable() {
                        return SectioningReports.this.iSelectedStudentIds.size() > 0 && SectioningReports.this.iSectioningProperties != null && SectioningReports.this.iSectioningProperties.isChangeStatus() && SectioningReports.this.iStudentStatusDialog != null;
                    }

                    public void execute() {
                        SectioningReports.this.iStudentStatusDialog.setStudentNote(new Command(){

                            public void execute() {
                                LoadingWidget.getInstance().show(SCT_MSG.changingStudentNote());
                                ArrayList<Long> studentIds = new ArrayList<Long>(SectioningReports.this.iSelectedStudentIds);
                                String statusRef = SectioningReports.this.iStudentStatusDialog.getStatus();
                                String note = SectioningReports.this.iStudentStatusDialog.getNote();
                                SectioningReports.this.iSectioningService.changeStatus(studentIds, note, statusRef, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(caught);
                                    }

                                    public void onSuccess(Boolean result) {
                                        LoadingWidget.getInstance().hide();
                                    }
                                });
                            }
                        });
                    }
                });
            }
            this.iTable.addRow(null, header);
            RowData prev = null;
            for (int i = this.iFirstLine; i < Math.min(this.iFirstLine + 100, this.iData.size()); ++i) {
                RowData row = this.iData.get(i);
                ArrayList<Object> line = new ArrayList<Object>();
                boolean prevHide = true;
                for (int x = 0; x < this.iTable.getCellCount(0); ++x) {
                    boolean hide = true;
                    if (prev == null || !prevHide || !prev.getCell(x).equals(row.getCell(x))) {
                        hide = false;
                    }
                    Object text = "";
                    boolean number = true;
                    int idx = 0;
                    for (String t : row.getCell(x).split("\\n")) {
                        boolean n;
                        block29: {
                            n = false;
                            try {
                                Double.parseDouble(t);
                                n = true;
                            }
                            catch (Exception e) {
                                if (!"\u221e".equals(t)) break block29;
                                n = true;
                            }
                        }
                        if (this.iHead.getCell(x).contains("%") && n) {
                            t = PF.format(Double.parseDouble(t));
                        } else if (t.matches("[\\-]?[0-9]+\\.[0-9]+(<br>[\\-]?[0-9]+\\.[0-9]+)*") && n) {
                            t = DF.format(Double.parseDouble(t));
                        } else if (t.matches("[\\-]?[0-9]+(,[0-9][0-9][0-9])*(\\.[0-9]+)? ?%?")) {
                            n = true;
                        }
                        if (!n) {
                            number = false;
                        }
                        if (idx > 0) {
                            text = (String)text + "<br>";
                        }
                        text = (String)text + t;
                        ++idx;
                    }
                    line.add(number ? new NumberCell((String)(hide ? "" : text)) : new HTML((String)(hide ? "" : text)));
                    prevHide = hide;
                }
                if (this.iSectioningProperties != null && "__Student".equals(this.iHead.getCell(0)) && this.iSectioningProperties.isCanSelectStudent()) {
                    if (prev == null || !prev.getCell(0).equals(row.getCell(0))) {
                        Toggle ch = new Toggle();
                        ch.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                event.stopPropagation();
                            }
                        });
                        ch.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                event.stopPropagation();
                            }
                        });
                        final Long sid = Long.valueOf(row.getCell(0));
                        List<CheckBox> toggles = this.iStudentId2Checks.get(sid);
                        if (toggles == null) {
                            toggles = new ArrayList<CheckBox>();
                            this.iStudentId2Checks.put(sid, toggles);
                        }
                        toggles.add(ch);
                        ch.setValue(this.iSelectedStudentIds.contains(sid));
                        ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                if (((Boolean)event.getValue()).booleanValue()) {
                                    SectioningReports.this.iSelectedStudentIds.add(sid);
                                } else {
                                    SectioningReports.this.iSelectedStudentIds.remove(sid);
                                }
                                if (SectioningReports.this.iStudentId2Checks.get(sid).size() > 1) {
                                    for (CheckBox ch : SectioningReports.this.iStudentId2Checks.get(sid)) {
                                        ch.setValue((Boolean)event.getValue());
                                    }
                                }
                            }
                        });
                        line.set(0, ch);
                    } else {
                        line.set(0, new HTML());
                    }
                }
                int last = this.iTable.addRow(row, line);
                if (prev != null && !prev.getCell(0).equals(row.getCell(0))) {
                    for (int c = 0; c < this.iTable.getCellCount(last); ++c) {
                        this.iTable.getCellFormatter().addStyleName(last, c, "unitime-TopLineDash");
                    }
                }
                prev = row;
            }
            this.iTable.setColumnVisible(0, !this.iHead.getCell(0).startsWith("__") || this.iSectioningProperties != null && "__Student".equals(this.iHead.getCell(0)) && this.iSectioningProperties.isCanSelectStudent());
            this.iHeader.setEnabled("print", true);
            this.iHeader.setEnabled("export", true);
            this.iHeader.setEnabled("exportXls", true);
            if (this.iData.size() <= 100 && this.iFirstLine == 0) {
                this.iTableHeader.setMessage(MESSAGES.infoShowingAllLines(this.iData.size()));
            } else {
                this.iTableHeader.setMessage(MESSAGES.infoShowingLines(this.iFirstLine + 1, Math.min(this.iFirstLine + 100, this.iData.size())));
            }
            this.iTableHeader.setEnabled("next", this.iFirstLine + 100 < this.iData.size());
            this.iTableHeader.setEnabled("previous", this.iFirstLine > 0);
        }
    }

    public void reload(String history) {
        if (history == null) {
            return;
        }
        if (history.indexOf(38) >= 0) {
            history = history.substring(0, history.indexOf(38));
        }
        if (history.isEmpty()) {
            return;
        }
        String[] params = history.split(":");
        ReportTypeInterface type = this.getReportType(params[0]);
        if (type == null) {
            return;
        }
        for (int i = 1; i < this.iReportSelector.getWidget().getItemCount(); ++i) {
            if (!type.getReference().equals(this.iReportSelector.getWidget().getValue(i))) continue;
            this.iReportSelector.getWidget().setSelectedIndex(i);
            break;
        }
        this.iForm.getRowFormatter().setVisible(this.iFilterLine, type.isFilter());
        this.queryChanged();
        this.iFirstLine = Integer.parseInt(params[1]);
        this.iLastSort = Integer.parseInt(params[2]);
        this.iFilter.setValue(history.substring(params[0].length() + params[1].length() + params[2].length() + 3), true);
        this.execute();
    }

    private void execute() {
        this.iHeader.setEnabled("print", false);
        if (this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
            this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
            return;
        }
        ReportTypeInterface type = this.getReportType(this.iReportSelector.getWidget().getValue(this.iReportSelector.getWidget().getSelectedIndex()));
        this.iLastHistory = type.getReference();
        this.iLastFilter = type.isFilter() ? this.iFilter.getValue() : "";
        this.iTable.clearTable();
        this.iTableHeader.clearMessage();
        this.iHeader.clearMessage();
        LoadingWidget.getInstance().show(MESSAGES.waitExecuting(type.getName()));
        History.newItem((String)(this.iLastHistory + ":" + this.iFirstLine + ":" + this.iLastSort + ":" + this.iLastFilter), (boolean)false);
        SectioningReportRpcRequest request = new SectioningReportRpcRequest();
        request.setParameter("report", type.getImplementation());
        request.setParameter("online", this.iOnline ? "true" : "false");
        int i = 0;
        while (i + 1 < type.getParameters().length) {
            request.setParameter(type.getParameters()[i], type.getParameters()[i + 1]);
            i += 2;
        }
        if (type.isFilter()) {
            request.setParameter("filter", this.iFilter.getValue());
        }
        RPC.execute(request, new AsyncCallback<SectioningReportRpcResponse>(){

            public void onFailure(Throwable caught) {
                SectioningReports.this.iTableHeader.setErrorMessage(caught.getMessage());
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(SectioningReportRpcResponse result) {
                SectioningReports.this.iData.clear();
                RowData prev = null;
                for (int i = 0; i < result.getReport().size(); ++i) {
                    String[] row = result.getReport().get(i);
                    if (row.length == 0) continue;
                    RowData data = new RowData(row);
                    while (prev != null && data.getNrBlanks() <= prev.getNrBlanks()) {
                        prev = prev.getParent();
                    }
                    if (prev != null) {
                        data.setParent(prev);
                    }
                    if (i == 0) {
                        SectioningReports.this.iHead = data;
                        continue;
                    }
                    SectioningReports.this.iData.add(data);
                    prev = data;
                }
                SectioningReports.this.populate(true);
                LoadingWidget.getInstance().hide();
            }
        });
    }

    private void sendEmail(final Iterator<Long> studentIds, final String subject, final String message, final String cc, final int fails, final boolean courseRequests, final boolean classSchedule, final boolean advisorRequests, final Boolean toggle) {
        if (!studentIds.hasNext()) {
            LoadingWidget.getInstance().hide();
            if (fails == 0) {
                UniTimeNotifications.info(MESSAGES.emailSent());
            }
            return;
        }
        Long studentId = studentIds.next();
        this.iSectioningService.sendEmail(null, studentId, subject, message, cc, courseRequests, classSchedule, advisorRequests, toggle, "user-reports", new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                SectioningReports.this.iTableHeader.setErrorMessage(MESSAGES.failedEmail(caught.getMessage()));
                SectioningReports.this.sendEmail(studentIds, subject, message, cc, fails + 1, courseRequests, classSchedule, advisorRequests, toggle);
            }

            public void onSuccess(Boolean result) {
                SectioningReports.this.sendEmail(studentIds, subject, message, cc, fails, courseRequests, classSchedule, advisorRequests, toggle);
            }
        });
    }

    public static class RowData {
        String[] iRow;
        RowData iParent;

        public RowData(String[] row) {
            this.iRow = row;
        }

        public String[] getRow() {
            return this.iRow;
        }

        public RowData getParent() {
            return this.iParent;
        }

        public void setParent(RowData parent) {
            this.iParent = parent;
        }

        public boolean isBlank(int col) {
            return this.getRow().length <= col || this.getRow()[col] == null || this.getRow()[col].isEmpty();
        }

        public String getCell(int col) {
            if (this.isBlank(col)) {
                if (this.getParent() != null) {
                    return this.getParent().getCell(col);
                }
                return "";
            }
            return this.getRow()[col];
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public int getLength() {
            return this.getParent() == null ? this.getRow().length : this.getParent().getLength();
        }

        public int getNrBlanks() {
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.isBlank(i)) continue;
                return i;
            }
            return this.getLength();
        }

        public boolean isAllBlank() {
            return this.getNrBlanks() == this.getLength();
        }

        public int compareTo(RowData b, int col) {
            int cmp;
            RowData a;
            block12: {
                int cmp2;
                a = this;
                if (a.getLevel() != b.getLevel()) {
                    RowData aP = a;
                    RowData bP = b;
                    while (aP.getLevel() > bP.getLevel()) {
                        aP = aP.getParent();
                    }
                    while (bP.getLevel() > aP.getLevel()) {
                        bP = bP.getParent();
                    }
                    cmp = aP.compareTo(bP, col);
                    if (cmp != 0) {
                        return cmp;
                    }
                } else if (a.getParent() != null && (cmp2 = a.getParent().compareTo(b.getParent(), col)) != 0) {
                    return cmp2;
                }
                try {
                    int cmp3 = Double.valueOf(a.getCell(col) == null ? "0" : a.getCell(col)).compareTo(Double.valueOf(b.getCell(col) == null ? "0" : b.getCell(col)));
                    if (cmp3 != 0) {
                        return cmp3;
                    }
                }
                catch (NumberFormatException e) {
                    int cmp4 = (a.getCell(col) == null ? "" : a.getCell(col)).compareTo(b.getCell(col) == null ? "" : b.getCell(col));
                    if (cmp4 == 0) break block12;
                    return cmp4;
                }
            }
            for (int c = 0; c < this.getLength(); ++c) {
                try {
                    int cmp5 = Double.valueOf(a.getCell(c) == null ? "0" : a.getCell(c)).compareTo(Double.valueOf(b.getCell(c) == null ? "0" : b.getCell(c)));
                    if (cmp5 == 0) continue;
                    return cmp5;
                }
                catch (NumberFormatException e) {
                    cmp = (a.getCell(c) == null ? "" : a.getCell(c)).compareTo(b.getCell(c) == null ? "" : b.getCell(c));
                    if (cmp == 0) continue;
                    return cmp;
                }
            }
            return 0;
        }
    }

    public static class SectioningReportTypesRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<ReportTypeInterface>> {
        private boolean iOnline = false;

        public SectioningReportTypesRpcRequest() {
        }

        public SectioningReportTypesRpcRequest(boolean online) {
            this.iOnline = online;
        }

        public void setOnline(boolean online) {
            this.iOnline = online;
        }

        public boolean isOnline() {
            return this.iOnline;
        }
    }

    public static class ReportTypeInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        String iReference;
        String iName;
        String iImplementation;
        String[] iParameters;
        boolean iFilter;

        public ReportTypeInterface() {
        }

        public ReportTypeInterface(String reference, String name, String implementation, boolean filter, String ... params) {
            this.iReference = reference;
            this.iName = name;
            this.iImplementation = implementation;
            this.iFilter = filter;
            this.iParameters = params;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setImplementation(String implementation) {
            this.iImplementation = implementation;
        }

        public String getImplementation() {
            return this.iImplementation;
        }

        public void setParameters(String ... params) {
            this.iParameters = params;
        }

        public String[] getParameters() {
            return this.iParameters;
        }

        public boolean isFilter() {
            return this.iFilter;
        }

        public void setFilter(boolean filter) {
            this.iFilter = filter;
        }

        public int hashCode() {
            return this.getReference().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ReportTypeInterface)) {
                return false;
            }
            return this.getReference().equals(((ReportTypeInterface)o).getReference());
        }
    }

    public static class NumberCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public NumberCell(String text) {
            super(text, false);
        }

        public NumberCell(int text) {
            super(String.valueOf(text), false);
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    private static class Toggle
    extends CheckBox
    implements UniTimeTable.HasStyleName {
        private Toggle() {
        }

        @Override
        public String getStyleName() {
            return "unitime-CheckBoxColumn";
        }
    }

    public static class SectioningReportRpcRequest
    implements GwtRpcRequest<SectioningReportRpcResponse> {
        Map<String, String> iParameters = new HashMap<String, String>();

        public void setParameter(String name, String value) {
            this.iParameters.put(name, value);
        }

        public Map<String, String> getParameters() {
            return this.iParameters;
        }

        @Override
        public String toString() {
            return this.getParameters().toString();
        }
    }

    public static class SectioningReportRpcResponse
    implements GwtRpcResponse {
        private List<String[]> iReport = new ArrayList<String[]>();

        public void addLine(String[] line) {
            this.iReport.add(line);
        }

        public List<String[]> getReport() {
            return this.iReport;
        }
    }
}

