/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.sectioning.DegreePlanTable;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class DegreePlanDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private SimpleForm iForm;
    private DegreePlanTable iDegreePlanTable;
    private ScrollPanel iDegreePlanPanel;
    private CourseFinder.CourseFinderCourseDetails[] iDetails = null;
    private UniTimeTabPanel iCourseDetailsTabPanel = null;
    private Button iBack;
    private UniTimeHeaderPanel iFooter;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private TakesValue<CourseRequestInterface> iRequests;
    private OnlineSectioningInterface.WaitListMode iWaitListMode = null;
    private Integer iCriticalCheck = null;

    public DegreePlanDialog(StudentSectioningPage.Mode mode, TakesValue<CourseRequestInterface> requests, AssignmentProvider assignments, CourseFinder.CourseFinderCourseDetails ... details) {
        super(true, false);
        this.setEscapeToHide(true);
        this.addStyleName("unitime-DegreePlanDialog");
        this.iRequests = requests;
        this.iForm = new SimpleForm();
        this.iDegreePlanTable = new DegreePlanTable(mode, requests, assignments);
        this.iDegreePlanPanel = new ScrollPanel((Widget)this.iDegreePlanTable);
        this.iDegreePlanPanel.setStyleName("unitime-ScrollPanel");
        this.iDegreePlanPanel.addStyleName("plan");
        this.iForm.addRow((Widget)this.iDegreePlanPanel);
        this.iDegreePlanTable.addMouseClickListener(new UniTimeTable.MouseClickListener<Object>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<Object> event) {
                DegreePlanDialog.this.updateAriaStatus();
                DegreePlanDialog.this.updateCourseDetails(event.getData());
            }
        });
        this.iCourseDetailsTabPanel = new UniTimeTabPanel();
        this.iCourseDetailsTabPanel.setDeckStyleName("unitime-TabPanel");
        this.iCourseDetailsTabPanel.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                ToolBox.setSessionCookie("UniTime:CourseFinderCourses", String.valueOf(event.getSelectedItem()));
            }
        });
        this.iForm.addRow((Widget)this.iCourseDetailsTabPanel);
        this.iDetails = details;
        int tabIndex = 0;
        for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
            ScrollPanel panel = new ScrollPanel(detail.asWidget());
            panel.setStyleName("unitime-ScrollPanel-inner");
            this.iCourseDetailsTabPanel.add((Widget)panel, detail.getName(), true);
            Character ch = UniTimeHeaderPanel.guessAccessKey(detail.getName());
            if (ch != null) {
                this.iTabAccessKeys.put(ch, tabIndex);
            }
            ++tabIndex;
        }
        this.selectLastTab();
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("apply", MESSAGES.buttonDegreePlanApply(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DegreePlanDialog.this.doApply();
            }
        });
        this.iFooter.addButton("close", MESSAGES.buttonDegreePlanClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DegreePlanDialog.this.hide();
            }
        });
        this.iBack = new AriaButton(MESSAGES.buttonDegreePlanBack());
        this.iBack.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DegreePlanDialog.this.doBack();
            }
        });
        Character backAck = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonDegreePlanBack());
        if (backAck != null) {
            this.iBack.setAccessKey(backAck.charValue());
        }
        ToolBox.setWhiteSpace(this.iBack.getElement().getStyle(), "nowrap");
        this.iFooter.insertLeft((Widget)this.iBack, true);
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.setWidget((Widget)this.iForm);
    }

    public void setWaitListMode(OnlineSectioningInterface.WaitListMode wl) {
        this.iWaitListMode = wl;
    }

    public void setCriticalCheck(Integer criticalCheck) {
        this.iCriticalCheck = criticalCheck;
    }

    public void open(DegreePlanInterface plan, boolean hasBack) {
        this.iDegreePlanTable.setValue(plan);
        this.setText(MESSAGES.dialogDegreePlan(plan.getName()));
        this.updateCourseDetails(this.iDegreePlanTable.getData(this.iDegreePlanTable.getSelectedRow()));
        this.iBack.setVisible(hasBack);
        this.iBack.setEnabled(hasBack);
        this.center();
    }

    private void selectLastTab() {
        try {
            int tab = Integer.valueOf(ToolBox.getSessionCookie("UniTime:CourseFinderCourses"));
            if (tab >= 0 || tab < this.iCourseDetailsTabPanel.getTabCount() && tab != this.iCourseDetailsTabPanel.getSelectedTab()) {
                this.iCourseDetailsTabPanel.selectTab(tab);
            } else {
                this.iCourseDetailsTabPanel.selectTab(0);
            }
        }
        catch (Exception e) {
            this.iCourseDetailsTabPanel.selectTab(0);
        }
    }

    protected void doBack() {
        this.hide();
    }

    protected void doApply() {
        this.hide();
        this.iRequests.setValue((Object)this.iDegreePlanTable.createRequests(this.iWaitListMode, this.iCriticalCheck));
    }

    @Override
    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        if (event.getTypeInt() == 512 && (event.getNativeEvent().getAltKey() || event.getNativeEvent().getCtrlKey())) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeEvent().getKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeEvent().getKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                this.iCourseDetailsTabPanel.selectTab(entry.getValue());
            }
        }
        if (event.getTypeInt() == 128) {
            if (event.getNativeEvent().getKeyCode() == 38) {
                int row = this.iDegreePlanTable.getSelectedRow();
                if (row >= 0) {
                    this.iDegreePlanTable.setSelected(row, false);
                }
                if (--row <= 0) {
                    row = this.iDegreePlanTable.getRowCount() - 1;
                }
                this.iDegreePlanTable.setSelected(row, true);
                this.updateCourseDetails(this.iDegreePlanTable.getData(row));
                this.scrollToSelectedRow();
                this.updateAriaStatus();
            } else if (event.getNativeEvent().getKeyCode() == 40) {
                int row = this.iDegreePlanTable.getSelectedRow();
                if (row >= 0) {
                    this.iDegreePlanTable.setSelected(row, false);
                } else {
                    row = 0;
                }
                if (++row >= this.iDegreePlanTable.getRowCount()) {
                    row = 1;
                }
                this.iDegreePlanTable.setSelected(row, true);
                this.updateCourseDetails(this.iDegreePlanTable.getData(row));
                this.scrollToSelectedRow();
                this.updateAriaStatus();
            }
        }
        if (event.getTypeInt() == 512 && (event.getNativeEvent().getKeyCode() == 32 || event.getNativeEvent().getKeyCode() == 13)) {
            if (this.iDegreePlanTable.canChoose(this.iDegreePlanTable.getSelectedRow())) {
                this.iDegreePlanTable.chooseRow(this.iDegreePlanTable.getSelectedRow(), true);
            }
            event.getNativeEvent().preventDefault();
            event.getNativeEvent().stopPropagation();
        }
    }

    protected void updateCourseDetails(Object data) {
        block3: {
            block2: {
                if (data != null && data instanceof ClassAssignmentInterface.CourseAssignment) break block2;
                if (this.iDetails == null) break block3;
                for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                    detail.setValue(null);
                }
                break block3;
            }
            ClassAssignmentInterface.CourseAssignment course = (ClassAssignmentInterface.CourseAssignment)data;
            for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                detail.setValue(course);
            }
        }
    }

    protected void scrollToSelectedRow() {
        if (this.iDegreePlanTable.getSelectedRow() < 0) {
            return;
        }
        Element scroll = this.iDegreePlanPanel.getElement();
        Element item = this.iDegreePlanTable.getRowFormatter().getElement(this.iDegreePlanTable.getSelectedRow());
        if (item == null) {
            return;
        }
        int realOffset = 0;
        while (item != null && !item.equals((Object)scroll)) {
            realOffset += item.getOffsetTop();
            item = item.getOffsetParent();
        }
        scroll.setScrollTop(realOffset - scroll.getOffsetHeight() / 2);
    }

    protected void updateAriaStatus() {
        Widget w;
        int row = this.iDegreePlanTable.getSelectedRow();
        Object data = this.iDegreePlanTable.getData(row);
        Object status = null;
        String name = null;
        if (data instanceof DegreePlanInterface.DegreePlaceHolderInterface) {
            DegreePlanInterface.DegreePlaceHolderInterface ph = (DegreePlanInterface.DegreePlaceHolderInterface)data;
            status = ARIA.degreePlaceholder(ph.getName());
            name = ph.getType();
        } else if (data instanceof DegreePlanInterface.DegreeGroupInterface) {
            DegreePlanInterface.DegreeGroupInterface group = (DegreePlanInterface.DegreeGroupInterface)data;
            status = group.isChoice() ? ARIA.degreeChoiceGroup(group.toString(MESSAGES)) : ARIA.degreeUnionGroup(group.toString(MESSAGES));
            name = group.toString(MESSAGES);
        } else if (data instanceof DegreePlanInterface.DegreeCourseInterface) {
            course = (DegreePlanInterface.DegreeCourseInterface)data;
            status = course.hasCourses() ? ARIA.degreeCourseWithChoice(course.getCourseName(), course.getTitle(), course.getCourses().size()) : ARIA.degreeCourseNotOffered(course.getCourseName(), course.getTitle());
            name = course.getCourseName();
        } else if (data instanceof ClassAssignmentInterface.CourseAssignment) {
            course = (ClassAssignmentInterface.CourseAssignment)data;
            status = course.getNote() == null || course.getNote().isEmpty() ? ARIA.degreeCourse(course.getCourseName(), course.getTitle()) : ARIA.degreeCourseWithNote(course.getCourseName(), course.getTitle(), course.getNote());
            name = course.getCourseName();
        }
        if (name != null && (w = this.iDegreePlanTable.getWidget(row, 1)) != null && w instanceof RadioButton) {
            RadioButton radio = (RadioButton)w;
            status = radio.getValue() != false ? (String)status + " " + ARIA.degreeCourseSelected(name) : (String)status + " " + ARIA.degreeSpaceToSelectCourse(name);
        }
        if (status != null) {
            AriaStatus.getInstance().setText(ARIA.selectedLine(row, this.iDegreePlanTable.getRowCount() - 1) + " " + (String)status);
        }
    }

    public static interface AssignmentProvider {
        public ClassAssignmentInterface getLastAssignment();

        public ClassAssignmentInterface getSavedAssignment();
    }
}

