/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.sectioning.AcademicSessionSelector;
import org.unitime.timetable.gwt.client.sectioning.AdvisorCourseRequestLine;
import org.unitime.timetable.gwt.client.sectioning.AdvisorCourseRequestsTable;
import org.unitime.timetable.gwt.client.sectioning.AriaMultiButton;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestsConfirmationDialog;
import org.unitime.timetable.gwt.client.sectioning.DegreePlanDialog;
import org.unitime.timetable.gwt.client.sectioning.DegreePlansSelectionDialog;
import org.unitime.timetable.gwt.client.sectioning.ScheduleStatus;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusCookie;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.sectioning.StudentStatusDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDetails;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class AdvisorCourseRequestsPage
extends SimpleForm
implements TakesValue<CourseRequestInterface> {
    private static final SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private static DateTimeFormat sTSF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private UniTimeHeaderPanel header;
    private UniTimeHeaderPanel footer;
    private Lookup iLookupDialog = null;
    private Label iStudentName;
    private Label iStudentExternalId;
    private Label iTerm;
    private Label iStudentEmail;
    private Label iAdvisorEmail = null;
    private AdvisorAcademicSessionSelector iSession = null;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecRegCx = null;
    private Label iTotalCredit = null;
    private ListBox iStatus = null;
    private TextArea iNotes = null;
    private CheckBox iPinReleased = null;
    private Label iPin = null;
    private P iWaitListHeader = null;
    private ArrayList<AdvisorCourseRequestLine> iCourses;
    private ArrayList<AdvisorCourseRequestLine> iAlternatives;
    private OnlineSectioningInterface.AdvisingStudentDetails iDetails;
    private DegreePlansSelectionDialog iDegreePlansSelectionDialog = null;
    private DegreePlanDialog iDegreePlanDialog = null;
    private AriaMultiButton iDegreePlan = null;
    private int iStudentRequestHeaderLine = 0;
    private int iAdisorRequestsHeaderLine = 0;
    private int iOtherSessionRecommendations = 0;
    private int iPinLine = 0;
    private int iStatusLine = 0;
    private ScheduleStatus iStatusBox = null;
    private ScheduleStatus iStudentStatus = null;
    private WebTable iRequests;
    private AdvisorCourseRequestsTable iAdvisorRequests;
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private CheckBox iEmailConfirmationHeader;
    private CheckBox iEmailConfirmationFooter;
    private AriaButton iLastNotes = null;
    private AdvisorNotesTable iLastNotesTable = null;
    private ScrollPanel iLastNotesScroll = null;
    private UniTimeDialogBox iLastNotesDialog = null;

    public AdvisorCourseRequestsPage() {
        super(7);
        UniTimePageHeader.getInstance().getLeft().setVisible(false);
        UniTimePageHeader.getInstance().getLeft().setPreventDefault(true);
        this.addStyleName("unitime-AdvisorCourseRequests");
        this.iContext = new OnlineSectioningInterface.StudentSectioningContext();
        this.iContext.setOnline(true);
        this.header = new UniTimeHeaderPanel();
        this.header.addStyleName("unitime-PageHeaderFooter");
        this.header.addButton("lookup", MESSAGES.buttonLookupStudent(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AdvisorCourseRequestsPage.this.isPageChanged()) {
                    UniTimeConfirmationDialog.confirm(MESSAGES.queryLeaveAdvisorsCourseRequestsNotSave(), new Command(){

                        public void execute() {
                            AdvisorCourseRequestsPage.this.lookupStudent();
                        }
                    });
                } else {
                    AdvisorCourseRequestsPage.this.lookupStudent();
                }
            }
        });
        this.header.addButton("print", MESSAGES.buttonExportPdf(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestsPage.this.submit();
            }
        });
        this.header.setEnabled("print", false);
        this.header.addButton("submit", MESSAGES.buttonSubmitPrint(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestsPage.this.submit();
            }
        });
        this.header.setEnabled("submit", false);
        this.addHeaderRow((Widget)this.header);
        this.iStudentName = new Label();
        this.iStudentName.addStyleName("student-name");
        this.iStudentExternalId = new Label();
        this.iStudentExternalId.addStyleName("student-id");
        this.iStudentEmail = new Label();
        this.iStudentEmail.addStyleName("student-email");
        this.addDoubleRow(MESSAGES.propStudentName(), (Widget)this.iStudentName, 1, MESSAGES.propStudentExternalId(), (Widget)this.iStudentExternalId, 4);
        this.iSession = new AdvisorAcademicSessionSelector();
        this.iAdvisorEmail = new Label();
        this.iAdvisorEmail.addStyleName("advisor-email");
        this.iTerm = new Label();
        this.iTerm.addStyleName("term");
        this.addDoubleRow(MESSAGES.propStudentEmail(), (Widget)this.iStudentEmail, 1, MESSAGES.propAcademicSession(), (Widget)this.iTerm, 4);
        this.iSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            @Override
            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                AdvisorCourseRequestsPage.this.iTerm.setText(AdvisorCourseRequestsPage.this.iSession.getAcademicSessionName() == null ? "" : AdvisorCourseRequestsPage.this.iSession.getAcademicSessionName());
                AdvisorCourseRequestsPage.this.iContext.setSessionId(event.getNewAcademicSessionId());
                AdvisorCourseRequestsPage.this.iContext.setStudentId(null);
                AdvisorCourseRequestsPage.this.iLookupDialog.setOptions("mustHaveExternalId,source=students,session=" + event.getNewAcademicSessionId());
                AdvisorCourseRequestsPage.this.header.setEnabled("submit", false);
                AdvisorCourseRequestsPage.this.header.setEnabled("print", false);
                AdvisorCourseRequestsPage.this.iDegreePlan.setVisible(false);
                AdvisorCourseRequestsPage.this.iDegreePlan.setEnabled(false);
                AdvisorCourseRequestsPage.this.iEmailConfirmationHeader.setVisible(false);
                AdvisorCourseRequestsPage.this.iEmailConfirmationFooter.setVisible(false);
                AdvisorCourseRequestsPage.this.iStatusBox.clear();
                AdvisorCourseRequestsPage.this.hideLastNotes();
                LoadingWidget.getInstance().show(MESSAGES.loadingAdvisorRequests(AdvisorCourseRequestsPage.this.iStudentName.getText()));
                sSectioningService.getStudentAdvisingDetails(AdvisorCourseRequestsPage.this.iSession.getAcademicSessionId(), AdvisorCourseRequestsPage.this.iStudentExternalId.getText(), new AsyncCallback<OnlineSectioningInterface.AdvisingStudentDetails>(){

                    public void onSuccess(OnlineSectioningInterface.AdvisingStudentDetails result) {
                        LoadingWidget.getInstance().hide();
                        AdvisorCourseRequestsPage.this.iDetails = result;
                        AdvisorCourseRequestsPage.this.iContext.setStudentId(AdvisorCourseRequestsPage.this.iDetails == null ? null : AdvisorCourseRequestsPage.this.iDetails.getStudentId());
                        AdvisorCourseRequestsPage.this.iSpecRegCx.setCanRequire(AdvisorCourseRequestsPage.this.iDetails == null || AdvisorCourseRequestsPage.this.iDetails.isCanRequire());
                        AdvisorCourseRequestsPage.this.iContext.setClassScheduleNotAvailable(AdvisorCourseRequestsPage.this.iDetails == null ? null : Boolean.valueOf(AdvisorCourseRequestsPage.this.iDetails.isClassScheduleNotAvailable()));
                        AdvisorCourseRequestsPage.this.header.setEnabled("submit", result.isCanUpdate());
                        AdvisorCourseRequestsPage.this.header.setEnabled("print", !result.isCanUpdate());
                        if (result.isCanUpdate()) {
                            AdvisorCourseRequestsPage.this.checkForLastNotes();
                        }
                        AdvisorCourseRequestsPage.this.iDegreePlan.setVisible(result.isDegreePlan());
                        AdvisorCourseRequestsPage.this.iDegreePlan.setEnabled(result.isDegreePlan());
                        AdvisorCourseRequestsPage.this.iEmailConfirmationHeader.setVisible(result.isCanUpdate() && result.isCanEmail());
                        AdvisorCourseRequestsPage.this.iEmailConfirmationFooter.setVisible(result.isCanUpdate() && result.isCanEmail());
                        AdvisorCourseRequestsPage.this.iAdvisorEmail.setText(result.getAdvisorEmail() == null ? "" : result.getAdvisorEmail());
                        AdvisorCourseRequestsPage.this.iStudentName.setText(result.getStudentName());
                        AdvisorCourseRequestsPage.this.iStudentEmail.setText(result.getStudentEmail() == null ? "" : result.getStudentEmail());
                        AdvisorCourseRequestsPage.this.iStudentExternalId.setText(result.getStudentExternalId());
                        AdvisorCourseRequestsPage.this.iAdvisorRequests.setMode(result.getWaitListMode());
                        String wlHeader = null;
                        switch (result.getWaitListMode()) {
                            case NoSubs: {
                                wlHeader = MESSAGES.headNoSubs();
                                break;
                            }
                            case WaitList: {
                                wlHeader = MESSAGES.headWaitList();
                            }
                        }
                        if (result.isCriticalCheckCritical()) {
                            wlHeader = wlHeader == null ? MESSAGES.opSetCritical() : MESSAGES.opSetCritical() + "&nbsp;&nbsp;" + wlHeader;
                        } else if (result.isCriticalCheckImportant()) {
                            wlHeader = wlHeader == null ? MESSAGES.opSetImportant() : MESSAGES.opSetImportant() + "&nbsp;&nbsp;" + wlHeader;
                        } else if (result.isCriticalCheckVital()) {
                            wlHeader = wlHeader == null ? MESSAGES.opSetVital() : MESSAGES.opSetVital() + "&nbsp;&nbsp;" + wlHeader;
                        }
                        AdvisorCourseRequestsPage.this.iWaitListHeader.setHTML(wlHeader == null ? "&nbsp;" : wlHeader);
                        if (result.hasCriticalCheck() && result.getWaitListMode() != OnlineSectioningInterface.WaitListMode.None) {
                            AdvisorCourseRequestsPage.this.iWaitListHeader.removeStyleName("waitlist-header");
                            AdvisorCourseRequestsPage.this.iWaitListHeader.addStyleName("waitlist-header-with-critical");
                        } else {
                            AdvisorCourseRequestsPage.this.iWaitListHeader.removeStyleName("waitlist-header-with-critical");
                            AdvisorCourseRequestsPage.this.iWaitListHeader.addStyleName("waitlist-header");
                        }
                        AdvisorCourseRequestsPage.this.fillInStudentRequests();
                        AdvisorCourseRequestsPage.this.fillInOtherSessionRecommendations();
                        if (result != null && result.getStudentRequest() != null && result.getRequest().hasErrorMessage()) {
                            AdvisorCourseRequestsPage.this.iStudentStatus.error(result.getRequest().getErrorMessaeg(), false);
                        }
                        if (result.isCanUpdate()) {
                            AdvisorCourseRequestsPage.this.clearAdvisorRequests();
                            AdvisorCourseRequestsPage.this.setRequest(result.getRequest());
                            AdvisorCourseRequestsPage.this.setPin(result.getRequest());
                            AdvisorCourseRequestsPage.this.iStatus.clear();
                            if (result.getStatus() != null) {
                                AdvisorCourseRequestsPage.this.iStatus.addItem(result.getStatus().getLabel(), result.getStatus().getReference());
                            } else {
                                AdvisorCourseRequestsPage.this.iStatus.addItem("", "");
                            }
                            AdvisorCourseRequestsPage.this.iStatus.setSelectedIndex(0);
                            if (result.hasStatuses()) {
                                for (OnlineSectioningInterface.StudentStatusInfo status : result.getStatuses()) {
                                    if (status.equals(result.getStatus())) continue;
                                    AdvisorCourseRequestsPage.this.iStatus.addItem(status.getLabel(), status.getReference());
                                }
                                AdvisorCourseRequestsPage.this.iStatus.setEnabled(true);
                            } else {
                                AdvisorCourseRequestsPage.this.iStatus.setEnabled(false);
                            }
                            AdvisorCourseRequestsPage.this.getRowFormatter().setVisible(AdvisorCourseRequestsPage.this.iStatusLine, true);
                        } else {
                            AdvisorCourseRequestsPage.this.setAdvisorRequests(result.getRequest());
                            AdvisorCourseRequestsPage.this.setPin(result.getRequest());
                            if (result.getStatus() != null) {
                                AdvisorCourseRequestsPage.this.iStatus.clear();
                                AdvisorCourseRequestsPage.this.iStatus.addItem(result.getStatus().getLabel(), result.getStatus().getReference());
                                AdvisorCourseRequestsPage.this.iStatus.setSelectedIndex(0);
                                AdvisorCourseRequestsPage.this.iStatus.setEnabled(false);
                                AdvisorCourseRequestsPage.this.getRowFormatter().setVisible(AdvisorCourseRequestsPage.this.iStatusLine, true);
                            } else {
                                AdvisorCourseRequestsPage.this.getRowFormatter().setVisible(AdvisorCourseRequestsPage.this.iStatusLine, false);
                            }
                        }
                        AdvisorCourseRequestsPage.this.iPinReleased.setEnabled(result.isCanUpdate());
                        History.newItem((String)String.valueOf(result.getStudentId()), (boolean)false);
                    }

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsLoadFailed(caught.getMessage()), caught);
                    }
                });
            }
        });
        this.iTerm.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestsPage.this.iSession.selectSession();
            }
        });
        this.iStudentName.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AdvisorCourseRequestsPage.this.isPageChanged()) {
                    UniTimeConfirmationDialog.confirm(MESSAGES.queryLeaveAdvisorsCourseRequestsNotSave(), new Command(){

                        public void execute() {
                            AdvisorCourseRequestsPage.this.lookupStudent();
                        }
                    });
                } else {
                    AdvisorCourseRequestsPage.this.lookupStudent();
                }
            }
        });
        this.iStudentExternalId.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AdvisorCourseRequestsPage.this.isPageChanged()) {
                    UniTimeConfirmationDialog.confirm(MESSAGES.queryLeaveAdvisorsCourseRequestsNotSave(), new Command(){

                        public void execute() {
                            AdvisorCourseRequestsPage.this.lookupStudent();
                        }
                    });
                } else {
                    AdvisorCourseRequestsPage.this.lookupStudent();
                }
            }
        });
        this.iStatus = new ListBox();
        this.iStatus.addStyleName("status");
        this.iStatusLine = this.addDoubleRow(MESSAGES.propAdvisorEmail(), (Widget)this.iAdvisorEmail, 1, MESSAGES.propStudentStatus(), (Widget)this.iStatus, 4);
        this.iPinReleased = new CheckBox(MESSAGES.propStudentPin());
        this.iPinReleased.addStyleName("unitime-PinToggle");
        this.iPin = new Label();
        this.iPin.addStyleName("unitime-Pin");
        this.iPin.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AdvisorCourseRequestsPage.this.iDetails != null && !AdvisorCourseRequestsPage.this.iDetails.isCanUpdate()) {
                    return;
                }
                AdvisorCourseRequestsPage.this.iPinReleased.setValue(Boolean.valueOf(AdvisorCourseRequestsPage.this.iPinReleased.getValue() == false));
                AdvisorCourseRequestsPage.this.pinReleaseChanged();
            }
        });
        this.iPinLine = this.addDoubleRow((Widget)new Label(), (Widget)new Label(), 1, (Widget)this.iPinReleased, (Widget)this.iPin, 4);
        this.getRowFormatter().setVisible(this.iPinLine, true);
        this.iPinReleased.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                AdvisorCourseRequestsPage.this.pinReleaseChanged();
            }
        });
        this.iStudentStatus = new ScheduleStatus();
        this.addRow((Widget)this.iStudentStatus);
        UniTimeHeaderPanel studentReqs = new UniTimeHeaderPanel(MESSAGES.studentCourseRequests());
        this.iStudentRequestHeaderLine = this.addHeaderRow((Widget)studentReqs);
        this.iRequests = new WebTable();
        this.iRequests.setEmptyMessage(MESSAGES.emptyRequests());
        this.iRequests.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colPriority(), 1, "25px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colTitle(), 1, "200px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "20px"), new WebTable.Cell(MESSAGES.colPreferences(), 1, "100px"), new WebTable.Cell(MESSAGES.colWarnings(), 1, "200px"), new WebTable.Cell(MESSAGES.colStatus(), 1, "20px"), new WebTable.Cell(MESSAGES.colCritical(), 1, "20px"), new WebTable.Cell(MESSAGES.colWaitList(), 1, "20px"), new WebTable.Cell(MESSAGES.colRequestTimeStamp(), 1, "50px")));
        ScrollPanel sp = new ScrollPanel((Widget)this.iRequests);
        sp.addStyleName("student-course-requests");
        this.addRow((Widget)sp);
        UniTimeHeaderPanel advisorReqs = new UniTimeHeaderPanel(MESSAGES.advisorCourseRequests());
        this.iAdisorRequestsHeaderLine = this.addHeaderRow((Widget)advisorReqs);
        this.iAdvisorRequests = new AdvisorCourseRequestsTable();
        this.addRow((Widget)this.iAdvisorRequests);
        this.getRowFormatter().setVisible(this.iAdisorRequestsHeaderLine, false);
        this.getRowFormatter().setVisible(this.iAdisorRequestsHeaderLine + 1, false);
        this.iSpecRegCx = new SpecialRegistrationInterface.SpecialRegistrationContext();
        this.iCourses = new ArrayList();
        this.iAlternatives = new ArrayList();
        UniTimeHeaderPanel requests = new UniTimeHeaderPanel(MESSAGES.advisorRequestsCourses());
        requests.setMessage(MESSAGES.headCreditHoursNotes());
        requests.addStyleName("requests-header");
        this.iWaitListHeader = new P("waitlist-header");
        this.iWaitListHeader.setHTML(MESSAGES.headWaitList());
        requests.insertRight((Widget)this.iWaitListHeader, true);
        this.addHeaderRow((Widget)requests);
        for (int i = 0; i < 9; ++i) {
            final AdvisorCourseRequestLine line = new AdvisorCourseRequestLine(this.iContext, i, false, null, this.iSpecRegCx);
            line.insert(this, this.getRowCount());
            this.iCourses.add(line);
            if (i > 0) {
                AdvisorCourseRequestLine prev = this.iCourses.get(i - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            }
            line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                    if (event.getValue() != null && AdvisorCourseRequestsPage.this.iCourses.indexOf(line) + 1 == AdvisorCourseRequestsPage.this.iCourses.size()) {
                        AdvisorCourseRequestsPage.this.addCourseLine();
                    }
                    AdvisorCourseRequestsPage.this.updateTotalCredits();
                }
            });
        }
        Label l = new Label(MESSAGES.labelTotalPriorityCreditHours());
        l.addStyleName("total-credit-label");
        int row = this.getRowCount();
        this.setWidget(row, 0, (Widget)l);
        this.getFlexCellFormatter().setColSpan(row, 0, 2);
        this.iTotalCredit = new Label(MESSAGES.credit(0.0f));
        this.iTotalCredit.addStyleName("total-credit-value");
        this.setWidget(row, 1, (Widget)this.iTotalCredit);
        UniTimeHeaderPanel alternatives = new UniTimeHeaderPanel(MESSAGES.advisorRequestsAlternatives());
        alternatives.setMessage(MESSAGES.courseRequestsAlternativesNote());
        this.addHeaderRow((Widget)alternatives);
        for (int i = 0; i < 2; ++i) {
            final AdvisorCourseRequestLine line = new AdvisorCourseRequestLine(this.iContext, i, true, null, this.iSpecRegCx);
            line.insert(this, this.getRowCount());
            this.iAlternatives.add(line);
            if (i == 0) {
                prev = this.iCourses.get(this.iCourses.size() - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            } else {
                prev = this.iAlternatives.get(i - 1);
                line.setPrevious(prev);
                prev.setNext(line);
            }
            line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                    if (event.getValue() != null && AdvisorCourseRequestsPage.this.iAlternatives.indexOf(line) + 1 == AdvisorCourseRequestsPage.this.iAlternatives.size()) {
                        AdvisorCourseRequestsPage.this.addAlternativeLine();
                    }
                }
            });
        }
        this.iCourses.get(1).getCourses().get(0).setHint(MESSAGES.courseRequestsHint1());
        this.iCourses.get(3).getCourses().get(0).setHint(MESSAGES.courseRequestsHint3());
        this.iCourses.get(4).getCourses().get(0).setHint(MESSAGES.courseRequestsHint4());
        this.iCourses.get(this.iCourses.size() - 1).getCourses().get(0).setHint(MESSAGES.courseRequestsHint8());
        this.iAlternatives.get(0).getCourses().get(0).setHint(MESSAGES.courseRequestsHintA0());
        this.iNotes = new TextArea();
        this.iNotes.setStyleName("unitime-TextArea");
        this.iNotes.addStyleName("advisor-notes");
        this.iNotes.setText("");
        this.iNotes.getElement().setAttribute("maxlength", "2048");
        int notesRow = this.addRow(MESSAGES.propAdvisorNotes(), (Widget)this.iNotes);
        for (int i = 0; i < this.getCellCount(notesRow); ++i) {
            this.getCellFormatter().addStyleName(notesRow, i, "advisor-notes-line");
        }
        final Timer timer = new Timer(){

            public void run() {
                AdvisorCourseRequestsPage.this.resizeNotes();
            }
        };
        this.iNotes.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                timer.schedule(10);
            }
        });
        this.iNotes.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                timer.schedule(10);
            }
        });
        this.footer = this.header.clonePanel();
        this.footer.addStyleName("unitime-PageHeaderFooter");
        this.addBottomRow((Widget)this.footer);
        this.iEmailConfirmationHeader = new CheckBox(MESSAGES.checkSendEmailConfirmation(), true);
        this.iEmailConfirmationHeader.addStyleName("toggle");
        this.header.insertRight((Widget)this.iEmailConfirmationHeader, true);
        this.iEmailConfirmationHeader.setVisible(false);
        this.iEmailConfirmationFooter = new CheckBox(MESSAGES.checkSendEmailConfirmation(), true);
        this.iEmailConfirmationFooter.addStyleName("toggle");
        this.footer.insertRight((Widget)this.iEmailConfirmationFooter, true);
        this.iEmailConfirmationFooter.setVisible(false);
        this.iEmailConfirmationHeader.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                AdvisorCourseRequestsPage.this.iEmailConfirmationFooter.setValue((Boolean)event.getValue(), false);
                SectioningStatusCookie.getInstance().setAdvisorRequestsEmailStudent((Boolean)event.getValue());
            }
        });
        this.iEmailConfirmationFooter.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                AdvisorCourseRequestsPage.this.iEmailConfirmationHeader.setValue((Boolean)event.getValue(), false);
                SectioningStatusCookie.getInstance().setAdvisorRequestsEmailStudent((Boolean)event.getValue());
            }
        });
        this.iEmailConfirmationHeader.setValue(Boolean.valueOf(SectioningStatusCookie.getInstance().isAdvisorRequestsEmailStudent()));
        this.iEmailConfirmationFooter.setValue(this.iEmailConfirmationHeader.getValue());
        this.iStatusBox = new ScheduleStatus();
        this.addRow((Widget)this.iStatusBox);
        this.iLastNotes = new AriaButton(MESSAGES.buttonLastNotes());
        this.iLastNotes.setTitle(MESSAGES.hintLastNotes());
        this.iLastNotes.setVisible(false);
        this.iLastNotes.setEnabled(false);
        this.iLastNotes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestsPage.this.iLastNotesDialog.center();
            }
        });
        this.footer.insertLeft((Widget)this.iLastNotes, false);
        this.iLastNotesTable = new AdvisorNotesTable();
        this.iLastNotesTable.addMouseClickListener(new UniTimeTable.MouseClickListener<OnlineSectioningInterface.AdvisorNote>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<OnlineSectioningInterface.AdvisorNote> event) {
                if (event.getData() != null) {
                    AdvisorCourseRequestsPage.this.iNotes.setText(event.getData().getReplaceString());
                    AdvisorCourseRequestsPage.this.resizeNotes();
                    AdvisorCourseRequestsPage.this.iLastNotesDialog.hide();
                    AdvisorCourseRequestsPage.this.iLastNotes.getElement().scrollIntoView();
                }
            }
        });
        this.iLastNotesScroll = new ScrollPanel((Widget)this.iLastNotesTable);
        this.iLastNotesScroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
        this.iLastNotesScroll.setStyleName("unitime-ScrollPanel");
        this.iLastNotesDialog = new UniTimeDialogBox(true, false);
        this.iLastNotesDialog.setEscapeToHide(true);
        this.iLastNotesDialog.setWidget((Widget)this.iLastNotesScroll);
        this.iLastNotesDialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

            public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                AdvisorCourseRequestsPage.this.iLastNotesScroll.setHeight(Math.min(AdvisorCourseRequestsPage.this.iLastNotesTable.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                AdvisorCourseRequestsPage.this.iLastNotesDialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - AdvisorCourseRequestsPage.this.iLastNotesDialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - AdvisorCourseRequestsPage.this.iLastNotesDialog.getOffsetHeight()) / 2, 0));
            }
        });
        this.iLastNotesDialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        this.iLastNotesDialog.setText(MESSAGES.dialogLastNotes());
        this.iDegreePlan = new AriaMultiButton(MESSAGES.buttonDegreePlan());
        this.iDegreePlan.setTitle(MESSAGES.hintDegreePlan());
        this.iDegreePlan.setVisible(false);
        this.iDegreePlan.setEnabled(false);
        this.header.insertLeft((Widget)this.iDegreePlan, true);
        this.footer.insertLeft((Widget)this.iDegreePlan.createClone(), true);
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                if (AdvisorCourseRequestsPage.this.isPageChanged()) {
                    if (LoadingWidget.getInstance().isShowing()) {
                        LoadingWidget.getInstance().hide();
                    }
                    event.setMessage(MESSAGES.queryLeaveAdvisorsCourseRequestsNotSave());
                }
            }
        });
        this.iLookupDialog = new Lookup();
        this.iLookupDialog.setText(MESSAGES.dialogStudentLookup());
        this.iLookupDialog.setOptions("mustHaveExternalId,source=students");
        this.iLookupDialog.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                AdvisorCourseRequestsPage.this.studentSelected((PersonInterface)event.getValue());
            }
        });
        if (Window.Location.getParameter((String)"student") != null) {
            this.iStudentExternalId.setText(Window.Location.getParameter((String)"student"));
            this.iSession.selectSession(new AcademicSessionProvider.AcademicSessionMatcher(){

                protected boolean matchCampus(AcademicSessionProvider.AcademicSessionInfo info, String campus) {
                    if (info.hasExternalCampus() && campus.equalsIgnoreCase(info.getExternalCampus())) {
                        return true;
                    }
                    return campus.equalsIgnoreCase(info.getCampus());
                }

                protected boolean matchTerm(AcademicSessionProvider.AcademicSessionInfo info, String term) {
                    if (info.hasExternalTerm() && term.equalsIgnoreCase(info.getExternalTerm())) {
                        return true;
                    }
                    return term.equalsIgnoreCase(info.getTerm() + info.getYear()) || term.equalsIgnoreCase(info.getYear() + info.getTerm()) || term.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus());
                }

                protected boolean matchSession(AcademicSessionProvider.AcademicSessionInfo info, String session) {
                    if (info.hasExternalTerm() && info.hasExternalCampus() && session.equalsIgnoreCase(info.getExternalTerm() + info.hasExternalCampus())) {
                        return true;
                    }
                    return session.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus()) || session.equalsIgnoreCase(info.getTerm() + info.getYear()) || session.equals(info.getSessionId().toString());
                }

                @Override
                public boolean match(AcademicSessionProvider.AcademicSessionInfo info) {
                    String campus = Window.Location.getParameter((String)"campus");
                    if (campus != null && !this.matchCampus(info, campus)) {
                        return false;
                    }
                    String term = Window.Location.getParameter((String)"term");
                    if (term != null && !this.matchTerm(info, term)) {
                        return false;
                    }
                    String session = Window.Location.getParameter((String)"session");
                    return session == null || this.matchSession(info, session);
                }
            }, new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Boolean result) {
                }
            });
        } else if (Window.Location.getHash() != null && !Window.Location.getHash().isEmpty()) {
            this.loadStudent(Window.Location.getHash().substring(1));
        } else {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    AdvisorCourseRequestsPage.this.lookupStudent();
                }
            });
        }
        this.iDegreePlan.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoadingWidget.getInstance().show(MESSAGES.waitListDegreePlans());
                sSectioningService.listDegreePlans(AdvisorCourseRequestsPage.this.iContext, new AsyncCallback<List<DegreePlanInterface>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        if (caught instanceof SectioningException) {
                            SectioningException s = (SectioningException)caught;
                            if (s.isInfo()) {
                                AdvisorCourseRequestsPage.this.iStatusBox.info(s.getMessage());
                            } else if (s.isWarning()) {
                                AdvisorCourseRequestsPage.this.iStatusBox.warning(s.getMessage());
                            } else if (s.isError()) {
                                AdvisorCourseRequestsPage.this.iStatusBox.error(s.getMessage());
                            } else {
                                AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.failedListDegreePlans(s.getMessage()), s);
                            }
                        } else {
                            AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.failedListDegreePlans(caught.getMessage()), caught);
                        }
                    }

                    public void onSuccess(List<DegreePlanInterface> result) {
                        LoadingWidget.getInstance().hide();
                        if (result == null || result.isEmpty()) {
                            AdvisorCourseRequestsPage.this.iStatusBox.info(MESSAGES.failedNoDegreePlans());
                        } else {
                            CourseFinderDetails details = new CourseFinderDetails();
                            details.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, String>(){

                                @Override
                                public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<String> callback) {
                                    sSectioningService.retrieveCourseDetails(AdvisorCourseRequestsPage.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                                }
                            });
                            CourseFinderClasses classes = new CourseFinderClasses(false, AdvisorCourseRequestsPage.this.iSpecRegCx);
                            classes.setDataProvider(new DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                                @Override
                                public void getData(ClassAssignmentInterface.CourseAssignment source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                                    sSectioningService.listClasses(AdvisorCourseRequestsPage.this.iContext, source.hasUniqueName() ? source.getCourseName() : source.getCourseNameWithTitle(), callback);
                                }
                            });
                            if (AdvisorCourseRequestsPage.this.iDegreePlanDialog == null) {
                                AdvisorCourseRequestsPage.this.iDegreePlanDialog = new DegreePlanDialog(StudentSectioningPage.Mode.REQUESTS, AdvisorCourseRequestsPage.this, null, new CourseFinder.CourseFinderCourseDetails[]{details, classes}){

                                    @Override
                                    protected void doBack() {
                                        super.doBack();
                                        AdvisorCourseRequestsPage.this.iDegreePlansSelectionDialog.show();
                                    }
                                };
                            }
                            if (AdvisorCourseRequestsPage.this.iDegreePlansSelectionDialog == null) {
                                AdvisorCourseRequestsPage.this.iDegreePlansSelectionDialog = new DegreePlansSelectionDialog(){

                                    @Override
                                    public void doSubmit(DegreePlanInterface plan) {
                                        super.doSubmit(plan);
                                        AdvisorCourseRequestsPage.this.iDegreePlanDialog.open(plan, true);
                                    }
                                };
                            }
                            AdvisorCourseRequestsPage.this.iDegreePlanDialog.setWaitListMode(AdvisorCourseRequestsPage.this.iDetails == null ? null : AdvisorCourseRequestsPage.this.iDetails.getWaitListMode());
                            AdvisorCourseRequestsPage.this.iDegreePlanDialog.setCriticalCheck(AdvisorCourseRequestsPage.this.iDetails == null ? null : AdvisorCourseRequestsPage.this.iDetails.getCriticalCheck());
                            if (result.size() == 1) {
                                AdvisorCourseRequestsPage.this.iDegreePlanDialog.open(result.get(0), false);
                            } else {
                                AdvisorCourseRequestsPage.this.iDegreePlansSelectionDialog.open(result);
                            }
                        }
                    }
                });
            }
        });
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(final ValueChangeEvent<String> event) {
                if (event.getValue() != null && !((String)event.getValue()).isEmpty()) {
                    if (AdvisorCourseRequestsPage.this.isPageChanged()) {
                        UniTimeConfirmationDialog.confirm(MESSAGES.queryLeaveAdvisorsCourseRequestsNotSave(), new Command(){

                            public void execute() {
                                AdvisorCourseRequestsPage.this.loadStudent((String)event.getValue());
                            }
                        });
                    } else {
                        AdvisorCourseRequestsPage.this.loadStudent((String)event.getValue());
                    }
                }
            }
        });
    }

    protected void pinReleaseChanged() {
        if (this.iPinReleased.getValue().booleanValue()) {
            this.iPin.setText(this.iDetails == null || this.iDetails.getRequest() == null || !this.iDetails.getRequest().hasPin() ? "" : this.iDetails.getRequest().getPin());
            this.iPin.removeStyleName("unitime-PinNotReleased");
        } else {
            this.iPin.setText(MESSAGES.pinNotReleasedToStudent());
            this.iPin.addStyleName("unitime-PinNotReleased");
        }
    }

    protected void hideLastNotes() {
        this.iLastNotes.setVisible(false);
        this.iLastNotes.setEnabled(false);
    }

    protected void checkForLastNotes() {
        sSectioningService.lastAdvisorNotes(this.iContext, new AsyncCallback<List<OnlineSectioningInterface.AdvisorNote>>(){

            public void onSuccess(List<OnlineSectioningInterface.AdvisorNote> result) {
                if (result != null && !result.isEmpty()) {
                    AdvisorCourseRequestsPage.this.iLastNotesTable.setData(result);
                    AdvisorCourseRequestsPage.this.iLastNotes.setVisible(true);
                    AdvisorCourseRequestsPage.this.iLastNotes.setEnabled(true);
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    protected void loadStudent(String studentId) {
        this.header.setEnabled("submit", false);
        this.header.setEnabled("print", false);
        this.hideLastNotes();
        this.iDegreePlan.setVisible(false);
        this.iDegreePlan.setEnabled(false);
        this.iEmailConfirmationHeader.setVisible(false);
        this.iEmailConfirmationFooter.setVisible(false);
        this.iStatusBox.clear();
        LoadingWidget.getInstance().show(MESSAGES.loadingData());
        sSectioningService.getStudentInfo(Long.valueOf(studentId), new AsyncCallback<OnlineSectioningInterface.StudentInfo>(){

            public void onSuccess(OnlineSectioningInterface.StudentInfo result) {
                LoadingWidget.getInstance().hide();
                AdvisorCourseRequestsPage.this.iTerm.setText(result.getSessionName());
                AdvisorCourseRequestsPage.this.iContext.setSessionId(result.getSessionId());
                AdvisorCourseRequestsPage.this.iContext.setStudentId(result.getStudentId());
                AdvisorCourseRequestsPage.this.iLookupDialog.setOptions("mustHaveExternalId,source=students,session=" + result.getSessionId());
                AdvisorCourseRequestsPage.this.iStudentName.setText(result.getStudentName());
                AdvisorCourseRequestsPage.this.iStudentExternalId.setText(result.getStudentExternalId());
                AdvisorCourseRequestsPage.this.iStudentEmail.setText(result.getStudentEmail() == null ? "" : result.getStudentEmail());
                if (result.getSessionId().equals(AdvisorCourseRequestsPage.this.iSession.getAcademicSessionId())) {
                    AdvisorCourseRequestsPage.this.iSession.selectSession(AdvisorCourseRequestsPage.this.iSession.getAcademicSessionInfo(), true);
                } else {
                    AdvisorCourseRequestsPage.this.iSession.selectSession(result.getSessionId(), new AsyncCallback<Boolean>(){

                        public void onSuccess(Boolean result) {
                        }

                        public void onFailure(Throwable caught) {
                        }
                    });
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsLoadFailed(caught.getMessage()) + "\n" + MESSAGES.sessionExpiredClickToLogin(), caught, new Command(){

                    public void execute() {
                        Window.open((String)("selectPrimaryRole.action?list=Y&m=" + URL.encodeQueryString((String)MESSAGES.sessionExpiredClickToLogin()) + "&target=" + URL.encodeQueryString((String)Window.Location.getHref())), (String)"_self", (String)"");
                    }
                });
            }
        });
    }

    private void resizeNotes() {
        if (!this.iNotes.getText().isEmpty()) {
            this.iNotes.setHeight(Math.max(50, this.iNotes.getElement().getScrollHeight()) + "px");
        } else {
            this.iNotes.setHeight("50px");
        }
    }

    private void updateTotalCredits() {
        float min = 0.0f;
        float max = 0.0f;
        for (AdvisorCourseRequestLine line : this.iCourses) {
            min += line.getCreditMin();
            max += line.getCreditMax();
        }
        if (min < max) {
            this.iTotalCredit.setText(MESSAGES.creditRange(min, max));
        } else {
            this.iTotalCredit.setText(MESSAGES.credit(min));
        }
    }

    private void clearRequests() {
        int row = this.iAdisorRequestsHeaderLine + 1;
        for (AdvisorCourseRequestLine line : this.iCourses) {
            line.clear();
            line.setWaitListMode(this.iDetails == null ? OnlineSectioningInterface.WaitListMode.None : this.iDetails.getWaitListMode());
            line.setCriticalCheck(this.iDetails == null ? null : this.iDetails.getCriticalCheck());
            line.fixWidth(this, row++);
        }
        for (AdvisorCourseRequestLine line : this.iAlternatives) {
            line.clear();
        }
        this.iStatusBox.clear();
        this.iNotes.setText("");
        this.resizeNotes();
        this.updateTotalCredits();
    }

    private void clearPin() {
        this.iPinReleased.setValue(Boolean.valueOf(false));
        this.pinReleaseChanged();
        this.getRowFormatter().setVisible(this.iPinLine, false);
    }

    private void addCourseLine() {
        int i = this.iCourses.size();
        final AdvisorCourseRequestLine line = new AdvisorCourseRequestLine(this.iContext, i, false, null, this.iSpecRegCx);
        line.setWaitListMode(this.iDetails == null ? OnlineSectioningInterface.WaitListMode.None : this.iDetails.getWaitListMode());
        line.setCriticalCheck(this.iDetails == null ? null : this.iDetails.getCriticalCheck());
        this.iCourses.add(line);
        AdvisorCourseRequestLine prev = this.iCourses.get(i - 1);
        prev.getCourses().get(0).setHint("");
        line.getCourses().get(0).setHint(MESSAGES.courseRequestsHint8());
        AdvisorCourseRequestLine next = this.iAlternatives.isEmpty() ? null : this.iAlternatives.get(0);
        line.setPrevious(prev);
        prev.setNext(line);
        if (next != null) {
            line.setNext(next);
            next.setPrevious(line);
        }
        line.insert(this, this.insertRow(this.iAdisorRequestsHeaderLine + 2 + this.iCourses.size()));
        line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                if (event.getValue() != null && AdvisorCourseRequestsPage.this.iCourses.indexOf(line) + 1 == AdvisorCourseRequestsPage.this.iCourses.size()) {
                    AdvisorCourseRequestsPage.this.addCourseLine();
                }
                AdvisorCourseRequestsPage.this.updateTotalCredits();
            }
        });
    }

    private void addAlternativeLine() {
        AdvisorCourseRequestLine prev;
        int i = this.iAlternatives.size();
        final AdvisorCourseRequestLine line = new AdvisorCourseRequestLine(this.iContext, i, true, null, this.iSpecRegCx);
        this.iAlternatives.add(line);
        AdvisorCourseRequestLine advisorCourseRequestLine = prev = i == 0 ? this.iCourses.get(this.iCourses.size() - 1) : this.iAlternatives.get(i - 1);
        if (prev != null) {
            line.setPrevious(prev);
            prev.setNext(line);
        }
        line.insert(this, this.insertRow(this.iAdisorRequestsHeaderLine + this.iCourses.size() + 4 + this.iAlternatives.size()));
        line.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Request>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Request> event) {
                if (event.getValue() != null && AdvisorCourseRequestsPage.this.iAlternatives.indexOf(line) + 1 == AdvisorCourseRequestsPage.this.iAlternatives.size()) {
                    AdvisorCourseRequestsPage.this.addAlternativeLine();
                }
            }
        });
    }

    protected boolean isPageChanged() {
        if (this.iDetails != null && !this.iDetails.isCanUpdate()) {
            return false;
        }
        if (!this.iNotes.getText().equals(this.iDetails == null || this.iDetails.getRequest() == null || !this.iDetails.getRequest().hasCreditNote() ? "" : this.iDetails.getRequest().getCreditNote())) {
            return true;
        }
        if (this.iDetails == null || this.iDetails.getRequest() == null) {
            return !this.getRequest().isEmpty();
        }
        return !this.iDetails.getRequest().equals(this.getRequest());
    }

    protected void lookupStudent() {
        this.iLookupDialog.center();
    }

    protected void studentSelected(PersonInterface person) {
        this.iContext.setSessionId(null);
        this.iContext.setStudentId(null);
        if (person == null || person.getId() == null || person.getId().isEmpty()) {
            this.iStudentName.setText("");
            this.iStudentExternalId.setText("");
            this.iStudentEmail.setText("");
            this.iTerm.setText("");
            this.header.setEnabled("submit", false);
            this.header.setEnabled("print", false);
            this.iDegreePlan.setVisible(false);
            this.iDegreePlan.setEnabled(false);
            this.iEmailConfirmationHeader.setVisible(false);
            this.iEmailConfirmationFooter.setVisible(false);
            this.iStudentStatus.clear();
            this.clearRequests();
            this.clearPin();
            this.clearStudentRequests();
            this.clearOtherSessionRecommendations();
            this.clearAdvisorRequests();
            this.hideLastNotes();
        } else {
            this.iStudentName.setText(person.getName());
            this.iStudentExternalId.setText(person.getId());
            this.iStudentEmail.setText(person.getEmail() == null ? "" : person.getEmail());
            this.iStudentStatus.clear();
            this.clearRequests();
            this.clearPin();
            this.iSession.selectSessionNoCheck();
            this.clearStudentRequests();
            this.clearOtherSessionRecommendations();
            this.clearAdvisorRequests();
            this.hideLastNotes();
        }
    }

    public void fillInCourses(CourseRequestInterface cr) {
        for (AdvisorCourseRequestLine line : this.iCourses) {
            CourseRequestInterface.Request req = line.getValue();
            if (req == null) continue;
            cr.getCourses().add(req);
        }
    }

    public void fillInAlternatives(CourseRequestInterface cr) {
        for (AdvisorCourseRequestLine line : this.iAlternatives) {
            CourseRequestInterface.Request req = line.getValue();
            if (req == null) continue;
            cr.getAlternatives().add(req);
        }
    }

    public CourseRequestInterface getRequest() {
        CourseRequestInterface cr = new CourseRequestInterface(this.iContext);
        this.fillInCourses(cr);
        this.fillInAlternatives(cr);
        cr.setCreditNote(this.iNotes.getText());
        return cr;
    }

    public void setRequest(CourseRequestInterface request) {
        this.clearRequests();
        if (request != null) {
            int idx;
            while (this.iCourses.size() < request.getCourses().size()) {
                this.addCourseLine();
            }
            for (idx = 0; idx < request.getCourses().size(); ++idx) {
                this.iCourses.get(idx).setValue(request.getCourses().get(idx), true);
            }
            while (this.iAlternatives.size() < request.getAlternatives().size()) {
                this.addAlternativeLine();
            }
            for (idx = 0; idx < request.getAlternatives().size(); ++idx) {
                this.iAlternatives.get(idx).setValue(request.getAlternatives().get(idx), true);
            }
            if (request.hasCreditNote()) {
                this.iNotes.setText(request.getCreditNote());
                this.resizeNotes();
            }
        }
        this.updateTotalCredits();
    }

    public void setPin(CourseRequestInterface request) {
        if (request != null && request.hasPin()) {
            this.iPin.setText(request.getPin());
            this.iPinReleased.setValue(Boolean.valueOf(request.isPinReleased()));
            this.pinReleaseChanged();
            this.getRowFormatter().setVisible(this.iPinLine, true);
        } else {
            this.clearPin();
        }
    }

    public static final native String download(byte[] var0, String var1);

    protected void save(final OnlineSectioningInterface.AdvisingStudentDetails details) {
        LoadingWidget.getInstance().show(details.isCanUpdate() ? MESSAGES.advisorCourseRequestsSaving() : MESSAGES.advisorCourseRequestsExporting());
        sSectioningService.submitAdvisingDetails(details, false, new AsyncCallback<OnlineSectioningInterface.AdvisorCourseRequestSubmission>(){

            public void onSuccess(OnlineSectioningInterface.AdvisorCourseRequestSubmission result) {
                String statusLink;
                LoadingWidget.getInstance().hide();
                AdvisorCourseRequestsPage.this.iDetails = details;
                if (AdvisorCourseRequestsPage.this.iDetails.getAdvisorWaitListedCourseIds() != null && AdvisorCourseRequestsPage.this.iDetails.hasStudentRequest() && AdvisorCourseRequestsPage.this.iDetails.getRequest() != null) {
                    if (AdvisorCourseRequestsPage.this.iDetails.getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
                        AdvisorCourseRequestsPage.this.iDetails.setAdvisorWaitListedCourseIds(AdvisorCourseRequestsPage.this.iDetails.getRequest().getWaitListedCourseIds());
                    }
                    if (AdvisorCourseRequestsPage.this.iDetails.getWaitListMode() == OnlineSectioningInterface.WaitListMode.NoSubs) {
                        AdvisorCourseRequestsPage.this.iDetails.setAdvisorWaitListedCourseIds(AdvisorCourseRequestsPage.this.iDetails.getRequest().getNoSubCourseIds());
                    }
                    AdvisorCourseRequestsPage.this.fillInStudentRequests();
                }
                AdvisorCourseRequestsPage.this.iContext.setStudentId(AdvisorCourseRequestsPage.this.iDetails == null ? null : AdvisorCourseRequestsPage.this.iDetails.getStudentId());
                AdvisorCourseRequestsPage.download(result.getPdf(), (String)(result.hasName() ? result.getName() : "crf-" + AdvisorCourseRequestsPage.this.iTerm.getText() + "-" + AdvisorCourseRequestsPage.this.iStudentName.getText() + "-" + AdvisorCourseRequestsPage.this.iStudentExternalId.getText()));
                String string = statusLink = result.hasLink() ? "\n" + MESSAGES.advisorRequestsPdfLink(GWT.getHostPageBaseURL() + result.getLink()) : "";
                if (result.isUpdated()) {
                    AdvisorCourseRequestsPage.this.iStatusBox.info(MESSAGES.advisorRequestsSubmitOK() + statusLink);
                    if (AdvisorCourseRequestsPage.this.isSendEmailConformation()) {
                        final StudentStatusDialog dialog = new StudentStatusDialog(new HashSet<OnlineSectioningInterface.StudentStatusInfo>(), null);
                        if (SectioningStatusCookie.getInstance().hasEmailCC()) {
                            dialog.setCC(SectioningStatusCookie.getInstance().getEmailCC());
                        } else {
                            dialog.setCC(AdvisorCourseRequestsPage.this.iDetails.hasAdvisorEmail() ? AdvisorCourseRequestsPage.this.iDetails.getAdvisorEmail().replace("\n", ", ") : "");
                        }
                        dialog.setSubject(MESSAGES.defaulSubjectAdvisorRequests().replace("%session%", AdvisorCourseRequestsPage.this.iTerm.getText()));
                        dialog.setIncludeAdvisorRequests(true);
                        dialog.setIncludeClassSchedule(false);
                        dialog.setIncludeCourseRequests(false);
                        dialog.sendStudentEmail(new Command(){

                            public void execute() {
                                sSectioningService.sendEmail(AdvisorCourseRequestsPage.this.iDetails.getSessionId(), AdvisorCourseRequestsPage.this.iDetails.getStudentId(), dialog.getSubject(), dialog.getMessage(), dialog.getCC(), dialog.getIncludeCourseRequests(), dialog.getIncludeClassSchedule(), dialog.getIncludeAdvisorRequests(), dialog.isOptionalEmailToggle(), "user-acr", new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsEmailFailed(caught.getMessage()) + statusLink, caught);
                                    }

                                    public void onSuccess(Boolean result) {
                                        AdvisorCourseRequestsPage.this.iStatusBox.info(MESSAGES.advisorRequestsEmailSent() + statusLink);
                                    }
                                });
                            }
                        }, AdvisorCourseRequestsPage.this.iDetails.getEmailOptionalToggleCaption(), AdvisorCourseRequestsPage.this.iDetails.getEmailOptionalToggleDefault());
                    }
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                if (caught instanceof PageAccessException) {
                    AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsSubmitFailed(caught.getMessage()) + "\n" + MESSAGES.sessionExpiredClickToLogin(), caught, new Command(){

                        public void execute() {
                            Window.open((String)"selectPrimaryRole.action?list=Y&target=close.jsp&menu=hide", (String)"", (String)("toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width=720px, height=400px, top=" + (Window.getClientHeight() - 400) / 2 + "px, left=" + (Window.getClientWidth() - 720) / 2 + "px"));
                        }
                    });
                } else {
                    AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsSubmitFailed(caught.getMessage()), caught);
                }
            }
        });
    }

    protected void validateAndSave(final OnlineSectioningInterface.AdvisingStudentDetails details) {
        this.iStatusBox.clear();
        if (!details.isCanUpdate()) {
            this.save(details);
            return;
        }
        LoadingWidget.getInstance().show(MESSAGES.advisorCourseRequestsValidating());
        sSectioningService.checkAdvisingDetails(details, new AsyncCallback<CourseRequestInterface.CheckCoursesResponse>(){

            public void onSuccess(final CourseRequestInterface.CheckCoursesResponse result) {
                LoadingWidget.getInstance().hide();
                if (result == null) {
                    AdvisorCourseRequestsPage.this.save(details);
                    return;
                }
                for (AdvisorCourseRequestLine line : AdvisorCourseRequestsPage.this.iCourses) {
                    for (AdvisorCourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        courseSelectionBox.setErrors(result);
                    }
                }
                for (AdvisorCourseRequestLine line : AdvisorCourseRequestsPage.this.iAlternatives) {
                    for (AdvisorCourseRequestLine.CourseSelectionBox courseSelectionBox : line.getCourses()) {
                        courseSelectionBox.setErrors(result);
                    }
                }
                if (result.hasErrorMessage()) {
                    AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsValidationFailed(result.getErrorMessage()));
                    return;
                }
                if (result.isConfirm()) {
                    final Iterator<Integer> it = result.getConfirms().iterator();
                    new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                        }

                        public void onSuccess(Boolean accept) {
                            if (accept.booleanValue() && it.hasNext()) {
                                CourseRequestsConfirmationDialog.confirm(result, (Integer)it.next(), this);
                            } else if (accept.booleanValue()) {
                                AdvisorCourseRequestsPage.this.save(details);
                            }
                        }
                    }.onSuccess(true);
                } else {
                    AdvisorCourseRequestsPage.this.save(details);
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                if (caught instanceof PageAccessException) {
                    AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsValidationFailed(caught.getMessage()) + "\n" + MESSAGES.sessionExpiredClickToLogin(), caught, new Command(){

                        public void execute() {
                            Window.open((String)"selectPrimaryRole.action?list=Y&target=close.jsp&menu=hide", (String)"", (String)("toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width=720px, height=400px, top=" + (Window.getClientHeight() - 400) / 2 + "px, left=" + (Window.getClientWidth() - 720) / 2 + "px"));
                        }
                    });
                } else {
                    AdvisorCourseRequestsPage.this.iStatusBox.error(MESSAGES.advisorRequestsValidationFailed(caught.getMessage()), caught);
                }
            }
        });
    }

    protected void submit() {
        OnlineSectioningInterface.AdvisingStudentDetails details;
        details.setRequest((details = new OnlineSectioningInterface.AdvisingStudentDetails(this.iDetails)).isCanUpdate() ? this.getRequest() : this.iAdvisorRequests.getValue());
        details.setStatus(this.iDetails.getStatus(this.iStatus.getSelectedValue()));
        if (this.getRowFormatter().isVisible(this.iPinLine) && details.getRequest() != null) {
            details.getRequest().setPinReleased(this.iPinReleased.getValue());
            details.getRequest().setPin(this.iDetails.getRequest().getPin());
        }
        this.validateAndSave(details);
    }

    public void setValue(CourseRequestInterface value) {
        this.setRequest(value);
    }

    public CourseRequestInterface getValue() {
        return this.getRequest();
    }

    protected void clearStudentRequests() {
        this.iRequests.setData(new WebTable.Row[0]);
        this.getRowFormatter().setVisible(this.iStudentRequestHeaderLine, false);
        this.getRowFormatter().setVisible(this.iStudentRequestHeaderLine + 1, false);
    }

    protected void clearAdvisorRequests() {
        this.iAdvisorRequests.setValue(new CourseRequestInterface());
        this.getRowFormatter().setVisible(this.iAdisorRequestsHeaderLine, false);
        this.getRowFormatter().setVisible(this.iAdisorRequestsHeaderLine + 1, false);
        for (int i = this.iAdisorRequestsHeaderLine + 2; i < this.getRowCount() - 2; ++i) {
            this.getRowFormatter().setVisible(i, true);
        }
    }

    protected void setAdvisorRequests(CourseRequestInterface requests) {
        this.iAdvisorRequests.setValue(requests);
        this.getRowFormatter().setVisible(this.iAdisorRequestsHeaderLine, true);
        this.getRowFormatter().setVisible(this.iAdisorRequestsHeaderLine + 1, true);
        for (int i = this.iAdisorRequestsHeaderLine + 2; i < this.getRowCount() - 2; ++i) {
            this.getRowFormatter().setVisible(i, false);
        }
    }

    protected void fillInStudentRequests() {
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        boolean hasPref = false;
        boolean hasWarn = false;
        boolean hasWait = false;
        boolean hasCrit = false;
        boolean hasImp = false;
        boolean hasVital = false;
        boolean hasLC = false;
        boolean hasVisitF2F = false;
        NumberFormat df = NumberFormat.getFormat((String)"0.#");
        if (this.iDetails != null && this.iDetails.hasStudentRequest()) {
            Object free;
            WebTable.Row row;
            Object noteTitle;
            WebTable.Cell credit;
            String msg;
            Object iconText;
            ImageResource icon;
            boolean first;
            switch (this.iDetails.getStudentRequest().getWaitListMode()) {
                case NoSubs: {
                    this.iRequests.getTable().setHTML(0, 8, MESSAGES.colNoSubs());
                    break;
                }
                case WaitList: {
                    this.iRequests.getTable().setHTML(0, 8, MESSAGES.colWaitList());
                }
            }
            CourseRequestInterface.CheckCoursesResponse check = new CourseRequestInterface.CheckCoursesResponse(this.iDetails.getStudentRequest().getConfirmations());
            hasWarn = this.iDetails.getStudentRequest().hasConfirmations();
            int priority = 1;
            for (CourseRequestInterface.Request request : this.iDetails.getStudentRequest().getCourses()) {
                if (!request.hasRequestedCourse()) continue;
                first = true;
                if (request.isWaitlistOrNoSub(this.iDetails.getStudentRequest().getWaitListMode())) {
                    hasWait = true;
                }
                if (request.isCritical()) {
                    hasCrit = true;
                }
                if (request.isImportant()) {
                    hasImp = true;
                }
                if (request.isVital()) {
                    hasVital = true;
                }
                if (request.isLC()) {
                    hasLC = true;
                }
                if (request.isVisitingF2F()) {
                    hasVisitF2F = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        icon = null;
                        iconText = null;
                        msg = check.getMessage(rc.getCourseName(), "\n", new String[0]);
                        if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                            icon = RESOURCES.requestError();
                            iconText = msg;
                        } else if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    icon = RESOURCES.requestEnrolled();
                                    iconText = MESSAGES.enrolled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    icon = RESOURCES.requestNeeded();
                                    iconText = MESSAGES.overrideNeeded(msg);
                                    break;
                                }
                                case SAVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.requested(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    icon = RESOURCES.requestRejected();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideRejected(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    icon = RESOURCES.requestPending();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overridePending(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    icon = RESOURCES.requestCancelled();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideCancelled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideApproved(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    icon = RESOURCES.requestNotNeeded();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideNotNeeded(rc.getCourseName());
                                    break;
                                }
                                default: {
                                    if (check.isError(rc.getCourseName())) {
                                        icon = RESOURCES.requestError();
                                    }
                                    iconText = msg;
                                }
                            }
                        }
                        if (rc.hasRequestorNote()) {
                            iconText = iconText + "\n" + MESSAGES.requestNote(rc.getRequestorNote());
                        }
                        if (rc.hasStatusNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.overrideNote(rc.getStatusNote());
                        }
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        WebTable.Cell[] status = "";
                        if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    status = MESSAGES.reqStatusEnrolled();
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    status = MESSAGES.reqStatusApproved();
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    status = MESSAGES.reqStatusCancelled();
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    status = MESSAGES.reqStatusPending();
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    status = MESSAGES.reqStatusRejected();
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    status = MESSAGES.reqStatusNotNeeded();
                                }
                            }
                        }
                        if (status.isEmpty()) {
                            status = MESSAGES.reqStatusRegistered();
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        credit = new WebTable.Cell((String)(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : ""));
                        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                        Object note = null;
                        noteTitle = null;
                        if (check != null) {
                            note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                            noteTitle = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                        }
                        if (rc.hasRequestorNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getRequestorNote();
                            noteTitle = (String)(noteTitle == null ? "" : noteTitle + "\n") + rc.getRequestorNote();
                        }
                        if (rc.hasStatusNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getStatusNote();
                            noteTitle = (String)(noteTitle == null ? "" : noteTitle + "\n") + rc.getStatusNote();
                        }
                        WebTable.Cell[] cellArray = new WebTable.Cell[10];
                        cellArray[0] = new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : "");
                        cellArray[1] = new WebTable.Cell(rc.getCourseName());
                        cellArray[2] = new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : "");
                        cellArray[3] = credit;
                        cellArray[4] = new WebTable.Cell(ToolBox.toString(prefs));
                        cellArray[5] = new WebTable.NoteCell((String)note, (String)noteTitle);
                        WebTable.Cell cell = cellArray[6] = icon == null ? new WebTable.Cell((String)status) : new WebTable.IconCell(icon, (String)iconText, (String)status);
                        WebTable.Cell cell2 = first && request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), "") : (first && request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), "") : (first && request.isVital() ? new WebTable.IconCell(RESOURCES.requestsVital(), MESSAGES.descriptionRequestVital(), "") : (first && request.isLC() ? new WebTable.Cell(MESSAGES.opSetLC(), MESSAGES.descriptionRequestLC()) : (cellArray[7] = first && request.isVisitingF2F() ? new WebTable.IconCell(RESOURCES.requestsVisitingF2F(), MESSAGES.descriptionRequestVisitingF2F(), MESSAGES.opSetVisitingF2F()) : new WebTable.Cell("")))));
                        cellArray[8] = this.iDetails.getStudentRequest().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList ? (first && request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), request.hasWaitListedTimeStamp() ? sDF.format(request.getWaitListedTimeStamp()) : "") : new WebTable.Cell("")) : (first && request.isNoSub() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestNoSubs(), "") : new WebTable.Cell(""));
                        cellArray[9] = new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : "");
                        row = new WebTable.Row(cellArray);
                        if (priority > 1 && first) {
                            for (WebTable.Cell cell3 : row.getCells()) {
                                cell3.setStyleName("top-border-dashed");
                            }
                        }
                        rows.add(row);
                    } else if (rc.isFreeTime()) {
                        free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!((String)free).isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        String note = null;
                        String noteTitle2 = null;
                        if (check != null) {
                            note = check.getMessageWithColor(CONSTANTS.freePrefix() + (String)free, "<br>", new String[0]);
                            noteTitle2 = check.getMessage(CONSTANTS.freePrefix() + (String)free, "\n", "CREDIT");
                        }
                        WebTable.Row row2 = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : ""), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 3, null), new WebTable.Cell(""), new WebTable.NoteCell(note, noteTitle2), new WebTable.IconCell(RESOURCES.requestSaved(), MESSAGES.requested((String)free), MESSAGES.reqStatusRegistered()), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (priority > 1 && first) {
                            for (WebTable.Cell cell : row2.getCells()) {
                                cell.setStyleName("top-border-dashed");
                            }
                        }
                        rows.add(row2);
                    }
                    first = false;
                }
                ++priority;
            }
            priority = 1;
            for (CourseRequestInterface.Request request : this.iDetails.getStudentRequest().getAlternatives()) {
                if (!request.hasRequestedCourse()) continue;
                first = true;
                if (request.isWaitList()) {
                    hasWait = true;
                }
                if (request.isCritical()) {
                    hasCrit = true;
                }
                if (request.isImportant()) {
                    hasImp = true;
                }
                if (request.isVital()) {
                    hasVital = true;
                }
                if (request.isLC()) {
                    hasLC = true;
                }
                if (request.isVisitingF2F()) {
                    hasVisitF2F = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        icon = null;
                        iconText = null;
                        msg = check.getMessage(rc.getCourseName(), "\n", new String[0]);
                        if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                            icon = RESOURCES.requestError();
                            iconText = msg;
                        } else if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    icon = RESOURCES.requestEnrolled();
                                    iconText = MESSAGES.enrolled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    icon = RESOURCES.requestNeeded();
                                    iconText = MESSAGES.overrideNeeded(msg);
                                    break;
                                }
                                case SAVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.requested(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    icon = RESOURCES.requestRejected();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideRejected(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    icon = RESOURCES.requestPending();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overridePending(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    icon = RESOURCES.requestCancelled();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideCancelled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideApproved(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    icon = RESOURCES.requestNotNeeded();
                                    iconText = (String)(msg == null ? "" : MESSAGES.requestWarnings(msg) + "\n\n") + MESSAGES.overrideNotNeeded(rc.getCourseName());
                                    break;
                                }
                                default: {
                                    if (check.isError(rc.getCourseName())) {
                                        icon = RESOURCES.requestError();
                                    }
                                    iconText = msg;
                                }
                            }
                        }
                        if (rc.hasRequestorNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.requestNote(rc.getRequestorNote());
                        }
                        if (rc.hasStatusNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.overrideNote(rc.getStatusNote());
                        }
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<CourseRequestInterface.Preference>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        String status = "";
                        if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    status = MESSAGES.reqStatusEnrolled();
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    status = MESSAGES.reqStatusApproved();
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    status = MESSAGES.reqStatusCancelled();
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    status = MESSAGES.reqStatusPending();
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    status = MESSAGES.reqStatusRejected();
                                    break;
                                }
                                case OVERRIDE_NOT_NEEDED: {
                                    status = MESSAGES.reqStatusNotNeeded();
                                }
                            }
                        }
                        if (status.isEmpty()) {
                            status = MESSAGES.reqStatusRegistered();
                        }
                        credit = new WebTable.Cell((String)(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : ""));
                        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                        Object note = null;
                        noteTitle = null;
                        if (check != null) {
                            note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                            noteTitle = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                        }
                        if (rc.hasRequestorNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getRequestorNote();
                            noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + rc.getRequestorNote();
                        }
                        if (rc.hasStatusNote()) {
                            note = (String)(note == null ? "" : note + "<br>") + rc.getStatusNote();
                            noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + rc.getStatusNote();
                        }
                        WebTable.Cell[] cellArray = new WebTable.Cell[10];
                        cellArray[0] = new WebTable.Cell(first ? MESSAGES.courseRequestsAlternate(priority) : "");
                        cellArray[1] = new WebTable.Cell(rc.getCourseName());
                        cellArray[2] = new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : "");
                        cellArray[3] = credit;
                        cellArray[4] = new WebTable.Cell(ToolBox.toString(prefs));
                        cellArray[5] = new WebTable.NoteCell((String)note, (String)noteTitle);
                        WebTable.Cell cell = cellArray[6] = icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, (String)iconText, status);
                        WebTable.Cell cell4 = first && request.isCritical() ? new WebTable.IconCell(RESOURCES.requestsCritical(), MESSAGES.descriptionRequestCritical(), "") : (first && request.isImportant() ? new WebTable.IconCell(RESOURCES.requestsImportant(), MESSAGES.descriptionRequestImportant(), "") : (first && request.isVital() ? new WebTable.IconCell(RESOURCES.requestsVital(), MESSAGES.descriptionRequestVital(), "") : (first && request.isLC() ? new WebTable.Cell(MESSAGES.opSetLC(), MESSAGES.descriptionRequestLC()) : (cellArray[7] = first && request.isVisitingF2F() ? new WebTable.IconCell(RESOURCES.requestsVisitingF2F(), MESSAGES.descriptionRequestVisitingF2F(), MESSAGES.opSetVisitingF2F()) : new WebTable.Cell("")))));
                        cellArray[8] = first && request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), request.hasWaitListedTimeStamp() ? sDF.format(request.getWaitListedTimeStamp()) : "") : new WebTable.Cell("");
                        cellArray[9] = new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : "");
                        row = new WebTable.Row(cellArray);
                        if (first) {
                            for (WebTable.Cell cell3 : row.getCells()) {
                                cell3.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        rows.add(row);
                    } else if (rc.isFreeTime()) {
                        free = "";
                        for (CourseRequestInterface.FreeTime ft : rc.getFreeTime()) {
                            if (!((String)free).isEmpty()) {
                                free = (String)free + ", ";
                            }
                            free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        WebTable.Row row3 = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsAlternate(priority) : ""), new WebTable.Cell(CONSTANTS.freePrefix() + (String)free, 3, null), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.IconCell(RESOURCES.requestSaved(), MESSAGES.requested((String)free), MESSAGES.reqStatusRegistered()), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (first) {
                            for (WebTable.Cell cell : row3.getCells()) {
                                cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        rows.add(row3);
                    }
                    first = false;
                }
                ++priority;
            }
        }
        if (this.iDetails != null && this.iDetails.hasStudentRequest()) {
            float[] range;
            if (this.iDetails.getStudentRequest().getMaxCreditOverrideStatus() == null) {
                this.iDetails.getStudentRequest().setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
            }
            ImageResource icon = null;
            String status = "";
            Object note = null;
            Object noteTitle = null;
            Object iconText = null;
            if (this.iDetails.getStudentRequest().hasCreditWarning()) {
                note = this.iDetails.getStudentRequest().getCreditWarning().replace("\n", "<br>");
                noteTitle = this.iDetails.getStudentRequest().getCreditWarning();
                iconText = this.iDetails.getStudentRequest().getCreditWarning();
                hasWarn = true;
            } else if (this.iDetails.getStudentRequest().getMaxCreditOverrideStatus() != CourseRequestInterface.RequestedCourseStatus.SAVED) {
                noteTitle = iconText = MESSAGES.creditWarning(this.iDetails.getStudentRequest().getMaxCredit().floatValue());
                note = iconText;
            }
            switch (this.iDetails.getStudentRequest().getMaxCreditOverrideStatus()) {
                case CREDIT_HIGH: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusWarning();
                    note = "<span class='text-red'>" + (String)note + "</span>";
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusTooHigh();
                    break;
                }
                case OVERRIDE_REJECTED: {
                    icon = RESOURCES.requestError();
                    status = MESSAGES.reqStatusRejected();
                    note = "<span class='text-red'>" + (String)note + "</span>";
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusDenied();
                    break;
                }
                case OVERRIDE_NEEDED: 
                case CREDIT_LOW: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusWarning();
                    note = "<span class='text-orange'>" + (String)note + "</span>";
                    break;
                }
                case OVERRIDE_CANCELLED: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusCancelled();
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusCancelled();
                    note = "<span class='text-orange'>" + (String)note + "</span>";
                    break;
                }
                case OVERRIDE_PENDING: {
                    icon = RESOURCES.requestPending();
                    status = MESSAGES.reqStatusPending();
                    iconText = (String)iconText + "\n" + MESSAGES.creditStatusPending();
                    note = "<span class='text-orange'>" + (String)note + "</span>";
                    break;
                }
                case OVERRIDE_APPROVED: {
                    icon = RESOURCES.requestSaved();
                    status = MESSAGES.reqStatusApproved();
                    iconText = (String)iconText + (String)(iconText == null ? "" : (String)iconText + "\n") + MESSAGES.creditStatusApproved();
                    break;
                }
                case SAVED: {
                    icon = null;
                    status = "";
                }
            }
            if (this.iDetails.getStudentRequest().hasRequestorNote()) {
                note = (String)(note == null ? "" : (String)note + "<br>") + this.iDetails.getStudentRequest().getRequestorNote().replace("\n", "<br>");
                noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + MESSAGES.requestNote(this.iDetails.getStudentRequest().getRequestorNote());
                iconText = (String)(iconText == null ? "" : (String)iconText + "\n") + this.iDetails.getStudentRequest().getRequestorNote();
                hasWarn = true;
            }
            if (this.iDetails.getStudentRequest().hasCreditNote()) {
                note = (String)(note == null ? "" : (String)note + "<br>") + this.iDetails.getStudentRequest().getCreditNote().replace("\n", "<br>");
                noteTitle = (String)(noteTitle == null ? "" : (String)noteTitle + "\n") + MESSAGES.overrideNote(this.iDetails.getStudentRequest().getCreditNote());
                iconText = (String)(iconText == null ? "" : (String)iconText + "\n") + this.iDetails.getStudentRequest().getCreditNote();
                hasWarn = true;
            }
            WebTable.Cell credit = new WebTable.Cell((String)((range = this.iDetails.getStudentRequest().getCreditRange(this.iDetails.getAdvisorWaitListedCourseIds())) != null ? (range[0] < range[1] ? df.format((double)range[0]) + " - " + df.format((double)range[1]) : df.format((double)range[0])) : ""));
            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            WebTable.Row row = new WebTable.Row(new WebTable.Cell(MESSAGES.rowRequestedCredit(), 2, null), new WebTable.Cell(""), credit, new WebTable.Cell(""), new WebTable.NoteCell((String)note, (String)noteTitle), icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, (String)iconText, status), new WebTable.Cell(""), new WebTable.Cell(""));
            for (WebTable.Cell cell : row.getCells()) {
                cell.setStyleName("top-border-solid");
            }
            row.getCell(0).setStyleName("top-border-solid text-bold");
            rows.add(row);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iRequests.setData(rowArray);
        this.iRequests.setColumnVisible(4, hasPref);
        this.iRequests.setColumnVisible(5, hasWarn);
        this.iRequests.setColumnVisible(7, hasCrit || hasImp || hasVital || hasLC || hasVisitF2F);
        if (!(!hasCrit || hasImp || hasVital || hasLC || hasVisitF2F)) {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.opSetCritical());
        } else if (!(hasCrit || !hasImp || hasVital || hasLC || hasVisitF2F)) {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.opSetImportant());
        } else if (!(hasCrit || hasImp || !hasVital || hasLC || hasVisitF2F)) {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.opSetVital());
        } else {
            this.iRequests.getTable().setHTML(0, 7, MESSAGES.colCritical());
        }
        this.iRequests.setColumnVisible(8, hasWait && (this.iDetails == null || this.iDetails.getWaitListMode() != OnlineSectioningInterface.WaitListMode.None));
        this.getRowFormatter().setVisible(this.iStudentRequestHeaderLine, this.iDetails != null && this.iDetails.hasStudentRequest());
        this.getRowFormatter().setVisible(this.iStudentRequestHeaderLine + 1, this.iDetails != null && this.iDetails.hasStudentRequest());
    }

    public void clearOtherSessionRecommendations() {
        for (int i = 0; i < this.iOtherSessionRecommendations; ++i) {
            this.iAdisorRequestsHeaderLine -= 2;
            this.removeRow(this.iAdisorRequestsHeaderLine);
            this.removeRow(this.iAdisorRequestsHeaderLine);
        }
        this.iOtherSessionRecommendations = 0;
    }

    public void fillInOtherSessionRecommendations() {
        this.clearOtherSessionRecommendations();
        if (this.iDetails != null && this.iDetails.hasOtherSessionRecommendations()) {
            TreeSet<String> campuses = new TreeSet<String>(this.iDetails.getOtherSessionRecommendations().keySet());
            for (String campus : campuses) {
                int hrow = this.insertRow(this.iAdisorRequestsHeaderLine);
                this.getFlexCellFormatter().setColSpan(hrow, 0, this.getColSpan());
                this.getFlexCellFormatter().setStyleName(hrow, 0, "unitime-MainTableHeader");
                this.getRowFormatter().setStyleName(hrow, "unitime-MainTableHeaderRow");
                UniTimeHeaderPanel header = new UniTimeHeaderPanel(MESSAGES.otherSessionRecommendations(campus));
                this.setWidget(hrow, 0, (Widget)header);
                final int trow = this.insertRow(this.iAdisorRequestsHeaderLine + 1);
                this.getFlexCellFormatter().setColSpan(trow, 0, this.getColSpan());
                AdvisorCourseRequestsTable acr = new AdvisorCourseRequestsTable();
                acr.setValue(this.iDetails.getOtherSessionRecommendations().get(campus));
                ScrollPanel sp = new ScrollPanel((Widget)acr);
                sp.addStyleName("other-session-recommendations");
                this.setWidget(trow, 0, (Widget)sp);
                if (SectioningStatusCookie.getInstance().isOtherSessionRecommendationsOpened()) {
                    header.setCollapsible(true);
                } else {
                    header.setCollapsible(false);
                    this.getRowFormatter().setVisible(trow, false);
                }
                header.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        AdvisorCourseRequestsPage.this.getRowFormatter().setVisible(trow, ((Boolean)event.getValue()).booleanValue());
                        SectioningStatusCookie.getInstance().setOtherSessionRecommendationsOpened((Boolean)event.getValue());
                    }
                });
                ++this.iOtherSessionRecommendations;
                this.iAdisorRequestsHeaderLine += 2;
            }
        }
    }

    public boolean isSendEmailConformation() {
        return this.iEmailConfirmationHeader.isVisible() && this.iEmailConfirmationHeader.getValue() != false;
    }

    private class AdvisorAcademicSessionSelector
    extends AcademicSessionSelector {
        public AdvisorAcademicSessionSelector() {
            super(UniTimePageHeader.getInstance().getRight(), StudentSectioningPage.Mode.REQUESTS);
        }

        @Override
        public void selectSession() {
            if (AdvisorCourseRequestsPage.this.isPageChanged()) {
                UniTimeConfirmationDialog.confirm(MESSAGES.queryLeaveAdvisorsCourseRequestsNotSave(), new Command(){

                    public void execute() {
                        AdvisorAcademicSessionSelector.this.selectSessionNoCheck();
                    }
                });
            } else {
                this.selectSessionNoCheck();
            }
        }

        @Override
        protected void listAcademicSessions(AsyncCallback<Collection<AcademicSessionProvider.AcademicSessionInfo>> callback) {
            sSectioningService.getStudentSessions(AdvisorCourseRequestsPage.this.iStudentExternalId.getText(), callback);
        }

        public void selectSessionNoCheck() {
            AdvisorCourseRequestsPage.this.header.setEnabled("submit", false);
            AdvisorCourseRequestsPage.this.header.setEnabled("print", false);
            AdvisorCourseRequestsPage.this.iDegreePlan.setVisible(false);
            AdvisorCourseRequestsPage.this.iDegreePlan.setEnabled(false);
            AdvisorCourseRequestsPage.this.iEmailConfirmationHeader.setVisible(false);
            AdvisorCourseRequestsPage.this.iEmailConfirmationFooter.setVisible(false);
            AdvisorCourseRequestsPage.this.hideLastNotes();
            super.selectSession();
        }
    }

    public static class AdvisorNotesTable
    extends UniTimeTable<OnlineSectioningInterface.AdvisorNote> {
        public AdvisorNotesTable() {
            ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
            for (Column col : Column.values()) {
                header.add(new UniTimeTableHeader(this.getColumnName(col)));
            }
            this.addRow(null, header);
        }

        public String getColumnName(Column column) {
            switch (column) {
                case COUNT: {
                    return MESSAGES.colAdvisorNotesCount();
                }
                case DATE: {
                    return MESSAGES.colAdvisorNotesTime();
                }
                case NOTE: {
                    return MESSAGES.colAdvisorNotesNote();
                }
            }
            return column.name();
        }

        public Widget getColumnWidget(Column column, OnlineSectioningInterface.AdvisorNote note) {
            switch (column) {
                case COUNT: {
                    return new UniTimeTable.NumberCell(note.getCount());
                }
                case DATE: {
                    return new Label(sTSF.format(note.getTimeStamp()));
                }
                case NOTE: {
                    Label label = new Label(note.getDisplayString());
                    label.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
                    return label;
                }
            }
            return null;
        }

        protected void addRow(OnlineSectioningInterface.AdvisorNote note) {
            ArrayList<Widget> line = new ArrayList<Widget>();
            for (Column col : Column.values()) {
                line.add(this.getColumnWidget(col, note));
            }
            this.addRow(note, line);
        }

        public void setData(List<OnlineSectioningInterface.AdvisorNote> notes) {
            this.clearTable(1);
            if (notes != null) {
                for (OnlineSectioningInterface.AdvisorNote note : notes) {
                    this.addRow(note);
                }
            }
        }

        public static enum Column {
            DATE,
            NOTE,
            COUNT;

        }
    }
}

