/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.unitime.timetable.gwt.client.aria.AriaDialogBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.page.InfoPanel;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;

public class AcademicSessionSelector
implements AcademicSessionProvider {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private InfoPanel iPanel;
    private AcademicSessionProvider.AcademicSessionInfo iSession = null;
    private DialogBox iDialog;
    private UniTimeTable<AcademicSessionProvider.AcademicSessionInfo> iSessions;
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private Vector<AcademicSessionProvider.AcademicSessionChangeHandler> iAcademicSessionChangeHandlers = new Vector();
    private StudentSectioningPage.Mode iMode;

    public AcademicSessionSelector(InfoPanel panel, StudentSectioningPage.Mode mode) {
        this.iMode = mode;
        this.iPanel = panel;
        this.iPanel.setPreventDefault(true);
        this.iPanel.setVisible(true);
        this.iPanel.setText(MESSAGES.sessionSelectorNoSession());
        this.iPanel.setHint(MESSAGES.sessionSelectorHint());
        this.iPanel.setAriaLabel(ARIA.sessionNoSession());
        this.iPanel.setInfo(null);
        this.iDialog = new MyDialogBox();
        this.iDialog.setText(MESSAGES.sessionSelectorSelect());
        this.iDialog.setAnimationEnabled(true);
        this.iDialog.setAutoHideEnabled(false);
        this.iDialog.setGlassEnabled(true);
        this.iDialog.setModal(true);
        this.iSessions = new UniTimeTable();
        this.iSessions.addRow(null, new Widget[]{new UniTimeTableHeader(MESSAGES.colYear()), new UniTimeTableHeader(MESSAGES.colTerm()), new UniTimeTableHeader(MESSAGES.colCampus())});
        this.iSessions.addRow(null, new Widget[]{new EmptyTableCell(MESSAGES.sessionSelectorLoading())});
        this.iSessions.setAllowSelection(true);
        this.iSessions.setWidth("100%");
        this.iDialog.add(this.iSessions);
        ClickHandler ch = new ClickHandler(){

            public void onClick(ClickEvent event) {
                AcademicSessionSelector.this.selectSession();
            }
        };
        this.iPanel.setClickHandler(ch);
        this.iSessions.addMouseClickListener(new UniTimeTable.MouseClickListener<AcademicSessionProvider.AcademicSessionInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<AcademicSessionProvider.AcademicSessionInfo> event) {
                if (event.getData() != null) {
                    AcademicSessionSelector.this.rowSelected(event.getRow(), event.getData());
                }
            }
        });
    }

    private void rowSelected(int row, AcademicSessionProvider.AcademicSessionInfo session) {
        this.iDialog.hide();
        this.iPanel.setText(MESSAGES.sessionSelectorLabel(session.getYear(), session.getTerm(), session.getCampus()));
        this.iPanel.setAriaLabel(ARIA.sessionCurrent(session.getYear(), session.getTerm(), session.getCampus()));
        this.selectSession(session, true);
        if (this.iSessions.getSelectedRow() >= 0) {
            this.iSessions.setSelected(this.iSessions.getSelectedRow(), false);
        }
        this.iSessions.setSelected(row, true);
        AriaStatus.getInstance().setText(ARIA.sessionSelectorDialogSelected(session.getYear(), session.getTerm(), session.getCampus()));
    }

    protected void listAcademicSessions(AsyncCallback<Collection<AcademicSessionProvider.AcademicSessionInfo>> callback) {
        this.iSectioningService.listAcademicSessions(this.iMode.isSectioning(), callback);
    }

    public void selectSession() {
        this.iDialog.setAutoHideEnabled(this.getAcademicSessionId() != null);
        this.listAcademicSessions(new AsyncCallback<Collection<AcademicSessionProvider.AcademicSessionInfo>>(){

            public void onSuccess(Collection<AcademicSessionProvider.AcademicSessionInfo> result) {
                AcademicSessionSelector.this.iSessions.clearTable(1);
                int row = 1;
                int lastSession = -1;
                for (AcademicSessionProvider.AcademicSessionInfo session : result) {
                    AcademicSessionSelector.this.iSessions.addRow(session, new Widget[]{new Label(session.getYear()), new Label(session.getTerm()), new Label(session.getCampus())});
                    if (session.equals(AcademicSessionSelector.this.iSession)) {
                        lastSession = row;
                    }
                    ++row;
                }
                if (result.size() == 1) {
                    AcademicSessionSelector.this.iSessions.setSelected(1, true);
                } else if (lastSession >= 0) {
                    AcademicSessionSelector.this.iSessions.setSelected(lastSession, true);
                }
                if (result.size() == 1) {
                    AcademicSessionSelector.this.rowSelected(1, AcademicSessionSelector.this.iSessions.getData(1));
                } else {
                    if (AcademicSessionSelector.this.iSessions.getSelectedRow() >= 0) {
                        AcademicSessionProvider.AcademicSessionInfo session = AcademicSessionSelector.this.iSessions.getData(AcademicSessionSelector.this.iSessions.getSelectedRow());
                        AriaStatus.getInstance().setText(ARIA.sessionSelectorDialogOpenedWithSelection(AcademicSessionSelector.this.iSessions.getSelectedRow(), result.size(), session.getYear(), session.getTerm(), session.getCampus()));
                    } else {
                        AriaStatus.getInstance().setText(ARIA.sessionSelectorDialogOpened());
                    }
                    AcademicSessionSelector.this.iDialog.center();
                }
            }

            public void onFailure(Throwable caught) {
                AriaStatus.getInstance().setText(caught.getMessage());
                AcademicSessionSelector.this.iSessions.clearTable(1);
                AcademicSessionSelector.this.iSessions.addRow(null, new Widget[]{new EmptyTableCell(caught.getMessage())});
                AcademicSessionSelector.this.iDialog.setAutoHideEnabled(true);
                AcademicSessionSelector.this.iDialog.center();
            }
        });
    }

    @Override
    public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
        this.selectSession(new AcademicSessionProvider.AcademicSessionMatchSessionId(sessionId), callback);
    }

    public void selectSession(final AcademicSessionProvider.AcademicSessionMatcher matcher, final AsyncCallback<Boolean> callback) {
        if (matcher == null) {
            this.selectSession();
            callback.onSuccess((Object)false);
        } else if (this.iSession != null && matcher.match(this.iSession)) {
            callback.onSuccess((Object)true);
        } else {
            this.listAcademicSessions(new AsyncCallback<Collection<AcademicSessionProvider.AcademicSessionInfo>>(){

                public void onSuccess(Collection<AcademicSessionProvider.AcademicSessionInfo> result) {
                    ArrayList<AcademicSessionProvider.AcademicSessionInfo> match = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
                    for (AcademicSessionProvider.AcademicSessionInfo session : result) {
                        if (!matcher.match(session)) continue;
                        match.add(session);
                    }
                    if (match.size() == 1) {
                        AcademicSessionSelector.this.selectSession((AcademicSessionProvider.AcademicSessionInfo)match.get(0), false);
                        callback.onSuccess((Object)true);
                    } else {
                        AcademicSessionSelector.this.selectSession();
                        callback.onSuccess((Object)false);
                    }
                }

                public void onFailure(Throwable caught) {
                    AcademicSessionSelector.this.iSessions.clearTable(1);
                    AcademicSessionSelector.this.iSessions.addRow(null, new Widget[]{new EmptyTableCell(caught.getMessage())});
                    AcademicSessionSelector.this.iDialog.center();
                    callback.onSuccess((Object)false);
                }
            });
        }
    }

    public void selectSession(AcademicSessionProvider.AcademicSessionInfo session, boolean fireChangeEvent) {
        Long oldSessionId = this.iSession == null ? null : this.iSession.getSessionId();
        this.iSession = session;
        if (this.iSession == null) {
            this.iPanel.setText(MESSAGES.sessionSelectorNoSession());
            this.iPanel.setAriaLabel(ARIA.sessionNoSession());
        } else {
            this.iPanel.setText(MESSAGES.sessionSelectorLabel(this.iSession.getYear(), this.iSession.getTerm(), this.iSession.getCampus()));
            this.iPanel.setAriaLabel(ARIA.sessionCurrent(this.iSession.getYear(), this.iSession.getTerm(), this.iSession.getCampus()));
            if (fireChangeEvent || !this.iSession.getSessionId().equals(oldSessionId)) {
                AcademicSessionChangeEvent changeEvent = new AcademicSessionChangeEvent(oldSessionId, this.iSession.getSessionId());
                for (AcademicSessionProvider.AcademicSessionChangeHandler handler : this.iAcademicSessionChangeHandlers) {
                    handler.onAcademicSessionChange(changeEvent);
                }
            }
        }
    }

    @Override
    public Long getAcademicSessionId() {
        return this.iSession == null ? null : this.iSession.getSessionId();
    }

    @Override
    public String getAcademicSessionName() {
        return this.iSession == null ? null : this.iSession.getName();
    }

    @Override
    public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
        return this.iSession;
    }

    @Override
    public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
        this.iAcademicSessionChangeHandlers.add(handler);
    }

    private class MyDialogBox
    extends AriaDialogBox {
        private MyDialogBox() {
        }

        protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
            super.onPreviewNativeEvent(event);
            if (DOM.eventGetType((Event)((Event)event.getNativeEvent())) == 512) {
                if (event.getNativeEvent().getKeyCode() == 40) {
                    int row = AcademicSessionSelector.this.iSessions.getSelectedRow();
                    if (row >= 0) {
                        AcademicSessionSelector.this.iSessions.setSelected(row, false);
                    }
                    if (row < 0) {
                        row = 1;
                    } else if (++row >= AcademicSessionSelector.this.iSessions.getRowCount()) {
                        row = 1;
                    }
                    AcademicSessionProvider.AcademicSessionInfo session = AcademicSessionSelector.this.iSessions.getData(row);
                    if (session != null) {
                        AriaStatus.getInstance().setText(ARIA.sessionSelectorShowingSession(row, AcademicSessionSelector.this.iSessions.getRowCount() - 1, session.getYear(), session.getTerm(), session.getCampus()));
                    }
                    AcademicSessionSelector.this.iSessions.setSelected(row, true);
                } else if (event.getNativeEvent().getKeyCode() == 38) {
                    int row = AcademicSessionSelector.this.iSessions.getSelectedRow();
                    if (row >= 0) {
                        AcademicSessionSelector.this.iSessions.setSelected(row, false);
                    }
                    if (row < 0) {
                        row = AcademicSessionSelector.this.iSessions.getRowCount() - 1;
                    } else if (--row <= 0) {
                        row = AcademicSessionSelector.this.iSessions.getRowCount() - 1;
                    }
                    AcademicSessionProvider.AcademicSessionInfo session = AcademicSessionSelector.this.iSessions.getData(row);
                    if (session != null) {
                        AriaStatus.getInstance().setText(ARIA.sessionSelectorShowingSession(row, AcademicSessionSelector.this.iSessions.getRowCount() - 1, session.getYear(), session.getTerm(), session.getCampus()));
                    }
                    AcademicSessionSelector.this.iSessions.setSelected(row, true);
                } else if (event.getNativeEvent().getKeyCode() == 13 && AcademicSessionSelector.this.iSessions.getSelectedRow() >= 0) {
                    int row = AcademicSessionSelector.this.iSessions.getSelectedRow();
                    if (row >= 0 && AcademicSessionSelector.this.iSessions.getData(row) != null) {
                        AcademicSessionSelector.this.rowSelected(row, AcademicSessionSelector.this.iSessions.getData(row));
                    }
                } else if (event.getNativeEvent().getKeyCode() == 27 && AcademicSessionSelector.this.getAcademicSessionId() != null) {
                    AcademicSessionSelector.this.iDialog.hide();
                }
            }
        }
    }

    private class EmptyTableCell
    extends Label
    implements UniTimeTable.HasColSpan {
        EmptyTableCell(String text) {
            super(text, false);
            this.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
        }

        @Override
        public int getColSpan() {
            return 3;
        }
    }

    public static class AcademicSessionChangeEvent
    implements AcademicSessionProvider.AcademicSessionChangeEvent {
        private Long iSessionId;
        private Long iOldSessionId;

        private AcademicSessionChangeEvent(Long oldSessionId, Long sessionId) {
            this.iOldSessionId = oldSessionId;
            this.iSessionId = sessionId;
        }

        @Override
        public Long getOldAcademicSessionId() {
            return this.iOldSessionId;
        }

        @Override
        public Long getNewAcademicSessionId() {
            return this.iSessionId;
        }

        @Override
        public boolean isChanged() {
            return this.iSessionId == null ? this.iOldSessionId != null : !this.iSessionId.equals(this.iOldSessionId);
        }
    }
}

