/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.LastChangesInterface;

public class RoomNoteChanges
extends Composite
implements SimpleForm.HasMobileScroll {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static DateTimeFormat sDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private Long iLocationId = null;
    private SimpleForm iChangesPanel = new SimpleForm();
    private UniTimeTable<LastChangesInterface.ChangeLogInterface> iChanges;
    private UniTimeHeaderPanel iHeader;
    private CheckBox iMultiSessionToggle;

    public RoomNoteChanges() {
        this.iChangesPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectRoomNoteHistory());
        this.iHeader.setCollapsible(LastChangesCookie.getInstance().getShowLastChanges());
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                LastChangesCookie.getInstance().setShowLastChanges((Boolean)event.getValue());
                if (RoomNoteChanges.this.iChanges.getRowCount() == 0) {
                    RoomNoteChanges.this.refresh();
                } else if (RoomNoteChanges.this.iChanges.getRowCount() > 1) {
                    for (int row = 1; row < RoomNoteChanges.this.iChanges.getRowCount(); ++row) {
                        RoomNoteChanges.this.iChanges.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
                RoomNoteChanges.this.iMultiSessionToggle.setVisible(((Boolean)event.getValue()).booleanValue());
            }
        });
        this.iChangesPanel.addHeaderRow((Widget)this.iHeader);
        this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.iChanges = new UniTimeTable();
        this.iChanges.setWidth("100%");
        this.iChangesPanel.addRow((Widget)this.iChanges);
        this.iMultiSessionToggle = new CheckBox(MESSAGES.checkAllSessions());
        this.iMultiSessionToggle.setValue(Boolean.valueOf(LastChangesCookie.getInstance().isMultiSession()));
        this.iMultiSessionToggle.getElement().getStyle().setFloat(Style.Float.RIGHT);
        this.iChangesPanel.addRow((Widget)this.iMultiSessionToggle);
        this.iMultiSessionToggle.setVisible(this.iHeader.isCollapsible().booleanValue());
        this.iMultiSessionToggle.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                LastChangesCookie.getInstance().setMultiSession((Boolean)event.getValue());
                RoomNoteChanges.this.refresh();
            }
        });
        this.initWidget((Widget)this.iChangesPanel);
    }

    private void refresh() {
        this.clear(true);
        if (this.iLocationId != null) {
            RPC.execute(LastChangesInterface.LastChangesRequest.createRequest("org.unitime.timetable.model.Location", this.iLocationId, "multi-session", this.iMultiSessionToggle.getValue() != false ? "true" : "false", "page", "ROOM_EDIT", "operation", "NOTE"), new AsyncCallback<GwtRpcResponseList<LastChangesInterface.ChangeLogInterface>>(){

                public void onFailure(Throwable caught) {
                    RoomNoteChanges.this.iHeader.setErrorMessage(MESSAGES.failedLoadRoomNoteChanges(caught.getMessage()));
                    RoomNoteChanges.this.iHeader.setCollapsible(null);
                    LastChangesCookie.getInstance().setShowLastChanges(false);
                }

                public void onSuccess(GwtRpcResponseList<LastChangesInterface.ChangeLogInterface> result) {
                    if (result.isEmpty()) {
                        RoomNoteChanges.this.iHeader.setMessage(MESSAGES.noRoomNoteChanges());
                    } else {
                        RoomNoteChanges.this.populate(result);
                        if (RoomNoteChanges.this.iChanges.getRowCount() > 1) {
                            for (int row = 1; row < RoomNoteChanges.this.iChanges.getRowCount(); ++row) {
                                RoomNoteChanges.this.iChanges.getRowFormatter().setVisible(row, LastChangesCookie.getInstance().getShowLastChanges());
                            }
                        }
                        RoomNoteChanges.this.iHeader.clearMessage();
                    }
                }
            });
        }
    }

    private void clear(boolean loading) {
        for (int row = this.iChanges.getRowCount() - 1; row >= 0; --row) {
            this.iChanges.removeRow(row);
        }
        this.iChanges.clear(true);
        if (loading) {
            this.iHeader.showLoading();
        } else {
            this.iHeader.clearMessage();
        }
    }

    private Comparator<LastChangesInterface.ChangeLogInterface> comparator(int column, final boolean order) {
        switch (column) {
            case 0: {
                return new Comparator<LastChangesInterface.ChangeLogInterface>(){

                    @Override
                    public int compare(LastChangesInterface.ChangeLogInterface c1, LastChangesInterface.ChangeLogInterface c2) {
                        return (order ? -1 : 1) * c1.getDate().compareTo(c2.getDate());
                    }
                };
            }
            case 1: {
                return new Comparator<LastChangesInterface.ChangeLogInterface>(){

                    @Override
                    public int compare(LastChangesInterface.ChangeLogInterface c1, LastChangesInterface.ChangeLogInterface c2) {
                        int cmp = c1.getSessionDate().compareTo(c2.getSessionDate());
                        if (cmp != 0) {
                            return order ? -cmp : cmp;
                        }
                        cmp = c1.getSessionInitiative().compareTo(c2.getSessionInitiative());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        cmp = c1.getSession().compareTo(c2.getSession());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        return (order ? -1 : 1) * c1.getDate().compareTo(c2.getDate());
                    }
                };
            }
            case 2: {
                return new Comparator<LastChangesInterface.ChangeLogInterface>(){

                    @Override
                    public int compare(LastChangesInterface.ChangeLogInterface c1, LastChangesInterface.ChangeLogInterface c2) {
                        int cmp = (c1.getManager() == null ? "" : c1.getManager()).compareTo(c2.getManager() == null ? "" : c2.getManager());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        cmp = c1.getSessionDate().compareTo(c2.getSessionDate());
                        if (cmp != 0) {
                            return order ? -cmp : cmp;
                        }
                        cmp = c1.getSessionInitiative().compareTo(c2.getSessionInitiative());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        cmp = c1.getSession().compareTo(c2.getSession());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        return (order ? -1 : 1) * c1.getDate().compareTo(c2.getDate());
                    }
                };
            }
            case 3: {
                return new Comparator<LastChangesInterface.ChangeLogInterface>(){

                    @Override
                    public int compare(LastChangesInterface.ChangeLogInterface c1, LastChangesInterface.ChangeLogInterface c2) {
                        int cmp = new HTML(c1.getObject() == null ? "" : c1.getObject()).getText().compareTo(new HTML(c2.getObject() == null ? "" : c2.getObject()).getText());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        cmp = c1.getSessionDate().compareTo(c2.getSessionDate());
                        if (cmp != 0) {
                            return order ? -cmp : cmp;
                        }
                        cmp = c1.getSessionInitiative().compareTo(c2.getSessionInitiative());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        cmp = c1.getSession().compareTo(c2.getSession());
                        if (cmp != 0) {
                            return order ? cmp : -cmp;
                        }
                        return (order ? -1 : 1) * c1.getDate().compareTo(c2.getDate());
                    }
                };
            }
        }
        return new Comparator<LastChangesInterface.ChangeLogInterface>(){

            @Override
            public int compare(LastChangesInterface.ChangeLogInterface c1, LastChangesInterface.ChangeLogInterface c2) {
                return (order ? -1 : 1) * c1.getDate().compareTo(c2.getDate());
            }
        };
    }

    private ClickHandler clickHandler(final int column) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeTableHeader header = (UniTimeTableHeader)event.getSource();
                boolean order = header.getOrder() == null ? true : header.getOrder() == false;
                RoomNoteChanges.this.iChanges.sort(header, RoomNoteChanges.this.comparator(column, order));
                LastChangesCookie.getInstance().setSort(column, order);
                header.setOrder(order);
            }
        };
    }

    private void populate(GwtRpcResponseList<LastChangesInterface.ChangeLogInterface> logs) {
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(MESSAGES.colDate(), this.clickHandler(0)));
        header.add(new UniTimeTableHeader(MESSAGES.colAcademicSession(), this.clickHandler(1)));
        header.add(new UniTimeTableHeader(MESSAGES.colManager(), this.clickHandler(2)));
        header.add(new UniTimeTableHeader(MESSAGES.colNote(), this.clickHandler(3)));
        this.iChanges.addRow(null, header);
        for (LastChangesInterface.ChangeLogInterface log : logs) {
            ArrayList<Object> line = new ArrayList<Object>();
            line.add(new Label(sDateFormat.format(log.getDate()), false));
            line.add(new Label(log.getSession(), false));
            line.add(new HTML((String)(log.getManager() == null ? "<i>" + MESSAGES.notApplicable() + "</i>" : log.getManager()), false));
            HTML note = new HTML((String)(log.getObject() == null || log.getObject().isEmpty() || "-".equals(log.getObject()) ? "<i>" + MESSAGES.emptyNote() + "</i>" : log.getObject()));
            note.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
            line.add(note);
            this.iChanges.addRow(log, line);
            this.iChanges.getRowFormatter().setVerticalAlign(this.iChanges.getRowCount() - 1, HasVerticalAlignment.ALIGN_TOP);
        }
        if (LastChangesCookie.getInstance().getSortColumn() >= 0) {
            this.iChanges.sort((UniTimeTableHeader)null, this.comparator(LastChangesCookie.getInstance().getSortColumn(), LastChangesCookie.getInstance().getSortOrder()));
            ((UniTimeTableHeader)header.get(LastChangesCookie.getInstance().getSortColumn())).setOrder(LastChangesCookie.getInstance().getSortOrder());
        }
        this.iChanges.setColumnVisible(1, this.iMultiSessionToggle.getValue());
    }

    public void insert(RootPanel panel) {
        this.load(Long.valueOf(panel.getElement().getInnerText()));
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
    }

    public void load(Long locationId) {
        this.iLocationId = locationId;
        if (LastChangesCookie.getInstance().getShowLastChanges()) {
            this.refresh();
        } else {
            this.clear(false);
            this.iHeader.clearMessage();
            this.iHeader.setCollapsible(false);
        }
    }

    public static class LastChangesCookie {
        private boolean iShowDetails = false;
        private int iSortColumn = -1;
        private boolean iSortOrder = true;
        private boolean iMultiSession = false;
        private static LastChangesCookie sInstance = null;

        private LastChangesCookie() {
            try {
                String cookie = ToolBox.getSessionCookie("UniTime:LastChanges");
                if (cookie != null && cookie.length() > 0) {
                    String[] values = cookie.split(":");
                    this.iShowDetails = "T".equals(values[0]);
                    this.iSortColumn = Integer.parseInt(values[1]);
                    this.iSortOrder = "T".equals(values[2]);
                    this.iMultiSession = "T".equals(values[3]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void save() {
            String cookie = (this.iShowDetails ? "T" : "F") + ":" + this.iSortColumn + ":" + (this.iSortOrder ? "T" : "F") + ":" + (this.iMultiSession ? "T" : "F");
            ToolBox.setSessionCookie("UniTime:LastChanges", cookie);
        }

        public static LastChangesCookie getInstance() {
            if (sInstance == null) {
                sInstance = new LastChangesCookie();
            }
            return sInstance;
        }

        public boolean getShowLastChanges() {
            return this.iShowDetails;
        }

        public void setShowLastChanges(boolean details) {
            this.iShowDetails = details;
            this.save();
        }

        public int getSortColumn() {
            return this.iSortColumn;
        }

        public boolean getSortOrder() {
            return this.iSortOrder;
        }

        public void setSort(int column, boolean order) {
            this.iSortColumn = column;
            this.iSortOrder = order;
            this.save();
        }

        public boolean isMultiSession() {
            return this.iMultiSession;
        }

        public void setMultiSession(boolean multi) {
            this.iMultiSession = multi;
            this.save();
        }
    }
}

