/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import java.util.HashMap;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomCookie {
    private static RoomCookie sInstance = null;
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private int[] iFlags = null;
    private String[] iHash = null;
    private int iSortRoomsBy = RoomInterface.RoomsColumn.TYPE.ordinal() + 1;
    private int iDeptMode = 1;
    private Boolean iGridAsText = null;
    private Boolean iHorizontal = null;
    private String iMode = "";
    private Map<Long, Integer> iFutures = new HashMap<Long, Integer>();
    private int iSortRoomGroupsBy = 0;
    private int iSortRoomFeaturesBy = 0;

    private RoomCookie() {
        this.iFlags = new int[RoomInterface.RoomsPageMode.values().length];
        this.iHash = new String[RoomInterface.RoomsPageMode.values().length];
        for (int i = 0; i < this.iFlags.length; ++i) {
            this.iFlags[i] = 0;
            this.iHash[i] = "";
        }
        try {
            String cookie = ToolBox.getCookie("UniTime:Room");
            if (cookie != null) {
                String[] params = cookie.split("\\|");
                int idx = 0;
                this.iSortRoomsBy = Integer.valueOf(params[idx++]);
                this.iSortRoomGroupsBy = Integer.valueOf(params[idx++]);
                this.iSortRoomFeaturesBy = Integer.valueOf(params[idx++]);
                this.setOrientation(params[idx++]);
                this.iDeptMode = Integer.valueOf(params[idx++]);
                for (int i = 0; i < this.iFlags.length; ++i) {
                    this.iFlags[i] = Integer.parseInt(params[idx++]);
                    this.iHash[i] = params[idx++];
                }
                while (idx < params.length) {
                    String[] x = params[idx++].split(":");
                    this.iFutures.put(Long.valueOf(x[0]), Integer.valueOf(x[1]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        String cookie = this.iSortRoomsBy + "|" + this.iSortRoomGroupsBy + "|" + this.iSortRoomFeaturesBy + "|" + this.getOrientation() + "|" + this.iDeptMode;
        for (int i = 0; i < this.iFlags.length; ++i) {
            cookie = cookie + "|" + this.iFlags[i] + "|" + (this.iHash[i] == null ? "" : this.iHash[i]);
        }
        for (Map.Entry<Long, Integer> e : this.iFutures.entrySet()) {
            cookie = cookie + "|" + e.getKey() + ":" + e.getValue();
        }
        ToolBox.setCookie("UniTime:Room", cookie);
    }

    private void setOrientation(String parameter) {
        if (parameter == null || parameter.isEmpty()) {
            this.iGridAsText = null;
            this.iHorizontal = null;
            this.iMode = "";
        } else {
            switch (parameter.charAt(0)) {
                case 'a': {
                    this.iHorizontal = null;
                    this.iGridAsText = true;
                    break;
                }
                case 'h': {
                    this.iHorizontal = true;
                    this.iGridAsText = true;
                    break;
                }
                case 'v': {
                    this.iHorizontal = false;
                    this.iGridAsText = true;
                    break;
                }
                case 'A': {
                    this.iHorizontal = null;
                    this.iGridAsText = false;
                    break;
                }
                case 'H': {
                    this.iHorizontal = true;
                    this.iGridAsText = false;
                    break;
                }
                case 'V': {
                    this.iHorizontal = false;
                    this.iGridAsText = false;
                    break;
                }
                case 'b': {
                    this.iHorizontal = true;
                    this.iGridAsText = null;
                    break;
                }
                case 'B': {
                    this.iHorizontal = false;
                    this.iGridAsText = null;
                    break;
                }
                default: {
                    this.iHorizontal = null;
                    this.iGridAsText = null;
                }
            }
            this.iMode = parameter.substring(1);
        }
    }

    private String getOrientation() {
        char orientation = 'X';
        orientation = this.iGridAsText == null ? (this.iHorizontal == null ? (char)'X' : (this.iHorizontal != false ? (char)'b' : 'B')) : (this.iGridAsText != false ? (this.iHorizontal == null ? (char)'a' : (this.iHorizontal != false ? (char)'h' : 'v')) : (this.iHorizontal == null ? (char)'A' : (this.iHorizontal != false ? (char)'H' : 'V')));
        return orientation + (this.iMode == null ? "" : this.iMode);
    }

    public static RoomCookie getInstance() {
        if (sInstance == null) {
            sInstance = new RoomCookie();
        }
        return sInstance;
    }

    public boolean get(RoomInterface.RoomsPageMode mode, int colIndex) {
        int flag = 1 << colIndex;
        return (this.iFlags[mode.ordinal()] & flag) != 0;
    }

    public void set(RoomInterface.RoomsPageMode mode, int colIndex, boolean value) {
        boolean in;
        int flag = 1 << colIndex;
        boolean bl = in = (this.iFlags[mode.ordinal()] & flag) != 0;
        if (value && !in) {
            int n = mode.ordinal();
            this.iFlags[n] = this.iFlags[n] + flag;
        }
        if (!value && in) {
            int n = mode.ordinal();
            this.iFlags[n] = this.iFlags[n] - flag;
        }
        this.save();
    }

    public int getFlags(RoomInterface.RoomsPageMode mode) {
        return this.iFlags[mode.ordinal()];
    }

    public void setFlags(RoomInterface.RoomsPageMode mode, int flags) {
        this.iFlags[mode.ordinal()] = flags;
        this.save();
    }

    public boolean hasHash(RoomInterface.RoomsPageMode mode) {
        return this.iHash[mode.ordinal()] != null && !this.iHash[mode.ordinal()].isEmpty();
    }

    public String getHash(RoomInterface.RoomsPageMode mode) {
        return this.iHash[mode.ordinal()];
    }

    public void setHash(RoomInterface.RoomsPageMode mode, String hash) {
        this.iHash[mode.ordinal()] = hash;
        this.save();
    }

    public int getRoomsSortBy() {
        return this.iSortRoomsBy;
    }

    public void setSortRoomsBy(int sortRoomsBy) {
        this.iSortRoomsBy = sortRoomsBy;
        this.save();
    }

    public boolean areRoomsHorizontal() {
        return this.iHorizontal == null ? false : this.iHorizontal;
    }

    public boolean isGridAsText() {
        return this.iGridAsText == null ? false : this.iGridAsText;
    }

    public boolean hasOrientation() {
        return this.iHorizontal != null && this.iGridAsText != null;
    }

    public void setOrientation(boolean gridAsText, boolean horizontal) {
        this.iGridAsText = gridAsText;
        this.iHorizontal = horizontal;
        this.save();
    }

    public void setHorizontal(boolean horizontal) {
        this.iHorizontal = horizontal;
        this.save();
    }

    public String getMode() {
        return this.iMode;
    }

    public boolean hasMode() {
        return this.iMode != null && !this.iMode.isEmpty();
    }

    public void setMode(boolean horizontal, String mode) {
        this.iMode = mode;
        this.iHorizontal = horizontal;
        this.save();
    }

    public int getDeptMode() {
        return this.iDeptMode;
    }

    public void setDeptMode(int deptMode) {
        this.iDeptMode = deptMode;
        this.save();
    }

    public Integer getFutureFlags(Long sessionId) {
        return this.iFutures.get(sessionId);
    }

    public void setFutureFlags(Long sessionId, Integer flags) {
        if (flags == null) {
            this.iFutures.remove(sessionId);
        } else {
            this.iFutures.put(sessionId, flags);
        }
        this.save();
    }

    public int getRoomGroupsSortBy() {
        return this.iSortRoomGroupsBy;
    }

    public void setSortRoomGroupsBy(int sortRoomGroupsBy) {
        this.iSortRoomGroupsBy = sortRoomGroupsBy;
        this.save();
    }

    public int getRoomFeaturesSortBy() {
        return this.iSortRoomFeaturesBy;
    }

    public void setSortRoomFeaturesBy(int sortRoomFeaturesBy) {
        this.iSortRoomFeaturesBy = sortRoomFeaturesBy;
        this.save();
    }
}

