/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.MapWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class LeafletMap
extends MapWidget {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private String iTileUrl;
    private String iTileAttribution;
    private AbsolutePanel iMap;
    private TextBox iMapSearchBox;

    public LeafletMap(TextBox x, TextBox y, String tileUrl, String tileAttribution) {
        super(x, y);
        this.setStyleName("unitime-LeafletMap");
        this.iTileUrl = tileUrl;
        this.iTileAttribution = tileAttribution;
        this.iMap = new AbsolutePanel();
        this.iMap.getElement().setId("map");
        this.add((Widget)this.iMap);
        this.iMapControl = new AbsolutePanel();
        this.iMapControl.setStyleName("control");
        this.iMapControl.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
        this.iMapSearchBox = new TextBox();
        this.iMapSearchBox.setStyleName("unitime-TextBox");
        this.iMapSearchBox.addStyleName("searchBox");
        this.iMapSearchBox.setTabIndex(-1);
        this.iMapControl.add((Widget)this.iMapSearchBox);
        this.add((Widget)this.iMapControl);
        Button button = new Button(MESSAGES.buttonGeocode(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                LeafletMap.this.leafletGeocodeAddress();
            }
        });
        button.setTabIndex(-1);
        this.iMapSearchBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                switch (event.getNativeEvent().getKeyCode()) {
                    case 13: {
                        event.preventDefault();
                        LeafletMap.this.leafletGeocodeAddress();
                        return;
                    }
                }
            }
        });
        button.addStyleName("geocode");
        ToolBox.setWhiteSpace(button.getElement().getStyle(), "nowrap");
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonGeocode());
        if (accessKey != null) {
            button.setAccessKey(accessKey.charValue());
        }
        this.iMapControl.add((Widget)button);
    }

    @Override
    public void setup() {
        LeafletMap.loadCss(GWT.getHostPageBaseURL() + "leaflet/leaflet.css");
        ScriptInjector.fromUrl((String)(GWT.getHostPageBaseURL() + "leaflet/leaflet.js")).setWindow(ScriptInjector.TOP_WINDOW).setCallback((Callback)new Callback<Void, Exception>(){

            public void onSuccess(Void result) {
                LeafletMap.this.setupLeafletMap(LeafletMap.this.iTileUrl, LeafletMap.this.iTileAttribution);
                LeafletMap.this.setLeafletMarker();
                LeafletMap.this.leafletReverseGeocode();
            }

            public void onFailure(Exception e) {
                UniTimeNotifications.error(e.getMessage(), e);
                LeafletMap.this.setVisible(false);
                LeafletMap.this.iMapControl = null;
            }
        }).inject();
    }

    protected native void setupLeafletMap(String var1, String var2);

    protected native void setLeafletMarker();

    protected native String getLeafletViewBox();

    public void leafletGeocodeAddress() {
        RPC.execute(new RoomInterface.GeocodeRequest(this.iMapSearchBox.getText(), this.getLeafletViewBox()), new AsyncCallback<RoomInterface.GeocodeResponse>(){

            public void onFailure(Throwable caught) {
                LeafletMap.this.iX.setText("");
                LeafletMap.this.iY.setText("");
                LeafletMap.this.setLeafletMarker();
            }

            public void onSuccess(RoomInterface.GeocodeResponse result) {
                LeafletMap.this.iX.setValue((Object)String.valueOf(result.getLat()));
                LeafletMap.this.iY.setValue((Object)String.valueOf(result.getLon()));
                LeafletMap.this.setLeafletMarker();
            }
        });
    }

    public void leafletReverseGeocode() {
        if (!this.iX.getValue().isEmpty() && !this.iY.getValue().isEmpty()) {
            try {
                RPC.execute(new RoomInterface.GeocodeRequest(Double.valueOf(this.iX.getValue()), Double.valueOf(this.iY.getValue())), new AsyncCallback<RoomInterface.GeocodeResponse>(){

                    public void onFailure(Throwable caught) {
                        LeafletMap.this.iMapSearchBox.setText("");
                    }

                    public void onSuccess(RoomInterface.GeocodeResponse result) {
                        LeafletMap.this.iMapSearchBox.setText(result.hasQuery() ? result.getQuery() : "");
                    }
                });
            }
            catch (NumberFormatException e) {
                this.iMapSearchBox.setText("");
            }
        } else {
            this.iMapSearchBox.setText("");
        }
    }

    public static void loadCss(String url) {
        LinkElement link = Document.get().createLinkElement();
        link.setRel("stylesheet");
        link.setHref(url);
        LeafletMap.nativeAttachToHead((JavaScriptObject)link);
    }

    protected static native void nativeAttachToHead(JavaScriptObject var0);

    @Override
    public void setMarker() {
        this.setLeafletMarker();
        this.leafletReverseGeocode();
    }
}

