/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.BuildingsEdit;
import org.unitime.timetable.gwt.client.rooms.BuildingsTable;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class BuildingsPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iPanel = new SimplePanel();
    private SimpleForm iListBuildingsForm = new SimpleForm();
    private UniTimeHeaderPanel iListBuildingsHeader = new UniTimeHeaderPanel(MESSAGES.sectBuildings());
    private UniTimeHeaderPanel iListBuildingsFooter;
    private BuildingsTable iBuildingsTable;
    private BuildingsEdit iBuildingsEdit;

    public BuildingsPage() {
        this.iListBuildingsHeader.addButton("add", MESSAGES.buttonAddBuilding(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                BuildingsPage.this.addBuilding();
            }
        });
        this.iListBuildingsHeader.setEnabled("add", false);
        this.iListBuildingsHeader.addButton("export", MESSAGES.buttonExportPDF(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?output=buildings.pdf&sort=" + BuildingsPage.this.iBuildingsTable.getSortBy());
            }
        });
        this.iListBuildingsHeader.setEnabled("export", false);
        this.iListBuildingsHeader.addButton("updateData", MESSAGES.buttonBuildingsUpdateData(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomInterface.UpdateBuildingRequest request = new RoomInterface.UpdateBuildingRequest();
                request.setAction(RoomInterface.UpdateBuildingAction.UPDATE_DATA);
                LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                RPC.execute(request, new AsyncCallback<RoomInterface.BuildingInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        BuildingsPage.this.iListBuildingsHeader.setErrorMessage(MESSAGES.failedBuildingUpdateData(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedBuildingUpdateData(caught.getMessage()), caught);
                    }

                    public void onSuccess(RoomInterface.BuildingInterface result) {
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        });
        this.iListBuildingsHeader.setEnabled("updateData", false);
        this.iListBuildingsForm.addHeaderRow((Widget)this.iListBuildingsHeader);
        this.iBuildingsTable = new BuildingsTable();
        this.iListBuildingsForm.addRow((Widget)this.iBuildingsTable);
        this.iBuildingsTable.setAllowSelection(true);
        this.iBuildingsTable.setAllowMultiSelect(false);
        this.iListBuildingsFooter = this.iListBuildingsHeader.clonePanel("");
        this.iListBuildingsForm.addBottomRow((Widget)this.iListBuildingsFooter);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        RPC.execute(new RoomInterface.GetBuildingsRequest(), new AsyncCallback<RoomInterface.BuildingsDataResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
                BuildingsPage.this.iListBuildingsHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(RoomInterface.BuildingsDataResponse result) {
                BuildingsPage.this.iListBuildingsHeader.setEnabled("add", result.isCanAdd());
                BuildingsPage.this.iListBuildingsHeader.setEnabled("export", result.isCanExportPDF());
                BuildingsPage.this.iListBuildingsHeader.setEnabled("updateData", result.isCanUpdateData());
                BuildingsPage.this.iBuildingsTable.setData(result.getBuildings());
                LoadingWidget.getInstance().hide();
                if (result.getEllipsoid() != null) {
                    BuildingsPage.this.iBuildingsEdit.setCoordinatesFormat(result.getEllipsoid());
                }
            }
        });
        this.iBuildingsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.BuildingInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.BuildingInterface> event) {
                if (event.getData() != null && event.getData().isCanEdit()) {
                    BuildingsPage.this.iBuildingsTable.setSelected(event.getRow(), true);
                    BuildingsPage.this.editBuilding(event.getData());
                }
            }
        });
        this.iBuildingsEdit = new BuildingsEdit(){

            @Override
            protected void onBack(boolean refresh, final Long buildingId) {
                BuildingsPage.this.iPanel.setWidget((Widget)BuildingsPage.this.iListBuildingsForm);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageBuildings());
                if (refresh) {
                    LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
                    RPC.execute(new RoomInterface.GetBuildingsRequest(), new AsyncCallback<RoomInterface.BuildingsDataResponse>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(BuildingsEdit.MESSAGES.failedLoadData(caught.getMessage()), caught);
                            BuildingsPage.this.iListBuildingsHeader.setErrorMessage(BuildingsEdit.MESSAGES.failedLoadData(caught.getMessage()));
                            ToolBox.checkAccess(caught);
                        }

                        public void onSuccess(RoomInterface.BuildingsDataResponse result) {
                            BuildingsPage.this.iListBuildingsHeader.setEnabled("add", result.isCanAdd());
                            BuildingsPage.this.iListBuildingsHeader.setEnabled("export", result.isCanExportPDF());
                            BuildingsPage.this.iListBuildingsHeader.setEnabled("updateData", result.isCanUpdateData());
                            BuildingsPage.this.iBuildingsTable.setData(result.getBuildings());
                            LoadingWidget.getInstance().hide();
                            if (result.getEllipsoid() != null) {
                                BuildingsPage.this.iBuildingsEdit.setCoordinatesFormat(result.getEllipsoid());
                            }
                            if (buildingId != null) {
                                for (int i = 0; i < BuildingsPage.this.iBuildingsTable.getRowCount(); ++i) {
                                    RoomInterface.BuildingInterface b = (RoomInterface.BuildingInterface)BuildingsPage.this.iBuildingsTable.getData(i);
                                    if (b == null || !b.getId().equals(buildingId)) continue;
                                    BuildingsPage.this.iBuildingsTable.getRowFormatter().getElement(i).scrollIntoView();
                                    BuildingsPage.this.iBuildingsTable.setSelected(i, true);
                                    break;
                                }
                            }
                        }
                    });
                } else {
                    if (BuildingsPage.this.iBuildingsTable.getSelectedRow() >= 0) {
                        BuildingsPage.this.iBuildingsTable.setSelected(BuildingsPage.this.iBuildingsTable.getSelectedRow(), false);
                    }
                    if (buildingId != null) {
                        for (int i = 0; i < BuildingsPage.this.iBuildingsTable.getRowCount(); ++i) {
                            RoomInterface.BuildingInterface b = (RoomInterface.BuildingInterface)BuildingsPage.this.iBuildingsTable.getData(i);
                            if (b == null || !b.getId().equals(buildingId)) continue;
                            BuildingsPage.this.iBuildingsTable.getRowFormatter().getElement(i).scrollIntoView();
                            BuildingsPage.this.iBuildingsTable.setSelected(i, true);
                            break;
                        }
                    }
                }
            }

            @Override
            protected boolean isAbbreviationUnique(RoomInterface.BuildingInterface building) {
                for (int i = 0; i < BuildingsPage.this.iBuildingsTable.getRowCount(); ++i) {
                    RoomInterface.BuildingInterface b = (RoomInterface.BuildingInterface)BuildingsPage.this.iBuildingsTable.getData(i);
                    if (b == null || b.getId().equals(building.getId()) || !b.getAbbreviation().equalsIgnoreCase(building.getAbbreviation())) continue;
                    return false;
                }
                return true;
            }
        };
        this.iPanel.setWidget((Widget)this.iListBuildingsForm);
        this.initWidget((Widget)this.iPanel);
    }

    protected void addBuilding() {
        this.iBuildingsEdit.setValue(null);
        this.iPanel.setWidget((Widget)this.iBuildingsEdit);
        this.iBuildingsEdit.show();
        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageAddBuilding());
        this.iBuildingsTable.clearHover();
    }

    protected void editBuilding(RoomInterface.BuildingInterface building) {
        this.iBuildingsEdit.setValue(building);
        this.iPanel.setWidget((Widget)this.iBuildingsEdit);
        this.iBuildingsEdit.show();
        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEditBuilding());
        this.iBuildingsTable.clearHover();
    }
}

