/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorRequirementsTable;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class OfferingDetailWidget
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private UniTimeHeaderPanel iHeader;
    private SimpleForm iForm = new SimpleForm();
    private Long iOfferingId;

    public OfferingDetailWidget() {
        this.iForm.setCellPadding(1);
        this.iForm.addStyleName("unitime-InstructorSurveyPage");
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectInstructorRequirements());
        this.iHeader.setCollapsible(InstructorCookie.getInstance().isShowSurveyDetails());
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorCookie.getInstance().setShowSurveyDetails((Boolean)event.getValue());
                if (OfferingDetailWidget.this.iForm.getRowCount() <= 1) {
                    OfferingDetailWidget.this.open();
                } else {
                    for (int row = 1; row < OfferingDetailWidget.this.iForm.getRowCount(); ++row) {
                        OfferingDetailWidget.this.iForm.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.initWidget((Widget)this.iForm);
    }

    protected void open() {
        this.iHeader.showLoading();
        RPC.execute(new InstructorSurveyInterface.InstructorRequirementsRequest(this.iOfferingId), new AsyncCallback<InstructorSurveyInterface.InstructorRequirementData>(){

            public void onFailure(Throwable t) {
                OfferingDetailWidget.this.iHeader.setErrorMessage(MESSAGES.failedToLoadPage(t.getMessage()));
            }

            public void onSuccess(InstructorSurveyInterface.InstructorRequirementData data) {
                OfferingDetailWidget.this.setValue(data);
                OfferingDetailWidget.this.iHeader.clearMessage();
            }
        });
    }

    protected void setValue(InstructorSurveyInterface.InstructorRequirementData data) {
        if (this.iForm.getRowCount() > 1) {
            this.iForm.clear();
            this.iForm.addHeaderRow((Widget)this.iHeader);
        }
        this.iForm.addRow((Widget)new InstructorRequirementsTable(data));
    }

    public void insert(RootPanel panel) {
        this.iOfferingId = Long.valueOf(panel.getElement().getInnerText());
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
        if (this.iHeader.isCollapsible().booleanValue()) {
            this.open();
        }
    }
}

