/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyCourseTable;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyPage;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomSharingWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class InstructorSurveyWidget
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static DateTimeFormat sTimeStampFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private Long iInstructorId;
    private UniTimeHeaderPanel iHeader;
    private SimpleForm iForm = new SimpleForm();
    private InstructorSurveyInterface.InstructorSurveyData iSurvey;
    private CheckBox iShowDifferences;

    public InstructorSurveyWidget() {
        this.iForm.setCellPadding(1);
        this.iForm.addStyleName("unitime-InstructorSurveyPage");
        this.iShowDifferences = new CheckBox(MESSAGES.instructorSurveyCompareWithInstructorPrefs());
        this.iShowDifferences.setValue(Boolean.valueOf(InstructorCookie.getInstance().isHighlightSurveyChanges()));
        this.iShowDifferences.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorCookie.getInstance().setHighlightSurveyChanges(InstructorSurveyWidget.this.iShowDifferences.getValue());
                InstructorSurveyWidget.this.setValue(InstructorSurveyWidget.this.iSurvey);
            }
        });
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectInstructorSurvey());
        this.iHeader.setCollapsible(InstructorCookie.getInstance().isShowSurveyDetails());
        this.iHeader.setTitleStyleName("unitime3-HeaderTitle");
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorCookie.getInstance().setShowSurveyDetails((Boolean)event.getValue());
                if (InstructorSurveyWidget.this.iForm.getRowCount() <= 1) {
                    InstructorSurveyWidget.this.open();
                } else {
                    for (int row = 1; row < InstructorSurveyWidget.this.iForm.getRowCount(); ++row) {
                        InstructorSurveyWidget.this.iForm.getRowFormatter().setVisible(row, ((Boolean)event.getValue()).booleanValue());
                    }
                }
            }
        });
        this.iHeader.addButton("delete", MESSAGES.buttonDeleteInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                Command delete = new Command(){

                    public void execute() {
                        InstructorSurveyWidget.this.iHeader.showLoading();
                        RPC.execute(new InstructorSurveyInterface.InstructorSurveyDeleteRequest(InstructorSurveyWidget.this.iInstructorId), new AsyncCallback<GwtRpcResponseNull>(){

                            public void onFailure(Throwable caught) {
                                InstructorSurveyWidget.this.iHeader.setErrorMessage(caught.getMessage());
                            }

                            public void onSuccess(GwtRpcResponseNull result) {
                                Window.Location.reload();
                            }
                        });
                    }
                };
                if (InstructorSurveyWidget.this.iSurvey.isEmpty()) {
                    delete.execute();
                } else {
                    UniTimeConfirmationDialog.confirm(MESSAGES.questionDeleteInstructorSurveys(), delete);
                }
            }
        });
        this.iHeader.setEnabled("delete", false);
        this.iHeader.addButton("submit", MESSAGES.buttonSubmitInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                InstructorSurveyWidget.this.iHeader.clearMessage();
                LoadingWidget.showLoading(MESSAGES.waitUpdatingInstructorSurvey());
                InstructorSurveyInterface.InstructorSurveySaveRequest req = new InstructorSurveyInterface.InstructorSurveySaveRequest(InstructorSurveyWidget.this.iSurvey, true);
                req.setChanged(false);
                req.setInstructorId(InstructorSurveyWidget.this.iInstructorId);
                RPC.execute(req, new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.hideLoading();
                        UniTimeNotifications.error(caught.getMessage());
                        InstructorSurveyWidget.this.iHeader.setErrorMessage(caught.getMessage());
                    }

                    public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                        LoadingWidget.hideLoading();
                        UniTimeNotifications.info(MESSAGES.infoInstructorSurveyUpdated());
                        InstructorSurveyWidget.this.setValue(result);
                    }
                });
            }
        });
        this.iHeader.setEnabled("submit", false);
        this.iHeader.addButton("unsubmit", MESSAGES.buttonUnsubmitInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                InstructorSurveyWidget.this.iHeader.clearMessage();
                LoadingWidget.showLoading(MESSAGES.waitUpdatingInstructorSurvey());
                InstructorSurveyInterface.InstructorSurveySaveRequest req = new InstructorSurveyInterface.InstructorSurveySaveRequest(InstructorSurveyWidget.this.iSurvey, false);
                req.setChanged(false);
                req.setUnsubmit(true);
                req.setInstructorId(InstructorSurveyWidget.this.iInstructorId);
                RPC.execute(req, new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.hideLoading();
                        UniTimeNotifications.error(caught.getMessage());
                        InstructorSurveyWidget.this.iHeader.setErrorMessage(caught.getMessage());
                    }

                    public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                        LoadingWidget.hideLoading();
                        UniTimeNotifications.info(MESSAGES.infoInstructorSurveyUpdated());
                        InstructorSurveyWidget.this.setValue(result);
                        if (result.hasPopupMessage()) {
                            if (result.isPopupWarning()) {
                                UniTimeNotifications.warn(result.getPopupMessage());
                            } else {
                                UniTimeNotifications.info(result.getPopupMessage());
                            }
                        }
                    }
                });
            }
        });
        this.iHeader.setEnabled("unsubmit", false);
        this.iHeader.addButton("apply", MESSAGES.buttonApplyInstructorSurveyPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimeConfirmationDialog.confirm(MESSAGES.questionApplyInstructorSurveyPreferences(), new Command(){

                    public void execute() {
                        InstructorSurveyWidget.this.iHeader.showLoading();
                        RPC.execute(new InstructorSurveyInterface.InstructorSurveyApplyRequest(InstructorSurveyWidget.this.iInstructorId), new AsyncCallback<GwtRpcResponseNull>(){

                            public void onFailure(Throwable caught) {
                                InstructorSurveyWidget.this.iHeader.setErrorMessage(caught.getMessage());
                            }

                            public void onSuccess(GwtRpcResponseNull result) {
                                Window.Location.reload();
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.setEnabled("apply", false);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.initWidget((Widget)this.iForm);
    }

    public void insert(RootPanel panel) {
        this.iInstructorId = Long.valueOf(panel.getElement().getInnerText());
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
        if (this.iHeader.isCollapsible().booleanValue()) {
            this.open();
        }
    }

    protected void open() {
        this.iHeader.showLoading();
        RPC.execute(new InstructorSurveyInterface.InstructorSurveyRequest(this.iInstructorId), new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

            public void onFailure(Throwable t) {
                InstructorSurveyWidget.this.iHeader.setErrorMessage(MESSAGES.failedToLoadPage(t.getMessage()));
            }

            public void onSuccess(InstructorSurveyInterface.InstructorSurveyData survey) {
                InstructorSurveyWidget.this.setValue(survey);
                InstructorSurveyWidget.this.iHeader.clearMessage();
            }
        });
    }

    protected boolean isShowDifferences() {
        return (this.iSurvey.getSubmitted() != null || this.iSurvey.getApplied() != null && this.iSurvey.getAppliedDeptCode() != null) && this.iShowDifferences.getValue() != false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setValue(InstructorSurveyInterface.InstructorSurveyData survey) {
        block29: {
            char ch;
            RoomSharingWidget.Cell cell;
            int slot;
            int day;
            RoomInterface.RoomSharingDisplayMode mode;
            Object tp;
            block33: {
                block32: {
                    block31: {
                        block30: {
                            this.iSurvey = survey;
                            if (this.iForm.getRowCount() > 1) {
                                this.iForm.clear();
                                this.iForm.addHeaderRow((Widget)this.iHeader);
                            }
                            this.iHeader.setEnabled("submit", survey.isEditable() && survey.isAdmin() && survey.getSubmitted() == null);
                            this.iHeader.setEnabled("delete", survey.isEditable() && survey.isAdmin() && survey.getSubmitted() == null && (survey.isEmpty() || survey.isCanDelete()));
                            this.iHeader.setEnabled("unsubmit", survey.isEditable() && survey.isAdmin() && survey.getSubmitted() != null);
                            this.iHeader.setEnabled("apply", survey.isCanApply());
                            if (survey.hasEmail()) {
                                this.iForm.addRow(MESSAGES.propEmail(), (Widget)new Label(survey.getEmail()));
                            }
                            if (survey.getChanged() != null && survey.getChangedBy() != null) {
                                this.iForm.addRow(MESSAGES.propLastChange(), (Widget)new Label(MESSAGES.lastChange(sTimeStampFormat.format(survey.getChanged()), survey.getChangedBy())));
                            }
                            if (survey.getSubmitted() != null) {
                                this.iForm.addRow(MESSAGES.propSubmitted(), (Widget)new Label(sTimeStampFormat.format(survey.getSubmitted())));
                            } else {
                                Label notSubmitted = new Label(MESSAGES.notSubbitted());
                                notSubmitted.addStyleName("not-submitted");
                                this.iForm.addRow(MESSAGES.propSubmitted(), (Widget)notSubmitted);
                            }
                            if (survey.getApplied() != null && survey.getAppliedDeptCode() != null) {
                                this.iForm.addRow(MESSAGES.propLastApplied(), (Widget)new Label(MESSAGES.lastApply(sTimeStampFormat.format(survey.getApplied()), survey.getAppliedDeptCode())));
                            }
                            if (this.iSurvey.getSubmitted() != null || this.iSurvey.getApplied() != null && this.iSurvey.getAppliedDeptCode() != null) {
                                this.iForm.addRow("", (Widget)this.iShowDifferences);
                            }
                            if (survey.getApplied() != null && survey.getChanged() != null && survey.getApplied().before(survey.getChanged())) {
                                Label updatedAfterApplied = new Label(MESSAGES.surveyUpdatedAfterApply());
                                updatedAfterApplied.addStyleName("updated-after-applied");
                                this.iForm.addRow("", (Widget)updatedAfterApplied);
                            }
                            if (survey.getTimePrefs().isEmpty()) break block30;
                            tp = new InstructorSurveyPage.InstructorTimePreferences(false);
                            ((InstructorSurveyPage.InstructorTimePreferences)tp).setModel(survey.getTimePrefs());
                            ((RoomSharingWidget)tp).setMode(survey.getTimePrefs().getModes().get(0), true);
                            ((RoomSharingWidget)tp).setEditable(false);
                            this.iForm.addRow(MESSAGES.propTimePrefs(), (Widget)((RoomSharingWidget)tp).getPanel());
                            if (survey.getTimePrefs().hasHard() && !((InstructorSurveyPage.InstructorTimePreferences)tp).getReason().getText().isEmpty()) {
                                this.iForm.addRow("", (Widget)new InstructorSurveyPage.ReadOnlyNote(((InstructorSurveyPage.InstructorTimePreferences)tp).getReason().getText()));
                            }
                            if (!this.isShowDifferences()) break block29;
                            if (survey.getTimePrefs().getProblem() == InstructorSurveyInterface.Problem.LEVEL_CHANGED) break block31;
                            if (survey.getTimePrefs().getProblem() != InstructorSurveyInterface.Problem.NOT_APPLIED) break block29;
                            break block32;
                        }
                        if (!this.isShowDifferences() || survey.getTimePrefs().getProblem() != InstructorSurveyInterface.Problem.LEVEL_CHANGED) break block29;
                        break block33;
                    }
                    mode = survey.getTimePrefs().getModes().get(survey.getTimePrefs().getDefaultMode());
                    day = mode.getFirstDay();
                    while (true) {
                        for (slot = mode.getFirstSlot(); slot <= mode.getLastSlot(); slot += mode.getStep()) {
                            cell = this.getCell((Widget)((RoomSharingWidget)tp).getPanel(), day, slot);
                            if (cell == null) continue;
                            ch = '2';
                            try {
                                ch = survey.getTimePrefs().getInstructorPattern().length() <= 336 ? survey.getTimePrefs().getInstructorPattern().charAt(48 * day + slot / 6) : survey.getTimePrefs().getInstructorPattern().charAt(288 * day + slot);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                            if (ch == survey.getTimePrefs().id2char(survey.getTimePrefs().getOption(day, slot).getId())) continue;
                            cell.addStyleName("preference-changed");
                        }
                        if (day != mode.getLastDay()) {
                            day = (1 + day) % 7;
                            continue;
                        }
                        break block29;
                        break;
                    }
                }
                mode = survey.getTimePrefs().getModes().get(survey.getTimePrefs().getDefaultMode());
                day = mode.getFirstDay();
                while (true) {
                    for (slot = mode.getFirstSlot(); slot <= mode.getLastSlot(); slot += mode.getStep()) {
                        cell = this.getCell((Widget)((RoomSharingWidget)tp).getPanel(), day, slot);
                        if (cell == null || '2' == survey.getTimePrefs().id2char(survey.getTimePrefs().getOption(day, slot).getId())) continue;
                        cell.addStyleName("preference-changed");
                    }
                    if (day != mode.getLastDay()) {
                        day = (1 + day) % 7;
                        continue;
                    }
                    break block29;
                    break;
                }
            }
            tp = new InstructorSurveyPage.InstructorTimePreferences(false);
            ((InstructorSurveyPage.InstructorTimePreferences)tp).setModel(survey.getTimePrefs());
            ((RoomSharingWidget)tp).setMode(survey.getTimePrefs().getModes().get(0), true);
            ((RoomSharingWidget)tp).setEditable(false);
            this.iForm.addRow(MESSAGES.propTimePrefs(), (Widget)((RoomSharingWidget)tp).getPanel());
            mode = survey.getTimePrefs().getModes().get(survey.getTimePrefs().getDefaultMode());
            day = mode.getFirstDay();
            while (true) {
                for (slot = mode.getFirstSlot(); slot <= mode.getLastSlot(); slot += mode.getStep()) {
                    cell = this.getCell((Widget)((RoomSharingWidget)tp).getPanel(), day, slot);
                    if (cell == null) continue;
                    ch = '2';
                    try {
                        ch = survey.getTimePrefs().getInstructorPattern().length() <= 336 ? survey.getTimePrefs().getInstructorPattern().charAt(48 * day + slot / 6) : survey.getTimePrefs().getInstructorPattern().charAt(288 * day + slot);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (ch == survey.getTimePrefs().id2char(survey.getTimePrefs().getOption(day, slot).getId())) continue;
                    cell.addStyleName("preference-changed");
                }
                if (day == mode.getLastDay()) break;
                day = (1 + day) % 7;
            }
        }
        if (survey.hasRoomPreferences()) {
            for (InstructorSurveyInterface.Preferences p : survey.getRoomPreferences()) {
                if (!p.hasSelections(this.iShowDifferences.getValue())) continue;
                this.iForm.addRow(p.getType(), (Widget)new PreferencesReadOnlyTable(p, survey.getPrefLevels()));
            }
        }
        if (survey.hasDistributionPreferences() && survey.getDistributionPreferences().hasSelections(this.iShowDifferences.getValue())) {
            this.iForm.addRow(survey.getDistributionPreferences().getType(), (Widget)new PreferencesReadOnlyTable(survey.getDistributionPreferences(), survey.getPrefLevels()));
        }
        if (survey.hasNote()) {
            this.iForm.addRow(MESSAGES.propOtherPreferences(), (Widget)new InstructorSurveyPage.ReadOnlyNote(survey.getNote()));
        }
        InstructorSurveyCourseTable courses = new InstructorSurveyCourseTable(survey.getSessionId(), survey.getCustomFields(), false);
        if (survey.hasCourses()) {
            for (InstructorSurveyInterface.Course ci : survey.getCourses()) {
                if (!ci.hasCustomFields()) continue;
                courses.addRow(ci);
            }
        }
        courses.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorSurveyInterface.Course>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorSurveyInterface.Course> event) {
                if (event.getData() != null && event.getData().getId() != null) {
                    ToolBox.open("instructionalOfferingDetail.action?op=view&co=" + event.getData().getId());
                }
            }
        });
        if (courses.getRowCount() > 1) {
            this.iForm.addRow(MESSAGES.propInstructorCoursePreferences(), (Widget)courses);
        }
        if (survey.isEditable()) {
            this.iForm.addBottomRow((Widget)this.iHeader.clonePanel(""));
        }
    }

    public RoomSharingWidget.Cell getCell(Widget prefs, int day, int slot) {
        if (prefs instanceof RoomSharingWidget.Cell) {
            RoomSharingWidget.Cell cell = (RoomSharingWidget.Cell)prefs;
            if (cell.getDay() == day && cell.getSlot() == slot) {
                return cell;
            }
            return null;
        }
        if (prefs instanceof ComplexPanel) {
            ComplexPanel p = (ComplexPanel)prefs;
            for (int i = 0; i < p.getWidgetCount(); ++i) {
                RoomSharingWidget.Cell cell = this.getCell(p.getWidget(i), day, slot);
                if (cell == null) continue;
                return cell;
            }
        }
        return null;
    }

    class PreferencesReadOnlyTable
    extends P {
        PreferencesReadOnlyTable(InstructorSurveyInterface.Preferences preferences, List<InstructorSurveyInterface.PrefLevel> options) {
            super("preference-table");
            if (preferences.hasSelections()) {
                for (InstructorSurveyInterface.IdLabel item : preferences.getItems()) {
                    InstructorSurveyInterface.Selection selection = preferences.getSelection(item.getId());
                    if (selection == null) continue;
                    InstructorSurveyInterface.PrefLevel level = null;
                    InstructorSurveyInterface.PrefLevel instructorLevel = null;
                    for (InstructorSurveyInterface.PrefLevel prefLevel : options) {
                        if (prefLevel.getId().equals(selection.getLevel())) {
                            level = prefLevel;
                        }
                        if (!prefLevel.getId().equals(selection.getInstructorLevel())) continue;
                        instructorLevel = prefLevel;
                    }
                    if (!InstructorSurveyWidget.this.isShowDifferences() && level == null) continue;
                    this.add((Widget)new PreferenceLine(item, level, instructorLevel, selection));
                }
            }
        }

        class PreferenceLine
        extends P {
            PreferenceLine(InstructorSurveyInterface.IdLabel item, InstructorSurveyInterface.PrefLevel level, InstructorSurveyInterface.PrefLevel instructor, InstructorSurveyInterface.Selection selection) {
                P ip;
                super("preference-line", "preference-line-readonly");
                P line1 = new P("first-line");
                this.add((Widget)line1);
                if (level != null) {
                    P preference = new P("preference-cell");
                    preference.setText(level.getTitle());
                    if (InstructorSurveyWidget.this.isShowDifferences() && selection.getProblem() == InstructorSurveyInterface.Problem.DIFFERENT_DEPT) {
                        preference.addStyleName("different-dept");
                    } else {
                        preference.getElement().getStyle().setColor(level.getColor());
                    }
                    line1.add((Widget)preference);
                }
                P it = new P("preference-cell");
                it.setText(item.getLabel());
                if (InstructorSurveyWidget.this.isShowDifferences() && selection.getProblem() == InstructorSurveyInterface.Problem.DIFFERENT_DEPT) {
                    it.addStyleName("different-dept");
                } else if (level != null) {
                    it.getElement().getStyle().setColor(level.getColor());
                }
                line1.add((Widget)it);
                if (InstructorSurveyWidget.this.isShowDifferences() && instructor != null) {
                    if (level != null) {
                        ct = new P("preference-cell", "pref-changed-to");
                        ct.setText(MESSAGES.instructorSurveyPreferenceLevelChangedTo());
                        line1.add((Widget)ct);
                    } else {
                        ct = new P("preference-cell", "pref-set-to");
                        ct.setText(MESSAGES.instructorSurveyPreferenceAdded());
                        line1.add((Widget)ct);
                    }
                    ip = new P("preference-cell", "new-preference-level");
                    ip.setText(instructor.getTitle());
                    ip.getElement().getStyle().setColor(instructor.getColor());
                    line1.add((Widget)ip);
                }
                if (InstructorSurveyWidget.this.isShowDifferences() && selection.getProblem() == InstructorSurveyInterface.Problem.NOT_APPLIED) {
                    ip = new P("preference-cell", "pref-not-set");
                    ip.setText(MESSAGES.instructorSurveyPreferenceNotSet());
                    line1.add((Widget)ip);
                }
                if (level != null && level.isHard() && selection.hasNote()) {
                    P reason = new P("reason");
                    reason.setVisible(false);
                    reason.setVisible(true);
                    reason.setText(selection.getNote());
                    if (InstructorSurveyWidget.this.isShowDifferences() && selection.getProblem() == InstructorSurveyInterface.Problem.DIFFERENT_DEPT) {
                        reason.addStyleName("different-dept");
                    }
                    P line2 = new P("second-line");
                    line2.add((Widget)reason);
                    this.add((Widget)line2);
                }
            }
        }
    }
}

