/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import java.util.Comparator;
import java.util.Iterator;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorAttributesComparator
implements Comparator<InstructorInterface.AttributeInterface> {
    private InstructorInterface.AttributesColumn iColumn;
    private boolean iAsc;

    public InstructorAttributesComparator(InstructorInterface.AttributesColumn column, boolean asc) {
        this.iColumn = column;
        this.iAsc = asc;
    }

    public int compareById(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        return this.compare(r1.getId(), r2.getId());
    }

    public int compareByName(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        return this.compare(r1.getName(), r2.getName());
    }

    public int compareByCode(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        return this.compare(r1.getCode(), r2.getCode());
    }

    public int compareByParent(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        return this.compare(r1.getParentName(), r2.getParentName());
    }

    public int compareByType(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        return this.compare(r1.getType() == null ? null : r1.getType().getAbbreviation(), r2.getType() == null ? null : r2.getType().getAbbreviation());
    }

    public int compareByInstructors(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        if (r1.hasInstructors()) {
            if (r2.hasInstructors()) {
                Iterator<InstructorInterface> i1 = r1.getInstructors().iterator();
                Iterator<InstructorInterface> i2 = r2.getInstructors().iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    int cmp = this.compare(i1.next().getOrderName(), i2.next().getOrderName());
                    if (cmp == 0) continue;
                    return cmp;
                }
                if (i1.hasNext()) {
                    return i2.hasNext() ? 0 : 1;
                }
                return i2.hasNext() ? -1 : 0;
            }
            return 1;
        }
        return r2.hasInstructors() ? -1 : 0;
    }

    protected int compareByColumn(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        switch (this.iColumn) {
            case NAME: {
                return this.compareByName(r1, r2);
            }
            case CODE: {
                return this.compareByCode(r1, r2);
            }
            case TYPE: {
                return this.compareByType(r1, r2);
            }
            case PARENT: {
                return this.compareByParent(r1, r2);
            }
            case INSTRUCTORS: {
                return this.compareByInstructors(r1, r2);
            }
        }
        return this.compareByName(r1, r2);
    }

    public static boolean isApplicable(InstructorInterface.AttributesColumn column) {
        switch (column) {
            case NAME: 
            case CODE: 
            case TYPE: 
            case PARENT: 
            case INSTRUCTORS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compare(InstructorInterface.AttributeInterface r1, InstructorInterface.AttributeInterface r2) {
        int cmp = this.compareByColumn(r1, r2);
        if (cmp == 0) {
            cmp = this.compareByName(r1, r2);
        }
        if (cmp == 0) {
            cmp = this.compareById(r1, r2);
        }
        return this.iAsc ? cmp : -cmp;
    }

    @Override
    protected int compare(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty() ? 0 : 1;
        }
        return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
    }

    @Override
    protected int compare(Number n1, Number n2) {
        return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
    }

    @Override
    protected int compare(Boolean b1, Boolean b2) {
        return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
    }
}

