/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.InstructorsTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorAttributeEdit
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SimpleForm iForm = new SimpleForm();
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private InstructorInterface.InstructorAttributePropertiesInterface iProperties;
    private InstructorInterface.AttributeInterface iAttribute;
    private UniTimeWidget<TextBox> iName;
    private UniTimeWidget<TextBox> iCode;
    private UniTimeWidget<ListBox> iType;
    private ListBox iParent;
    private Label iDepartment;
    private int iDepartmentRow;
    private CheckBox iGlobal;
    private InstructorInterface.DepartmentInterface iSelectedDepartment;
    private InstructorsTable iInstructors = null;
    private int iLastScrollTop;
    private int iLastScrollLeft;

    public InstructorAttributeEdit(InstructorInterface.InstructorAttributePropertiesInterface properties) {
        this.iForm.addStyleName("unitime-InstructorAttributeEdit");
        this.iProperties = properties;
        this.iHeader = new UniTimeHeaderPanel();
        ClickHandler createOrUpdateFeature = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InstructorAttributeEdit.this.validate()) {
                    InstructorInterface.UpdateInstructorAttributeRequest request = new InstructorInterface.UpdateInstructorAttributeRequest();
                    request.setAttribute(InstructorAttributeEdit.this.iAttribute);
                    for (int i = 1; i < InstructorAttributeEdit.this.iInstructors.getRowCount(); ++i) {
                        InstructorInterface instructor = (InstructorInterface)InstructorAttributeEdit.this.iInstructors.getData(i);
                        boolean wasSelected = instructor.hasAttribute(InstructorAttributeEdit.this.iAttribute.getId());
                        boolean selected = InstructorAttributeEdit.this.iInstructors.isInstructorSelected(i);
                        if (selected == wasSelected) continue;
                        if (selected) {
                            request.addInstructor(instructor.getId());
                            continue;
                        }
                        request.dropInstructor(instructor.getId());
                    }
                    LoadingWidget.getInstance().show(InstructorAttributeEdit.this.iAttribute.getId() == null ? MESSAGES.waitSavingInstructorAttribute() : MESSAGES.waitUpdatingInstructorAttribute());
                    RPC.execute(request, new AsyncCallback<InstructorInterface.AttributeInterface>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            String message = InstructorAttributeEdit.this.iAttribute.getId() == null ? MESSAGES.errorFailedToSaveInstructorAttribute(caught.getMessage()) : MESSAGES.errorFailedToUpdateInstructorAttribute(caught.getMessage());
                            InstructorAttributeEdit.this.iHeader.setErrorMessage(message);
                            UniTimeNotifications.error(message);
                        }

                        public void onSuccess(InstructorInterface.AttributeInterface result) {
                            LoadingWidget.getInstance().hide();
                            InstructorAttributeEdit.this.hide(true, result);
                        }
                    });
                } else {
                    InstructorAttributeEdit.this.iHeader.setErrorMessage(MESSAGES.failedValidationCheckForm());
                    UniTimeNotifications.error(MESSAGES.failedValidationCheckForm());
                }
            }
        };
        this.iHeader.addButton("create", MESSAGES.buttonCreateInstructorAttribute(), 100, createOrUpdateFeature);
        this.iHeader.addButton("update", MESSAGES.buttonUpdateInstructorAttribute(), 100, createOrUpdateFeature);
        this.iHeader.addButton("delete", MESSAGES.buttonDeleteInstructorAttribute(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!Window.confirm((String)MESSAGES.confirmDeleteInstructorAttribute())) {
                    return;
                }
                InstructorInterface.UpdateInstructorAttributeRequest request = new InstructorInterface.UpdateInstructorAttributeRequest();
                request.setDeleteAttributeId(InstructorAttributeEdit.this.iAttribute.getId());
                LoadingWidget.getInstance().show(MESSAGES.waitDeletingInstructorAttribute());
                RPC.execute(request, new AsyncCallback<InstructorInterface.AttributeInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        String message = MESSAGES.errorFailedToDeleteInstructorAttribute(caught.getMessage());
                        InstructorAttributeEdit.this.iHeader.setErrorMessage(message);
                        UniTimeNotifications.error(message);
                    }

                    public void onSuccess(InstructorInterface.AttributeInterface result) {
                        LoadingWidget.getInstance().hide();
                        InstructorAttributeEdit.this.hide(true, result);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorAttributeEdit.this.hide(false, InstructorAttributeEdit.this.iAttribute);
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iCode = new UniTimeWidget<TextBox>(new TextBox());
        this.iCode.getWidget().setStyleName("unitime-TextBox");
        this.iCode.getWidget().setMaxLength(20);
        this.iCode.getWidget().setWidth("170px");
        this.iCode.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                InstructorAttributeEdit.this.iCode.clearHint();
                InstructorAttributeEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propAbbreviation(), (Widget)this.iCode);
        this.iName = new UniTimeWidget<TextBox>(new TextBox());
        this.iName.getWidget().setStyleName("unitime-TextBox");
        this.iName.getWidget().setMaxLength(60);
        this.iName.getWidget().setWidth("370px");
        this.iName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                InstructorAttributeEdit.this.iName.clearHint();
                InstructorAttributeEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        this.iType = new UniTimeWidget<ListBox>(new ListBox());
        this.iType.getWidget().setStyleName("unitime-TextBox");
        this.iForm.addRow(MESSAGES.propInstructorAttributeType(), (Widget)this.iType);
        this.iType.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                InstructorAttributeEdit.this.iType.clearHint();
                InstructorAttributeEdit.this.iHeader.clearMessage();
                InstructorAttributeEdit.this.setupParents();
            }
        });
        this.iParent = new ListBox();
        this.iParent.setStyleName("unitime-TextBox");
        this.iForm.addRow(MESSAGES.propInstructorAttributeParent(), (Widget)this.iParent);
        this.iGlobal = new CheckBox();
        this.iForm.addRow(MESSAGES.propGlobalInstructorAttribute(), (Widget)this.iGlobal);
        this.iGlobal.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorAttributeEdit.this.iForm.getRowFormatter().setVisible(InstructorAttributeEdit.this.iDepartmentRow, (Boolean)event.getValue() == false);
                InstructorAttributeEdit.this.setupParents();
            }
        });
        this.iDepartment = new Label();
        this.iDepartmentRow = this.iForm.addRow(MESSAGES.propDepartment(), (Widget)this.iDepartment);
        this.iForm.addHeaderRow(MESSAGES.headerInstructors());
        this.iInstructors = new InstructorsTable(this.iProperties, true);
        this.iInstructors.setWidth("100%");
        this.iForm.addRow((Widget)this.iInstructors);
        this.iInstructors.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface> event) {
                InstructorAttributeEdit.this.iHeader.clearMessage();
            }
        });
        this.iFooter = this.iHeader.clonePanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iForm);
        this.iType.getWidget().clear();
        if (!this.iProperties.getAttributeTypes().isEmpty()) {
            this.iType.getWidget().addItem(MESSAGES.itemSelect(), "-1");
            for (InstructorInterface.AttributeTypeInterface type : this.iProperties.getAttributeTypes()) {
                this.iType.getWidget().addItem(type.getLabel(), type.getId().toString());
            }
        }
    }

    private void hide(boolean refresh, InstructorInterface.AttributeInterface attribute) {
        this.setVisible(false);
        this.onHide(refresh, attribute);
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    protected void onHide(boolean refresh, InstructorInterface.AttributeInterface feature) {
    }

    protected void onShow() {
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(this.iAttribute.getId() == null ? MESSAGES.pageAddInstructorAttribute() : MESSAGES.pageEditInstructorAttribute());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
    }

    public void hide() {
        this.hide(true, this.iAttribute);
    }

    protected void setupParents() {
        this.iParent.clear();
        InstructorInterface.GetInstructorAttributeParentsRequest request = new InstructorInterface.GetInstructorAttributeParentsRequest();
        request.setAttributeId(this.iAttribute.getId());
        request.setDepartmentId(this.iGlobal.getValue() != false ? null : (this.iSelectedDepartment == null ? null : this.iSelectedDepartment.getId()));
        request.setTypeId(Long.valueOf(this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex())));
        RPC.execute(request, new AsyncCallback<GwtRpcResponseList<InstructorInterface.AttributeInterface>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(GwtRpcResponseList<InstructorInterface.AttributeInterface> result) {
                InstructorAttributeEdit.this.iParent.clear();
                InstructorAttributeEdit.this.iParent.addItem(MESSAGES.itemInstructorAttributeNoParent(), "-1");
                int select = 0;
                for (InstructorInterface.AttributeInterface a : result) {
                    InstructorAttributeEdit.this.iParent.addItem(a.getName(), a.getId().toString());
                    if (!a.getId().equals(InstructorAttributeEdit.this.iAttribute.getParentId())) continue;
                    select = InstructorAttributeEdit.this.iParent.getItemCount() - 1;
                }
                InstructorAttributeEdit.this.iParent.setSelectedIndex(select);
            }
        });
    }

    public void setAttribute(InstructorInterface.AttributeInterface attribute, InstructorInterface.DepartmentInterface department) {
        this.iHeader.clearMessage();
        this.iName.clearHint();
        this.iCode.clearHint();
        this.iType.clearHint();
        this.iSelectedDepartment = department;
        this.iDepartment.setText((String)(department == null ? "" : department.getDeptCode() + " - " + department.getLabel()));
        if (attribute == null) {
            this.iAttribute = new InstructorInterface.AttributeInterface();
            this.iHeader.setEnabled("create", true);
            this.iHeader.setEnabled("update", false);
            this.iHeader.setEnabled("delete", false);
            this.iName.getWidget().setText("");
            this.iName.getWidget().setEnabled(true);
            this.iCode.getWidget().setText("");
            this.iCode.getWidget().setEnabled(true);
            this.iGlobal.setValue(Boolean.valueOf(this.iSelectedDepartment == null), true);
            this.iGlobal.setEnabled(this.iProperties.isCanAddGlobalAttribute() && this.iSelectedDepartment != null);
            this.iType.getWidget().setSelectedIndex(0);
            this.iType.getWidget().setEnabled(true);
        } else {
            this.iAttribute = new InstructorInterface.AttributeInterface(attribute);
            this.iHeader.setEnabled("create", false);
            this.iHeader.setEnabled("update", attribute.canEdit() || attribute.canAssign());
            this.iHeader.setEnabled("delete", attribute.canDelete());
            this.iName.getWidget().setText(attribute.getName() == null ? "" : attribute.getName());
            this.iName.getWidget().setEnabled(attribute.canEdit());
            this.iCode.getWidget().setText(attribute.getCode() == null ? "" : attribute.getCode());
            this.iCode.getWidget().setEnabled(attribute.canEdit());
            if (attribute.getType() == null) {
                this.iType.getWidget().setSelectedIndex(0);
            } else {
                this.iType.getWidget().setSelectedIndex(1 + this.iProperties.getAttributeTypes().indexOf(attribute.getType()));
            }
            this.iType.getWidget().setEnabled(attribute.canEdit() && attribute.canChangeType());
            this.iGlobal.setValue(Boolean.valueOf(!attribute.isDepartmental()), true);
            this.iGlobal.setEnabled(false);
        }
        this.setupParents();
    }

    public void setInstructors(List<InstructorInterface> instructors) {
        int sort;
        this.iInstructors.clearTable(1);
        this.iInstructors.resetVisibility();
        this.iHeader.clearMessage();
        ValueChangeHandler<Boolean> clearErrorMessage = new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorAttributeEdit.this.iHeader.clearMessage();
            }
        };
        if (instructors != null) {
            for (InstructorInterface i : instructors) {
                int row = this.iInstructors.addInstructor(i);
                boolean selected = i.hasAttribute(this.iAttribute.getId());
                this.iInstructors.selectInstructor(row, selected);
                this.iInstructors.setSelected(row, selected);
                this.iInstructors.getInstructorSelection(row).addValueChangeHandler((ValueChangeHandler)clearErrorMessage);
            }
        }
        if ((sort = InstructorCookie.getInstance().getSortInstructorsBy()) != 0) {
            this.iInstructors.setSortBy(sort);
        }
        this.iInstructors.setVisible(this.iInstructors.getRowCount() > 1);
    }

    public boolean validate() {
        boolean result = true;
        this.iAttribute.setName(this.iName.getWidget().getText());
        if (this.iAttribute.getName().isEmpty()) {
            this.iName.setErrorHint(MESSAGES.errorNameIsEmpty());
            result = false;
        }
        this.iAttribute.setCode(this.iCode.getWidget().getText());
        if (this.iAttribute.getCode().isEmpty()) {
            this.iCode.setErrorHint(MESSAGES.errorAbbreviationIsEmpty());
            result = false;
        }
        this.iAttribute.setType(this.iProperties.getAttributeType(Long.valueOf(this.iType.getWidget().getValue(this.iType.getWidget().getSelectedIndex()))));
        if (this.iAttribute.getType() == null) {
            this.iType.setErrorHint(MESSAGES.errorNoAttributeTypeSelected());
            result = false;
        }
        if (!this.iGlobal.getValue().booleanValue()) {
            this.iAttribute.setDepartment(this.iSelectedDepartment);
        } else {
            this.iAttribute.setDepartment(null);
        }
        if (this.iParent.getSelectedIndex() > 0) {
            this.iAttribute.setParentId(Long.valueOf(this.iParent.getValue(this.iParent.getSelectedIndex())));
            this.iAttribute.setParentName(this.iParent.getItemText(this.iParent.getSelectedIndex()));
        } else {
            this.iAttribute.setParentId(null);
            this.iAttribute.setParentName(null);
        }
        return result;
    }

    public InstructorInterface.AttributeInterface getAttribute() {
        return this.iAttribute;
    }
}

