/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.ScriptInterface;

public class ScriptPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sTS = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormatShort());
    private SimpleForm iForm;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iBottom;
    private UniTimeHeaderPanel iQueueHeader;
    private UniTimeHeaderPanel iLogHeader;
    private ListBox iName;
    private HTML iDescription;
    private int iDescriptionRow;
    private UniTimeTable<ScriptInterface.QueueItemInterface> iQueue;
    private HTML iLog;
    private int iQueueRow;
    private int iLogRow;
    private List<ScriptInterface> iScripts = null;
    private Map<String, String> iParams = new HashMap<String, String>();
    private SaveOrUpdateDialog iDialog = new SaveOrUpdateDialog();
    private int iLastSelectedRow = -1;
    private CheckBox iSendEmail;
    private TextArea iEmailAddresses;
    private VerticalPanel iEmailPanel;

    public ScriptPage() {
        this.iForm = new SimpleForm(2);
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iQueueHeader = new UniTimeHeaderPanel(MESSAGES.sectScriptQueue());
        this.iQueueHeader.addButton("refresh", MESSAGES.buttonRefresh(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ScriptPage.this.refreshQueue(null, null);
            }
        });
        this.iQueueRow = this.iForm.addHeaderRow((Widget)this.iQueueHeader);
        this.iQueue = new UniTimeTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(MESSAGES.colName()));
        header.add(new UniTimeTableHeader(MESSAGES.colStatus()));
        header.add(new UniTimeTableHeader(MESSAGES.colProgress()));
        header.add(new UniTimeTableHeader(MESSAGES.colOwner()));
        header.add(new UniTimeTableHeader(MESSAGES.colSession()));
        header.add(new UniTimeTableHeader(MESSAGES.colCreated()));
        header.add(new UniTimeTableHeader(MESSAGES.colStarted()));
        header.add(new UniTimeTableHeader(MESSAGES.colFinished()));
        header.add(new UniTimeTableHeader(MESSAGES.colOutput()));
        header.add(new UniTimeTableHeader(""));
        this.iQueue.addRow(null, header);
        this.iQueue.setAllowSelection(true);
        this.iForm.addRow((Widget)this.iQueue);
        this.iLogHeader = new UniTimeHeaderPanel();
        this.iLogRow = this.iForm.addHeaderRow((Widget)this.iLogHeader);
        this.iLog = new HTML();
        this.iForm.addRow((Widget)this.iLog);
        this.iForm.getRowFormatter().setVisible(this.iQueueRow, false);
        this.iForm.getRowFormatter().setVisible(this.iQueueRow + 1, false);
        this.iForm.getRowFormatter().setVisible(this.iLogRow, false);
        this.iForm.getRowFormatter().setVisible(this.iLogRow + 1, false);
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectScript());
        this.iHeader.addButton("execute", MESSAGES.buttonExecute(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!Window.confirm((String)MESSAGES.confirmScriptExecution(ScriptPage.this.iName.getItemText(ScriptPage.this.iName.getSelectedIndex())))) {
                    return;
                }
                LoadingWidget.getInstance().show(MESSAGES.waitExecuting(ScriptPage.this.iName.getItemText(ScriptPage.this.iName.getSelectedIndex())));
                ScriptPage.this.RPC.execute(ScriptInterface.ExecuteScriptRpcRequest.executeScript(Long.valueOf(ScriptPage.this.iName.getValue(ScriptPage.this.iName.getSelectedIndex())), ScriptPage.this.iName.getItemText(ScriptPage.this.iName.getSelectedIndex()), ScriptPage.this.iParams, ScriptPage.this.iSendEmail.getValue() != false ? ScriptPage.this.iEmailAddresses.getText() : null), new AsyncCallback<ScriptInterface.QueueItemInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        ScriptPage.this.iHeader.setErrorMessage(MESSAGES.failedExecution(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedExecution(caught.getMessage()), caught);
                    }

                    public void onSuccess(ScriptInterface.QueueItemInterface result) {
                        LoadingWidget.getInstance().hide();
                        ScriptPage.this.iHeader.clearMessage();
                        ScriptPage.this.refreshQueue(null, result == null ? null : result.getId());
                    }
                });
            }
        });
        this.iHeader.setEnabled("execute", false);
        this.iHeader.addButton("add", MESSAGES.buttonAddNew(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ScriptPage.this.iDialog.addScript();
            }
        });
        this.iHeader.setEnabled("add", false);
        this.iHeader.addButton("edit", MESSAGES.buttonEdit(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ScriptInterface script = ScriptPage.this.getScript();
                if (script != null) {
                    ScriptPage.this.iDialog.editScript(script);
                }
            }
        });
        this.iHeader.setEnabled("edit", false);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iName = new ListBox();
        this.iName.addItem(MESSAGES.itemSelect(), "-1");
        this.iName.setSelectedIndex(0);
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        this.iSendEmail = new CheckBox(MESSAGES.scriptSendEmailCheckbox());
        this.iSendEmail.setValue(Boolean.valueOf(false));
        this.iEmailAddresses = new TextArea();
        this.iEmailAddresses.setStyleName("unitime-TextArea");
        this.iEmailAddresses.setVisibleLines(3);
        this.iEmailAddresses.setCharacterWidth(80);
        this.iEmailPanel = new VerticalPanel();
        this.iEmailPanel.add((Widget)this.iSendEmail);
        this.iEmailPanel.setCellHorizontalAlignment((Widget)this.iSendEmail, HasHorizontalAlignment.ALIGN_LEFT);
        this.iEmailPanel.add((Widget)this.iEmailAddresses);
        this.iEmailAddresses.setVisible(false);
        this.iSendEmail.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                ScriptPage.this.iEmailAddresses.setVisible(((Boolean)event.getValue()).booleanValue());
            }
        });
        this.iDescription = new HTML();
        this.iDescriptionRow = this.iForm.addRow(MESSAGES.propDescription(), (Widget)this.iDescription);
        this.iForm.getRowFormatter().setVisible(this.iDescriptionRow, false);
        this.iForm.addRow(MESSAGES.propEmail(), (Widget)this.iEmailPanel);
        this.iBottom = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iBottom);
        this.initWidget((Widget)this.iForm);
        this.iName.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ScriptPage.this.scriptChanged();
                if (ScriptPage.this.iName.getItemCount() > 0) {
                    History.newItem((String)ScriptPage.this.iName.getValue(ScriptPage.this.iName.getSelectedIndex()), (boolean)false);
                }
            }
        });
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ScriptPage.this.reload(Long.valueOf((String)event.getValue()));
            }
        });
        this.reload(History.getToken() == null || History.getToken().isEmpty() ? null : Long.valueOf(History.getToken()));
        this.refreshQueue(null, null);
        new Timer(){

            public void run() {
                ScriptPage.this.refreshQueue(null, null);
            }
        }.scheduleRepeating(5000);
        this.iQueue.addMouseClickListener(new UniTimeTable.MouseClickListener<ScriptInterface.QueueItemInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ScriptInterface.QueueItemInterface> event) {
                if (ScriptPage.this.iLastSelectedRow >= 1) {
                    ScriptPage.this.iQueue.setSelected(ScriptPage.this.iLastSelectedRow, false);
                }
                if (event.getData() != null && ScriptPage.this.iLastSelectedRow != event.getRow()) {
                    ScriptPage.this.iQueue.setSelected(event.getRow(), true);
                    ScriptPage.this.showLog(event.getData());
                    ScriptPage.this.iLastSelectedRow = event.getRow();
                } else {
                    ScriptPage.this.showLog(null);
                    ScriptPage.this.iLastSelectedRow = -1;
                }
            }
        });
    }

    private ScriptInterface getScript() {
        if (this.iScripts != null) {
            for (ScriptInterface s : this.iScripts) {
                if (!s.getId().toString().equals(this.iName.getValue(this.iName.getSelectedIndex()))) continue;
                return s;
            }
        }
        return null;
    }

    private void populate(GwtRpcResponseList<ScriptInterface.QueueItemInterface> queue, String selectId) {
        ScriptInterface.QueueItemInterface q;
        if (this.iQueue.getSelectedRow() > 0 && selectId == null && (q = this.iQueue.getData(this.iQueue.getSelectedRow())) != null) {
            selectId = q.getId();
        }
        ScriptInterface.QueueItemInterface selectedQueue = null;
        this.iQueue.clearTable(1);
        this.iLastSelectedRow = -1;
        for (final ScriptInterface.QueueItemInterface q2 : queue) {
            ArrayList<Object> line = new ArrayList<Object>();
            line.add(new Label(q2.getName()));
            line.add(new Label(q2.getStatus()));
            line.add(new Label(q2.getProgress()));
            line.add(new Label(q2.getOwner()));
            line.add(new Label(q2.getSession()));
            line.add(new Label(q2.getCreated() == null ? "" : sTS.format(q2.getCreated())));
            line.add(new Label(q2.getStarted() == null ? "" : sTS.format(q2.getStarted())));
            line.add(new Label(q2.getFinished() == null ? "" : sTS.format(q2.getFinished())));
            if (q2.getOtuput() != null) {
                line.add(new Anchor(q2.getOtuput().substring(1 + q2.getOtuput().lastIndexOf(46)), q2.getOtuputLink()));
            } else {
                line.add(new Label(""));
            }
            if (q2.isCanDelete()) {
                Image delete = new Image(RESOURCES.delete());
                delete.setTitle(MESSAGES.titleDeleteRow());
                delete.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                delete.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ScriptPage.this.refreshQueue(q2.getId(), null);
                    }
                });
                line.add(delete);
            } else {
                line.add(new Label(""));
            }
            this.iQueue.addRow(q2, line);
            if (selectId == null || !selectId.equals(q2.getId())) continue;
            this.iQueue.setSelected(this.iQueue.getRowCount() - 1, true);
            this.iLastSelectedRow = this.iQueue.getRowCount() - 1;
            selectedQueue = q2;
        }
        this.iForm.getRowFormatter().setVisible(this.iQueueRow, this.iQueue.getRowCount() > 1);
        this.iForm.getRowFormatter().setVisible(this.iQueueRow + 1, this.iQueue.getRowCount() > 1);
        this.showLog(selectedQueue);
    }

    private void refreshQueue(String deleteId, final String selectId) {
        this.RPC.execute(new ScriptInterface.GetQueueTableRpcRequest(deleteId), new AsyncCallback<GwtRpcResponseList<ScriptInterface.QueueItemInterface>>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<ScriptInterface.QueueItemInterface> result) {
                ScriptPage.this.populate(result, selectId);
            }
        });
    }

    private void showLog(ScriptInterface.QueueItemInterface item) {
        if (item == null || item.getLog() == null || item.getLog().isEmpty()) {
            this.iForm.getRowFormatter().setVisible(this.iLogRow, false);
            this.iForm.getRowFormatter().setVisible(this.iLogRow + 1, false);
        } else {
            this.iLogHeader.setHeaderTitle(MESSAGES.sectScriptLog(item.getName()));
            this.iForm.getRowFormatter().setVisible(this.iLogRow, true);
            this.iForm.getRowFormatter().setVisible(this.iLogRow + 1, true);
            this.iLog.setHTML(item.getLog());
        }
    }

    private void scriptChanged() {
        ScriptInterface script = this.getScript();
        if (script == null) {
            this.iForm.getRowFormatter().setVisible(this.iDescriptionRow, false);
            while (this.iForm.getRowCount() > this.iDescriptionRow + 3) {
                this.iForm.removeRow(1 + this.iDescriptionRow);
            }
            this.iHeader.setEnabled("edit", false);
            this.iHeader.setEnabled("execute", false);
            this.iParams.clear();
        } else {
            this.iDescription.setHTML(script.getDescription());
            this.iForm.getRowFormatter().setVisible(this.iDescriptionRow, true);
            this.iHeader.setEnabled("edit", script.canEdit());
            this.iHeader.setEnabled("execute", script.canExecute());
            this.iParams.clear();
            while (this.iForm.getRowCount() > this.iDescriptionRow + 3) {
                this.iForm.removeRow(1 + this.iDescriptionRow);
            }
            if (script.hasParameters()) {
                for (final ScriptInterface.ScriptParameterInterface param : script.getParameters()) {
                    if (param.getValue() != null) {
                        this.iParams.put(param.getName(), param.getValue());
                    }
                    Object widget = null;
                    if (param.hasOptions()) {
                        final ListBox list = new ListBox();
                        list.setMultipleSelect(param.isMultiSelect());
                        if (!param.isMultiSelect()) {
                            list.addItem(MESSAGES.itemSelect());
                        }
                        block3: for (ScriptInterface.ListItem item : param.getOptions()) {
                            list.addItem(item.getText(), item.getValue());
                            if (param.getDefaultValue() == null) continue;
                            if (param.isMultiSelect()) {
                                for (String id : param.getDefaultValue().split(",")) {
                                    if (id.isEmpty() || !id.equalsIgnoreCase(item.getValue()) && !id.equalsIgnoreCase(item.getText()) && !item.getText().startsWith(id + " - ")) continue;
                                    list.setItemSelected(list.getItemCount() - 1, true);
                                    continue block3;
                                }
                                continue;
                            }
                            if (!param.getDefaultValue().equalsIgnoreCase(item.getValue()) && !param.getDefaultValue().equalsIgnoreCase(item.getText()) && !item.getText().startsWith(param.getDefaultValue() + " - ")) continue;
                            list.setSelectedIndex(list.getItemCount() - 1);
                        }
                        list.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (param.isMultiSelect()) {
                                    Object value = "";
                                    for (int i = 0; i < list.getItemCount(); ++i) {
                                        if (!list.isItemSelected(i)) continue;
                                        value = (String)value + (((String)value).isEmpty() ? "" : ",") + list.getValue(i);
                                    }
                                    ScriptPage.this.iParams.put(param.getName(), (String)value);
                                } else if (list.getSelectedIndex() <= 0) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), list.getValue(list.getSelectedIndex()));
                                }
                            }
                        });
                        widget = list;
                    } else if ("boolean".equalsIgnoreCase(param.getType())) {
                        CheckBox ch = new CheckBox();
                        ch.setValue(Boolean.valueOf("true".equalsIgnoreCase(param.getDefaultValue())));
                        ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), (Boolean)event.getValue() != false ? "true" : "false");
                                }
                            }
                        });
                        widget = ch;
                    } else if ("file".equalsIgnoreCase(param.getType())) {
                        UniTimeFileUpload upload = new UniTimeFileUpload();
                        upload.reset();
                        widget = upload;
                    } else if ("textarea".equalsIgnoreCase(param.getType())) {
                        TextArea textarea = new TextArea();
                        textarea.setStyleName("unitime-TextArea");
                        textarea.setVisibleLines(5);
                        textarea.setCharacterWidth(80);
                        if (param.getDefaultValue() != null) {
                            textarea.setText(param.getDefaultValue());
                        }
                        textarea.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), (String)event.getValue());
                                }
                            }
                        });
                        widget = textarea;
                    } else if ("integer".equalsIgnoreCase(param.getType()) || "int".equalsIgnoreCase(param.getType()) || "long".equalsIgnoreCase(param.getType()) || "short".equalsIgnoreCase(param.getType()) || "byte".equalsIgnoreCase(param.getType())) {
                        text = new NumberBox();
                        ((NumberBox)text).setDecimal(false);
                        ((NumberBox)text).setNegative(true);
                        if (param.getDefaultValue() != null) {
                            text.setText(param.getDefaultValue());
                        }
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), (String)event.getValue());
                                }
                            }
                        });
                        widget = text;
                    } else if ("number".equalsIgnoreCase(param.getType()) || "float".equalsIgnoreCase(param.getType()) || "double".equalsIgnoreCase(param.getType())) {
                        text = new NumberBox();
                        ((NumberBox)text).setDecimal(true);
                        ((NumberBox)text).setNegative(true);
                        if (param.getDefaultValue() != null) {
                            text.setText(param.getDefaultValue());
                        }
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), (String)event.getValue());
                                }
                            }
                        });
                        widget = text;
                    } else if ("date".equalsIgnoreCase(param.getType())) {
                        text = new SingleDateSelector();
                        if (param.getDefaultValue() != null) {
                            ((SingleDateSelector)text).setText(param.getDefaultValue());
                        }
                        final DateTimeFormat format = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
                        ((SingleDateSelector)text).addValueChangeHandler(new ValueChangeHandler<Date>(){

                            public void onValueChange(ValueChangeEvent<Date> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), format.format((Date)event.getValue()));
                                }
                            }
                        });
                        widget = text;
                    } else if ("slot".equalsIgnoreCase(param.getType()) || "time".equalsIgnoreCase(param.getType())) {
                        text = new TimeSelector();
                        if (param.getDefaultValue() != null) {
                            ((TimeSelector)((Object)text)).setText(param.getDefaultValue());
                        }
                        ((TimeSelector)((Object)text)).addValueChangeHandler(new ValueChangeHandler<Integer>(){

                            public void onValueChange(ValueChangeEvent<Integer> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), ((Integer)event.getValue()).toString());
                                }
                            }
                        });
                        widget = text;
                    } else if ("datetime".equalsIgnoreCase(param.getType()) || "timestamp".equalsIgnoreCase(param.getType())) {
                        text = new DateTimeBox();
                        if (param.getDefaultValue() != null) {
                            ((DateTimeBox)((Object)text)).setText(param.getDefaultValue());
                        }
                        ((DateTimeBox)((Object)text)).addValueChangeHandler(new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), (String)event.getValue());
                                }
                            }
                        });
                        widget = text;
                    } else {
                        text = new TextBox();
                        text.setStyleName("unitime-TextBox");
                        text.setWidth("400px");
                        if (param.getDefaultValue() != null) {
                            text.setText(param.getDefaultValue());
                        }
                        text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                            public void onValueChange(ValueChangeEvent<String> event) {
                                if (event.getValue() == null) {
                                    ScriptPage.this.iParams.remove(param.getName());
                                } else {
                                    ScriptPage.this.iParams.put(param.getName(), (String)event.getValue());
                                }
                            }
                        });
                        widget = text;
                    }
                    int row = this.iForm.insertRow(this.iForm.getRowCount() - 2);
                    this.iForm.setWidget(row, 0, (Widget)new Label((param.getLabel() == null || param.getLabel().isEmpty() ? param.getName() : param.getLabel()) + ":", false));
                    this.iForm.setWidget(row, 1, (Widget)widget);
                }
            }
        }
    }

    public void reload(final Long scriptId) {
        this.RPC.execute(new ScriptInterface.GetScriptOptionsRpcRequest(), new AsyncCallback<ScriptInterface.ScriptOptionsInterface>(){

            public void onFailure(Throwable caught) {
                ScriptPage.this.iHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
            }

            public void onSuccess(ScriptInterface.ScriptOptionsInterface result) {
                ScriptPage.this.iHeader.setEnabled("add", result.canAdd());
                if (result.hasEmail()) {
                    ScriptPage.this.iEmailAddresses.setText(result.getEmail());
                }
                ScriptPage.this.iDialog.setup(result);
                ScriptPage.this.RPC.execute(new ScriptInterface.LoadAllScriptsRpcRequest(), new AsyncCallback<GwtRpcResponseList<ScriptInterface>>(){

                    public void onFailure(Throwable caught) {
                        ScriptPage.this.iHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
                    }

                    public void onSuccess(GwtRpcResponseList<ScriptInterface> result) {
                        ScriptPage.this.iScripts = result;
                        ScriptPage.this.iName.clear();
                        ScriptPage.this.iName.addItem(MESSAGES.itemSelect(), "-1");
                        ScriptPage.this.iName.setSelectedIndex(0);
                        for (ScriptInterface script : result) {
                            if (!script.canExecute() && !script.canEdit() && !script.canDelete()) continue;
                            ScriptPage.this.iName.addItem(script.getName(), script.getId().toString());
                            if (scriptId == null || !scriptId.equals(script.getId())) continue;
                            ScriptPage.this.iName.setSelectedIndex(ScriptPage.this.iName.getItemCount() - 1);
                        }
                        ScriptPage.this.scriptChanged();
                    }
                });
            }
        });
    }

    private class SaveOrUpdateDialog
    extends UniTimeDialogBox {
        private SimpleForm iDialogForm;
        private TextBox iName;
        private TextArea iDescription;
        private ListBox iPermission;
        private ListBox iEngine;
        private TextArea iScript;
        private UniTimeHeaderPanel iBottom;
        private Long iScriptId;
        private UniTimeTable<ScriptInterface.ScriptParameterInterface> iParams;

        SaveOrUpdateDialog() {
            super(false, true);
            this.iScriptId = null;
            this.iDialogForm = new SimpleForm(2);
            this.iName = new TextBox();
            this.iName.setStyleName("unitime-TextBox");
            this.iName.setWidth("400px");
            this.iName.setMaxLength(128);
            this.iName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            this.iDialogForm.addRow(MESSAGES.propName(), (Widget)this.iName);
            this.iDescription = new TextArea();
            this.iDescription.setStyleName("unitime-TextArea");
            this.iDescription.setVisibleLines(3);
            this.iDescription.setCharacterWidth(80);
            this.iDescription.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            this.iDialogForm.addRow(MESSAGES.propDescription(), (Widget)this.iDescription);
            this.iEngine = new ListBox();
            this.iEngine.setMultipleSelect(false);
            this.iEngine.addItem(MESSAGES.itemSelect());
            this.iEngine.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            this.iDialogForm.addRow(MESSAGES.propEngine(), (Widget)this.iEngine);
            this.iPermission = new ListBox();
            this.iPermission.setMultipleSelect(false);
            this.iPermission.addItem(MESSAGES.itemNone());
            this.iPermission.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            this.iDialogForm.addRow(MESSAGES.propPermission(), (Widget)this.iPermission);
            this.iScript = new TextArea();
            this.iScript.setStyleName("unitime-TextArea");
            this.iScript.setVisibleLines(20);
            this.iScript.setCharacterWidth(80);
            this.iScript.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            this.iDialogForm.addRow(MESSAGES.propScript(), (Widget)this.iScript);
            this.iParams = new UniTimeTable();
            this.iDialogForm.addRow(MESSAGES.propParameters(), (Widget)this.iParams);
            ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
            header.add(new UniTimeTableHeader(MESSAGES.colName()));
            header.add(new UniTimeTableHeader(MESSAGES.colLabel()));
            header.add(new UniTimeTableHeader(MESSAGES.colType()));
            header.add(new UniTimeTableHeader(MESSAGES.colDefaultValue()));
            header.add(new UniTimeTableHeader(""));
            this.iParams.addRow(null, header);
            ClickHandler save = new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (!SaveOrUpdateDialog.this.validate()) {
                        return;
                    }
                    ScriptInterface script = new ScriptInterface();
                    script.setId(SaveOrUpdateDialog.this.iScriptId);
                    script.setName(SaveOrUpdateDialog.this.iName.getText());
                    script.setScript(SaveOrUpdateDialog.this.iScript.getText());
                    script.setDescription(SaveOrUpdateDialog.this.iDescription.getText());
                    script.setEngine(SaveOrUpdateDialog.this.iEngine.getSelectedIndex() <= 0 ? null : SaveOrUpdateDialog.this.iEngine.getValue(SaveOrUpdateDialog.this.iEngine.getSelectedIndex()));
                    script.setPermission(SaveOrUpdateDialog.this.iPermission.getSelectedIndex() <= 0 ? null : SaveOrUpdateDialog.this.iPermission.getValue(SaveOrUpdateDialog.this.iPermission.getSelectedIndex()));
                    for (int i = 1; i < SaveOrUpdateDialog.this.iParams.getRowCount(); ++i) {
                        ScriptInterface.ScriptParameterInterface p = SaveOrUpdateDialog.this.iParams.getData(i);
                        if (p == null || p.getName() == null || p.getName().isEmpty()) continue;
                        script.addParameter(p);
                    }
                    SaveOrUpdateDialog.this.hide();
                    LoadingWidget.getInstance().show(MESSAGES.waitSavingData());
                    ScriptPage.this.RPC.execute(new ScriptInterface.SaveOrUpdateScriptRpcRequest(script), new AsyncCallback<ScriptInterface>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            ScriptPage.this.iHeader.setErrorMessage(MESSAGES.failedSave(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedSave(caught.getMessage()), caught);
                        }

                        public void onSuccess(ScriptInterface result) {
                            LoadingWidget.getInstance().hide();
                            ScriptPage.this.reload(result.getId());
                        }
                    });
                }
            };
            this.iBottom = new UniTimeHeaderPanel();
            this.iBottom.addButton("save", MESSAGES.opScriptSave(), save);
            this.iBottom.addButton("update", MESSAGES.opScriptUpdate(), save);
            this.iBottom.addButton("export", MESSAGES.opScriptExport(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ScriptPage.this.RPC.execute(EventInterface.EncodeQueryRpcRequest.encode("output=script.xml&script=" + SaveOrUpdateDialog.this.iScriptId), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

                        public void onFailure(Throwable caught) {
                        }

                        public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                            ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
                        }
                    });
                }
            });
            this.iBottom.addButton("delete", MESSAGES.opScriptDelete(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (SaveOrUpdateDialog.this.iScriptId != null) {
                        if (!Window.confirm((String)MESSAGES.confirmDeleteScript())) {
                            return;
                        }
                        SaveOrUpdateDialog.this.hide();
                        LoadingWidget.getInstance().show(MESSAGES.waitDelete(SaveOrUpdateDialog.this.iName.getText()));
                        ScriptPage.this.RPC.execute(new ScriptInterface.DeleteScriptRpcRequest(SaveOrUpdateDialog.this.iScriptId, SaveOrUpdateDialog.this.iName.getText()), new AsyncCallback<ScriptInterface>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                ScriptPage.this.iHeader.setErrorMessage(MESSAGES.failedDelete(SaveOrUpdateDialog.this.iName.getText(), caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedDelete(SaveOrUpdateDialog.this.iName.getText(), caught.getMessage()), caught);
                            }

                            public void onSuccess(ScriptInterface result) {
                                LoadingWidget.getInstance().hide();
                                ScriptPage.this.reload(null);
                            }
                        });
                    }
                }
            });
            this.iBottom.addButton("back", MESSAGES.opScriptBack(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SaveOrUpdateDialog.this.hide();
                }
            });
            this.iDialogForm.addBottomRow((Widget)this.iBottom);
            this.setWidget((Widget)this.iDialogForm);
        }

        private void addParam(final ScriptInterface.ScriptParameterInterface param) {
            ArrayList<Object> line = new ArrayList<Object>();
            final TextBox name = new TextBox();
            name.setStyleName("unitime-TextBox");
            name.setMaxLength(128);
            name.setWidth("125px");
            if (param.getName() != null) {
                name.setText(param.getName());
            }
            name.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    param.setName((String)event.getValue());
                    if (!((String)event.getValue()).isEmpty() && SaveOrUpdateDialog.this.iParams.getWidget(SaveOrUpdateDialog.this.iParams.getRowCount() - 1, 0).equals(name)) {
                        SaveOrUpdateDialog.this.addParam(new ScriptInterface.ScriptParameterInterface());
                    }
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            line.add(name);
            TextBox label = new TextBox();
            label.setStyleName("unitime-TextBox");
            label.setMaxLength(256);
            label.setWidth("125px");
            if (param.getLabel() != null) {
                label.setText(param.getLabel());
            }
            label.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    param.setLabel((String)event.getValue());
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            line.add(label);
            TextBox type = new TextBox();
            type.setStyleName("unitime-TextBox");
            type.setMaxLength(2048);
            type.setWidth("125px");
            if (param.getType() != null) {
                type.setText(param.getType());
            }
            type.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    param.setType((String)event.getValue());
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            line.add(type);
            TextBox defaultValue = new TextBox();
            defaultValue.setStyleName("unitime-TextBox");
            defaultValue.setMaxLength(2048);
            defaultValue.setWidth("125px");
            if (param.getDefaultValue() != null) {
                defaultValue.setText(param.getDefaultValue());
            }
            defaultValue.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    param.setDefaultValue((String)event.getValue());
                    SaveOrUpdateDialog.this.iBottom.clearMessage();
                }
            });
            line.add(defaultValue);
            Image delete = new Image(RESOURCES.delete());
            delete.setTitle(MESSAGES.titleDeleteRow());
            delete.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            delete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (SaveOrUpdateDialog.this.iParams.getRowCount() > 2) {
                        SaveOrUpdateDialog.this.iParams.removeRow(SaveOrUpdateDialog.this.iParams.getCellForEvent(event).getRowIndex());
                    }
                }
            });
            line.add(delete);
            this.iParams.addRow(param, line);
        }

        private boolean validate() {
            if (this.iName.getText().isEmpty()) {
                this.iBottom.setErrorMessage(MESSAGES.errorNameIsRequired());
                return false;
            }
            for (ScriptInterface script : ScriptPage.this.iScripts) {
                if (this.iScriptId != null && this.iScriptId.equals(script.getId()) || !this.iName.getText().equals(script.getName())) continue;
                this.iBottom.setErrorMessage(MESSAGES.errorNameNotUnique());
                return false;
            }
            if (this.iEngine.getSelectedIndex() <= 0) {
                this.iBottom.setErrorMessage(MESSAGES.errorEngineIsRequired());
                return false;
            }
            if (this.iScript.getText().isEmpty()) {
                this.iBottom.setErrorMessage(MESSAGES.errorScriptIsRequired());
                return false;
            }
            HashSet<String> names = new HashSet<String>();
            for (int i = 1; i < this.iParams.getRowCount(); ++i) {
                ScriptInterface.ScriptParameterInterface p = this.iParams.getData(i);
                if (p == null || p.getName() == null || p.getName().isEmpty()) continue;
                if (!names.add(p.getName())) {
                    this.iBottom.setErrorMessage(MESSAGES.errorParameterNameNotUnique(p.getName()));
                    return false;
                }
                if (p.getType() != null && !p.getType().isEmpty()) continue;
                this.iBottom.setErrorMessage(MESSAGES.errorParameterTypeRequired(p.getName()));
                return false;
            }
            return true;
        }

        public void addScript() {
            this.iScriptId = null;
            this.setText(MESSAGES.dialogAddScript());
            this.iName.setText("");
            this.iDescription.setText("");
            this.iEngine.setSelectedIndex(0);
            this.iPermission.setSelectedIndex(0);
            this.iScript.setText("");
            this.iParams.clearTable(1);
            this.addParam(new ScriptInterface.ScriptParameterInterface());
            this.center();
            this.iBottom.setEnabled("save", true);
            this.iBottom.setEnabled("update", false);
            this.iBottom.setEnabled("delete", false);
            this.iBottom.setEnabled("export", false);
        }

        public void editScript(ScriptInterface script) {
            int i;
            this.iScriptId = script.getId();
            this.setText(MESSAGES.dialogEditScript());
            this.iName.setText(script.getName());
            this.iDescription.setText(script.getDescription());
            this.iPermission.setSelectedIndex(0);
            if (script.getPermission() != null) {
                for (i = 0; i < this.iPermission.getItemCount(); ++i) {
                    if (!script.getPermission().equals(this.iPermission.getValue(i))) continue;
                    this.iPermission.setSelectedIndex(i);
                    break;
                }
            }
            this.iEngine.setSelectedIndex(0);
            if (script.getEngine() != null) {
                for (i = 0; i < this.iEngine.getItemCount(); ++i) {
                    if (!script.getEngine().equals(this.iEngine.getValue(i))) continue;
                    this.iEngine.setSelectedIndex(i);
                    break;
                }
            }
            this.iScript.setText(script.getScript());
            this.iParams.clearTable(1);
            if (script.hasParameters()) {
                for (ScriptInterface.ScriptParameterInterface param : script.getParameters()) {
                    ScriptInterface.ScriptParameterInterface p = new ScriptInterface.ScriptParameterInterface();
                    p.setDefaultValue(param.getDefaultValue());
                    p.setLabel(param.getLabel());
                    p.setType(param.getType());
                    p.setName(param.getName());
                    this.addParam(p);
                }
            }
            this.addParam(new ScriptInterface.ScriptParameterInterface());
            this.center();
            this.iBottom.setEnabled("save", false);
            this.iBottom.setEnabled("update", script.canEdit());
            this.iBottom.setEnabled("delete", script.canDelete());
            this.iBottom.setEnabled("export", true);
        }

        public void setup(ScriptInterface.ScriptOptionsInterface options) {
            this.iPermission.clear();
            this.iPermission.addItem(MESSAGES.itemNone(), "");
            for (String permission : options.getPermissions()) {
                this.iPermission.addItem(permission);
            }
            this.iEngine.clear();
            this.iEngine.addItem(MESSAGES.itemSelect(), "");
            for (String engine : options.getEngines()) {
                this.iEngine.addItem(engine);
            }
        }
    }

    public static class DateTimeBox
    extends P
    implements HasText,
    HasValue<String> {
        private SingleDateSelector iDate;
        private TimeSelector iTime;
        private DateTimeFormat iFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
        private DateTimeFormat iDefaultFormat = DateTimeFormat.getFormat((String)"MM/dd/yyyy hh:mmaa");

        public DateTimeBox() {
            super("unitime-DateTimeBox");
            this.iDate = new SingleDateSelector();
            this.iDate.addStyleName("date");
            this.add((Widget)this.iDate);
            this.iTime = new TimeSelector();
            this.iTime.addStyleName("time");
            this.add((Widget)this.iTime);
            this.iDate.addValueChangeHandler(new ValueChangeHandler<Date>(){

                public void onValueChange(ValueChangeEvent<Date> event) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getText());
                }
            });
            this.iTime.addValueChangeHandler(new ValueChangeHandler<Integer>(){

                public void onValueChange(ValueChangeEvent<Integer> event) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getText());
                }
            });
        }

        @Override
        public String getText() {
            Date date = this.iDate.getValue();
            if (date == null) {
                return null;
            }
            Integer slot = this.iTime.getValue();
            if (slot != null) {
                int h = slot * 5 / 60;
                int m = slot * 5 % 60;
                date.setHours(h);
                date.setMinutes(m);
            }
            return this.iFormat.format(date);
        }

        @Override
        public void setText(String text) {
            if (text == null || text.isEmpty()) {
                this.iDate.setValue(null);
                this.iTime.setValue(null);
            } else {
                try {
                    Date date = null;
                    try {
                        date = this.iFormat.parse(text);
                    }
                    catch (IllegalArgumentException e) {
                        date = this.iDefaultFormat.parse(text);
                    }
                    this.iDate.setValue(date);
                    int slot = date.getHours() * 12 + date.getMinutes() / 5;
                    this.iTime.setValue(slot == 0 ? null : Integer.valueOf(slot));
                }
                catch (IllegalArgumentException e) {
                    UniTimeNotifications.error(MESSAGES.errorNotValidDate(e.getMessage()));
                    this.iDate.setValue(null);
                    this.iTime.setValue(null);
                }
            }
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
            return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
        }

        public String getValue() {
            return this.getText();
        }

        public void setValue(String value) {
            this.setText(value);
        }

        public void setValue(String value, boolean fireEvents) {
            this.setText(value);
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
            }
        }
    }
}

