/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SimpleItypeConfig;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.IdValue;

public class InstructionalOfferingConfigEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 3257570611432993077L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long configId;
    private String instrOfferingName;
    private String courseOfferingId;
    private String instrOfferingId;
    private String subjectArea;
    private String courseNumber;
    private int limit;
    private Boolean notOffered;
    private String itype;
    private String op;
    private String name;
    private Boolean unlimited;
    private Integer configCount;
    private String catalogLinkLabel;
    private String catalogLinkLocation;
    private String durationTypeDefault;
    private Long durationType;
    private boolean durationTypeEditable;
    private Long instructionalMethod;
    private String instructionalMethodDefault;
    private boolean instructionalMethodEditable;
    private final short NO_ERR = 0;
    private final short ERR_NC = (short)-1;
    private final short ERR_CL = (short)-2;
    private final short ERR_LS = (short)-3;

    public InstructionalOfferingConfigEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.limit < 0) {
            action.addFieldError("form.limit", MSG.errorIntegerGtEq(MSG.columnLimit(), "0"));
        }
        String lblMax = MSG.columnLimit();
        if (action.getRequest().getParameter("varLimits") != null) {
            lblMax = MSG.columnMaxLimit();
        }
        if (MSG.actionAddInstructionalTypeToConfig().equals(this.op) && (this.itype == null || this.itype.trim().length() == 0 || this.itype.equals(Constants.BLANK_OPTION_VALUE))) {
            action.addFieldError("form.itype", MSG.errorRequiredField(MSG.columnInstructionType().replace("\n", " ")));
        }
        if (MSG.actionSaveConfiguration().equals(this.op) || MSG.actionUpdateConfiguration().equals(this.op)) {
            HttpSession webSession = action.getRequest().getSession();
            Collection sp = (Collection)webSession.getAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME);
            InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(Long.valueOf(this.getInstrOfferingId()));
            if (io.existsConfig(this.getName(), this.getConfigId())) {
                action.addFieldError("form.subparts", MSG.errorConfigurationAlreadyExists());
            }
            for (SimpleItypeConfig sic : sp) {
                if (!this.getUnlimited().booleanValue() && ApplicationProperty.ConfigEditCheckLimits.isTrue()) {
                    int numClasses = sic.getNumClasses();
                    int maxLimitPerClass = sic.getMaxLimitPerClass();
                    if (numClasses == 1 && maxLimitPerClass != this.limit) {
                        sic.setHasError(true);
                        action.addFieldError("form.subparts", MSG.errorEqual(MSG.messageLimitPerClassForIType(lblMax, sic.getItype().getDesc()), MSG.messageConfigurationLimit(this.limit)));
                    }
                    if (numClasses > 1 && maxLimitPerClass * numClasses < this.limit) {
                        sic.setHasError(true);
                        action.addFieldError("form.subparts", MSG.errorIntegerGtEq(MSG.messageSumClassLimitsForIType(sic.getItype().getDesc()), MSG.messageConfigurationLimit(this.limit)));
                    }
                }
                this.checkInputfields(action, sic, lblMax, this.getUnlimited());
                short errCode = this.checkChildSubpart(action, sic, lblMax, this.getUnlimited());
                if (errCode == 0) continue;
                if (errCode == -1) {
                    action.addFieldError("form.subparts", MSG.errorConfigurationNC(sic.getItype().getDesc(), sic.getNumClasses()));
                }
                if (errCode == -2) {
                    action.addFieldError("form.subparts", MSG.errorConfigurationCL(sic.getItype().getDesc(), lblMax.toLowerCase(), sic.getMaxLimitPerClass()));
                }
                if (errCode != -3) continue;
                action.addFieldError("form.subparts", MSG.errorConfigurationLS(sic.getItype().getDesc()));
            }
        }
    }

    private void checkInputfields(UniTimeAction action, SimpleItypeConfig sic, String lblMax, boolean unlimited) {
        int mxlpc = sic.getMaxLimitPerClass();
        int mnlpc = sic.getMinLimitPerClass();
        int nc = sic.getNumClasses();
        int nr = sic.getNumRooms();
        int mpw = sic.getMinPerWeek();
        float rc = sic.getRoomRatio();
        long indx = sic.getId();
        int ct = action.getFieldErrors().size();
        if (!unlimited) {
            if (mxlpc < 0) {
                action.addFieldError("form.subparts" + indx, MSG.errorIntegerGtEq(MSG.messageLimitPerClassForIType(lblMax, sic.getItype().getDesc()), "0"));
            } else if (mxlpc > this.limit && ApplicationProperty.ConfigEditCheckLimits.isTrue()) {
                if (nc > 1) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerLtEq(MSG.messageLimitPerClassOfLimitForIType(lblMax, mxlpc, sic.getItype().getDesc()), MSG.messageConfigurationLimit(this.limit)));
                }
            } else {
                if (action.getRequest().getParameter("varLimits") == null) {
                    mnlpc = mxlpc;
                }
                if (mnlpc < 0) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerGtEq(MSG.messageLimitPerClassForIType(MSG.columnMinLimit(), sic.getItype().getDesc()), "0"));
                }
                if (mnlpc > mxlpc) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerLtEq(MSG.messageLimitPerClassForIType(MSG.columnMinLimit(), sic.getItype().getDesc()), MSG.messageMaxLimitPerClass()));
                }
                if (nc <= 0) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerGt(MSG.messageNumberOfClassesForIType(sic.getItype().getDesc()), "0"));
                }
                if (nc > ApplicationProperty.SubpartMaxNumClasses.intValue()) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerLtEq(MSG.messageNumberOfClassesForIType(sic.getItype().getDesc()), ApplicationProperty.SubpartMaxNumClasses.value()));
                }
                if (nr < 0) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerGtEq(MSG.messageNumberOfRoomsForIType(sic.getItype().getDesc()), "0"));
                }
                if (mpw < 0) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerGtEq(MSG.messageMinsPerWeekForIType(sic.getItype().getDesc()), "0"));
                }
                if (mpw == 0 && nr != 0) {
                    action.addFieldError("form.subparts" + indx, MSG.messageMinsPerWeekForITypeCanBeZeroWhenNbrRoomsIsZero(sic.getItype().getDesc()));
                }
                if (rc < 0.0f) {
                    action.addFieldError("form.subparts" + indx, MSG.errorIntegerGtEq(MSG.messageRoomRatioForIType(sic.getItype().getDesc()), "0"));
                }
            }
        } else {
            if (nc <= 0) {
                action.addFieldError("form.subparts" + indx, MSG.errorIntegerGt(MSG.messageNumberOfClassesForIType(sic.getItype().getDesc()), "0"));
            }
            if (nc > ApplicationProperty.SubpartMaxNumClasses.intValue()) {
                action.addFieldError("form.subparts" + indx, MSG.errorIntegerLtEq(MSG.messageNumberOfClassesForIType(sic.getItype().getDesc()), ApplicationProperty.SubpartMaxNumClasses.value()));
            }
            if (mpw < 0) {
                action.addFieldError("form.subparts" + indx, MSG.errorIntegerGtEq(MSG.messageMinsPerWeekForIType(sic.getItype().getDesc()), "0"));
            }
        }
        if (action.getFieldErrors().size() > ct) {
            sic.setHasError(true);
        }
    }

    private short checkChildSubpart(UniTimeAction action, SimpleItypeConfig sic, String lblMax, boolean unlimited) {
        List<SimpleItypeConfig> csp = sic.getSubparts();
        if (csp != null && csp.size() > 0) {
            for (SimpleItypeConfig csic : csp) {
                short errCode;
                this.checkInputfields(action, csic, lblMax, unlimited);
                if (!unlimited) {
                    if (sic.getNumClasses() != 0 && csic.getNumClasses() % sic.getNumClasses() != 0) {
                        csic.setHasError(true);
                        return -1;
                    }
                    if (csic.getMaxLimitPerClass() > sic.getMaxLimitPerClass()) {
                        csic.setHasError(true);
                        return -2;
                    }
                    if (csic.getNumClasses() * csic.getMaxLimitPerClass() < sic.getNumClasses() * sic.getMaxLimitPerClass()) {
                        csic.setHasError(true);
                        return -3;
                    }
                } else if (sic.getNumClasses() != 0 && csic.getNumClasses() % sic.getNumClasses() != 0) {
                    csic.setHasError(true);
                    return -1;
                }
                if ((errCode = this.checkChildSubpart(action, csic, lblMax, unlimited)) == 0) continue;
                return errCode;
            }
        }
        return 0;
    }

    @Override
    public void reset() {
        this.courseOfferingId = "";
        this.subjectArea = "";
        this.courseNumber = "";
        this.itype = "";
        this.limit = 0;
        this.op = "";
        this.unlimited = false;
        this.configCount = 0;
        this.configId = 0L;
        this.name = null;
        this.catalogLinkLabel = null;
        this.catalogLinkLocation = null;
        this.durationType = null;
        this.durationTypeDefault = null;
        this.durationTypeEditable = false;
        this.instructionalMethod = null;
        this.instructionalMethodDefault = null;
        this.instructionalMethodEditable = false;
    }

    public Integer getConfigCount() {
        return this.configCount;
    }

    public void setConfigCount(Integer configCount) {
        this.configCount = configCount;
    }

    public String getSubjectArea() {
        return this.subjectArea;
    }

    public void setSubjectArea(String subjectArea) {
        this.subjectArea = subjectArea;
    }

    public String getCourseNumber() {
        return this.courseNumber;
    }

    public void setCourseNumber(String courseNumber) {
        this.courseNumber = courseNumber;
    }

    public String getCourseOfferingId() {
        return this.courseOfferingId;
    }

    public void setCourseOfferingId(String courseOfferingId) {
        this.courseOfferingId = courseOfferingId;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Boolean getNotOffered() {
        return this.notOffered;
    }

    public void setNotOffered(Boolean notOffered) {
        this.notOffered = notOffered;
    }

    public String getItype() {
        return this.itype;
    }

    public void setItype(String itype) {
        this.itype = itype;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(String instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public Long getConfigId() {
        return this.configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public String getCatalogLinkLabel() {
        return this.catalogLinkLabel;
    }

    public void setCatalogLinkLabel(String catalogLinkLabel) {
        this.catalogLinkLabel = catalogLinkLabel;
    }

    public String getCatalogLinkLocation() {
        return this.catalogLinkLocation;
    }

    public void setCatalogLinkLocation(String catalogLinkLocation) {
        this.catalogLinkLocation = catalogLinkLocation;
    }

    public Long getDurationType() {
        return this.durationType;
    }

    public void setDurationType(Long durationType) {
        this.durationType = durationType;
    }

    public String getDurationTypeDefault() {
        return this.durationTypeDefault;
    }

    public void setDurationTypeDefault(String durationTypeDefault) {
        this.durationTypeDefault = durationTypeDefault;
    }

    public List<IdValue> getDurationTypes() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (ClassDurationType type : ClassDurationType.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.durationType)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }

    public String getDurationTypeText() {
        for (ClassDurationType type : ClassDurationType.findAll()) {
            if (!type.getUniqueId().equals(this.durationType)) continue;
            return type.getLabel();
        }
        return this.durationTypeDefault;
    }

    public boolean isDurationTypeEditable() {
        return this.durationTypeEditable;
    }

    public void setDurationTypeEditable(boolean durationTypeEditable) {
        this.durationTypeEditable = durationTypeEditable;
    }

    public Long getInstructionalMethod() {
        return this.instructionalMethod;
    }

    public void setInstructionalMethod(Long instructionalMethod) {
        this.instructionalMethod = instructionalMethod;
    }

    public String getInstructionalMethodDefault() {
        return this.instructionalMethodDefault;
    }

    public void setInstructionalMethodDefault(String instructionalMethodDefault) {
        this.instructionalMethodDefault = instructionalMethodDefault;
    }

    public List<IdValue> getInstructionalMethods() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (InstructionalMethod type : InstructionalMethod.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.instructionalMethod)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }

    public boolean isInstructionalMethodEditable() {
        return this.instructionalMethodEditable;
    }

    public void setInstructionalMethodEditable(boolean instructionalMethodEditable) {
        this.instructionalMethodEditable = instructionalMethodEditable;
    }
}

