/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ComboBoxLookup;

public class ExamAssignmentReportForm
extends ExamReportForm {
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private static final long serialVersionUID = -1263238076223090733L;
    private String iReport = null;
    private String iFilter = null;
    private boolean iCanSeeAll = false;

    @Override
    public void reset() {
        super.reset();
        this.iReport = null;
        this.iCanSeeAll = false;
    }

    public String getReport() {
        return this.iReport;
    }

    public String getReportName() {
        try {
            return this.getReportName(ExamReport.valueOf(this.iReport));
        }
        catch (Exception e) {
            return this.iReport;
        }
    }

    public void setReport(String report) {
        this.iReport = report;
    }

    public String getReportName(ExamReport report) {
        switch (report) {
            case ExamAssignmentReport: {
                return MSG.reportExamAssignmentReport();
            }
            case RoomAssignmentReport: {
                return MSG.reportRoomAssignmentReport();
            }
            case Statistics: {
                return MSG.reportStatistics();
            }
            case PeriodUsage: {
                return MSG.reportPeriodUsage();
            }
            case NrExamsADay: {
                return MSG.reportNrExamsADay();
            }
            case RoomSplits: {
                return MSG.reportRoomSplits();
            }
            case ViolatedDistributions: {
                return MSG.reportViolatedDistributions();
            }
            case DirectStudentConflicts: {
                return MSG.reportDirectStudentConflicts();
            }
            case More2ADayStudentConflicts: {
                return MSG.reportMore2ADayStudentConflicts();
            }
            case BackToBackStudentConflicts: {
                return MSG.reportBackToBackStudentConflicts();
            }
            case IndividualStudentConflicts: {
                return MSG.reportIndividualStudentConflicts();
            }
            case IndividualDirectStudentConflicts: {
                return MSG.reportIndividualDirectStudentConflicts();
            }
            case IndividualBackToBackStudentConflicts: {
                return MSG.reportIndividualBackToBackStudentConflicts();
            }
            case IndividualMore2ADayStudentConflicts: {
                return MSG.reportIndividualMore2ADayStudentConflicts();
            }
            case DirectInstructorConflicts: {
                return MSG.reportDirectInstructorConflicts();
            }
            case More2ADayInstructorConflicts: {
                return MSG.reportMore2ADayInstructorConflicts();
            }
            case BackToBackInstructorConflicts: {
                return MSG.reportBackToBackInstructorConflicts();
            }
            case IndividualInstructorConflicts: {
                return MSG.reportIndividualInstructorConflicts();
            }
            case IndividualDirectInstructorConflicts: {
                return MSG.reportIndividualDirectInstructorConflicts();
            }
            case IndividualBackToBackInstructorConflicts: {
                return MSG.reportIndividualBackToBackInstructorConflicts();
            }
            case IndividualMore2ADayInstructorConflicts: {
                return MSG.reportIndividualMore2ADayInstructorConflicts();
            }
            case IndividualStudentSchedule: {
                return MSG.reportIndividualStudentSchedule();
            }
            case IndividualInstructorSchedule: {
                return MSG.reportIndividualInstructorSchedule();
            }
        }
        return report.name();
    }

    public List<ComboBoxLookup> getReports() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (ExamReport r : ExamReport.values()) {
            ret.add(new ComboBoxLookup(this.getReportName(r), r.name()));
        }
        return ret;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    @Override
    public void load(SessionContext session) {
        super.load(session);
        this.setFilter(session.getAttribute("ExamReport.Filter") == null ? "" : (String)session.getAttribute("ExamReport.Filter"));
        this.setReport(session.getAttribute("ExamReport.Report") == null ? "" : (String)session.getAttribute("ExamReport.Report"));
    }

    @Override
    public void save(SessionContext session) {
        super.save(session);
        if (this.getFilter() == null) {
            session.removeAttribute("ExamReport.Filter");
        } else {
            session.setAttribute("ExamReport.Filter", (Object)this.getFilter());
        }
        if (this.getReport() == null) {
            session.removeAttribute("ExamReport.Report");
        } else {
            session.setAttribute("ExamReport.Report", (Object)this.getReport());
        }
    }

    public boolean getCanSeeAll() {
        return this.iCanSeeAll;
    }

    public void setCanSeeAll(boolean seeAll) {
        this.iCanSeeAll = seeAll;
    }

    public static enum ExamReport {
        ExamAssignmentReport,
        RoomAssignmentReport,
        Statistics,
        PeriodUsage,
        NrExamsADay,
        RoomSplits,
        ViolatedDistributions,
        DirectStudentConflicts,
        More2ADayStudentConflicts,
        BackToBackStudentConflicts,
        IndividualStudentConflicts,
        IndividualDirectStudentConflicts,
        IndividualBackToBackStudentConflicts,
        IndividualMore2ADayStudentConflicts,
        DirectInstructorConflicts,
        More2ADayInstructorConflicts,
        BackToBackInstructorConflicts,
        IndividualInstructorConflicts,
        IndividualDirectInstructorConflicts,
        IndividualBackToBackInstructorConflicts,
        IndividualMore2ADayInstructorConflicts,
        IndividualStudentSchedule,
        IndividualInstructorSchedule;

    }
}

