/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ReferenceList;

public class DepartmentEditForm
implements UniTimeForm {
    private static final long serialVersionUID = -6614766002463228171L;
    protected static final GwtMessages MSG = Localization.create(GwtMessages.class);
    public Long iId = null;
    public Long iSessionId = null;
    public String iName = null;
    public String iDeptCode = null;
    public String iStatusType = null;
    public String iOp = null;
    public String iAbbv = null;
    public String iExternalId = null;
    public int iDistPrefPriority = 0;
    public boolean iIsExternal = false;
    public String iExtAbbv = null;
    public String iExtName = null;
    public boolean iAllowReqTime = false;
    public boolean iAllowReqRoom = false;
    public boolean iAllowReqDist = false;
    public boolean iAllowEvents = false;
    public boolean iInheritInstructorPreferences = false;
    public boolean iAllowStudentScheduling = false;
    private List<Long> iDependentDepartments;
    private List<String> iDependentStatuses;
    private boolean iFullyEditable = false;

    public DepartmentEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iName == null || this.iName.trim().equalsIgnoreCase("")) {
            action.addFieldError("form.name", MSG.errorNameIsRequired());
        }
        if (this.iName != null && this.iName.trim().length() > 100) {
            action.addFieldError("form.name", MSG.errorTooLong(MSG.colName()));
        }
        if (this.iAbbv == null || this.iAbbv.trim().equalsIgnoreCase("")) {
            action.addFieldError("form.abbv", MSG.errorAbbreviationIsEmpty());
        }
        if (this.iAbbv != null && this.iAbbv.trim().length() > 20) {
            action.addFieldError("form.abbv", MSG.errorTooLong(MSG.colAbbreviation()));
        }
        if (this.iDeptCode == null || this.iDeptCode.trim().equalsIgnoreCase("")) {
            action.addFieldError("form.deptCode", MSG.errorDeptCodeIsEmpty());
        }
        if (this.iDeptCode != null && this.iDeptCode.trim().length() > 50) {
            action.addFieldError("form.deptCode", MSG.errorTooLong(MSG.colCode()));
        }
        if (this.iIsExternal && (this.iExtName == null || this.iExtName.trim().length() == 0)) {
            action.addFieldError("form.extName", MSG.errorRequired(MSG.fieldExternalManagerName()));
        }
        if (!this.iIsExternal && this.iExtName != null && this.iExtName.trim().length() > 0) {
            action.addFieldError("form.extName", MSG.errorExternalManagerNameUse());
        }
        if (this.iIsExternal && this.iExtName != null && this.iExtName.trim().length() > 30) {
            action.addFieldError("form.extName", MSG.errorTooLong(MSG.fieldExternalManagerName()));
        }
        if (this.iIsExternal && (this.iExtAbbv == null || this.iExtAbbv.trim().length() == 0)) {
            action.addFieldError("form.extAbbv", MSG.errorRequired(MSG.fieldExternalManagerAbbreviation()));
        }
        if (!this.iIsExternal && this.iExtAbbv != null && this.iExtAbbv.trim().length() > 0) {
            action.addFieldError("form.extAbbv", MSG.errorExternalManagerAbbreviationUse());
        }
        if (this.iIsExternal && this.iExtAbbv != null && this.iExtAbbv.trim().length() > 10) {
            action.addFieldError("form.extAbbv", MSG.errorTooLong(MSG.fieldExternalManagerAbbreviation()));
        }
        try {
            Department dept = Department.findByDeptCode(this.iDeptCode, this.iSessionId);
            if (dept != null && !dept.getUniqueId().equals(this.iId)) {
                action.addFieldError("form.deptCode", MSG.errorDeptCodeMustBeUnique());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            action.addFieldError("form.deptCode", e.getMessage());
        }
    }

    @Override
    public void reset() {
        this.iId = null;
        this.iSessionId = null;
        this.iName = null;
        this.iDeptCode = null;
        this.iStatusType = null;
        this.iAbbv = null;
        this.iDistPrefPriority = 0;
        this.iIsExternal = false;
        this.iExtName = null;
        this.iExtAbbv = null;
        this.iAllowReqTime = false;
        this.iAllowReqRoom = false;
        this.iAllowReqDist = false;
        this.iAllowEvents = false;
        this.iInheritInstructorPreferences = false;
        this.iAllowStudentScheduling = false;
        this.iDependentDepartments = new ArrayList<Long>();
        this.iDependentStatuses = new ArrayList<String>();
        this.iFullyEditable = false;
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public int getDistPrefPriority() {
        return this.iDistPrefPriority;
    }

    public void setDistPrefPriority(int distPrefPriority) {
        this.iDistPrefPriority = distPrefPriority;
    }

    public String getDeptCode() {
        return this.iDeptCode;
    }

    public void setDeptCode(String deptCode) {
        this.iDeptCode = deptCode;
    }

    public String getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(String statusType) {
        this.iStatusType = statusType;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public boolean getIsExternal() {
        return this.iIsExternal;
    }

    public void setIsExternal(boolean isExternal) {
        this.iIsExternal = isExternal;
    }

    public boolean getAllowReqTime() {
        return this.iAllowReqTime;
    }

    public void setAllowReqTime(boolean allowReqTime) {
        this.iAllowReqTime = allowReqTime;
    }

    public boolean getAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public void setAllowReqRoom(boolean allowReqRoom) {
        this.iAllowReqRoom = allowReqRoom;
    }

    public boolean getAllowReqDist() {
        return this.iAllowReqDist;
    }

    public void setAllowReqDist(boolean allowReqDist) {
        this.iAllowReqDist = allowReqDist;
    }

    public boolean getAllowEvents() {
        return this.iAllowEvents;
    }

    public void setAllowEvents(boolean allowEvents) {
        this.iAllowEvents = allowEvents;
    }

    public boolean getInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public void setInheritInstructorPreferences(boolean inheritInstructorPreferences) {
        this.iInheritInstructorPreferences = inheritInstructorPreferences;
    }

    public String getExtAbbv() {
        return this.iExtAbbv;
    }

    public void setExtAbbv(String extAbbv) {
        this.iExtAbbv = extAbbv;
    }

    public String getExtName() {
        return this.iExtName;
    }

    public void setExtName(String extName) {
        this.iExtName = extName;
    }

    public boolean getAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public void setAllowStudentScheduling(boolean allowStudentScheduling) {
        this.iAllowStudentScheduling = allowStudentScheduling;
    }

    public ReferenceList getStatusOptions() {
        ReferenceList ref = new ReferenceList();
        ref.addAll(DepartmentStatusType.findAllForDepartment());
        return ref;
    }

    public List<Long> getDependentDepartments() {
        return this.iDependentDepartments;
    }

    public Long getDependentDepartments(int key) {
        return this.iDependentDepartments.get(key);
    }

    public void setDependentDepartments(int key, Long value) {
        this.iDependentDepartments.set(key, value);
    }

    public void setDependentDepartments(List<Long> departments) {
        this.iDependentDepartments = departments;
    }

    public List<String> getDependentStatuses() {
        return this.iDependentStatuses;
    }

    public String getDependentStatuses(int key) {
        return this.iDependentStatuses.get(key);
    }

    public void setDependentStatuses(int key, String value) {
        this.iDependentStatuses.set(key, value);
    }

    public void setDependentStatuses(List<String> statuses) {
        this.iDependentStatuses = statuses;
    }

    public void load(Department department) {
        this.setId(department.getUniqueId());
        this.setSessionId(department.getSessionId());
        this.setName(department.getName());
        this.setAbbv(department.getAbbreviation());
        this.setDistPrefPriority(department.getDistributionPrefPriority() == null ? 0 : department.getDistributionPrefPriority());
        this.setDeptCode(department.getDeptCode());
        this.setStatusType(department.getStatusType() == null ? null : department.getStatusType().getReference());
        this.setExternalId(department.getExternalUniqueId());
        this.setIsExternal(department.isExternalManager());
        this.setExtAbbv(department.getExternalMgrAbbv());
        this.setExtName(department.getExternalMgrLabel());
        this.setAllowReqRoom(department.isAllowReqRoom() != null && department.isAllowReqRoom() != false);
        this.setAllowReqTime(department.isAllowReqTime() != null && department.isAllowReqTime() != false);
        this.setAllowReqDist(department.isAllowReqDistribution() != null && department.isAllowReqDistribution() != false);
        this.setAllowEvents(department.isAllowEvents());
        this.setAllowStudentScheduling(department.isAllowStudentScheduling());
        this.setInheritInstructorPreferences(department.isInheritInstructorPreferences());
        this.iDependentDepartments.clear();
        this.iDependentStatuses.clear();
        if (department.isExternalManager().booleanValue() && department.getExternalStatusTypes() != null) {
            if (!department.getExternalStatusTypes().isEmpty()) {
                TreeSet<ExternalDepartmentStatusType> set = new TreeSet<ExternalDepartmentStatusType>(new Comparator<ExternalDepartmentStatusType>(){

                    @Override
                    public int compare(ExternalDepartmentStatusType e1, ExternalDepartmentStatusType e2) {
                        return e1.getDepartment().compareTo(e2.getDepartment());
                    }
                });
                set.addAll(department.getExternalStatusTypes());
                for (ExternalDepartmentStatusType e : set) {
                    this.iDependentDepartments.add(e.getDepartment().getUniqueId());
                    this.iDependentStatuses.add(e.getStatusType().getReference());
                }
            }
            this.addBlankDependentDepartment();
            this.addBlankDependentDepartment();
        }
    }

    public void addBlankDependentDepartment() {
        this.iDependentDepartments.add(-1L);
        this.iDependentStatuses.add("");
    }

    public void deleteDependentDepartment(int idx) {
        this.iDependentDepartments.remove(idx);
        this.iDependentStatuses.remove(idx);
    }

    public void deleteAllDependentDepartments() {
        this.iDependentDepartments.clear();
        this.iDependentStatuses.clear();
        this.addBlankDependentDepartment();
        this.addBlankDependentDepartment();
    }

    public void save(SessionContext context) throws Exception {
        Department department;
        DepartmentDAO dao = DepartmentDAO.getInstance();
        org.hibernate.Session session = dao.getSession();
        Session acadSession = null;
        if (this.getId() == null || this.getId() < 0L) {
            department = new Department();
            acadSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
            department.setSession(acadSession);
            department.setDistributionPrefPriority(0);
            acadSession.addToDepartments(department);
            department.setExternalStatusTypes(new HashSet<ExternalDepartmentStatusType>());
        } else {
            department = (Department)dao.get(this.getId(), session);
        }
        if (department != null) {
            if (this.isFullyEditable()) {
                department.setStatusType(this.getStatusType() == null || this.getStatusType().length() == 0 ? null : DepartmentStatusType.findByRef(this.getStatusType()));
                department.setName(this.getName());
                department.setDeptCode(this.getDeptCode());
                department.setAbbreviation(this.getAbbv());
                department.setExternalUniqueId(this.getExternalId());
                department.setDistributionPrefPriority(this.getDistPrefPriority());
                department.setExternalManager(this.getIsExternal());
                department.setExternalMgrLabel(this.getExtName());
                department.setExternalMgrAbbv(this.getExtAbbv());
                department.setAllowReqRoom(this.getAllowReqRoom());
                department.setAllowReqTime(this.getAllowReqTime());
                department.setAllowReqDistribution(this.getAllowReqDist());
                department.setAllowEvents(this.getAllowEvents());
                department.setAllowStudentScheduling(this.getAllowStudentScheduling());
                department.setInheritInstructorPreferences(this.getInheritInstructorPreferences());
            }
            ArrayList<ExternalDepartmentStatusType> statuses = new ArrayList<ExternalDepartmentStatusType>(department.getExternalStatusTypes());
            if (department.isExternalManager().booleanValue()) {
                for (int i = 0; i < Math.min(this.iDependentDepartments.size(), this.iDependentStatuses.size()); ++i) {
                    Long deptId = this.iDependentDepartments.get(i);
                    String status = this.iDependentStatuses.get(i);
                    if (deptId < 0L || status.isEmpty()) continue;
                    ExternalDepartmentStatusType t = null;
                    Iterator j = statuses.iterator();
                    while (j.hasNext()) {
                        ExternalDepartmentStatusType x = (ExternalDepartmentStatusType)j.next();
                        if (!deptId.equals(x.getDepartment().getUniqueId())) continue;
                        j.remove();
                        t = x;
                        break;
                    }
                    if (t == null) {
                        t = new ExternalDepartmentStatusType();
                        t.setExternalDepartment(department);
                        t.setDepartment((Department)DepartmentDAO.getInstance().get(deptId));
                        department.getExternalStatusTypes().add(t);
                    }
                    t.setStatusType(DepartmentStatusType.findByRef(status));
                }
            }
            for (ExternalDepartmentStatusType t : statuses) {
                department.getExternalStatusTypes().remove(t);
                session.remove((Object)t);
            }
            if (department.getUniqueId() == null) {
                session.persist((Object)department);
            } else {
                session.merge((Object)department);
            }
            ChangeLog.addChange(session, context, department, ChangeLog.Source.DEPARTMENT_EDIT, this.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, department);
            this.setId(department.getUniqueId());
            session.flush();
            if (acadSession != null) {
                session.refresh((Object)acadSession);
            }
        }
    }

    public boolean isFullyEditable() {
        return this.iFullyEditable;
    }

    public void setFullyEditable(boolean fullyEditable) {
        this.iFullyEditable = fullyEditable;
    }
}

