/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.CourseOffering;

public class CrossListsModifyForm
implements UniTimeForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 3638385556572422628L;
    private String op;
    private Long subjectAreaId;
    private Long instrOfferingId;
    private Long addCourseOfferingId;
    private Long ctrlCrsOfferingId;
    private String instrOfferingName;
    private Boolean ownedInstrOffr;
    private List<Long> originalOfferings;
    private List<Long> courseOfferingIds;
    private List<String> courseOfferingNames;
    private List<Boolean> ownedCourse;
    private List<String> resvId;
    private List<Integer> limits;
    private List<Integer> requested;
    private List<Integer> projected;
    private List<Integer> lastTerm;
    private List<Boolean> canDelete;
    private Integer ioLimit;
    private Boolean unlimited;
    private Long readOnlyCrsOfferingId;

    public CrossListsModifyForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.op.equals(MSG.actionAddCourseToCrossList()) && (this.addCourseOfferingId == null || this.addCourseOfferingId.intValue() <= 0)) {
            action.addFieldError("form.addCourseOfferingId", MSG.errorRequiredCourseOffering());
        }
        if (this.op.equals(MSG.actionUpdateCrossLists()) && (this.ctrlCrsOfferingId == null || this.ctrlCrsOfferingId.intValue() <= 0)) {
            action.addFieldError("form.ctrlCrsOfferingId", MSG.errorRequiredControllingCourse());
        }
    }

    @Override
    public void reset() {
        this.subjectAreaId = null;
        this.instrOfferingId = null;
        this.ctrlCrsOfferingId = null;
        this.readOnlyCrsOfferingId = null;
        this.instrOfferingName = null;
        this.originalOfferings = new ArrayList<Long>();
        this.courseOfferingIds = new ArrayList<Long>();
        this.courseOfferingNames = new ArrayList<String>();
        this.ownedCourse = new ArrayList<Boolean>();
        this.resvId = new ArrayList<String>();
        this.limits = new ArrayList<Integer>();
        this.requested = new ArrayList<Integer>();
        this.projected = new ArrayList<Integer>();
        this.lastTerm = new ArrayList<Integer>();
        this.canDelete = new ArrayList<Boolean>();
        this.ioLimit = null;
        this.unlimited = null;
    }

    public List<Long> getOriginalOfferings() {
        return this.originalOfferings;
    }

    public Long getOriginalOfferings(int key) {
        return this.originalOfferings.get(key);
    }

    public void setOriginalOfferings(int key, Long value) {
        this.originalOfferings.set(key, value);
    }

    public void setOriginalOfferings(List<Long> courseOfferingIds) {
        this.originalOfferings = courseOfferingIds;
    }

    public List<Long> getCourseOfferingIds() {
        return this.courseOfferingIds;
    }

    public Long getCourseOfferingIds(int key) {
        return this.courseOfferingIds.get(key);
    }

    public void setCourseOfferingIds(int key, Long value) {
        this.courseOfferingIds.set(key, value);
    }

    public void setCourseOfferingIds(List<Long> courseOfferingIds) {
        this.courseOfferingIds = courseOfferingIds;
    }

    public List<String> getCourseOfferingNames() {
        return this.courseOfferingNames;
    }

    public String getCourseOfferingNames(int key) {
        return this.courseOfferingNames.get(key).toString();
    }

    public void setCourseOfferingNames(int key, String value) {
        this.courseOfferingNames.set(key, value);
    }

    public void setCourseOfferingNames(List<String> courseOfferingNames) {
        this.courseOfferingNames = courseOfferingNames;
    }

    public List<Boolean> getOwnedCourse() {
        return this.ownedCourse;
    }

    public Boolean getOwnedCourse(int key) {
        return this.ownedCourse.get(key);
    }

    public void setOwnedCourse(int key, Boolean value) {
        this.ownedCourse.set(key, value);
    }

    public void setOwnedCourse(List<Boolean> ownedCourse) {
        this.ownedCourse = ownedCourse;
    }

    public List<Integer> getLimits() {
        return this.limits;
    }

    public Integer getLimits(int key) {
        return this.limits.get(key);
    }

    public void setLimits(int key, Integer value) {
        this.limits.set(key, value);
    }

    public void setLimits(List<Integer> limits) {
        this.limits = limits;
    }

    public List<String> getResvId() {
        return this.resvId;
    }

    public String getResvId(int key) {
        return this.resvId.get(key).toString();
    }

    public void setResvId(int key, String value) {
        this.resvId.set(key, value);
    }

    public void setResvId(List<String> resvId) {
        this.resvId = resvId;
    }

    public List<Integer> getRequested() {
        return this.requested;
    }

    public Integer getRequested(int key) {
        return this.requested.get(key);
    }

    public void setRequested(int key, Integer value) {
        this.requested.set(key, value);
    }

    public void setRequested(List<Integer> requested) {
        this.requested = requested;
    }

    public List<Integer> getProjected() {
        return this.projected;
    }

    public Integer getProjected(int key) {
        return this.projected.get(key);
    }

    public void setProjected(int key, Integer value) {
        this.projected.set(key, value);
    }

    public void setProjected(List<Integer> projected) {
        this.projected = projected;
    }

    public List<Integer> getLastTerm() {
        return this.lastTerm;
    }

    public Integer getLastTerm(int key) {
        return this.lastTerm.get(key);
    }

    public void setLastTerm(int key, Integer value) {
        this.lastTerm.set(key, value);
    }

    public void setLastTerm(List<Integer> lastTerm) {
        this.lastTerm = lastTerm;
    }

    public List<Boolean> getCanDelete() {
        return this.canDelete;
    }

    public Boolean getCanDelete(int key) {
        return this.canDelete.get(key);
    }

    public void setCanDelete(int key, Boolean value) {
        this.canDelete.set(key, value);
    }

    public void setCanDelete(List<Boolean> canDelete) {
        this.canDelete = canDelete;
    }

    public Long getCtrlCrsOfferingId() {
        return this.ctrlCrsOfferingId;
    }

    public void setCtrlCrsOfferingId(Long ctrlCrsOfferingId) {
        this.ctrlCrsOfferingId = ctrlCrsOfferingId;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Long getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Long subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public Long getAddCourseOfferingId() {
        return this.addCourseOfferingId;
    }

    public void setAddCourseOfferingId(Long addCourseOfferingId) {
        this.addCourseOfferingId = addCourseOfferingId;
    }

    public Long getReadOnlyCrsOfferingId() {
        return this.readOnlyCrsOfferingId;
    }

    public void setReadOnlyCrsOfferingId(Long readOnlyCrsOfferingId) {
        this.readOnlyCrsOfferingId = readOnlyCrsOfferingId;
    }

    public Boolean getOwnedInstrOffr() {
        return this.ownedInstrOffr;
    }

    public void setOwnedInstrOffr(Boolean ownedInstrOffr) {
        this.ownedInstrOffr = ownedInstrOffr;
    }

    public Integer getIoLimit() {
        return this.ioLimit;
    }

    public void setIoLimit(Integer ioLimit) {
        this.ioLimit = ioLimit;
    }

    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public void addToOriginalCourseOfferings(CourseOffering co) {
        this.originalOfferings.add(co.getUniqueId());
    }

    public void addToCourseOfferings(CourseOffering co, Boolean isOwner, Boolean canDelete) {
        this.courseOfferingIds.add(co.getUniqueId());
        this.courseOfferingNames.add(co.getCourseNameWithTitle());
        this.ownedCourse.add(isOwner);
        this.resvId.add("");
        this.limits.add(co.getReservation());
        this.requested.add(null);
        this.projected.add(co.getProjectedDemand());
        this.lastTerm.add(co.getDemand());
        this.canDelete.add(canDelete);
    }

    public void removeFromCourseOfferings(Long courseOfferingId) {
        int ct = 0;
        Iterator<Long> i = this.courseOfferingIds.iterator();
        while (i.hasNext()) {
            Long co1 = i.next();
            if (co1.equals(courseOfferingId)) {
                i.remove();
                this.courseOfferingNames.remove(ct);
                this.ownedCourse.remove(ct);
                this.resvId.remove(ct);
                this.limits.remove(ct);
                this.requested.remove(ct);
                this.projected.remove(ct);
                this.lastTerm.remove(ct);
                this.canDelete.remove(ct);
                break;
            }
            ++ct;
        }
    }

    public int getIndex(Long courseOfferingId) {
        for (int i = 0; i < this.courseOfferingIds.size(); ++i) {
            Long co1 = this.courseOfferingIds.get(i);
            if (!co1.equals(courseOfferingId)) continue;
            return i;
        }
        return -1;
    }
}

