/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.util.Formats;

public class LocaleFilter
implements Filter {
    private boolean iUseBrowserSettings;

    public void init(FilterConfig fc) throws ServletException {
        this.iUseBrowserSettings = "true".equals(fc.getInitParameter("use-browser-settings"));
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        try {
            if (req instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)req;
                String locale = null;
                if (this.iUseBrowserSettings) {
                    locale = request.getHeader("Accept-Language");
                }
                if (req.getParameter("locale") != null) {
                    locale = req.getParameter("locale");
                    request.getSession().setAttribute("unitime.locale", (Object)locale);
                } else if (request.getSession().getAttribute("unitime.locale") != null) {
                    locale = (String)request.getSession().getAttribute("unitime.locale");
                }
                if (locale == null) {
                    locale = ApplicationProperty.Locale.value();
                    UserContext user = this.getUser();
                    if (user != null) {
                        locale = user.getProperty(ApplicationProperty.Locale.key(), locale);
                    }
                }
                Localization.setLocale(locale);
            }
            chain.doFilter(req, resp);
        }
        finally {
            Localization.removeLocale();
            Formats.removeFormats();
        }
    }

    public void destroy() {
    }
}

