/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.solver;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.solver.TableExporter;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

@Service(value="org.unitime.timetable.export.Exporter:solution-reports.csv")
public class ExportSolutionReportsCSV
extends TableExporter {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public String reference() {
        return "solution-reports.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        String tableId = helper.getParameter("table");
        GwtRpcImplementation service = (GwtRpcImplementation)this.applicationContext.getBean(CourseTimetablingSolverInterface.SolverReportsRequest.class.getName());
        CourseTimetablingSolverInterface.SolverReportsRequest request = new CourseTimetablingSolverInterface.SolverReportsRequest();
        CourseTimetablingSolverInterface.SolverReportsResponse response = (CourseTimetablingSolverInterface.SolverReportsResponse)service.execute(request, helper.getSessionContext());
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        boolean first = true;
        if (response.hasTables()) {
            for (TableInterface table : response.getTables()) {
                if (tableId != null && !tableId.equals(table.getTableId())) continue;
                if (!first) {
                    out.printLine(new String[0]);
                    out.printLine(new String[0]);
                } else {
                    first = false;
                }
                if (table.hasName()) {
                    out.printLine(table.getName());
                }
                this.sort(table, helper);
                String[] header = new String[table.getHeader().length];
                for (int i = 0; i < table.getHeader().length; ++i) {
                    header[i] = table.getHeader(i).getName().replace("<br>", "\n");
                }
                out.printHeader(header);
                out.flush();
                for (TableInterface.TableRowInterface row : table.getRows()) {
                    String[] line = new String[row.getNrCells()];
                    for (int i = 0; i < row.getNrCells(); ++i) {
                        line[i] = this.convertCSV(row.getCell(i));
                    }
                    out.printLine(line);
                }
                if (table.hasColumnDescriptions()) {
                    out.printLine(new String[0]);
                    for (TableInterface.TableHeaderIterface h : table.getHeader()) {
                        if (!h.hasDescription()) continue;
                        out.printLine(h.getName(), h.getDescription());
                    }
                }
                out.flush();
            }
        }
        out.close();
    }
}

