/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.hql;

import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.export.BufferedPrinter;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SavedHQLException;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.AccessDeniedException;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:hql-report.csv")
public class SavedHqlExportToCSV
implements Exporter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Log sLog = LogFactory.getLog(SavedHqlExportToCSV.class);

    @Override
    public String reference() {
        return "hql-report.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getAcademicSessionId());
        context.checkPermission(helper.getAcademicSessionId(), Right.HQLReports);
        String report = helper.getParameter("report");
        if (report == null) {
            throw new IllegalArgumentException("No report provided, please set the report parameter.");
        }
        SavedHQL hql = null;
        try {
            hql = (SavedHQL)SavedHQLDAO.getInstance().get(Long.valueOf(report));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (hql == null) {
            hql = (SavedHQL)SavedHQLDAO.getInstance().getSession().createQuery("from SavedHQL where name = :name", SavedHQL.class).setParameter("name", (Object)report).setMaxResults(1).uniqueResult();
        }
        if (hql == null) {
            throw new IllegalArgumentException("Report " + report + " does not exist.");
        }
        ArrayList<SavedHQLInterface.IdValue> params = new ArrayList<SavedHQLInterface.IdValue>();
        if (helper.getParameter("params") != null) {
            String[] p = helper.getParameter("params").split(":");
            int i = 0;
            for (SavedHQL.Option o : SavedHQL.Option.values()) {
                if (!o.allowSingleSelection() && !o.allowMultiSelection() || !hql.getQuery().contains("%" + o.name() + "%")) continue;
                SavedHQLInterface.IdValue v = new SavedHQLInterface.IdValue();
                v.setValue(o.name());
                v.setText((String)(i < p.length ? p[i] : ""));
                params.add(v);
                ++i;
            }
        }
        for (SavedHQL.Option option : SavedHQL.Option.values()) {
            SavedHQLInterface.IdValue v;
            if (!hql.getQuery().contains("%" + option.name() + "%")) continue;
            if (option.allowMultiSelection()) {
                String[] values = helper.getParameterValues(option.name());
                if (values == null || values.length <= 0) continue;
                v = new SavedHQLInterface.IdValue();
                v.setValue(option.name());
                Object text = "";
                for (String value : values) {
                    Long id = option.lookupValue(context.getUser(), value);
                    if (id == null) {
                        try {
                            id = Long.valueOf(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (id == null) continue;
                    text = (String)text + (((String)text).isEmpty() ? "" : ",") + id;
                }
                v.setText((String)text);
                params.add(v);
                continue;
            }
            String value = helper.getParameter(option.name());
            if (value == null) continue;
            v = new SavedHQLInterface.IdValue();
            v.setValue(option.name());
            Long id = option.lookupValue(context.getUser(), value);
            if (id == null) {
                try {
                    id = Long.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            v.setText(id == null ? "" : id.toString());
            params.add(v);
        }
        for (SavedHQLParameter p : hql.getParameters()) {
            SavedHQLInterface.IdValue v = new SavedHQLInterface.IdValue();
            v.setValue(p.getName());
            String value = helper.getParameter(p.getName());
            v.setText(value == null ? p.getDefaultValue() : value);
            params.add(v);
        }
        boolean hasAppearancePermission = false;
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (!hql.isSet(flag)) continue;
            if (flag.getAppearance() != null && !hasAppearancePermission && (flag.getPermission() == null || context.hasPermission(flag.getPermission()))) {
                hasAppearancePermission = true;
            }
            if (flag.getAppearance() != null || flag.getPermission() == null) continue;
            context.checkPermission(flag.getPermission());
        }
        if (!hasAppearancePermission) {
            throw new AccessDeniedException();
        }
        BufferedPrinter out = new BufferedPrinter(new CSVPrinter(helper, false));
        helper.setup(out.getContentType(), hql.getName().replace('/', '-').replace('\\', '-').replace(':', '-') + ".csv", false);
        SavedHqlExportToCSV.execute(context.getUser(), out, hql.getQuery(), params, 0, -1, hql.getParameters());
        String sort = helper.getParameter("sort");
        if (sort != null && !"0".equals(sort)) {
            final boolean asc = Integer.parseInt(sort) > 0;
            final int col = Math.abs(Integer.parseInt(sort)) - 1;
            Collections.sort(out.getBuffer(), new Comparator<String[]>(){

                int compare(String[] a, String[] b, int col2) {
                    for (int i = 0; i < a.length; ++i) {
                        int c = (col2 + i) % a.length;
                        try {
                            int cmp = Double.valueOf(a[c] == null ? "0" : a[c]).compareTo(Double.valueOf(b[c] == null ? "0" : b[c]));
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        catch (NumberFormatException e) {
                            int cmp = (a[c] == null ? "" : a[c]).compareTo(b[c] == null ? "" : b[c]);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                    }
                    return 0;
                }

                @Override
                public int compare(String[] a, String[] b) {
                    return asc ? this.compare(a, b, col) : this.compare(b, a, col);
                }
            });
        }
        out.close();
    }

    public static void execute(UserContext user, Exporter.Printer out, String hql, List<SavedHQLInterface.IdValue> options, int fromRow, int maxRows, Collection<SavedHQLParameter> parameters) throws SavedHQLException, PageAccessException {
        try {
            Object value;
            for (SavedHQL.Option option : SavedHQL.Option.values()) {
                if (hql.indexOf("%" + option.name() + "%") < 0) continue;
                value = null;
                for (SavedHQLInterface.IdValue idValue : options) {
                    if (!option.name().equals(idValue.getValue())) continue;
                    value = idValue.getText();
                    break;
                }
                if (value == null || ((String)value).isEmpty()) {
                    Map<Long, String> vals = option.values(user);
                    if (vals == null || vals.isEmpty()) {
                        throw new SavedHQLException(MESSAGES.errorUnableToSetParameterNoValues(option.name()));
                    }
                    value = "";
                    for (Long id : vals.keySet()) {
                        if (!((String)value).isEmpty()) {
                            value = (String)value + ",";
                        }
                        value = (String)value + id.toString();
                        if (option.allowMultiSelection()) continue;
                        break;
                    }
                }
                hql = hql.replace("%" + option.name() + "%", "(" + (String)value + ")");
            }
            if (hql.indexOf("%USER%") >= 0) {
                hql = hql.replace("%USER%", "'" + HibernateUtil.escapeSql(user.getExternalUserId()) + "'");
            }
            org.hibernate.Session hibSession = SavedHQLDAO.getInstance().getSession();
            Query q = hibSession.createQuery(hql, Tuple.class);
            if (maxRows > 0) {
                q.setMaxResults(maxRows);
            }
            if (fromRow > 0) {
                q.setFirstResult(fromRow);
            }
            q.setCacheable(true);
            if (parameters != null && !parameters.isEmpty()) {
                block11: for (SavedHQLParameter savedHQLParameter : parameters) {
                    SavedHQL.Option[] dateFormat;
                    value = savedHQLParameter.getDefaultValue();
                    for (SavedHQLInterface.IdValue idValue : options) {
                        if (!savedHQLParameter.getName().equals(idValue.getValue())) continue;
                        value = idValue.getText();
                        break;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("boolean")) {
                        q.setParameter(savedHQLParameter.getName(), value == null ? null : Boolean.valueOf("true".equalsIgnoreCase((String)value)));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("long")) {
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : Long.valueOf((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("int") || savedHQLParameter.getType().equalsIgnoreCase("integer") || savedHQLParameter.getType().equalsIgnoreCase("slot") || savedHQLParameter.getType().equalsIgnoreCase("time")) {
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : Integer.valueOf((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("double")) {
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : Double.valueOf((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("float")) {
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : Float.valueOf((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("short")) {
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : Short.valueOf((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("byte")) {
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : Byte.valueOf((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("date")) {
                        dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : dateFormat.parse((String)value));
                        continue;
                    }
                    if (savedHQLParameter.getType().equalsIgnoreCase("datetime") || savedHQLParameter.getType().equalsIgnoreCase("timestamp")) {
                        dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
                        q.setParameter(savedHQLParameter.getName(), value == null || ((String)value).isEmpty() ? null : dateFormat.parse((String)value));
                        continue;
                    }
                    for (SavedHQL.Option option : SavedHQL.Option.values()) {
                        if (!savedHQLParameter.getType().equalsIgnoreCase(option.name())) continue;
                        if (option.allowMultiSelection()) {
                            ArrayList<Long> ids = new ArrayList<Long>();
                            if (value != null && !((String)value).isEmpty()) {
                                for (String idStr : ((String)value).split(",")) {
                                    try {
                                        ids.add(Long.parseLong(idStr));
                                    }
                                    catch (NumberFormatException e) {
                                        Long id = option.lookupValue(user, idStr);
                                        if (id == null) continue;
                                        ids.add(id);
                                    }
                                }
                            } else {
                                Map<Long, String> vals = option.values(user);
                                if (vals != null) {
                                    ids.addAll(vals.keySet());
                                }
                            }
                            q.setParameterList(savedHQLParameter.getName(), ids);
                            continue block11;
                        }
                        Long id = null;
                        try {
                            id = Long.parseLong((String)value);
                        }
                        catch (NumberFormatException e) {
                            id = option.lookupValue(user, (String)value);
                        }
                        q.setParameter(savedHQLParameter.getName(), (Object)(id == null ? -1L : id));
                        continue block11;
                    }
                    q.setParameter(savedHQLParameter.getName(), value);
                }
            }
            int len = -1;
            for (Tuple o : q.list()) {
                String[] line;
                if (len < 0) {
                    len = SavedHqlExportToCSV.length(o);
                    line = new String[len];
                    SavedHqlExportToCSV.header(line, o);
                    if (line.length > 0 && line[0].startsWith("__")) {
                        out.hideColumn(0);
                    }
                    out.printHeader(line);
                }
                line = new String[len];
                SavedHqlExportToCSV.line(line, o);
                out.printLine(line);
                out.flush();
            }
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (SavedHQLException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            for (Throwable f = e; f != null; f = f.getCause()) {
                SQLException sQLException;
                if (f instanceof JDBCException && (sQLException = ((JDBCException)f).getSQLException()) != null && sQLException.getMessage() != null && !sQLException.getMessage().isEmpty()) {
                    message = sQLException.getMessage();
                    break;
                }
                if (f instanceof HibernateException) {
                    message = f.getMessage();
                }
                if (!(f instanceof IllegalArgumentException)) continue;
                message = f.getMessage();
            }
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SavedHQLException(message);
        }
    }

    private static boolean skip(Attribute t) {
        try {
            Class<?> ts = t.getJavaType().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static int length(Tuple o) {
        if (o == null) {
            return 1;
        }
        int len = 0;
        for (TupleElement te : o.getElements()) {
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (et == null) {
                ++len;
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (SavedHqlExportToCSV.skip(sa)) continue;
                ++len;
            }
        }
        return len;
    }

    private static String format(String column) {
        if (column == null || column.isEmpty()) {
            return "?";
        }
        return column.substring(0, 1).toUpperCase() + column.substring(1);
    }

    private static void header(String[] ret, Tuple o) {
        int idx = 0;
        for (TupleElement te : o.getElements()) {
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (et == null) {
                if (te.getAlias() == null || te.getAlias().isEmpty()) {
                    if (o.getElements().size() == 1) {
                        ret[idx++] = "Result";
                        continue;
                    }
                    ret[idx++] = "Column" + (idx + 1);
                    continue;
                }
                ret[idx++] = te.getAlias();
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (SavedHqlExportToCSV.skip(sa)) continue;
                ret[idx++] = SavedHqlExportToCSV.format(sa.getName());
            }
        }
    }

    private static String toString(Object o) {
        if (o != null && o instanceof Document) {
            return ((Document)o).asXML();
        }
        return o == null ? "" : o.toString();
    }

    private static void line(String[] ret, Tuple o) {
        int idx = 0;
        for (TupleElement te : o.getElements()) {
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Object x = o.get(te);
            if (et == null) {
                ret[idx++] = SavedHqlExportToCSV.toString(x);
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (SavedHqlExportToCSV.skip(sa)) continue;
                try {
                    ret[idx++] = SavedHqlExportToCSV.toString(((Method)sa.getJavaMember()).invoke(x, new Object[0]));
                }
                catch (Exception e) {
                    ret[idx++] = "";
                }
            }
        }
    }

    static class AttributeComparator
    implements Comparator<Attribute> {
        AttributeComparator() {
        }

        @Override
        public int compare(Attribute a1, Attribute a2) {
            boolean id2;
            boolean id1 = a1 instanceof SingularAttribute && ((SingularAttribute)a1).isId();
            boolean bl = id2 = a2 instanceof SingularAttribute && ((SingularAttribute)a2).isId();
            if (id1 != id2) {
                return id1 ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

