/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.XLSPrinter;
import org.unitime.timetable.export.courses.OfferingsCSV;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;

@Service(value="org.unitime.timetable.export.Exporter:offerings.xls")
public class OfferingsXLS
extends OfferingsCSV {
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public String reference() {
        return "offerings.xls";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.checkPermission(helper, Right.InstructionalOfferingsExportPDF);
        this.exportDataXls(this.getOfferings(helper), helper);
    }

    protected void exportDataXls(List<TableInterface> response, ExportHelper helper) throws IOException {
        XLSPrinter printer = new XLSPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), this.reference(), false);
        boolean first = true;
        for (TableInterface table : response) {
            if (!first) {
                printer.newSheet();
            }
            printer.getWorkbook().setSheetName(printer.getSheetIndex(), table.getName());
            first = false;
            if (table.getHeader() != null) {
                for (TableInterface.LineInterface line : table.getHeader()) {
                    printer.printHeader(this.toLine(line));
                }
            }
            if (table.getLines() == null) continue;
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(this.toA(line, false));
            }
        }
        printer.flush();
        printer.close();
    }

    protected PDFPrinter.A[] toA(TableInterface.LineInterface line, boolean header) {
        ArrayList<PDFPrinter.A> ret = new ArrayList<PDFPrinter.A>();
        if (line.hasCells()) {
            for (TableInterface.CellInterface cell : line.getCells()) {
                PDFPrinter.A a = this.toA(cell, line, null, 0);
                if (!a.hasChunks() && (a.getText() == null || a.getText().isEmpty())) {
                    a.setText(" ");
                }
                if (header) {
                    a.bold();
                }
                ret.add(a);
            }
        }
        return ret.toArray(new PDFPrinter.A[0]);
    }

    protected void applyStyle(PDFPrinter.A a, String styles) {
        for (String style : styles.split(";")) {
            if (style.indexOf(58) < 0) continue;
            String key = style.substring(0, style.indexOf(58)).trim();
            String value = style.substring(style.indexOf(58) + 1).trim();
            if ("font-weight".equalsIgnoreCase(key) && "bold".equalsIgnoreCase(value)) {
                a.bold();
                continue;
            }
            if ("font-style".equalsIgnoreCase(key) && "italic".equalsIgnoreCase(value)) {
                a.italic();
                continue;
            }
            if ("color".equalsIgnoreCase(key) && !"inherit".equals(value)) {
                a.setColor(value);
                continue;
            }
            if (!"background".equalsIgnoreCase(key)) continue;
            a.setBackground(value);
        }
    }

    protected PDFPrinter.A createCell(TableInterface.CellInterface cell) {
        return new PDFPrinter.A();
    }

    protected PDFPrinter.A toA(TableInterface.CellInterface cell, TableInterface.LineInterface line, PDFPrinter.A parent, int index) {
        int i;
        PDFPrinter.A a = this.createCell(cell);
        if (cell.hasWidth()) {
            a.setWidth(cell.getWidth());
        }
        a.inline();
        if (parent != null && !cell.isInline() && index > 0) {
            parent.clear(PDFPrinter.F.INLINE);
        }
        if (parent != null && parent.has(PDFPrinter.F.BOLD)) {
            a.bold();
        }
        if (parent != null && parent.has(PDFPrinter.F.ITALIC)) {
            a.italic();
        }
        if (parent != null && parent.getColorValue() != null) {
            a.setColor(parent.getColor());
        }
        if (parent == null && !cell.hasNoWrap()) {
            a.wrap();
        }
        a.setColSpan(cell.getColSpan());
        a.setRowSpan(cell.getRowSpan());
        if (cell.hasColor()) {
            a.color(cell.getColor());
        }
        if (parent == null) {
            if (line.hasBgColor()) {
                a.setBackground(line.getBgColor());
            }
            if (line.hasStyle()) {
                this.applyStyle(a, line.getStyle());
            }
        }
        if (cell.hasStyle()) {
            this.applyStyle(a, cell.getStyle());
        }
        if (cell.getTextAlignment() == TableInterface.CellInterface.Alignment.CENTER) {
            a.center();
        } else if (cell.getTextAlignment() == TableInterface.CellInterface.Alignment.RIGHT) {
            a.right();
        }
        if (a.getImage() == null) {
            if (cell.hasAria()) {
                a.setText(cell.getAria());
            } else if (cell.hasText() && !cell.isHtml()) {
                a.setText(cell.getText());
            } else if (cell.hasTitle()) {
                a.setText(cell.getTitle());
            } else if (cell.hasImage() && cell.getImage().hasTitle()) {
                a.setText(cell.getImage().getTitle());
            }
        }
        if (cell.hasIndent()) {
            for (i = 0; i < cell.getIndent(); ++i) {
                a.setText("  " + (a.getText() == null ? "" : a.getText()));
            }
        }
        if (cell.hasItems() && a.getImage() == null && !cell.hasAria()) {
            i = 0;
            for (TableInterface.CellInterface c : cell.getItems()) {
                a.add(this.toA(c, line, a, i++));
            }
        }
        return a;
    }
}

