/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.AdvisorClassPref;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorInstrMthPref;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class StudentSectioningExport
extends BaseExport {
    protected static Formats.Format<Number> sTwoNumbersDF = Formats.getNumberFormat("00");
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected DecimalFormat iCreditDF = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("request");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            document.addDocType("request", "-//UniTime//UniTime Student Sectioning DTD/EN", "http://www.unitime.org/interface/StudentSectioning.dtd");
            for (Student student : this.getHibSession().createQuery("select s from Student s where s.session.uniqueId = :sessionId", Student.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                String extId;
                Element acadAreaEl;
                Element studentEl = root.addElement("student");
                studentEl.addAttribute("key", student.getExternalUniqueId() == null || student.getExternalUniqueId().isEmpty() ? student.getUniqueId().toString() : student.getExternalUniqueId());
                if (student.getSectioningStatus() != null) {
                    studentEl.addAttribute("status", student.getSectioningStatus().getReference());
                }
                Element demographicsEl = studentEl.addElement("updateDemographics");
                Element nameEl = demographicsEl.addElement("name");
                if (student.getFirstName() != null) {
                    nameEl.addAttribute("first", student.getFirstName());
                }
                if (student.getMiddleName() != null) {
                    nameEl.addAttribute("middle", student.getMiddleName());
                }
                if (student.getLastName() != null) {
                    nameEl.addAttribute("last", student.getLastName());
                }
                for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
                    acadAreaEl = demographicsEl.addElement("acadArea");
                    acadAreaEl.addAttribute("abbv", studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation());
                    acadAreaEl.addAttribute("classification", studentAreaClassificationMajor.getAcademicClassification().getCode());
                    Element majorEl = acadAreaEl.addElement("major").addAttribute("code", studentAreaClassificationMajor.getMajor().getCode());
                    if (studentAreaClassificationMajor.getConcentration() != null) {
                        majorEl.addAttribute("concentration", studentAreaClassificationMajor.getConcentration().getCode());
                    }
                    if (studentAreaClassificationMajor.getDegree() != null) {
                        majorEl.addAttribute("degree", studentAreaClassificationMajor.getDegree().getReference());
                    }
                    if (studentAreaClassificationMajor.getProgram() != null) {
                        majorEl.addAttribute("program", studentAreaClassificationMajor.getProgram().getReference());
                    }
                    if (studentAreaClassificationMajor.getCampus() != null) {
                        majorEl.addAttribute("campus", studentAreaClassificationMajor.getCampus().getReference());
                    }
                    if (studentAreaClassificationMajor.getWeight() == null || studentAreaClassificationMajor.getWeight() == 1.0) continue;
                    majorEl.addAttribute("weight", studentAreaClassificationMajor.getWeight().toString());
                }
                for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                    acadAreaEl = demographicsEl.addElement("acadArea");
                    acadAreaEl.addAttribute("abbv", studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation());
                    acadAreaEl.addAttribute("classification", studentAreaClassificationMinor.getAcademicClassification().getCode());
                    acadAreaEl.addElement("minor").addAttribute("code", studentAreaClassificationMinor.getMinor().getCode());
                }
                for (StudentGroup studentGroup : student.getGroups()) {
                    demographicsEl.addElement("groupAffiliation").addAttribute("code", studentGroup.getGroupAbbreviation());
                }
                for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
                    demographicsEl.addElement("disability").addAttribute("code", studentAccomodation.getAbbreviation());
                }
                if (student.getMinCredit() != null) {
                    demographicsEl.addAttribute("minCredit", this.iCreditDF.format(student.getMinCredit()));
                }
                if (student.getMaxCredit() != null) {
                    demographicsEl.addAttribute("maxCredit", this.iCreditDF.format(student.getMaxCredit()));
                }
                Element requestsEl = studentEl.addElement("updateCourseRequests").addAttribute("commit", "true");
                for (CourseDemand cd : new TreeSet<CourseDemand>(student.getCourseDemands())) {
                    if (cd.getFreeTime() != null) {
                        Element freeTimeEl = requestsEl.addElement("freeTime");
                        Object days = "";
                        for (int i = 0; i < Constants.DAY_NAMES_SHORT.length; ++i) {
                            if ((cd.getFreeTime().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                            days = (String)days + Constants.DAY_NAMES_SHORT[i];
                        }
                        freeTimeEl.addAttribute("days", (String)days);
                        freeTimeEl.addAttribute("startTime", StudentSectioningExport.startSlot2startTime(cd.getFreeTime().getStartSlot()));
                        freeTimeEl.addAttribute("endTime", StudentSectioningExport.startSlot2startTime(cd.getFreeTime().getStartSlot() + cd.getFreeTime().getLength()));
                        freeTimeEl.addAttribute("length", String.valueOf(Constants.SLOT_LENGTH_MIN * cd.getFreeTime().getLength()));
                    }
                    if (cd.getCourseRequests().isEmpty()) continue;
                    Element courseOfferingEl = null;
                    boolean first = true;
                    for (CourseRequest cr : new TreeSet<CourseRequest>(cd.getCourseRequests())) {
                        courseOfferingEl = courseOfferingEl == null ? requestsEl.addElement("courseOffering") : courseOfferingEl.addElement("alternative");
                        courseOfferingEl.addAttribute("subjectArea", cr.getCourseOffering().getSubjectAreaAbbv());
                        courseOfferingEl.addAttribute("courseNumber", cr.getCourseOffering().getCourseNbr());
                        if (first && cd.isWaitlist().booleanValue()) {
                            courseOfferingEl.addAttribute("waitlist", "true");
                        }
                        if (first && cd.getNoSub() != null && cd.getNoSub().booleanValue()) {
                            courseOfferingEl.addAttribute("nosub", "true");
                        }
                        if (first && cd.isAlternative().booleanValue()) {
                            courseOfferingEl.addAttribute("alternative", "true");
                        }
                        if (first && cd.getCritical() != null) {
                            courseOfferingEl.addAttribute("critical", CourseDemand.Critical.values()[cd.getCritical()].name().toLowerCase());
                        }
                        if (first && cd.getCriticalOverride() != null) {
                            courseOfferingEl.addAttribute("criticalOverride", CourseDemand.Critical.values()[cd.getCriticalOverride()].name().toLowerCase());
                        }
                        if (cr.getCredit() != null && cr.getCredit() != 0) {
                            courseOfferingEl.addAttribute("credit", String.valueOf(cr.getCredit()));
                        }
                        if (first && cd.getWaitlistedTimeStamp() != null) {
                            courseOfferingEl.addAttribute("waitlisted", sDateFormat.format(cd.getWaitlistedTimeStamp()));
                        }
                        if (first && cd.getTimestamp() != null) {
                            courseOfferingEl.addAttribute("requested", sDateFormat.format(cd.getTimestamp()));
                        }
                        for (StudentClassEnrollment studentClassEnrollment : cr.getClassEnrollments()) {
                            Element classEl = courseOfferingEl.addElement("class");
                            Class_ clazz = studentClassEnrollment.getClazz();
                            extId = clazz.getExternalId(cr.getCourseOffering());
                            if (extId != null && !extId.isEmpty()) {
                                classEl.addAttribute("externalId", extId);
                            }
                            classEl.addAttribute("type", clazz.getSchedulingSubpart().getItypeDesc().trim());
                            classEl.addAttribute("suffix", this.getClassSuffix(clazz));
                            if (studentClassEnrollment.getTimestamp() == null) continue;
                            classEl.addAttribute("enrolled", sDateFormat.format(studentClassEnrollment.getTimestamp()));
                        }
                        if (cr.getPreferences() != null && !cr.getPreferences().isEmpty()) {
                            Element prefEl = courseOfferingEl.addElement("preferences");
                            for (StudentSectioningPref p : cr.getPreferences()) {
                                if (p instanceof StudentClassPref) {
                                    StudentClassPref scp = (StudentClassPref)p;
                                    Element classEl = prefEl.addElement("class");
                                    String extId2 = scp.getClazz().getExternalId(cr.getCourseOffering());
                                    if (extId2 != null && !extId2.isEmpty()) {
                                        classEl.addAttribute("externalId", extId2);
                                    }
                                    classEl.addAttribute("type", scp.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                                    classEl.addAttribute("suffix", this.getClassSuffix(scp.getClazz()));
                                    if (!scp.isRequired().booleanValue()) continue;
                                    classEl.addAttribute("required", "true");
                                    continue;
                                }
                                if (!(p instanceof StudentInstrMthPref)) continue;
                                StudentInstrMthPref imp = (StudentInstrMthPref)p;
                                Element imEl = prefEl.addElement("instructional-method");
                                imEl.addAttribute("externalId", imp.getInstructionalMethod().getReference());
                                imEl.addAttribute("name", imp.getInstructionalMethod().getLabel());
                                if (!imp.isRequired().booleanValue()) continue;
                                imEl.addAttribute("required", "true");
                            }
                        }
                        first = false;
                    }
                }
                Element element = studentEl.addElement("updateAdvisorRecommendations");
                Element recEl = null;
                for (AdvisorCourseRequest acr : new TreeSet<AdvisorCourseRequest>(student.getAdvisorCourseRequests())) {
                    Element acrEl = null;
                    if (acr.getPriority() == -1) {
                        if (acr.getNotes() != null) {
                            element.addAttribute("notes", acr.getNotes());
                        }
                        if (acr.getTimestamp() == null) continue;
                        element.addAttribute("recommended", sDateFormat.format(acr.getTimestamp()));
                        continue;
                    }
                    if (acr.getAlternative() == 0) {
                        recEl = element.addElement("recommendation");
                        if (acr.isSubstitute().booleanValue()) {
                            recEl.addAttribute("substitute", "true");
                        }
                        acrEl = recEl;
                    } else {
                        acrEl = recEl.addElement("alternative");
                    }
                    if (acr.getCredit() != null) {
                        acrEl.addAttribute("credit", acr.getCredit());
                    }
                    if (acr.getWaitlist() != null) {
                        acrEl.addAttribute("waitlist", acr.getWaitlist() != false ? "true" : "false");
                    }
                    if (acr.getNoSub() != null) {
                        acrEl.addAttribute("nosub", acr.getNoSub() != false ? "true" : "false");
                    }
                    if (acr.getNotes() != null) {
                        acrEl.addAttribute("notes", acr.getNotes());
                    }
                    if (acr.getCourse() != null) {
                        acrEl.addAttribute("course", acr.getCourse());
                    }
                    if (acr.getFreeTime() != null) {
                        void var18_34;
                        Element freeTimeEl = acrEl.addElement("freeTime");
                        Object days = "";
                        boolean bl = false;
                        while (var18_34 < Constants.DAY_NAMES_SHORT.length) {
                            if ((acr.getFreeTime().getDayCode() & Constants.DAY_CODES[var18_34]) != 0) {
                                days = (String)days + Constants.DAY_NAMES_SHORT[var18_34];
                            }
                            ++var18_34;
                        }
                        freeTimeEl.addAttribute("days", (String)days);
                        freeTimeEl.addAttribute("startTime", StudentSectioningExport.startSlot2startTime(acr.getFreeTime().getStartSlot()));
                        freeTimeEl.addAttribute("endTime", StudentSectioningExport.startSlot2startTime(acr.getFreeTime().getStartSlot() + acr.getFreeTime().getLength()));
                        freeTimeEl.addAttribute("length", String.valueOf(Constants.SLOT_LENGTH_MIN * acr.getFreeTime().getLength()));
                    }
                    if (acr.getTimestamp() != null) {
                        acrEl.addAttribute("recommended", sDateFormat.format(acr.getTimestamp()));
                    }
                    if (acr.getCourseOffering() == null) continue;
                    acrEl.addAttribute("subjectArea", acr.getCourseOffering().getSubjectAreaAbbv());
                    acrEl.addAttribute("courseNumber", acr.getCourseOffering().getCourseNbr());
                    if (acr.getCritical() != null) {
                        acrEl.addAttribute("critical", CourseDemand.Critical.values()[acr.getCritical()].name().toLowerCase());
                    }
                    if (acr.getPreferences() == null || acr.getPreferences().isEmpty()) continue;
                    Element prefEl = acrEl.addElement("preferences");
                    for (AdvisorSectioningPref advisorSectioningPref : acr.getPreferences()) {
                        if (advisorSectioningPref instanceof AdvisorClassPref) {
                            AdvisorClassPref scp = (AdvisorClassPref)advisorSectioningPref;
                            Element classEl = prefEl.addElement("class");
                            extId = scp.getClazz().getExternalId(acr.getCourseOffering());
                            if (extId != null && !extId.isEmpty()) {
                                classEl.addAttribute("externalId", extId);
                            }
                            classEl.addAttribute("type", scp.getClazz().getSchedulingSubpart().getItypeDesc().trim());
                            classEl.addAttribute("suffix", this.getClassSuffix(scp.getClazz()));
                            if (!scp.isRequired().booleanValue()) continue;
                            classEl.addAttribute("required", "true");
                            continue;
                        }
                        if (!(advisorSectioningPref instanceof AdvisorInstrMthPref)) continue;
                        AdvisorInstrMthPref imp = (AdvisorInstrMthPref)advisorSectioningPref;
                        Element imEl = prefEl.addElement("instructional-method");
                        imEl.addAttribute("externalId", imp.getInstructionalMethod().getReference());
                        imEl.addAttribute("name", imp.getInstructionalMethod().getLabel());
                        if (!imp.isRequired().booleanValue()) continue;
                        imEl.addAttribute("required", "true");
                    }
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    private static String startSlot2startTime(int startSlot) {
        int minHrs = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return sTwoNumbersDF.format(minHrs / 60) + sTwoNumbersDF.format(minHrs % 60);
    }
}

