/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentGroup;

public class StudentExport
extends BaseExport {
    protected DecimalFormat iCreditDF = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));

    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("students");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            document.addDocType("students", "-//UniTime//UniTime Students DTD/EN", "http://www.unitime.org/interface/Student.dtd");
            for (Student student : this.getHibSession().createQuery("select s from Student s where s.session.uniqueId = :sessionId", Student.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                Element studentEl = root.addElement("student");
                this.exportStudent(studentEl, student);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected void exportStudent(Element studentEl, Student student) {
        Element e;
        studentEl.addAttribute("externalId", student.getExternalUniqueId() == null || student.getExternalUniqueId().isEmpty() ? student.getUniqueId().toString() : student.getExternalUniqueId());
        if (student.getFirstName() != null) {
            studentEl.addAttribute("firstName", student.getFirstName());
        }
        if (student.getMiddleName() != null) {
            studentEl.addAttribute("middleName", student.getMiddleName());
        }
        if (student.getLastName() != null) {
            studentEl.addAttribute("lastName", student.getLastName());
        }
        if (student.getEmail() != null) {
            studentEl.addAttribute("email", student.getEmail());
        }
        if (!student.getAreaClasfMajors().isEmpty() || !student.getGroups().isEmpty()) {
            e = studentEl.addElement("studentAcadAreaClass");
            HashSet<CallSite> ac = new HashSet<CallSite>();
            for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
                if (!ac.add((CallSite)((Object)(studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation() + "|" + studentAreaClassificationMajor.getAcademicClassification().getCode())))) continue;
                e.addElement("acadAreaClass").addAttribute("academicArea", studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation()).addAttribute("academicClass", studentAreaClassificationMajor.getAcademicClassification().getCode());
            }
            for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                if (!ac.add((CallSite)((Object)(studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation() + "|" + studentAreaClassificationMinor.getAcademicClassification().getCode())))) continue;
                e.addElement("acadAreaClass").addAttribute("academicArea", studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation()).addAttribute("academicClass", studentAreaClassificationMinor.getAcademicClassification().getCode());
            }
        }
        if (!student.getAreaClasfMajors().isEmpty()) {
            e = studentEl.addElement("studentMajors");
            for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
                Element element = e.addElement("major").addAttribute("academicArea", studentAreaClassificationMajor.getAcademicArea().getAcademicAreaAbbreviation()).addAttribute("academicClass", studentAreaClassificationMajor.getAcademicClassification().getCode()).addAttribute("code", studentAreaClassificationMajor.getMajor().getCode());
                if (studentAreaClassificationMajor.getConcentration() != null) {
                    element.addAttribute("concentration", studentAreaClassificationMajor.getConcentration().getCode());
                }
                if (studentAreaClassificationMajor.getDegree() != null) {
                    element.addAttribute("degree", studentAreaClassificationMajor.getDegree().getReference());
                }
                if (studentAreaClassificationMajor.getProgram() != null) {
                    element.addAttribute("program", studentAreaClassificationMajor.getProgram().getReference());
                }
                if (studentAreaClassificationMajor.getCampus() != null) {
                    element.addAttribute("campus", studentAreaClassificationMajor.getCampus().getReference());
                }
                if (studentAreaClassificationMajor.getWeight() == null || studentAreaClassificationMajor.getWeight() == 1.0) continue;
                element.addAttribute("weight", studentAreaClassificationMajor.getWeight().toString());
            }
        }
        if (!student.getAreaClasfMinors().isEmpty()) {
            e = studentEl.addElement("studentMinors");
            for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                e.addElement("minor").addAttribute("academicArea", studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation()).addAttribute("academicClass", studentAreaClassificationMinor.getAcademicClassification().getCode()).addAttribute("code", studentAreaClassificationMinor.getMinor().getCode());
            }
        }
        if (!student.getGroups().isEmpty()) {
            e = studentEl.addElement("studentGroups");
            for (StudentGroup studentGroup : student.getGroups()) {
                e.addElement("studentGroup").addAttribute("group", studentGroup.getGroupAbbreviation());
            }
        }
        if (!student.getAccomodations().isEmpty()) {
            e = studentEl.addElement("studentAccomodations");
            for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
                e.addElement("studentAccomodation").addAttribute("accomodation", studentAccomodation.getAbbreviation());
            }
        }
        if (student.getMinCredit() != null) {
            studentEl.addAttribute("minCredit", this.iCreditDF.format(student.getMinCredit()));
        }
        if (student.getMaxCredit() != null) {
            studentEl.addAttribute("maxCredit", this.iCreditDF.format(student.getMaxCredit()));
        }
    }
}

