/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.cpsolver.coursett.Constants;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.util.Formats;

public class RoomSharingExport
extends BaseExport {
    protected static Formats.Format<Number> sTwoNumbersDF = Formats.getNumberFormat("00");

    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("roomSharing");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("created", new Date().toString());
            root.addAttribute("timeFormat", "HHmm");
            document.addDocType("roomSharing", "-//UniTime//UniTime Room Sharing DTD/EN", "http://www.unitime.org/interface/RoomSharing.dtd");
            List<Location> locations = Location.findAll(session.getUniqueId());
            Collections.sort(locations);
            for (Location location : locations) {
                int j;
                int i;
                Element locEl = root.addElement("location");
                this.fillLocationData(location, locEl);
                if (location.getShareNote() != null) {
                    locEl.addAttribute("note", location.getShareNote());
                }
                HashMap<Long, Department> id2dept = new HashMap<Long, Department>();
                for (RoomDept rd : location.getRoomDepts()) {
                    Element deptEl = locEl.addElement("department");
                    this.fillDepartmentData(rd, deptEl);
                    id2dept.put(rd.getDepartment().getUniqueId(), rd.getDepartment());
                }
                RoomSharingModel model = location.getRoomSharingModel();
                if (model == null || model.allAvailable(null)) continue;
                Element sharingEl = locEl.addElement("sharing");
                boolean[][] out = new boolean[model.getNrDays()][model.getNrTimes()];
                for (i = 0; i < model.getNrDays(); ++i) {
                    for (j = 0; j < model.getNrTimes(); ++j) {
                        out[i][j] = false;
                    }
                }
                for (i = 0; i < model.getNrDays(); ++i) {
                    for (j = 0; j < model.getNrTimes(); ++j) {
                        if (out[i][j]) continue;
                        out[i][j] = true;
                        if (model.isFreeForAll(i, j)) continue;
                        int endDay = i;
                        int endTime = j;
                        String p = model.getPreference(i, j);
                        while (endTime + 1 < model.getNrTimes() && !out[i][endTime + 1] && model.getPreference(i, endTime + 1).equals(p)) {
                            ++endTime;
                        }
                        while (endDay + 1 < model.getNrDays()) {
                            boolean same = true;
                            for (int x = j; x <= endTime; ++x) {
                                if (out[endDay + 1][x] || model.getPreference(endDay + 1, x).equals(p)) continue;
                                same = false;
                                break;
                            }
                            if (!same) break;
                            ++endDay;
                        }
                        for (int a = i; a <= endDay; ++a) {
                            for (int b = j; b <= endTime; ++b) {
                                out[a][b] = true;
                            }
                        }
                        Element el = null;
                        Department dept = null;
                        if (model.isNotAvailable(i, j)) {
                            el = sharingEl.addElement("unavailable");
                        } else {
                            dept = (Department)id2dept.get(model.getDepartmentId(i, j));
                            if (dept == null) continue;
                            el = sharingEl.addElement("assigned");
                        }
                        if (i != 0 || endDay + 1 != model.getNrDays()) {
                            Object day = "";
                            for (int a = i; a <= endDay; ++a) {
                                day = (String)day + Constants.DAY_NAMES_SHORT[a];
                            }
                            el.addAttribute("days", (String)day);
                        }
                        if (j != 0 || endTime + 1 != model.getNrTimes()) {
                            el.addAttribute("start", this.slot2time(j));
                            el.addAttribute("end", this.slot2time(endTime + 1));
                        }
                        if (dept == null) continue;
                        this.fillDepartmentData(dept, el);
                    }
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected void fillLocationData(Location location, Element element) {
        if (location instanceof Room) {
            Room room = (Room)location;
            element.addAttribute("building", room.getBuilding().getAbbreviation());
            element.addAttribute("roomNbr", room.getRoomNumber());
        } else {
            element.addAttribute("name", location.getLabel());
        }
        if (location.getExternalUniqueId() != null && !location.getExternalUniqueId().isEmpty()) {
            element.addAttribute("id", location.getExternalUniqueId());
        }
    }

    protected void fillDepartmentData(RoomDept rd, Element element) {
        this.fillDepartmentData(rd.getDepartment(), element);
        if (rd.isControl().booleanValue()) {
            element.addAttribute("control", "true");
        }
    }

    protected void fillDepartmentData(Department dept, Element element) {
        if (dept.getExternalUniqueId() != null) {
            element.addAttribute("id", dept.getExternalUniqueId());
        }
        element.addAttribute("code", dept.getDeptCode());
    }

    protected String slot2time(int slot) {
        int minutesSinceMidnight = Constants.SLOT_LENGTH_MIN * slot + Constants.FIRST_SLOT_TIME_MIN;
        return sTwoNumbersDF.format(minutesSinceMidnight / 60) + sTwoNumbersDF.format(minutesSinceMidnight % 60);
    }
}

