/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.dataexchange.ReservationExport;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumOverrideReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.UniversalOverrideReservation;

public class ReservationImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("reservations")) {
            throw new Exception("Given XML file is not reservations load file.");
        }
        try {
            Session session;
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = root.attributeValue("created");
            String dateFormat = root.attributeValue("dateFormat", ReservationExport.sDateFormat);
            boolean incremental = "true".equalsIgnoreCase(root.attributeValue("incremental", "false"));
            if (incremental) {
                this.info("Incremental mode.");
            }
            if ((session = Session.getSessionUsingInitiativeYearTerm(campus, year, term)) == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_RESERVATIONS, ChangeLog.Operation.UPDATE, null, null);
            }
            if (!incremental) {
                this.info("Deleting all existing reservations...");
                for (Reservation r : this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId=:sessionId", Reservation.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                    this.getHibSession().remove((Object)r);
                }
            } else {
                HashSet<CallSite> courses = new HashSet<CallSite>();
                Iterator i = root.elementIterator();
                while (i.hasNext()) {
                    Element reservationElement = (Element)i.next();
                    courses.add((CallSite)((Object)(reservationElement.attributeValue("subject") + "|" + reservationElement.attributeValue("courseNbr") + "|" + reservationElement.attributeValue("type", "course"))));
                }
                this.info("Deleting existing reservations for courses & types listed in the XML file...");
                int count = 0;
                for (Reservation r : this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session.uniqueId=:sessionId", Reservation.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                    boolean hasCourse = false;
                    String type = this.getType(r);
                    for (CourseOffering co : r.getInstructionalOffering().getCourseOfferings()) {
                        if (!courses.contains(co.getSubjectAreaAbbv() + "|" + co.getCourseNbr() + "|" + type)) continue;
                        hasCourse = true;
                        break;
                    }
                    if (!hasCourse) continue;
                    this.getHibSession().remove((Object)r);
                    ++count;
                }
                this.info(count + " reservations removed.");
            }
            this.flush(false);
            this.info("Loading areas, majors, classifications, and student groups...");
            Hashtable<String, AcademicArea> areasByAbbv = new Hashtable<String, AcademicArea>();
            Hashtable<String, AcademicArea> areasByExtId = new Hashtable<String, AcademicArea>();
            for (AcademicArea area : this.getHibSession().createQuery("select a from AcademicArea a where a.session.uniqueId = :sessionId", AcademicArea.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                areasByAbbv.put(area.getAcademicAreaAbbreviation(), area);
                if (area.getExternalUniqueId() == null) continue;
                areasByExtId.put(area.getExternalUniqueId(), area);
            }
            Hashtable<String, StudentGroup> groupsByCode = new Hashtable<String, StudentGroup>();
            Hashtable<String, StudentGroup> groupsByExtId = new Hashtable<String, StudentGroup>();
            for (StudentGroup group : this.getHibSession().createQuery("select a from StudentGroup a where a.session.uniqueId = :sessionId", StudentGroup.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                groupsByCode.put(group.getGroupAbbreviation(), group);
                if (group.getExternalUniqueId() == null) continue;
                groupsByExtId.put(group.getExternalUniqueId(), group);
            }
            Hashtable<CallSite, PosMajor> majorsByCode = new Hashtable<CallSite, PosMajor>();
            Hashtable<String, PosMajor> majorsByExtId = new Hashtable<String, PosMajor>();
            for (PosMajor major : this.getHibSession().createQuery("select a from PosMajor a where a.session.uniqueId = :sessionId", PosMajor.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                for (AcademicArea area : major.getAcademicAreas()) {
                    majorsByCode.put((CallSite)((Object)(area.getAcademicAreaAbbreviation() + "|" + major.getCode())), major);
                }
                if (major.getExternalUniqueId() == null) continue;
                majorsByExtId.put(major.getExternalUniqueId(), major);
            }
            Hashtable<CallSite, PosMinor> minorsByCode = new Hashtable<CallSite, PosMinor>();
            Hashtable<String, PosMinor> minorsByExtId = new Hashtable<String, PosMinor>();
            for (PosMinor minor : this.getHibSession().createQuery("select a from PosMinor a where a.session.uniqueId = :sessionId", PosMinor.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                for (AcademicArea area : minor.getAcademicAreas()) {
                    minorsByCode.put((CallSite)((Object)(area.getAcademicAreaAbbreviation() + "|" + minor.getCode())), minor);
                }
                if (minor.getExternalUniqueId() == null) continue;
                minorsByExtId.put(minor.getExternalUniqueId(), minor);
            }
            Hashtable<String, AcademicClassification> clasfsByCode = new Hashtable<String, AcademicClassification>();
            Hashtable<String, AcademicClassification> clasfsByExtId = new Hashtable<String, AcademicClassification>();
            for (AcademicClassification clasf : this.getHibSession().createQuery("select a from AcademicClassification a where a.session.uniqueId = :sessionId", AcademicClassification.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                clasfsByCode.put(clasf.getCode(), clasf);
                if (clasf.getExternalUniqueId() == null) continue;
                clasfsByExtId.put(clasf.getExternalUniqueId(), clasf);
            }
            this.info("Loading courses...");
            Hashtable<String, CourseOffering> corusesByExtId = new Hashtable<String, CourseOffering>();
            Hashtable<CallSite, CourseOffering> corusesBySubjectCourseNbr = new Hashtable<CallSite, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("select a from CourseOffering a where a.subjectArea.session.uniqueId = :sessionId", CourseOffering.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                corusesBySubjectCourseNbr.put((CallSite)((Object)(course.getSubjectArea().getSubjectAreaAbbreviation() + "|" + course.getCourseNbr())), course);
                if (course.getExternalUniqueId() == null) continue;
                corusesByExtId.put(course.getExternalUniqueId(), course);
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, Locale.US);
            this.info("Importing reservations...");
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                String inclusive;
                String startDate;
                String expire;
                CourseOffering course;
                Element reservationElement = (Element)i.next();
                Reservation reservation = null;
                String type = reservationElement.attributeValue("type", "course");
                if ("individual".equals(type)) {
                    reservation = new IndividualReservation();
                    if ("true".equalsIgnoreCase(reservationElement.attributeValue("override"))) {
                        reservation = new IndividualOverrideReservation();
                        ((IndividualOverrideReservation)reservation).setAlwaysExpired("true".equalsIgnoreCase(reservationElement.attributeValue("expired")));
                        ((IndividualOverrideReservation)reservation).setAllowOverlap("true".equalsIgnoreCase(reservationElement.attributeValue("allowOverlap")));
                        ((IndividualOverrideReservation)reservation).setCanAssignOverLimit("true".equalsIgnoreCase(reservationElement.attributeValue("overLimit")));
                        ((IndividualOverrideReservation)reservation).setMustBeUsed("true".equalsIgnoreCase(reservationElement.attributeValue("mustBeUsed")));
                    }
                } else if ("group".equals(type)) {
                    reservation = new StudentGroupReservation();
                    if ("true".equalsIgnoreCase(reservationElement.attributeValue("override"))) {
                        reservation = new GroupOverrideReservation();
                        ((GroupOverrideReservation)reservation).setAlwaysExpired("true".equalsIgnoreCase(reservationElement.attributeValue("expired")));
                        ((GroupOverrideReservation)reservation).setAllowOverlap("true".equalsIgnoreCase(reservationElement.attributeValue("allowOverlap")));
                        ((GroupOverrideReservation)reservation).setCanAssignOverLimit("true".equalsIgnoreCase(reservationElement.attributeValue("overLimit")));
                        ((GroupOverrideReservation)reservation).setMustBeUsed("true".equalsIgnoreCase(reservationElement.attributeValue("mustBeUsed")));
                    }
                } else if ("curriculum".equals(type)) {
                    reservation = new CurriculumReservation();
                    if ("true".equalsIgnoreCase(reservationElement.attributeValue("override"))) {
                        reservation = new CurriculumOverrideReservation();
                        ((CurriculumOverrideReservation)reservation).setAlwaysExpired("true".equalsIgnoreCase(reservationElement.attributeValue("expired")));
                        ((CurriculumOverrideReservation)reservation).setAllowOverlap("true".equalsIgnoreCase(reservationElement.attributeValue("allowOverlap")));
                        ((CurriculumOverrideReservation)reservation).setCanAssignOverLimit("true".equalsIgnoreCase(reservationElement.attributeValue("overLimit")));
                        ((CurriculumOverrideReservation)reservation).setMustBeUsed("true".equalsIgnoreCase(reservationElement.attributeValue("mustBeUsed")));
                    }
                } else if ("course".equals(type)) {
                    reservation = new CourseReservation();
                } else if ("lc".equals(type)) {
                    reservation = new LearningCommunityReservation();
                } else if ("universal".equals(type)) {
                    reservation = new UniversalOverrideReservation();
                    ((UniversalOverrideReservation)reservation).setAlwaysExpired("true".equalsIgnoreCase(reservationElement.attributeValue("expired")));
                    ((UniversalOverrideReservation)reservation).setAllowOverlap("true".equalsIgnoreCase(reservationElement.attributeValue("allowOverlap")));
                    ((UniversalOverrideReservation)reservation).setCanAssignOverLimit("true".equalsIgnoreCase(reservationElement.attributeValue("overLimit")));
                    ((UniversalOverrideReservation)reservation).setMustBeUsed("true".equalsIgnoreCase(reservationElement.attributeValue("mustBeUsed")));
                } else {
                    for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
                        if (!t.getReference().equalsIgnoreCase(type)) continue;
                        reservation = new OverrideReservation();
                        ((OverrideReservation)reservation).setOverrideType(t);
                        break;
                    }
                    if (reservation == null) {
                        this.warn("Unknown reservation type " + type);
                        continue;
                    }
                }
                if ((course = (CourseOffering)corusesBySubjectCourseNbr.get(reservationElement.attributeValue("subject") + "|" + reservationElement.attributeValue("courseNbr"))) == null || course.getInstructionalOffering() == null) {
                    this.warn("Unknown course " + reservationElement.attributeValue("subject") + " " + reservationElement.attributeValue("courseNbr"));
                    continue;
                }
                reservation.setInstructionalOffering(course.getInstructionalOffering());
                String limit = reservationElement.attributeValue("limit");
                if (limit != null) {
                    try {
                        reservation.setLimit(Integer.parseInt(limit));
                    }
                    catch (NumberFormatException e) {
                        this.warn("Unable to parse reservation limit " + limit);
                    }
                }
                if ((expire = reservationElement.attributeValue("expire")) != null) {
                    try {
                        reservation.setExpirationDate(df.parse(expire));
                    }
                    catch (Exception e) {
                        this.warn("Unable to parse reservation expiration date " + expire);
                    }
                }
                if ((startDate = reservationElement.attributeValue("startDate")) != null) {
                    try {
                        reservation.setStartDate(df.parse(startDate));
                    }
                    catch (Exception e) {
                        this.warn("Unable to parse reservation start date " + expire);
                    }
                }
                if ((inclusive = reservationElement.attributeValue("inclusive")) != null) {
                    reservation.setInclusive("true".equalsIgnoreCase(inclusive));
                }
                reservation.setConfigurations(new HashSet<InstrOfferingConfig>());
                Iterator j = reservationElement.elementIterator("configuration");
                while (j.hasNext()) {
                    String name = ((Element)j.next()).attributeValue("name");
                    InstrOfferingConfig config = null;
                    for (InstrOfferingConfig c : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                        if (!name.equals(c.getName())) continue;
                        config = c;
                        break;
                    }
                    if (config == null) {
                        this.warn("Unable to find configuration " + name + " of course " + course.getCourseName());
                        continue;
                    }
                    reservation.getConfigurations().add(config);
                }
                reservation.setClasses(new HashSet<Class_>());
                j = reservationElement.elementIterator("class");
                while (j.hasNext()) {
                    Element classEl = (Element)j.next();
                    String extId = classEl.attributeValue("externalId");
                    String itype = classEl.attributeValue("type");
                    String suffix = classEl.attributeValue("suffix");
                    Class_ clazz = null;
                    block25: for (InstrOfferingConfig c : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                        for (SchedulingSubpart s : c.getSchedulingSubparts()) {
                            if (itype != null && !itype.equals(s.getItypeDesc().trim())) continue;
                            for (Class_ z : s.getClasses()) {
                                if (extId != null && extId.equals(z.getExternalUniqueId())) {
                                    clazz = z;
                                    break block25;
                                }
                                if (extId != null || suffix == null || !suffix.equals(this.getClassSuffix(z))) continue;
                                clazz = z;
                                break block25;
                            }
                        }
                    }
                    if (clazz == null) {
                        this.warn("Unable to find clazz " + (String)(extId == null ? itype + " " + suffix : extId) + " of course " + course.getCourseName());
                        continue;
                    }
                    reservation.getClasses().add(clazz);
                }
                if ("individual".equals(type)) {
                    IndividualReservation individual = (IndividualReservation)reservation;
                    individual.setStudents(new HashSet<Student>());
                    j = reservationElement.elementIterator("student");
                    while (j.hasNext()) {
                        studentId = ((Element)j.next()).attributeValue("externalId");
                        student = Student.findByExternalId(session.getUniqueId(), studentId);
                        if (student == null) {
                            this.warn("Unable to find student " + student);
                            continue;
                        }
                        individual.getStudents().add(student);
                    }
                    if (individual.getStudents().isEmpty()) {
                        this.warn("Individual reservation of course " + course.getCourseName() + " has no students.");
                        continue;
                    }
                } else if ("group".equals(type)) {
                    StudentGroupReservation group = (StudentGroupReservation)reservation;
                    j = reservationElement.elementIterator("studentGroup");
                    while (j.hasNext()) {
                        groupEl = (Element)j.next();
                        extId = groupEl.attributeValue("externalId");
                        code = groupEl.attributeValue("code");
                        StudentGroup studentGroup = sg = extId == null ? (StudentGroup)groupsByCode.get(code) : (StudentGroup)groupsByExtId.get(extId);
                        if (sg == null) {
                            this.warn("Unable to find student group " + (extId == null ? code : extId));
                            continue;
                        }
                        group.setGroup(sg);
                        break;
                    }
                    if (group.getGroup() == null) {
                        this.warn("Group reservation of course " + course.getCourseName() + " has no student group.");
                    }
                } else if ("lc".equals(type)) {
                    LearningCommunityReservation lc = (LearningCommunityReservation)reservation;
                    j = reservationElement.elementIterator("studentGroup");
                    while (j.hasNext()) {
                        groupEl = (Element)j.next();
                        extId = groupEl.attributeValue("externalId");
                        code = groupEl.attributeValue("code");
                        StudentGroup studentGroup = sg = extId == null ? (StudentGroup)groupsByCode.get(code) : (StudentGroup)groupsByExtId.get(extId);
                        if (sg == null) {
                            this.warn("Unable to find student group " + (extId == null ? code : extId));
                            continue;
                        }
                        lc.setGroup(sg);
                        break;
                    }
                    lc.setCourse(course);
                    if (lc.getGroup() == null) {
                        this.warn("Group reservation of course " + course.getCourseName() + " has no student group.");
                    }
                } else if ("curriculum".equals(type)) {
                    AcademicArea area;
                    Iterator<Serializable> iterator;
                    CurriculumReservation curriculum = (CurriculumReservation)reservation;
                    curriculum.setAreas(new HashSet<AcademicArea>());
                    j = reservationElement.elementIterator("academicArea");
                    while (j.hasNext()) {
                        AcademicArea area2;
                        Element areaEl = (Element)j.next();
                        extId = areaEl.attributeValue("externalId");
                        String abbv = areaEl.attributeValue("abbreviation");
                        AcademicArea academicArea = area2 = extId == null ? (AcademicArea)areasByAbbv.get(abbv) : (AcademicArea)areasByExtId.get(extId);
                        if (area2 == null) {
                            this.warn("Unable to find academic area " + (Serializable)(extId == null ? area2 : extId));
                            continue;
                        }
                        curriculum.getAreas().add(area2);
                    }
                    if (curriculum.getAreas().isEmpty()) {
                        this.warn("Curriculum reservation of course " + course.getCourseName() + " has no academic area.");
                    }
                    curriculum.setClassifications(new HashSet<AcademicClassification>());
                    j = reservationElement.elementIterator("academicClassification");
                    while (j.hasNext()) {
                        AcademicClassification clasf;
                        Element clasfEl = (Element)j.next();
                        extId = clasfEl.attributeValue("externalId");
                        code = clasfEl.attributeValue("code");
                        AcademicClassification academicClassification = clasf = extId == null ? (AcademicClassification)clasfsByCode.get(code) : (AcademicClassification)clasfsByExtId.get(extId);
                        if (clasf == null) {
                            this.warn("Unable to find academic classification " + (extId == null ? code : extId));
                            continue;
                        }
                        curriculum.getClassifications().add(clasf);
                    }
                    curriculum.setMajors(new HashSet<PosMajor>());
                    j = reservationElement.elementIterator("major");
                    while (j.hasNext()) {
                        PosMajor major;
                        Element majorEl = (Element)j.next();
                        extId = majorEl.attributeValue("externalId");
                        code = majorEl.attributeValue("code");
                        PosMajor posMajor = major = extId != null ? (PosMajor)majorsByExtId.get(extId) : null;
                        if (major == null) {
                            iterator = curriculum.getAreas().iterator();
                            while (iterator.hasNext() && (major = (PosMajor)majorsByCode.get((area = (AcademicArea)iterator.next()).getAcademicAreaAbbreviation() + "|" + code)) == null) {
                            }
                        }
                        if (major == null) {
                            this.warn("Unable to find major " + (extId == null ? code : extId));
                            continue;
                        }
                        curriculum.getMajors().add(major);
                    }
                    curriculum.setMinors(new HashSet<PosMinor>());
                    j = reservationElement.elementIterator("minor");
                    while (j.hasNext()) {
                        PosMinor minor;
                        Element minorEl = (Element)j.next();
                        extId = minorEl.attributeValue("externalId");
                        code = minorEl.attributeValue("code");
                        PosMinor posMinor = minor = extId != null ? (PosMinor)minorsByExtId.get(extId) : null;
                        if (minor == null) {
                            iterator = curriculum.getAreas().iterator();
                            while (iterator.hasNext() && (minor = (PosMinor)minorsByCode.get((area = (AcademicArea)iterator.next()).getAcademicAreaAbbreviation() + "|" + code)) == null) {
                            }
                        }
                        if (minor == null) {
                            this.warn("Unable to find major " + (extId == null ? code : extId));
                            continue;
                        }
                        curriculum.getMinors().add(minor);
                    }
                } else if ("course".equals(type)) {
                    course.setReservation(reservation.getLimit());
                    reservation.setLimit(null);
                    this.getHibSession().merge((Object)course);
                    if (reservation.getConfigurations().isEmpty() && reservation.getClasses().isEmpty()) continue;
                    ((CourseReservation)reservation).setCourse(course);
                } else if ("universal".equals(type)) {
                    ((UniversalOverrideReservation)reservation).setFilter(reservationElement.attributeValue("filter"));
                } else {
                    OverrideReservation override = (OverrideReservation)reservation;
                    override.setStudents(new HashSet<Student>());
                    j = reservationElement.elementIterator("student");
                    while (j.hasNext()) {
                        studentId = ((Element)j.next()).attributeValue("externalId");
                        student = Student.findByExternalId(session.getUniqueId(), studentId);
                        if (student == null) {
                            this.warn("Unable to find student " + student);
                            continue;
                        }
                        override.getStudents().add(student);
                    }
                    if (override.getStudents().isEmpty()) {
                        this.warn("Override reservation of course " + course.getCourseName() + " has no students.");
                        continue;
                    }
                }
                this.getHibSession().persist((Object)reservation);
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    private String getType(Reservation reservation) {
        if (reservation instanceof OverrideReservation) {
            return ((OverrideReservation)reservation).getOverrideType().getReference().toLowerCase();
        }
        if (reservation instanceof IndividualReservation) {
            return "individual";
        }
        if (reservation instanceof LearningCommunityReservation) {
            return "lc";
        }
        if (reservation instanceof StudentGroupReservation) {
            return "group";
        }
        if (reservation instanceof CurriculumReservation) {
            return "curriculum";
        }
        if (reservation instanceof CourseReservation) {
            return "course";
        }
        if (reservation instanceof UniversalOverrideReservation) {
            return "universal";
        }
        return "unknown";
    }
}

