/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.PreferencesImport;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorCourseRequirementType;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Session;

public class InstructorSurveyImport
extends PreferencesImport {
    private SimpleDateFormat iTimestampFormat;

    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("instructorSurveys")) {
            throw new Exception("Given XML file is not an instructor surveys file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            this.iTimestampFormat = new SimpleDateFormat(root.attributeValue("timeStampFormat", "yyyy/M/d HH:mm:ss"), Locale.US);
            this.iSession = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (this.iSession == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            HashMap<String, InstructorCourseRequirementType> types = new HashMap<String, InstructorCourseRequirementType>();
            for (InstructorCourseRequirementType type : this.getHibSession().createQuery("from InstructorCourseRequirementType", InstructorCourseRequirementType.class).list()) {
                types.put(type.getReference(), type);
            }
            Iterator i = root.elementIterator("survey");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String externalUniqueId = element.attributeValue("externalId");
                InstructorSurvey survey = (InstructorSurvey)this.getHibSession().createQuery("from InstructorSurvey where session.uniqueId = :sessionId and externalUniqueId = :externalId", InstructorSurvey.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).setParameter("externalId", (Object)externalUniqueId).setMaxResults(1).uniqueResult();
                if (survey == null) {
                    survey = new InstructorSurvey();
                    survey.setExternalUniqueId(externalUniqueId);
                    survey.setPreferences(new HashSet<Preference>());
                    survey.setCourseRequirements(new HashSet<InstructorCourseRequirement>());
                } else {
                    survey.getPreferences().clear();
                    for (InstructorCourseRequirement req : survey.getCourseRequirements()) {
                        this.getHibSession().remove((Object)req);
                    }
                    survey.getCourseRequirements().clear();
                }
                survey.setEmail(element.attributeValue("email"));
                survey.setNote(this.getNote(element));
                survey.setChangedBy(element.attributeValue("changedBy"));
                survey.setAppliedDeptCode(element.attributeValue("appliedDeptCode"));
                survey.setSubmitted(this.toDate(element.attributeValue("submitted")));
                survey.setChanged(this.toDate(element.attributeValue("changed")));
                survey.setApplied(this.toDate(element.attributeValue("applied")));
                if (survey.getUniqueId() == null) {
                    this.getHibSession().persist((Object)survey);
                } else {
                    this.getHibSession().merge((Object)survey);
                }
                Iterator j = element.elementIterator();
                while (j.hasNext()) {
                    Element prefElement = (Element)j.next();
                    if ("courseReq".equals(prefElement.getName())) {
                        InstructorCourseRequirement req = this.createCourseReq(prefElement, types);
                        if (req == null || req.getNotes().isEmpty()) continue;
                        req.setInstructorSurvey(survey);
                        survey.getCourseRequirements().add(req);
                        this.getHibSession().persist((Object)req);
                        continue;
                    }
                    Preference preference = this.createPreference(prefElement, survey);
                    if (preference == null) continue;
                    preference.setOwner(survey);
                    survey.getPreferences().add(preference);
                    this.getHibSession().persist((Object)preference);
                }
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected InstructorCourseRequirement createCourseReq(Element element, Map<String, InstructorCourseRequirementType> types) {
        InstructorCourseRequirement req = new InstructorCourseRequirement();
        req.setCourse(element.attributeValue("course"));
        req.setCourseOffering((CourseOffering)this.getHibSession().createQuery("from CourseOffering where instructionalOffering.session.uniqueId = :sessionId and (subjectArea.subjectAreaAbbreviation || ' ' || courseNbr) = :course", CourseOffering.class).setParameter("sessionId", (Object)this.iSession.getUniqueId()).setParameter("course", (Object)req.getCourse()).setMaxResults(1).uniqueResult());
        req.setNotes(new HashSet<InstructorCourseRequirementNote>());
        for (Element noteEl : element.elements("note")) {
            InstructorCourseRequirementType type = types.get(noteEl.attributeValue("type"));
            if (type == null) continue;
            InstructorCourseRequirementNote n = new InstructorCourseRequirementNote();
            n.setType(type);
            n.setRequirement(req);
            n.setNote(noteEl.getText());
            req.getNotes().add(n);
        }
        return req;
    }

    protected Date toDate(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return this.iTimestampFormat.parse(date);
        }
        catch (ParseException e) {
            this.warn("Failed to parse date: " + date, e);
            return null;
        }
    }
}

