/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.Session;

public abstract class BaseExport
extends DataExchangeHelper {
    protected static Log sLog = LogFactory.getLog(BaseExport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXml(String fileName, Session session, Properties parameters) throws Exception {
        this.debug("Saving " + fileName);
        Document doc = this.saveXml(session, parameters);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(doc);
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                this.fatal("Unable to write file " + fileName + ", reason:" + e.getMessage(), e);
                throw e;
            }
        }
    }

    public Document saveXml(Session session, Properties parameters) throws Exception {
        Document document = DocumentHelper.createDocument();
        this.saveXml(document, session, parameters);
        return document;
    }

    public abstract void saveXml(Document var1, Session var2, Properties var3) throws Exception;
}

