/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.authenticate.jaas;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.security.authentication.jaas.AuthorityGranter;
import org.springframework.security.authentication.jaas.DefaultJaasAuthenticationProvider;
import org.springframework.security.authentication.jaas.JaasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.unitime.timetable.authenticate.jaas.HasExternalId;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.context.UniTimeUserContext;

public class JaasAuthenticationProvider
extends DefaultJaasAuthenticationProvider {
    public JaasAuthenticationProvider() {
        this.setAuthorityGranters(new AuthorityGranter[]{new AuthorityGranter(){

            public Set<String> grant(Principal principal) {
                HashSet<String> roles = new HashSet<String>();
                if (principal instanceof HasExternalId) {
                    roles.add(((HasExternalId)((Object)principal)).getExternalId());
                } else {
                    String user = principal.getName();
                    if (user.indexOf(64) >= 0) {
                        user = user.substring(0, user.indexOf(64));
                    }
                    roles.add(user);
                }
                return roles;
            }
        }});
    }

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        JaasAuthenticationToken ret = (JaasAuthenticationToken)super.authenticate(auth);
        Iterator iterator = ret.getAuthorities().iterator();
        if (iterator.hasNext()) {
            GrantedAuthority role = (GrantedAuthority)iterator.next();
            UniTimeUserContext user = new UniTimeUserContext(role.getAuthority(), ret.getName(), null, null);
            return new JaasAuthenticationToken((Object)user, ret.getCredentials(), new ArrayList<UserAuthority>(user.getAuthorities()), ret.getLoginContext());
        }
        return null;
    }
}

