/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventDetailBackend;
import org.unitime.timetable.events.EventLookupBackend;
import org.unitime.timetable.events.ResourceLookupBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcServlet;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseEvent;
import org.unitime.timetable.model.dao.EventContactDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.MeetingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

@Service(value="/api/events")
public class EventsConnector
extends ApiConnector {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void doGet(ApiHelper helper) throws IOException {
        EventInterface.ResourceInterface resource;
        String name;
        String type;
        String ext;
        if (helper.getParameter("eventId") != null) {
            Event event = (Event)EventDAO.getInstance().get(helper.getRequiredParameterLong("eventId"));
            if (event == null) {
                throw new IllegalArgumentException("Given event no longer exists.");
            }
            Long sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                if (event.getSession() != null) {
                    sessionId = event.getSession().getUniqueId();
                } else {
                    for (Meeting m : event.getMeetings()) {
                        if (m.getLocation() == null) continue;
                        sessionId = m.getLocation().getSession().getUniqueId();
                        break;
                    }
                }
            }
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveEvents, new Qualifiable[0]);
            EventInterface.EventDetailRpcRequest request = new EventInterface.EventDetailRpcRequest();
            request.setEventId(event.getUniqueId());
            request.setSessionId(sessionId);
            EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
            helper.setResponse(new EventDetailBackend().execute(request, context));
            return;
        }
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)session, Right.ApiRetrieveEvents, new Qualifiable[0]);
        EventInterface.EventLookupRpcRequest request = new EventInterface.EventLookupRpcRequest();
        request.setSessionId(sessionId);
        String id = helper.getParameter("id");
        if (id != null) {
            request.setResourceId(Long.valueOf(id));
        }
        if ((ext = helper.getParameter("ext")) != null) {
            request.setResourceExternalId(ext);
        }
        if ((type = helper.getParameter("type")) == null) {
            type = EventInterface.ResourceType.ROOM.name();
        }
        request.setResourceType(EventInterface.ResourceType.valueOf(type.toUpperCase()));
        EventInterface.EventFilterRpcRequest eventFilter = new EventInterface.EventFilterRpcRequest();
        eventFilter.setSessionId(sessionId);
        request.setEventFilter(eventFilter);
        EventInterface.RoomFilterRpcRequest roomFilter = new EventInterface.RoomFilterRpcRequest();
        roomFilter.setSessionId(sessionId);
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("e:text")) {
                eventFilter.setText(helper.getParameter("e:text"));
                continue;
            }
            if (command.startsWith("e:")) {
                for (String value : helper.getParameterValues(command)) {
                    eventFilter.addOption(command.substring(2), value);
                }
                continue;
            }
            if (command.equals("r:text")) {
                roomFilter.setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                roomFilter.addOption(command.substring(2), value);
            }
        }
        request.setRoomFilter(roomFilter);
        if (request.getResourceType() != EventInterface.ResourceType.ROOM && request.getResourceType() != EventInterface.ResourceType.PERSON && request.getResourceId() == null && (name = helper.getParameter("name")) != null && (resource = new ResourceLookupBackend().findResource(request.getSessionId(), request.getResourceType(), name)) != null) {
            request.setResourceId(resource.getId());
        }
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        GwtRpcResponseList<EventInterface> events = new EventLookupBackend().findEvents(request, context);
        if (!"1".equals(helper.getParameter("ua"))) {
            Iterator i = events.iterator();
            while (i.hasNext()) {
                EventInterface event = (EventInterface)i.next();
                if (event.getType() != EventInterface.EventType.Unavailabile) continue;
                i.remove();
            }
        }
        helper.setResponse(events);
    }

    public void fixContact(Long sessionId, EventInterface.ContactInterface c) {
        Iterator iterator;
        List people;
        if (c.getExternalId() != null) {
            org.hibernate.Session hibSession = EventContactDAO.getInstance().getSession();
            EventContact contact = (EventContact)hibSession.createQuery("from EventContact where externalUniqueId = :userId", EventContact.class).setParameter("userId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
            if (contact != null) {
                c.setFirstName(contact.getFirstName());
                c.setMiddleName(contact.getMiddleName());
                c.setLastName(contact.getLastName());
                c.setAcademicTitle(contact.getAcademicTitle());
                c.setEmail(contact.getEmailAddress());
                c.setPhone(contact.getPhone());
                return;
            }
            TimetableManager manager = (TimetableManager)hibSession.createQuery("from TimetableManager where externalUniqueId = :userId", TimetableManager.class).setParameter("userId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
            if (manager != null) {
                c.setExternalId(manager.getExternalUniqueId());
                c.setFirstName(manager.getFirstName());
                c.setMiddleName(manager.getMiddleName());
                c.setLastName(manager.getLastName());
                c.setAcademicTitle(manager.getAcademicTitle());
                c.setEmail(manager.getEmailAddress());
                return;
            }
            DepartmentalInstructor instructor = (DepartmentalInstructor)hibSession.createQuery("from DepartmentalInstructor where department.session.uniqueId = :sessionId and externalUniqueId = :userId", DepartmentalInstructor.class).setParameter("sessionId", (Object)sessionId).setParameter("userId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
            if (instructor != null) {
                c.setExternalId(instructor.getExternalUniqueId());
                c.setFirstName(instructor.getFirstName());
                c.setMiddleName(instructor.getMiddleName());
                c.setLastName(instructor.getLastName());
                c.setAcademicTitle(instructor.getAcademicTitle());
                c.setEmail(instructor.getEmail());
                return;
            }
            Staff staff = (Staff)hibSession.createQuery("from Staff where externalUniqueId = :userId", Staff.class).setParameter("userId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
            if (staff != null) {
                c.setExternalId(staff.getExternalUniqueId());
                c.setFirstName(staff.getFirstName());
                c.setMiddleName(staff.getMiddleName());
                c.setLastName(staff.getLastName());
                c.setAcademicTitle(staff.getAcademicTitle());
                c.setEmail(staff.getEmail());
                return;
            }
            Student student = (Student)hibSession.createQuery("from Student where session.uniqueId = :sessionId and externalUniqueId = :userId", Student.class).setParameter("sessionId", (Object)sessionId).setParameter("userId", (Object)c.getExternalId()).setMaxResults(1).uniqueResult();
            if (student != null) {
                c.setExternalId(student.getExternalUniqueId());
                c.setFirstName(student.getFirstName());
                c.setMiddleName(student.getMiddleName());
                c.setLastName(student.getLastName());
                c.setAcademicTitle(student.getAcademicTitle());
                c.setEmail(student.getEmail());
                return;
            }
        } else if (c.hasEmail() && (people = (List)GwtRpcServlet.execute(new PersonInterface.LookupRequest(c.getEmail(), "mustHaveExternalId,session=" + sessionId), this.applicationContext, null)) != null && (iterator = people.iterator()).hasNext()) {
            PersonInterface person = (PersonInterface)iterator.next();
            c.setFirstName(person.getFirstName());
            c.setMiddleName(person.getMiddleName());
            c.setLastName(person.getLastName());
            c.setAcademicTitle(person.getAcademicTitle());
            c.setEmail(person.getEmail());
            c.setPhone(person.getPhone());
            c.setExternalId(person.getId());
            return;
        }
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        Session session;
        Iterator<EventInterface.ContactInterface> e;
        EventInterface event = (EventInterface)helper.getRequest((Type)((Object)EventInterface.class));
        if (event == null) {
            throw new IllegalArgumentException("No event data provided.");
        }
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null && event.getId() != null && (e = (Event)EventDAO.getInstance().get(event.getId())) != null) {
            if (((Event)((Object)e)).getSession() != null) {
                sessionId = ((Event)((Object)e)).getSession().getUniqueId();
            } else {
                for (Meeting m : ((BaseEvent)((Object)e)).getMeetings()) {
                    if (m.getLocation() == null) continue;
                    sessionId = m.getLocation().getSession().getUniqueId();
                    break;
                }
            }
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        if (event.hasMeetings()) {
            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                Location l;
                EventInterface.ResourceInterface location;
                if (meeting.getId() != null && meeting.getMeetingDate() == null) {
                    Meeting m;
                    m = (Meeting)MeetingDAO.getInstance().get(meeting.getId());
                    if (m == null) continue;
                    meeting.setMeetingDate(m.getMeetingDate());
                    meeting.setDayOfWeek(Constants.getDayOfWeek(m.getMeetingDate()));
                    meeting.setStartTime(m.getStartTime().getTime());
                    meeting.setStopTime(m.getStopTime().getTime());
                    meeting.setStartSlot(m.getStartPeriod());
                    meeting.setEndSlot(m.getStopPeriod());
                    meeting.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
                    meeting.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
                    meeting.setApprovalDate(m.getApprovalDate());
                    meeting.setApprovalStatus(m.getApprovalStatus());
                    if (m.getLocation() != null) {
                        location = new EventInterface.ResourceInterface();
                        location.setType(EventInterface.ResourceType.ROOM);
                        location.setId(m.getLocation().getUniqueId());
                        location.setName(m.getLocation().getLabel());
                        location.setSize(m.getLocation().getCapacity());
                        location.setRoomType(m.getLocation().getRoomTypeLabel());
                        location.setBreakTime(m.getLocation().getEffectiveBreakTime());
                        location.setMessage(m.getLocation().getEventMessage());
                        location.setIgnoreRoomCheck(m.getLocation().isIgnoreRoomCheck());
                        location.setDisplayName(m.getLocation().getDisplayName());
                        location.setPartitionParentId(m.getLocation().getPartitionParentId());
                        location.setEventEmail(m.getLocation().getEventEmail());
                        meeting.setLocation(location);
                    }
                }
                if (!meeting.hasLocation() || meeting.getLocation().getId() != null || meeting.getLocationName() == null || (l = Location.findByName(LocationDAO.getInstance().getSession(), sessionId, meeting.getLocationName())) == null) continue;
                location = new EventInterface.ResourceInterface();
                location.setType(EventInterface.ResourceType.ROOM);
                location.setId(l.getUniqueId());
                location.setName(l.getLabel());
                location.setSize(l.getCapacity());
                location.setRoomType(l.getRoomTypeLabel());
                location.setBreakTime(l.getEffectiveBreakTime());
                location.setMessage(l.getEventMessage());
                location.setIgnoreRoomCheck(l.isIgnoreRoomCheck());
                location.setDisplayName(l.getDisplayName());
                location.setPartitionParentId(l.getPartitionParentId());
                location.setEventEmail(l.effectiveEventEmail());
                meeting.setLocation(location);
            }
        }
        if (event.hasContact()) {
            this.fixContact(sessionId, event.getContact());
        }
        if (event.hasAdditionalContacts()) {
            for (EventInterface.ContactInterface c : event.getAdditionalContacts()) {
                this.fixContact(sessionId, c);
            }
        }
        String op = helper.getParameter("operation");
        EventInterface.SaveOrApproveEventRpcRequest.Operation operation = null;
        if (op != null) {
            operation = EventInterface.SaveOrApproveEventRpcRequest.Operation.valueOf(op.toUpperCase());
        }
        if ((session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession())) == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)session, Right.ApiRetrieveEvents, new Qualifiable[0]);
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        if (event.getContact() == null) {
            event.setContact(GwtRpcServlet.execute(new EventInterface.EventPropertiesRpcRequest(sessionId), this.applicationContext, context).getMainContact());
        }
        EventInterface.SaveOrApproveEventRpcRequest save = null;
        if (op == null) {
            save = new EventInterface.SaveEventRpcRequest();
        } else {
            switch (operation) {
                case CREATE: 
                case UPDATE: 
                case DELETE: {
                    save = new EventInterface.SaveEventRpcRequest();
                    break;
                }
                default: {
                    EventInterface.ApproveEventRpcRequest approve = new EventInterface.ApproveEventRpcRequest();
                    approve.setOperation(operation);
                    if (event.hasMeetings()) {
                        for (EventInterface.MeetingInterface m : event.getMeetings()) {
                            approve.addMeeting(m);
                        }
                    }
                    save = approve;
                }
            }
        }
        save.setEvent(event);
        save.setEmailConfirmation(helper.getOptinalParameterBoolean("email", true));
        save.setMessage(helper.getParameter("message"));
        save.setSessionId(sessionId);
        EventInterface.SaveOrApproveEventRpcResponse response = GwtRpcServlet.execute(save, this.applicationContext, context);
        helper.setResponse(response);
    }

    @Override
    public void doDelete(ApiHelper helper) throws IOException {
        Long sessionId;
        EventInterface event = new EventInterface();
        event.setId(helper.getRequiredParameterLong("eventId"));
        event.setMeetings(new TreeSet<EventInterface.MeetingInterface>());
        Event e = (Event)EventDAO.getInstance().get(event.getId());
        if (e == null) {
            throw new IllegalArgumentException("Given event no longer exists.");
        }
        event.setType(EventInterface.EventType.values()[e.getEventType()]);
        if (e.getMainContact() != null) {
            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
            contact.setFirstName(e.getMainContact().getFirstName());
            contact.setMiddleName(e.getMainContact().getMiddleName());
            contact.setLastName(e.getMainContact().getLastName());
            contact.setAcademicTitle(e.getMainContact().getAcademicTitle());
            contact.setEmail(e.getMainContact().getEmailAddress());
            event.setContact(contact);
        }
        if ((sessionId = helper.getAcademicSessionId()) == null) {
            if (e.getSession() != null) {
                sessionId = e.getSession().getUniqueId();
            } else {
                for (Meeting m : e.getMeetings()) {
                    if (m.getLocation() == null) continue;
                    sessionId = m.getLocation().getSession().getUniqueId();
                    break;
                }
            }
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)session, Right.ApiRetrieveEvents, new Qualifiable[0]);
        EventInterface.SaveEventRpcRequest save = new EventInterface.SaveEventRpcRequest();
        save.setEvent(event);
        save.setEmailConfirmation(helper.getOptinalParameterBoolean("email", true));
        save.setMessage(helper.getParameter("message"));
        save.setSessionId(sessionId);
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        EventInterface.SaveOrApproveEventRpcResponse response = GwtRpcServlet.execute(save, this.applicationContext, context);
        helper.setResponse(response);
    }

    @Override
    protected String getName() {
        return "events";
    }
}

