/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.api.ApiHelper;

public class ErrorMessage {
    int code;
    String message;
    Map<String, String> parameters = new HashMap<String, String>();
    List<String> exception;

    public ErrorMessage(int code, ApiHelper helper) {
        this.code = code;
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            this.parameters.put(name, helper.getParameter(name));
        }
    }

    public ErrorMessage(int code, String message, ApiHelper helper) {
        this(code, helper);
        this.message = message;
    }

    public ErrorMessage(int code, Throwable error, ApiHelper helper) {
        this(code, helper);
        this.message = error.getMessage();
        StringWriter trace = new StringWriter();
        error.printStackTrace(new PrintWriter(trace));
        this.exception = new ArrayList<String>();
        this.exception.add(error.toString());
        for (StackTraceElement e : error.getStackTrace()) {
            this.exception.add("at " + e.toString());
        }
        for (Throwable cause = error.getCause(); cause != null; cause = cause.getCause()) {
            this.exception.add("Caused by: " + cause.toString());
            for (StackTraceElement e : cause.getStackTrace()) {
                this.exception.add("at " + e.toString());
            }
        }
    }
}

