/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.api.ApiToken;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.UserEditForm;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao.UserDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

@Action(value="userEdit", results={@Result(name={"list"}, type="tiles", location="userEditList.tiles"), @Result(name={"add"}, type="tiles", location="userEditAdd.tiles"), @Result(name={"edit"}, type="tiles", location="userEditEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="userEditList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Users (Database Authentication)"), @TilesPutAttribute(name="body", value="/admin/userEdit.jsp")}), @TilesDefinition(name="userEditAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add User"), @TilesPutAttribute(name="body", value="/admin/userEdit.jsp")}), @TilesDefinition(name="userEditEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit User"), @TilesPutAttribute(name="body", value="/admin/userEdit.jsp")})})
public class UserEditAction
extends UniTimeAction<UserEditForm> {
    private static final long serialVersionUID = -1707528693336547809L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() throws Exception {
        Session hibSession;
        Transaction tx;
        if (this.form == null) {
            this.form = new UserEditForm();
        }
        this.sessionContext.checkPermission(Right.Users);
        if (this.op == null) {
            this.op = ((UserEditForm)this.form).getOp();
        } else {
            ((UserEditForm)this.form).setOp(this.op);
        }
        if (this.op == null) {
            ((UserEditForm)this.form).reset();
        }
        if (MSG.actionBackToUsers().equals(this.op)) {
            ((UserEditForm)this.form).reset();
        }
        if (MSG.actionAddUser().equals(this.op)) {
            ((UserEditForm)this.form).load(null);
        }
        if (MSG.actionRequestPasswordChange().equals(this.op)) {
            this.response.sendRedirect("gwt.jsp?page=password&reset=1");
            return null;
        }
        if (MSG.actionSaveUser().equals(this.op) || MSG.actionUpdateUser().equals(this.op)) {
            ((UserEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                tx = null;
                try {
                    hibSession = UserDAO.getInstance().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ((UserEditForm)this.form).saveOrUpdate(hibSession);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                ((UserEditForm)this.form).reset();
            }
        }
        if ("Edit".equals(this.op)) {
            if (this.id == null || this.id.trim().isEmpty()) {
                this.addFieldError("form.externalId", MSG.errorRequiredField(MSG.columnExternalId()));
            } else {
                User u = User.findByExternalId(this.id);
                if (u == null) {
                    this.addFieldError("form.externalId", MSG.errorDoesNotExists(this.id));
                } else {
                    ((UserEditForm)this.form).load(u);
                    if (ApplicationProperty.ApiCanUseAPIToken.isTrue()) {
                        ((UserEditForm)this.form).setToken(this.getApiToken().getToken(u.getExternalUniqueId(), u.getPassword()));
                    }
                }
            }
        }
        if (MSG.actionDeleteUser().equals(this.op)) {
            tx = null;
            try {
                hibSession = UserDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                ((UserEditForm)this.form).delete(hibSession);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((UserEditForm)this.form).reset();
        }
        if ("List".equals(((UserEditForm)this.form).getOp())) {
            return "list";
        }
        return MSG.actionSaveUser().equals(((UserEditForm)this.form).getOp()) ? "add" : "edit";
    }

    public String getUsersTable() {
        WebTable.setOrder(this.sessionContext, "users.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = null;
        boolean showTokents = ApplicationProperty.ApiCanUseAPIToken.isTrue();
        webTable = showTokents ? new WebTable(4, null, "userEdit.action?ord=%%", new String[]{MSG.columnExternalId(), MSG.columnUserName(), MSG.columnTimetableManager(), MSG.columnAPIKey()}, new String[]{"left", "left", "left", "left"}, null) : new WebTable(3, null, "userEdit.action?ord=%%", new String[]{MSG.columnExternalId(), MSG.columnUserName(), MSG.columnTimetableManager()}, new String[]{"left", "left", "left"}, null);
        List users = UserDAO.getInstance().findAll();
        if (users.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.messageNoUsers()}, null);
        }
        for (User user : users) {
            String onClick = "onClick=\"document.location='userEdit.action?op=Edit&id=" + user.getExternalUniqueId() + "';\"";
            TimetableManager mgr = TimetableManager.findByExternalId(user.getExternalUniqueId());
            if (showTokents) {
                String token = this.getApiToken().getToken(user.getExternalUniqueId(), user.getPassword());
                webTable.addLine(onClick, new String[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName(), token == null ? "" : token}, new Comparable[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName(), null});
                continue;
            }
            webTable.addLine(onClick, new String[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName()}, new Comparable[]{user.getExternalUniqueId(), user.getUsername(), mgr == null ? "" : mgr.getName()});
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "users.ord"));
    }

    public ApiToken getApiToken() {
        return (ApiToken)SpringApplicationContextHolder.getBean("apiToken");
    }
}

