/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.TimetableManagerForm;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BaseSolverGroup;
import org.unitime.timetable.model.comparators.RolesComparator;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;

@Action(value="timetableManagerEdit", results={@Result(name={"addManagerInfo"}, type="tiles", location="timetableManagerAdd.tiles"), @Result(name={"editManagerInfo"}, type="tiles", location="timetableManagerEdit.tiles"), @Result(name={"displayManagerList"}, type="redirect", location="/timetableManagerList.action", params={"anchor", "${form.uniqueId}"})})
@TilesDefinitions(value={@TilesDefinition(name="timetableManagerAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Timetable Manager"), @TilesPutAttribute(name="body", value="/admin/timetableManagerEdit.jsp")}), @TilesDefinition(name="timetableManagerEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Timetable Manager"), @TilesPutAttribute(name="body", value="/admin/timetableManagerEdit.jsp")})})
public class TimetableManagerEditAction
extends UniTimeAction<TimetableManagerForm> {
    private static final long serialVersionUID = 3071423315785922315L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long id;
    private String deleteType;
    private Integer deleteId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(String deleteType) {
        this.deleteType = deleteType;
    }

    public Integer getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(Integer deleteId) {
        this.deleteId = deleteId;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new TimetableManagerForm();
        }
        this.sessionContext.checkPermission(Right.TimetableManagers);
        if (this.op == null) {
            this.op = ((TimetableManagerForm)this.form).getOp();
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            throw new Exception("Operation could not be interpreted: " + this.op);
        }
        LookupTables.setupDepts(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        this.request.setAttribute("solverGroupList", SolverGroup.findBySessionId(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        ((TimetableManagerForm)this.form).setOp(this.op);
        if (MSG.actionBackToManagers().equals(this.op)) {
            return "displayManagerList";
        }
        if ("Edit".equals(this.op)) {
            this.loadForm();
            this.setupOtherSessions(true);
        }
        if (MSG.actionAddTimetableManager().equals(this.op)) {
            this.sessionContext.checkPermission(Right.TimetableManagerAdd);
            ((TimetableManagerForm)this.form).setLookupEnabled(ApplicationProperty.ManagerExternalIdLookup.isTrue() && ApplicationProperty.ManagerExternalIdLookupClass.value() != null);
            this.setupOtherSessions(true);
        }
        if (MSG.actionLookupManager().equals(this.op)) {
            // empty if block
        }
        if (MSG.actionAddRole().equals(this.op)) {
            ((TimetableManagerForm)this.form).validate(this);
            if (!this.hasFieldErrors() && !((TimetableManagerForm)this.form).getRoles().contains(((TimetableManagerForm)this.form).getRole())) {
                Roles role = (Roles)RolesDAO.getInstance().get(((TimetableManagerForm)this.form).getRole());
                ((TimetableManagerForm)this.form).addToRoles(role);
                if (((TimetableManagerForm)this.form).getRoles().size() == 1) {
                    ((TimetableManagerForm)this.form).setPrimaryRole(role.getRoleId());
                }
                ((TimetableManagerForm)this.form).getRoleReceiveEmailFlags().add(true);
            }
        }
        if (MSG.actionAddDepartment().equals(this.op)) {
            ((TimetableManagerForm)this.form).validate(this);
            if (!this.hasFieldErrors() && !((TimetableManagerForm)this.form).getDepts().contains(((TimetableManagerForm)this.form).getDept())) {
                Department dept = (Department)DepartmentDAO.getInstance().get(((TimetableManagerForm)this.form).getDept());
                ((TimetableManagerForm)this.form).addToDepts(dept);
            }
        }
        if (MSG.actionAddSolverGroup().equals(this.op)) {
            ((TimetableManagerForm)this.form).validate(this);
            if (!this.hasFieldErrors() && !((TimetableManagerForm)this.form).getSolverGrs().contains(((TimetableManagerForm)this.form).getSolverGr())) {
                SolverGroup sg = (SolverGroup)SolverGroupDAO.getInstance().get(((TimetableManagerForm)this.form).getSolverGr());
                ((TimetableManagerForm)this.form).addToSolverGrs(sg);
            }
        }
        if (MSG.actionSaveManager().equals(this.op)) {
            ((TimetableManagerForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.addManager();
                return "displayManagerList";
            }
        }
        if (MSG.actionUpdateManager().equals(this.op)) {
            ((TimetableManagerForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.updateManager();
                return "displayManagerList";
            }
        }
        if (MSG.actionDelete().equals(this.op) && this.deleteId != null && this.deleteType != null && !this.deleteType.isEmpty()) {
            if (this.deleteType.equalsIgnoreCase("dept")) {
                ((TimetableManagerForm)this.form).removeFromDepts(this.deleteId);
            }
            if (this.deleteType.equalsIgnoreCase("solverGr")) {
                ((TimetableManagerForm)this.form).removeFromSolverGrs(this.deleteId);
            }
            if (this.deleteType.equalsIgnoreCase("role")) {
                ((TimetableManagerForm)this.form).removeFromRoles(this.deleteId);
                if (((TimetableManagerForm)this.form).getRoles().size() == 1) {
                    ((TimetableManagerForm)this.form).setPrimaryRole(((TimetableManagerForm)this.form).getRoles(0));
                }
                if (!(((TimetableManagerForm)this.form).getRoles().size() <= 1 || ((TimetableManagerForm)this.form).getPrimaryRole() != null && ((TimetableManagerForm)this.form).getRoles().contains(((TimetableManagerForm)this.form).getPrimaryRole()))) {
                    ((TimetableManagerForm)this.form).setPrimaryRole(((TimetableManagerForm)this.form).getRoles(0));
                }
            }
        }
        if (MSG.actionDeleteManager().equals(this.op) && this.deleteId == null && (this.deleteType == null || this.deleteType.isEmpty())) {
            this.deleteManager();
            return "displayManagerList";
        }
        this.lookupManager();
        this.setupRoles();
        if (((TimetableManagerForm)this.form).getOtherSessions() == null) {
            this.setupOtherSessions(false);
        }
        return ((TimetableManagerForm)this.form).getUniqueId() == null || ((TimetableManagerForm)this.form).getUniqueId() < 0L ? "addManagerInfo" : "editManagerInfo";
    }

    private void lookupManager() throws Exception {
        try {
            String id = ((TimetableManagerForm)this.form).getExternalId();
            if (id != null && id.trim().length() > 0 && ((TimetableManagerForm)this.form).getLookupEnabled().booleanValue()) {
                String className = ApplicationProperty.ManagerExternalIdLookupClass.value();
                ExternalUidLookup lookup = (ExternalUidLookup)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ExternalUidLookup.UserInfo results = lookup.doLookup(id);
                if (results == null) {
                    return;
                }
                ((TimetableManagerForm)this.form).setExternalId(results.getExternalId());
                ((TimetableManagerForm)this.form).setLookupResult(results.getUserName());
                if (((TimetableManagerForm)this.form).getFirstName() == null || ((TimetableManagerForm)this.form).getFirstName().trim().length() == 0) {
                    ((TimetableManagerForm)this.form).setFirstName(results.getFirstName());
                }
                if (((TimetableManagerForm)this.form).getMiddleName() == null || ((TimetableManagerForm)this.form).getMiddleName().trim().length() == 0) {
                    ((TimetableManagerForm)this.form).setMiddleName(results.getMiddleName());
                }
                if (((TimetableManagerForm)this.form).getLastName() == null || ((TimetableManagerForm)this.form).getLastName().trim().length() == 0) {
                    ((TimetableManagerForm)this.form).setLastName(results.getLastName());
                }
                if (((TimetableManagerForm)this.form).getTitle() == null || ((TimetableManagerForm)this.form).getTitle().trim().length() == 0) {
                    ((TimetableManagerForm)this.form).setTitle(results.getAcademicTitle());
                }
                if (((TimetableManagerForm)this.form).getEmail() == null || ((TimetableManagerForm)this.form).getEmail().trim().length() == 0) {
                    ((TimetableManagerForm)this.form).setEmail(results.getEmail());
                }
            }
        }
        catch (Exception e) {
            Debug.error(MSG.errorLookupManager(e.getMessage()), e);
            this.addFieldError("form.externalId", MSG.errorLookupManager(e.getMessage()));
        }
    }

    private void setupRoles() {
        Iterator<Roles> i;
        Set<Roles> roles = Roles.findAll(true);
        if (!this.sessionContext.hasPermission(Right.SessionIndependent)) {
            i = roles.iterator();
            while (i.hasNext()) {
                if (!i.next().hasRight(Right.SessionIndependent)) continue;
                i.remove();
            }
        }
        if (((TimetableManagerForm)this.form).getRoleRefs() != null && !((TimetableManagerForm)this.form).getRoleRefs().isEmpty()) {
            i = roles.iterator();
            while (i.hasNext()) {
                if (!((TimetableManagerForm)this.form).getRoleRefs().contains(i.next().getReference())) continue;
                i.remove();
            }
        }
        this.request.setAttribute(Roles.ROLES_ATTR_NAME, roles);
    }

    private void setupOtherSessions(boolean defaultSelection) {
        Long currentSessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        ArrayList<IdValue> sessions = new ArrayList<IdValue>();
        TimetableManager mgr = ((TimetableManagerForm)this.form).getUniqueId() == null ? null : (TimetableManager)TimetableManagerDAO.getInstance().get(((TimetableManagerForm)this.form).getUniqueId());
        ArrayList<Long> defaultSelectedSessionIds = new ArrayList<Long>();
        boolean past = true;
        for (Session session : SessionDAO.getInstance().getSession().createQuery("select s from Session s, Session z where z.uniqueId = :sessionId and s.academicInitiative = z.academicInitiative and (s.uniqueId = :sessionId or bitand(s.statusType.status, 7572918) > 0) order by s.sessionBeginDateTime", Session.class).setParameter("sessionId", (Object)currentSessionId).setCacheable(true).list()) {
            IdValue s = new IdValue(session.getUniqueId(), session.getLabel(), null, !session.getUniqueId().equals(currentSessionId));
            sessions.add(s);
            if (session.getUniqueId().equals(currentSessionId)) {
                defaultSelectedSessionIds.add(session.getUniqueId());
                past = false;
                continue;
            }
            if (!defaultSelection) continue;
            if (mgr == null && !past) {
                defaultSelectedSessionIds.add(session.getUniqueId());
                continue;
            }
            if (mgr == null || !this.sameDepartments(mgr, currentSessionId, session.getUniqueId()) || !this.sameSolverGroups(mgr, currentSessionId, session.getUniqueId())) continue;
            defaultSelectedSessionIds.add(session.getUniqueId());
        }
        ((TimetableManagerForm)this.form).setOtherSessions(sessions);
        if (defaultSelection) {
            ((TimetableManagerForm)this.form).setUpdateSessions(defaultSelectedSessionIds);
        }
    }

    private boolean sameDepartments(TimetableManager mgr, Long s1, Long s2) {
        TreeSet<String> d1 = new TreeSet<String>();
        TreeSet<String> d2 = new TreeSet<String>();
        for (Department d : mgr.getDepartments()) {
            if (s1.equals(d.getSessionId())) {
                d1.add(d.getDeptCode());
            }
            if (!s2.equals(d.getSessionId())) continue;
            d2.add(d.getDeptCode());
        }
        return d1.equals(d2);
    }

    private boolean sameSolverGroups(TimetableManager mgr, Long s1, Long s2) {
        TreeSet<String> d1 = new TreeSet<String>();
        TreeSet<String> d2 = new TreeSet<String>();
        for (SolverGroup d : mgr.getSolverGroups()) {
            if (s1.equals(d.getSession().getUniqueId())) {
                d1.add(d.getAbbv());
            }
            if (!s2.equals(d.getSession().getUniqueId())) continue;
            d2.add(d.getAbbv());
        }
        return d1.equals(d2);
    }

    private void loadForm() throws Exception {
        this.sessionContext.checkPermission(this.id, "TimetableManager", Right.TimetableManagerEdit);
        ((TimetableManagerForm)this.form).setUniqueId(this.id);
        TimetableManager mgr = (TimetableManager)TimetableManagerDAO.getInstance().get(this.id);
        ((TimetableManagerForm)this.form).setEmail(mgr.getEmailAddress());
        ((TimetableManagerForm)this.form).setExternalId(mgr.getExternalUniqueId());
        Set<ManagerRole> rolesSet = mgr.getManagerRoles();
        ArrayList<ManagerRole> roles = new ArrayList<ManagerRole>(rolesSet);
        Collections.sort(roles, new RolesComparator());
        for (ManagerRole mgrRole : roles) {
            Roles role = mgrRole.getRole();
            ((TimetableManagerForm)this.form).addToRoles(role);
            if (mgrRole.isPrimary().booleanValue()) {
                ((TimetableManagerForm)this.form).setPrimaryRole(role.getRoleId());
            }
            ((TimetableManagerForm)this.form).getRoleReceiveEmailFlags().add(mgrRole.isReceiveEmails() == null ? Boolean.valueOf(false) : mgrRole.isReceiveEmails());
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        TreeSet<Department> depts = new TreeSet<Department>(mgr.getDepartments());
        for (Department dept : depts) {
            if (!dept.getSessionId().equals(sessionId)) continue;
            ((TimetableManagerForm)this.form).addToDepts(dept);
        }
        TreeSet<SolverGroup> sgs = new TreeSet<SolverGroup>(mgr.getSolverGroups());
        for (SolverGroup sg : sgs) {
            if (!sg.getSession().getUniqueId().equals(sessionId)) continue;
            ((TimetableManagerForm)this.form).addToSolverGrs(sg);
        }
        if (ApplicationProperty.ManagerExternalIdLookup.isTrue() && ApplicationProperty.ManagerExternalIdLookupClass.value() != null) {
            ((TimetableManagerForm)this.form).setLookupEnabled(Boolean.TRUE);
            ((TimetableManagerForm)this.form).setFirstName(mgr.getFirstName());
            ((TimetableManagerForm)this.form).setMiddleName(mgr.getMiddleName());
            ((TimetableManagerForm)this.form).setLastName(mgr.getLastName());
            ((TimetableManagerForm)this.form).setTitle(mgr.getAcademicTitle());
        } else {
            ((TimetableManagerForm)this.form).setLookupEnabled(Boolean.FALSE);
            ((TimetableManagerForm)this.form).setFirstName(mgr.getFirstName());
            ((TimetableManagerForm)this.form).setMiddleName(mgr.getMiddleName());
            ((TimetableManagerForm)this.form).setLastName(mgr.getLastName());
            ((TimetableManagerForm)this.form).setTitle(mgr.getAcademicTitle());
        }
    }

    private void addManager() throws Exception {
        this.sessionContext.checkPermission(Right.TimetableManagerAdd);
        this.lookupManager();
        TimetableManagerDAO mgrDao = TimetableManagerDAO.getInstance();
        RolesDAO rDao = RolesDAO.getInstance();
        DepartmentDAO dDao = DepartmentDAO.getInstance();
        SolverGroupDAO sgDao = SolverGroupDAO.getInstance();
        org.hibernate.Session hibSession = mgrDao.getSession();
        Transaction tx = hibSession.beginTransaction();
        TimetableManager mgr = new TimetableManager();
        mgr.setFirstName(((TimetableManagerForm)this.form).getFirstName());
        mgr.setMiddleName(((TimetableManagerForm)this.form).getMiddleName());
        mgr.setLastName(((TimetableManagerForm)this.form).getLastName());
        mgr.setAcademicTitle(((TimetableManagerForm)this.form).getTitle());
        mgr.setExternalUniqueId(((TimetableManagerForm)this.form).getExternalId());
        mgr.setEmailAddress(((TimetableManagerForm)this.form).getEmail());
        List<Long> roles = ((TimetableManagerForm)this.form).getRoles();
        List<Boolean> roleReceiveEmails = ((TimetableManagerForm)this.form).getRoleReceiveEmailFlags();
        Iterator<Boolean> receiveEmailIt = roleReceiveEmails.iterator();
        Iterator<Long> i = roles.iterator();
        while (i.hasNext()) {
            Roles role = (Roles)rDao.get(i.next());
            ManagerRole mgrRole = new ManagerRole();
            mgrRole.setRole(role);
            mgrRole.setTimetableManager(mgr);
            mgrRole.setPrimary(role.getRoleId().equals(((TimetableManagerForm)this.form).getPrimaryRole()));
            if (receiveEmailIt.hasNext()) {
                mgrRole.setReceiveEmails(receiveEmailIt.next());
            } else {
                mgrRole.setReceiveEmails(false);
            }
            mgr.addToManagerRoles(mgrRole);
        }
        hibSession.persist((Object)mgr);
        mgr.setDepartments(new HashSet<Department>());
        ArrayList<Department> departments = new ArrayList<Department>();
        Iterator i2 = ((TimetableManagerForm)this.form).getDepts().iterator();
        while (i2.hasNext()) {
            Department dept = (Department)dDao.get((Long)i2.next());
            mgr.getDepartments().add(dept);
            dept.getTimetableManagers().add(mgr);
            hibSession.merge((Object)dept);
            departments.add(dept);
        }
        mgr.setSolverGroups(new HashSet<SolverGroup>());
        ArrayList<SolverGroup> solverGroups = new ArrayList<SolverGroup>();
        Iterator<Long> i3 = ((TimetableManagerForm)this.form).getSolverGrs().iterator();
        while (i3.hasNext()) {
            SolverGroup sg = (SolverGroup)sgDao.get(i3.next());
            mgr.getSolverGroups().add(sg);
            sg.getTimetableManagers().add(mgr);
            hibSession.merge((Object)sg);
            solverGroups.add(sg);
        }
        if (((TimetableManagerForm)this.form).getUpdateSessions() != null) {
            Long currentSessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
            for (Long sessionId : ((TimetableManagerForm)this.form).getUpdateSessions()) {
                Comparable<Department> other;
                if (sessionId.equals(currentSessionId)) continue;
                for (Department dept : departments) {
                    other = dept.findSameDepartmentInSession(sessionId);
                    if (other == null) continue;
                    mgr.getDepartments().add((Department)other);
                    ((BaseDepartment)((Object)other)).getTimetableManagers().add(mgr);
                    hibSession.merge(other);
                }
                for (SolverGroup sg : solverGroups) {
                    other = SolverGroup.findBySessionIdAbbv(sessionId, sg.getAbbv());
                    if (other == null) continue;
                    mgr.getSolverGroups().add((SolverGroup)other);
                    ((BaseSolverGroup)((Object)other)).getTimetableManagers().add(mgr);
                    hibSession.merge((Object)sg);
                }
            }
        }
        ChangeLog.addChange(hibSession, this.sessionContext, mgr, ChangeLog.Source.MANAGER_EDIT, ChangeLog.Operation.CREATE, null, null);
        tx.commit();
        ((TimetableManagerForm)this.form).setUniqueId(mgr.getUniqueId());
    }

    private void updateManager() throws Exception {
        boolean found;
        Iterator<Object> i;
        this.sessionContext.checkPermission(((TimetableManagerForm)this.form).getUniqueId(), "TimetableManager", Right.TimetableManagerEdit);
        this.lookupManager();
        TimetableManagerDAO mgrDao = TimetableManagerDAO.getInstance();
        RolesDAO rDao = RolesDAO.getInstance();
        DepartmentDAO dDao = DepartmentDAO.getInstance();
        SolverGroupDAO sgDao = SolverGroupDAO.getInstance();
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        org.hibernate.Session hibSession = mgrDao.getSession();
        Transaction tx = hibSession.beginTransaction();
        TimetableManager mgr = (TimetableManager)mgrDao.get(Long.valueOf(((TimetableManagerForm)this.form).getUniqueId()));
        mgr.setFirstName(((TimetableManagerForm)this.form).getFirstName());
        mgr.setMiddleName(((TimetableManagerForm)this.form).getMiddleName());
        mgr.setLastName(((TimetableManagerForm)this.form).getLastName());
        mgr.setAcademicTitle(((TimetableManagerForm)this.form).getTitle());
        mgr.setExternalUniqueId(((TimetableManagerForm)this.form).getExternalId());
        mgr.setEmailAddress(((TimetableManagerForm)this.form).getEmail());
        List<Long> roles = ((TimetableManagerForm)this.form).getRoles();
        List<Boolean> roleReceiveEmails = ((TimetableManagerForm)this.form).getRoleReceiveEmailFlags();
        Set<ManagerRole> mgrRoles = mgr.getManagerRoles();
        if (mgrRoles == null) {
            mgrRoles = new HashSet<ManagerRole>();
        }
        Iterator<Boolean> receiveEmailIt = roleReceiveEmails.iterator();
        Iterator<Long> i2 = roles.iterator();
        while (i2.hasNext()) {
            Roles role = (Roles)rDao.get(i2.next());
            Boolean receiveEmail = false;
            if (receiveEmailIt.hasNext()) {
                receiveEmail = receiveEmailIt.next();
            }
            boolean found2 = false;
            for (ManagerRole eMgrRole : mgrRoles) {
                Roles eRole = eMgrRole.getRole();
                if (!eRole.equals(role)) continue;
                eMgrRole.setPrimary(role.getRoleId().equals(((TimetableManagerForm)this.form).getPrimaryRole()));
                eMgrRole.setReceiveEmails(receiveEmail);
                found2 = true;
                break;
            }
            if (found2) continue;
            ManagerRole mgrRole = new ManagerRole();
            mgrRole.setRole(role);
            mgrRole.setTimetableManager(mgr);
            mgrRole.setPrimary(role.getRoleId().equals(((TimetableManagerForm)this.form).getPrimaryRole()));
            mgrRole.setReceiveEmails(receiveEmail);
            mgr.addToManagerRoles(mgrRole);
        }
        Iterator<ManagerRole> j = mgrRoles.iterator();
        while (j.hasNext()) {
            ManagerRole eMgrRole = j.next();
            Roles eRole = eMgrRole.getRole();
            boolean found2 = false;
            Iterator<Long> i3 = roles.iterator();
            while (i3.hasNext()) {
                Roles role = (Roles)rDao.get(i3.next());
                if (!eRole.equals(role)) continue;
                found2 = true;
                break;
            }
            if (found2) continue;
            j.remove();
        }
        List depts = ((TimetableManagerForm)this.form).getDepts();
        ArrayList<Department> departments = new ArrayList<Department>();
        Set<Department> mgrDepts = mgr.getDepartments();
        if (mgrDepts == null) {
            mgrDepts = new HashSet<Department>();
            mgr.setDepartments(mgrDepts);
        }
        Iterator i4 = depts.iterator();
        while (i4.hasNext()) {
            Department dept = (Department)dDao.get((Long)i4.next());
            departments.add(dept);
            boolean found3 = false;
            for (Department eDept : mgrDepts) {
                if (!eDept.equals(dept)) continue;
                found3 = true;
                break;
            }
            if (found3) continue;
            mgrDepts.add(dept);
            dept.getTimetableManagers().add(mgr);
            hibSession.merge((Object)dept);
        }
        Iterator<Department> j2 = mgrDepts.iterator();
        while (j2.hasNext()) {
            Department eDept = j2.next();
            if (!eDept.getSessionId().equals(sessionId)) continue;
            boolean found4 = false;
            i = depts.iterator();
            while (i.hasNext()) {
                Department dept = (Department)dDao.get((Long)i.next());
                if (!eDept.equals(dept)) continue;
                found4 = true;
                break;
            }
            if (found4) continue;
            j2.remove();
            eDept.getTimetableManagers().remove(mgr);
            hibSession.merge((Object)eDept);
        }
        List<Long> solverGrs = ((TimetableManagerForm)this.form).getSolverGrs();
        ArrayList<SolverGroup> solverGroups = new ArrayList<SolverGroup>();
        Set<SolverGroup> mgrSolverGrs = mgr.getSolverGroups();
        if (mgrSolverGrs == null) {
            mgrSolverGrs = new HashSet<SolverGroup>();
            mgr.setSolverGroups(mgrSolverGrs);
        }
        i = solverGrs.iterator();
        while (i.hasNext()) {
            SolverGroup sg = (SolverGroup)sgDao.get((Long)i.next());
            solverGroups.add(sg);
            found = false;
            for (SolverGroup eSg : mgrSolverGrs) {
                if (!eSg.equals(sg)) continue;
                found = true;
                break;
            }
            if (found) continue;
            mgrSolverGrs.add(sg);
            sg.getTimetableManagers().add(mgr);
            hibSession.merge((Object)sg);
        }
        Iterator<SolverGroup> j3 = mgrSolverGrs.iterator();
        while (j3.hasNext()) {
            SolverGroup eSg = j3.next();
            if (!eSg.getSession().getUniqueId().equals(sessionId)) continue;
            found = false;
            Iterator<Long> iterator = solverGrs.iterator();
            while (iterator.hasNext()) {
                SolverGroup sg = (SolverGroup)sgDao.get(iterator.next());
                if (!eSg.equals(sg)) continue;
                found = true;
                break;
            }
            if (found) continue;
            j3.remove();
            eSg.getTimetableManagers().remove(mgr);
            hibSession.merge((Object)eSg);
        }
        if (((TimetableManagerForm)this.form).getUpdateSessions() != null) {
            for (Long otherSessionId : ((TimetableManagerForm)this.form).getUpdateSessions()) {
                Comparable<Department> other;
                if (otherSessionId.equals(sessionId)) continue;
                mgrDepts = new HashSet<Department>(mgr.getDepartments());
                for (Department department : departments) {
                    other = department.findSameDepartmentInSession(otherSessionId);
                    if (other == null || mgrDepts.remove(other)) continue;
                    mgr.getDepartments().add((Department)other);
                    ((BaseDepartment)((Object)other)).getTimetableManagers().add(mgr);
                    hibSession.merge((Object)other);
                }
                for (Department department : mgrDepts) {
                    if (!department.getSessionId().equals(otherSessionId)) continue;
                    mgr.getDepartments().remove(department);
                    department.getTimetableManagers().remove(mgr);
                    hibSession.merge((Object)department);
                }
                mgrSolverGrs = new HashSet<SolverGroup>(mgr.getSolverGroups());
                for (SolverGroup solverGroup : solverGroups) {
                    other = SolverGroup.findBySessionIdAbbv(otherSessionId, solverGroup.getAbbv());
                    if (other == null || mgrSolverGrs.remove(other)) continue;
                    mgr.getSolverGroups().add((SolverGroup)other);
                    ((BaseSolverGroup)((Object)other)).getTimetableManagers().add(mgr);
                    hibSession.merge(other);
                }
                for (SolverGroup solverGroup : mgrSolverGrs) {
                    if (!solverGroup.getSession().getUniqueId().equals(otherSessionId)) continue;
                    mgr.getSolverGroups().remove(solverGroup);
                    solverGroup.getTimetableManagers().remove(mgr);
                    hibSession.merge((Object)solverGroup);
                }
            }
        }
        hibSession.merge((Object)mgr);
        ChangeLog.addChange(hibSession, this.sessionContext, mgr, ChangeLog.Source.MANAGER_EDIT, ChangeLog.Operation.UPDATE, null, null);
        tx.commit();
    }

    private void deleteManager() {
        this.sessionContext.checkPermission(((TimetableManagerForm)this.form).getUniqueId(), "TimetableManager", Right.TimetableManagerEdit);
        TimetableManagerDAO mgrDao = TimetableManagerDAO.getInstance();
        org.hibernate.Session hibSession = mgrDao.getSession();
        TimetableManager mgr = (TimetableManager)mgrDao.get(((TimetableManagerForm)this.form).getUniqueId());
        Transaction tx = hibSession.beginTransaction();
        ChangeLog.addChange(hibSession, this.sessionContext, mgr, ChangeLog.Source.MANAGER_EDIT, ChangeLog.Operation.DELETE, null, null);
        for (ManagerRole mgrRole : mgr.getManagerRoles()) {
            hibSession.remove((Object)mgrRole);
        }
        for (Department d : mgr.getDepartments()) {
            d.getTimetableManagers().remove(mgr);
            hibSession.merge((Object)d);
        }
        for (SolverGroup sg : mgr.getSolverGroups()) {
            sg.getTimetableManagers().remove(mgr);
            hibSession.merge((Object)sg);
        }
        hibSession.remove((Object)mgr);
        tx.commit();
    }

    public String getSession() {
        return this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel();
    }
}

