/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.CSVFile;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.TimePatternEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.Navigation;

@Action(value="timePatternEdit", results={@Result(name={"list"}, type="tiles", location="timePatternList.tiles"), @Result(name={"add"}, type="tiles", location="timePatternAdd.tiles"), @Result(name={"edit"}, type="tiles", location="timePatternEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="timePatternList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Time Patterns"), @TilesPutAttribute(name="body", value="/admin/timePatterns.jsp")}), @TilesDefinition(name="timePatternAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Time Pattern"), @TilesPutAttribute(name="body", value="/admin/timePatterns.jsp")}), @TilesDefinition(name="timePatternEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Time Pattern"), @TilesPutAttribute(name="body", value="/admin/timePatterns.jsp")})})
public class TimePatternEditAction
extends UniTimeAction<TimePatternEditForm> {
    private static final long serialVersionUID = 4079082627336504012L;
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long id;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String execute() throws Exception {
        Session hibSession;
        Transaction tx;
        if (this.form == null) {
            this.form = new TimePatternEditForm();
        }
        this.sessionContext.checkPermission(Right.TimePatterns);
        if (this.op == null) {
            this.op = ((TimePatternEditForm)this.form).getOp();
        }
        if (this.op == null) {
            ((TimePatternEditForm)this.form).reset();
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        List list = DepartmentDAO.getInstance().getSession().createQuery("from Department where session.uniqueId = :sessionId order by deptCode", Department.class).setParameter("sessionId", (Object)sessionId).list();
        ArrayList<IdValue> availableDepts = new ArrayList<IdValue>();
        for (Department d : list) {
            availableDepts.add(new IdValue(d.getUniqueId(), d.getLabel()));
        }
        this.request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
        if (MSG.actionBackToTimePatterns().equals(this.op)) {
            if (((TimePatternEditForm)this.form).getUniqueId() != null) {
                this.request.setAttribute("hash", (Object)((TimePatternEditForm)this.form).getUniqueId());
            }
            ((TimePatternEditForm)this.form).reset();
        }
        if (MSG.actionAddDepartment().equals(this.op)) {
            if (((TimePatternEditForm)this.form).getDepartmentId() == null || ((TimePatternEditForm)this.form).getDepartmentId() < 0L) {
                this.addFieldError("form.department", MSG.errorNoDepartmentSelected());
            } else {
                boolean contains = ((TimePatternEditForm)this.form).getDepartmentIds().contains(((TimePatternEditForm)this.form).getDepartmentId());
                if (contains) {
                    this.addFieldError("form.department", MSG.errorDepartmentAlreadyListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((TimePatternEditForm)this.form).getDepartmentIds().add(((TimePatternEditForm)this.form).getDepartmentId());
            }
            ((TimePatternEditForm)this.form).setOp(((TimePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveTimePattern() : MSG.actionUpdateTimePattern());
        }
        if (MSG.actionRemoveDepartment().equals(this.op)) {
            if (((TimePatternEditForm)this.form).getDepartmentId() == null || ((TimePatternEditForm)this.form).getDepartmentId() < 0L) {
                this.addFieldError("form.department", MSG.errorNoDepartmentSelected());
            } else {
                boolean contains = ((TimePatternEditForm)this.form).getDepartmentIds().contains(((TimePatternEditForm)this.form).getDepartmentId());
                if (!contains) {
                    this.addFieldError("form.department", MSG.errorDepartmentNotListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((TimePatternEditForm)this.form).getDepartmentIds().remove(((TimePatternEditForm)this.form).getDepartmentId());
            }
            ((TimePatternEditForm)this.form).setOp(((TimePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveTimePattern() : MSG.actionUpdateTimePattern());
        }
        if (MSG.actionSaveTimePattern().equals(this.op) || MSG.actionUpdateTimePattern().equals(this.op) || MSG.actionPreviousTimePattern().equals(this.op) || MSG.actionNextTimePattern().equals(this.op)) {
            ((TimePatternEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                ((TimePatternEditForm)this.form).setOp(((TimePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
            } else {
                tx = null;
                try {
                    hibSession = TimePatternDAO.getInstance().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ((TimePatternEditForm)this.form).saveOrUpdate(this.sessionContext, hibSession);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                if (MSG.actionNextTimePattern().equals(this.op) && ((TimePatternEditForm)this.form).getNextId() != null) {
                    this.response.sendRedirect(this.response.encodeURL("timePatternEdit.action?op=Edit&id=" + ((TimePatternEditForm)this.form).getNextId()));
                } else if (MSG.actionPreviousTimePattern().equals(this.op) && ((TimePatternEditForm)this.form).getPreviousId() != null) {
                    this.response.sendRedirect(this.response.encodeURL("timePatternEdit.action?op=Edit&id=" + ((TimePatternEditForm)this.form).getPreviousId()));
                } else {
                    if (((TimePatternEditForm)this.form).getUniqueId() != null) {
                        this.request.setAttribute("hash", (Object)((TimePatternEditForm)this.form).getUniqueId());
                    }
                    ((TimePatternEditForm)this.form).reset();
                }
            }
        }
        if ("Edit".equals(this.op)) {
            if (this.id == null && ((TimePatternEditForm)this.form).getUniqueId() != null) {
                this.id = ((TimePatternEditForm)this.form).getUniqueId();
            }
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField("Id"));
                return "list";
            }
            TimePattern pattern = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(this.id));
            ((TimePatternEditForm)this.form).setPreviousId(Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, (long)this.id));
            ((TimePatternEditForm)this.form).setNextId(Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, (long)this.id));
            if (pattern == null) {
                this.addFieldError("form.uniqueId", MSG.errorDoesNotExists(MSG.columnTimePattern()));
                return "list";
            }
            ((TimePatternEditForm)this.form).load(pattern, sessionId);
        }
        if (MSG.actionDeleteTimePattern().equals(this.op)) {
            tx = null;
            try {
                hibSession = TimePatternDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                ((TimePatternEditForm)this.form).delete(this.sessionContext, hibSession);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((TimePatternEditForm)this.form).reset();
        }
        if (MSG.actionExactTimesCSV().equals(this.op)) {
            tx = null;
            try {
                TimePattern tp;
                hibSession = TimePatternDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                if ((tp = TimePattern.findExactTime(sessionId)) == null) {
                    ((TimePatternEditForm)this.form).reset();
                    this.getTimePatterns(sessionId);
                    this.addFieldError("form.uniqueId", MSG.errorNoExactTimePatternDefined());
                    return "list";
                }
                List timePrefs = hibSession.createQuery("select distinct p from TimePref as p inner join p.timePattern as tp where tp.uniqueId=:uniqueid", TimePref.class).setParameter("uniqueid", (Object)tp.getUniqueId()).list();
                CSVFile csv = new CSVFile();
                csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)MSG.columnClass()), new CSVFile.CSVField((Object)MSG.columnTimePattern()), new CSVFile.CSVField((Object)MSG.columnAssignedTime())});
                for (TimePref tpref : timePrefs) {
                    int minPerMtg;
                    Class_ clazz;
                    if (!(tpref.getOwner() instanceof Class_) || !(clazz = (Class_)tpref.getOwner()).getSessionId().equals(sessionId)) continue;
                    int dayCode = tpref.getTimePatternModel().getExactDays();
                    Object name = "";
                    int nrDays = 0;
                    for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
                        if ((Constants.DAY_CODES[j] & dayCode) == 0) continue;
                        name = (String)name + CONSTANTS.shortDays()[j];
                        ++nrDays;
                    }
                    name = (String)name + " ";
                    int startSlot = tpref.getTimePatternModel().getExactStartSlot();
                    name = (String)name + Constants.toTime(Constants.FIRST_SLOT_TIME_MIN + Constants.SLOT_LENGTH_MIN * startSlot);
                    DurationModel dm = clazz.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
                    int n = minPerMtg = nrDays == 0 ? 0 : dm.getExactTimeMinutesPerMeeting(clazz.getSchedulingSubpart().getMinutesPerWk(), clazz.effectiveDatePattern(), dayCode);
                    if (nrDays == 0) {
                        Debug.warning("Class " + clazz.getClassLabel() + " has zero number of days.");
                    }
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)clazz.getClassLabel()), new CSVFile.CSVField((Object)(nrDays + " x " + minPerMtg)), new CSVFile.CSVField(name)});
                }
                if (tx != null) {
                    tx.commit();
                }
                ExportUtils.exportCSV(csv, this.response, "exact");
                return null;
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        if ("Generate SQL".equals(this.op)) {
            try (PrintWriter out = ExportUtils.getPlainTextWriter(this.response, "tp.sql");){
                TreeSet<TimePattern> patterns = new TreeSet<TimePattern>(TimePattern.findAll(sessionId, null));
                boolean mysql = false;
                int line = 0;
                if (mysql) {
                    out.println("INSERT INTO `timetable`.`time_pattern`(`uniqueid`, `name`, `mins_pmt`, `slots_pmt`, `nr_mtgs`, `visible`, `type`, `break_time`, `session_id`)");
                } else {
                    out.println("prompt Loading TIME_PATTERN...");
                }
                for (TimePattern tp : patterns) {
                    if (tp.isExtended() || !tp.isVisible().booleanValue()) continue;
                    if (mysql) {
                        if (line == 0) {
                            out.print("VALUES");
                        } else {
                            out.println(",");
                        }
                        out.print(" (" + tp.getUniqueId() + ", '" + tp.getName() + "', " + tp.getMinPerMtg() + ", " + tp.getSlotsPerMtg() + ", " + tp.getNrMeetings() + ", " + (tp.isVisible() != false ? "1" : "0") + ", " + tp.getType() + ", " + tp.getBreakTime() + ", " + sessionId + ")");
                    } else {
                        out.println("insert into TIME_PATTERN (UNIQUEID, NAME, MINS_PMT, SLOTS_PMT, NR_MTGS, VISIBLE, TYPE, BREAK_TIME, SESSION_ID)");
                        out.println("values (" + tp.getUniqueId() + ", '" + tp.getName() + "', " + tp.getMinPerMtg() + ", " + tp.getSlotsPerMtg() + ", " + tp.getNrMeetings() + ", " + (tp.isVisible() != false ? "1" : "0") + ", " + tp.getType() + ", " + tp.getBreakTime() + ", " + sessionId + ");");
                    }
                    ++line;
                }
                if (mysql) {
                    out.println(";");
                } else {
                    out.println("commit;");
                    out.println("prompt " + line + " records loaded");
                }
                out.println();
                line = 0;
                if (mysql) {
                    out.println("INSERT INTO `timetable`.`time_pattern_days`(`uniqueid`, `day_code`, `time_pattern_id`)");
                } else {
                    out.println("prompt Loading TIME_PATTERN_DAYS...");
                }
                for (TimePattern tp : patterns) {
                    if (tp.isExtended() || !tp.isVisible().booleanValue()) continue;
                    for (TimePatternDays d : tp.getDays()) {
                        if (mysql) {
                            if (line == 0) {
                                out.print("VALUES");
                            } else {
                                out.println(",");
                            }
                            out.print(" (" + d.getUniqueId() + ", " + d.getDayCode() + ", " + tp.getUniqueId() + ")");
                        } else {
                            out.println("insert into TIME_PATTERN_DAYS (UNIQUEID, DAY_CODE, TIME_PATTERN_ID)");
                            out.println("values (" + d.getUniqueId() + ", " + d.getDayCode() + ", " + tp.getUniqueId() + ");");
                        }
                        ++line;
                    }
                }
                if (mysql) {
                    out.println(";");
                } else {
                    out.println("commit;");
                    out.println("prompt " + line + " records loaded");
                }
                out.println();
                line = 0;
                if (mysql) {
                    out.println("INSERT INTO `timetable`.`time_pattern_time`(`uniqueid`, `start_slot`, `time_pattern_id`)");
                } else {
                    out.println("prompt Loading TIME_PATTERN_TIME...");
                }
                for (TimePattern tp : patterns) {
                    if (tp.isExtended() || !tp.isVisible().booleanValue()) continue;
                    for (TimePatternTime t : tp.getTimes()) {
                        if (mysql) {
                            if (line == 0) {
                                out.print("VALUES");
                            } else {
                                out.println(",");
                            }
                            out.print(" (" + t.getUniqueId() + ", " + t.getStartSlot() + ", " + tp.getUniqueId() + ")");
                        } else {
                            out.println("insert into TIME_PATTERN_TIME (UNIQUEID, START_SLOT, TIME_PATTERN_ID)");
                            out.println("values (" + t.getUniqueId() + ", " + t.getStartSlot() + ", " + tp.getUniqueId() + ");");
                        }
                        ++line;
                    }
                }
                if (mysql) {
                    out.println(";");
                } else {
                    out.println("commit;");
                    out.println("prompt " + line + " records loaded");
                }
                out.flush();
                out.close();
                out = null;
                Iterator<TimePattern> i = null;
                return i;
            }
        }
        if (MSG.actionAssingDepartmentsToTimePatterns().equals(this.op)) {
            tx = null;
            HashSet<TimePattern> refresh = new HashSet<TimePattern>();
            try (PrintWriter out = null;){
                Session hibSession2 = TimePatternDAO.getInstance().getSession();
                if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                    tx = hibSession2.beginTransaction();
                }
                File file = ApplicationProperties.getTempFile("assigndept", "txt");
                out = new PrintWriter(new FileWriter(file));
                TreeSet<TimePattern> patterns = new TreeSet<TimePattern>(TimePattern.findAll(sessionId, null));
                for (TimePattern tp : patterns) {
                    if (!tp.isExtended()) continue;
                    out.println("Checking " + tp.getName() + " ...");
                    List timePrefs = hibSession2.createQuery("select distinct p from TimePref as p inner join p.timePattern as tp where tp.uniqueId=:uniqueid", TimePref.class).setParameter("uniqueid", (Object)tp.getUniqueId()).list();
                    HashSet<Department> depts = new HashSet<Department>();
                    for (TimePref timePref : timePrefs) {
                        SchedulingSubpart s;
                        if (timePref.getOwner() instanceof Class_) {
                            Class_ c = (Class_)timePref.getOwner();
                            if (!c.getSession().getUniqueId().equals(sessionId)) continue;
                            depts.add(c.getManagingDept());
                            continue;
                        }
                        if (!(timePref.getOwner() instanceof SchedulingSubpart) || !(s = (SchedulingSubpart)timePref.getOwner()).getSession().getUniqueId().equals(sessionId)) continue;
                        depts.add(s.getManagingDept());
                    }
                    out.println("  -- departments: " + depts);
                    boolean added = false;
                    for (Department d : depts) {
                        if (d.isExternalManager().booleanValue() || tp.getDepartments().contains(d)) continue;
                        tp.getDepartments().add(d);
                        d.getTimePatterns().add(tp);
                        hibSession2.merge((Object)d);
                        out.println("    -- department " + d + " added to " + tp.getName());
                        added = true;
                    }
                    if (!added) continue;
                    hibSession2.merge((Object)tp);
                    refresh.add(tp);
                }
                out.flush();
                out.close();
                out = null;
                this.request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                if (tx != null) {
                    tx.commit();
                }
                Iterator<TimePattern> i = refresh.iterator();
                while (i.hasNext()) {
                    hibSession2.refresh((Object)i.next());
                }
            }
            ((TimePatternEditForm)this.form).reset();
        }
        if (MSG.actionExportCsv().equals(this.op)) {
            tx = null;
            try {
                hibSession = TimePatternDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                CSVFile csv = new CSVFile();
                csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)MSG.columnTimePatternName()), new CSVFile.CSVField((Object)MSG.columnTimePatternType()), new CSVFile.CSVField((Object)MSG.columnTimePatternVisible()), new CSVFile.CSVField((Object)MSG.columnTimePatternUsed()), new CSVFile.CSVField((Object)MSG.columnTimePatternNbrMtgs()), new CSVFile.CSVField((Object)MSG.columnTimePatternMinPerMtg()), new CSVFile.CSVField((Object)MSG.columnTimePatternSlotsPerMtg()), new CSVFile.CSVField((Object)MSG.columnTimePatternBreakTime()), new CSVFile.CSVField((Object)MSG.columnTimePatternDays()), new CSVFile.CSVField((Object)MSG.columnTimePatternTimes()), new CSVFile.CSVField((Object)MSG.columnTimePatternDepartments()), new CSVFile.CSVField((Object)MSG.columnTimePatternClasses())});
                TreeSet<TimePattern> patterns = new TreeSet<TimePattern>(TimePattern.findAll(sessionId, null));
                for (TimePattern tp : patterns) {
                    Object deptStr = "";
                    TreeSet<Department> depts = new TreeSet<Department>(tp.getDepartments());
                    for (Department d : depts) {
                        if (!d.getSessionId().equals(sessionId)) continue;
                        if (((String)deptStr).length() > 0) {
                            deptStr = (String)deptStr + ", ";
                        }
                        deptStr = (String)deptStr + d.getShortLabel().trim();
                    }
                    Object classStr = "";
                    if (tp.getTimePatternType() != TimePattern.TimePatternType.Standard) {
                        List timePrefs = hibSession.createQuery("select distinct p.owner from TimePref as p inner join p.timePattern as tp where tp.uniqueId=:uniqueid", PreferenceGroup.class).setParameter("uniqueid", (Object)tp.getUniqueId()).list();
                        TreeSet<String> allOwners = new TreeSet<String>();
                        for (Object owner : timePrefs) {
                            SchedulingSubpart s;
                            if (owner instanceof Class_) {
                                Class_ c = (Class_)owner;
                                if (!c.getSession().getUniqueId().equals(sessionId)) continue;
                                allOwners.add(c.getClassLabel());
                                continue;
                            }
                            if (!(owner instanceof SchedulingSubpart) || !(s = (SchedulingSubpart)owner).getSession().getUniqueId().equals(sessionId)) continue;
                            allOwners.add(s.getSchedulingSubpartLabel());
                        }
                        if (allOwners.isEmpty()) {
                            classStr = (String)classStr + MSG.notUsed();
                        } else {
                            int idx = 0;
                            classStr = (String)classStr + allOwners.size() + " / ";
                            Iterator j = allOwners.iterator();
                            while (j.hasNext()) {
                                if (idx == 20) {
                                    classStr = (String)classStr + "...";
                                    break;
                                }
                                classStr = (String)classStr + (String)j.next();
                                if (j.hasNext()) {
                                    classStr = (String)classStr + ", ";
                                }
                                ++idx;
                            }
                        }
                    }
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)tp.getName()), new CSVFile.CSVField((Object)tp.getTimePatternType().getLabel()), new CSVFile.CSVField((Object)(tp.isVisible() != false ? MSG.csvTrue() : MSG.csvFalse())), new CSVFile.CSVField((Object)(tp.isEditable() ? MSG.csvFalse() : MSG.csvTrue())), new CSVFile.CSVField((Object)tp.getNrMeetings()), new CSVFile.CSVField((Object)tp.getMinPerMtg()), new CSVFile.CSVField((Object)tp.getSlotsPerMtg()), new CSVFile.CSVField((Object)tp.getBreakTime()), new CSVFile.CSVField((Object)TimePatternEditForm.dayCodes2str(tp.getDays(), ", ")), new CSVFile.CSVField((Object)TimePatternEditForm.startSlots2str(tp.getTimes(), ", ")), new CSVFile.CSVField(deptStr), new CSVFile.CSVField(classStr)});
                }
                if (tx != null) {
                    tx.commit();
                }
                ExportUtils.exportCSV(csv, this.response, "timePatterns");
                return null;
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        if (MSG.actionAddTimePattern().equals(this.op)) {
            ((TimePatternEditForm)this.form).load(null, null);
        }
        if ("List".equals(((TimePatternEditForm)this.form).getOp())) {
            this.getTimePatterns(sessionId);
            return "list";
        }
        String example = ((TimePatternEditForm)this.form).getExample();
        if (example != null) {
            this.request.setAttribute("example", (Object)example);
        }
        return ((TimePatternEditForm)this.form).getUniqueId() < 0L ? "add" : "edit";
    }

    private void getTimePatterns(Long sessionId) throws Exception {
        WebTable.setOrder(this.sessionContext, "timePatterns.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(10, null, "timePatternEdit.action?ord=%%", new String[]{MSG.columnTimePatternName(), MSG.columnTimePatternType(), MSG.columnTimePatternUsed(), MSG.columnTimePatternNbrMtgs(), MSG.columnTimePatternMinPerMtg(), MSG.columnTimePatternSlotsPerMtg(), MSG.columnTimePatternBreakTime(), MSG.columnTimePatternDays(), MSG.columnTimePatternTimes(), MSG.columnTimePatternDepartments()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
        List<TimePattern> patterns = TimePattern.findAll(sessionId, null);
        if (patterns.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.errorNoTimePatternsDefined()}, null, null);
        }
        Set used = TimePattern.findAllUsed(sessionId);
        for (TimePattern pattern : patterns) {
            String onClick = "onClick=\"document.location='timePatternEdit.action?op=Edit&id=" + pattern.getUniqueId() + "';\"";
            Object deptStr = "";
            Object deptCmp = "";
            Iterator i = pattern.getDepartments(sessionId).iterator();
            while (i.hasNext()) {
                Department d = (Department)i.next();
                deptStr = (String)deptStr + d.getManagingDeptAbbv().trim();
                deptCmp = (String)deptCmp + d.getDeptCode();
                if (!i.hasNext()) continue;
                deptStr = (String)deptStr + ", ";
                deptCmp = (String)deptCmp + ",";
            }
            boolean isUsed = used.contains(pattern);
            webTable.addLine(onClick, new String[]{(pattern.isVisible() != false ? "" : "<font color='grey'>") + pattern.getName().replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getTimePatternType().getLabel().replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>"), isUsed ? "<IMG border='0' title='" + MSG.hintTimePatternUsed() + "' alt='Default' align='absmiddle' src='images/accept.png'>" : "", (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getNrMeetings().toString() + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getMinPerMtg().toString() + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getSlotsPerMtg().toString() + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getBreakTime().toString() + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + TimePatternEditForm.dayCodes2str(pattern.getDays(), ", ") + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + TimePatternEditForm.startSlots2str(pattern.getTimes(), ", ") + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)deptStr + (pattern.isVisible() != false ? "" : "</font>")}, new Comparable[]{pattern.getName(), pattern.getType(), isUsed ? "0" : "1", pattern.getNrMeetings(), pattern.getMinPerMtg(), pattern.getSlotsPerMtg(), pattern.getBreakTime(), TimePatternEditForm.dayCodes2str(pattern.getDays(), ", "), TimePatternEditForm.startSlots2str(pattern.getTimes(), ", "), deptCmp}, pattern.getUniqueId().toString());
        }
        this.request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "timePatterns.ord")));
        ArrayList<Long> ids = new ArrayList<Long>();
        Enumeration e = webTable.getLines().elements();
        while (e.hasMoreElements()) {
            WebTable.WebTableLine line = (WebTable.WebTableLine)e.nextElement();
            if (line.getUniqueId() == null) continue;
            ids.add(Long.parseLong(line.getUniqueId()));
        }
        Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
    }
}

