/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.SubjectAreaEditForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalCourseOfferingRemoveAction;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Action(value="subjectAreaEdit", results={@Result(name={"add"}, type="tiles", location="subjectAreaAdd.tiles"), @Result(name={"edit"}, type="tiles", location="subjectAreaEdit.tiles"), @Result(name={"back"}, type="redirect", location="/subjectList.action", params={"anchor", "${form.uniqueId}"})})
@TilesDefinitions(value={@TilesDefinition(name="subjectAreaAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Subject Area"), @TilesPutAttribute(name="body", value="/admin/subjectAreaEdit.jsp")}), @TilesDefinition(name="subjectAreaEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Subject Area"), @TilesPutAttribute(name="body", value="/admin/subjectAreaEdit.jsp")})})
public class SubjectAreaEditAction
extends UniTimeAction<SubjectAreaEditForm> {
    private static final long serialVersionUID = 5726515478142736794L;
    protected static final GwtMessages MSG = Localization.create(GwtMessages.class);
    private Long id;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new SubjectAreaEditForm();
        }
        this.sessionContext.checkPermission(Right.SubjectAreas);
        if (SubjectAreaEditAction.stripAccessKey(MSG.buttonAddSubjectArea()).equals(this.op)) {
            this.sessionContext.checkPermission(Right.SubjectAreaAdd);
            ((SubjectAreaEditForm)this.form).reset();
            LookupTables.setupNonExternalDepts(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return "add";
        }
        if ("edit".equals(this.op)) {
            this.doLoad();
            LookupTables.setupNonExternalDepts(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return "edit";
        }
        if (SubjectAreaEditAction.stripAccessKey(MSG.buttonSave()).equals(this.op) || SubjectAreaEditAction.stripAccessKey(MSG.buttonUpdate()).equals(this.op)) {
            ((SubjectAreaEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doUpdate();
            }
        }
        if (SubjectAreaEditAction.stripAccessKey(MSG.buttonDelete()).equals(this.op)) {
            ((SubjectAreaEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doDelete();
            }
        }
        if (this.hasFieldErrors()) {
            LookupTables.setupNonExternalDepts(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return ((SubjectAreaEditForm)this.form).getUniqueId() != null ? "edit" : "add";
        }
        return "back";
    }

    private void doLoad() throws Exception {
        this.sessionContext.checkPermission(this.id, "SubjectArea", Right.SubjectAreaEdit);
        SubjectArea sa = (SubjectArea)SubjectAreaDAO.getInstance().get(this.id);
        ((SubjectAreaEditForm)this.form).setUniqueId(this.id);
        ((SubjectAreaEditForm)this.form).setAbbv(sa.getSubjectAreaAbbreviation() != null ? sa.getSubjectAreaAbbreviation() : "");
        ((SubjectAreaEditForm)this.form).setDepartment(sa.getDepartment() != null ? sa.getDepartment().getUniqueId() : null);
        ((SubjectAreaEditForm)this.form).setExternalId(sa.getExternalUniqueId() != null ? sa.getExternalUniqueId() : "");
        ((SubjectAreaEditForm)this.form).setTitle(sa.getTitle() != null ? sa.getTitle() : "");
    }

    private void doDelete() throws Exception {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        this.sessionContext.checkPermission(((SubjectAreaEditForm)this.form).getUniqueId(), "SubjectArea", Right.SubjectAreaDelete);
        try {
            SubjectAreaDAO sdao = SubjectAreaDAO.getInstance();
            hibSession = sdao.getSession();
            tx = hibSession.beginTransaction();
            SubjectArea sa = (SubjectArea)sdao.get(((SubjectAreaEditForm)this.form).getUniqueId());
            String className = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
            if (className != null && className.trim().length() > 0) {
                ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (CourseOffering co : sa.getCourseOfferings()) {
                    removeAction.performExternalCourseOfferingRemoveAction(co, hibSession);
                }
            }
            for (CourseOffering co : sa.getCourseOfferings()) {
                if (!co.isIsControl().booleanValue()) continue;
                InstructionalOffering io = co.getInstructionalOffering();
                io.deleteAllDistributionPreferences(hibSession);
                io.deleteAllClasses(hibSession);
                io.deleteAllCourses(hibSession);
                hibSession.remove((Object)io);
            }
            for (CourseOffering co : sa.getCourseOfferings()) {
                hibSession.remove((Object)co);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, sa, ChangeLog.Source.SUBJECT_AREA_EDIT, ChangeLog.Operation.DELETE, null, sa.getDepartment());
            hibSession.remove((Object)sa);
            tx.commit();
            hibSession.flush();
            HibernateUtil.clearCache();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    private void doUpdate() throws Exception {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        if (((SubjectAreaEditForm)this.form).getUniqueId() == null) {
            this.sessionContext.checkPermission(Right.SubjectAreaAdd);
        } else {
            this.sessionContext.checkPermission(((SubjectAreaEditForm)this.form).getUniqueId(), "SubjectArea", Right.SubjectAreaEdit);
        }
        try {
            String className;
            SubjectAreaDAO sdao = SubjectAreaDAO.getInstance();
            DepartmentDAO ddao = DepartmentDAO.getInstance();
            SubjectArea sa = null;
            Department oldDept = null;
            hibSession = sdao.getSession();
            tx = hibSession.beginTransaction();
            sa = ((SubjectAreaEditForm)this.form).getUniqueId() != null ? (SubjectArea)sdao.get(((SubjectAreaEditForm)this.form).getUniqueId()) : new SubjectArea();
            Department dept = (Department)ddao.get(((SubjectAreaEditForm)this.form).getDepartment());
            HashSet<Class_> updatedClasses = new HashSet<Class_>();
            sa.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId(), hibSession));
            sa.setSubjectAreaAbbreviation(((SubjectAreaEditForm)this.form).getAbbv());
            if (sa.getDepartment() != null && !dept.equals(sa.getDepartment())) {
                HashSet<Location> availableRooms = new HashSet<Location>();
                HashSet<Building> availableBuildings = new HashSet<Building>();
                for (RoomDept roomDept : dept.getRoomDepts()) {
                    availableRooms.add(roomDept.getRoom());
                    if (!(roomDept.getRoom() instanceof Room)) continue;
                    availableBuildings.add(((Room)roomDept.getRoom()).getBuilding());
                }
                for (CourseOffering co : sa.getCourseOfferings()) {
                    if (!co.getIsControl().booleanValue() || co.getInstructionalOffering() == null) continue;
                    for (InstrOfferingConfig ioc : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                            if (!ss.getManagingDept().isExternalManager().booleanValue()) {
                                Iterator<Serializable> l = ss.getPreferences().iterator();
                                while (l.hasNext()) {
                                    RoomGroupPref rgp;
                                    Preference p = (Preference)l.next();
                                    if (p instanceof TimePref) continue;
                                    if (p instanceof RoomPref) {
                                        RoomPref rp = (RoomPref)p;
                                        if (availableRooms.contains(rp.getRoom())) continue;
                                        l.remove();
                                        continue;
                                    }
                                    if (p instanceof BuildingPref) {
                                        BuildingPref bp = (BuildingPref)p;
                                        if (availableBuildings.contains(bp.getBuilding())) continue;
                                        l.remove();
                                        continue;
                                    }
                                    if (p instanceof RoomFeaturePref) {
                                        RoomFeaturePref rfp = (RoomFeaturePref)p;
                                        if (!(rfp.getRoomFeature() instanceof DepartmentRoomFeature)) continue;
                                        l.remove();
                                        continue;
                                    }
                                    if (!(p instanceof RoomGroupPref) || (rgp = (RoomGroupPref)p).getRoomGroup().isGlobal().booleanValue()) continue;
                                    l.remove();
                                }
                                hibSession.merge((Object)ss);
                            }
                            for (Class_ c : ss.getClasses()) {
                                Iterator<Comparable> m;
                                if (!c.getManagingDept().isExternalManager().booleanValue()) {
                                    m = c.getPreferences().iterator();
                                    while (m.hasNext()) {
                                        RoomGroupPref rgp;
                                        Preference p = (Preference)m.next();
                                        if (p instanceof TimePref) continue;
                                        if (p instanceof RoomPref) {
                                            RoomPref rp = (RoomPref)p;
                                            if (availableRooms.contains(rp.getRoom())) continue;
                                            m.remove();
                                            continue;
                                        }
                                        if (p instanceof BuildingPref) {
                                            BuildingPref bp = (BuildingPref)p;
                                            if (availableBuildings.contains(bp.getBuilding())) continue;
                                            m.remove();
                                            continue;
                                        }
                                        if (p instanceof RoomFeaturePref) {
                                            RoomFeaturePref rfp = (RoomFeaturePref)p;
                                            if (!(rfp.getRoomFeature() instanceof DepartmentRoomFeature)) continue;
                                            m.remove();
                                            continue;
                                        }
                                        if (!(p instanceof RoomGroupPref) || (rgp = (RoomGroupPref)p).getRoomGroup().isGlobal().booleanValue()) continue;
                                        m.remove();
                                    }
                                    c.setManagingDept(dept, this.sessionContext.getUser(), hibSession);
                                }
                                m = c.getClassInstructors().iterator();
                                while (m.hasNext()) {
                                    ClassInstructor ci = (ClassInstructor)m.next();
                                    DepartmentalInstructor newInstructor = null;
                                    if (ci.getInstructor().getExternalUniqueId() != null) {
                                        newInstructor = DepartmentalInstructor.findByPuidDepartmentId(ci.getInstructor().getExternalUniqueId(), dept.getUniqueId());
                                    }
                                    ci.getInstructor().getClasses().remove(ci);
                                    hibSession.merge((Object)ci.getInstructor());
                                    if (newInstructor != null) {
                                        ci.setInstructor(newInstructor);
                                        newInstructor.getClasses().add(ci);
                                        hibSession.merge((Object)newInstructor);
                                        continue;
                                    }
                                    m.remove();
                                    hibSession.remove((Object)ci);
                                }
                                hibSession.merge((Object)c);
                                updatedClasses.add(c);
                            }
                        }
                    }
                }
                for (Preference p : sa.getDepartment().getPreferences()) {
                    if (!(p instanceof DistributionPref)) continue;
                    DistributionPref dp = (DistributionPref)p;
                    boolean change = true;
                    for (DistributionObject dobj : dp.getOrderedSetOfDistributionObjects()) {
                        if (dobj.getPrefGroup() instanceof SchedulingSubpart) {
                            SchedulingSubpart ss = (SchedulingSubpart)dobj.getPrefGroup();
                            if (ss.getControllingCourseOffering().getSubjectArea().equals(sa)) break;
                            change = false;
                            break;
                        }
                        if (!(dobj.getPrefGroup() instanceof Class_)) continue;
                        Class_ c = (Class_)dobj.getPrefGroup();
                        if (c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().equals(sa)) break;
                        change = false;
                        break;
                    }
                    if (!change) continue;
                    dp.setOwner(dept);
                    hibSession.merge((Object)dp);
                }
                oldDept = sa.getDepartment();
                sa.setDepartment(dept);
            } else if (sa.getDepartment() == null) {
                sa.setDepartment(dept);
            }
            sa.setExternalUniqueId(((SubjectAreaEditForm)this.form).getExternalId());
            sa.setTitle(((SubjectAreaEditForm)this.form).getTitle());
            hibSession.merge((Object)sa);
            ChangeLog.addChange(hibSession, this.sessionContext, sa, ChangeLog.Source.SUBJECT_AREA_EDIT, ((SubjectAreaEditForm)this.form).getUniqueId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, sa, dept);
            ((SubjectAreaEditForm)this.form).setUniqueId(sa.getUniqueId());
            tx.commit();
            hibSession.refresh((Object)sa);
            hibSession.flush();
            hibSession.refresh((Object)sa.getSession());
            if (oldDept != null) {
                hibSession.refresh((Object)oldDept);
                hibSession.refresh((Object)sa.getDepartment());
            }
            if ((className = ApplicationProperty.ExternalActionClassEdit.value()) != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public String getSession() {
        return this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel();
    }
}

