/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.DataProperties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.SolverSettingsForm;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;
import org.unitime.timetable.model.dao.SolverParameterGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;

@Action(value="solverSettings", results={@Result(name={"list"}, type="tiles", location="solverSettingsList.tiles"), @Result(name={"add"}, type="tiles", location="solverSettingAdd.tiles"), @Result(name={"edit"}, type="tiles", location="solverSettingEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="solverSettingsList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Solver Configurations"), @TilesPutAttribute(name="body", value="/admin/solverSettings.jsp")}), @TilesDefinition(name="solverSettingAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Solver Configuration"), @TilesPutAttribute(name="body", value="/admin/solverSettings.jsp")}), @TilesDefinition(name="solverSettingEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Solver Configuration"), @TilesPutAttribute(name="body", value="/admin/solverSettings.jsp")})})
public class SolverSettingsAction
extends UniTimeAction<SolverSettingsForm> {
    private static final long serialVersionUID = 2993473779756335885L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String id = null;
    protected String op2 = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String execute() throws Exception {
        SolverPredefinedSetting setting;
        Session hibSession;
        SolverPredefinedSettingDAO dao;
        Transaction tx;
        if (this.form == null) {
            this.form = new SolverSettingsForm();
        }
        this.sessionContext.checkPermission(Right.SolverConfigurations);
        if (this.op == null) {
            this.op = ((SolverSettingsForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null) {
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
            this.op = "list";
        }
        if (MSG.actionBackToSolverConfigs().equals(this.op)) {
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
        }
        if (MSG.actionAddNewSolverConfig().equals(this.op)) {
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionSaveSolverConfig());
            ((SolverSettingsForm)this.form).loadDefaults();
        }
        if ("Refresh".equals(this.op)) {
            ((SolverSettingsForm)this.form).setOp(((SolverSettingsForm)this.form).getUniqueId() == null || ((SolverSettingsForm)this.form).getUniqueId() <= 0L ? MSG.actionSaveSolverConfig() : MSG.actionUpdateSolverConfig());
            for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll()) {
                if (!def.isVisible().booleanValue() || !Boolean.TRUE.equals(((SolverSettingsForm)this.form).getUseDefault(def.getUniqueId())) || ((SolverSettingsForm)this.form).getParameter(def.getUniqueId()) != null) continue;
                ((SolverSettingsForm)this.form).setParameter(def.getUniqueId(), def.getDefault());
            }
        }
        if (MSG.actionSaveSolverConfig().equals(this.op) || MSG.actionUpdateSolverConfig().equals(this.op)) {
            ((SolverSettingsForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                tx = null;
                try {
                    dao = SolverPredefinedSettingDAO.getInstance();
                    hibSession = dao.getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    setting = null;
                    setting = MSG.actionSaveSolverConfig().equals(this.op) ? new SolverPredefinedSetting() : (SolverPredefinedSetting)dao.get(((SolverSettingsForm)this.form).getUniqueId(), hibSession);
                    setting.setName(((SolverSettingsForm)this.form).getName());
                    setting.setDescription(((SolverSettingsForm)this.form).getDescription());
                    setting.setAppearanceType(((SolverSettingsForm)this.form).getAppearanceType());
                    Object params = setting.getParameters();
                    if (params == null) {
                        params = new HashSet<SolverParameter>();
                        setting.setParameters((Set<SolverParameter>)params);
                    }
                    for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll(hibSession)) {
                        SolverParameter param = null;
                        Iterator<Comparable> j = params.iterator();
                        while (j.hasNext()) {
                            SolverParameter solverParameter = j.next();
                            if (!solverParameter.getDefinition().equals(def)) continue;
                            param = solverParameter;
                            break;
                        }
                        if (!def.isVisible().booleanValue()) {
                            if (param == null) continue;
                            params.remove(param);
                            hibSession.remove((Object)param);
                            continue;
                        }
                        String value = ((SolverSettingsForm)this.form).getParameter(def.getUniqueId());
                        Boolean bl = ((SolverSettingsForm)this.form).getUseDefault(def.getUniqueId());
                        if (bl.booleanValue()) {
                            if (param == null) continue;
                            params.remove(param);
                            hibSession.remove((Object)param);
                            continue;
                        }
                        if (param == null) {
                            param = new SolverParameter();
                            param.setDefinition(def);
                            param.setValue(value == null ? def.getDefault() : value);
                            hibSession.persist((Object)param);
                        } else {
                            param.setValue(value == null ? def.getDefault() : value);
                            hibSession.merge((Object)param);
                        }
                        params.add(param);
                    }
                    if (setting.getUniqueId() == null) {
                        hibSession.persist((Object)setting);
                    } else {
                        hibSession.merge((Object)setting);
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                ((SolverSettingsForm)this.form).reset();
                ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
            } else {
                ((SolverSettingsForm)this.form).setOp(this.op);
                for (SolverParameterDef def : SolverParameterDefDAO.getInstance().findAll()) {
                    if (!def.isVisible().booleanValue() || !Boolean.TRUE.equals(((SolverSettingsForm)this.form).getUseDefault(def.getUniqueId())) || ((SolverSettingsForm)this.form).getParameter(def.getUniqueId()) != null) continue;
                    ((SolverSettingsForm)this.form).setParameter(def.getUniqueId(), def.getDefault());
                }
            }
        }
        if (this.op.equals("Edit")) {
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField("Id"));
            } else {
                tx = null;
                try {
                    dao = SolverPredefinedSettingDAO.getInstance();
                    hibSession = dao.getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    if ((setting = (SolverPredefinedSetting)dao.get(Long.valueOf(this.id), hibSession)) == null) {
                        this.addFieldError("form.name", MSG.errorDoesNotExists(this.id));
                    } else {
                        ((SolverSettingsForm)this.form).reset();
                        ((SolverSettingsForm)this.form).loadDefaults();
                        ((SolverSettingsForm)this.form).setUniqueId(setting.getUniqueId());
                        ((SolverSettingsForm)this.form).setName(setting.getName());
                        ((SolverSettingsForm)this.form).setDescription(setting.getDescription());
                        ((SolverSettingsForm)this.form).setAppearanceType(setting.getAppearanceType());
                        ((SolverSettingsForm)this.form).setOp(MSG.actionUpdateSolverConfig());
                        for (SolverParameter solverParameter : setting.getParameters()) {
                            if (!solverParameter.getDefinition().isVisible().booleanValue()) continue;
                            String value = solverParameter.getValue();
                            if ("boolean".equals(solverParameter.getDefinition().getType()) && "on".equals(solverParameter.getValue())) {
                                value = "true";
                            }
                            ((SolverSettingsForm)this.form).setParameter(solverParameter.getDefinition().getUniqueId(), value);
                            ((SolverSettingsForm)this.form).setUseDefault(solverParameter.getDefinition().getUniqueId(), Boolean.FALSE);
                        }
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
            }
        }
        if (MSG.actionExportSolverConfig().equals(this.op)) {
            if (((SolverSettingsForm)this.form).getUniqueId() == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField("Id"));
            } else {
                SolverPredefinedSettingDAO dao2 = SolverPredefinedSettingDAO.getInstance();
                Session hibSession2 = dao2.getSession();
                SolverPredefinedSetting setting2 = (SolverPredefinedSetting)dao2.get(((SolverSettingsForm)this.form).getUniqueId(), hibSession2);
                if (setting2 == null) {
                    this.addFieldError("form.name", MSG.errorDoesNotExists(String.valueOf(((SolverSettingsForm)this.form).getUniqueId())));
                } else {
                    PrintWriter pw = ExportUtils.getPlainTextWriter(this.response, setting2.getName() + ".txt");
                    DataProperties properties = null;
                    switch (setting2.getAppearanceType().getSolverType()) {
                        case STUDENT: {
                            properties = this.getStudentSectioningSolverService().createConfig(setting2.getUniqueId(), null);
                            break;
                        }
                        case EXAM: {
                            properties = this.getExaminationSolverService().createConfig(setting2.getUniqueId(), null);
                            break;
                        }
                        case INSTRUCTOR: {
                            properties = this.getInstructorSchedulingSolverService().createConfig(setting2.getUniqueId(), null);
                            break;
                        }
                        default: {
                            properties = this.getCourseTimetablingSolverService().createConfig(setting2.getUniqueId(), null);
                        }
                    }
                    pw.println("## Solver Configuration File");
                    pw.println("## Reference: " + setting2.getName());
                    pw.println("## Name: " + setting2.getDescription());
                    pw.println("## Appearance: " + SolverPredefinedSetting.Appearance.values()[setting2.getAppearance()].getLabel());
                    pw.println("## Date: " + new Date());
                    pw.println("######################################");
                    for (SolverParameterGroup g : hibSession2.createQuery("select g from SolverParameterGroup g order by g.order", SolverParameterGroup.class).list()) {
                        if (setting2.getAppearanceType() == SolverPredefinedSetting.Appearance.STUDENT_SOLVER ? g.getSolverType() != SolverParameterGroup.SolverType.STUDENT : (setting2.getAppearanceType() == SolverPredefinedSetting.Appearance.EXAM_SOLVER ? g.getSolverType() != SolverParameterGroup.SolverType.EXAM : (setting2.getAppearanceType() == SolverPredefinedSetting.Appearance.INSTRUCTOR_SOLVER ? g.getSolverType() != SolverParameterGroup.SolverType.INSTRUCTOR : g.getSolverType() != SolverParameterGroup.SolverType.COURSE))) continue;
                        pw.println();
                        pw.println("## " + g.getDescription().replaceAll("<br>", "\n#"));
                        pw.println("######################################");
                        TreeSet<SolverParameterDef> parameters = new TreeSet<SolverParameterDef>(g.getParameters());
                        for (SolverParameterDef solverParameterDef : parameters) {
                            String value = properties.getProperty(solverParameterDef.getName(), solverParameterDef.getDefault());
                            if (value == null) continue;
                            pw.println("## " + solverParameterDef.getDescription().replaceAll("<br>", "\n#"));
                            pw.println("## Type: " + solverParameterDef.getType());
                            if (value != null && !value.equals(solverParameterDef.getDefault())) {
                                pw.println("## Default: " + solverParameterDef.getDefault());
                            }
                            pw.println(solverParameterDef.getName() + "=" + properties.getProperty(solverParameterDef.getName(), solverParameterDef.getDefault()));
                            properties.remove((Object)solverParameterDef.getName());
                        }
                    }
                    pw.println();
                    pw.println("## Other Properties");
                    pw.println("######################################");
                    Enumeration enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String name = (String)enumeration.nextElement();
                        pw.println(name + "=" + properties.getProperty(name));
                    }
                    pw.flush();
                    pw.close();
                    return null;
                }
            }
        }
        if (MSG.actionDeleteSolverConfig().equals(this.op)) {
            tx = null;
            try {
                dao = SolverPredefinedSettingDAO.getInstance();
                hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                setting = (SolverPredefinedSetting)dao.get(((SolverSettingsForm)this.form).getUniqueId(), hibSession);
                hibSession.remove((Object)setting);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                Debug.error(e);
            }
            ((SolverSettingsForm)this.form).reset();
            ((SolverSettingsForm)this.form).setOp(MSG.actionAddNewSolverConfig());
        }
        if (MSG.actionAddNewSolverConfig().equals(((SolverSettingsForm)this.form).getOp())) {
            return "list";
        }
        return MSG.actionSaveSolverConfig().equals(((SolverSettingsForm)this.form).getOp()) ? "add" : "edit";
    }

    public String getSolverSettingsTable() {
        Transaction tx = null;
        WebTable.setOrder(this.sessionContext, "solverSettings.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(4, null, "solverSettings.action?ord=%%", new String[]{MSG.fieldReference(), MSG.fieldName(), MSG.fieldAppearance()}, new String[]{"left", "left", "left"}, null);
        try {
            List list;
            SolverPredefinedSettingDAO dao = SolverPredefinedSettingDAO.getInstance();
            Session hibSession = dao.getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((list = hibSession.createQuery("from SolverPredefinedSetting", SolverPredefinedSetting.class).list()).isEmpty()) {
                webTable.addLine(null, new String[]{MSG.infoNoSolverConfigs()}, null, null);
            } else {
                for (SolverPredefinedSetting setting : list) {
                    String onClick = "onClick=\"document.location='solverSettings.action?op=Edit&id=" + setting.getUniqueId() + "';\"";
                    webTable.addLine(onClick, new String[]{setting.getName(), setting.getDescription(), setting.getAppearanceType().getLabel()}, new Comparable[]{setting.getName(), setting.getDescription(), setting.getAppearance()});
                }
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "solverSettings.ord"));
    }

    public List<SolverParameterGroup> getSolverParameterGroups() {
        return SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup order by order", SolverParameterGroup.class).list();
    }
}

