/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.RollForwardSessionForm;
import org.unitime.timetable.gwt.command.server.GwtRpcServlet;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.PointInTimeDataDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.SessionRollForward;
import org.unitime.timetable.util.queue.QueueItem;

@Action(value="rollForwardSession", results={@Result(name={"displayRollForwardSessionForm"}, type="tiles", location="rollForwardSession.tiles")})
@TilesDefinition(name="rollForwardSession.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Roll Forward Session"), @TilesPutAttribute(name="body", value="/admin/rollForwardSession.jsp")})
public class RollForwardSessionAction
extends UniTimeAction<RollForwardSessionForm> {
    private static final long serialVersionUID = -5982958315864704198L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String remove;

    public String getRemove() {
        return this.remove;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public String execute() throws Exception {
        WebTable queueTable;
        if (this.form == null) {
            this.form = new RollForwardSessionForm();
        }
        if (MSG.actionRollForward().equals(this.op)) {
            this.sessionContext.checkPermission(Right.SessionRollForward);
            ((RollForwardSessionForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.getSolverServerService().getQueueProcessor().add(new RollForwardQueueItem((Session)SessionDAO.getInstance().get(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()), this.sessionContext.getUser(), (RollForwardSessionForm)((RollForwardSessionForm)this.form).clone()));
            }
        }
        if (this.remove != null && !this.remove.isEmpty()) {
            this.getSolverServerService().getQueueProcessor().remove(this.remove);
        }
        if ((queueTable = this.getQueueTable()) != null && !queueTable.getLines().isEmpty()) {
            this.request.setAttribute("table", (Object)queueTable.printTable(WebTable.getOrder(this.sessionContext, "rollForwardSession.ord")));
        }
        this.setToFromSessionsInForm();
        ((RollForwardSessionForm)this.form).setSubjectAreas(this.getSubjectAreas(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()));
        ((RollForwardSessionForm)this.form).setDepartments(this.getDepartments(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()));
        ((RollForwardSessionForm)this.form).setFromPointInTimeDataSnapshots(this.getPointInTimeDataSnapshots(((RollForwardSessionForm)this.form).getSessionToRollForwardTo()));
        if (this.op == null) {
            this.setExpirationDates((RollForwardSessionForm)this.form);
        }
        if (((RollForwardSessionForm)this.form).getSubpartLocationPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setSubpartLocationPrefsAction(SessionRollForward.ROLL_PREFS_ACTION);
        }
        if (((RollForwardSessionForm)this.form).getSubpartTimePrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setSubpartTimePrefsAction(SessionRollForward.ROLL_PREFS_ACTION);
        }
        if (((RollForwardSessionForm)this.form).getClassPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setClassPrefsAction(SessionRollForward.DO_NOT_ROLL_ACTION);
        }
        if (((RollForwardSessionForm)this.form).getRollForwardDistributions() == null) {
            ((RollForwardSessionForm)this.form).setRollForwardDistributions(SessionRollForward.DistributionMode.MIXED.name());
        }
        if (((RollForwardSessionForm)this.form).getCancelledClassAction() == null) {
            ((RollForwardSessionForm)this.form).setCancelledClassAction(SessionRollForward.CancelledClassAction.REOPEN.name());
        }
        if (((RollForwardSessionForm)this.form).getMidtermExamsPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setMidtermExamsPrefsAction(SessionRollForward.EXAMS_ROOM_PREFS);
        }
        if (((RollForwardSessionForm)this.form).getFinalExamsPrefsAction() == null) {
            ((RollForwardSessionForm)this.form).setFinalExamsPrefsAction(SessionRollForward.EXAMS_ROOM_PREFS);
        }
        return "displayRollForwardSessionForm";
    }

    public WebTable getQueueTable() {
        WebTable.setOrder(this.sessionContext, "rollForwardSession.ord", this.request.getParameter("ord"), 1);
        String log = this.request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        List<QueueItem> queue = this.getSolverServerService().getQueueProcessor().getItems(null, null, "Roll Forward");
        if (queue.isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, null, "rollForwardSession.action?ord=%%", new String[]{MSG.fieldQueueName(), MSG.fieldQueueStatus(), MSG.fieldQueueProgress(), MSG.fieldQueueOwner(), MSG.fieldQueueSession(), MSG.fieldQueueCreated(), MSG.fieldQueueStarted(), MSG.fieldQueueFinished(), MSG.fieldQueueOutput()}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 86400000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            Object name = item.name();
            if (((String)name).length() > 60) {
                name = ((String)name).substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('Do you really want to remove this roll forward?')) document.location='rollForwardSession.action?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine("onClick=\"document.location='rollForwardSession.action?log=" + item.getId() + "';\"", new String[]{(String)name + (String)(delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.hasOutput() ? "<A href='" + item.getOutputLink() + "'>" + item.getOutputName().substring(item.getOutputName().lastIndexOf(46) + 1).toUpperCase() + "</A>" : ""}, new Comparable[]{Long.valueOf(item.created().getTime()), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log == null || !log.equals(item.getId().toString())) continue;
            this.request.setAttribute("logname", name);
            this.request.setAttribute("logid", (Object)item.getId().toString());
            this.request.setAttribute("log", (Object)item.log());
            ((RollForwardQueueItem)item).getForm().copyTo((RollForwardSessionForm)this.form);
            this.saveErrors(((RollForwardQueueItem)item).getErrors());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }

    protected void saveErrors(List<RollForwardError> errors) {
        if (errors != null) {
            for (RollForwardError e : errors) {
                this.addFieldError(e.getType(), e.getMessage());
            }
        }
    }

    protected void setToFromSessionsInForm() {
        Session currentSession;
        ArrayList<Session> sessionList = new ArrayList<Session>();
        sessionList.addAll(Session.getAllSessions());
        ArrayList<Session> fromSessions = new ArrayList<Session>();
        ((RollForwardSessionForm)this.form).setFromSessions(fromSessions);
        ArrayList<Session> toSessions = new ArrayList<Session>();
        ((RollForwardSessionForm)this.form).setToSessions(toSessions);
        Session session = null;
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            session = (Session)sessionList.get(i);
            if (session.getStatusType().isAllowRollForward()) {
                toSessions.add(session);
                if (((RollForwardSessionForm)this.form).getSessionToRollForwardTo() != null) continue;
                ((RollForwardSessionForm)this.form).setSessionToRollForwardTo(session.getUniqueId());
                continue;
            }
            fromSessions.add(session);
        }
        Long currentSessionId = ((RollForwardSessionForm)this.form).getSessionToRollForwardTo();
        if (currentSessionId == null || currentSessionId <= 0L) {
            currentSessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        }
        Session session2 = currentSession = currentSessionId == null ? null : (Session)SessionDAO.getInstance().get(currentSessionId);
        if (currentSession != null) {
            Collections.sort(fromSessions, new SessionComparator(currentSession.getAcademicInitiative()));
            Collections.sort(toSessions, new SessionComparator(currentSession.getAcademicInitiative()));
        }
    }

    protected Set<SubjectArea> getSubjectAreas(Long selectedSessionId) {
        Session session = null;
        if (selectedSessionId == null) {
            boolean found = false;
            TreeSet<Session> allSessions = Session.getAllSessions();
            ArrayList<Session> sessionList = new ArrayList<Session>();
            sessionList.addAll(Session.getAllSessions());
            for (int i = sessionList.size() - 1; i >= 0; --i) {
                session = (Session)sessionList.get(i);
                if (!session.getStatusType().isAllowRollForward()) continue;
                found = true;
            }
            if (!found) {
                session = null;
                if (allSessions.size() > 0) {
                    session = allSessions.last();
                }
            }
        } else {
            session = Session.getSessionById(selectedSessionId);
        }
        TreeSet<SubjectArea> subjects = new TreeSet<SubjectArea>();
        if (session != null) {
            subjects.addAll(session.getSubjectAreas());
        }
        return subjects;
    }

    protected Set<Department> getDepartments(Long selectedSessionId) {
        Session session = null;
        if (selectedSessionId == null) {
            boolean found = false;
            TreeSet<Session> allSessions = Session.getAllSessions();
            ArrayList<Session> sessionList = new ArrayList<Session>();
            sessionList.addAll(Session.getAllSessions());
            for (int i = sessionList.size() - 1; i >= 0; --i) {
                session = (Session)sessionList.get(i);
                if (!session.getStatusType().isAllowRollForward()) continue;
                found = true;
            }
            if (!found) {
                session = null;
                if (allSessions.size() > 0) {
                    session = allSessions.last();
                }
            }
        } else {
            session = Session.getSessionById(selectedSessionId);
        }
        TreeSet<Department> departments = new TreeSet<Department>();
        if (session != null) {
            departments.addAll(session.getDepartments());
        }
        return departments;
    }

    protected Set<PointInTimeData> getPointInTimeDataSnapshots(Long selectedSessionId) {
        TreeSet<PointInTimeData> pointInTimeDataSnapshots = new TreeSet<PointInTimeData>();
        if (selectedSessionId != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("from PointInTimeData pitd where pitd.session.uniqueId in (select distinct rfio.session.uniqueId ").append(" from InstructionalOffering rfio, Session s inner join s.instructionalOfferings as io ").append(" where s.uniqueId = :sessId ").append(" and rfio.uniqueId = io.uniqueIdRolledForwardFrom )").append(" and pitd.savedSuccessfully = true ");
            pointInTimeDataSnapshots.addAll(PointInTimeDataDAO.getInstance().getSession().createQuery(sb.toString(), PointInTimeData.class).setParameter("sessId", (Object)selectedSessionId).list());
        }
        return pointInTimeDataSnapshots;
    }

    protected void setExpirationDates(RollForwardSessionForm form) {
        if (form.getSessionToRollForwardTo() != null) {
            ReservationInterface.DefaultExpirationDates dates = GwtRpcServlet.execute(new ReservationInterface.ReservationDefaultExpirationDatesRpcRequest(form.getSessionToRollForwardTo()), this.getApplicationContext(), this.sessionContext);
            if (dates != null) {
                Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
                form.setExpirationCourseReservations(dates.hasExpirationDate("course") ? df.format(dates.getExpirationDate("course")) : null);
                form.setExpirationCurriculumReservations(dates.hasExpirationDate("curriculum") ? df.format(dates.getExpirationDate("curriculum")) : null);
                form.setExpirationGroupReservations(dates.hasExpirationDate("group") ? df.format(dates.getExpirationDate("group")) : null);
                form.setExpirationUniversalReservations(dates.hasExpirationDate("universal") ? df.format(dates.getExpirationDate("universal")) : null);
                form.setStartDateCourseReservations(dates.hasStartDate("course") ? df.format(dates.getStartDate("course")) : null);
                form.setStartDateCurriculumReservations(dates.hasStartDate("curriculum") ? df.format(dates.getStartDate("curriculum")) : null);
                form.setStartDateGroupReservations(dates.hasStartDate("group") ? df.format(dates.getStartDate("group")) : null);
                form.setStartDateUniversalReservations(dates.hasStartDate("universal") ? df.format(dates.getStartDate("universal")) : null);
            }
        } else {
            form.setExpirationCourseReservations(null);
            form.setExpirationCurriculumReservations(null);
            form.setExpirationGroupReservations(null);
            form.setExpirationUniversalReservations(null);
            form.setStartDateCourseReservations(null);
            form.setStartDateCurriculumReservations(null);
            form.setStartDateGroupReservations(null);
            form.setStartDateUniversalReservations(null);
        }
    }

    private static class RollForwardQueueItem
    extends QueueItem {
        private static final long serialVersionUID = 1L;
        private RollForwardSessionForm iForm;
        private int iProgress = 0;
        private RollForwardErrors iErrors = new RollForwardErrors();

        public RollForwardQueueItem(Session session, UserContext owner, RollForwardSessionForm form) {
            super(session, owner);
            this.iForm = form;
        }

        public RollForwardErrors getErrors() {
            return this.iErrors;
        }

        public RollForwardSessionForm getForm() {
            return this.iForm;
        }

        @Override
        public void error(Object message, Throwable t) {
            super.error(message, t);
            this.setError(t);
        }

        @Override
        protected void execute() throws Exception {
            Transaction tx;
            SessionRollForward sessionRollForward = new SessionRollForward(this);
            Session toAcadSession = Session.getSessionById(this.iForm.getSessionToRollForwardTo());
            if (toAcadSession == null) {
                this.iErrors.addFieldError("mustSelectSession", MSG.errorRollForwardMissingToSession());
            }
            org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardDepartments().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardDepartments() + " ...");
                    if (this.iForm.validateDepartmentRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollDepartmentsForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardDepartments()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardSessionConfig().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardSessionConfiguration() + " ...");
                    sessionRollForward.rollSessionConfigurationForward(this.iErrors, this.iForm);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardSessionConfiguration()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardManagers().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardManagers() + " ...");
                    if (this.iForm.validateManagerRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollManagersForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardManagers()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardRoomData().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardRooms() + " ...");
                    if (this.iForm.validateBuildingAndRoomRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollBuildingAndRoomDataForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardRooms()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardDatePatterns().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardDatePatterns() + " ...");
                    if (this.iForm.validateDatePatternRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollDatePatternsForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardDatePatterns()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardTimePatterns().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardTimePatterns() + " ...");
                    if (this.iForm.validateTimePatternRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollTimePatternsForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardTimePatterns()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardLearningManagementSystems().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardLMSInfo() + " ...");
                    if (this.iForm.validateLearningManagementSystemRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollLearningManagementSystemInfoForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardLMSInfo()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardSubjectAreas().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardSubjectAreas() + " ...");
                    if (this.iForm.validateSubjectAreaRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollSubjectAreasForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardSubjectAreas()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardInstructorData().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardInstructors() + " ...");
                    sessionRollForward.rollInstructorDataForward(this.iErrors, this.iForm);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardInstructors()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardCourseOfferings().booleanValue()) {
                this.setStatus(MSG.rollForwardCourseOfferings() + " ...");
                sessionRollForward.rollCourseOfferingsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardClassInstructors().booleanValue()) {
                this.setStatus(MSG.rollForwardClassInstructors() + " ...");
                sessionRollForward.rollClassInstructorsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardOfferingCoordinators().booleanValue()) {
                this.setStatus(MSG.rollForwardOfferingCoordinators() + " ...");
                sessionRollForward.rollOfferingCoordinatorsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardTeachingRequests().booleanValue()) {
                this.setStatus(MSG.rollForwardTeachingRequests() + " ...");
                sessionRollForward.rollTeachingRequestsForward(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getAddNewCourseOfferings().booleanValue()) {
                this.setStatus(MSG.rollForwardNewCourses() + " ...");
                sessionRollForward.addNewCourseOfferings(this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardExamConfiguration().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardExamConfiguration() + " ...");
                    if (this.iForm.validateExamConfigurationRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollExamConfigurationDataForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardExamConfiguration()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardMidtermExams().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardMidtermExams() + " ...");
                    if (this.iForm.validateMidtermExamRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollMidtermExamsForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardMidtermExams()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardFinalExams().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardFinalExams() + " ...");
                    if (this.iForm.validateFinalExamRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollFinalExamsForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardFinalExams()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardStudents().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardStudents() + " ...");
                    if (this.iForm.validateLastLikeDemandRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollStudentsForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardStudents()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardCurricula().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardCurricula() + " ...");
                    if (this.iForm.validateCurriculaRollForward(toAcadSession, this.iErrors)) {
                        sessionRollForward.rollCurriculaForward(this.iErrors, this.iForm);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardCurricula()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardReservations()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardReservations() + " ...");
                    sessionRollForward.rollReservationsForward(this.iErrors, this.iForm);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardReservations()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardPeriodicTasks().booleanValue()) {
                tx = hibSession.beginTransaction();
                try {
                    this.setStatus(MSG.rollForwardScheduledTasks() + " ...");
                    sessionRollForward.rollPeriodicTasksForward(this.iErrors, this.iForm);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    this.error(MSG.errorRollForwardFailedAll(MSG.rollForwardScheduledTasks()), e);
                    this.iErrors.addFieldError("rollForward", e.getMessage());
                }
                hibSession.clear();
            }
            ++this.iProgress;
            if (!this.iErrors.isEmpty()) {
                this.setError(new Exception(((RollForwardError)this.iErrors.get(0)).getMessage()));
            } else {
                this.log(MSG.logAllDone());
            }
        }

        @Override
        public String name() {
            Object name;
            ArrayList<String> names = new ArrayList<String>();
            if (this.iForm.getRollForwardDepartments().booleanValue()) {
                names.add(MSG.rollForwardDepartments());
            }
            if (this.iForm.getRollForwardSessionConfig().booleanValue()) {
                names.add(MSG.rollForwardConfiguration());
            }
            if (this.iForm.getRollForwardManagers().booleanValue()) {
                names.add(MSG.rollForwardManagers());
            }
            if (this.iForm.getRollForwardRoomData().booleanValue()) {
                names.add(MSG.rollForwardRooms());
            }
            if (this.iForm.getRollForwardDatePatterns().booleanValue()) {
                names.add(MSG.rollForwardDatePatterns());
            }
            if (this.iForm.getRollForwardTimePatterns().booleanValue()) {
                names.add(MSG.rollForwardTimePatterns());
            }
            if (this.iForm.getRollForwardLearningManagementSystems().booleanValue()) {
                names.add(MSG.rollForwardLMS());
            }
            if (this.iForm.getRollForwardSubjectAreas().booleanValue()) {
                names.add(MSG.rollForwardSubjectAreas());
            }
            if (this.iForm.getRollForwardInstructorData().booleanValue()) {
                names.add(MSG.rollForwardInstructors());
            }
            if (this.iForm.getRollForwardCourseOfferings().booleanValue()) {
                names.add(MSG.rollForwardCourseOfferings());
            }
            if (this.iForm.getRollForwardClassInstructors().booleanValue()) {
                names.add(MSG.rollForwardClassInstructors());
            }
            if (this.iForm.getRollForwardOfferingCoordinators().booleanValue()) {
                names.add(MSG.rollForwardOfferingCoordinators());
            }
            if (this.iForm.getRollForwardTeachingRequests().booleanValue()) {
                names.add(MSG.rollForwardTeachingRequests());
            }
            if (this.iForm.getAddNewCourseOfferings().booleanValue()) {
                names.add(MSG.rollForwardNewCourses());
            }
            if (this.iForm.getRollForwardExamConfiguration().booleanValue()) {
                names.add(MSG.rollForwardExamConfiguration());
            }
            if (this.iForm.getRollForwardMidtermExams().booleanValue()) {
                names.add(MSG.rollForwardMidtermExams());
            }
            if (this.iForm.getRollForwardFinalExams().booleanValue()) {
                names.add(MSG.rollForwardFinalExams());
            }
            if (this.iForm.getRollForwardStudents().booleanValue()) {
                names.add(MSG.rollForwardStudents());
            }
            if (this.iForm.getRollForwardCurricula().booleanValue()) {
                names.add(MSG.rollForwardCurricula());
            }
            if (this.iForm.getRollForwardReservations()) {
                names.add(MSG.rollForwardReservations());
            }
            if (this.iForm.getRollForwardPeriodicTasks().booleanValue()) {
                names.add(MSG.rollForwardScheduledTasks());
            }
            if (((String)(name = ((Object)names).toString().replace("[", "").replace("]", ""))).length() > 50) {
                name = ((String)name).substring(0, 47) + "...";
            }
            return name;
        }

        @Override
        public double progress() {
            return 100 * this.iProgress / 21;
        }

        @Override
        public String type() {
            return "Roll Forward";
        }
    }

    public static class RollForwardErrors
    extends ArrayList<RollForwardError> {
        private static final long serialVersionUID = 6152383035137322209L;

        public void addFieldError(String type, String message) {
            this.add(new RollForwardError(type, message));
        }
    }

    public static class RollForwardError
    implements Serializable {
        private static final long serialVersionUID = -8383522549018220760L;
        private String iType;
        private String iMessage;

        RollForwardError(String type, String message) {
            this.iType = type;
            this.iMessage = message;
        }

        public String getType() {
            return this.iType;
        }

        public String getMessage() {
            return this.iMessage;
        }
    }

    public static class SessionComparator
    implements Comparator<Session> {
        private String iPreferCampus = null;

        public SessionComparator(String currentCampus) {
            this.iPreferCampus = currentCampus;
        }

        @Override
        public int compare(Session s1, Session s2) {
            boolean c2;
            boolean c1 = s1.getAcademicInitiative().equals(this.iPreferCampus);
            if (c1 != (c2 = s2.getAcademicInitiative().equals(this.iPreferCampus))) {
                return c1 ? -1 : 1;
            }
            int cmp = s1.getAcademicInitiative().compareTo(s2.getAcademicInitiative());
            if (cmp != 0) {
                return cmp;
            }
            cmp = s2.getSessionBeginDateTime().compareTo(s1.getSessionBeginDateTime());
            if (cmp != 0) {
                return cmp;
            }
            return s1.getUniqueId().compareTo(s2.getUniqueId());
        }
    }
}

