/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingDetailForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingDeleteAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingNotOfferedAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingOfferedAction;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.OfferingCoordinatorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;
import org.unitime.timetable.webutil.WebInstrOfferingConfigTableBuilder;

@Action(value="instructionalOfferingDetail", results={@Result(name={"showConfigDetail"}, type="tiles", location="instructionalOfferingDetail.tiles"), @Result(name={"addConfig"}, type="redirect", location="/instructionalOfferingConfigEdit.action", params={"form.instrOfferingId", "${form.instrOfferingId}", "uid", "${form.ctrlCrsOfferingId}", "op", "${op}"}), @Result(name={"addConfigGWT"}, type="redirect", location="/gwt.action", params={"page", "instrOfferingConfig", "offering", "${form.instrOfferingId}", "op", "${op}"}), @Result(name={"showInstructionalOfferings"}, type="redirect", location="/instructionalOfferingSearch.action", params={"backType", "InstructionalOffering", "backId", "${form.instrOfferingId}", "anchor", "back"}), @Result(name={"modifyCrossLists"}, type="redirect", location="/crossListsModify.action", params={"instrOfferingId", "${form.instrOfferingId}", "uid", "${form.ctrlCrsOfferingId}", "op", "${op}"}), @Result(name={"editCourse"}, type="redirect", location="/courseOfferingEdit.action", params={"courseOfferingId", "${form.crsOfferingId}", "op", "${op}"})})
@TilesDefinition(name="instructionalOfferingDetail.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructional Offering Detail"), @TilesPutAttribute(name="body", value="/user/instructionalOfferingDetail.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment")})
public class InstructionalOfferingDetailAction
extends UniTimeAction<InstructionalOfferingDetailForm> {
    private static final long serialVersionUID = -4648988999277363085L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GMSG = Localization.create(GwtMessages.class);
    protected Long instrOfferingId = null;
    protected Long courseOfferingId = null;
    protected String op2 = null;
    protected String confirm = null;
    protected String crsNbr = null;

    public Long getIo() {
        return this.instrOfferingId;
    }

    public void setIo(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public Long getCo() {
        return this.courseOfferingId;
    }

    public void setCo(Long courseOfferingId) {
        this.courseOfferingId = courseOfferingId;
    }

    public String getHdnOp() {
        return this.op2;
    }

    public void setHdnOp(String hdnOp) {
        this.op2 = hdnOp;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getCrsNbr() {
        return this.crsNbr;
    }

    public void setCrsNbr(String crsNbr) {
        this.crsNbr = crsNbr;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new InstructionalOfferingDetailForm();
        }
        this.setCrsNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
        if (this.op == null) {
            this.op = ((InstructionalOfferingDetailForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if ("n".equals(this.confirm)) {
            this.op = "view";
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            throw new Exception(MSG.exceptionOperationNotInterpreted() + this.op);
        }
        Debug.debug("Op: " + this.op);
        if (this.op.equals(MSG.actionDeleteIO())) {
            this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.OfferingDelete);
            this.doDelete(this.request, (InstructionalOfferingDetailForm)this.form);
            this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            return "showInstructionalOfferings";
        }
        if (this.op.equals(MSG.actionEditCourseOffering())) {
            if (ApplicationProperty.LegacyCourseEdit.isTrue()) {
                return "editCourse";
            }
            this.response.sendRedirect("gwt.jsp?page=courseOffering&offering=" + ((InstructionalOfferingDetailForm)this.form).getCrsOfferingId() + "&op=editCourseOffering");
            return null;
        }
        if (this.op.equals("view") || this.op.equals(MSG.actionUpdateConfiguration()) || this.op.equals(MSG.actionSaveConfiguration()) || this.op.equals(MSG.actionDeleteConfiguration()) || this.op.equals(MSG.actionUnassignAllInstructorsFromConfig())) {
            if (this.instrOfferingId == null && ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId() != null) {
                this.instrOfferingId = ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId();
            }
            if (this.instrOfferingId == null && this.courseOfferingId != null) {
                try {
                    this.instrOfferingId = ((CourseOffering)CourseOfferingDAO.getInstance().get(this.courseOfferingId)).getInstructionalOffering().getUniqueId();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.instrOfferingId == null) {
                throw new Exception(MSG.exceptionIODataNotCorrect() + this.instrOfferingId);
            }
            this.sessionContext.checkPermission(this.instrOfferingId, "InstructionalOffering", Right.InstructionalOfferingDetail);
            this.doLoad();
            BackTracker.markForBack(this.request, "instructionalOfferingDetail.action?io=" + ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), MSG.backInstructionalOffering(((InstructionalOfferingDetailForm)this.form).getInstrOfferingNameNoTitle()), true, false);
            return "showConfigDetail";
        }
        if (this.op.equals(MSG.actionAddConfiguration())) {
            this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.InstrOfferingConfigAdd);
            if (ApplicationProperty.LegacyInstrOfferingConfig.isTrue()) {
                return "addConfig";
            }
            return "addConfigGWT";
        }
        if (this.op.equals(MSG.actionMakeOffered())) {
            this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeOffered);
            this.doMakeOffered();
            if (ApplicationProperty.LegacyInstrOfferingConfig.isTrue()) {
                return "addConfig";
            }
            return "addConfigGWT";
        }
        if (this.op.equals(MSG.actionMakeNotOffered())) {
            this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeNotOffered);
            this.doMakeNotOffered();
            if (ApplicationProperty.MakeNotOfferedStaysOnDetail.isFalse()) {
                this.response.sendRedirect(this.response.encodeURL("instructionalOfferingSearch.action#A" + ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId()));
                return null;
            }
            this.response.sendRedirect(this.response.encodeURL("instructionalOfferingDetail.action?io=" + ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId()));
            return null;
        }
        if (this.op.equals(MSG.actionCrossLists())) {
            this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.InstructionalOfferingCrossLists);
            return "modifyCrossLists";
        }
        if (this.op.equals(MSG.actionNextIO())) {
            this.response.sendRedirect(this.response.encodeURL("instructionalOfferingDetail.action?io=" + ((InstructionalOfferingDetailForm)this.form).getNextId()));
            return null;
        }
        if (this.op.equals(MSG.actionPreviousIO())) {
            this.response.sendRedirect(this.response.encodeURL("instructionalOfferingDetail.action?io=" + ((InstructionalOfferingDetailForm)this.form).getPreviousId()));
            return null;
        }
        if (this.op.equals(MSG.actionLockIO())) {
            InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
            InstructionalOffering io = (InstructionalOffering)idao.get(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId());
            this.sessionContext.checkPermission(io, Right.OfferingCanLock);
            io.getSession().lockOffering(io.getUniqueId());
            this.response.sendRedirect(this.response.encodeURL("instructionalOfferingDetail.action?io=" + io.getUniqueId()));
            return null;
        }
        if (this.op.equals(MSG.actionUnlockIO())) {
            InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
            InstructionalOffering io = (InstructionalOffering)idao.get(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId());
            this.sessionContext.checkPermission(io, Right.OfferingCanUnlock);
            io.getSession().unlockOffering(io, this.sessionContext.getUser());
            this.response.sendRedirect(this.response.encodeURL("instructionalOfferingDetail.action?io=" + io.getUniqueId()));
            return null;
        }
        this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.InstructionalOfferingDetail);
        BackTracker.markForBack(this.request, "instructionalOfferingDetail.action?io=" + ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), MSG.backInstructionalOffering(((InstructionalOfferingDetailForm)this.form).getInstrOfferingName()), true, false);
        return "showInstructionalOfferings";
    }

    private void doDelete(HttpServletRequest request, InstructionalOfferingDetailForm form) throws Exception {
        org.hibernate.Session hibSession = null;
        Transaction tx = null;
        try {
            InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
            InstructionalOffering io = (InstructionalOffering)idao.get(form.getInstrOfferingId());
            hibSession = idao.getSession();
            tx = hibSession.beginTransaction();
            io.deleteAllDistributionPreferences(hibSession);
            Event.deleteFromEvents(hibSession, io);
            Exam.deleteFromExams(hibSession, io);
            String className = ApplicationProperty.ExternalActionInstructionalOfferingDelete.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingDeleteAction deleteAction = (ExternalInstructionalOfferingDeleteAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                deleteAction.performExternalInstructionalOfferingDeleteAction(io, hibSession);
            }
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.OFFERING_DETAIL, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
            for (CourseOffering co : io.getCourseOfferings()) {
                co.getSubjectArea().getCourseOfferings().remove(co);
                hibSession.remove((Object)co);
            }
            hibSession.remove((Object)io);
            tx.commit();
            hibSession.flush();
            hibSession.clear();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            Debug.error(e);
            throw e;
        }
    }

    private boolean hasConflicts(HttpServletRequest request, InstructionalOffering io) {
        if (RoomAvailability.getInstance() != null && !(RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService)) {
            Session session = io.getSession();
            Date[] bounds = DatePattern.getBounds(session.getUniqueId());
            RoomAvailability.getInstance().activate(session.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType, false);
            RoomAvailability.setAvailabilityWarning(request, session, true, true);
        }
        ClassAssignmentProxy proxy = this.getClassAssignmentService().getAssignment();
        try {
            if (proxy != null) {
                return proxy.hasConflicts(io.getUniqueId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void doLoad() throws Exception {
        String linkLookupClass;
        Department fundingDepartment;
        OverrideType prohibitedOverride;
        InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
        InstructionalOffering io = (InstructionalOffering)idao.get(this.instrOfferingId);
        Long subjectAreaId = io.getControllingCourseOffering().getSubjectArea().getUniqueId();
        this.sessionContext.checkPermission(io, Right.InstructionalOfferingDetail);
        InstructionalOfferingSearchAction.setLastInstructionalOffering(this.sessionContext, io);
        ArrayList<CourseOffering> offerings = new ArrayList<CourseOffering>(io.getCourseOfferings());
        Collections.sort(offerings, new CourseOfferingComparator(2));
        ((InstructionalOfferingDetailForm)this.form).setInstrOfferingId(this.instrOfferingId);
        ((InstructionalOfferingDetailForm)this.form).setSubjectAreaId(subjectAreaId);
        ((InstructionalOfferingDetailForm)this.form).setInstrOfferingName(io.getCourseNameWithTitle());
        ((InstructionalOfferingDetailForm)this.form).setSubjectAreaAbbr(io.getControllingCourseOffering().getSubjectAreaAbbv());
        ((InstructionalOfferingDetailForm)this.form).setCourseNbr(io.getControllingCourseOffering().getCourseNbr());
        ((InstructionalOfferingDetailForm)this.form).setInstrOfferingNameNoTitle(io.getCourseName());
        ((InstructionalOfferingDetailForm)this.form).setCtrlCrsOfferingId(io.getControllingCourseOffering().getUniqueId());
        ((InstructionalOfferingDetailForm)this.form).setDemand(io.getDemand());
        ((InstructionalOfferingDetailForm)this.form).setEnrollment(io.getEnrollment());
        ((InstructionalOfferingDetailForm)this.form).setSnapshotLimit(io.getSnapshotLimit());
        ((InstructionalOfferingDetailForm)this.form).setProjectedDemand(io.getProjectedDemand());
        ((InstructionalOfferingDetailForm)this.form).setLimit(io.getLimit());
        ((InstructionalOfferingDetailForm)this.form).setUnlimited(Boolean.FALSE);
        ((InstructionalOfferingDetailForm)this.form).setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(io)));
        ((InstructionalOfferingDetailForm)this.form).setByReservationOnly(io.isByReservationOnly());
        ((InstructionalOfferingDetailForm)this.form).setWkEnroll(io.getLastWeekToEnroll() == null ? "" : io.getLastWeekToEnroll().toString());
        ((InstructionalOfferingDetailForm)this.form).setWkChange(io.getLastWeekToChange() == null ? "" : io.getLastWeekToChange().toString());
        ((InstructionalOfferingDetailForm)this.form).setWkDrop(io.getLastWeekToDrop() == null ? "" : io.getLastWeekToDrop().toString());
        ((InstructionalOfferingDetailForm)this.form).setWaitList(io.getEffectiveWaitListMode().name());
        ((InstructionalOfferingDetailForm)this.form).setWeekStartDayOfWeek(Localization.getDateFormat("EEEE").format(io.getSession().getSessionBeginDateTime()));
        ((InstructionalOfferingDetailForm)this.form).setHasConflict(this.hasConflicts(this.request, io));
        if (io.effectiveWaitList() && (prohibitedOverride = OverrideType.findByReference(ApplicationProperty.OfferingWaitListProhibitedOverride.value())) != null) {
            String message = null;
            for (CourseOffering courseOffering : io.getCourseOfferings()) {
                if (courseOffering.getDisabledOverrides() != null && courseOffering.getDisabledOverrides().contains(prohibitedOverride)) continue;
                message = (String)(message == null ? "" : message + "\n") + MSG.problemWaitListProhibitedOverride(courseOffering.getCourseName(), prohibitedOverride.getLabel());
            }
            if (message != null) {
                this.request.setAttribute("waitlistProblem", message);
            }
        }
        if ((fundingDepartment = io.getEffectiveFundingDept()) != null) {
            ((InstructionalOfferingDetailForm)this.form).setFundingDepartment(fundingDepartment.toString());
        } else {
            ((InstructionalOfferingDetailForm)this.form).setFundingDepartment(null);
        }
        if (ApplicationProperty.OfferingShowClassNotes.isTrue()) {
            StringBuffer notes = new StringBuffer();
            ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(io.getInstrOfferingConfigs());
            Collections.sort(configs, new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
            for (InstrOfferingConfig instrOfferingConfig : configs) {
                ArrayList<SchedulingSubpart> subparts = new ArrayList<SchedulingSubpart>(instrOfferingConfig.getSchedulingSubparts());
                Collections.sort(subparts, new SchedulingSubpartComparator());
                for (SchedulingSubpart schedulingSubpart : subparts) {
                    ArrayList<Class_> classes = new ArrayList<Class_>(schedulingSubpart.getClasses());
                    Collections.sort(classes, new ClassComparator(3));
                    Iterator iterator = classes.iterator();
                    while (iterator.hasNext()) {
                        Class_ clazz = (Class_)iterator.next();
                        if (clazz.getNotes() == null || clazz.getNotes().isEmpty()) continue;
                        notes.append("<tr><th valign='top' align='left' nowrap>" + schedulingSubpart.getItypeDesc().trim() + " " + clazz.getSectionNumberString() + "</th><td>" + clazz.getNotes() + "</td></tr>");
                    }
                }
            }
            if (notes.length() == 0) {
                ((InstructionalOfferingDetailForm)this.form).setNotes(io.getNotes());
            } else {
                ((InstructionalOfferingDetailForm)this.form).setNotes("<table border='0' cellspacing='2' cellpadding='0'>" + (String)(io.getNotes() != null && !io.getNotes().isEmpty() ? "<tr><th valign='top' align='left' nowrap>" + io.getControllingCourseOffering().getCourseName() + "&nbsp;</th><td>" + io.getNotes() + "</td></tr>" : "") + notes + "</table>");
            }
        } else {
            ((InstructionalOfferingDetailForm)this.form).setNotes(io.getNotes());
        }
        Object coordinators = "";
        String instructorNameFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
        ArrayList<OfferingCoordinator> arrayList = new ArrayList<OfferingCoordinator>(io.getOfferingCoordinators());
        Collections.sort(arrayList, new OfferingCoordinatorComparator(this.sessionContext));
        for (OfferingCoordinator coordinator : arrayList) {
            if (!((String)coordinators).isEmpty()) {
                coordinators = (String)coordinators + "<br>";
            }
            coordinators = (String)coordinators + "<a href='instructorDetail.action?instructorId=" + coordinator.getInstructor().getUniqueId() + "' class='noFancyLinks'>" + coordinator.getInstructor().getName(instructorNameFormat) + (String)(coordinator.getResponsibility() == null ? (coordinator.getPercentShare() != 0 ? " (" + coordinator.getPercentShare() + "%)" : "") : " (" + coordinator.getResponsibility().getLabel() + (String)(coordinator.getPercentShare() > 0 ? ", " + coordinator.getPercentShare() + "%" : "") + ")") + "</a>";
        }
        ((InstructionalOfferingDetailForm)this.form).setCoordinators((String)coordinators);
        ((InstructionalOfferingDetailForm)this.form).setTeachingRequests(false);
        if (this.sessionContext.hasPermission(Right.InstructorScheduling)) {
            for (DepartmentalInstructor di : io.getDepartment().getInstructors()) {
                if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                ((InstructionalOfferingDetailForm)this.form).setTeachingRequests(true);
                break;
            }
        }
        Iterator<InstrOfferingConfig> iterator = io.getInstrOfferingConfigs().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isUnlimitedEnrollment().booleanValue()) continue;
            ((InstructionalOfferingDetailForm)this.form).setUnlimited(Boolean.TRUE);
            break;
        }
        ((InstructionalOfferingDetailForm)this.form).setNotOffered(io.isNotOffered());
        ((InstructionalOfferingDetailForm)this.form).setCourseOfferings(offerings);
        if (io.getCourseOfferings().size() > 1 && !((InstructionalOfferingDetailForm)this.form).getUnlimited().booleanValue()) {
            void var9_18;
            boolean bl = false;
            boolean reservationSet = false;
            for (CourseOffering courseOffering : io.getCourseOfferings()) {
                if (courseOffering.getReservation() == null) continue;
                var9_18 += courseOffering.getReservation().intValue();
                reservationSet = true;
            }
            if (reservationSet && io.getLimit() != null && var9_18 < io.getLimit()) {
                this.request.setAttribute("limitsDoNotMatch", (Object)("" + (int)var9_18));
            }
        }
        TreeSet<InstrOfferingConfig> treeSet = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig instrOfferingConfig : io.getInstrOfferingConfigs()) {
            void var12_38;
            if (instrOfferingConfig.isUnlimitedEnrollment().booleanValue()) continue;
            Object var12_37 = null;
            for (SchedulingSubpart subpart : instrOfferingConfig.getSchedulingSubparts()) {
                int limit = 0;
                for (Class_ clazz : subpart.getClasses()) {
                    limit += (clazz.getMaxExpectedCapacity() == null ? clazz.getExpectedCapacity() : clazz.getMaxExpectedCapacity()).intValue();
                }
                if (var12_38 != null && var12_38.intValue() <= limit) continue;
                Integer n = limit;
            }
            if (var12_38 == null || var12_38.intValue() >= instrOfferingConfig.getLimit()) continue;
            treeSet.add(instrOfferingConfig);
        }
        if (!treeSet.isEmpty()) {
            if (treeSet.size() == 1) {
                this.request.setAttribute("configsWithTooHighLimit", (Object)MSG.errorConfigWithTooHighLimit(((InstrOfferingConfig)treeSet.first()).getName()));
            } else {
                Object names = "";
                for (InstrOfferingConfig instrOfferingConfig : treeSet) {
                    if (!((String)names).isEmpty()) {
                        names = (String)names + ", ";
                    }
                    names = (String)names + instrOfferingConfig.getName();
                }
                this.request.setAttribute("configsWithTooHighLimit", (Object)MSG.errorConfigsWithTooHighLimit((String)names));
            }
        }
        if ((linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value()) != null && linkLookupClass.trim().length() > 0) {
            ExternalLinkLookup externalLinkLookup = (ExternalLinkLookup)Class.forName(linkLookupClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map map = externalLinkLookup.getLink(io);
            if (map == null) {
                throw new Exception(externalLinkLookup.getErrorMessage());
            }
            ((InstructionalOfferingDetailForm)this.form).setCatalogLinkLabel((String)map.get("label"));
            ((InstructionalOfferingDetailForm)this.form).setCatalogLinkLocation((String)map.get("href"));
        }
        InstructionalOffering instructionalOffering = io.getNextInstructionalOffering(this.sessionContext);
        ((InstructionalOfferingDetailForm)this.form).setNextId(instructionalOffering == null ? null : instructionalOffering.getUniqueId().toString());
        InstructionalOffering instructionalOffering2 = io.getPreviousInstructionalOffering(this.sessionContext);
        ((InstructionalOfferingDetailForm)this.form).setPreviousId(instructionalOffering2 == null ? null : instructionalOffering2.getUniqueId().toString());
        DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
        String html = tbl.getDistPrefsTableForInstructionalOffering(this.request, this.sessionContext, io);
        if (html != null && html.indexOf(MSG.noPreferencesFound()) < 0) {
            this.request.setAttribute("distPrefs", (Object)html);
        }
        ((InstructionalOfferingDetailForm)this.form).setInstructorSurvey(InstructorCourseRequirement.hasRequirementsForOffering(io));
    }

    private void doMakeNotOffered() throws Exception {
        this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeNotOffered);
        org.hibernate.Session hibSession = null;
        try {
            String className;
            InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
            hibSession = idao.getSession();
            InstructionalOffering io = (InstructionalOffering)idao.get(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId());
            io.deleteAllDistributionPreferences(hibSession);
            io.deleteAllClasses(hibSession);
            for (CourseOffering co : io.getCourseOfferings()) {
                Event.deleteFromEvents(hibSession, co);
                Exam.deleteFromExams(hibSession, co);
            }
            Event.deleteFromEvents(hibSession, io);
            Exam.deleteFromExams(hibSession, io);
            Iterator<Comparable> i = io.getReservations().iterator();
            while (i.hasNext()) {
                Reservation r = (Reservation)i.next();
                hibSession.remove((Object)r);
                i.remove();
            }
            i = io.getTeachingRequests().iterator();
            while (i.hasNext()) {
                TeachingRequest tr = (TeachingRequest)i.next();
                hibSession.remove((Object)tr);
                i.remove();
            }
            io.setNotOffered(true);
            hibSession.merge((Object)io);
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.MAKE_NOT_OFFERED, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            hibSession.flush();
            hibSession.clear();
            if (this.sessionContext.hasPermission(io, Right.OfferingCanUnlock)) {
                io.getSession().unlockOffering(io, this.sessionContext.getUser());
            }
            if ((className = ApplicationProperty.ExternalActionInstructionalOfferingNotOffered.value()) != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingNotOfferedAction notOfferedAction = (ExternalInstructionalOfferingNotOfferedAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                notOfferedAction.performExternalInstructionalOfferingNotOfferedAction(io, hibSession);
            }
            ((InstructionalOfferingDetailForm)this.form).setNotOffered(io.isNotOffered());
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doMakeOffered() throws Exception {
        this.sessionContext.checkPermission(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), "InstructionalOffering", Right.OfferingMakeOffered);
        org.hibernate.Session hibSession = null;
        try {
            InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
            hibSession = idao.getSession();
            InstructionalOffering io = (InstructionalOffering)idao.get(((InstructionalOfferingDetailForm)this.form).getInstrOfferingId());
            io.setNotOffered(false);
            hibSession.merge((Object)io);
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.MAKE_OFFERED, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            if (this.sessionContext.hasPermission(io, Right.OfferingCanLock)) {
                io.getSession().lockOffering(io.getUniqueId());
            }
            hibSession.flush();
            hibSession.clear();
            String className = ApplicationProperty.ExternalActionInstructionalOfferingOffered.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingOfferedAction offeredAction = (ExternalInstructionalOfferingOfferedAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                offeredAction.performExternalInstructionalOfferingOfferedAction(io, hibSession);
            }
            ((InstructionalOfferingDetailForm)this.form).setNotOffered(io.isNotOffered());
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    public String printTable() throws Exception {
        WebInstrOfferingConfigTableBuilder ioTableBuilder = new WebInstrOfferingConfigTableBuilder();
        ioTableBuilder.setDisplayDistributionPrefs(false);
        ioTableBuilder.setDisplayConfigOpButtons(true);
        ioTableBuilder.setDisplayConflicts(true);
        ioTableBuilder.setDisplayDatePatternDifferentWarning(true);
        ioTableBuilder.htmlConfigTablesForInstructionalOffering(this.sessionContext, this.getClassAssignmentService().getAssignment(), this.getExaminationSolverService().getSolver(), ((InstructionalOfferingDetailForm)this.form).getInstrOfferingId(), this.getPageContext().getOut(), this.request.getParameter("backType"), this.request.getParameter("backId"));
        return "";
    }
}

