/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.dom4j.Document;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.SqmQuery;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.BufferedPrinter;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.hql.TestHqlExportToCSV;
import org.unitime.timetable.form.HibernateQueryTestForm;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Action(value="hibernateQueryTest", results={@Result(name={"displayQueryForm"}, type="tiles", location="hibernateQueryTest.tiles")})
@TilesDefinition(name="hibernateQueryTest.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Test HQL"), @TilesPutAttribute(name="body", value="/admin/hibernateQueryTest.jsp")})
public class HibernateQueryTestAction
extends UniTimeAction<HibernateQueryTestForm> {
    private static final long serialVersionUID = 4379704237143143345L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        String url;
        block69: {
            String q;
            this.sessionContext.checkPermission(Right.TestHQL);
            if (this.form == null) {
                this.form = new HibernateQueryTestForm();
            }
            if (this.op == null) {
                return "displayQueryForm";
            }
            if (MSG.actionClearCache().equals(this.op)) {
                HibernateUtil.clearCache();
                return "displayQueryForm";
            }
            if (("Back".equals(this.op) || MSG.actionBackToDetail().equals(this.op)) && (((HibernateQueryTestForm)this.form).getQuery() == null || ((HibernateQueryTestForm)this.form).getQuery().isEmpty()) && (q = (String)this.request.getSession().getAttribute("TestHQL.LastQuery")) != null) {
                ((HibernateQueryTestForm)this.form).setQuery(q);
            }
            ((HibernateQueryTestForm)this.form).validate(this);
            if (MSG.actionNextQueryResults().equals(this.op)) {
                ((HibernateQueryTestForm)this.form).setStart(((HibernateQueryTestForm)this.form).getStart() + ApplicationProperty.TestHQLMaxLines.intValue());
            }
            if (MSG.actionPreviousQueryResults().equals(this.op)) {
                ((HibernateQueryTestForm)this.form).setStart(Math.max(0, ((HibernateQueryTestForm)this.form).getStart() - ApplicationProperty.TestHQLMaxLines.intValue()));
            }
            if (MSG.actionSubmitQuery().equals(this.op)) {
                ((HibernateQueryTestForm)this.form).setStart(0);
            }
            if (MSG.actionExportCsv().equals(this.op) && !this.hasFieldErrors()) {
                String query = ((HibernateQueryTestForm)this.form).getQuery();
                for (SavedHQL.Option o : SavedHQL.Option.values()) {
                    if (query.indexOf("%" + o.name() + "%") < 0) continue;
                    Object value = null;
                    if (value == null || ((String)value).isEmpty()) {
                        Map<Long, String> vals = o.values(this.sessionContext.getUser());
                        if (vals == null || vals.isEmpty()) {
                            this.addFieldError("form.query", MSG.errorCannotSetQueryParameterNoValues(o.name()));
                            return "displayQueryForm";
                        }
                        value = "";
                        for (Long id : vals.keySet()) {
                            if (!((String)value).isEmpty()) {
                                value = (String)value + ",";
                            }
                            value = (String)value + id.toString();
                            if (o.allowMultiSelection()) continue;
                            break;
                        }
                    }
                    query = query.replace("%" + o.name() + "%", "(" + (String)value + ")");
                }
                if (query.indexOf("%USER%") >= 0) {
                    query = query.replace("%USER%", "'" + HibernateUtil.escapeSql(this.sessionContext.getUser().getExternalUserId()) + "'");
                }
                BufferedPrinter out = new BufferedPrinter(new CSVPrinter(this.response.getWriter(), false));
                this.response.setContentType(out.getContentType() + "; charset=UTF-8");
                this.response.setCharacterEncoding("UTF-8");
                this.response.setHeader("Pragma", "no-cache");
                this.response.addHeader("Cache-Control", "must-revalidate");
                this.response.addHeader("Cache-Control", "no-cache");
                this.response.addHeader("Cache-Control", "no-store");
                this.response.setDateHeader("Date", new Date().getTime());
                this.response.setDateHeader("Expires", 0L);
                this.response.setHeader("Content-Disposition", "attachment; filename=\"hql-test.csv\"");
                TestHqlExportToCSV.execute(this.sessionContext.getUser(), out, query, 0, -1);
                out.close();
                return null;
            }
            ((HibernateQueryTestForm)this.form).setExport(false);
            if (!this.hasFieldErrors()) {
                try {
                    int limit = ApplicationProperty.TestHQLMaxLines.intValue();
                    String query = ((HibernateQueryTestForm)this.form).getQuery();
                    for (SavedHQL.Option o : SavedHQL.Option.values()) {
                        if (query.indexOf("%" + o.name() + "%") < 0) continue;
                        Object value = null;
                        if (value == null || ((String)value).isEmpty()) {
                            Map<Long, String> vals = o.values(this.sessionContext.getUser());
                            if (vals == null || vals.isEmpty()) {
                                this.addFieldError("form.query", MSG.errorCannotSetQueryParameterNoValues(o.name()));
                                return "displayQueryForm";
                            }
                            value = "";
                            for (Long id : vals.keySet()) {
                                if (!((String)value).isEmpty()) {
                                    value = (String)value + ",";
                                }
                                value = (String)value + id.toString();
                                if (o.allowMultiSelection()) continue;
                                break;
                            }
                        }
                        query = query.replace("%" + o.name() + "%", "(" + (String)value + ")");
                    }
                    if (query.indexOf("%USER%") >= 0) {
                        query = query.replace("%USER%", "'" + HibernateUtil.escapeSql(this.sessionContext.getUser().getExternalUserId()) + "'");
                    }
                    _RootDAO rdao = new _RootDAO();
                    Session hibSession = rdao.getSession();
                    Query q2 = null;
                    MutationQuery updateQuery = null;
                    try {
                        q2 = hibSession.createQuery(query, Tuple.class);
                    }
                    catch (IllegalArgumentException e) {
                        updateQuery = hibSession.createMutationQuery(query);
                    }
                    try {
                        SqmStatement sqm = null;
                        sqm = updateQuery != null ? ((SqmQuery)updateQuery).getSqmStatement() : ((SqmQuery)q2).getSqmStatement();
                        SessionFactoryImplementor sfi = (SessionFactoryImplementor)hibSession.getSessionFactory();
                        Dialect dialect = sfi.getJdbcServices().getDialect();
                        if (sqm instanceof SqmSelectStatement) {
                            tr = new StandardSqmTranslatorFactory().createSelectTranslator((SqmSelectStatement)sqm, QueryOptions.NONE, DomainParameterXref.from((SqmStatement)sqm), (QueryParameterBindings)QueryParameterBindingsImpl.from((ParameterMetadataImplementor)ParameterMetadataImpl.EMPTY, (SessionFactoryImplementor)sfi), new LoadQueryInfluencers(sfi), (SqlAstCreationContext)hibSession.getSessionFactory(), false).translate();
                            sql = ((JdbcOperationQuerySelect)dialect.getSqlAstTranslatorFactory().buildSelectTranslator(sfi, (SelectStatement)tr.getSqlAst()).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE)).getSqlString();
                            this.request.setAttribute("sql", (Object)sql);
                        } else if (sqm instanceof SqmDeleteStatement) {
                            tr = new StandardSqmTranslatorFactory().createSimpleDeleteTranslator((SqmDeleteStatement)sqm, QueryOptions.NONE, DomainParameterXref.from((SqmStatement)sqm), (QueryParameterBindings)QueryParameterBindingsImpl.from((ParameterMetadataImplementor)ParameterMetadataImpl.EMPTY, (SessionFactoryImplementor)sfi), new LoadQueryInfluencers(sfi), (SqlAstCreationContext)hibSession.getSessionFactory()).translate();
                            sql = ((JdbcOperationQueryMutation)dialect.getSqlAstTranslatorFactory().buildMutationTranslator(sfi, (MutationStatement)((DeleteStatement)tr.getSqlAst())).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE)).getSqlString();
                            this.request.setAttribute("sql", (Object)sql);
                        } else if (sqm instanceof SqmInsertStatement) {
                            tr = new StandardSqmTranslatorFactory().createInsertTranslator((SqmInsertStatement)sqm, QueryOptions.NONE, DomainParameterXref.from((SqmStatement)sqm), (QueryParameterBindings)QueryParameterBindingsImpl.from((ParameterMetadataImplementor)ParameterMetadataImpl.EMPTY, (SessionFactoryImplementor)sfi), new LoadQueryInfluencers(sfi), (SqlAstCreationContext)hibSession.getSessionFactory()).translate();
                            sql = ((JdbcOperationQueryMutation)dialect.getSqlAstTranslatorFactory().buildMutationTranslator(sfi, (MutationStatement)((InsertStatement)tr.getSqlAst())).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE)).getSqlString();
                            this.request.setAttribute("sql", (Object)sql);
                        } else if (sqm instanceof SqmUpdateStatement) {
                            tr = new StandardSqmTranslatorFactory().createSimpleUpdateTranslator((SqmUpdateStatement)sqm, QueryOptions.NONE, DomainParameterXref.from((SqmStatement)sqm), (QueryParameterBindings)QueryParameterBindingsImpl.from((ParameterMetadataImplementor)ParameterMetadataImpl.EMPTY, (SessionFactoryImplementor)sfi), new LoadQueryInfluencers(sfi), (SqlAstCreationContext)hibSession.getSessionFactory()).translate();
                            sql = ((JdbcOperationQueryMutation)dialect.getSqlAstTranslatorFactory().buildMutationTranslator(sfi, (MutationStatement)((UpdateStatement)tr.getSqlAst())).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE)).getSqlString();
                            this.request.setAttribute("sql", (Object)sql);
                        }
                    }
                    catch (Exception e) {
                        Debug.error(e);
                    }
                    if (q2 != null) {
                        q2.setCacheable(true);
                        q2.setFirstResult(((HibernateQueryTestForm)this.form).getStart());
                        if (limit > 0) {
                            q2.setMaxResults(limit + 1);
                        }
                        String idAlias = null;
                        List l = q2.list();
                        ArrayList<Long> ids = new ArrayList<Long>();
                        StringBuffer s = new StringBuffer();
                        Iterator i = l.iterator();
                        for (int line = 0; i.hasNext() && (limit <= 0 || line < limit); ++line) {
                            Tuple o = (Tuple)i.next();
                            if (s.length() == 0) {
                                idAlias = this.printHeader(s, o);
                            }
                            this.printLine(s, o, ids, (SessionImplementor)hibSession);
                        }
                        if (s.length() > 0) {
                            this.printFooter(s);
                            this.request.setAttribute("result", (Object)s.toString());
                        }
                        if (((HibernateQueryTestForm)this.form).getStart() == 0) {
                            if (limit > 0 && l.size() > limit) {
                                ((HibernateQueryTestForm)this.form).setListSize(limit + "+ " + MSG.queryLines());
                            } else {
                                ((HibernateQueryTestForm)this.form).setListSize(l.size() + " " + MSG.queryLines());
                            }
                        } else if (limit > 0 && l.size() > limit) {
                            ((HibernateQueryTestForm)this.form).setListSize(MSG.queryLines() + " " + ((HibernateQueryTestForm)this.form).getStart() + " ... " + (((HibernateQueryTestForm)this.form).getStart() + limit));
                        } else {
                            ((HibernateQueryTestForm)this.form).setListSize(MSG.queryLines() + " " + ((HibernateQueryTestForm)this.form).getStart() + " ... " + (((HibernateQueryTestForm)this.form).getStart() + l.size()));
                        }
                        ((HibernateQueryTestForm)this.form).setExport(!l.isEmpty());
                        ((HibernateQueryTestForm)this.form).setNext(limit > 0 && l.size() > limit);
                        if (idAlias != null) {
                            if ("__Class".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sClassLevel, ids);
                            } else if ("__Offering".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                            } else if ("__Subpart".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sSchedulingSubpartLevel, ids);
                            } else if ("__Room".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                            } else if ("__Instructor".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                            } else if ("__Exam".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                            } else if ("__Event".equals(idAlias)) {
                                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
                            }
                        }
                        break block69;
                    }
                    if (updateQuery == null) break block69;
                    Transaction tx = null;
                    try {
                        tx = hibSession.beginTransaction();
                        int i = updateQuery.executeUpdate();
                        this.request.setAttribute("result", (Object)MSG.queryLinesUpdated(i));
                        ((HibernateQueryTestForm)this.form).setListSize(MSG.queryLinesUpdated(i));
                        tx.commit();
                    }
                    catch (Exception ex) {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                        throw ex;
                    }
                    hibSession.flush();
                    HibernateUtil.clearCache();
                }
                catch (Exception e) {
                    String message = null;
                    for (Throwable f = e; f != null; f = f.getCause()) {
                        SQLException s;
                        if (f instanceof JDBCException && (s = ((JDBCException)f).getSQLException()) != null && s.getMessage() != null && !s.getMessage().isEmpty()) {
                            message = s.getMessage();
                            break;
                        }
                        if (f instanceof HibernateException) {
                            message = f.getMessage();
                        }
                        if (!(f instanceof IllegalArgumentException)) continue;
                        message = f.getMessage();
                    }
                    if (message != null && !message.isEmpty()) {
                        this.addFieldError("form.query", message);
                    } else {
                        this.addFieldError("form.query", e.getMessage());
                    }
                    Debug.error(e);
                }
            }
        }
        if ((url = "hibernateQueryTest.action?form.query=" + URLEncoder.encode(((HibernateQueryTestForm)this.form).getQuery(), "utf-8") + "&form.start=" + ((HibernateQueryTestForm)this.form).getStart() + "&op=Back").length() <= 2000) {
            this.request.getSession().removeAttribute("TestHQL.LastQuery");
            BackTracker.markForBack(this.request, url, "HQL", true, true);
        } else {
            this.request.getSession().setAttribute("TestHQL.LastQuery", (Object)((HibernateQueryTestForm)this.form).getQuery());
            BackTracker.markForBack(this.request, "hibernateQueryTest.action?form.start=" + ((HibernateQueryTestForm)this.form).getStart() + "&op=Back", "HQL", true, true);
        }
        return "displayQueryForm";
    }

    private void header(StringBuffer s, int idx, String text) {
        block4: {
            s.append("<td class='WebTableHeader'><i>");
            if (text == null || text.length() <= 0) {
                s.append("Col " + idx);
            } else {
                try {
                    s.append("Col " + (1 + Integer.parseInt(text)));
                }
                catch (NumberFormatException e) {
                    s.append(text.substring(0, 1).toUpperCase());
                    if (text.length() <= 1) break block4;
                    s.append(text.substring(1).replace('_', ' '));
                }
            }
        }
        s.append("</i></td>");
    }

    private boolean skip(Attribute t) {
        try {
            Class<?> ts = t.getJavaType().getMethod("toString", new Class[0]).getDeclaringClass();
            return ts.equals(Object.class) || ts.getName().startsWith("org.unitime.timetable.model.base.Base");
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    public String printHeader(StringBuffer s, Tuple o) {
        s.append("<table width='100%' border='0' cellspacing='0' cellpadding='3' class='unitime-HQLTable'>");
        s.append("<tr align='left'>");
        boolean hasLink = false;
        Object first = null;
        if (!o.getElements().isEmpty() && ((TupleElement)o.getElements().get(0)).getAlias() != null && ((TupleElement)o.getElements().get(0)).getAlias().startsWith("__") && o.get(0) != null) {
            first = (TupleElement)o.getElements().get(0);
            String alias = first.getAlias();
            if ("__Class".equals(alias)) {
                hasLink = true;
            } else if ("__Offering".equals(alias)) {
                hasLink = true;
            } else if ("__Subpart".equals(alias)) {
                hasLink = true;
            } else if ("__Room".equals(alias)) {
                hasLink = true;
            } else if ("__Instructor".equals(alias)) {
                hasLink = true;
            } else if ("__Exam".equals(alias)) {
                hasLink = true;
            } else if ("__Event".equals(alias)) {
                hasLink = true;
            }
        }
        int idx = 1;
        for (TupleElement te : o.getElements()) {
            if (hasLink && first != null && first.equals(te)) continue;
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (et == null) {
                this.header(s, idx++, te.getAlias());
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (this.skip(sa)) continue;
                this.header(s, idx++, sa.getName());
            }
        }
        s.append("</tr>");
        return hasLink && first != null ? first.getAlias() : null;
    }

    private void line(StringBuffer s, Object text) {
        s.append("<td>");
        if (text != null) {
            if (text instanceof Document) {
                s.append(StringEscapeUtils.escapeHtml4((String)((Document)text).asXML()));
            } else {
                s.append(text.toString());
            }
        }
        s.append("</td>");
    }

    public void printLine(StringBuffer s, Tuple o, List<Long> ids, SessionImplementor session) {
        String link = null;
        TupleElement first = null;
        if (!o.getElements().isEmpty() && ((TupleElement)o.getElements().get(0)).getAlias() != null && ((TupleElement)o.getElements().get(0)).getAlias().startsWith("__") && o.get(0) != null) {
            first = (TupleElement)o.getElements().get(0);
            Object x = o.get(0);
            String alias = first.getAlias();
            if ("__Class".equals(alias)) {
                link = "classDetail.action?cid=" + x;
                ids.add((Long)x);
            } else if ("__Offering".equals(alias)) {
                link = "instructionalOfferingDetail.action?op=view&io=" + x;
                ids.add((Long)x);
            } else if ("__Subpart".equals(alias)) {
                link = "schedulingSubpartDetail.action?ssuid=" + x;
                ids.add((Long)x);
            } else if ("__Room".equals(alias)) {
                link = "gwt.jsp?page=rooms&back=1&id=" + x;
                ids.add((Long)x);
            } else if ("__Instructor".equals(alias)) {
                link = "instructorDetail.action?instructorId=" + x;
                ids.add((Long)x);
            } else if ("__Exam".equals(alias)) {
                link = "examDetail.action?examId=" + x;
                ids.add((Long)x);
            } else if ("__Event".equals(alias)) {
                link = "gwt.jsp?page=events#event=" + x;
                ids.add((Long)x);
            }
        }
        s.append("<tr align='left' onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';\" onmouseout=\"this.style.backgroundColor='transparent';\" " + (String)(link == null ? "" : "onClick=\"document.location='" + link + "';\"") + ">");
        for (TupleElement te : o.getElements()) {
            if (link != null && first != null && first.equals(te)) continue;
            Object x = o.get(te);
            EntityType et = null;
            try {
                et = new _RootDAO().getSession().getMetamodel().entity(te.getJavaType());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (et == null) {
                this.line(s, x);
                continue;
            }
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(new AttributeComparator());
            attributes.addAll(et.getSingularAttributes());
            for (Attribute sa : attributes) {
                if (this.skip(sa)) continue;
                try {
                    this.line(s, ((Method)sa.getJavaMember()).invoke(x, new Object[0]));
                }
                catch (Exception e) {
                    this.line(s, null);
                }
            }
        }
        s.append("</tr>");
    }

    public void printFooter(StringBuffer s) {
        s.append("</table>");
    }

    static class AttributeComparator
    implements Comparator<Attribute> {
        AttributeComparator() {
        }

        @Override
        public int compare(Attribute a1, Attribute a2) {
            boolean id2;
            boolean id1 = a1 instanceof SingularAttribute && ((SingularAttribute)a1).isId();
            boolean bl = id2 = a2 instanceof SingularAttribute && ((SingularAttribute)a2).isId();
            if (id1 != id2) {
                return id1 ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

