/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Action(value="examEdit", results={@Result(name={"showAdd"}, type="tiles", location="examAdd.tiles"), @Result(name={"showEdit"}, type="tiles", location="examEdit.tiles"), @Result(name={"showDetail"}, type="redirect", location="/examDetail.action", params={"examId", "${form.examId}", "op", "${op}"}), @Result(name={"showList"}, type="redirect", location="/examList.action")})
@TilesDefinitions(value={@TilesDefinition(name="examEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Examination"), @TilesPutAttribute(name="body", value="/user/examEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")}), @TilesDefinition(name="examAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Examination"), @TilesPutAttribute(name="body", value="/user/examEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})})
public class ExamEditAction
extends PreferencesAction2<ExamEditForm> {
    private static final long serialVersionUID = -6628177736452722156L;
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static ExaminationMessages EXMSG = Localization.create(ExaminationMessages.class);
    protected String examId = null;
    protected String op2 = null;
    protected String deleteType = null;
    protected Boolean clone = null;
    protected Long deleteId = null;
    protected Long firstId = null;
    protected String firstType = null;

    public String getExamId() {
        return this.examId;
    }

    public void setExamId(String examId) {
        this.examId = examId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(String deleteType) {
        this.deleteType = deleteType;
    }

    public Boolean isClone() {
        return this.clone;
    }

    public void setClone(Boolean clone) {
        this.clone = clone;
    }

    public Long getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(Long deleteId) {
        this.deleteId = deleteId;
    }

    public Long getFirstId() {
        return this.firstId;
    }

    public void setFirstId(Long firstId) {
        this.firstId = firstId;
    }

    public String getFirstType() {
        return this.firstType;
    }

    public void setFirstType(String firstType) {
        this.firstType = firstType;
    }

    @Override
    public String execute() throws Exception {
        int i;
        ExamType type;
        Exam exam;
        if (this.form == null) {
            List<ExamType> types;
            this.form = new ExamEditForm();
            ((ExamEditForm)this.form).reset();
            if (this.request.getSession().getAttribute("Exam.Type") != null) {
                ((ExamEditForm)this.form).setExamType((Long)this.request.getSession().getAttribute("Exam.Type"));
            }
            if (((ExamEditForm)this.form).getExamType() == null && !(types = ExamType.findAllUsedApplicable(this.getSessionContext().getUser(), this.getSessionContext().getUser() != null && this.getSessionContext().getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) ? DepartmentStatusType.Status.ExamTimetable : DepartmentStatusType.Status.ExamEdit)).isEmpty()) {
                ((ExamEditForm)this.form).setExamType(types.get(0).getUniqueId());
            }
        }
        super.execute();
        if (this.op == null) {
            this.op = ((ExamEditForm)this.form).getOp();
        }
        if (this.examId == null && ((ExamEditForm)this.form).getExamId() != null) {
            this.examId = ((ExamEditForm)this.form).getExamId();
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = this.deleteType != null && !this.deleteType.isEmpty() ? "delete" : "init";
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            throw new Exception(EXMSG.errorNoExamId());
        }
        Exam exam2 = exam = this.examId == null || this.examId.trim().isEmpty() ? null : (Exam)ExamDAO.getInstance().get(Long.valueOf(this.examId));
        if (exam != null) {
            this.sessionContext.checkPermission((Serializable)((Object)this.examId), "Exam", Right.ExaminationEdit);
            ((ExamEditForm)this.form).setExamId(exam.getUniqueId().toString());
        } else if (exam == null) {
            this.sessionContext.checkPermission(Right.ExaminationAdd);
            ((ExamEditForm)this.form).setExamId(null);
        }
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        if ("Back".equals(this.op) || EXMSG.actionBatckToDetail().equals(this.op)) {
            if (BackTracker.hasBack(this.request, 1)) {
                BackTracker.doBack(this.request, this.response);
                return null;
            }
            if (this.examId != null && !this.examId.trim().isEmpty()) {
                return "showDetail";
            }
            return "showList";
        }
        if (exam != null && ("Clear Preferences".equals(this.op) || EXMSG.actionClearExamPreferences().equals(this.op))) {
            this.sessionContext.checkPermission(exam, Right.ExaminationEditClearPreferences);
            Set<Preference> s = exam.getPreferences();
            s.clear();
            exam.setPreferences(s);
            ExamDAO.getInstance().getSession().merge((Object)exam);
            ExamDAO.getInstance().getSession().flush();
            this.op = "init";
            ChangeLog.addChange(null, this.sessionContext, exam, ChangeLog.Source.EXAM_EDIT, ChangeLog.Operation.CLEAR_PREF, exam.firstSubjectArea(), exam.firstDepartment());
            return "showDetail";
        }
        if ("init".equals(this.op)) {
            this.doLoad(exam);
            if (Boolean.TRUE.equals(this.clone)) {
                ((ExamEditForm)this.form).setExamId(null);
                ((ExamEditForm)this.form).setClone(true);
            }
        }
        if (ApplicationProperty.ExaminationSizeUseLimitInsteadOfEnrollment.isTrue((type = (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType())).getReference(), type.getType() != 0)) {
            ((ExamEditForm)this.form).setSizeNote("A number of enrolled students or a total limit of selected classes/courses (whichever is bigger) is used when blank");
        } else {
            ((ExamEditForm)this.form).setSizeNote("A number of enrolled students is used when blank");
        }
        ((ExamEditForm)this.form).setLabel(((ExamEditForm)this.form).getClone() || exam == null ? "New Examination" : exam.getLabel());
        if ("Add Instructor".equals(this.op) || EXMSG.actionAddInstructor().equals(this.op)) {
            for (i = 0; i < 2; ++i) {
                ((ExamEditForm)this.form).getInstructors().add("-");
            }
        }
        if ("Add Object".equals(this.op) || EXMSG.actionAddObject().equals(this.op)) {
            for (i = 0; i < 2; ++i) {
                ((ExamEditForm)this.form).addExamOwner(null);
            }
            this.request.setAttribute("hash", (Object)"objects");
        }
        if ("instructor".equals(this.deleteType) && this.deleteId != null) {
            ((ExamEditForm)this.form).getInstructors().remove(this.deleteId.intValue());
        } else if ("examType".equals(this.deleteType) && this.deleteId != null) {
            ((ExamEditForm)this.form).setExamType(this.deleteId);
        } else if ("objects".equals(this.deleteType) && this.deleteId != null) {
            ((ExamEditForm)this.form).deleteExamOwner(this.deleteId.intValue());
        }
        if ("Update".equals(this.op) || EXMSG.actionExamUpdate().equals(this.op) || "Save".equals(this.op) || EXMSG.actionExamSave().equals(this.op) || "Previous".equals(this.op) || EXMSG.actionExamPrevious().equals(this.op) || "Next".equals(this.op) || EXMSG.actionExamNext().equals(this.op)) {
            ((ExamEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doUpdate(exam);
                if ("Next".equals(this.op) || EXMSG.actionExamNext().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("examEdit.action?examId=" + ((ExamEditForm)this.form).getNextId()));
                    return null;
                }
                if ("Previous".equals(this.op) || EXMSG.actionExamPrevious().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("examEdit.action?examId=" + ((ExamEditForm)this.form).getPreviousId()));
                    return null;
                }
                if (("Save".equals(this.op) || EXMSG.actionExamSave().equals(this.op)) && BackTracker.hasBack(this.request, 2) && !((ExamEditForm)this.form).getClone()) {
                    this.request.setAttribute("backType", (Object)"PreferenceGroup");
                    this.request.setAttribute("backId", (Object)((ExamEditForm)this.form).getExamId());
                    BackTracker.doBack(this.request, this.response);
                    return null;
                }
                return "showDetail";
            }
        }
        ((ExamEditForm)this.form).setAvailableTimePatterns(null);
        if ("init".equals(this.op)) {
            this.initPrefs(exam, null, true);
        }
        this.generateExamPeriodGrid(((ExamEditForm)this.form).getClone() ? null : exam, this.op, timeVertical, true);
        this.processPrefAction();
        this.setupInstructors(exam);
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), this.getSessionContext().getUser() != null && this.getSessionContext().getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) ? DepartmentStatusType.Status.ExamTimetable : DepartmentStatusType.Status.ExamEdit);
        if (exam != null) {
            LookupTables.setupRooms(this.request, exam);
            LookupTables.setupBldgs(this.request, exam);
            LookupTables.setupRoomFeatures(this.request, exam);
            LookupTables.setupRoomGroups(this.request, exam);
        } else {
            Exam dummy = new Exam();
            dummy.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            dummy.setExamType((ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType()));
            LookupTables.setupRooms(this.request, dummy);
            LookupTables.setupBldgs(this.request, dummy);
            LookupTables.setupRoomFeatures(this.request, dummy);
            LookupTables.setupRoomGroups(this.request, dummy);
        }
        ((ExamEditForm)this.form).setAllowHardPrefs(this.sessionContext.hasPermission(exam, Right.CanUseHardPeriodPrefs));
        ((ExamEditForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false));
        if (!((ExamEditForm)this.form).getClone() && exam != null) {
            BackTracker.markForBack(this.request, "examDetail.action?examId=" + ((ExamEditForm)this.form).getExamId(), EXMSG.backExam(((ExamEditForm)this.form).getName() == null || ((ExamEditForm)this.form).getName().length() == 0 ? ((ExamEditForm)this.form).getLabel().trim() : ((ExamEditForm)this.form).getName().trim()), true, false);
        }
        return ((ExamEditForm)this.form).getClone() || exam == null ? "showAdd" : "showEdit";
    }

    /*
     * Unable to fully structure code
     */
    protected void doLoad(Exam exam) {
        if (exam != null) {
            ((ExamEditForm)this.form).setExamId(exam.getUniqueId().toString());
            ((ExamEditForm)this.form).setExamType(exam.getExamType().getUniqueId());
            ((ExamEditForm)this.form).setName(exam.generateName().equals(exam.getName()) != false ? null : exam.getName());
            ((ExamEditForm)this.form).setNote(exam.getNote());
            ((ExamEditForm)this.form).setLength(exam.getLength());
            ((ExamEditForm)this.form).setSize(exam.getExamSize() == null ? null : exam.getExamSize().toString());
            ((ExamEditForm)this.form).setPrintOffset(exam.getPrintOffset() == null || exam.getPrintOffset() == 0 ? null : exam.getPrintOffset().toString());
            ((ExamEditForm)this.form).setSeatingType(Exam.getSeatingTypeLabel(exam.getSeatingType()));
            ((ExamEditForm)this.form).setMaxNbrRooms(exam.getMaxNbrRooms());
            ((ExamEditForm)this.form).setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(exam)));
            instructors = new TreeSet<DepartmentalInstructor>(exam.getInstructors());
            for (DepartmentalInstructor instr : instructors) {
                ((ExamEditForm)this.form).getInstructors().add(instr.getUniqueId().toString());
            }
            nextId = Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
            prevId = Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
            ((ExamEditForm)this.form).setPreviousId(prevId == null ? null : prevId.toString());
            ((ExamEditForm)this.form).setNextId(nextId == null ? null : nextId.toString());
            i = new TreeSet<ExamOwner>(exam.getOwners()).iterator();
            while (i.hasNext()) {
                ((ExamEditForm)this.form).addExamOwner(i.next());
            }
        } else {
            try {
                periods = ExamPeriod.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), ((ExamEditForm)this.form).getExamType());
                if (!periods.isEmpty()) {
                    ((ExamEditForm)this.form).setLength(Constants.SLOT_LENGTH_MIN * periods.first().getLength());
                }
                if ((maxRoomsParam = SolverParameterDef.findByNameType("Exams.MaxRooms", SolverParameterGroup.SolverType.EXAM)) == null || maxRoomsParam.getDefault() == null) ** GOTO lbl35
                ((ExamEditForm)this.form).setMaxNbrRooms(Integer.valueOf(maxRoomsParam.getDefault()));
            }
            catch (Exception periods) {
                // empty catch block
            }
        }
lbl35:
        // 4 sources

        if (this.firstId != null && this.firstType != null) {
            if ("Class_".equals(this.firstType)) {
                clazz = (Class_)new Class_DAO().get(this.firstId);
                ((ExamEditForm)this.form).getSubjectArea().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().getUniqueId());
                ((ExamEditForm)this.form).getCourseNbr().add(clazz.getSchedulingSubpart().getControllingCourseOffering().getUniqueId());
                ((ExamEditForm)this.form).getItype().add(clazz.getSchedulingSubpart().getUniqueId());
                ((ExamEditForm)this.form).getClassNumber().add(clazz.getUniqueId());
            } else if ("SchedulingSubpart".equals(this.firstType)) {
                subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(this.firstId);
                config = subpart.getInstrOfferingConfig();
                ((ExamEditForm)this.form).getSubjectArea().add(config.getControllingCourseOffering().getSubjectArea().getUniqueId());
                ((ExamEditForm)this.form).getCourseNbr().add(config.getControllingCourseOffering().getUniqueId());
                ((ExamEditForm)this.form).getItype().add(-config.getUniqueId().longValue());
                ((ExamEditForm)this.form).getClassNumber().add(-1L);
            } else if ("InstrOfferingConfig".equals(this.firstType)) {
                config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(this.firstId);
                ((ExamEditForm)this.form).getSubjectArea().add(config.getControllingCourseOffering().getSubjectArea().getUniqueId());
                ((ExamEditForm)this.form).getCourseNbr().add(config.getControllingCourseOffering().getUniqueId());
                ((ExamEditForm)this.form).getItype().add(-config.getUniqueId().longValue());
                ((ExamEditForm)this.form).getClassNumber().add(-1L);
            } else if ("InstructionalOffering".equals(this.firstType)) {
                offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(this.firstId);
                ((ExamEditForm)this.form).getSubjectArea().add(offering.getControllingCourseOffering().getSubjectArea().getUniqueId());
                ((ExamEditForm)this.form).getCourseNbr().add(offering.getControllingCourseOffering().getUniqueId());
                ((ExamEditForm)this.form).getItype().add(-9223372036854775807L);
                ((ExamEditForm)this.form).getClassNumber().add(-1L);
            } else if ("CourseOffering".equals(this.firstType)) {
                course = (CourseOffering)CourseOfferingDAO.getInstance().get(this.firstId);
                ((ExamEditForm)this.form).getSubjectArea().add(course.getSubjectArea().getUniqueId());
                ((ExamEditForm)this.form).getCourseNbr().add(course.getUniqueId());
                ((ExamEditForm)this.form).getItype().add(-9223372036854775808L);
                ((ExamEditForm)this.form).getClassNumber().add(-1L);
            }
        }
        for (i = 0; i < 2; ++i) {
            ((ExamEditForm)this.form).addExamOwner(null);
            ((ExamEditForm)this.form).getInstructors().add(Constants.BLANK_OPTION_VALUE);
        }
    }

    protected void setupInstructors(Exam exam) throws Exception {
        List<String> instructors = ((ExamEditForm)this.form).getInstructors();
        if (instructors == null || instructors.size() == 0) {
            return;
        }
        HashSet<Long> deptIds = new HashSet<Long>();
        if (exam != null) {
            for (DepartmentalInstructor instr : exam.getInstructors()) {
                deptIds.add(instr.getDepartment().getUniqueId());
            }
            for (ExamOwner own : exam.getOwners()) {
                deptIds.add(own.getCourse().getDepartment().getUniqueId());
            }
        } else {
            for (int i = 0; i < ((ExamEditForm)this.form).getSubjectAreaList().size(); ++i) {
                ExamOwner own;
                own = ((ExamEditForm)this.form).getExamOwner(i);
                if (own == null) continue;
                deptIds.add(own.getCourse().getDepartment().getUniqueId());
            }
            if (deptIds.isEmpty()) {
                for (Department dept : Department.getUserDepartments(this.sessionContext.getUser())) {
                    deptIds.add(dept.getUniqueId());
                }
            }
        }
        Long[] deptsIdsArray = new Long[deptIds.size()];
        int idx = 0;
        Iterator i = deptIds.iterator();
        while (i.hasNext()) {
            deptsIdsArray[idx++] = (Long)i.next();
        }
        LookupTables.setupInstructors(this.request, this.sessionContext, deptsIdsArray);
    }

    protected void doUpdate(Exam exam) throws Exception {
        int oldPrintOffset;
        Set<Preference> s;
        boolean add = false;
        if (exam == null) {
            add = true;
            exam = new Exam();
            exam.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            exam.setExamType((ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType()));
        }
        if ((s = exam.getPreferences()) == null) {
            s = new HashSet<Preference>();
        }
        Iterator<Preference> i = s.iterator();
        while (i.hasNext()) {
            Preference p = i.next();
            if (p instanceof DistributionPref) continue;
            i.remove();
        }
        super.doUpdate(exam, s, false, Preference.Type.PERIOD, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING);
        exam.setNote(((ExamEditForm)this.form).getNote());
        exam.setSeatingType(((ExamEditForm)this.form).getSeatingTypeIdx());
        Integer oldLength = exam.getLength();
        exam.setLength((int)((ExamEditForm)this.form).getLength());
        if (((ExamEditForm)this.form).getSize() == null || ((ExamEditForm)this.form).getSize().length() == 0) {
            exam.setExamSize(null);
        } else {
            exam.setExamSize(Integer.valueOf(((ExamEditForm)this.form).getSize()));
        }
        int n = oldPrintOffset = exam.getPrintOffset() == null ? 0 : exam.getPrintOffset();
        if (((ExamEditForm)this.form).getPrintOffset() == null || ((ExamEditForm)this.form).getPrintOffset().length() == 0) {
            exam.setPrintOffset(null);
        } else {
            exam.setPrintOffset(Integer.valueOf(((ExamEditForm)this.form).getPrintOffset()));
        }
        exam.setMaxNbrRooms((int)((ExamEditForm)this.form).getMaxNbrRooms());
        if (exam.getInstructors() == null) {
            exam.setInstructors(new HashSet<DepartmentalInstructor>());
        }
        Iterator<Object> i2 = exam.getInstructors().iterator();
        while (i2.hasNext()) {
            DepartmentalInstructor instructor = i2.next();
            instructor.getExams().remove(exam);
            i2.remove();
        }
        for (String instructorId : ((ExamEditForm)this.form).getInstructors()) {
            DepartmentalInstructor instructor;
            if (Constants.BLANK_OPTION_VALUE.equals(instructorId) || "-".equals(instructorId) || (instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(instructorId))) == null) continue;
            exam.getInstructors().add(instructor);
            instructor.getExams().add(exam);
        }
        ((ExamEditForm)this.form).setExamOwners(exam);
        if (((ExamEditForm)this.form).getName() == null || ((ExamEditForm)this.form).getName().trim().length() == 0) {
            exam.setName(exam.generateName());
        } else {
            exam.setName(((ExamEditForm)this.form).getName());
        }
        ExamEvent event = exam.getEvent();
        if (event != null) {
            event.setEventName(exam.getName());
            if (!(exam.getAssignedPeriod() == null || exam.getLength().equals(oldLength) && oldPrintOffset == (exam.getPrintOffset() == null ? 0 : exam.getPrintOffset()))) {
                for (Meeting m : event.getMeetings()) {
                    m.setStartOffset(exam.getAssignedPeriod().getExamEventStartOffsetForExam(exam));
                    m.setStopOffset(exam.getAssignedPeriod().getExamEventStopOffsetForExam(exam));
                }
            }
        }
        exam.generateDefaultPreferences(false);
        if (exam.getUniqueId() == null) {
            ExamDAO.getInstance().getSession().persist((Object)exam);
        } else {
            ExamDAO.getInstance().getSession().merge((Object)exam);
        }
        ChangeLog.addChange(null, this.sessionContext, exam, ChangeLog.Source.EXAM_EDIT, add ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, exam.firstSubjectArea(), exam.firstDepartment());
        if (add) {
            ((ExamEditForm)this.form).setExamId(exam.getUniqueId().toString());
        }
    }
}

