/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.CSVFile;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.DatePatternEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.webutil.Navigation;

@Action(value="datePatternEdit", results={@Result(name={"list"}, type="tiles", location="datePatternList.tiles"), @Result(name={"add"}, type="tiles", location="datePatternAdd.tiles"), @Result(name={"edit"}, type="tiles", location="datePatternEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="datePatternList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Date Patterns"), @TilesPutAttribute(name="body", value="/admin/datePatterns.jsp")}), @TilesDefinition(name="datePatternAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Date Pattern"), @TilesPutAttribute(name="body", value="/admin/datePatterns.jsp")}), @TilesDefinition(name="datePatternEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Date Pattern"), @TilesPutAttribute(name="body", value="/admin/datePatterns.jsp")})})
public class DatePatternEditAction
extends UniTimeAction<DatePatternEditForm> {
    private static final long serialVersionUID = -9049668741172580381L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private Long id;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private int diff(Set x, Set y) {
        int diff = 0;
        for (Object o : x) {
            if (y.contains(o)) continue;
            ++diff;
        }
        for (Object o : y) {
            if (x.contains(o)) continue;
            ++diff;
        }
        return diff;
    }

    public String execute() throws Exception {
        AbstractCollection allClasses;
        List subparts;
        SequencedCollection<DatePattern> allDatePatterns;
        File file;
        Session hibSession;
        PrintWriter out;
        DatePattern dp;
        Session hibSession2;
        Transaction tx;
        if (this.form == null) {
            this.form = new DatePatternEditForm();
        }
        this.sessionContext.checkPermission(Right.DatePatterns);
        if (this.op == null) {
            this.op = ((DatePatternEditForm)this.form).getOp();
        }
        if (this.op == null) {
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setOp("List");
        }
        this.request.setAttribute(DatePattern.DATE_PATTERN_PARENT_LIST_ATTR, DatePattern.findAllParents(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        this.request.setAttribute(DatePattern.DATE_PATTERN_CHILDREN_LIST_ATTR, DatePattern.findAllChildren(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        List list = DepartmentDAO.getInstance().getSession().createQuery("from Department where session.uniqueId = :sessionId order by deptCode", Department.class).setParameter("sessionId", (Object)this.sessionContext.getUser().getCurrentAcademicSessionId()).list();
        ArrayList<IdValue> availableDepts = new ArrayList<IdValue>();
        for (Department d : list) {
            availableDepts.add(new IdValue(d.getUniqueId(), d.getLabel()));
        }
        this.request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
        if (MSG.actionBackToDatePatterns().equals(this.op)) {
            if (((DatePatternEditForm)this.form).getUniqueId() != null) {
                this.request.setAttribute("hash", (Object)((DatePatternEditForm)this.form).getUniqueId());
            }
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setOp("List");
        }
        if (MSG.actionAddDatePattern().equals(this.op) && ((DatePatternEditForm)this.form).getChildId() == null) {
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
            ((DatePatternEditForm)this.form).setOp(MSG.actionSaveDatePattern());
        }
        if (MSG.actionAddDepartment().equals(this.op)) {
            if (((DatePatternEditForm)this.form).getDepartmentId() == null || ((DatePatternEditForm)this.form).getDepartmentId() < 0L) {
                this.addFieldError("form.department", MSG.errorNoDepartmentSelected());
            } else {
                boolean contains = ((DatePatternEditForm)this.form).getDepartmentIds().contains(((DatePatternEditForm)this.form).getDepartmentId());
                if (contains) {
                    this.addFieldError("form.department", MSG.errorDepartmentAlreadyListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).getDepartmentIds().add(((DatePatternEditForm)this.form).getDepartmentId());
            }
            ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
        }
        if (MSG.actionAddAltPatternSet().equals(this.op)) {
            if (((DatePatternEditForm)this.form).getParentId() == null || ((DatePatternEditForm)this.form).getParentId() < 0L) {
                this.addFieldError("form.parent", MSG.errorNoDatePatternSelected());
            } else {
                boolean contains = ((DatePatternEditForm)this.form).getParentIds().contains(((DatePatternEditForm)this.form).getParentId());
                if (contains) {
                    this.addFieldError("form.parent", MSG.errorDatePatternAlreadyListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).getParentIds().add(((DatePatternEditForm)this.form).getParentId());
            }
            ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
        }
        if (MSG.actionRemoveDepartment().equals(this.op)) {
            if (((DatePatternEditForm)this.form).getDepartmentId() == null || ((DatePatternEditForm)this.form).getDepartmentId() < 0L) {
                this.addFieldError("form.department", MSG.errorNoDepartmentSelected());
            } else {
                boolean contains = ((DatePatternEditForm)this.form).getDepartmentIds().contains(((DatePatternEditForm)this.form).getDepartmentId());
                if (!contains) {
                    this.addFieldError("form.department", MSG.errorDepartmentNotListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).getDepartmentIds().remove(((DatePatternEditForm)this.form).getDepartmentId());
            }
            ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
        }
        if (MSG.actionRemovePatternSet().equals(this.op)) {
            if (((DatePatternEditForm)this.form).getParentId() == null || ((DatePatternEditForm)this.form).getParentId() < 0L) {
                this.addFieldError("form.parent", MSG.errorNoDatePatternSelected());
            } else {
                boolean contains = ((DatePatternEditForm)this.form).getParentIds().contains(((DatePatternEditForm)this.form).getParentId());
                if (!contains) {
                    this.addFieldError("form.parent", MSG.errorDatePatternNotListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).getParentIds().remove(((DatePatternEditForm)this.form).getParentId());
            }
            ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
        }
        if (MSG.actionAddDatePattern().equals(this.op) && ((DatePatternEditForm)this.form).getChildId() != null) {
            if (((DatePatternEditForm)this.form).getChildId() == null || ((DatePatternEditForm)this.form).getChildId() < 0L) {
                this.addFieldError("form.child", MSG.errorNoDatePatternSelected());
            } else {
                boolean contains = ((DatePatternEditForm)this.form).getChildrenIds().contains(((DatePatternEditForm)this.form).getChildId());
                if (contains) {
                    this.addFieldError("form.child", MSG.errorDatePatternAlreadyListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).getChildrenIds().add(((DatePatternEditForm)this.form).getChildId());
            }
            ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
        }
        if (MSG.actionRemoveDatePattern().equals(this.op)) {
            if (((DatePatternEditForm)this.form).getChildId() == null || ((DatePatternEditForm)this.form).getChildId() < 0L) {
                this.addFieldError("form.child", MSG.errorNoDatePatternSelected());
            } else {
                boolean contains = ((DatePatternEditForm)this.form).getChildrenIds().contains(((DatePatternEditForm)this.form).getChildId());
                if (!contains) {
                    this.addFieldError("form.child", MSG.errorDatePatternNotListed());
                }
            }
            if (!this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).getChildrenIds().remove(((DatePatternEditForm)this.form).getChildId());
            }
            ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
        }
        if (MSG.actionUpdateDatePattern().equals(this.op) || MSG.actionSaveDatePattern().equals(this.op) || MSG.actionMakeDatePatternDefaulf().equals(this.op) || MSG.actionPreviousDatePattern().equals(this.op) || MSG.actionNextDatePattern().equals(this.op)) {
            ((DatePatternEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                ((DatePatternEditForm)this.form).setOp(((DatePatternEditForm)this.form).getUniqueId() < 0L ? MSG.actionSaveDatePattern() : MSG.actionUpdateDatePattern());
            } else {
                tx = null;
                try {
                    hibSession2 = DatePatternDAO.getInstance().getSession();
                    if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                        tx = hibSession2.beginTransaction();
                    }
                    dp = ((DatePatternEditForm)this.form).saveOrUpdate(this.request, hibSession2);
                    if (MSG.actionMakeDatePatternDefaulf().equals(this.op)) {
                        dp.getSession().setDefaultDatePattern(dp);
                        hibSession2.merge((Object)dp.getSession());
                        ((DatePatternEditForm)this.form).setIsDefault(true);
                    }
                    ChangeLog.addChange(hibSession2, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, MSG.actionSaveDatePattern().equals(this.op) ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, null);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                if (MSG.actionNextDatePattern().equals(this.op) && ((DatePatternEditForm)this.form).getNextId() != null) {
                    this.response.sendRedirect(this.response.encodeURL("datePatternEdit.action?op=Edit&id=" + ((DatePatternEditForm)this.form).getNextId()));
                } else if (MSG.actionPreviousDatePattern().equals(this.op) && ((DatePatternEditForm)this.form).getPreviousId() != null) {
                    this.response.sendRedirect(this.response.encodeURL("datePatternEdit.action?op=Edit&id=" + ((DatePatternEditForm)this.form).getPreviousId()));
                } else {
                    ((DatePatternEditForm)this.form).setOp("List");
                    if (((DatePatternEditForm)this.form).getUniqueId() != null) {
                        this.request.setAttribute("hash", (Object)((DatePatternEditForm)this.form).getUniqueId());
                    }
                }
            }
        }
        if ("Edit".equals(this.op)) {
            if (this.id == null && ((DatePatternEditForm)this.form).getUniqueId() != null) {
                this.id = ((DatePatternEditForm)this.form).getUniqueId();
            }
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField("Id"));
                this.request.setAttribute("pattern", (Object)((DatePatternEditForm)this.form).getDatePattern(this.request).getPatternHtml(true, ((DatePatternEditForm)this.form).getUniqueId()));
                return "list";
            }
            DatePattern pattern = (DatePattern)DatePatternDAO.getInstance().get(Long.valueOf(this.id));
            ((DatePatternEditForm)this.form).setPreviousId(Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, (long)this.id));
            ((DatePatternEditForm)this.form).setNextId(Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, (long)this.id));
            if (pattern == null) {
                this.addFieldError("form.uniqueId", MSG.errorDoesNotExists(MSG.columnDatePattern()));
                this.request.setAttribute("pattern", (Object)((DatePatternEditForm)this.form).getDatePattern(this.request).getPatternHtml(true, ((DatePatternEditForm)this.form).getUniqueId()));
                return "list";
            }
            ((DatePatternEditForm)this.form).load(pattern);
        }
        if (MSG.actionDeleteDatePattern().equals(this.op)) {
            tx = null;
            try {
                hibSession2 = DatePatternDAO.getInstance().getSession();
                if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                    tx = hibSession2.beginTransaction();
                }
                dp = (DatePattern)DatePatternDAO.getInstance().get(((DatePatternEditForm)this.form).getUniqueId(), hibSession2);
                ChangeLog.addChange(hibSession2, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
                ((DatePatternEditForm)this.form).delete(hibSession2);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setOp("List");
        }
        if ("Fix Generated".equals(this.op)) {
            tx = null;
            out = null;
            try {
                hibSession = DatePatternDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                file = ApplicationProperties.getTempFile("fix", "txt");
                out = new PrintWriter(new FileWriter(file));
                allDatePatterns = DatePattern.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), true, null, null);
                for (DatePattern dp2 : allDatePatterns) {
                    if (!dp2.getName().startsWith("generated")) continue;
                    out.println("Checking " + dp2.getName() + " ...");
                    List classes = hibSession.createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId", Class_.class).setParameter("uniqueId", (Object)dp2.getUniqueId()).list();
                    subparts = hibSession.createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId", SchedulingSubpart.class).setParameter("uniqueId", (Object)dp2.getUniqueId()).list();
                    allClasses = new Vector<Class_>(classes);
                    for (SchedulingSubpart s : subparts) {
                        for (Class_ c : s.getClasses()) {
                            if (c.getDatePattern() != null) continue;
                            ((Vector)allClasses).add((Class_)c);
                        }
                    }
                    if (((Vector)allClasses).isEmpty()) {
                        out.println("  -- date pattern is not used -> delete");
                        for (Department d : dp2.getDepartments()) {
                            d.getDatePatterns().remove(dp2);
                            hibSession.merge((Object)d);
                        }
                        ChangeLog.addChange(hibSession, this.sessionContext, dp2, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
                        hibSession.remove((Object)dp2);
                        continue;
                    }
                    for (Class_ clazz : allClasses) {
                        out.println("  -- used by " + clazz.getClassLabel());
                    }
                    TreeSet<Integer> days = dp2.getUsage(allClasses);
                    out.println("    -- " + days);
                    if (days.isEmpty()) {
                        int offset = dp2.getPatternOffset();
                        for (int x = 0; x < dp2.getPattern().length(); ++x) {
                            if (dp2.getPattern().charAt(x) != '1') continue;
                            days.add(x + offset);
                        }
                    }
                    BaseDatePattern likeDp = null;
                    int likeDiff = 0;
                    for (DatePattern xdp : allDatePatterns) {
                        if (xdp.getName().startsWith("generated")) continue;
                        TreeSet<Integer> xdays = xdp.getUsage(allClasses);
                        if (xdays.isEmpty()) {
                            int offset = xdp.getPatternOffset();
                            for (int x = 0; x < xdp.getPattern().length(); ++x) {
                                if (xdp.getPattern().charAt(x) != '1') continue;
                                xdays.add(x + offset);
                            }
                        }
                        int diff = this.diff(days, xdays);
                        if (likeDp != null && likeDiff <= diff && (likeDiff != diff || !xdp.isDefault())) continue;
                        likeDp = xdp;
                        likeDiff = diff;
                    }
                    if (likeDp == null) continue;
                    if (likeDiff <= 5) {
                        out.println("      -- like " + likeDp.getName() + ", diff=" + likeDiff);
                        out.println("      -- " + ((DatePattern)likeDp).getUsage(allClasses));
                        out.println("    -- transfering all classes and subparts from " + dp2.getName() + " to " + likeDp.getName());
                        for (Class_ clazz : classes) {
                            clazz.setDatePattern((DatePattern)(((DatePattern)likeDp).isDefault() ? null : likeDp));
                            hibSession.merge((Object)clazz);
                        }
                        for (SchedulingSubpart subpart : subparts) {
                            subpart.setDatePattern((DatePattern)(((DatePattern)likeDp).isDefault() ? null : likeDp));
                            hibSession.merge((Object)subpart);
                        }
                        out.println("    -- deleting date pattern " + dp2.getName());
                        for (Department d : dp2.getDepartments()) {
                            d.getDatePatterns().remove(dp2);
                            hibSession.merge((Object)d);
                        }
                        ChangeLog.addChange(hibSession, this.sessionContext, dp2, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
                        hibSession.remove((Object)dp2);
                        continue;
                    }
                    out.println("      -- like " + likeDp.getName() + ", diff=" + likeDiff);
                    out.println("      -- " + ((DatePattern)likeDp).getUsage(allClasses));
                    Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                    dp2.setName("generated " + sdf.format(dp2.getStartDate()) + " - " + sdf.format(dp2.getEndDate()));
                    hibSession.merge((Object)dp2);
                }
                out.flush();
                out.close();
                out = null;
                this.request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setOp("List");
        }
        if ("Generate SQL".equals(this.op)) {
            try (PrintWriter out2 = ExportUtils.getPlainTextWriter(this.response, "tp.sql");){
                TreeSet<DatePattern> patterns = new TreeSet<DatePattern>(DatePattern.findAll(this.sessionContext.getUser(), null, null));
                boolean mysql = false;
                int line = 0;
                if (mysql) {
                    out2.println("INSERT INTO `timetable`.`date_pattern`(`uniqueid`, `name`, `pattern`, `offset`, `type`, `visible`, `session_id`)");
                } else {
                    out2.println("prompt Loading DATE_PATTERN...");
                }
                for (DatePattern dp3 : patterns) {
                    if (dp3.isExtended() || !dp3.isVisible().booleanValue()) continue;
                    if (mysql) {
                        if (line == 0) {
                            out2.print("VALUES");
                        } else {
                            out2.println(",");
                        }
                        out2.print(" (" + dp3.getUniqueId() + ", '" + dp3.getName() + "', '" + dp3.getPattern() + "', " + dp3.getOffset() + ", " + dp3.getType() + ", " + (dp3.isVisible() != false ? "1" : "0") + ", " + this.sessionContext.getUser().getCurrentAcademicSessionId() + ")");
                    } else {
                        out2.println("insert into DATE_PATTERN (UNIQUEID, NAME, PATTERN, OFFSET, TYPE, VISIBLE, SESSION_ID)");
                        out2.println("values (" + dp3.getUniqueId() + ", '" + dp3.getName() + "', '" + dp3.getPattern() + "', " + dp3.getOffset() + ", " + dp3.getType() + ", " + (dp3.isVisible() != false ? "1" : "0") + ", " + this.sessionContext.getUser().getCurrentAcademicSessionId() + ");");
                    }
                    ++line;
                }
                if (mysql) {
                    out2.println(";");
                } else {
                    out2.println("commit;");
                    out2.println("prompt " + line + " records loaded");
                }
                out2.println();
                out2.flush();
                out2.close();
                out2 = null;
            }
            return null;
        }
        if (MSG.actionPushUpDatePatterns().equals(this.op)) {
            tx = null;
            out = null;
            try {
                hibSession = DatePatternDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                file = ApplicationProperties.getTempFile("push", "txt");
                out = new PrintWriter(new FileWriter(file));
                List subparts2 = hibSession.createQuery("select distinct c.schedulingSubpart from Class_ as c inner join c.datePattern as dp where dp.session.uniqueId=:sessionId", SchedulingSubpart.class).setParameter("sessionId", (Object)this.sessionContext.getUser().getCurrentAcademicSessionId()).list();
                for (SchedulingSubpart subpart : subparts2) {
                    out.println("Checking " + subpart.getSchedulingSubpartLabel() + " ...");
                    boolean sameDatePattern = true;
                    BaseDatePattern dp4 = null;
                    for (Class_ clazz : subpart.getClasses()) {
                        if (clazz.getDatePattern() == null) {
                            sameDatePattern = false;
                            break;
                        }
                        if (dp4 == null) {
                            dp4 = clazz.getDatePattern();
                            continue;
                        }
                        if (dp4.equals(clazz.getDatePattern())) continue;
                        sameDatePattern = false;
                        break;
                    }
                    if (!sameDatePattern) continue;
                    out.println("  -- all classes share same date pattern " + dp4.getName() + " --> pushing it to subpart");
                    for (Class_ clazz : subpart.getClasses()) {
                        clazz.setDatePattern(null);
                        hibSession.merge((Object)clazz);
                    }
                    subpart.setDatePattern((DatePattern)(((DatePattern)dp4).isDefault() ? null : dp4));
                    hibSession.merge((Object)subpart);
                }
                out.flush();
                out.close();
                out = null;
                this.request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setOp("List");
        }
        if (MSG.actionAssingDepartmentsToDatePatterns().equals(this.op)) {
            tx = null;
            out = null;
            HashSet<DatePattern> refresh = new HashSet<DatePattern>();
            try {
                Session hibSession3 = DatePatternDAO.getInstance().getSession();
                if (hibSession3.getTransaction() == null || !hibSession3.getTransaction().isActive()) {
                    tx = hibSession3.beginTransaction();
                }
                File file2 = ApplicationProperties.getTempFile("assigndept", "txt");
                out = new PrintWriter(new FileWriter(file2));
                TreeSet<DatePattern> allDatePatterns2 = new TreeSet<DatePattern>(DatePattern.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), true, null, null));
                for (DatePattern dp5 : allDatePatterns2) {
                    if (!dp5.isExtended()) continue;
                    out.println("Checking " + dp5.getName() + " ...");
                    List classes = hibSession3.createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId", Class_.class).setParameter("uniqueId", (Object)dp5.getUniqueId()).list();
                    List subparts3 = hibSession3.createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId", SchedulingSubpart.class).setParameter("uniqueId", (Object)dp5.getUniqueId()).list();
                    HashSet<Department> depts = new HashSet<Department>();
                    for (Class_ c : classes) {
                        depts.add(c.getManagingDept());
                    }
                    for (SchedulingSubpart s : subparts3) {
                        depts.add(s.getManagingDept());
                    }
                    out.println("  -- departments: " + depts);
                    boolean added = false;
                    for (Department d : depts) {
                        if (d.isExternalManager().booleanValue() || dp5.getDepartments().contains(d)) continue;
                        dp5.getDepartments().add(d);
                        d.getDatePatterns().add(dp5);
                        hibSession3.merge((Object)d);
                        out.println("    -- department " + d + " added to " + dp5.getName());
                        added = true;
                    }
                    if (!added) continue;
                    hibSession3.merge((Object)dp5);
                    ChangeLog.addChange(hibSession3, this.sessionContext, dp5, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.UPDATE, null, null);
                    refresh.add(dp5);
                }
                out.flush();
                out.close();
                out = null;
                this.request.setAttribute("RqOpenUrl", (Object)("temp/" + file2.getName()));
                if (tx != null) {
                    tx.commit();
                }
                Iterator<DatePattern> i = refresh.iterator();
                while (i.hasNext()) {
                    hibSession3.refresh((Object)i.next());
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            ((DatePatternEditForm)this.form).load(null);
            ((DatePatternEditForm)this.form).setOp("List");
        }
        if (MSG.actionExportCsv().equals(this.op)) {
            tx = null;
            try {
                hibSession2 = DatePatternDAO.getInstance().getSession();
                if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                    tx = hibSession2.beginTransaction();
                }
                CSVFile csv = new CSVFile();
                csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)MSG.columnDatePatternName()), new CSVFile.CSVField((Object)MSG.columnDatePatternType()), new CSVFile.CSVField((Object)MSG.columnDatePatternNbrDays()), new CSVFile.CSVField((Object)MSG.columnDatePatternFrom()), new CSVFile.CSVField((Object)MSG.columnDatePatternTo()), new CSVFile.CSVField((Object)MSG.columnDatePatternDates()), new CSVFile.CSVField((Object)MSG.columnDatePatternParent()), new CSVFile.CSVField((Object)MSG.columnDatePatternDepartments()), new CSVFile.CSVField((Object)MSG.columnDatePatternClasses())});
                Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                allDatePatterns = new TreeSet<DatePattern>(DatePattern.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), true, null, null));
                for (DatePattern dp2 : allDatePatterns) {
                    List classes = hibSession2.createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId", Class_.class).setParameter("uniqueId", (Object)dp2.getUniqueId()).list();
                    subparts = hibSession2.createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId", SchedulingSubpart.class).setParameter("uniqueId", (Object)dp2.getUniqueId()).list();
                    allClasses = new TreeSet<Class_>(new ClassComparator(5));
                    ((TreeSet)allClasses).addAll(classes);
                    for (SchedulingSubpart s : subparts) {
                        for (Class_ c : s.getClasses()) {
                            if (c.getDatePattern() != null) continue;
                            ((TreeSet)allClasses).add(c);
                        }
                    }
                    Object deptStr = "";
                    TreeSet<Department> depts = new TreeSet<Department>(dp2.getDepartments());
                    Iterator<Department> j = depts.iterator();
                    while (j.hasNext()) {
                        Department d;
                        d = j.next();
                        deptStr = (String)deptStr + d.getShortLabel().trim();
                        if (!j.hasNext()) continue;
                        deptStr = (String)deptStr + ", ";
                    }
                    Object classStr = "";
                    Iterator<Comparable<DatePattern>> j2 = ((TreeSet)allClasses).iterator();
                    while (j2.hasNext()) {
                        Class_ clazz;
                        clazz = (Class_)((Object)j2.next());
                        classStr = (String)classStr + clazz.getClassLabel();
                        if (!j2.hasNext()) continue;
                        classStr = (String)classStr + ", ";
                    }
                    Object datePattStr = "";
                    Iterator<DatePattern> j3 = dp2.getParents().iterator();
                    while (j3.hasNext()) {
                        DatePattern d = j3.next();
                        datePattStr = (String)datePattStr + d.getName();
                        if (!j3.hasNext()) continue;
                        datePattStr = (String)datePattStr + ", ";
                    }
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)dp2.getName()), new CSVFile.CSVField((Object)dp2.getDatePatternType().getLabel()), new CSVFile.CSVField((Object)String.valueOf(dp2.size())), new CSVFile.CSVField((Object)sdf.format(dp2.getStartDate())), new CSVFile.CSVField((Object)sdf.format(dp2.getEndDate())), new CSVFile.CSVField((Object)dp2.getPatternString()), new CSVFile.CSVField(datePattStr), new CSVFile.CSVField(deptStr), new CSVFile.CSVField(classStr)});
                }
                ExportUtils.exportCSV(csv, this.response, "datePatterns");
                if (tx != null) {
                    tx.commit();
                }
                return null;
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        if ("List".equals(((DatePatternEditForm)this.form).getOp())) {
            this.getDatePatterns(this.request);
            return "list";
        }
        this.request.setAttribute("pattern", (Object)((DatePatternEditForm)this.form).getDatePattern(this.request).getPatternHtml(true, ((DatePatternEditForm)this.form).getUniqueId()));
        return ((DatePatternEditForm)this.form).getUniqueId() < 0L ? "add" : "edit";
    }

    private void getDatePatterns(HttpServletRequest request) throws Exception {
        Set<DatePattern> used = DatePattern.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
        boolean hasSet = !DatePattern.findAllParents(this.sessionContext.getUser().getCurrentAcademicSessionId()).isEmpty();
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        WebTable.setOrder(this.sessionContext, "datePatterns.ord", request.getParameter("ord"), 1);
        WebTable webTable = hasSet ? new WebTable(7, null, "datePatternEdit.action?ord=%%", new String[]{MSG.columnDatePatternName(), MSG.columnDatePatternType(), MSG.columnDatePatternUsed(), MSG.columnDatePatternWeeks(), MSG.columnDatePatternDatesOrPatterns(), MSG.columnDatePatternPatternSets(), MSG.columnDatePatternDepartments()}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, null) : new WebTable(6, null, "datePatternEdit.action?ord=%%", new String[]{MSG.columnDatePatternName(), MSG.columnDatePatternType(), MSG.columnDatePatternUsed(), MSG.columnDatePatternWeeks(), MSG.columnDatePatternDates(), MSG.columnDatePatternDepartments()}, new String[]{"left", "left", "left", "left", "left", "left"}, null);
        List<DatePattern> patterns = DatePattern.findAll(this.sessionContext.getUser(), null, null);
        if (patterns.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.errorNoDatePatterns()}, null, null);
        }
        DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
        for (DatePattern pattern : patterns) {
            boolean isUsed;
            String onClick = "onClick=\"document.location='datePatternEdit.action?op=Edit&id=" + pattern.getUniqueId() + "';\"";
            Object deptStr = "";
            Object deptCmp = "";
            TreeSet<Department> depts = new TreeSet<Department>(pattern.getDepartments());
            Iterator<Department> i = depts.iterator();
            while (i.hasNext()) {
                Department d = i.next();
                deptStr = (String)deptStr + d.getManagingDeptAbbv().trim();
                deptCmp = (String)deptCmp + d.getDeptCode();
                if (!i.hasNext()) continue;
                deptStr = (String)deptStr + ", ";
                deptCmp = (String)deptCmp + ",";
            }
            Object datePatternStr = "";
            ArrayList<DatePattern> dps = new ArrayList<DatePattern>(pattern.getParents());
            Collections.sort(dps);
            Iterator i2 = dps.iterator();
            while (i2.hasNext()) {
                DatePattern d = (DatePattern)i2.next();
                datePatternStr = (String)datePatternStr + d.getName();
                if (!i2.hasNext()) continue;
                datePatternStr = (String)datePatternStr + ", ";
            }
            Object pattStr = pattern.getPatternString();
            if (pattern.getName().startsWith("generated")) {
                int first = pattern.getPattern().indexOf(49) - pattern.getOffset();
                int last = pattern.getPattern().lastIndexOf(49) - pattern.getOffset();
                BaseDatePattern likeDp = null;
                int likeDiff = 0;
                for (DatePattern xdp : patterns) {
                    if (xdp.getName().startsWith("generated")) continue;
                    int xfirst = xdp.getPattern().indexOf(49) - xdp.getOffset();
                    int xlast = xdp.getPattern().lastIndexOf(49) - xdp.getOffset();
                    int diff = Math.abs(first - xfirst) + Math.abs(last - xlast);
                    if (likeDp != null && likeDiff <= diff && (likeDiff != diff || !xdp.isDefault())) continue;
                    likeDp = xdp;
                    likeDiff = diff;
                }
                if (likeDp != null) {
                    int xfirst = likeDp.getPattern().indexOf(49) - likeDp.getOffset();
                    int xlast = likeDp.getPattern().lastIndexOf(49) - likeDp.getOffset();
                    int firstDiff = first - xfirst;
                    int lastDiff = last - xlast;
                    if (Math.abs(lastDiff) > 3 || Math.abs(firstDiff) > 3) {
                        pattStr = (String)pattStr + "<b>";
                    }
                    pattStr = (String)pattStr + "<br>Similar to " + likeDp.getName() + " (offset " + firstDiff + " and " + lastDiff + " days)";
                    pattStr = (String)pattStr + "<br>" + sdf.format(pattern.getStartDate()) + "-" + sdf.format(pattern.getEndDate()) + " versus " + sdf.format(((DatePattern)likeDp).getStartDate()) + "-" + sdf.format(((DatePattern)likeDp).getEndDate());
                    if (Math.abs(lastDiff) > 3 || Math.abs(firstDiff) > 3) {
                        pattStr = (String)pattStr + "</b>";
                    }
                }
            }
            if (pattern.isPatternSet()) {
                for (DatePattern child : new TreeSet<DatePattern>(pattern.findChildren())) {
                    pattStr = (String)pattStr + (((String)pattStr).isEmpty() ? "" : ", ") + child.getName();
                }
            }
            Object nbrWeeks = null;
            nbrWeeks = pattern.getNumberOfWeeks() == null ? "<i>" + df.format(pattern.getComputedNumberOfWeeks()) + "</i>" : df.format(pattern.getNumberOfWeeks());
            boolean bl = isUsed = used.contains(pattern) || pattern.isDefault();
            if (hasSet) {
                webTable.addLine(onClick, new String[]{(pattern.isDefault() ? "<B>" : "") + (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getName().replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>") + (pattern.isDefault() ? "</B>" : ""), (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getDatePatternType().getLabel().replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>"), isUsed ? "<IMG border='0' title='" + MSG.infoDatePatternUsed() + "' alt='Default' align='absmiddle' src='images/accept.png'>" : "", (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)nbrWeeks + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)pattStr + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)datePatternStr + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)deptStr + (pattern.isVisible() != false ? "" : "</font>")}, new Comparable[]{pattern.getName(), pattern.getType(), isUsed ? "0" : "1", Float.valueOf(pattern.getEffectiveNumberOfWeeks()), pattStr, datePatternStr, deptCmp}, pattern.getUniqueId().toString());
                continue;
            }
            webTable.addLine(onClick, new String[]{(pattern.isDefault() ? "<B>" : "") + (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getName().replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>") + (pattern.isDefault() ? "</B>" : ""), (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattern.getDatePatternType().getLabel().replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>"), isUsed ? "<IMG border='0' title='" + MSG.infoDatePatternUsed() + "' alt='Default' align='absmiddle' src='images/accept.png'>" : "", (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)nbrWeeks + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)pattStr + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + (String)deptStr + (pattern.isVisible() != false ? "" : "</font>")}, new Comparable[]{pattern.getName(), pattern.getType(), isUsed ? "0" : "1", Float.valueOf(pattern.getEffectiveNumberOfWeeks()), pattStr, deptCmp}, pattern.getUniqueId().toString());
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "datePatterns.ord")));
        ArrayList<Long> ids = new ArrayList<Long>();
        Enumeration e = webTable.getLines().elements();
        while (e.hasMoreElements()) {
            WebTable.WebTableLine line = (WebTable.WebTableLine)e.nextElement();
            if (line.getUniqueId() == null) continue;
            ids.add(Long.parseLong(line.getUniqueId()));
        }
        Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
    }

    public boolean isShowMakeDefault() {
        return ApplicationProperty.DatePatternShowMakeDefault.isTrue();
    }
}

